/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.entitymanager.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.CachedDbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.DbEntityCacheKeyMapping;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.DbEntityState;

public class DbEntityCache {
    protected Map<Class<?>, Map<String, CachedDbEntity>> cachedEntites = new HashMap();
    protected DbEntityCacheKeyMapping cacheKeyMapping;

    public DbEntityCache() {
        this.cacheKeyMapping = DbEntityCacheKeyMapping.emptyMapping();
    }

    public DbEntityCache(DbEntityCacheKeyMapping cacheKeyMapping) {
        this.cacheKeyMapping = cacheKeyMapping;
    }

    public <T extends DbEntity> T get(Class<T> type, String id) {
        Class<?> cacheKey = this.cacheKeyMapping.getEntityCacheKey(type);
        CachedDbEntity cachedDbEntity = this.getCachedEntity(cacheKey, id);
        if (cachedDbEntity != null) {
            DbEntity dbEntity = cachedDbEntity.getEntity();
            try {
                return (T)dbEntity;
            }
            catch (ClassCastException e) {
                throw new ProcessEngineException("Could not lookup entity of type '" + type + "' and id '" + id + "': found entity of type '" + dbEntity.getClass() + "'.", e);
            }
        }
        return null;
    }

    public <T extends DbEntity> List<T> getEntitiesByType(Class<T> type) {
        Class<?> cacheKey = this.cacheKeyMapping.getEntityCacheKey(type);
        Map<String, CachedDbEntity> entities = this.cachedEntites.get(cacheKey);
        ArrayList<DbEntity> result = new ArrayList<DbEntity>();
        if (entities == null) {
            return Collections.emptyList();
        }
        for (CachedDbEntity cachedEntity : entities.values()) {
            if (type != cacheKey) {
                if (!type.isAssignableFrom(cachedEntity.getClass())) continue;
                result.add(cachedEntity.getEntity());
                continue;
            }
            result.add(cachedEntity.getEntity());
        }
        return result;
    }

    public CachedDbEntity getCachedEntity(Class<?> type, String id) {
        Class<?> cacheKey = this.cacheKeyMapping.getEntityCacheKey(type);
        Map<String, CachedDbEntity> entitesByType = this.cachedEntites.get(cacheKey);
        if (entitesByType != null) {
            return entitesByType.get(id);
        }
        return null;
    }

    public CachedDbEntity getCachedEntity(DbEntity dbEntity) {
        return this.getCachedEntity(dbEntity.getClass(), dbEntity.getId());
    }

    public void putTransient(DbEntity e) {
        CachedDbEntity cachedDbEntity = new CachedDbEntity();
        cachedDbEntity.setEntity(e);
        cachedDbEntity.setEntityState(DbEntityState.TRANSIENT);
        this.putInternal(cachedDbEntity);
    }

    public void putPersistent(DbEntity e) {
        CachedDbEntity cachedDbEntity = new CachedDbEntity();
        cachedDbEntity.setEntity(e);
        cachedDbEntity.setEntityState(DbEntityState.PERSISTENT);
        cachedDbEntity.makeCopy();
        this.putInternal(cachedDbEntity);
    }

    public void putMerged(DbEntity e) {
        CachedDbEntity cachedDbEntity = new CachedDbEntity();
        cachedDbEntity.setEntity(e);
        cachedDbEntity.setEntityState(DbEntityState.MERGED);
        this.putInternal(cachedDbEntity);
    }

    protected void putInternal(CachedDbEntity entityToAdd) {
        CachedDbEntity existingCachedEntity;
        Class<?> type = entityToAdd.getEntity().getClass();
        Class<?> cacheKey = this.cacheKeyMapping.getEntityCacheKey(type);
        Map<String, CachedDbEntity> map = this.cachedEntites.get(cacheKey);
        if (map == null) {
            map = new HashMap<String, CachedDbEntity>();
            this.cachedEntites.put(cacheKey, map);
        }
        if ((existingCachedEntity = map.get(entityToAdd.getEntity().getId())) == null) {
            map.put(entityToAdd.getEntity().getId(), entityToAdd);
        } else {
            switch (entityToAdd.getEntityState()) {
                case TRANSIENT: {
                    if (existingCachedEntity.getEntityState() == DbEntityState.TRANSIENT) {
                        throw new ProcessEngineException("Same entity with Id " + entityToAdd.getEntity().getId() + " and type " + entityToAdd.getEntity().getClass() + " is inserted twice.");
                    }
                    throw new ProcessEngineException("Inserting entity with Id " + entityToAdd.getEntity().getId() + " and type " + entityToAdd.getEntity().getClass() + " wich is already marked " + (Object)((Object)existingCachedEntity.getEntityState()));
                }
                case PERSISTENT: {
                    if (existingCachedEntity.getEntityState() == DbEntityState.PERSISTENT) {
                        map.put(entityToAdd.getEntity().getId(), entityToAdd);
                        break;
                    }
                    if (existingCachedEntity.getEntityState() == DbEntityState.DELETED_PERSISTENT || existingCachedEntity.getEntityState() == DbEntityState.DELETED_MERGED) break;
                    throw new ProcessEngineException("Cannot add PERSISTENT entity with id " + entityToAdd.getEntity().getId() + " and type " + entityToAdd.getEntity().getClass() + " into cache: entity with same Id and type is already " + (Object)((Object)existingCachedEntity.getEntityState()));
                }
                case MERGED: {
                    if (existingCachedEntity.getEntityState() == DbEntityState.PERSISTENT || existingCachedEntity.getEntityState() == DbEntityState.MERGED) {
                        map.put(entityToAdd.getEntity().getId(), entityToAdd);
                        break;
                    }
                    if (existingCachedEntity.getEntityState() == DbEntityState.DELETED_PERSISTENT || existingCachedEntity.getEntityState() == DbEntityState.DELETED_MERGED) break;
                    throw new ProcessEngineException("Cannot add MERGED entity with id " + entityToAdd.getEntity().getId() + " and type " + entityToAdd.getEntity().getClass() + " into cache: entity with same Id and type is already " + (Object)((Object)existingCachedEntity.getEntityState()));
                }
                default: {
                    map.put(entityToAdd.getEntity().getId(), entityToAdd);
                }
            }
        }
    }

    public boolean remove(DbEntity e) {
        Class<?> cacheKey = this.cacheKeyMapping.getEntityCacheKey(e.getClass());
        Map<String, CachedDbEntity> typeMap = this.cachedEntites.get(cacheKey);
        if (typeMap != null) {
            return typeMap.remove(e.getId()) != null;
        }
        return false;
    }

    public void remove(CachedDbEntity cachedDbEntity) {
        this.remove(cachedDbEntity.getEntity());
    }

    public boolean contains(DbEntity dbEntity) {
        return this.getCachedEntity(dbEntity) != null;
    }

    public boolean isPersistent(DbEntity dbEntity) {
        CachedDbEntity cachedDbEntity = this.getCachedEntity(dbEntity);
        if (cachedDbEntity == null) {
            return false;
        }
        return cachedDbEntity.getEntityState() == DbEntityState.PERSISTENT;
    }

    public boolean isDeleted(DbEntity dbEntity) {
        CachedDbEntity cachedDbEntity = this.getCachedEntity(dbEntity);
        if (cachedDbEntity == null) {
            return false;
        }
        return cachedDbEntity.getEntityState() == DbEntityState.DELETED_MERGED || cachedDbEntity.getEntityState() == DbEntityState.DELETED_PERSISTENT || cachedDbEntity.getEntityState() == DbEntityState.DELETED_TRANSIENT;
    }

    public boolean isTransient(DbEntity dbEntity) {
        CachedDbEntity cachedDbEntity = this.getCachedEntity(dbEntity);
        if (cachedDbEntity == null) {
            return false;
        }
        return cachedDbEntity.getEntityState() == DbEntityState.TRANSIENT;
    }

    public List<CachedDbEntity> getCachedEntities() {
        ArrayList<CachedDbEntity> result = new ArrayList<CachedDbEntity>();
        for (Map<String, CachedDbEntity> typeCache : this.cachedEntites.values()) {
            result.addAll(typeCache.values());
        }
        return result;
    }

    public void setDeleted(DbEntity dbEntity) {
        CachedDbEntity cachedEntity = this.getCachedEntity(dbEntity);
        if (cachedEntity != null) {
            if (cachedEntity.getEntityState() == DbEntityState.TRANSIENT) {
                cachedEntity.setEntityState(DbEntityState.DELETED_TRANSIENT);
            } else if (cachedEntity.getEntityState() == DbEntityState.PERSISTENT) {
                cachedEntity.setEntityState(DbEntityState.DELETED_PERSISTENT);
            } else if (cachedEntity.getEntityState() == DbEntityState.MERGED) {
                cachedEntity.setEntityState(DbEntityState.DELETED_MERGED);
            }
        } else {
            CachedDbEntity cachedDbEntity = new CachedDbEntity();
            cachedDbEntity.setEntity(dbEntity);
            cachedDbEntity.setEntityState(DbEntityState.DELETED_MERGED);
            this.putInternal(cachedDbEntity);
        }
    }
}

