/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.operation;

import java.util.List;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.TransferVariablesActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.operation.AbstractCmmnEventAtomicOperation;
import org.camunda.bpm.engine.impl.util.ActivityBehaviorUtil;

public abstract class AbstractAtomicOperationCaseExecutionComplete
extends AbstractCmmnEventAtomicOperation {
    @Override
    protected String getEventName() {
        return "complete";
    }

    @Override
    protected CmmnExecution eventNotificationsStarted(CmmnExecution execution) {
        CmmnActivityBehavior behavior = ActivityBehaviorUtil.getActivityBehavior(execution);
        this.triggerBehavior(behavior, execution);
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                cmmnExecution.remove();
            }
        }
        execution.setCurrentState(CaseExecutionState.COMPLETED);
        return execution;
    }

    @Override
    protected void postTransitionNotification(CmmnExecution execution) {
        CmmnActivityBehavior behavior;
        if (!execution.isCaseInstanceExecution()) {
            execution.remove();
        } else {
            CmmnExecution superCaseExecution = execution.getSuperCaseExecution();
            behavior = null;
            if (superCaseExecution != null) {
                behavior = (TransferVariablesActivityBehavior)ActivityBehaviorUtil.getActivityBehavior(superCaseExecution);
                behavior.transferVariables(execution, superCaseExecution);
                superCaseExecution.complete();
            }
        }
        CmmnExecution parent = execution.getParent();
        if (parent != null && (behavior = ActivityBehaviorUtil.getActivityBehavior(parent)) instanceof CompositeActivityBehavior) {
            CompositeActivityBehavior compositeBehavior = (CompositeActivityBehavior)behavior;
            compositeBehavior.handleChildCompletion(parent, execution);
        }
    }

    protected abstract void triggerBehavior(CmmnActivityBehavior var1, CmmnExecution var2);
}

