/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class StartProcessInstanceByMessageCmd
implements Command<ProcessInstance> {
    protected final String messageName;
    protected final String businessKey;
    protected final Map<String, Object> processVariables;

    public StartProcessInstanceByMessageCmd(String messageName, String businessKey, Map<String, Object> processVariables) {
        this.messageName = messageName;
        this.businessKey = businessKey;
        this.processVariables = processVariables;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("Cannot start process instance by message", "message name", (Object)this.messageName);
        MessageEventSubscriptionEntity messageEventSubscription = commandContext.getEventSubscriptionManager().findMessageStartEventSubscriptionByName(this.messageName);
        EnsureUtil.ensureNotNull("Cannot start process instance by message: no subscription to message with name '" + this.messageName + "' found", "messageEventSubscription", (Object)messageEventSubscription);
        String processDefinitionId = messageEventSubscription.getConfiguration();
        EnsureUtil.ensureNotNull("Cannot start process instance by message: subscription to message with name '" + this.messageName + "' is not a message start event", "processDefinitionId", (Object)processDefinitionId);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        EnsureUtil.ensureNotNull("No process definition found for id '" + processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        ActivityImpl startActivity = processDefinition.findActivity(messageEventSubscription.getActivityId());
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.businessKey, startActivity);
        if (this.processVariables != null) {
            processInstance.setVariables(this.processVariables);
        }
        processInstance.start();
        return processInstance;
    }
}

