/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.DataAssociation;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior;

public class CallActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    protected String processDefinitionKey;
    protected String binding;
    protected Integer version;
    private List<DataAssociation> dataInputAssociations = new ArrayList<DataAssociation>();
    private List<DataAssociation> dataOutputAssociations = new ArrayList<DataAssociation>();
    private Expression processDefinitionExpression;

    public CallActivityBehavior(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public CallActivityBehavior(Expression processDefinitionExpression) {
        this.processDefinitionExpression = processDefinitionExpression;
    }

    public CallActivityBehavior(String processDefinitionKey, String binding, Integer version) {
        this.processDefinitionKey = processDefinitionKey;
        this.binding = binding;
        this.version = version;
    }

    public CallActivityBehavior(Expression processDefinitionExpression, String binding, Integer version) {
        this.processDefinitionExpression = processDefinitionExpression;
        this.binding = binding;
        this.version = version;
    }

    public void addDataInputAssociation(DataAssociation dataInputAssociation) {
        this.dataInputAssociations.add(dataInputAssociation);
    }

    public void addDataOutputAssociation(DataAssociation dataOutputAssociation) {
        this.dataOutputAssociations.add(dataOutputAssociation);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        String processDefinitionKey = this.processDefinitionKey;
        String binding = this.binding;
        Integer version = this.version;
        if (this.processDefinitionExpression != null) {
            processDefinitionKey = (String)this.processDefinitionExpression.getValue(execution);
        }
        ProcessDefinitionEntity processDefinition = null;
        if (binding == null || CalledElementBinding.LATEST.getValue().equals(binding)) {
            processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
        } else if (binding != null && CalledElementBinding.DEPLOYMENT.getValue().equals(binding)) {
            processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionByDeploymentAndKey(((ExecutionEntity)Context.getExecutionContext().getExecution()).getProcessDefinition().getDeploymentId(), processDefinitionKey);
        } else if (binding != null && CalledElementBinding.VERSION.getValue().equals(binding) && version != null) {
            processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionByKeyAndVersion(processDefinitionKey, version);
        }
        String businessKey = null;
        HashMap<String, Object> callActivityVariables = new HashMap<String, Object>();
        for (DataAssociation dataInputAssociation : this.dataInputAssociations) {
            if (dataInputAssociation.getBusinessKeyExpression() != null) {
                businessKey = (String)dataInputAssociation.getBusinessKeyExpression().getValue(execution);
                continue;
            }
            if (dataInputAssociation.getVariables() != null) {
                Map<String, Object> variables = execution.getVariables();
                if (variables == null || variables.isEmpty()) continue;
                Set<String> variableKeys = variables.keySet();
                for (String variableKey : variableKeys) {
                    callActivityVariables.put(variableKey, variables.get(variableKey));
                }
                continue;
            }
            Object value = dataInputAssociation.getSourceExpression() != null ? dataInputAssociation.getSourceExpression().getValue(execution) : execution.getVariable(dataInputAssociation.getSource());
            callActivityVariables.put(dataInputAssociation.getTarget(), value);
        }
        PvmProcessInstance subProcessInstance = execution.createSubProcessInstance(processDefinition, businessKey);
        subProcessInstance.start(callActivityVariables);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        for (DataAssociation dataOutputAssociation : this.dataOutputAssociations) {
            Object value = null;
            if (dataOutputAssociation.getVariables() != null) {
                Map<String, Object> variables = subProcessInstance.getVariables();
                if (variables == null || variables.isEmpty()) continue;
                execution.setVariables(variables);
                continue;
            }
            value = dataOutputAssociation.getSourceExpression() != null ? dataOutputAssociation.getSourceExpression().getValue(subProcessInstance) : subProcessInstance.getVariable(dataOutputAssociation.getSource());
            execution.setVariable(dataOutputAssociation.getTarget(), value);
        }
    }

    @Override
    public void completed(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }

    public static enum CalledElementBinding {
        LATEST("latest"),
        DEPLOYMENT("deployment"),
        VERSION("version");

        private String value;

        private CalledElementBinding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

