/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import java.util.List;
import java.util.logging.Level;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;

public class StopProcessApplicationsStep
extends DeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process applications";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        List processApplicationsReferences = serviceContainer.getServiceValuesByType(ServiceTypes.PROCESS_APPLICATION);
        for (JmxManagedProcessApplication processApplication : processApplicationsReferences) {
            this.stopProcessApplication(processApplication.getProcessApplicationReference());
        }
    }

    protected void stopProcessApplication(ProcessApplicationReference processApplicationReference) {
        try {
            ProcessApplicationInterface processApplication = processApplicationReference.getProcessApplication();
            processApplication.undeploy();
        }
        catch (Throwable t) {
            this.LOGGER.log(Level.WARNING, "Exception while stopping ProcessApplication ", t);
        }
    }
}

