/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.repository;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.repository.CandidateDeployment;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentHandler;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.Resource;

public class DefaultDeploymentHandler
implements DeploymentHandler {
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;

    public DefaultDeploymentHandler(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.repositoryService = processEngine.getRepositoryService();
    }

    @Override
    public boolean shouldDeployResource(Resource newResource, Resource existingResource) {
        return this.resourcesDiffer(newResource, existingResource);
    }

    @Override
    public String determineDuplicateDeployment(CandidateDeployment candidateDeployment) {
        return Context.getCommandContext().getDeploymentManager().findLatestDeploymentByName(candidateDeployment.getName()).getId();
    }

    @Override
    public Set<String> determineDeploymentsToResumeByProcessDefinitionKey(String[] processDefinitionKeys) {
        HashSet<String> deploymentIds = new HashSet<String>();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeysIn(processDefinitionKeys).list();
        for (ProcessDefinition processDefinition : processDefinitions) {
            deploymentIds.add(processDefinition.getDeploymentId());
        }
        return deploymentIds;
    }

    @Override
    public Set<String> determineDeploymentsToResumeByDeploymentName(CandidateDeployment candidateDeployment) {
        List previousDeployments = this.processEngine.getRepositoryService().createDeploymentQuery().deploymentName(candidateDeployment.getName()).list();
        HashSet<String> deploymentIds = new HashSet<String>();
        for (Deployment deployment : previousDeployments) {
            deploymentIds.add(deployment.getId());
        }
        return deploymentIds;
    }

    protected boolean resourcesDiffer(Resource resource, Resource existing) {
        byte[] savedBytes;
        byte[] bytes = resource.getBytes();
        return !Arrays.equals(bytes, savedBytes = existing.getBytes());
    }
}

