/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instruction;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.migration.MigrationInstructionValidationReport;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationReport;

public class MigrationPlanValidationReportImpl
implements MigrationPlanValidationReport {
    protected MigrationPlan migrationPlan;
    protected List<MigrationInstructionValidationReport> instructionReports = new ArrayList<MigrationInstructionValidationReport>();

    public MigrationPlanValidationReportImpl(MigrationPlan migrationPlan) {
        this.migrationPlan = migrationPlan;
    }

    @Override
    public MigrationPlan getMigrationPlan() {
        return this.migrationPlan;
    }

    public void addInstructionReport(MigrationInstructionValidationReport instructionReport) {
        this.instructionReports.add(instructionReport);
    }

    @Override
    public boolean hasInstructionReports() {
        return !this.instructionReports.isEmpty();
    }

    @Override
    public List<MigrationInstructionValidationReport> getInstructionReports() {
        return this.instructionReports;
    }

    public void writeTo(StringBuilder sb) {
        sb.append("Migration plan for process definition '").append(this.migrationPlan.getSourceProcessDefinitionId()).append("' to '").append(this.migrationPlan.getTargetProcessDefinitionId()).append("' is not valid:\n");
        for (MigrationInstructionValidationReport instructionReport : this.instructionReports) {
            sb.append("\t Migration instruction ").append(instructionReport.getMigrationInstruction()).append(" is not valid:\n");
            for (String failure : instructionReport.getFailures()) {
                sb.append("\t\t").append(failure).append("\n");
            }
        }
    }
}

