/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.handler;

import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.form.handler.FormHandler;
import org.camunda.bpm.engine.impl.form.handler.SubmitFormVariablesInvocation;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.variable.VariableMap;

public abstract class DelegateFormHandler {
    protected String deploymentId;
    protected FormHandler formHandler;

    public DelegateFormHandler(FormHandler formHandler, String deploymentId) {
        this.formHandler = formHandler;
        this.deploymentId = deploymentId;
    }

    public void parseConfiguration(Element activityElement, DeploymentEntity deployment, ProcessDefinitionEntity processDefinition, BpmnParse bpmnParse) {
    }

    protected <T> T performContextSwitch(final Callable<T> callable) {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication(this.deploymentId);
        if (targetProcessApplication != null) {
            return Context.executeWithinProcessApplication(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return DelegateFormHandler.this.doCall(callable);
                }
            }, targetProcessApplication);
        }
        return this.doCall(callable);
    }

    protected <T> T doCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
    }

    public void submitFormVariables(final VariableMap properties, final VariableScope variableScope) {
        this.performContextSwitch(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new SubmitFormVariablesInvocation(DelegateFormHandler.this.formHandler, properties, variableScope));
                return null;
            }
        });
    }

    public abstract FormHandler getFormHandler();
}

