/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.ModificationBuilderImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractModificationCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.ActivityCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class ProcessInstanceModificationCmd
extends AbstractModificationCmd<Void> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected boolean writeUserOperationLog;

    public ProcessInstanceModificationCmd(ModificationBuilderImpl builder, boolean writeUserOperationLog) {
        super(builder);
        this.writeUserOperationLog = writeUserOperationLog;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getInstructions();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Modification instructions cannot be empty", instructions);
        Collection<String> processInstanceIds = this.collectProcessInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be empty", "Process instance ids", processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "Process instance ids", processInstanceIds);
        ProcessDefinitionEntity processDefinition = this.getProcessDefinition(commandContext, this.builder.getProcessDefinitionId());
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process definition id cannot be null", (Object)processDefinition);
        if (this.writeUserOperationLog) {
            String annotation = this.builder.getAnnotation();
            this.writeUserOperationLog(commandContext, processDefinition, processInstanceIds.size(), false, annotation);
        }
        boolean skipCustomListeners = this.builder.isSkipCustomListeners();
        boolean skipIoMappings = this.builder.isSkipIoMappings();
        for (String processInstanceId : processInstanceIds) {
            ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
            this.ensureProcessInstanceExist(processInstanceId, processInstance);
            this.ensureSameProcessDefinition(processInstance, processDefinition.getId());
            ProcessInstanceModificationBuilderImpl builder = this.createProcessInstanceModificationBuilder(processInstanceId, commandContext);
            builder.execute(false, skipCustomListeners, skipIoMappings);
        }
        return null;
    }

    protected void ensureSameProcessDefinition(ExecutionEntity processInstance, String processDefinitionId) {
        if (!processDefinitionId.equals(processInstance.getProcessDefinitionId())) {
            throw LOG.processDefinitionOfInstanceDoesNotMatchModification(processInstance, processDefinitionId);
        }
    }

    protected void ensureProcessInstanceExist(String processInstanceId, ExecutionEntity processInstance) {
        if (processInstance == null) {
            throw LOG.processInstanceDoesNotExist(processInstanceId);
        }
    }

    protected ProcessInstanceModificationBuilderImpl createProcessInstanceModificationBuilder(String processInstanceId, CommandContext commandContext) {
        ProcessInstanceModificationBuilderImpl processInstanceModificationBuilder = new ProcessInstanceModificationBuilderImpl(commandContext, processInstanceId);
        List<AbstractProcessInstanceModificationCommand> operations = processInstanceModificationBuilder.getModificationOperations();
        ActivityInstance activityInstanceTree = null;
        for (AbstractProcessInstanceModificationCommand instruction : this.builder.getInstructions()) {
            instruction.setProcessInstanceId(processInstanceId);
            if (!(instruction instanceof ActivityCancellationCmd) || !((ActivityCancellationCmd)instruction).isCancelCurrentActiveActivityInstances()) {
                operations.add(instruction);
                continue;
            }
            if (activityInstanceTree == null) {
                activityInstanceTree = commandContext.runWithoutAuthorization(() -> new GetActivityInstanceCmd(processInstanceId).execute(commandContext));
            }
            ActivityCancellationCmd cancellationInstruction = (ActivityCancellationCmd)instruction;
            List<AbstractInstanceCancellationCmd> cmds = cancellationInstruction.createActivityInstanceCancellations(activityInstanceTree, commandContext);
            operations.addAll(cmds);
        }
        return processInstanceModificationBuilder;
    }
}

