/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class AcquireJobsCmd
implements Command<AcquiredJobs>,
OptimisticLockingListener {
    private final JobExecutor jobExecutor;
    protected AcquiredJobs acquiredJobs;
    protected int numJobsToAcquire;

    public AcquireJobsCmd(JobExecutor jobExecutor) {
        this(jobExecutor, jobExecutor.getMaxJobsPerAcquisition());
    }

    public AcquireJobsCmd(JobExecutor jobExecutor, int numJobsToAcquire) {
        this.jobExecutor = jobExecutor;
        this.numJobsToAcquire = numJobsToAcquire;
    }

    @Override
    public AcquiredJobs execute(CommandContext commandContext) {
        this.acquiredJobs = new AcquiredJobs(this.numJobsToAcquire);
        List<AcquirableJobEntity> jobs = commandContext.getJobManager().findNextJobsToExecute(new Page(0, this.numJobsToAcquire));
        HashMap<String, ArrayList<String>> exclusiveJobsByProcessInstance = new HashMap<String, ArrayList<String>>();
        for (AcquirableJobEntity job : jobs) {
            this.lockJob(job);
            if (job.isExclusive()) {
                ArrayList<String> list = (ArrayList<String>)exclusiveJobsByProcessInstance.get(job.getProcessInstanceId());
                if (list == null) {
                    list = new ArrayList<String>();
                    exclusiveJobsByProcessInstance.put(job.getProcessInstanceId(), list);
                }
                list.add(job.getId());
                continue;
            }
            this.acquiredJobs.addJobIdBatch(job.getId());
        }
        for (List jobIds : exclusiveJobsByProcessInstance.values()) {
            this.acquiredJobs.addJobIdBatch(jobIds);
        }
        commandContext.getDbEntityManager().registerOptimisticLockingListener(this);
        return this.acquiredJobs;
    }

    protected void lockJob(AcquirableJobEntity job) {
        String lockOwner = this.jobExecutor.getLockOwner();
        job.setLockOwner(lockOwner);
        int lockTimeInMillis = this.jobExecutor.getLockTimeInMillis();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(ClockUtil.getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }

    @Override
    public Class<? extends DbEntity> getEntityType() {
        return AcquirableJobEntity.class;
    }

    @Override
    public void failedOperation(DbOperation operation) {
        DbEntityOperation entityOperation;
        if (operation instanceof DbEntityOperation && AcquirableJobEntity.class.isAssignableFrom((entityOperation = (DbEntityOperation)operation).getEntityType())) {
            this.acquiredJobs.removeJobId(entityOperation.getEntity().getId());
        }
    }
}

