/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.camunda.bpm.engine.BpmnParseException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.mapping.InputParameter;
import org.camunda.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.camunda.bpm.engine.impl.core.variable.mapping.OutputParameter;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ListValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.MapValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.NullValueProvider;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.el.ElValueProvider;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptValueProvider;
import org.camunda.bpm.engine.impl.util.ScriptUtil;
import org.camunda.bpm.engine.impl.util.xml.Element;

public final class BpmnParseUtil {
    public static Element findCamundaExtensionElement(Element element, String extensionElementName) {
        Element extensionElements = element.element("extensionElements");
        if (extensionElements != null) {
            return extensionElements.elementNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, extensionElementName);
        }
        return null;
    }

    public static IoMapping parseInputOutput(Element element) {
        Element inputOutputElement = element.elementNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "inputOutput");
        if (inputOutputElement != null) {
            IoMapping ioMapping = new IoMapping();
            BpmnParseUtil.parseCamundaInputParameters(inputOutputElement, ioMapping);
            BpmnParseUtil.parseCamundaOutputParameters(inputOutputElement, ioMapping);
            return ioMapping;
        }
        return null;
    }

    public static void parseCamundaInputParameters(Element inputOutputElement, IoMapping ioMapping) {
        List<Element> inputParameters = inputOutputElement.elementsNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "inputParameter");
        for (Element inputParameterElement : inputParameters) {
            BpmnParseUtil.parseInputParameterElement(inputParameterElement, ioMapping);
        }
    }

    public static void parseCamundaOutputParameters(Element inputOutputElement, IoMapping ioMapping) {
        List<Element> outputParameters = inputOutputElement.elementsNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "outputParameter");
        for (Element outputParameterElement : outputParameters) {
            BpmnParseUtil.parseOutputParameterElement(outputParameterElement, ioMapping);
        }
    }

    public static void parseInputParameterElement(Element inputParameterElement, IoMapping ioMapping) {
        String nameAttribute = inputParameterElement.attribute("name");
        if (nameAttribute == null || nameAttribute.isEmpty()) {
            throw new BpmnParseException("Missing attribute 'name' for inputParameter", inputParameterElement);
        }
        ParameterValueProvider valueProvider = BpmnParseUtil.parseNestedParamValueProvider(inputParameterElement);
        ioMapping.addInputParameter(new InputParameter(nameAttribute, valueProvider));
    }

    public static void parseOutputParameterElement(Element outputParameterElement, IoMapping ioMapping) {
        String nameAttribute = outputParameterElement.attribute("name");
        if (nameAttribute == null || nameAttribute.isEmpty()) {
            throw new BpmnParseException("Missing attribute 'name' for outputParameter", outputParameterElement);
        }
        ParameterValueProvider valueProvider = BpmnParseUtil.parseNestedParamValueProvider(outputParameterElement);
        ioMapping.addOutputParameter(new OutputParameter(nameAttribute, valueProvider));
    }

    protected static ParameterValueProvider parseNestedParamValueProvider(Element element) {
        if (element.elements().size() == 0) {
            return BpmnParseUtil.parseParamValueProvider(element);
        }
        if (element.elements().size() == 1) {
            return BpmnParseUtil.parseParamValueProvider(element.elements().get(0));
        }
        throw new BpmnParseException("Nested parameter can at most have one child element", element);
    }

    protected static ParameterValueProvider parseParamValueProvider(Element parameterElement) {
        if ("list".equals(parameterElement.getTagName())) {
            ArrayList<ParameterValueProvider> providerList = new ArrayList<ParameterValueProvider>();
            for (Element element : parameterElement.elements()) {
                providerList.add(BpmnParseUtil.parseParamValueProvider(element));
            }
            return new ListValueProvider(providerList);
        }
        if ("map".equals(parameterElement.getTagName())) {
            TreeMap<ParameterValueProvider, ParameterValueProvider> providerMap = new TreeMap<ParameterValueProvider, ParameterValueProvider>();
            for (Element entryElement : parameterElement.elements("entry")) {
                String keyAttribute = entryElement.attribute("key");
                if (keyAttribute == null || keyAttribute.isEmpty()) {
                    throw new BpmnParseException("Missing attribute 'key' for 'entry' element", entryElement);
                }
                providerMap.put(new ElValueProvider(BpmnParseUtil.getExpressionManager().createExpression(keyAttribute)), BpmnParseUtil.parseNestedParamValueProvider(entryElement));
            }
            return new MapValueProvider(providerMap);
        }
        if ("script".equals(parameterElement.getTagName())) {
            ExecutableScript executableScript = BpmnParseUtil.parseCamundaScript(parameterElement);
            if (executableScript != null) {
                return new ScriptValueProvider(executableScript);
            }
            return new NullValueProvider();
        }
        String textContent = parameterElement.getText().trim();
        if (!textContent.isEmpty()) {
            return new ElValueProvider(BpmnParseUtil.getExpressionManager().createExpression(textContent));
        }
        return new NullValueProvider();
    }

    public static ExecutableScript parseCamundaScript(Element scriptElement) {
        String scriptLanguage = scriptElement.attribute("scriptFormat");
        if (scriptLanguage == null || scriptLanguage.isEmpty()) {
            throw new BpmnParseException("Missing attribute 'scriptFormat' for 'script' element", scriptElement);
        }
        String scriptResource = scriptElement.attribute("resource");
        String scriptSource = scriptElement.getText();
        try {
            return ScriptUtil.getScript(scriptLanguage, scriptSource, scriptResource, BpmnParseUtil.getExpressionManager());
        }
        catch (ProcessEngineException e) {
            throw new BpmnParseException("Unable to process script", scriptElement, e);
        }
    }

    protected static ExpressionManager getExpressionManager() {
        return Context.getProcessEngineConfiguration().getExpressionManager();
    }
}

