/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class EverLivingJobEntity
extends JobEntity {
    private static final long serialVersionUID = 1L;
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static final String TYPE = "ever-living";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void postExecute(CommandContext commandContext) {
        LOG.debugJobExecuted(this);
        this.init(commandContext);
        commandContext.getHistoricJobLogManager().fireJobSuccessfulEvent(this);
    }

    @Override
    public void init(CommandContext commandContext) {
        this.init(commandContext, false);
    }

    public void init(CommandContext commandContext, boolean shouldResetLock) {
        JobHandler jobHandler = this.getJobHandler();
        if (jobHandler != null) {
            jobHandler.onDelete(this.getJobHandlerConfiguration(), this);
        }
        this.setRetries(commandContext.getProcessEngineConfiguration().getDefaultNumberOfRetries());
        String exceptionByteArrayIdToDelete = null;
        if (this.exceptionByteArrayId != null) {
            exceptionByteArrayIdToDelete = this.exceptionByteArrayId;
            this.exceptionByteArrayId = null;
            this.exceptionMessage = null;
        }
        if (shouldResetLock) {
            this.setLockOwner(null);
            this.setLockExpirationTime(null);
        }
        if (exceptionByteArrayIdToDelete != null) {
            ByteArrayEntity byteArray = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, exceptionByteArrayIdToDelete);
            commandContext.getDbEntityManager().delete(byteArray);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", duedate=" + this.duedate + ", lockOwner=" + this.lockOwner + ", lockExpirationTime=" + this.lockExpirationTime + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", isExclusive=" + this.isExclusive + ", retries=" + this.retries + ", jobHandlerType=" + this.jobHandlerType + ", jobHandlerConfiguration=" + this.jobHandlerConfiguration + ", exceptionByteArray=" + this.exceptionByteArray + ", exceptionByteArrayId=" + this.exceptionByteArrayId + ", exceptionMessage=" + this.exceptionMessage + ", deploymentId=" + this.deploymentId + "]";
    }
}

