/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy.cache;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.ModelInstanceCache;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class BpmnModelInstanceCache
extends ModelInstanceCache<BpmnModelInstance, ProcessDefinitionEntity> {
    public BpmnModelInstanceCache(CacheFactory factory, int cacheCapacity, ResourceDefinitionCache<ProcessDefinitionEntity> definitionCache) {
        super(factory, cacheCapacity, definitionCache);
    }

    @Override
    protected void throwLoadModelException(String definitionId, Exception e) {
        throw LOG.loadModelException("BPMN", "process", definitionId, e);
    }

    @Override
    protected BpmnModelInstance readModelFromStream(InputStream bpmnResourceInputStream) {
        return Bpmn.readModelFromStream((InputStream)bpmnResourceInputStream);
    }

    @Override
    protected void logRemoveEntryFromDeploymentCacheFailure(String definitionId, Exception e) {
        LOG.removeEntryFromDeploymentCacheFailure("process", definitionId, e);
    }

    @Override
    protected List<ProcessDefinition> getAllDefinitionsForDeployment(final String deploymentId) {
        CommandContext commandContext = Context.getCommandContext();
        List<ProcessDefinition> allDefinitionsForDeployment = commandContext.runWithoutAuthorization(new Callable<List<ProcessDefinition>>(){

            @Override
            public List<ProcessDefinition> call() throws Exception {
                return new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
            }
        });
        return allDefinitionsForDeployment;
    }
}

