/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricDecisionInstancesBulkCmd
implements Command<Object> {
    protected final List<String> decisionInstanceIds;

    public DeleteHistoricDecisionInstancesBulkCmd(List<String> decisionInstanceIds) {
        this.decisionInstanceIds = decisionInstanceIds;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.DECISION_DEFINITION);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "decisionInstanceIds", this.decisionInstanceIds);
        this.writeUserOperationLog(commandContext, this.decisionInstanceIds.size());
        commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstanceByIds(this.decisionInstanceIds);
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, false));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("DeleteHistory", propertyChanges);
    }
}

