/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ModificationBatchConfiguration;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;

public class ModifyProcessInstanceAsyncCmd
implements Command<Batch> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessInstanceModificationBuilderImpl builder;

    public ModifyProcessInstanceAsyncCmd(ProcessInstanceModificationBuilderImpl processInstanceModificationBuilder) {
        this.builder = processInstanceModificationBuilder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        String processInstanceId = this.builder.getProcessInstanceId();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(processInstanceId);
        this.ensureProcessInstanceExists(processInstanceId, processInstance);
        this.checkPermissions(commandContext);
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), processInstanceId, null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE));
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getModificationOperations();
        BatchEntity batch = this.createBatch(commandContext, instructions, processInstance);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected void checkPermissions(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateBatch(BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES);
        }
    }

    protected BatchEntity createBatch(CommandContext commandContext, List<AbstractProcessInstanceModificationCommand> instructions, ExecutionEntity processInstance) {
        String processInstanceId = processInstance.getProcessInstanceId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        String tenantId = processInstance.getTenantId();
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler<ModificationBatchConfiguration> batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        ModificationBatchConfiguration configuration = new ModificationBatchConfiguration(Arrays.asList(processInstanceId), processDefinitionId, instructions, this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setTotalJobs(1);
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        batch.setTenantId(tenantId);
        commandContext.getBatchManager().insertBatch(batch);
        return batch;
    }

    protected BatchJobHandler<ModificationBatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Map<String, BatchJobHandler<?>> batchHandlers = processEngineConfiguration.getBatchHandlers();
        return batchHandlers.get("instance-modification");
    }

    protected void ensureProcessInstanceExists(String processInstanceId, ExecutionEntity processInstance) {
        if (processInstance == null) {
            throw LOG.processInstanceDoesNotExist(processInstanceId);
        }
    }

    protected String getLogEntryOperation() {
        return "ModifyProcessInstance";
    }
}

