/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.form.FormData;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractGetDeployedFormCmd;
import org.camunda.bpm.engine.impl.cmd.GetStartFormCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetDeployedStartFormCmd
extends AbstractGetDeployedFormCmd {
    protected String processDefinitionId;

    public GetDeployedStartFormCmd(String processDefinitionId) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process definition id cannot be null", "processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    protected FormData getFormData(final CommandContext commandContext) {
        return commandContext.runWithoutAuthorization(new Callable<FormData>(){

            @Override
            public FormData call() throws Exception {
                return new GetStartFormCmd(GetDeployedStartFormCmd.this.processDefinitionId).execute(commandContext);
            }
        });
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(processDefinition);
        }
    }
}

