/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.removaltime;

import camundajar.com.google.gson.JsonObject;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class SetRemovalTimeJsonConverter
extends JsonObjectConverter<SetRemovalTimeBatchConfiguration> {
    public static final SetRemovalTimeJsonConverter INSTANCE = new SetRemovalTimeJsonConverter();
    protected static final String IDS = "ids";
    protected static final String REMOVAL_TIME = "removalTime";
    protected static final String HAS_REMOVAL_TIME = "hasRemovalTime";
    protected static final String IS_HIERARCHICAL = "isHierarchical";

    @Override
    public JsonObject toJsonObject(SetRemovalTimeBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addListField(json, IDS, configuration.getIds());
        JsonUtil.addDateField(json, REMOVAL_TIME, configuration.getRemovalTime());
        JsonUtil.addField(json, HAS_REMOVAL_TIME, configuration.hasRemovalTime());
        JsonUtil.addField(json, IS_HIERARCHICAL, configuration.isHierarchical());
        return json;
    }

    @Override
    public SetRemovalTimeBatchConfiguration toObject(JsonObject jsonObject) {
        long removalTimeMills = JsonUtil.getLong(jsonObject, REMOVAL_TIME);
        Date removalTime = removalTimeMills > 0L ? new Date(removalTimeMills) : null;
        List<String> instanceIds = JsonUtil.asStringList(JsonUtil.getArray(jsonObject, IDS));
        boolean hasRemovalTime = JsonUtil.getBoolean(jsonObject, HAS_REMOVAL_TIME);
        boolean isHierarchical = JsonUtil.getBoolean(jsonObject, IS_HIERARCHICAL);
        return new SetRemovalTimeBatchConfiguration(instanceIds).setRemovalTime(removalTime).setHasRemovalTime(hasRemovalTime).setHierarchical(isHierarchical);
    }
}

