/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.deletion;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfigurationJsonConverter;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;

public class DeleteProcessInstancesJobHandler
extends AbstractBatchJobHandler<DeleteProcessInstanceBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("instance-deletion");

    @Override
    public String getType() {
        return "instance-deletion";
    }

    protected DeleteProcessInstanceBatchConfigurationJsonConverter getJsonConverterInstance() {
        return DeleteProcessInstanceBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected DeleteProcessInstanceBatchConfiguration createJobConfiguration(DeleteProcessInstanceBatchConfiguration configuration, List<String> processIdsForJob) {
        return new DeleteProcessInstanceBatchConfiguration(processIdsForJob, configuration.getDeleteReason(), configuration.isSkipCustomListeners(), configuration.isSkipSubprocesses(), configuration.isFailIfNotExists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ByteArrayEntity configurationEntity = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, configuration.getConfigurationByteArrayId());
        DeleteProcessInstanceBatchConfiguration batchConfiguration = (DeleteProcessInstanceBatchConfiguration)this.readConfiguration(configurationEntity.getBytes());
        boolean initialLegacyRestrictions = commandContext.isRestrictUserOperationLogToAuthenticatedUsers();
        commandContext.disableUserOperationLog();
        commandContext.setRestrictUserOperationLogToAuthenticatedUsers(true);
        try {
            RuntimeService runtimeService = commandContext.getProcessEngineConfiguration().getRuntimeService();
            if (batchConfiguration.isFailIfNotExists()) {
                runtimeService.deleteProcessInstances(batchConfiguration.getIds(), batchConfiguration.deleteReason, batchConfiguration.isSkipCustomListeners(), true, batchConfiguration.isSkipSubprocesses());
            } else {
                runtimeService.deleteProcessInstancesIfExists(batchConfiguration.getIds(), batchConfiguration.deleteReason, batchConfiguration.isSkipCustomListeners(), true, batchConfiguration.isSkipSubprocesses());
            }
        }
        finally {
            commandContext.enableUserOperationLog();
            commandContext.setRestrictUserOperationLogToAuthenticatedUsers(initialLegacyRestrictions);
        }
        commandContext.getByteArrayManager().delete(configurationEntity);
    }

    @Override
    public boolean createJobs(BatchEntity batch) {
        DeleteProcessInstanceBatchConfiguration configuration = (DeleteProcessInstanceBatchConfiguration)this.readConfiguration(batch.getConfigurationBytes());
        List<String> ids = configuration.getIds();
        final CommandContext commandContext = Context.getCommandContext();
        int batchJobsPerSeed = batch.getBatchJobsPerSeed();
        int invocationsPerBatchJob = batch.getInvocationsPerBatchJob();
        int numberOfItemsToProcess = Math.min(invocationsPerBatchJob * batchJobsPerSeed, ids.size());
        final List<String> processIds = ids.subList(0, numberOfItemsToProcess);
        List<String> deploymentIds = commandContext.runWithoutAuthorization(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return commandContext.getDeploymentManager().findDeploymentIdsByProcessInstances(processIds);
            }
        });
        for (final String deploymentId : deploymentIds) {
            List<String> processIdsPerDeployment = commandContext.runWithoutAuthorization(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    ProcessInstanceQueryImpl processInstanceQueryToBeProcess = new ProcessInstanceQueryImpl();
                    processInstanceQueryToBeProcess.processInstanceIds(new HashSet<String>(processIds)).deploymentId(deploymentId);
                    return commandContext.getExecutionManager().findProcessInstancesIdsByQueryCriteria(processInstanceQueryToBeProcess);
                }
            });
            processIds.removeAll(processIdsPerDeployment);
            this.createJobEntities(batch, configuration, deploymentId, processIdsPerDeployment, invocationsPerBatchJob);
        }
        if (!processIds.isEmpty()) {
            this.createJobEntities(batch, configuration, null, processIds, invocationsPerBatchJob);
        }
        return ids.isEmpty();
    }

    protected void createJobEntities(BatchEntity batch, DeleteProcessInstanceBatchConfiguration configuration, String deploymentId, List<String> processInstancesToHandle, int invocationsPerBatchJob) {
        CommandContext commandContext = Context.getCommandContext();
        ByteArrayManager byteArrayManager = commandContext.getByteArrayManager();
        JobManager jobManager = commandContext.getJobManager();
        int createdJobs = 0;
        while (!processInstancesToHandle.isEmpty()) {
            int lastIdIndex = Math.min(invocationsPerBatchJob, processInstancesToHandle.size());
            List<String> idsForJob = processInstancesToHandle.subList(0, lastIdIndex);
            DeleteProcessInstanceBatchConfiguration jobConfiguration = this.createJobConfiguration(configuration, idsForJob);
            ByteArrayEntity configurationEntity = this.saveConfiguration(byteArrayManager, jobConfiguration);
            JobEntity job = this.createBatchJob(batch, configurationEntity);
            job.setDeploymentId(deploymentId);
            jobManager.insertAndHintJobExecutor(job);
            ++createdJobs;
            idsForJob.clear();
        }
        batch.setJobsCreated(batch.getJobsCreated() + createdJobs);
        batch.setConfigurationBytes(this.writeConfiguration(configuration));
    }
}

