// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


/** \brief The main functionality of ArucoDetector class is detection of markers in an image with detectMarkers() method.
 *
 * After detecting some markers in the image, you can try to find undetected markers from this dictionary with
 * refineDetectedMarkers() method.
 *
 * @see DetectorParameters, RefineParameters
 */
@Namespace("cv::aruco") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class ArucoDetector extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ArucoDetector(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ArucoDetector(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ArucoDetector position(long position) {
        return (ArucoDetector)super.position(position);
    }
    @Override public ArucoDetector getPointer(long i) {
        return new ArucoDetector((Pointer)this).offsetAddress(i);
    }
    /** Downcast constructor. */
    public ArucoDetector(Algorithm pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @Name("static_cast<cv::aruco::ArucoDetector*>") void allocate(Algorithm pointer);
    @Override public Algorithm asAlgorithm() { return asAlgorithm(this); }
    @Namespace public static native @Name("static_cast<cv::Algorithm*>") Algorithm asAlgorithm(ArucoDetector pointer);

    /** \brief Basic ArucoDetector constructor
     *
     * @param dictionary indicates the type of markers that will be searched
     * @param detectorParams marker detection parameters
     * @param refineParams marker refine detection parameters
     */
    public ArucoDetector(@Const @ByRef(nullValue = "cv::aruco::Dictionary(getPredefinedDictionary(cv::aruco::DICT_4X4_50))") Dictionary dictionary,
                              @Const @ByRef(nullValue = "cv::aruco::DetectorParameters()") DetectorParameters detectorParams,
                              @Const @ByRef(nullValue = "cv::aruco::RefineParameters()") RefineParameters refineParams) { super((Pointer)null); allocate(dictionary, detectorParams, refineParams); }
    private native void allocate(@Const @ByRef(nullValue = "cv::aruco::Dictionary(getPredefinedDictionary(cv::aruco::DICT_4X4_50))") Dictionary dictionary,
                              @Const @ByRef(nullValue = "cv::aruco::DetectorParameters()") DetectorParameters detectorParams,
                              @Const @ByRef(nullValue = "cv::aruco::RefineParameters()") RefineParameters refineParams);
    public ArucoDetector() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** \brief Basic marker detection
     *
     * @param image input image
     * @param corners vector of detected marker corners. For each marker, its four corners
     * are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers,
     * the dimensions of this array is Nx4. The order of the corners is clockwise.
     * @param ids vector of identifiers of the detected markers. The identifier is of type int
     * (e.g. std::vector<int>). For N detected markers, the size of ids is also N.
     * The identifiers have the same order than the markers in the imgPoints array.
     * @param rejectedImgPoints contains the imgPoints of those squares whose inner code has not a
     * correct codification. Useful for debugging purposes.
     *
     * Performs marker detection in the input image. Only markers included in the specific dictionary
     * are searched. For each detected marker, it returns the 2D position of its corner in the image
     * and its corresponding identifier.
     * Note that this function does not perform pose estimation.
     * \note The function does not correct lens distortion or takes it into account. It's recommended to undistort
     * input image with corresponding camera model, if camera parameters are known
     * @see undistort, estimatePoseSingleMarkers,  estimatePoseBoard
     */
    public native void detectMarkers(@ByVal Mat image, @ByVal MatVector corners, @ByVal Mat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal Mat image, @ByVal MatVector corners, @ByVal Mat ids);
    public native void detectMarkers(@ByVal Mat image, @ByVal UMatVector corners, @ByVal Mat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal Mat image, @ByVal UMatVector corners, @ByVal Mat ids);
    public native void detectMarkers(@ByVal Mat image, @ByVal GpuMatVector corners, @ByVal Mat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal Mat image, @ByVal GpuMatVector corners, @ByVal Mat ids);
    public native void detectMarkers(@ByVal UMat image, @ByVal MatVector corners, @ByVal UMat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal UMat image, @ByVal MatVector corners, @ByVal UMat ids);
    public native void detectMarkers(@ByVal UMat image, @ByVal UMatVector corners, @ByVal UMat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal UMat image, @ByVal UMatVector corners, @ByVal UMat ids);
    public native void detectMarkers(@ByVal UMat image, @ByVal GpuMatVector corners, @ByVal UMat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal UMat image, @ByVal GpuMatVector corners, @ByVal UMat ids);
    public native void detectMarkers(@ByVal GpuMat image, @ByVal MatVector corners, @ByVal GpuMat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal GpuMat image, @ByVal MatVector corners, @ByVal GpuMat ids);
    public native void detectMarkers(@ByVal GpuMat image, @ByVal UMatVector corners, @ByVal GpuMat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal GpuMat image, @ByVal UMatVector corners, @ByVal GpuMat ids);
    public native void detectMarkers(@ByVal GpuMat image, @ByVal GpuMatVector corners, @ByVal GpuMat ids,
                                   @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints);
    public native void detectMarkers(@ByVal GpuMat image, @ByVal GpuMatVector corners, @ByVal GpuMat ids);

    /** \brief Refine not detected markers based on the already detected and the board layout
     *
     * @param image input image
     * @param board layout of markers in the board.
     * @param detectedCorners vector of already detected marker corners.
     * @param detectedIds vector of already detected marker identifiers.
     * @param rejectedCorners vector of rejected candidates during the marker detection process.
     * @param cameraMatrix optional input 3x3 floating-point camera matrix
     * {@code A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}}
     * @param distCoeffs optional vector of distortion coefficients
     * {@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])} of 4, 5, 8 or 12 elements
     * @param recoveredIdxs Optional array to returns the indexes of the recovered candidates in the
     * original rejectedCorners array.
     *
     * This function tries to find markers that were not detected in the basic detecMarkers function.
     * First, based on the current detected marker and the board layout, the function interpolates
     * the position of the missing markers. Then it tries to find correspondence between the reprojected
     * markers and the rejected candidates based on the minRepDistance and errorCorrectionRate parameters.
     * If camera parameters and distortion coefficients are provided, missing markers are reprojected
     * using projectPoint function. If not, missing marker projections are interpolated using global
     * homography, and all the marker corners in the board must have the same Z coordinate.
     */
    public native void refineDetectedMarkers(@ByVal Mat image, @Const @ByRef Board board,
                                           @ByVal MatVector detectedCorners,
                                           @ByVal Mat detectedIds, @ByVal MatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal Mat image, @Const @ByRef Board board,
                                           @ByVal MatVector detectedCorners,
                                           @ByVal Mat detectedIds, @ByVal MatVector rejectedCorners);
    public native void refineDetectedMarkers(@ByVal Mat image, @Const @ByRef Board board,
                                           @ByVal UMatVector detectedCorners,
                                           @ByVal Mat detectedIds, @ByVal UMatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal Mat image, @Const @ByRef Board board,
                                           @ByVal UMatVector detectedCorners,
                                           @ByVal Mat detectedIds, @ByVal UMatVector rejectedCorners);
    public native void refineDetectedMarkers(@ByVal Mat image, @Const @ByRef Board board,
                                           @ByVal GpuMatVector detectedCorners,
                                           @ByVal Mat detectedIds, @ByVal GpuMatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal Mat image, @Const @ByRef Board board,
                                           @ByVal GpuMatVector detectedCorners,
                                           @ByVal Mat detectedIds, @ByVal GpuMatVector rejectedCorners);
    public native void refineDetectedMarkers(@ByVal UMat image, @Const @ByRef Board board,
                                           @ByVal MatVector detectedCorners,
                                           @ByVal UMat detectedIds, @ByVal MatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal UMat image, @Const @ByRef Board board,
                                           @ByVal MatVector detectedCorners,
                                           @ByVal UMat detectedIds, @ByVal MatVector rejectedCorners);
    public native void refineDetectedMarkers(@ByVal UMat image, @Const @ByRef Board board,
                                           @ByVal UMatVector detectedCorners,
                                           @ByVal UMat detectedIds, @ByVal UMatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal UMat image, @Const @ByRef Board board,
                                           @ByVal UMatVector detectedCorners,
                                           @ByVal UMat detectedIds, @ByVal UMatVector rejectedCorners);
    public native void refineDetectedMarkers(@ByVal UMat image, @Const @ByRef Board board,
                                           @ByVal GpuMatVector detectedCorners,
                                           @ByVal UMat detectedIds, @ByVal GpuMatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal UMat image, @Const @ByRef Board board,
                                           @ByVal GpuMatVector detectedCorners,
                                           @ByVal UMat detectedIds, @ByVal GpuMatVector rejectedCorners);
    public native void refineDetectedMarkers(@ByVal GpuMat image, @Const @ByRef Board board,
                                           @ByVal MatVector detectedCorners,
                                           @ByVal GpuMat detectedIds, @ByVal MatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal GpuMat image, @Const @ByRef Board board,
                                           @ByVal MatVector detectedCorners,
                                           @ByVal GpuMat detectedIds, @ByVal MatVector rejectedCorners);
    public native void refineDetectedMarkers(@ByVal GpuMat image, @Const @ByRef Board board,
                                           @ByVal UMatVector detectedCorners,
                                           @ByVal GpuMat detectedIds, @ByVal UMatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal GpuMat image, @Const @ByRef Board board,
                                           @ByVal UMatVector detectedCorners,
                                           @ByVal GpuMat detectedIds, @ByVal UMatVector rejectedCorners);
    public native void refineDetectedMarkers(@ByVal GpuMat image, @Const @ByRef Board board,
                                           @ByVal GpuMatVector detectedCorners,
                                           @ByVal GpuMat detectedIds, @ByVal GpuMatVector rejectedCorners,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs);
    public native void refineDetectedMarkers(@ByVal GpuMat image, @Const @ByRef Board board,
                                           @ByVal GpuMatVector detectedCorners,
                                           @ByVal GpuMat detectedIds, @ByVal GpuMatVector rejectedCorners);

    public native @Const @ByRef Dictionary getDictionary();
    public native void setDictionary(@Const @ByRef Dictionary dictionary);

    public native @Const @ByRef DetectorParameters getDetectorParameters();
    public native void setDetectorParameters(@Const @ByRef DetectorParameters detectorParameters);

    public native @Const @ByRef RefineParameters getRefineParameters();
    public native void setRefineParameters(@Const @ByRef RefineParameters refineParameters);

    /** \brief Stores algorithm parameters in a file storage
    */
    public native @Override void write(@ByRef FileStorage fs);

    /** \brief simplified API for language bindings
    */
    public native void write(@ByRef FileStorage fs, @Str BytePointer name);
    public native void write(@ByRef FileStorage fs, @Str String name);

    /** \brief Reads algorithm parameters from a file storage
    */
    public native @Override void read(@Const @ByRef FileNode fn);
}
