// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_core.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

public class opencv_core extends org.bytedeco.opencv.helper.opencv_core {
    static { Loader.load(); }

// Targeting ..\opencv_core\IntDoubleMap.java


// Targeting ..\opencv_core\ByteVectorVector.java


// Targeting ..\opencv_core\IntVectorVector.java


// Targeting ..\opencv_core\FloatVectorVector.java


// Targeting ..\opencv_core\StringVector.java


// Targeting ..\opencv_core\PointVector.java


// Targeting ..\opencv_core\Point2fVector.java


// Targeting ..\opencv_core\Point2dVector.java


// Targeting ..\opencv_core\Point3iVector.java


// Targeting ..\opencv_core\Point3fVector.java


// Targeting ..\opencv_core\SizeVector.java


// Targeting ..\opencv_core\RectVector.java


// Targeting ..\opencv_core\Rect2dVector.java


// Targeting ..\opencv_core\ScalarVector.java


// Targeting ..\opencv_core\KeyPointVector.java


// Targeting ..\opencv_core\DMatchVector.java


// Targeting ..\opencv_core\RangeVector.java


// Targeting ..\opencv_core\PointVectorVector.java


// Targeting ..\opencv_core\Point2fVectorVector.java


// Targeting ..\opencv_core\Point2dVectorVector.java


// Targeting ..\opencv_core\Point3fVectorVector.java


// Targeting ..\opencv_core\RectVectorVector.java


// Targeting ..\opencv_core\KeyPointVectorVector.java


// Targeting ..\opencv_core\DMatchVectorVector.java


// Targeting ..\opencv_core\MatVector.java


// Targeting ..\opencv_core\UMatVector.java


// Targeting ..\opencv_core\GpuMatVector.java


// Targeting ..\opencv_core\MatVectorVector.java


// Targeting ..\opencv_core\IntDoublePairVector.java


// Targeting ..\opencv_core\IntIntPairVector.java


// Targeting ..\opencv_core\MatBytePairVector.java


// Targeting ..\opencv_core\UMatBytePairVector.java


// Targeting ..\opencv_core\NodeDataTlsVector.java


// Targeting ..\opencv_core\IntIntPair.java


// Parsed from <opencv2/core/hal/interface.h>

// #ifndef OPENCV_CORE_HAL_INTERFACE_H
// #define OPENCV_CORE_HAL_INTERFACE_H

/** \addtogroup core_hal_interface
 *  \{
 <p>
 *  \name Return codes
 *  \{ */
public static final int CV_HAL_ERROR_OK = 0;
public static final int CV_HAL_ERROR_NOT_IMPLEMENTED = 1;
public static final int CV_HAL_ERROR_UNKNOWN = -1;
/** \} */

// #ifdef __cplusplus
// #include <cstddef>
// #else
// #endif

/** \name Data types
 *  primitive types
 *  - schar  - signed 1 byte integer
 *  - uchar  - unsigned 1 byte integer
 *  - short  - signed 2 byte integer
 *  - ushort - unsigned 2 byte integer
 *  - int    - signed 4 byte integer
 *  - uint   - unsigned 4 byte integer
 *  - int64  - signed 8 byte integer
 *  - uint64 - unsigned 8 byte integer
 *  \{ */
// #if !defined _MSC_VER && !defined __BORLANDC__
// #  if defined __cplusplus && __cplusplus >= 201103L && !defined __APPLE__
// #    include <cstdint>
// #    ifdef __NEWLIB__
// #    else
// #    endif
// #  else
// #    include <stdint.h>
// #  endif
// #else
// #endif

// #ifndef __IPL_H__
// #endif

// #if defined _MSC_VER || defined __BORLANDC__
// #  define CV_BIG_INT(n)   n##I64
// #  define CV_BIG_UINT(n)  n##UI64
// #else
// #  define CV_BIG_INT(n)   n##LL
// #  define CV_BIG_UINT(n)  n##ULL
// #endif

// #define CV_USRTYPE1 (void)"CV_USRTYPE1 support has been dropped in OpenCV 4.0"

public static final int CV_CN_MAX =     512;
public static final int CV_CN_SHIFT =   3;
public static final int CV_DEPTH_MAX =  (1 << CV_CN_SHIFT);

public static final int CV_8U =   0;
public static final int CV_8S =   1;
public static final int CV_16U =  2;
public static final int CV_16S =  3;
public static final int CV_32S =  4;
public static final int CV_32F =  5;
public static final int CV_64F =  6;
public static final int CV_16F =  7;

public static final int CV_MAT_DEPTH_MASK =       (CV_DEPTH_MAX - 1);
public static native int CV_MAT_DEPTH(int flags);

public static native int CV_MAKETYPE(int depth, int cn);
public static native int CV_MAKE_TYPE(int arg1, int arg2);

public static final int CV_8UC1 = CV_MAKETYPE(CV_8U,1);
public static final int CV_8UC2 = CV_MAKETYPE(CV_8U,2);
public static final int CV_8UC3 = CV_MAKETYPE(CV_8U,3);
public static final int CV_8UC4 = CV_MAKETYPE(CV_8U,4);
public static native int CV_8UC(int n);

public static final int CV_8SC1 = CV_MAKETYPE(CV_8S,1);
public static final int CV_8SC2 = CV_MAKETYPE(CV_8S,2);
public static final int CV_8SC3 = CV_MAKETYPE(CV_8S,3);
public static final int CV_8SC4 = CV_MAKETYPE(CV_8S,4);
public static native int CV_8SC(int n);

public static final int CV_16UC1 = CV_MAKETYPE(CV_16U,1);
public static final int CV_16UC2 = CV_MAKETYPE(CV_16U,2);
public static final int CV_16UC3 = CV_MAKETYPE(CV_16U,3);
public static final int CV_16UC4 = CV_MAKETYPE(CV_16U,4);
public static native int CV_16UC(int n);

public static final int CV_16SC1 = CV_MAKETYPE(CV_16S,1);
public static final int CV_16SC2 = CV_MAKETYPE(CV_16S,2);
public static final int CV_16SC3 = CV_MAKETYPE(CV_16S,3);
public static final int CV_16SC4 = CV_MAKETYPE(CV_16S,4);
public static native int CV_16SC(int n);

public static final int CV_32SC1 = CV_MAKETYPE(CV_32S,1);
public static final int CV_32SC2 = CV_MAKETYPE(CV_32S,2);
public static final int CV_32SC3 = CV_MAKETYPE(CV_32S,3);
public static final int CV_32SC4 = CV_MAKETYPE(CV_32S,4);
public static native int CV_32SC(int n);

public static final int CV_32FC1 = CV_MAKETYPE(CV_32F,1);
public static final int CV_32FC2 = CV_MAKETYPE(CV_32F,2);
public static final int CV_32FC3 = CV_MAKETYPE(CV_32F,3);
public static final int CV_32FC4 = CV_MAKETYPE(CV_32F,4);
public static native int CV_32FC(int n);

public static final int CV_64FC1 = CV_MAKETYPE(CV_64F,1);
public static final int CV_64FC2 = CV_MAKETYPE(CV_64F,2);
public static final int CV_64FC3 = CV_MAKETYPE(CV_64F,3);
public static final int CV_64FC4 = CV_MAKETYPE(CV_64F,4);
public static native int CV_64FC(int n);

public static native @MemberGetter int CV_16FC1();
public static final int CV_16FC1 = CV_16FC1();
public static native @MemberGetter int CV_16FC2();
public static final int CV_16FC2 = CV_16FC2();
public static native @MemberGetter int CV_16FC3();
public static final int CV_16FC3 = CV_16FC3();
public static native @MemberGetter int CV_16FC4();
public static final int CV_16FC4 = CV_16FC4();
// #define CV_16FC(n) CV_MAKETYPE(CV_16F,(n))
/** \}
 <p>
 *  \name Comparison operation
 *  @see cv::CmpTypes
 *  \{ */
public static final int CV_HAL_CMP_EQ = 0;
public static final int CV_HAL_CMP_GT = 1;
public static final int CV_HAL_CMP_GE = 2;
public static final int CV_HAL_CMP_LT = 3;
public static final int CV_HAL_CMP_LE = 4;
public static final int CV_HAL_CMP_NE = 5;
/** \}
 <p>
 *  \name Border processing modes
 *  @see cv::BorderTypes
 *  \{ */
public static final int CV_HAL_BORDER_CONSTANT = 0;
public static final int CV_HAL_BORDER_REPLICATE = 1;
public static final int CV_HAL_BORDER_REFLECT = 2;
public static final int CV_HAL_BORDER_WRAP = 3;
public static final int CV_HAL_BORDER_REFLECT_101 = 4;
public static final int CV_HAL_BORDER_TRANSPARENT = 5;
public static final int CV_HAL_BORDER_ISOLATED = 16;
/** \}
 <p>
 *  \name DFT flags
 *  \{ */
public static final int CV_HAL_DFT_INVERSE =        1;
public static final int CV_HAL_DFT_SCALE =          2;
public static final int CV_HAL_DFT_ROWS =           4;
public static final int CV_HAL_DFT_COMPLEX_OUTPUT = 16;
public static final int CV_HAL_DFT_REAL_OUTPUT =    32;
public static final int CV_HAL_DFT_TWO_STAGE =      64;
public static final int CV_HAL_DFT_STAGE_COLS =    128;
public static final int CV_HAL_DFT_IS_CONTINUOUS = 512;
public static final int CV_HAL_DFT_IS_INPLACE = 1024;
/** \}
 <p>
 *  \name SVD flags
 *  \{ */
public static final int CV_HAL_SVD_NO_UV =    1;
public static final int CV_HAL_SVD_SHORT_UV = 2;
public static final int CV_HAL_SVD_MODIFY_A = 4;
public static final int CV_HAL_SVD_FULL_UV =  8;
/** \}
 <p>
 *  \name Gemm flags
 *  \{ */
public static final int CV_HAL_GEMM_1_T = 1;
public static final int CV_HAL_GEMM_2_T = 2;
public static final int CV_HAL_GEMM_3_T = 4;
/** \}
 <p>
 *  \} */

// #endif


// Parsed from <opencv2/core/cvdef.h>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Copyright (C) 2015, Itseez Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_CVDEF_H
// #define OPENCV_CORE_CVDEF_H

// #include "opencv2/core/version.hpp"

/** \addtogroup core_utils
 *  \{ */

// #ifdef OPENCV_INCLUDE_PORT_FILE  // User-provided header file with custom platform configuration
// #include OPENCV_INCLUDE_PORT_FILE
// #endif

// #if !defined CV_DOXYGEN && !defined CV_IGNORE_DEBUG_BUILD_GUARD
// #if (defined(_MSC_VER) && (defined(DEBUG) || defined(_DEBUG))) ||
//     (defined(_GLIBCXX_DEBUG) || defined(_GLIBCXX_DEBUG_PEDANTIC))
// Guard to prevent using of binary incompatible binaries / runtimes
// https://github.com/opencv/opencv/pull/9161
// #define CV__DEBUG_NS_BEGIN namespace debug_build_guard {
// #define CV__DEBUG_NS_END }
 
// #endif
// #endif

// #ifndef CV__DEBUG_NS_BEGIN
// #define CV__DEBUG_NS_BEGIN
// #define CV__DEBUG_NS_END
// #endif


// #ifdef __OPENCV_BUILD
// #endif

// #ifndef __CV_EXPAND
// #define __CV_EXPAND(x) x
// #endif

// #ifndef __CV_CAT
// #define __CV_CAT__(x, y) x ## y
// #define __CV_CAT_(x, y) __CV_CAT__(x, y)
// #define __CV_CAT(x, y) __CV_CAT_(x, y)
// #endif

// #define __CV_VA_NUM_ARGS_HELPER(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, N, ...) N
// #define __CV_VA_NUM_ARGS(...) __CV_EXPAND(__CV_VA_NUM_ARGS_HELPER(__VA_ARGS__, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0))

// #ifdef CV_Func
// #elif defined __GNUC__ || (defined (__cpluscplus) && (__cpluscplus >= 201103))
// #define CV_Func __func__
// #elif defined __clang__ && (__clang_minor__ * 100 + __clang_major__ >= 305)
// #define CV_Func __func__
// #elif defined(__STDC_VERSION__) && (__STDC_VERSION >= 199901)
// #define CV_Func __func__
// #elif defined _MSC_VER
// #define CV_Func __FUNCTION__
// #elif defined(__INTEL_COMPILER) && (_INTEL_COMPILER >= 600)
// #define CV_Func __FUNCTION__
// #elif defined __IBMCPP__ && __IBMCPP__ >=500
// #define CV_Func __FUNCTION__
// #elif defined __BORLAND__ && (__BORLANDC__ >= 0x550)
// #define CV_Func __FUNC__
// #else
// #define CV_Func "<unknown>"
// #endif

/** \cond IGNORED
<p>
//////////////// static assert ///////////////// */
// #define CVAUX_CONCAT_EXP(a, b) a##b
// #define CVAUX_CONCAT(a, b) CVAUX_CONCAT_EXP(a,b)

// #if defined(__clang__)
// #elif defined(__GNUC__)
// #elif defined(_MSC_VER)
// #endif
// #ifndef CV_StaticAssert
// #endif

// Suppress warning "-Wdeprecated-declarations" / C4996
// #if defined(_MSC_VER)
// #elif defined(__GNUC__)
// #else
//     #define CV_DO_PRAGMA(x)
// #endif

// #ifdef _MSC_VER
// #define CV_SUPPRESS_DEPRECATED_START
//     CV_DO_PRAGMA(warning(push))
//     CV_DO_PRAGMA(warning(disable: 4996))
// #define CV_SUPPRESS_DEPRECATED_END CV_DO_PRAGMA(warning(pop))
// #elif defined (__clang__) || ((__GNUC__)  && (__GNUC__*100 + __GNUC_MINOR__ > 405))
// #define CV_SUPPRESS_DEPRECATED_START
//     CV_DO_PRAGMA(GCC diagnostic push)
//     CV_DO_PRAGMA(GCC diagnostic ignored "-Wdeprecated-declarations")
// #define CV_SUPPRESS_DEPRECATED_END CV_DO_PRAGMA(GCC diagnostic pop)
// #else
// #define CV_SUPPRESS_DEPRECATED_START
// #define CV_SUPPRESS_DEPRECATED_END
// #endif

// #define CV_UNUSED(name) (void)name

/** \endcond */

// undef problematic defines sometimes defined by system headers (windows.h in particular)
// #undef small
// #undef min
// #undef max
// #undef abs
// #undef Complex

// #if defined __cplusplus
// #include <limits>
// #else
// #include <limits.h>
// #endif

// #include "opencv2/core/hal/interface.h"

// #if defined __ICL
// #elif defined __ICC
// #elif defined __ECL
// #elif defined __ECC
// #elif defined __INTEL_COMPILER
// #endif

// #ifndef CV_INLINE
// #  if defined __cplusplus
// #    define CV_INLINE static inline
// #  elif defined _MSC_VER
// #    define CV_INLINE __inline
// #  else
// #    define CV_INLINE static
// #  endif
// #endif

// #ifndef CV_ALWAYS_INLINE
// #if defined(__GNUC__) && (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1))
// #define CV_ALWAYS_INLINE inline __attribute__((always_inline))
// #elif defined(_MSC_VER)
// #else
// #define CV_ALWAYS_INLINE inline
// #endif
// #endif

// #if defined CV_DISABLE_OPTIMIZATION || (defined CV_ICC && !defined CV_ENABLE_UNROLLED)
// #  define CV_ENABLE_UNROLLED 0
// #else
// #  define CV_ENABLE_UNROLLED 1
// #endif

// #ifdef __GNUC__
// #  define CV_DECL_ALIGNED(x) __attribute__ ((aligned (x)))
// #elif defined _MSC_VER
// #  define CV_DECL_ALIGNED(x) __declspec(align(x))
// #else
// #  define CV_DECL_ALIGNED(x)
// #endif

/* CPU features and intrinsics support */
public static final int CV_CPU_NONE =             0;
public static final int CV_CPU_MMX =              1;
public static final int CV_CPU_SSE =              2;
public static final int CV_CPU_SSE2 =             3;
public static final int CV_CPU_SSE3 =             4;
public static final int CV_CPU_SSSE3 =            5;
public static final int CV_CPU_SSE4_1 =           6;
public static final int CV_CPU_SSE4_2 =           7;
public static final int CV_CPU_POPCNT =           8;
public static final int CV_CPU_FP16 =             9;
public static final int CV_CPU_AVX =              10;
public static final int CV_CPU_AVX2 =             11;
public static final int CV_CPU_FMA3 =             12;

public static final int CV_CPU_AVX_512F =         13;
public static final int CV_CPU_AVX_512BW =        14;
public static final int CV_CPU_AVX_512CD =        15;
public static final int CV_CPU_AVX_512DQ =        16;
public static final int CV_CPU_AVX_512ER =        17;
public static final int CV_CPU_AVX_512IFMA512 =   18; // deprecated
public static final int CV_CPU_AVX_512IFMA =      18;
public static final int CV_CPU_AVX_512PF =        19;
public static final int CV_CPU_AVX_512VBMI =      20;
public static final int CV_CPU_AVX_512VL =        21;
public static final int CV_CPU_AVX_512VBMI2 =     22;
public static final int CV_CPU_AVX_512VNNI =      23;
public static final int CV_CPU_AVX_512BITALG =    24;
public static final int CV_CPU_AVX_512VPOPCNTDQ = 25;
public static final int CV_CPU_AVX_5124VNNIW =    26;
public static final int CV_CPU_AVX_5124FMAPS =    27;

public static final int CV_CPU_NEON =             100;
public static final int CV_CPU_NEON_DOTPROD =     101;
public static final int CV_CPU_NEON_FP16 =        102;
public static final int CV_CPU_NEON_BF16 =        103;

public static final int CV_CPU_MSA =              150;

public static final int CV_CPU_RISCVV =           170;

public static final int CV_CPU_VSX =              200;
public static final int CV_CPU_VSX3 =             201;

public static final int CV_CPU_RVV =              210;

public static final int CV_CPU_LSX =              230;
public static final int CV_CPU_LASX =             231;

// CPU features groups
public static final int CV_CPU_AVX512_SKX =       256;
public static final int CV_CPU_AVX512_COMMON =    257;
public static final int CV_CPU_AVX512_KNL =       258;
public static final int CV_CPU_AVX512_KNM =       259;
public static final int CV_CPU_AVX512_CNL =       260;
public static final int CV_CPU_AVX512_CLX =       261;
public static final int CV_CPU_AVX512_ICL =       262;

// when adding to this list remember to update the following enum
public static final int CV_HARDWARE_MAX_FEATURE = 512;

/** \brief Available CPU features.
*/
/** enum CpuFeatures */
public static final int
    CPU_MMX             = 1,
    CPU_SSE             = 2,
    CPU_SSE2            = 3,
    CPU_SSE3            = 4,
    CPU_SSSE3           = 5,
    CPU_SSE4_1          = 6,
    CPU_SSE4_2          = 7,
    CPU_POPCNT          = 8,
    CPU_FP16            = 9,
    CPU_AVX             = 10,
    CPU_AVX2            = 11,
    CPU_FMA3            = 12,

    CPU_AVX_512F        = 13,
    CPU_AVX_512BW       = 14,
    CPU_AVX_512CD       = 15,
    CPU_AVX_512DQ       = 16,
    CPU_AVX_512ER       = 17,
    CPU_AVX_512IFMA512  = 18, // deprecated
    CPU_AVX_512IFMA     = 18,
    CPU_AVX_512PF       = 19,
    CPU_AVX_512VBMI     = 20,
    CPU_AVX_512VL       = 21,
    CPU_AVX_512VBMI2    = 22,
    CPU_AVX_512VNNI     = 23,
    CPU_AVX_512BITALG   = 24,
    CPU_AVX_512VPOPCNTDQ = 25,
    CPU_AVX_5124VNNIW   = 26,
    CPU_AVX_5124FMAPS   = 27,

    CPU_NEON            = 100,
    CPU_NEON_DOTPROD    = 101,
    CPU_NEON_FP16       = 102,
    CPU_NEON_BF16       = 103,

    CPU_MSA             = 150,

    CPU_RISCVV          = 170,

    CPU_VSX             = 200,
    CPU_VSX3            = 201,

    CPU_RVV             = 210,

    CPU_LSX             = 230,
    CPU_LASX            = 231,

    /** Skylake-X with AVX-512F/CD/BW/DQ/VL */
    CPU_AVX512_SKX      = 256,
    /** Common instructions AVX-512F/CD for all CPUs that support AVX-512 */
    CPU_AVX512_COMMON   = 257,
    /** Knights Landing with AVX-512F/CD/ER/PF */
    CPU_AVX512_KNL      = 258,
    /** Knights Mill with AVX-512F/CD/ER/PF/4FMAPS/4VNNIW/VPOPCNTDQ */
    CPU_AVX512_KNM      = 259,
    /** Cannon Lake with AVX-512F/CD/BW/DQ/VL/IFMA/VBMI */
    CPU_AVX512_CNL      = 260,
    /** Cascade Lake with AVX-512F/CD/BW/DQ/VL/VNNI */
    CPU_AVX512_CLX      = 261,
    /** Ice Lake with AVX-512F/CD/BW/DQ/VL/IFMA/VBMI/VNNI/VBMI2/BITALG/VPOPCNTDQ */
    CPU_AVX512_ICL      = 262,

    CPU_MAX_FEATURE     = 512;  // see CV_HARDWARE_MAX_FEATURE


// #include "cv_cpu_dispatch.h"

// #if !defined(CV_STRONG_ALIGNMENT) && defined(__arm__) && !(defined(__aarch64__) || defined(_M_ARM64))
// int*, int64* should be propertly aligned pointers on ARMv7
public static final int CV_STRONG_ALIGNMENT = 1;
// #endif
// #if !defined(CV_STRONG_ALIGNMENT)
// #endif

/* fundamental constants */
public static final double CV_PI =   3.1415926535897932384626433832795;
public static final double CV_2PI =  6.283185307179586476925286766559;
public static final double CV_LOG2 = 0.69314718055994530941723212145818;

// #if defined __ARM_FP16_FORMAT_IEEE
//     && !defined __CUDACC__
public static native @MemberGetter int CV_FP16_TYPE();
public static final int CV_FP16_TYPE = CV_FP16_TYPE();
// #else
// Targeting ..\opencv_core\Cv16suf.java


// Targeting ..\opencv_core\Cv32suf.java


// Targeting ..\opencv_core\Cv64suf.java



// #ifndef OPENCV_ABI_COMPATIBILITY
public static final int OPENCV_ABI_COMPATIBILITY = 400;
// #endif

// #ifdef __OPENCV_BUILD
// #endif

// #ifndef CV_EXPORTS
// # if (defined _WIN32 || defined WINCE || defined __CYGWIN__) && defined(CVAPI_EXPORTS)
// #   define CV_EXPORTS __declspec(dllexport)
// # elif defined __GNUC__ && __GNUC__ >= 4 && (defined(CVAPI_EXPORTS) || defined(__APPLE__))
// #   define CV_EXPORTS __attribute__ ((visibility ("default")))
// # endif
// #endif

// #ifndef CV_EXPORTS
// # define CV_EXPORTS
// #endif

// #ifdef _MSC_VER
// #   define CV_EXPORTS_TEMPLATE
// #else
// #   define CV_EXPORTS_TEMPLATE CV_EXPORTS
// #endif

// #ifndef CV_DEPRECATED
// #  if defined(__GNUC__)
// #  elif defined(_MSC_VER)
// #  else
// #    define CV_DEPRECATED
// #  endif
// #endif

// #ifndef CV_DEPRECATED_EXTERNAL
// #  if defined(__OPENCV_BUILD)
// #    define CV_DEPRECATED_EXTERNAL /* nothing */
// #  else
// #    define CV_DEPRECATED_EXTERNAL CV_DEPRECATED
// #  endif
// #endif


// #ifndef CV_EXTERN_C
// #  ifdef __cplusplus
// #    define CV_EXTERN_C extern "C"
// #  else
// #  endif
// #endif

/* special informative macros for wrapper generators */
// #define CV_EXPORTS_W CV_EXPORTS
// #define CV_EXPORTS_W_SIMPLE CV_EXPORTS
// #define CV_EXPORTS_AS(synonym) CV_EXPORTS
// #define CV_EXPORTS_W_MAP CV_EXPORTS
// #define CV_EXPORTS_W_PARAMS CV_EXPORTS
// #define CV_IN_OUT
// #define CV_OUT
// #define CV_PROP
// #define CV_PROP_RW
// #define CV_WRAP
// #define CV_WRAP_AS(synonym)
// #define CV_WRAP_MAPPABLE(mappable)
// #define CV_WRAP_PHANTOM(phantom_header)
// #define CV_WRAP_DEFAULT(val)

/****************************************************************************************\
*                                  Matrix type (Mat)                                     *
\****************************************************************************************/

public static final int CV_MAT_CN_MASK =          ((CV_CN_MAX - 1) << CV_CN_SHIFT);
public static native int CV_MAT_CN(int flags);
public static final int CV_MAT_TYPE_MASK =        (CV_DEPTH_MAX*CV_CN_MAX - 1);
public static native int CV_MAT_TYPE(int flags);
public static final int CV_MAT_CONT_FLAG_SHIFT =  14;
public static final int CV_MAT_CONT_FLAG =        (1 << CV_MAT_CONT_FLAG_SHIFT);
public static native int CV_IS_MAT_CONT(int flags);
public static native int CV_IS_CONT_MAT(int arg1);
public static final int CV_SUBMAT_FLAG_SHIFT =    15;
public static final int CV_SUBMAT_FLAG =          (1 << CV_SUBMAT_FLAG_SHIFT);
// #define CV_IS_SUBMAT(flags)     ((flags) & CV_MAT_SUBMAT_FLAG)

/** Size of each channel item,
   0x28442211 = 0010 1000 0100 0100 0010 0010 0001 0001 ~ array of sizeof(arr_type_elem) */
// #define CV_ELEM_SIZE1(type) ((0x28442211 >> CV_MAT_DEPTH(type)*4) & 15)

// #define CV_ELEM_SIZE(type) (CV_MAT_CN(type)*CV_ELEM_SIZE1(type))

// #ifndef MIN
// #  define MIN(a,b)  ((a) > (b) ? (b) : (a))
// #endif

// #ifndef MAX
// #  define MAX(a,b)  ((a) < (b) ? (b) : (a))
// #endif

///////////////////////////////////////// Enum operators ///////////////////////////////////////

/**
<p>
Provides compatibility operators for both classical and C++11 enum classes,
as well as exposing the C++11 enum class members for backwards compatibility
<p>
<pre>{@code
    // Provides operators required for flag enums
    CV_ENUM_FLAGS(AccessFlag)

    // Exposes the listed members of the enum class AccessFlag to the current namespace
    CV_ENUM_CLASS_EXPOSE(AccessFlag, ACCESS_READ [, ACCESS_WRITE [, ...] ]);
}</pre>
*/

// #define __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST)
// static const EnumType MEMBER_CONST = EnumType::MEMBER_CONST;                                          

// #define __CV_ENUM_CLASS_EXPOSE_2(EnumType, MEMBER_CONST, ...)
// __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST);
// __CV_EXPAND(__CV_ENUM_CLASS_EXPOSE_1(EnumType, __VA_ARGS__));                                         

// #define __CV_ENUM_CLASS_EXPOSE_3(EnumType, MEMBER_CONST, ...)
// __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST);
// __CV_EXPAND(__CV_ENUM_CLASS_EXPOSE_2(EnumType, __VA_ARGS__));                                         

// #define __CV_ENUM_CLASS_EXPOSE_4(EnumType, MEMBER_CONST, ...)
// __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST);
// __CV_EXPAND(__CV_ENUM_CLASS_EXPOSE_3(EnumType, __VA_ARGS__));                                         

// #define __CV_ENUM_CLASS_EXPOSE_5(EnumType, MEMBER_CONST, ...)
// __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST);
// __CV_EXPAND(__CV_ENUM_CLASS_EXPOSE_4(EnumType, __VA_ARGS__));                                         

// #define __CV_ENUM_CLASS_EXPOSE_6(EnumType, MEMBER_CONST, ...)
// __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST);
// __CV_EXPAND(__CV_ENUM_CLASS_EXPOSE_5(EnumType, __VA_ARGS__));                                         

// #define __CV_ENUM_CLASS_EXPOSE_7(EnumType, MEMBER_CONST, ...)
// __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST);
// __CV_EXPAND(__CV_ENUM_CLASS_EXPOSE_6(EnumType, __VA_ARGS__));                                         

// #define __CV_ENUM_CLASS_EXPOSE_8(EnumType, MEMBER_CONST, ...)
// __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST);
// __CV_EXPAND(__CV_ENUM_CLASS_EXPOSE_7(EnumType, __VA_ARGS__));                                         

// #define __CV_ENUM_CLASS_EXPOSE_9(EnumType, MEMBER_CONST, ...)
// __CV_ENUM_CLASS_EXPOSE_1(EnumType, MEMBER_CONST);
// __CV_EXPAND(__CV_ENUM_CLASS_EXPOSE_8(EnumType, __VA_ARGS__));                                         

// #define __CV_ENUM_FLAGS_LOGICAL_NOT(EnumType)
// static inline bool operator!(const EnumType& val)
// {
//     typedef std::underlying_type<EnumType>::type UnderlyingType;
//     return !static_cast<UnderlyingType>(val);
// }                                                                                                     

// #define __CV_ENUM_FLAGS_LOGICAL_NOT_EQ(Arg1Type, Arg2Type)
// static inline bool operator!=(const Arg1Type& a, const Arg2Type& b)
// {
//     return static_cast<int>(a) != static_cast<int>(b);
// }                                                                                                     

// #define __CV_ENUM_FLAGS_LOGICAL_EQ(Arg1Type, Arg2Type)
// static inline bool operator==(const Arg1Type& a, const Arg2Type& b)
// {
//     return static_cast<int>(a) == static_cast<int>(b);
// }                                                                                                     

// #define __CV_ENUM_FLAGS_BITWISE_NOT(EnumType)
// static inline EnumType operator~(const EnumType& val)
// {
//     typedef std::underlying_type<EnumType>::type UnderlyingType;
//     return static_cast<EnumType>(~static_cast<UnderlyingType>(val));
// }                                                                                                     

// #define __CV_ENUM_FLAGS_BITWISE_OR(EnumType, Arg1Type, Arg2Type)
// static inline EnumType operator|(const Arg1Type& a, const Arg2Type& b)
// {
//     typedef std::underlying_type<EnumType>::type UnderlyingType;
//     return static_cast<EnumType>(static_cast<UnderlyingType>(a) | static_cast<UnderlyingType>(b));
// }                                                                                                     

// #define __CV_ENUM_FLAGS_BITWISE_AND(EnumType, Arg1Type, Arg2Type)
// static inline EnumType operator&(const Arg1Type& a, const Arg2Type& b)
// {
//     typedef std::underlying_type<EnumType>::type UnderlyingType;
//     return static_cast<EnumType>(static_cast<UnderlyingType>(a) & static_cast<UnderlyingType>(b));
// }                                                                                                     

// #define __CV_ENUM_FLAGS_BITWISE_XOR(EnumType, Arg1Type, Arg2Type)
// static inline EnumType operator^(const Arg1Type& a, const Arg2Type& b)
// {
//     typedef std::underlying_type<EnumType>::type UnderlyingType;
//     return static_cast<EnumType>(static_cast<UnderlyingType>(a) ^ static_cast<UnderlyingType>(b));
// }                                                                                                     

// #define __CV_ENUM_FLAGS_BITWISE_OR_EQ(EnumType, Arg1Type)
// static inline EnumType& operator|=(EnumType& _this, const Arg1Type& val)
// {
//     _this = static_cast<EnumType>(static_cast<int>(_this) | static_cast<int>(val));
//     return _this;
// }                                                                                                     

// #define __CV_ENUM_FLAGS_BITWISE_AND_EQ(EnumType, Arg1Type)
// static inline EnumType& operator&=(EnumType& _this, const Arg1Type& val)
// {
//     _this = static_cast<EnumType>(static_cast<int>(_this) & static_cast<int>(val));
//     return _this;
// }                                                                                                     

// #define __CV_ENUM_FLAGS_BITWISE_XOR_EQ(EnumType, Arg1Type)
// static inline EnumType& operator^=(EnumType& _this, const Arg1Type& val)
// {
//     _this = static_cast<EnumType>(static_cast<int>(_this) ^ static_cast<int>(val));
//     return _this;
// }                                                                                                     

// #define CV_ENUM_CLASS_EXPOSE(EnumType, ...)
// __CV_EXPAND(__CV_CAT(__CV_ENUM_CLASS_EXPOSE_, __CV_VA_NUM_ARGS(__VA_ARGS__))(EnumType, __VA_ARGS__)); 

// #define CV_ENUM_FLAGS(EnumType)
// __CV_ENUM_FLAGS_LOGICAL_NOT      (EnumType)
// __CV_ENUM_FLAGS_LOGICAL_EQ       (EnumType, int)
// __CV_ENUM_FLAGS_LOGICAL_NOT_EQ   (EnumType, int)
// 
// __CV_ENUM_FLAGS_BITWISE_NOT      (EnumType)
// __CV_ENUM_FLAGS_BITWISE_OR       (EnumType, EnumType, EnumType)
// __CV_ENUM_FLAGS_BITWISE_AND      (EnumType, EnumType, EnumType)
// __CV_ENUM_FLAGS_BITWISE_XOR      (EnumType, EnumType, EnumType)
// 
// __CV_ENUM_FLAGS_BITWISE_OR_EQ    (EnumType, EnumType)
// __CV_ENUM_FLAGS_BITWISE_AND_EQ   (EnumType, EnumType)
// __CV_ENUM_FLAGS_BITWISE_XOR_EQ   (EnumType, EnumType)                                                 

/****************************************************************************************\
*                                    static analysys                                     *
\****************************************************************************************/

// In practice, some macro are not processed correctly (noreturn is not detected).
// We need to use simplified definition for them.
// #ifndef CV_STATIC_ANALYSIS
// # if defined(__KLOCWORK__) || defined(__clang_analyzer__) || defined(__COVERITY__)
public static final int CV_STATIC_ANALYSIS = 1;
// # endif
// #else
// # if defined(CV_STATIC_ANALYSIS) && !(__CV_CAT(1, CV_STATIC_ANALYSIS) == 1)  // defined and not empty
// #   if 0 == CV_STATIC_ANALYSIS
// #     undef CV_STATIC_ANALYSIS
// #   endif
// # endif
// #endif

/****************************************************************************************\
*                                    Thread sanitizer                                    *
\****************************************************************************************/
// #ifndef CV_THREAD_SANITIZER
// # if defined(__has_feature)
// #   if __has_feature(thread_sanitizer)
// #     define CV_THREAD_SANITIZER
// #   endif
// # endif
// #endif

/****************************************************************************************\
*          exchange-add operation for atomic operations on reference counters            *
\****************************************************************************************/

// #ifdef CV_XADD
  // allow to use user-defined macro
// #elif defined __GNUC__ || defined __clang__
// #elif defined _MSC_VER && !defined RC_INVOKED
// #else
//   #ifdef OPENCV_FORCE_UNSAFE_XADD
    public static native int CV_XADD(IntPointer addr, int delta);
    public static native int CV_XADD(IntBuffer addr, int delta);
    public static native int CV_XADD(int[] addr, int delta);
//   #else
//     #error "OpenCV: can't define safe CV_XADD macro for current platform (unsupported). Define CV_XADD macro through custom port header (see OPENCV_INCLUDE_PORT_FILE)"
//   #endif
// #endif


/****************************************************************************************\
*                                  CV_NORETURN attribute                                 *
\****************************************************************************************/

// #ifndef CV_NORETURN
// #  if defined(__GNUC__)
// #  elif defined(_MSC_VER) && (_MSC_VER >= 1300)
// #    define CV_NORETURN __declspec(noreturn)
// #  else
// #    define CV_NORETURN /* nothing by default */
// #  endif
// #endif

/****************************************************************************************\
*                       CV_NODISCARD_STD attribute (C++17)                               *
* encourages the compiler to issue a warning if the return value is discarded            *
\****************************************************************************************/
// #ifndef CV_NODISCARD_STD
// #  ifndef __has_cpp_attribute
//   workaround preprocessor non-compliance https://reviews.llvm.org/D57851
// #    define __has_cpp_attribute(__x) 0
// #  endif
// #  if __has_cpp_attribute(nodiscard)
// #    define CV_NODISCARD_STD [[nodiscard]]
// #  elif __cplusplus >= 201703L
//   available when compiler is C++17 compliant
// #    define CV_NODISCARD_STD [[nodiscard]]
// #  elif defined(__INTEL_COMPILER)
     // see above, available when C++17 is enabled
// #  elif defined(_MSC_VER) && _MSC_VER >= 1911 && _MSVC_LANG >= 201703L
//   available with VS2017 v15.3+ with /std:c++17 or higher; works on functions and classes
// #    define CV_NODISCARD_STD [[nodiscard]]
// #  elif defined(__GNUC__) && (((__GNUC__ * 100) + __GNUC_MINOR__) >= 700) && (__cplusplus >= 201103L)
//   available with GCC 7.0+; works on functions, works or silently fails on classes
// #    define CV_NODISCARD_STD [[nodiscard]]
// #  elif defined(__GNUC__) && (((__GNUC__ * 100) + __GNUC_MINOR__) >= 408) && (__cplusplus >= 201103L)
//   available with GCC 4.8+ but it usually does nothing and can fail noisily -- therefore not used
//   define CV_NODISCARD_STD [[gnu::warn_unused_result]]
// #  endif
// #endif
// #ifndef CV_NODISCARD_STD
// #  define CV_NODISCARD_STD /* nothing by default */
// #endif


/****************************************************************************************\
*                      CV_NODISCARD attribute (deprecated, GCC only)                     *
* DONT USE: use instead the standard CV_NODISCARD_STD macro above                        *
*           this legacy method silently fails to issue warning until some version        *
*           after gcc 6.3.0. Yet with gcc 7+ you can use the above standard method       *
*           which makes this method useless. Don't use it.                               *
* @deprecated use instead CV_NODISCARD_STD                                               *
\****************************************************************************************/
// #ifndef CV_NODISCARD
// #  if defined(__GNUC__)
// #  elif defined(__clang__) && defined(__has_attribute)
// #    if __has_attribute(__warn_unused_result__)
// #      define CV_NODISCARD __attribute__((__warn_unused_result__))
// #    endif
// #  endif
// #endif
// #ifndef CV_NODISCARD
// #  define CV_NODISCARD /* nothing by default */
// #endif


/****************************************************************************************\
*                                    C++ 11                                              *
\****************************************************************************************/
// #ifndef CV_CXX11
// #  if __cplusplus >= 201103L || (defined(_MSC_VER) && _MSC_VER >= 1800)
// #  endif
// #else
// #endif
// #ifndef CV_CXX11
// #  error "OpenCV 4.x+ requires enabled C++11 support"
// #endif

public static final int CV_CXX_MOVE_SEMANTICS = 1;
// #define CV_CXX_MOVE(x) std::move(x)
public static final int CV_CXX_STD_ARRAY = 1;
// #include <array>
// #ifndef CV_OVERRIDE
// #  define CV_OVERRIDE override
// #endif
// #ifndef CV_FINAL
// #  define CV_FINAL final
// #endif

// #ifndef CV_NOEXCEPT
// #  if __cplusplus >= 201103L || (defined(_MSC_VER) && _MSC_VER >= 1900/*MSVS 2015*/)
// #    define CV_NOEXCEPT noexcept
// #  endif
// #endif
// #ifndef CV_NOEXCEPT
// #  define CV_NOEXCEPT
// #endif

// #ifndef CV_CONSTEXPR
// #  if __cplusplus >= 201103L || (defined(_MSC_VER) && _MSC_VER >= 1900/*MSVS 2015*/)
// #    define CV_CONSTEXPR constexpr
// #  endif
// #endif
// #ifndef CV_CONSTEXPR
// #  define CV_CONSTEXPR
// #endif

// Integer types portability
// #ifdef OPENCV_STDINT_HEADER
// #include OPENCV_STDINT_HEADER
// #elif defined(__cplusplus)
// #if defined(_MSC_VER) && _MSC_VER < 1600 /* MSVS 2010 */

// #elif defined(_MSC_VER) || __cplusplus >= 201103L
// #include <cstdint>

// #else
// #include <stdint.h>

// #endif
// #else // pure C
// #include <stdint.h>
// Targeting ..\opencv_core\float16_t.java




// #endif

/** \} */

// #ifndef __cplusplus
// #endif

// #endif // OPENCV_CORE_CVDEF_H


// Parsed from <opencv2/core/hal/hal.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Copyright (C) 2015, Itseez Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_HAL_HPP
// #define OPENCV_HAL_HPP

// #include "opencv2/core/cvdef.h"
// #include "opencv2/core/cvstd.hpp"
// #include "opencv2/core/hal/interface.h"

/** \addtogroup core_hal_functions
 *  \{ */

@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") BytePointer a, int n);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") ByteBuffer a, int n);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") byte[] a, int n);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") BytePointer a, @Cast("const uchar*") BytePointer b, int n);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") ByteBuffer a, @Cast("const uchar*") ByteBuffer b, int n);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") byte[] a, @Cast("const uchar*") byte[] b, int n);

@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") BytePointer a, int n, int cellSize);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") ByteBuffer a, int n, int cellSize);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") byte[] a, int n, int cellSize);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") BytePointer a, @Cast("const uchar*") BytePointer b, int n, int cellSize);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") ByteBuffer a, @Cast("const uchar*") ByteBuffer b, int n, int cellSize);
@Namespace("cv::hal") public static native int normHamming(@Cast("const uchar*") byte[] a, @Cast("const uchar*") byte[] b, int n, int cellSize);

@Namespace("cv::hal") public static native int LU32f(FloatPointer A, @Cast("size_t") long astep, int m, FloatPointer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU32f(FloatBuffer A, @Cast("size_t") long astep, int m, FloatBuffer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU32f(float[] A, @Cast("size_t") long astep, int m, float[] b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU64f(DoublePointer A, @Cast("size_t") long astep, int m, DoublePointer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU64f(DoubleBuffer A, @Cast("size_t") long astep, int m, DoubleBuffer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU64f(double[] A, @Cast("size_t") long astep, int m, double[] b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky32f(FloatPointer A, @Cast("size_t") long astep, int m, FloatPointer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky32f(FloatBuffer A, @Cast("size_t") long astep, int m, FloatBuffer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky32f(float[] A, @Cast("size_t") long astep, int m, float[] b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky64f(DoublePointer A, @Cast("size_t") long astep, int m, DoublePointer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky64f(DoubleBuffer A, @Cast("size_t") long astep, int m, DoubleBuffer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky64f(double[] A, @Cast("size_t") long astep, int m, double[] b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native void SVD32f(FloatPointer At, @Cast("size_t") long astep, FloatPointer W, FloatPointer U, @Cast("size_t") long ustep, FloatPointer Vt, @Cast("size_t") long vstep, int m, int n, int flags);
@Namespace("cv::hal") public static native void SVD32f(FloatBuffer At, @Cast("size_t") long astep, FloatBuffer W, FloatBuffer U, @Cast("size_t") long ustep, FloatBuffer Vt, @Cast("size_t") long vstep, int m, int n, int flags);
@Namespace("cv::hal") public static native void SVD32f(float[] At, @Cast("size_t") long astep, float[] W, float[] U, @Cast("size_t") long ustep, float[] Vt, @Cast("size_t") long vstep, int m, int n, int flags);
@Namespace("cv::hal") public static native void SVD64f(DoublePointer At, @Cast("size_t") long astep, DoublePointer W, DoublePointer U, @Cast("size_t") long ustep, DoublePointer Vt, @Cast("size_t") long vstep, int m, int n, int flags);
@Namespace("cv::hal") public static native void SVD64f(DoubleBuffer At, @Cast("size_t") long astep, DoubleBuffer W, DoubleBuffer U, @Cast("size_t") long ustep, DoubleBuffer Vt, @Cast("size_t") long vstep, int m, int n, int flags);
@Namespace("cv::hal") public static native void SVD64f(double[] At, @Cast("size_t") long astep, double[] W, double[] U, @Cast("size_t") long ustep, double[] Vt, @Cast("size_t") long vstep, int m, int n, int flags);
@Namespace("cv::hal") public static native int QR32f(FloatPointer A, @Cast("size_t") long astep, int m, int n, int k, FloatPointer b, @Cast("size_t") long bstep, FloatPointer hFactors);
@Namespace("cv::hal") public static native int QR32f(FloatBuffer A, @Cast("size_t") long astep, int m, int n, int k, FloatBuffer b, @Cast("size_t") long bstep, FloatBuffer hFactors);
@Namespace("cv::hal") public static native int QR32f(float[] A, @Cast("size_t") long astep, int m, int n, int k, float[] b, @Cast("size_t") long bstep, float[] hFactors);
@Namespace("cv::hal") public static native int QR64f(DoublePointer A, @Cast("size_t") long astep, int m, int n, int k, DoublePointer b, @Cast("size_t") long bstep, DoublePointer hFactors);
@Namespace("cv::hal") public static native int QR64f(DoubleBuffer A, @Cast("size_t") long astep, int m, int n, int k, DoubleBuffer b, @Cast("size_t") long bstep, DoubleBuffer hFactors);
@Namespace("cv::hal") public static native int QR64f(double[] A, @Cast("size_t") long astep, int m, int n, int k, double[] b, @Cast("size_t") long bstep, double[] hFactors);

@Namespace("cv::hal") public static native void gemm32f(@Const FloatPointer src1, @Cast("size_t") long src1_step, @Const FloatPointer src2, @Cast("size_t") long src2_step,
                        float alpha, @Const FloatPointer src3, @Cast("size_t") long src3_step, float beta, FloatPointer dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm32f(@Const FloatBuffer src1, @Cast("size_t") long src1_step, @Const FloatBuffer src2, @Cast("size_t") long src2_step,
                        float alpha, @Const FloatBuffer src3, @Cast("size_t") long src3_step, float beta, FloatBuffer dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm32f(@Const float[] src1, @Cast("size_t") long src1_step, @Const float[] src2, @Cast("size_t") long src2_step,
                        float alpha, @Const float[] src3, @Cast("size_t") long src3_step, float beta, float[] dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm64f(@Const DoublePointer src1, @Cast("size_t") long src1_step, @Const DoublePointer src2, @Cast("size_t") long src2_step,
                        double alpha, @Const DoublePointer src3, @Cast("size_t") long src3_step, double beta, DoublePointer dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm64f(@Const DoubleBuffer src1, @Cast("size_t") long src1_step, @Const DoubleBuffer src2, @Cast("size_t") long src2_step,
                        double alpha, @Const DoubleBuffer src3, @Cast("size_t") long src3_step, double beta, DoubleBuffer dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm64f(@Const double[] src1, @Cast("size_t") long src1_step, @Const double[] src2, @Cast("size_t") long src2_step,
                        double alpha, @Const double[] src3, @Cast("size_t") long src3_step, double beta, double[] dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm32fc(@Const FloatPointer src1, @Cast("size_t") long src1_step, @Const FloatPointer src2, @Cast("size_t") long src2_step,
                        float alpha, @Const FloatPointer src3, @Cast("size_t") long src3_step, float beta, FloatPointer dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm32fc(@Const FloatBuffer src1, @Cast("size_t") long src1_step, @Const FloatBuffer src2, @Cast("size_t") long src2_step,
                        float alpha, @Const FloatBuffer src3, @Cast("size_t") long src3_step, float beta, FloatBuffer dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm32fc(@Const float[] src1, @Cast("size_t") long src1_step, @Const float[] src2, @Cast("size_t") long src2_step,
                        float alpha, @Const float[] src3, @Cast("size_t") long src3_step, float beta, float[] dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm64fc(@Const DoublePointer src1, @Cast("size_t") long src1_step, @Const DoublePointer src2, @Cast("size_t") long src2_step,
                        double alpha, @Const DoublePointer src3, @Cast("size_t") long src3_step, double beta, DoublePointer dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm64fc(@Const DoubleBuffer src1, @Cast("size_t") long src1_step, @Const DoubleBuffer src2, @Cast("size_t") long src2_step,
                        double alpha, @Const DoubleBuffer src3, @Cast("size_t") long src3_step, double beta, DoubleBuffer dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);
@Namespace("cv::hal") public static native void gemm64fc(@Const double[] src1, @Cast("size_t") long src1_step, @Const double[] src2, @Cast("size_t") long src2_step,
                        double alpha, @Const double[] src3, @Cast("size_t") long src3_step, double beta, double[] dst, @Cast("size_t") long dst_step,
                        int m_a, int n_a, int n_d, int flags);

@Namespace("cv::hal") public static native int normL1_(@Cast("const uchar*") BytePointer a, @Cast("const uchar*") BytePointer b, int n);
@Namespace("cv::hal") public static native int normL1_(@Cast("const uchar*") ByteBuffer a, @Cast("const uchar*") ByteBuffer b, int n);
@Namespace("cv::hal") public static native int normL1_(@Cast("const uchar*") byte[] a, @Cast("const uchar*") byte[] b, int n);
@Namespace("cv::hal") public static native float normL1_(@Const FloatPointer a, @Const FloatPointer b, int n);
@Namespace("cv::hal") public static native float normL1_(@Const FloatBuffer a, @Const FloatBuffer b, int n);
@Namespace("cv::hal") public static native float normL1_(@Const float[] a, @Const float[] b, int n);
@Namespace("cv::hal") public static native float normL2Sqr_(@Const FloatPointer a, @Const FloatPointer b, int n);
@Namespace("cv::hal") public static native float normL2Sqr_(@Const FloatBuffer a, @Const FloatBuffer b, int n);
@Namespace("cv::hal") public static native float normL2Sqr_(@Const float[] a, @Const float[] b, int n);

@Namespace("cv::hal") public static native void exp32f(@Const FloatPointer src, FloatPointer dst, int n);
@Namespace("cv::hal") public static native void exp32f(@Const FloatBuffer src, FloatBuffer dst, int n);
@Namespace("cv::hal") public static native void exp32f(@Const float[] src, float[] dst, int n);
@Namespace("cv::hal") public static native void exp64f(@Const DoublePointer src, DoublePointer dst, int n);
@Namespace("cv::hal") public static native void exp64f(@Const DoubleBuffer src, DoubleBuffer dst, int n);
@Namespace("cv::hal") public static native void exp64f(@Const double[] src, double[] dst, int n);
@Namespace("cv::hal") public static native void log32f(@Const FloatPointer src, FloatPointer dst, int n);
@Namespace("cv::hal") public static native void log32f(@Const FloatBuffer src, FloatBuffer dst, int n);
@Namespace("cv::hal") public static native void log32f(@Const float[] src, float[] dst, int n);
@Namespace("cv::hal") public static native void log64f(@Const DoublePointer src, DoublePointer dst, int n);
@Namespace("cv::hal") public static native void log64f(@Const DoubleBuffer src, DoubleBuffer dst, int n);
@Namespace("cv::hal") public static native void log64f(@Const double[] src, double[] dst, int n);

@Namespace("cv::hal") public static native void fastAtan32f(@Const FloatPointer y, @Const FloatPointer x, FloatPointer dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void fastAtan32f(@Const FloatBuffer y, @Const FloatBuffer x, FloatBuffer dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void fastAtan32f(@Const float[] y, @Const float[] x, float[] dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void fastAtan64f(@Const DoublePointer y, @Const DoublePointer x, DoublePointer dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void fastAtan64f(@Const DoubleBuffer y, @Const DoubleBuffer x, DoubleBuffer dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void fastAtan64f(@Const double[] y, @Const double[] x, double[] dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void magnitude32f(@Const FloatPointer x, @Const FloatPointer y, FloatPointer dst, int n);
@Namespace("cv::hal") public static native void magnitude32f(@Const FloatBuffer x, @Const FloatBuffer y, FloatBuffer dst, int n);
@Namespace("cv::hal") public static native void magnitude32f(@Const float[] x, @Const float[] y, float[] dst, int n);
@Namespace("cv::hal") public static native void magnitude64f(@Const DoublePointer x, @Const DoublePointer y, DoublePointer dst, int n);
@Namespace("cv::hal") public static native void magnitude64f(@Const DoubleBuffer x, @Const DoubleBuffer y, DoubleBuffer dst, int n);
@Namespace("cv::hal") public static native void magnitude64f(@Const double[] x, @Const double[] y, double[] dst, int n);
@Namespace("cv::hal") public static native void sqrt32f(@Const FloatPointer src, FloatPointer dst, int len);
@Namespace("cv::hal") public static native void sqrt32f(@Const FloatBuffer src, FloatBuffer dst, int len);
@Namespace("cv::hal") public static native void sqrt32f(@Const float[] src, float[] dst, int len);
@Namespace("cv::hal") public static native void sqrt64f(@Const DoublePointer src, DoublePointer dst, int len);
@Namespace("cv::hal") public static native void sqrt64f(@Const DoubleBuffer src, DoubleBuffer dst, int len);
@Namespace("cv::hal") public static native void sqrt64f(@Const double[] src, double[] dst, int len);
@Namespace("cv::hal") public static native void invSqrt32f(@Const FloatPointer src, FloatPointer dst, int len);
@Namespace("cv::hal") public static native void invSqrt32f(@Const FloatBuffer src, FloatBuffer dst, int len);
@Namespace("cv::hal") public static native void invSqrt32f(@Const float[] src, float[] dst, int len);
@Namespace("cv::hal") public static native void invSqrt64f(@Const DoublePointer src, DoublePointer dst, int len);
@Namespace("cv::hal") public static native void invSqrt64f(@Const DoubleBuffer src, DoubleBuffer dst, int len);
@Namespace("cv::hal") public static native void invSqrt64f(@Const double[] src, double[] dst, int len);

@Namespace("cv::hal") public static native void split8u(@Cast("const uchar*") BytePointer src, @Cast("uchar**") PointerPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void split8u(@Cast("const uchar*") BytePointer src, @Cast("uchar**") @ByPtrPtr BytePointer dst, int len, int cn );
@Namespace("cv::hal") public static native void split8u(@Cast("const uchar*") ByteBuffer src, @Cast("uchar**") @ByPtrPtr ByteBuffer dst, int len, int cn );
@Namespace("cv::hal") public static native void split8u(@Cast("const uchar*") byte[] src, @Cast("uchar**") @ByPtrPtr byte[] dst, int len, int cn );
@Namespace("cv::hal") public static native void split16u(@Cast("const ushort*") ShortPointer src, @Cast("ushort**") PointerPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void split16u(@Cast("const ushort*") ShortPointer src, @Cast("ushort**") @ByPtrPtr ShortPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void split16u(@Cast("const ushort*") ShortBuffer src, @Cast("ushort**") @ByPtrPtr ShortBuffer dst, int len, int cn );
@Namespace("cv::hal") public static native void split16u(@Cast("const ushort*") short[] src, @Cast("ushort**") @ByPtrPtr short[] dst, int len, int cn );
@Namespace("cv::hal") public static native void split32s(@Const IntPointer src, @Cast("int**") PointerPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void split32s(@Const IntPointer src, @ByPtrPtr IntPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void split32s(@Const IntBuffer src, @ByPtrPtr IntBuffer dst, int len, int cn );
@Namespace("cv::hal") public static native void split32s(@Const int[] src, @ByPtrPtr int[] dst, int len, int cn );
@Namespace("cv::hal") public static native void split64s(@Cast("const int64*") LongPointer src, @Cast("int64**") PointerPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void split64s(@Cast("const int64*") LongPointer src, @Cast("int64**") @ByPtrPtr LongPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void split64s(@Cast("const int64*") LongBuffer src, @Cast("int64**") @ByPtrPtr LongBuffer dst, int len, int cn );
@Namespace("cv::hal") public static native void split64s(@Cast("const int64*") long[] src, @Cast("int64**") @ByPtrPtr long[] dst, int len, int cn );

@Namespace("cv::hal") public static native void merge8u(@Cast("const uchar**") PointerPointer src, @Cast("uchar*") BytePointer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge8u(@Cast("const uchar**") @ByPtrPtr BytePointer src, @Cast("uchar*") BytePointer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge8u(@Cast("const uchar**") @ByPtrPtr ByteBuffer src, @Cast("uchar*") ByteBuffer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge8u(@Cast("const uchar**") @ByPtrPtr byte[] src, @Cast("uchar*") byte[] dst, int len, int cn );
@Namespace("cv::hal") public static native void merge16u(@Cast("const ushort**") PointerPointer src, @Cast("ushort*") ShortPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge16u(@Cast("const ushort**") @ByPtrPtr ShortPointer src, @Cast("ushort*") ShortPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge16u(@Cast("const ushort**") @ByPtrPtr ShortBuffer src, @Cast("ushort*") ShortBuffer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge16u(@Cast("const ushort**") @ByPtrPtr short[] src, @Cast("ushort*") short[] dst, int len, int cn );
@Namespace("cv::hal") public static native void merge32s(@Cast("const int**") PointerPointer src, IntPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge32s(@Const @ByPtrPtr IntPointer src, IntPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge32s(@Const @ByPtrPtr IntBuffer src, IntBuffer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge32s(@Const @ByPtrPtr int[] src, int[] dst, int len, int cn );
@Namespace("cv::hal") public static native void merge64s(@Cast("const int64**") PointerPointer src, @Cast("int64*") LongPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge64s(@Cast("const int64**") @ByPtrPtr LongPointer src, @Cast("int64*") LongPointer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge64s(@Cast("const int64**") @ByPtrPtr LongBuffer src, @Cast("int64*") LongBuffer dst, int len, int cn );
@Namespace("cv::hal") public static native void merge64s(@Cast("const int64**") @ByPtrPtr long[] src, @Cast("int64*") long[] dst, int len, int cn );

@Namespace("cv::hal") public static native void add8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add8s( @Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add8s( @Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add8s( @Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add16u( @Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add16u( @Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add16u( @Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add16s( @Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add16s( @Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add16s( @Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add32s( @Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add32s( @Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add32s( @Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add32f( @Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add32f( @Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add32f( @Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add64f( @Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add64f( @Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void add64f( @Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );

@Namespace("cv::hal") public static native void sub8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub8s( @Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub8s( @Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub8s( @Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub16u( @Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub16u( @Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub16u( @Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub16s( @Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub16s( @Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub16s( @Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub32s( @Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub32s( @Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub32s( @Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub32f( @Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub32f( @Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub32f( @Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub64f( @Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub64f( @Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void sub64f( @Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );

@Namespace("cv::hal") public static native void max8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max8s( @Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max8s( @Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max8s( @Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max16u( @Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max16u( @Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max16u( @Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max16s( @Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max16s( @Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max16s( @Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max32s( @Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max32s( @Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max32s( @Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max32f( @Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max32f( @Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max32f( @Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max64f( @Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max64f( @Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void max64f( @Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );

@Namespace("cv::hal") public static native void min8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min8s( @Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min8s( @Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min8s( @Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min16u( @Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min16u( @Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min16u( @Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min16s( @Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min16s( @Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min16s( @Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min32s( @Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min32s( @Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min32s( @Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min32f( @Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min32f( @Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min32f( @Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min64f( @Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min64f( @Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void min64f( @Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );

@Namespace("cv::hal") public static native void absdiff8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff8s( @Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff8s( @Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff8s( @Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff16u( @Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff16u( @Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff16u( @Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff16s( @Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff16s( @Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff16s( @Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff32s( @Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff32s( @Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff32s( @Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff32f( @Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff32f( @Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff32f( @Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff64f( @Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff64f( @Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void absdiff64f( @Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );

@Namespace("cv::hal") public static native void and8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void and8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void and8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void or8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void or8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void or8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void xor8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void xor8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void xor8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void not8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void not8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );
@Namespace("cv::hal") public static native void not8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer arg8 );

@Namespace("cv::hal") public static native void cmp8u(@Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp8u(@Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp8u(@Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp8s(@Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp8s(@Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp8s(@Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp16u(@Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp16u(@Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp16u(@Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp16s(@Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp16s(@Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp16s(@Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp32s(@Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp32s(@Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp32s(@Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp32f(@Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp32f(@Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp32f(@Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp64f(@Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp64f(@Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);
@Namespace("cv::hal") public static native void cmp64f(@Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer _cmpop);

@Namespace("cv::hal") public static native void mul8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul8s( @Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul8s( @Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul8s( @Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul16u( @Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul16u( @Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul16u( @Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul16s( @Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul16s( @Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul16s( @Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul32s( @Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul32s( @Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul32s( @Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul32f( @Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul32f( @Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul32f( @Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul64f( @Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul64f( @Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void mul64f( @Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);

@Namespace("cv::hal") public static native void div8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div8s( @Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div8s( @Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div8s( @Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div16u( @Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div16u( @Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div16u( @Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div16s( @Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div16s( @Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div16s( @Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div32s( @Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div32s( @Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div32s( @Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div32f( @Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div32f( @Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div32f( @Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div64f( @Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div64f( @Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void div64f( @Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);

@Namespace("cv::hal") public static native void recip8u( @Cast("const uchar*") BytePointer arg0, @Cast("size_t") long arg1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip8u( @Cast("const uchar*") ByteBuffer arg0, @Cast("size_t") long arg1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip8u( @Cast("const uchar*") byte[] arg0, @Cast("size_t") long arg1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip8s( @Cast("const schar*") BytePointer arg0, @Cast("size_t") long arg1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip8s( @Cast("const schar*") ByteBuffer arg0, @Cast("size_t") long arg1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip8s( @Cast("const schar*") byte[] arg0, @Cast("size_t") long arg1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip16u( @Cast("const ushort*") ShortPointer arg0, @Cast("size_t") long arg1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip16u( @Cast("const ushort*") ShortBuffer arg0, @Cast("size_t") long arg1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip16u( @Cast("const ushort*") short[] arg0, @Cast("size_t") long arg1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip16s( @Const ShortPointer arg0, @Cast("size_t") long arg1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip16s( @Const ShortBuffer arg0, @Cast("size_t") long arg1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip16s( @Const short[] arg0, @Cast("size_t") long arg1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip32s( @Const IntPointer arg0, @Cast("size_t") long arg1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip32s( @Const IntBuffer arg0, @Cast("size_t") long arg1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip32s( @Const int[] arg0, @Cast("size_t") long arg1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip32f( @Const FloatPointer arg0, @Cast("size_t") long arg1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip32f( @Const FloatBuffer arg0, @Cast("size_t") long arg1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip32f( @Const float[] arg0, @Cast("size_t") long arg1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip64f( @Const DoublePointer arg0, @Cast("size_t") long arg1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip64f( @Const DoubleBuffer arg0, @Cast("size_t") long arg1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scale);
@Namespace("cv::hal") public static native void recip64f( @Const double[] arg0, @Cast("size_t") long arg1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer scale);

@Namespace("cv::hal") public static native void addWeighted8u( @Cast("const uchar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const uchar*") BytePointer src2, @Cast("size_t") long step2, @Cast("uchar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer _scalars );
@Namespace("cv::hal") public static native void addWeighted8u( @Cast("const uchar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const uchar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("uchar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer _scalars );
@Namespace("cv::hal") public static native void addWeighted8u( @Cast("const uchar*") byte[] src1, @Cast("size_t") long step1, @Cast("const uchar*") byte[] src2, @Cast("size_t") long step2, @Cast("uchar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer _scalars );
@Namespace("cv::hal") public static native void addWeighted8s( @Cast("const schar*") BytePointer src1, @Cast("size_t") long step1, @Cast("const schar*") BytePointer src2, @Cast("size_t") long step2, @Cast("schar*") BytePointer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted8s( @Cast("const schar*") ByteBuffer src1, @Cast("size_t") long step1, @Cast("const schar*") ByteBuffer src2, @Cast("size_t") long step2, @Cast("schar*") ByteBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted8s( @Cast("const schar*") byte[] src1, @Cast("size_t") long step1, @Cast("const schar*") byte[] src2, @Cast("size_t") long step2, @Cast("schar*") byte[] dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted16u( @Cast("const ushort*") ShortPointer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortPointer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted16u( @Cast("const ushort*") ShortBuffer src1, @Cast("size_t") long step1, @Cast("const ushort*") ShortBuffer src2, @Cast("size_t") long step2, @Cast("ushort*") ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted16u( @Cast("const ushort*") short[] src1, @Cast("size_t") long step1, @Cast("const ushort*") short[] src2, @Cast("size_t") long step2, @Cast("ushort*") short[] dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted16s( @Const ShortPointer src1, @Cast("size_t") long step1, @Const ShortPointer src2, @Cast("size_t") long step2, ShortPointer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted16s( @Const ShortBuffer src1, @Cast("size_t") long step1, @Const ShortBuffer src2, @Cast("size_t") long step2, ShortBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted16s( @Const short[] src1, @Cast("size_t") long step1, @Const short[] src2, @Cast("size_t") long step2, short[] dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted32s( @Const IntPointer src1, @Cast("size_t") long step1, @Const IntPointer src2, @Cast("size_t") long step2, IntPointer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted32s( @Const IntBuffer src1, @Cast("size_t") long step1, @Const IntBuffer src2, @Cast("size_t") long step2, IntBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted32s( @Const int[] src1, @Cast("size_t") long step1, @Const int[] src2, @Cast("size_t") long step2, int[] dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted32f( @Const FloatPointer src1, @Cast("size_t") long step1, @Const FloatPointer src2, @Cast("size_t") long step2, FloatPointer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted32f( @Const FloatBuffer src1, @Cast("size_t") long step1, @Const FloatBuffer src2, @Cast("size_t") long step2, FloatBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted32f( @Const float[] src1, @Cast("size_t") long step1, @Const float[] src2, @Cast("size_t") long step2, float[] dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted64f( @Const DoublePointer src1, @Cast("size_t") long step1, @Const DoublePointer src2, @Cast("size_t") long step2, DoublePointer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted64f( @Const DoubleBuffer src1, @Cast("size_t") long step1, @Const DoubleBuffer src2, @Cast("size_t") long step2, DoubleBuffer dst, @Cast("size_t") long step, int width, int height, Pointer scalars );
@Namespace("cv::hal") public static native void addWeighted64f( @Const double[] src1, @Cast("size_t") long step1, @Const double[] src2, @Cast("size_t") long step2, double[] dst, @Cast("size_t") long step, int width, int height, Pointer scalars );

@Namespace("cv::hal") public static native void cvt16f32f( @Const float16_t src, FloatPointer dst, int len );
@Namespace("cv::hal") public static native void cvt16f32f( @Const float16_t src, FloatBuffer dst, int len );
@Namespace("cv::hal") public static native void cvt16f32f( @Const float16_t src, float[] dst, int len );
@Namespace("cv::hal") public static native void cvt32f16f( @Const FloatPointer src, float16_t dst, int len );
@Namespace("cv::hal") public static native void cvt32f16f( @Const FloatBuffer src, float16_t dst, int len );
@Namespace("cv::hal") public static native void cvt32f16f( @Const float[] src, float16_t dst, int len );

@Namespace("cv::hal") public static native void addRNGBias32f( FloatPointer arr, @Const FloatPointer scaleBiasPairs, int len );
@Namespace("cv::hal") public static native void addRNGBias32f( FloatBuffer arr, @Const FloatBuffer scaleBiasPairs, int len );
@Namespace("cv::hal") public static native void addRNGBias32f( float[] arr, @Const float[] scaleBiasPairs, int len );
@Namespace("cv::hal") public static native void addRNGBias64f( DoublePointer arr, @Const DoublePointer scaleBiasPairs, int len );
@Namespace("cv::hal") public static native void addRNGBias64f( DoubleBuffer arr, @Const DoubleBuffer scaleBiasPairs, int len );
@Namespace("cv::hal") public static native void addRNGBias64f( double[] arr, @Const double[] scaleBiasPairs, int len );
// Targeting ..\opencv_core\DFT1D.java


// Targeting ..\opencv_core\DFT2D.java


// Targeting ..\opencv_core\DCT2D.java



/** \} core_hal */

//=============================================================================
// for binary compatibility with 3.0

/** \cond IGNORED */

@Namespace("cv::hal") public static native int LU(FloatPointer A, @Cast("size_t") long astep, int m, FloatPointer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU(FloatBuffer A, @Cast("size_t") long astep, int m, FloatBuffer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU(float[] A, @Cast("size_t") long astep, int m, float[] b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU(DoublePointer A, @Cast("size_t") long astep, int m, DoublePointer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU(DoubleBuffer A, @Cast("size_t") long astep, int m, DoubleBuffer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native int LU(double[] A, @Cast("size_t") long astep, int m, double[] b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky(FloatPointer A, @Cast("size_t") long astep, int m, FloatPointer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky(FloatBuffer A, @Cast("size_t") long astep, int m, FloatBuffer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky(float[] A, @Cast("size_t") long astep, int m, float[] b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky(DoublePointer A, @Cast("size_t") long astep, int m, DoublePointer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky(DoubleBuffer A, @Cast("size_t") long astep, int m, DoubleBuffer b, @Cast("size_t") long bstep, int n);
@Namespace("cv::hal") public static native @Cast("bool") boolean Cholesky(double[] A, @Cast("size_t") long astep, int m, double[] b, @Cast("size_t") long bstep, int n);

@Namespace("cv::hal") public static native void exp(@Const FloatPointer src, FloatPointer dst, int n);
@Namespace("cv::hal") public static native void exp(@Const FloatBuffer src, FloatBuffer dst, int n);
@Namespace("cv::hal") public static native void exp(@Const float[] src, float[] dst, int n);
@Namespace("cv::hal") public static native void exp(@Const DoublePointer src, DoublePointer dst, int n);
@Namespace("cv::hal") public static native void exp(@Const DoubleBuffer src, DoubleBuffer dst, int n);
@Namespace("cv::hal") public static native void exp(@Const double[] src, double[] dst, int n);
@Namespace("cv::hal") public static native void log(@Const FloatPointer src, FloatPointer dst, int n);
@Namespace("cv::hal") public static native void log(@Const FloatBuffer src, FloatBuffer dst, int n);
@Namespace("cv::hal") public static native void log(@Const float[] src, float[] dst, int n);
@Namespace("cv::hal") public static native void log(@Const DoublePointer src, DoublePointer dst, int n);
@Namespace("cv::hal") public static native void log(@Const DoubleBuffer src, DoubleBuffer dst, int n);
@Namespace("cv::hal") public static native void log(@Const double[] src, double[] dst, int n);

@Namespace("cv::hal") public static native void fastAtan2(@Const FloatPointer y, @Const FloatPointer x, FloatPointer dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void fastAtan2(@Const FloatBuffer y, @Const FloatBuffer x, FloatBuffer dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void fastAtan2(@Const float[] y, @Const float[] x, float[] dst, int n, @Cast("bool") boolean angleInDegrees);
@Namespace("cv::hal") public static native void magnitude(@Const FloatPointer x, @Const FloatPointer y, FloatPointer dst, int n);
@Namespace("cv::hal") public static native void magnitude(@Const FloatBuffer x, @Const FloatBuffer y, FloatBuffer dst, int n);
@Namespace("cv::hal") public static native void magnitude(@Const float[] x, @Const float[] y, float[] dst, int n);
@Namespace("cv::hal") public static native void magnitude(@Const DoublePointer x, @Const DoublePointer y, DoublePointer dst, int n);
@Namespace("cv::hal") public static native void magnitude(@Const DoubleBuffer x, @Const DoubleBuffer y, DoubleBuffer dst, int n);
@Namespace("cv::hal") public static native void magnitude(@Const double[] x, @Const double[] y, double[] dst, int n);
@Namespace("cv::hal") public static native void sqrt(@Const FloatPointer src, FloatPointer dst, int len);
@Namespace("cv::hal") public static native void sqrt(@Const FloatBuffer src, FloatBuffer dst, int len);
@Namespace("cv::hal") public static native void sqrt(@Const float[] src, float[] dst, int len);
@Namespace("cv::hal") public static native void sqrt(@Const DoublePointer src, DoublePointer dst, int len);
@Namespace("cv::hal") public static native void sqrt(@Const DoubleBuffer src, DoubleBuffer dst, int len);
@Namespace("cv::hal") public static native void sqrt(@Const double[] src, double[] dst, int len);
@Namespace("cv::hal") public static native void invSqrt(@Const FloatPointer src, FloatPointer dst, int len);
@Namespace("cv::hal") public static native void invSqrt(@Const FloatBuffer src, FloatBuffer dst, int len);
@Namespace("cv::hal") public static native void invSqrt(@Const float[] src, float[] dst, int len);
@Namespace("cv::hal") public static native void invSqrt(@Const DoublePointer src, DoublePointer dst, int len);
@Namespace("cv::hal") public static native void invSqrt(@Const DoubleBuffer src, DoubleBuffer dst, int len);
@Namespace("cv::hal") public static native void invSqrt(@Const double[] src, double[] dst, int len);

/** \endcond */

 //cv::hal

// #endif //OPENCV_HAL_HPP


// Parsed from <opencv2/core/fast_math.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Copyright (C) 2015, Itseez Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_FAST_MATH_HPP
// #define OPENCV_CORE_FAST_MATH_HPP

// #include "opencv2/core/cvdef.h"

/** \addtogroup core_utils
 *  \{
<p>
/****************************************************************************************\
*                                      fast math                                         *
\****************************************************************************************/

// #ifdef __cplusplus */
// #  include <cmath>
// #else
// #endif

// #if defined(__CUDACC__)
  // nothing, intrinsics/asm code is not supported
// #else
//   #if ((defined _MSC_VER && defined _M_X64)
//       || (defined __GNUC__ && defined __SSE2__))
//       && !defined(OPENCV_SKIP_INCLUDE_EMMINTRIN_H)
//     #include <emmintrin.h>
//   #endif

//   #if defined __PPC64__ && defined __GNUC__ && defined _ARCH_PWR8
//       && !defined(OPENCV_SKIP_INCLUDE_ALTIVEC_H)
//     #include <altivec.h>
//     #undef vector
//     #undef bool
//     #undef pixel
//   #endif

//   #if defined(CV_INLINE_ROUND_FLT)
    // user-specified version
    // CV_INLINE_ROUND_DBL should be defined too
//   #elif defined __GNUC__ && defined __arm__ && (defined __ARM_PCS_VFP || defined __ARM_VFPV3__ || defined __ARM_NEON__) && !defined __SOFTFP__
    // 1. general scheme
//     #define ARM_ROUND(_value, _asm_string)
//         int res;
//         float temp;
//         __asm__(_asm_string : [res] "=r" (res), [temp] "=w" (temp) : [value] "w" (_value));
//         return res
    // 2. version for double
//     #ifdef __clang__
//         #define CV_INLINE_ROUND_DBL(value) ARM_ROUND(value, "vcvtr.s32.f64 %[temp], %[value] \n vmov %[res], %[temp]")
//     #else
//         #define CV_INLINE_ROUND_DBL(value) ARM_ROUND(value, "vcvtr.s32.f64 %[temp], %P[value] \n vmov %[res], %[temp]")
//     #endif
    // 3. version for float
//     #define CV_INLINE_ROUND_FLT(value) ARM_ROUND(value, "vcvtr.s32.f32 %[temp], %[value]\n vmov %[res], %[temp]")
//   #elif defined __PPC64__ && defined __GNUC__ && defined _ARCH_PWR8
    // P8 and newer machines can convert fp32/64 to int quickly.
//     #define CV_INLINE_ROUND_DBL(value)
//         int out;
//         double temp;
//         __asm__( "fctiw %[temp],%[in]\n\tmfvsrwz %[out],%[temp]\n\t" : [out] "=r" (out), [temp] "=d" (temp) : [in] "d" ((double)(value)) : );
//         return out;

    // FP32 also works with FP64 routine above
//     #define CV_INLINE_ROUND_FLT(value) CV_INLINE_ROUND_DBL(value)
//   #endif

//   #ifdef CV_INLINE_ISINF_FLT
    // user-specified version
    // CV_INLINE_ISINF_DBL should be defined too
//   #elif defined __PPC64__ && defined _ARCH_PWR9 && defined(scalar_test_data_class)
//     #define CV_INLINE_ISINF_DBL(value) return scalar_test_data_class(value, 0x30);
//     #define CV_INLINE_ISINF_FLT(value) CV_INLINE_ISINF_DBL(value)
//   #endif

//   #ifdef CV_INLINE_ISNAN_FLT
    // user-specified version
    // CV_INLINE_ISNAN_DBL should be defined too
//   #elif defined __PPC64__ && defined _ARCH_PWR9 && defined(scalar_test_data_class)
//     #define CV_INLINE_ISNAN_DBL(value) return scalar_test_data_class(value, 0x40);
//     #define CV_INLINE_ISNAN_FLT(value) CV_INLINE_ISNAN_DBL(value)
//   #endif

//   #if !defined(OPENCV_USE_FASTMATH_BUILTINS)
//     && (
//         defined(__x86_64__) || defined(__i686__)
//         || defined(__arm__)
//         || defined(__PPC64__)
//     )
    /* Let builtin C math functions when available. Dedicated hardware is available to
       round and convert FP values. */
    public static final int OPENCV_USE_FASTMATH_BUILTINS = 1;
//   #endif

  /* Enable builtin math functions if possible, desired, and available.
     Note, not all math functions inline equally. E.g lrint will not inline
     without the -fno-math-errno option. */
//   #if defined(CV_ICC)
    // nothing
//   #elif defined(OPENCV_USE_FASTMATH_BUILTINS) && OPENCV_USE_FASTMATH_BUILTINS
//     #if defined(__clang__)
//     #elif defined(__GNUC__)
//     #elif defined(_MSC_VER)
//     #endif
//   #endif

// #endif // defined(__CUDACC__)

/** \brief Rounds floating-point number to the nearest integer
 <p>
 @param value floating-point number. If the value is outside of INT_MIN ... INT_MAX range, the
 result is not defined.
 */
public static native int cvRound( double value );


/** \brief Rounds floating-point number to the nearest integer not larger than the original.
 <p>
 The function computes an integer i such that:
 <pre>{@code \[i \le \texttt{value} < i+1\]}</pre>
 @param value floating-point number. If the value is outside of INT_MIN ... INT_MAX range, the
 result is not defined.
 */
public static native int cvFloor( double value );

/** \brief Rounds floating-point number to the nearest integer not smaller than the original.
 <p>
 The function computes an integer i such that:
 <pre>{@code \[i \le \texttt{value} < i+1\]}</pre>
 @param value floating-point number. If the value is outside of INT_MIN ... INT_MAX range, the
 result is not defined.
 */
public static native int cvCeil( double value );

/** \brief Determines if the argument is Not A Number.
 <p>
 @param value The input floating-point value
 <p>
 The function returns 1 if the argument is Not A Number (as defined by IEEE754 standard), 0
 otherwise. */
public static native int cvIsNaN( double value );

/** \brief Determines if the argument is Infinity.
 <p>
 @param value The input floating-point value
 <p>
 The function returns 1 if the argument is a plus or minus infinity (as defined by IEEE754 standard)
 and 0 otherwise. */
public static native int cvIsInf( double value );

// #ifdef __cplusplus

/** \overload */
public static native int cvRound(float value);

/** \overload */
public static native int cvRound( int value );

/** \overload */
public static native int cvFloor( float value );

/** \overload */
public static native int cvFloor( int value );

/** \overload */
public static native int cvCeil( float value );

/** \overload */
public static native int cvCeil( int value );

/** \overload */
public static native int cvIsNaN( float value );

/** \overload */
public static native int cvIsInf( float value );

// #endif // __cplusplus

/** \} core_utils */

// #endif


// Parsed from <opencv2/core/saturate.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Copyright (C) 2014, Itseez Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_SATURATE_HPP
// #define OPENCV_CORE_SATURATE_HPP

// #include "opencv2/core/cvdef.h"
// #include <climits>
// #include "opencv2/core/fast_math.hpp"

/** \addtogroup core_utils
 *  \{
<p>
/////////////// saturate_cast (used in image & signal processing) ///////////////////
<p>
/** \brief Template function for accurate conversion from one primitive type to another.
 <p>
 The function saturate_cast resembles the standard C++ cast operations, such as static_cast\<T\>()
 and others. It perform an efficient and accurate conversion from one primitive type to another
 (see the introduction chapter). saturate in the name means that when the input value v is out of the
 range of the target type, the result is not formed just by taking low bits of the input, but instead
 the value is clipped. For example:
 <pre>{@code
 uchar a = saturate_cast<uchar>(-100); // a = 0 (UCHAR_MIN)
 short b = saturate_cast<short>(33333.33333); // b = 32767 (SHRT_MAX)
 }</pre>
 Such clipping is done when the target type is unsigned char , signed char , unsigned short or
 signed short . For 32-bit integers, no clipping is done.
 <p>
 When the parameter is a floating-point value and the target type is an integer (8-, 16- or 32-bit),
 the floating-point value is first rounded to the nearest integer and then clipped if needed (when
 the target type is 8- or 16-bit).
 <p>
 @param v Function parameter.
 @see add, subtract, multiply, divide, Mat::convertTo
 */
@Namespace("cv") public static native @Cast("uchar") @Name("saturate_cast<uchar>") byte ucharSaturateCast(@Cast("uchar") byte v);
@Namespace("cv") public static native @Cast("schar") @Name("saturate_cast<schar>") byte scharSaturateCast(@Cast("uchar") byte v);
@Namespace("cv") public static native @Cast("ushort") @Name("saturate_cast<ushort>") short ushortSaturateCast(@Cast("uchar") byte v);
@Namespace("cv") public static native @Name("saturate_cast<short>") short shortSaturateCast(@Cast("uchar") byte v);
@Namespace("cv") public static native @Name("saturate_cast<int>") int intSaturate(@Cast("uchar") byte v);
@Namespace("cv") public static native @Cast("unsigned") @Name("saturate_cast<unsigned>") int unsignedSaturateCast(@Cast("uchar") byte v);
@Namespace("cv") public static native @Cast("uint64") @Name("saturate_cast<uint64>") long uint64SaturateCast(@Cast("uchar") byte v);
@Namespace("cv") public static native @Cast("int64") @Name("saturate_cast<int64>") long int64SaturateCast(@Cast("uchar") byte v);
@Namespace("cv") public static native @ByVal @Name("saturate_cast<cv::float16_t>") float16_t float16SaturateCast(@Cast("uchar") byte v);
/** \overload */
/** \overload */
@Namespace("cv") public static native @Cast("uchar") @Name("saturate_cast<uchar>") byte ucharSaturateCast(@Cast("ushort") short v);
@Namespace("cv") public static native @Cast("schar") @Name("saturate_cast<schar>") byte scharSaturateCast(@Cast("ushort") short v);
@Namespace("cv") public static native @Cast("ushort") @Name("saturate_cast<ushort>") short ushortSaturateCast(@Cast("ushort") short v);
@Namespace("cv") public static native @Name("saturate_cast<short>") short shortSaturateCast(@Cast("ushort") short v);
@Namespace("cv") public static native @Name("saturate_cast<int>") int intSaturate(@Cast("ushort") short v);
@Namespace("cv") public static native @Cast("unsigned") @Name("saturate_cast<unsigned>") int unsignedSaturateCast(@Cast("ushort") short v);
@Namespace("cv") public static native @Cast("uint64") @Name("saturate_cast<uint64>") long uint64SaturateCast(@Cast("ushort") short v);
@Namespace("cv") public static native @Cast("int64") @Name("saturate_cast<int64>") long int64SaturateCast(@Cast("ushort") short v);
@Namespace("cv") public static native @ByVal @Name("saturate_cast<cv::float16_t>") float16_t float16SaturateCast(@Cast("ushort") short v);
/** \overload */
/** \overload */
@Namespace("cv") public static native @Cast("uchar") @Name("saturate_cast<uchar>") byte ucharSaturateCast(@Cast("unsigned") int v);
@Namespace("cv") public static native @Cast("schar") @Name("saturate_cast<schar>") byte scharSaturateCast(@Cast("unsigned") int v);
@Namespace("cv") public static native @Cast("ushort") @Name("saturate_cast<ushort>") short ushortSaturateCast(@Cast("unsigned") int v);
@Namespace("cv") public static native @Name("saturate_cast<short>") short shortSaturateCast(@Cast("unsigned") int v);
@Namespace("cv") public static native @Name("saturate_cast<int>") int intSaturate(@Cast("unsigned") int v);
@Namespace("cv") public static native @Cast("unsigned") @Name("saturate_cast<unsigned>") int unsignedSaturateCast(@Cast("unsigned") int v);
@Namespace("cv") public static native @Cast("uint64") @Name("saturate_cast<uint64>") long uint64SaturateCast(@Cast("unsigned") int v);
@Namespace("cv") public static native @Cast("int64") @Name("saturate_cast<int64>") long int64SaturateCast(@Cast("unsigned") int v);
@Namespace("cv") public static native @ByVal @Name("saturate_cast<cv::float16_t>") float16_t float16SaturateCast(@Cast("unsigned") int v);
/** \overload */
/** \overload */
@Namespace("cv") public static native @Cast("uchar") @Name("saturate_cast<uchar>") byte ucharSaturateCast(float v);
@Namespace("cv") public static native @Cast("schar") @Name("saturate_cast<schar>") byte scharSaturateCast(float v);
@Namespace("cv") public static native @Cast("ushort") @Name("saturate_cast<ushort>") short ushortSaturateCast(float v);
@Namespace("cv") public static native @Name("saturate_cast<short>") short shortSaturateCast(float v);
@Namespace("cv") public static native @Name("saturate_cast<int>") int intSaturate(float v);
@Namespace("cv") public static native @Cast("unsigned") @Name("saturate_cast<unsigned>") int unsignedSaturateCast(float v);
@Namespace("cv") public static native @Cast("uint64") @Name("saturate_cast<uint64>") long uint64SaturateCast(float v);
@Namespace("cv") public static native @Cast("int64") @Name("saturate_cast<int64>") long int64SaturateCast(float v);
@Namespace("cv") public static native @ByVal @Name("saturate_cast<cv::float16_t>") float16_t float16SaturateCast(float v);
/** \overload */
@Namespace("cv") public static native @Cast("uchar") @Name("saturate_cast<uchar>") byte ucharSaturateCast(double v);
@Namespace("cv") public static native @Cast("schar") @Name("saturate_cast<schar>") byte scharSaturateCast(double v);
@Namespace("cv") public static native @Cast("ushort") @Name("saturate_cast<ushort>") short ushortSaturateCast(double v);
@Namespace("cv") public static native @Name("saturate_cast<short>") short shortSaturateCast(double v);
@Namespace("cv") public static native @Name("saturate_cast<int>") int intSaturate(double v);
@Namespace("cv") public static native @Cast("unsigned") @Name("saturate_cast<unsigned>") int unsignedSaturateCast(double v);
@Namespace("cv") public static native @Cast("uint64") @Name("saturate_cast<uint64>") long uint64SaturateCast(double v);
@Namespace("cv") public static native @Cast("int64") @Name("saturate_cast<int64>") long int64SaturateCast(double v);
@Namespace("cv") public static native @ByVal @Name("saturate_cast<cv::float16_t>") float16_t float16SaturateCast(double v);
/** \overload */
@Namespace("cv") public static native @Cast("uchar") @Name("saturate_cast<uchar>") byte ucharSaturateCast(@Cast("int64") long v);
@Namespace("cv") public static native @Cast("schar") @Name("saturate_cast<schar>") byte scharSaturateCast(@Cast("int64") long v);
@Namespace("cv") public static native @Cast("ushort") @Name("saturate_cast<ushort>") short ushortSaturateCast(@Cast("int64") long v);
@Namespace("cv") public static native @Name("saturate_cast<short>") short shortSaturateCast(@Cast("int64") long v);
@Namespace("cv") public static native @Name("saturate_cast<int>") int intSaturate(@Cast("int64") long v);
@Namespace("cv") public static native @Cast("unsigned") @Name("saturate_cast<unsigned>") int unsignedSaturateCast(@Cast("int64") long v);
@Namespace("cv") public static native @Cast("uint64") @Name("saturate_cast<uint64>") long uint64SaturateCast(@Cast("int64") long v);
@Namespace("cv") public static native @Cast("int64") @Name("saturate_cast<int64>") long int64SaturateCast(@Cast("int64") long v);
@Namespace("cv") public static native @ByVal @Name("saturate_cast<cv::float16_t>") float16_t float16SaturateCast(@Cast("int64") long v);
/** \overload */
// we intentionally do not clip negative numbers, to make -1 become 0xffffffff etc.

/** \overload */
@Namespace("cv") public static native @Cast("uchar") @Name("saturate_cast<uchar>") byte ucharSaturateCast(@ByVal float16_t v);
@Namespace("cv") public static native @Cast("schar") @Name("saturate_cast<schar>") byte scharSaturateCast(@ByVal float16_t v);
@Namespace("cv") public static native @Cast("ushort") @Name("saturate_cast<ushort>") short ushortSaturateCast(@ByVal float16_t v);
@Namespace("cv") public static native @Name("saturate_cast<short>") short shortSaturateCast(@ByVal float16_t v);
@Namespace("cv") public static native @Name("saturate_cast<int>") int intSaturate(@ByVal float16_t v);
@Namespace("cv") public static native @Cast("unsigned") @Name("saturate_cast<unsigned>") int unsignedSaturateCast(@ByVal float16_t v);
@Namespace("cv") public static native @Cast("uint64") @Name("saturate_cast<uint64>") long uint64SaturateCast(@ByVal float16_t v);
@Namespace("cv") public static native @Cast("int64") @Name("saturate_cast<int64>") long int64SaturateCast(@ByVal float16_t v);
@Namespace("cv") public static native @ByVal @Name("saturate_cast<cv::float16_t>") float16_t float16SaturateCast(@ByVal float16_t v);

// in theory, we could use a LUT for 8u/8s->16f conversion,
// but with hardware support for FP32->FP16 conversion the current approach is preferable

/** \} */

 // cv

// #endif // OPENCV_CORE_SATURATE_HPP


// Parsed from <opencv2/core/version.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef OPENCV_VERSION_HPP
// #define OPENCV_VERSION_HPP

public static final int CV_VERSION_MAJOR =    4;
public static final int CV_VERSION_MINOR =    9;
public static final int CV_VERSION_REVISION = 0;
public static final String CV_VERSION_STATUS =   "";

// #define CVAUX_STR_EXP(__A)  #__A
// #define CVAUX_STR(__A)      CVAUX_STR_EXP(__A)

// #define CVAUX_STRW_EXP(__A)  L ## #__A
// #define CVAUX_STRW(__A)      CVAUX_STRW_EXP(__A)

public static native @MemberGetter String CV_VERSION();
public static final String CV_VERSION = CV_VERSION();

/* old  style version constants*/
public static final int CV_MAJOR_VERSION =    CV_VERSION_MAJOR;
public static final int CV_MINOR_VERSION =    CV_VERSION_MINOR;
public static final int CV_SUBMINOR_VERSION = CV_VERSION_REVISION;

// #endif // OPENCV_VERSION_HPP


// Parsed from <opencv2/core/base.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Copyright (C) 2014, Itseez Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_BASE_HPP
// #define OPENCV_CORE_BASE_HPP

// #ifndef __cplusplus
// #endif

// #include "opencv2/opencv_modules.hpp"

// #include <climits>
// #include <algorithm>

// #include "opencv2/core/cvdef.h"
// #include "opencv2/core/cvstd.hpp"

/** \addtogroup core_utils
 *  \{ */
/** error codes */
/** enum cv::Error::Code */
public static final int
    /** everything is ok */
    StsOk = 0,
    /** pseudo error for back trace */
    StsBackTrace = -1,
    /** unknown /unspecified error */
    StsError = -2,
    /** internal error (bad state) */
    StsInternal = -3,
    /** insufficient memory */
    StsNoMem = -4,
    /** function arg/param is bad */
    StsBadArg = -5,
    /** unsupported function */
    StsBadFunc = -6,
    /** iteration didn't converge */
    StsNoConv = -7,
    /** tracing */
    StsAutoTrace = -8,
    /** image header is NULL */
    HeaderIsNull = -9,
    /** image size is invalid */
    BadImageSize = -10,
    /** offset is invalid */
    BadOffset = -11,
    //!<
    BadDataPtr = -12,
    /** image step is wrong, this may happen for a non-continuous matrix. */
    BadStep = -13,
    //!<
    BadModelOrChSeq = -14,
    /** bad number of channels, for example, some functions accept only single channel matrices. */
    BadNumChannels = -15,
    //!<
    BadNumChannel1U = -16,
    /** input image depth is not supported by the function */
    BadDepth = -17,
    //!<
    BadAlphaChannel = -18,
    /** number of dimensions is out of range */
    BadOrder = -19,
    /** incorrect input origin */
    BadOrigin = -20,
    /** incorrect input align */
    BadAlign = -21,
    //!<
    BadCallBack = -22,
    //!<
    BadTileSize = -23,
    /** input COI is not supported */
    BadCOI = -24,
    /** incorrect input roi */
    BadROISize = -25,
    //!<
    MaskIsTiled = -26,
    /** null pointer */
    StsNullPtr = -27,
    /** incorrect vector length */
    StsVecLengthErr = -28,
    /** incorrect filter structure content */
    StsFilterStructContentErr = -29,
    /** incorrect transform kernel content */
    StsKernelStructContentErr = -30,
    /** incorrect filter offset value */
    StsFilterOffsetErr = -31,
    /** the input/output structure size is incorrect */
    StsBadSize = -201,
    /** division by zero */
    StsDivByZero = -202,
    /** in-place operation is not supported */
    StsInplaceNotSupported = -203,
    /** request can't be completed */
    StsObjectNotFound = -204,
    /** formats of input/output arrays differ */
    StsUnmatchedFormats = -205,
    /** flag is wrong or not supported */
    StsBadFlag = -206,
    /** bad CvPoint */
    StsBadPoint = -207,
    /** bad format of mask (neither 8uC1 nor 8sC1) */
    StsBadMask = -208,
    /** sizes of input/output structures do not match */
    StsUnmatchedSizes = -209,
    /** the data format/type is not supported by the function */
    StsUnsupportedFormat = -210,
    /** some of parameters are out of range */
    StsOutOfRange = -211,
    /** invalid syntax/structure of the parsed file */
    StsParseError = -212,
    /** the requested function/feature is not implemented */
    StsNotImplemented = -213,
    /** an allocated block has been corrupted */
    StsBadMemBlock = -214,
    /** assertion failed */
    StsAssert = -215,
    /** no CUDA support */
    GpuNotSupported = -216,
    /** GPU API call error */
    GpuApiCallError = -217,
    /** no OpenGL support */
    OpenGlNotSupported = -218,
    /** OpenGL API call error */
    OpenGlApiCallError = -219,
    /** OpenCL API call error */
    OpenCLApiCallError = -220,
    OpenCLDoubleNotSupported = -221,
    /** OpenCL initialization error */
    OpenCLInitError = -222,
    OpenCLNoAMDBlasFft = -223;
 //Error

/** \} core_utils
 <p>
 *  \addtogroup core_array
 *  \{
 <p>
 *  matrix decomposition types */
/** enum cv::DecompTypes */
public static final int
    /** Gaussian elimination with the optimal pivot element chosen. */
    DECOMP_LU       = 0,
    /** singular value decomposition (SVD) method; the system can be over-defined and/or the matrix
    src1 can be singular */
    DECOMP_SVD      = 1,
    /** eigenvalue decomposition; the matrix src1 must be symmetrical */
    DECOMP_EIG      = 2,
    /** Cholesky {@code LL^T} factorization; the matrix src1 must be symmetrical and positively
    defined */
    DECOMP_CHOLESKY = 3,
    /** QR factorization; the system can be over-defined and/or the matrix src1 can be singular */
    DECOMP_QR       = 4,
    /** while all the previous flags are mutually exclusive, this flag can be used together with
    any of the previous; it means that the normal equations
    {@code \texttt{src1}^T\cdot\texttt{src1}\cdot\texttt{dst}=\texttt{src1}^T\texttt{src2}} are
    solved instead of the original system
    {@code \texttt{src1}\cdot\texttt{dst}=\texttt{src2}} */
    DECOMP_NORMAL   = 16;

/** norm types
<p>
src1 and src2 denote input arrays.
*/

/** enum cv::NormTypes */
public static final int
                /**
                <pre>{@code \[
                norm =  \forkthree
                {\|\texttt{src1}\|_{L_{\infty}} =  \max _I | \texttt{src1} (I)|}{if  \(\texttt{normType} = \texttt{NORM_INF}\) }
                {\|\texttt{src1}-\texttt{src2}\|_{L_{\infty}} =  \max _I | \texttt{src1} (I) -  \texttt{src2} (I)|}{if  \(\texttt{normType} = \texttt{NORM_INF}\) }
                {\frac{\|\texttt{src1}-\texttt{src2}\|_{L_{\infty}}    }{\|\texttt{src2}\|_{L_{\infty}} }}{if  \(\texttt{normType} = \texttt{NORM_RELATIVE | NORM_INF}\) }
                \]}</pre>
                */
                NORM_INF       = 1,
                /**
                <pre>{@code \[
                norm =  \forkthree
                {\| \texttt{src1} \| _{L_1} =  \sum _I | \texttt{src1} (I)|}{if  \(\texttt{normType} = \texttt{NORM_L1}\)}
                { \| \texttt{src1} - \texttt{src2} \| _{L_1} =  \sum _I | \texttt{src1} (I) -  \texttt{src2} (I)|}{if  \(\texttt{normType} = \texttt{NORM_L1}\) }
                { \frac{\|\texttt{src1}-\texttt{src2}\|_{L_1} }{\|\texttt{src2}\|_{L_1}} }{if  \(\texttt{normType} = \texttt{NORM_RELATIVE | NORM_L1}\) }
                \]}</pre>*/
                 NORM_L1        = 2,
                 /**
                 <pre>{@code \[
                 norm =  \forkthree
                 { \| \texttt{src1} \| _{L_2} =  \sqrt{\sum_I \texttt{src1}(I)^2} }{if  \(\texttt{normType} = \texttt{NORM_L2}\) }
                 { \| \texttt{src1} - \texttt{src2} \| _{L_2} =  \sqrt{\sum_I (\texttt{src1}(I) - \texttt{src2}(I))^2} }{if  \(\texttt{normType} = \texttt{NORM_L2}\) }
                 { \frac{\|\texttt{src1}-\texttt{src2}\|_{L_2} }{\|\texttt{src2}\|_{L_2}} }{if  \(\texttt{normType} = \texttt{NORM_RELATIVE | NORM_L2}\) }
                 \]}</pre>
                 */
                 NORM_L2        = 4,
                 /**
                 <pre>{@code \[
                 norm =  \forkthree
                 { \| \texttt{src1} \| _{L_2} ^{2} = \sum_I \texttt{src1}(I)^2} {if  \(\texttt{normType} = \texttt{NORM_L2SQR}\)}
                 { \| \texttt{src1} - \texttt{src2} \| _{L_2} ^{2} =  \sum_I (\texttt{src1}(I) - \texttt{src2}(I))^2 }{if  \(\texttt{normType} = \texttt{NORM_L2SQR}\) }
                 { \left(\frac{\|\texttt{src1}-\texttt{src2}\|_{L_2} }{\|\texttt{src2}\|_{L_2}}\right)^2 }{if  \(\texttt{normType} = \texttt{NORM_RELATIVE | NORM_L2SQR}\) }
                 \]}</pre>
                 */
                 NORM_L2SQR     = 5,
                 /**
                 In the case of one input array, calculates the Hamming distance of the array from zero,
                 In the case of two input arrays, calculates the Hamming distance between the arrays.
                 */
                 NORM_HAMMING   = 6,
                 /**
                 Similar to NORM_HAMMING, but in the calculation, each two bits of the input sequence will
                 be added and treated as a single bit to be used in the same calculation as NORM_HAMMING.
                 */
                 NORM_HAMMING2  = 7,
                 /** bit-mask which can be used to separate norm type from norm flags */
                 NORM_TYPE_MASK = 7,
                 /** flag */
                 NORM_RELATIVE  = 8,
                 /** flag */
                 NORM_MINMAX    = 32;

/** comparison types */
/** enum cv::CmpTypes */
public static final int /** src1 is equal to src2. */
 CMP_EQ = 0,
                /** src1 is greater than src2. */
                CMP_GT = 1,
                /** src1 is greater than or equal to src2. */
                CMP_GE = 2,
                /** src1 is less than src2. */
                CMP_LT = 3,
                /** src1 is less than or equal to src2. */
                CMP_LE = 4,
                /** src1 is unequal to src2. */
                CMP_NE = 5;

/** generalized matrix multiplication flags */
/** enum cv::GemmFlags */
public static final int /** transposes src1 */
 GEMM_1_T = 1,
                 /** transposes src2 */
                 GEMM_2_T = 2,
                 /** transposes src3 */
                 GEMM_3_T = 4;

/** enum cv::DftFlags */
public static final int
    /** performs an inverse 1D or 2D transform instead of the default forward
        transform. */
    DFT_INVERSE        = 1,
    /** scales the result: divide it by the number of array elements. Normally, it is
        combined with DFT_INVERSE. */
    DFT_SCALE          = 2,
    /** performs a forward or inverse transform of every individual row of the input
        matrix; this flag enables you to transform multiple vectors simultaneously and can be used to
        decrease the overhead (which is sometimes several times larger than the processing itself) to
        perform 3D and higher-dimensional transformations and so forth.*/
    DFT_ROWS           = 4,
    /** performs a forward transformation of 1D or 2D real array; the result,
        though being a complex array, has complex-conjugate symmetry (*CCS*, see the function
        description below for details), and such an array can be packed into a real array of the same
        size as input, which is the fastest option and which is what the function does by default;
        however, you may wish to get a full complex array (for simpler spectrum analysis, and so on) -
        pass the flag to enable the function to produce a full-size complex output array. */
    DFT_COMPLEX_OUTPUT = 16,
    /** performs an inverse transformation of a 1D or 2D complex array; the
        result is normally a complex array of the same size, however, if the input array has
        conjugate-complex symmetry (for example, it is a result of forward transformation with
        DFT_COMPLEX_OUTPUT flag), the output is a real array; while the function itself does not
        check whether the input is symmetrical or not, you can pass the flag and then the function
        will assume the symmetry and produce the real output array (note that when the input is packed
        into a real array and inverse transformation is executed, the function treats the input as a
        packed complex-conjugate symmetrical array, and the output will also be a real array). */
    DFT_REAL_OUTPUT    = 32,
    /** specifies that input is complex input. If this flag is set, the input must have 2 channels.
        On the other hand, for backwards compatibility reason, if input has 2 channels, input is
        already considered complex. */
    DFT_COMPLEX_INPUT  = 64,
    /** performs an inverse 1D or 2D transform instead of the default forward transform. */
    DCT_INVERSE        = DFT_INVERSE,
    /** performs a forward or inverse transform of every individual row of the input
        matrix. This flag enables you to transform multiple vectors simultaneously and can be used to
        decrease the overhead (which is sometimes several times larger than the processing itself) to
        perform 3D and higher-dimensional transforms and so forth.*/
    DCT_ROWS           = DFT_ROWS;

/** Various border types, image boundaries are denoted with {@code |}
 *  @see borderInterpolate, copyMakeBorder */
/** enum cv::BorderTypes */
public static final int
    /** {@code iiiiii|abcdefgh|iiiiiii}  with some specified {@code i} */
    BORDER_CONSTANT    = 0,
    /** {@code aaaaaa|abcdefgh|hhhhhhh} */
    BORDER_REPLICATE   = 1,
    /** {@code fedcba|abcdefgh|hgfedcb} */
    BORDER_REFLECT     = 2,
    /** {@code cdefgh|abcdefgh|abcdefg} */
    BORDER_WRAP        = 3,
    /** {@code gfedcb|abcdefgh|gfedcba} */
    BORDER_REFLECT_101 = 4,
    /** {@code uvwxyz|abcdefgh|ijklmno} */
    BORDER_TRANSPARENT = 5,

    /** same as BORDER_REFLECT_101 */
    BORDER_REFLECT101  = BORDER_REFLECT_101,
    /** same as BORDER_REFLECT_101 */
    BORDER_DEFAULT     = BORDER_REFLECT_101,
    /** do not look outside of ROI */
    BORDER_ISOLATED    = 16;

/** \} core_array
 <p>
 *  \addtogroup core_utils
 *  \{
<p>
/** \brief Signals an error and raises the exception.
<p>
By default the function prints information about the error to stderr,
then it either stops if setBreakOnError() had been called before or raises the exception.
It is possible to alternate error processing by using redirectError().
@param _code - error code (Error::Code)
@param _err - error description
@param _func - function name. Available only when the compiler supports getting it
@param _file - source file name where the error has occurred
@param _line - line number in the source file where the error has occurred
@see CV_Error, CV_Error_, CV_Assert, CV_DbgAssert
 */
/* nothing by default */ @Namespace("cv") public static native void error(int _code, @Str BytePointer _err, @Cast("const char*") BytePointer _func, @Cast("const char*") BytePointer _file, int _line);
@Namespace("cv") public static native void error(int _code, @Str String _err, String _func, String _file, int _line);

// #ifdef CV_STATIC_ANALYSIS

// In practice, some macro are not processed correctly (noreturn is not detected).
// We need to use simplified definition for them.
// #define CV_Error(code, msg) do { (void)(code); (void)(msg); abort(); } while (0)
// #define CV_Error_(code, args) do { (void)(code); (void)(cv::format args); abort(); } while (0)
// #define CV_Assert( expr ) do { if (!(expr)) abort(); } while (0)

// #else // CV_STATIC_ANALYSIS

// #endif // CV_STATIC_ANALYSIS

/** \cond IGNORED */
// #if !defined(__OPENCV_BUILD)  // TODO: backward compatibility only
// #ifndef CV_ErrorNoReturn
// #define CV_ErrorNoReturn CV_Error
// #endif
// #ifndef CV_ErrorNoReturn_
// #define CV_ErrorNoReturn_ CV_Error_
// #endif
// #endif

// #define CV_Assert_1 CV_Assert
// #define CV_Assert_2( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_1( __VA_ARGS__ ))
// #define CV_Assert_3( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_2( __VA_ARGS__ ))
// #define CV_Assert_4( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_3( __VA_ARGS__ ))
// #define CV_Assert_5( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_4( __VA_ARGS__ ))
// #define CV_Assert_6( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_5( __VA_ARGS__ ))
// #define CV_Assert_7( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_6( __VA_ARGS__ ))
// #define CV_Assert_8( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_7( __VA_ARGS__ ))
// #define CV_Assert_9( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_8( __VA_ARGS__ ))
// #define CV_Assert_10( expr, ... ) CV_Assert_1(expr); __CV_EXPAND(CV_Assert_9( __VA_ARGS__ ))

// #define CV_Assert_N(...) do { __CV_EXPAND(__CV_CAT(CV_Assert_, __CV_VA_NUM_ARGS(__VA_ARGS__)) (__VA_ARGS__)); } while(0)

/** \endcond */

// #if defined _DEBUG || defined CV_STATIC_ANALYSIS
// #  define CV_DbgAssert(expr) CV_Assert(expr)
// #else
/** replaced with CV_Assert(expr) in Debug configuration */
// #  define CV_DbgAssert(expr)
// Targeting ..\opencv_core\Hamming.java



/////////////////////////////////// inline norms ////////////////////////////////////
@Namespace("cv") public static native int cv_abs(@Cast("uchar") byte x);
@Namespace("cv") public static native int cv_abs(@Cast("ushort") short x);















/** \brief Computes the cube root of an argument.
 <p>
 The function cubeRoot computes {@code \sqrt[3]{\texttt{val}}}. Negative arguments are handled correctly.
 NaN and Inf are not handled. The accuracy approaches the maximum possible accuracy for
 single-precision data.
 @param val A function argument.
 */
@Namespace("cv") public static native float cubeRoot(float val);

/** \overload
<p>
cubeRoot with argument of {@code double} type calls {@code std::cbrt(double)}
*/
@Namespace("cv") public static native double cubeRoot(double val);

/** \brief Calculates the angle of a 2D vector in degrees.
 <p>
 The function fastAtan2 calculates the full-range angle of an input 2D vector. The angle is measured
 in degrees and varies from 0 to 360 degrees. The accuracy is about 0.3 degrees.
 @param x x-coordinate of the vector.
 @param y y-coordinate of the vector.
 */
@Namespace("cv") public static native float fastAtan2(float y, float x);

/** proxy for hal::LU */
/** proxy for hal::LU */
/** proxy for hal::Cholesky */
/** proxy for hal::Cholesky */

////////////////// forward declarations for important OpenCV types //////////////////

/** \cond IGNORED */
// Targeting ..\opencv_core\Buffer.java


// Targeting ..\opencv_core\Texture2D.java


// Targeting ..\opencv_core\Arrays.java





@Namespace("cv::ipp") public static native @Cast("unsigned long long") long getIppFeatures();
@Namespace("cv::ipp") public static native void setIppStatus(int status, @Cast("const char*") BytePointer funcname/*=NULL*/, @Cast("const char*") BytePointer filename/*=NULL*/,
                             int line/*=0*/);
@Namespace("cv::ipp") public static native void setIppStatus(int status);
@Namespace("cv::ipp") public static native void setIppStatus(int status, String funcname/*=NULL*/, String filename/*=NULL*/,
                             int line/*=0*/);
@Namespace("cv::ipp") public static native int getIppStatus();
@Namespace("cv::ipp") public static native @Str BytePointer getIppErrorLocation();
@Namespace("cv::ipp") public static native @Cast("bool") boolean useIPP();
@Namespace("cv::ipp") public static native void setUseIPP(@Cast("bool") boolean flag);
@Namespace("cv::ipp") public static native @Str BytePointer getIppVersion();

// IPP Not-Exact mode. This function may force use of IPP then both IPP and OpenCV provide proper results
// but have internal accuracy differences which have too much direct or indirect impact on accuracy tests.
@Namespace("cv::ipp") public static native @Cast("bool") boolean useIPP_NotExact();
@Namespace("cv::ipp") public static native void setUseIPP_NotExact(@Cast("bool") boolean flag);
// #ifndef DISABLE_OPENCV_3_COMPATIBILITY
@Namespace("cv::ipp") public static native @Cast("bool") boolean useIPP_NE();
@Namespace("cv::ipp") public static native void setUseIPP_NE(@Cast("bool") boolean flag);
// #endif

 // ipp

/** \endcond
 <p>
 *  \} core_utils */




 // cv

// #include "opencv2/core/neon_utils.hpp"
// #include "opencv2/core/vsx_utils.hpp"
// #include "opencv2/core/check.hpp"

// #endif //OPENCV_CORE_BASE_HPP


// Parsed from <opencv2/core/cvstd.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_CVSTD_HPP
// #define OPENCV_CORE_CVSTD_HPP

// #ifndef __cplusplus
// #endif

// #include "opencv2/core/cvdef.h"
// #include <cstddef>
// #include <cstring>
// #include <cctype>

// #include <string>

// import useful primitives from stl
// #  include <algorithm>
// #  include <utility>
// #  include <cstdlib> //for abs(int)
// #  include <cmath>
    @Namespace("cv") public static native @Cast("uchar") byte abs(@Cast("uchar") byte a);
    @Namespace("cv") public static native @Cast("ushort") short abs(@Cast("ushort") short a);
    @Namespace("cv") public static native @Cast("unsigned") int abs(@Cast("unsigned") int a);
    @Namespace("cv") public static native @Cast("uint64") long abs(@Cast("uint64") long a);


// #include "cvstd_wrapper.hpp"

/** \addtogroup core_utils
 *  \{
<p>
//////////////////////////// memory management functions ////////////////////////////
<p>
/** \brief Allocates an aligned memory buffer.
<p>
The function allocates the buffer of the specified size and returns it. When the buffer size is 16
bytes or more, the returned buffer is aligned to 16 bytes.
@param bufSize Allocated buffer size.
 */
@Namespace("cv") public static native Pointer fastMalloc(@Cast("size_t") long bufSize);

/** \brief Deallocates a memory buffer.
<p>
The function deallocates the buffer allocated with fastMalloc . If NULL pointer is passed, the
function does nothing. C version of the function clears the pointer *pptr* to avoid problems with
double memory deallocation.
@param ptr Pointer to the allocated buffer.
 */
@Namespace("cv") public static native void fastFree(Pointer ptr);

/**
  The STL-compliant memory Allocator based on cv::fastMalloc() and cv::fastFree()
*/

/** \} core_utils
 <p>
 *  \endcond
 <p>
 *  \addtogroup core_basic
 *  \{
<p>
//////////////////////////////// string class //////////////////////////////// */ //for string constructor from FileNode

// #ifndef OPENCV_DISABLE_STRING_LOWER_UPPER_CONVERSIONS

/** \cond IGNORED */
// std::tolower is int->int
@Namespace("cv::details") public static native @Cast("char") byte char_tolower(@Cast("char") byte ch);
// std::toupper is int->int
@Namespace("cv::details") public static native @Cast("char") byte char_toupper(@Cast("char") byte ch);
 // namespace details
/** \endcond */

@Namespace("cv") public static native @StdString BytePointer toLowerCase(@StdString BytePointer str);
@Namespace("cv") public static native @StdString String toLowerCase(@StdString String str);

@Namespace("cv") public static native @StdString BytePointer toUpperCase(@StdString BytePointer str);
@Namespace("cv") public static native @StdString String toUpperCase(@StdString String str);

// #endif // OPENCV_DISABLE_STRING_LOWER_UPPER_CONVERSIONS

/** \} core_basic */
 // cv

// #endif //OPENCV_CORE_CVSTD_HPP


// Parsed from <opencv2/core/utility.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Copyright (C) 2015, Itseez Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_UTILITY_H
// #define OPENCV_CORE_UTILITY_H

// #ifndef __cplusplus
// #endif

// #if defined(check)
// #  warning Detected Apple 'check' macro definition, it can cause build conflicts. Please, include this header before any Apple headers.
// #endif

// #include "opencv2/core.hpp"
// #include <ostream>

// #include <functional>

// #if !defined(_M_CEE)
// #include <mutex>  // std::mutex, std::lock_guard
// #endif

/** \addtogroup core_utils
 *  \{
<p>
/** \brief  Automatically Allocated Buffer Class
 <p>
 The class is used for temporary buffers in functions and methods.
 If a temporary buffer is usually small (a few K's of memory),
 but its size depends on the parameters, it makes sense to create a small
 fixed-size array on stack and use it if it's large enough. If the required buffer size
 is larger than the fixed size, another buffer of sufficient size is allocated dynamically
 and released after the processing. Therefore, in typical cases, when the buffer size is small,
 there is no overhead associated with malloc()/free().
 At the same time, there is no limit on the size of processed data.
 <p>
 This is what AutoBuffer does. The template takes 2 parameters - type of the buffer elements and
 the number of stack-allocated elements. Here is how the class is used:
 <p>
 <pre>{@code
 void my_func(const cv::Mat& m)
 {
    cv::AutoBuffer<float> buf(1000); // create automatic buffer containing 1000 floats

    buf.allocate(m.rows); // if m.rows <= 1000, the pre-allocated buffer is used,
                          // otherwise the buffer of "m.rows" floats will be allocated
                          // dynamically and deallocated in cv::AutoBuffer destructor
    ...
 }
 }</pre>
*/
// #ifdef OPENCV_ENABLE_MEMORY_SANITIZER */
// #else

/**  \brief Sets/resets the break-on-error mode.
<p>
When the break-on-error mode is set, the default error handler issues a hardware exception, which
can make debugging more convenient.
<p>
@return the previous state
 */
@Namespace("cv") public static native @Cast("bool") boolean setBreakOnError(@Cast("bool") boolean flag);
// Targeting ..\opencv_core\ErrorCallback.java




/** \brief Sets the new error handler and the optional user data.
  <p>
  The function sets the new error handler, called from cv::error().
  <p>
  @param errCallback the new error handler. If NULL, the default error handler is used.
  @param userdata the optional user data pointer, passed to the callback.
  @param prevUserdata the optional output parameter where the previous user data pointer is stored
  <p>
  @return the previous error handler
*/
@Namespace("cv") public static native ErrorCallback redirectError( ErrorCallback errCallback, Pointer userdata/*=0*/, @Cast("void**") PointerPointer prevUserdata/*=0*/);
@Namespace("cv") public static native ErrorCallback redirectError( ErrorCallback errCallback);
@Namespace("cv") public static native ErrorCallback redirectError( ErrorCallback errCallback, Pointer userdata/*=0*/, @Cast("void**") @ByPtrPtr Pointer prevUserdata/*=0*/);

@Namespace("cv") public static native @Str BytePointer tempfile( @Cast("const char*") BytePointer suffix/*=0*/);
@Namespace("cv") public static native @Str BytePointer tempfile();
@Namespace("cv") public static native @Str String tempfile( String suffix/*=0*/);
@Namespace("cv") public static native void glob(@Str BytePointer pattern, @ByRef StringVector result, @Cast("bool") boolean recursive/*=false*/);
@Namespace("cv") public static native void glob(@Str BytePointer pattern, @ByRef StringVector result);
@Namespace("cv") public static native void glob(@Str String pattern, @ByRef StringVector result, @Cast("bool") boolean recursive/*=false*/);
@Namespace("cv") public static native void glob(@Str String pattern, @ByRef StringVector result);

/** \brief OpenCV will try to set the number of threads for subsequent parallel regions.
<p>
If threads == 1, OpenCV will disable threading optimizations and run all it's functions
sequentially. Passing threads \< 0 will reset threads number to system default.
The function is not thread-safe. It must not be called in parallel region or concurrent threads.
<p>
OpenCV will try to run its functions with specified threads number, but some behaviour differs from
framework:
-   {@code TBB} - User-defined parallel constructions will run with the same threads number, if
    another is not specified. If later on user creates his own scheduler, OpenCV will use it.
-   {@code OpenMP} - No special defined behaviour.
-   {@code Concurrency} - If threads == 1, OpenCV will disable threading optimizations and run its
    functions sequentially.
-   {@code GCD} - Supports only values \<= 0.
-   {@code C=} - No special defined behaviour.
@param nthreads Number of threads used by OpenCV.
@see getNumThreads, getThreadNum
 */
@Namespace("cv") public static native void setNumThreads(int nthreads);

/** \brief Returns the number of threads used by OpenCV for parallel regions.
<p>
Always returns 1 if OpenCV is built without threading support.
<p>
The exact meaning of return value depends on the threading framework used by OpenCV library:
- {@code TBB} - The number of threads, that OpenCV will try to use for parallel regions. If there is
  any tbb::thread_scheduler_init in user code conflicting with OpenCV, then function returns
  default number of threads used by TBB library.
- {@code OpenMP} - An upper bound on the number of threads that could be used to form a new team.
- {@code Concurrency} - The number of threads, that OpenCV will try to use for parallel regions.
- {@code GCD} - Unsupported; returns the GCD thread pool limit (512) for compatibility.
- {@code C=} - The number of threads, that OpenCV will try to use for parallel regions, if before
  called setNumThreads with threads \> 0, otherwise returns the number of logical CPUs,
  available for the process.
@see setNumThreads, getThreadNum
 */
@Namespace("cv") public static native int getNumThreads();

/** \brief Returns the index of the currently executed thread within the current parallel region. Always
returns 0 if called outside of parallel region.
<p>
@deprecated Current implementation doesn't corresponding to this documentation.
<p>
The exact meaning of the return value depends on the threading framework used by OpenCV library:
- {@code TBB} - Unsupported with current 4.1 TBB release. Maybe will be supported in future.
- {@code OpenMP} - The thread number, within the current team, of the calling thread.
- {@code Concurrency} - An ID for the virtual processor that the current context is executing on (0
  for master thread and unique number for others, but not necessary 1,2,3,...).
- {@code GCD} - System calling thread's ID. Never returns 0 inside parallel region.
- {@code C=} - The index of the current parallel task.
@see setNumThreads, getNumThreads
 */
@Namespace("cv") public static native int getThreadNum();

/** \brief Returns full configuration time cmake output.
<p>
Returned value is raw cmake output including version control system revision, compiler version,
compiler flags, enabled modules and third party libraries, etc. Output format depends on target
architecture.
 */
@Namespace("cv") public static native @Str BytePointer getBuildInformation();

/** \brief Returns library version string
<p>
For example "3.4.1-dev".
<p>
@see getMajorVersion, getMinorVersion, getRevisionVersion
*/
@Namespace("cv") public static native @Str BytePointer getVersionString();

/** \brief Returns major library version */
@Namespace("cv") public static native int getVersionMajor();

/** \brief Returns minor library version */
@Namespace("cv") public static native int getVersionMinor();

/** \brief Returns revision field of the library version */
@Namespace("cv") public static native int getVersionRevision();

/** \brief Returns the number of ticks.
<p>
The function returns the number of ticks after the certain event (for example, when the machine was
turned on). It can be used to initialize RNG or to measure a function execution time by reading the
tick count before and after the function call.
@see getTickFrequency, TickMeter
 */
@Namespace("cv") public static native @Cast("int64") long getTickCount();

/** \brief Returns the number of ticks per second.
<p>
The function returns the number of ticks per second. That is, the following code computes the
execution time in seconds:
<pre>{@code
    double t = (double)getTickCount();
    // do something ...
    t = ((double)getTickCount() - t)/getTickFrequency();
}</pre>
@see getTickCount, TickMeter
 */
@Namespace("cv") public static native double getTickFrequency();
// Targeting ..\opencv_core\TickMeter.java



/** \brief output operator
<pre>{@code
TickMeter tm;
tm.start();
// do something ...
tm.stop();
std::cout << tm;
}</pre>
*/

@Namespace("cv") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, @Const @ByRef TickMeter tm);

/** \brief Returns the number of CPU ticks.
<p>
The function returns the current number of CPU ticks on some architectures (such as x86, x64,
PowerPC). On other platforms the function is equivalent to getTickCount. It can also be used for
very accurate time measurements, as well as for RNG initialization. Note that in case of multi-CPU
systems a thread, from which getCPUTickCount is called, can be suspended and resumed at another CPU
with its own counter. So, theoretically (and practically) the subsequent calls to the function do
not necessary return the monotonously increasing values. Also, since a modern CPU varies the CPU
frequency depending on the load, the number of CPU clocks spent in some code cannot be directly
converted to time units. Therefore, getTickCount is generally a preferable solution for measuring
execution time.
 */
@Namespace("cv") public static native @Cast("int64") long getCPUTickCount();

/** \brief Returns true if the specified feature is supported by the host hardware.
<p>
The function returns true if the host hardware supports the specified feature. When user calls
setUseOptimized(false), the subsequent calls to checkHardwareSupport() will return false until
setUseOptimized(true) is called. This way user can dynamically switch on and off the optimized code
in OpenCV.
@param feature The feature of interest, one of cv::CpuFeatures
 */
@Namespace("cv") public static native @Cast("bool") boolean checkHardwareSupport(int feature);

/** \brief Returns feature name by ID
<p>
Returns empty string if feature is not defined
*/
@Namespace("cv") public static native @Str BytePointer getHardwareFeatureName(int feature);

/** \brief Returns list of CPU features enabled during compilation.
<p>
Returned value is a string containing space separated list of CPU features with following markers:
<p>
- no markers - baseline features
- prefix {@code *} - features enabled in dispatcher
- suffix {@code ?} - features enabled but not available in HW
<p>
Example: {@code SSE SSE2 SSE3 *SSE4.1 *SSE4.2 *FP16 *AVX *AVX2 *AVX512-SKX?}
*/
@Namespace("cv") public static native @StdString BytePointer getCPUFeaturesLine();

/** \brief Returns the number of logical CPUs available for the process.
 */
@Namespace("cv") public static native int getNumberOfCPUs();


/** \brief Aligns a pointer to the specified number of bytes.
<p>
The function returns the aligned pointer of the same type as the input pointer:
<pre>{@code \[\texttt{(_Tp*)(((size_t)ptr + n-1) & -n)}\]}</pre>
@param ptr Aligned pointer.
@param n Alignment size that must be a power of two.
 */

/** \brief Aligns a buffer size to the specified number of bytes.
<p>
The function returns the minimum number that is greater than or equal to sz and is divisible by n :
<pre>{@code \[\texttt{(sz + n-1) & -n}\]}</pre>
@param sz Buffer size to align.
@param n Alignment size that must be a power of two.
 */
@Namespace("cv") public static native @Cast("size_t") long alignSize(@Cast("size_t") long sz, int n);

/** \brief Integer division with result round up.
<p>
Use this function instead of {@code ceil((float)a / b)} expressions.
<p>
@see alignSize
*/
@Namespace("cv") public static native int divUp(int a, @Cast("unsigned int") int b);
/** \overload */
@Namespace("cv") public static native @Cast("size_t") long divUp(@Cast("size_t") long a, @Cast("unsigned int") int b);

/** \brief Round first value up to the nearest multiple of second value.
<p>
Use this function instead of {@code ceil((float)a / b) * b} expressions.
<p>
@see divUp
*/
@Namespace("cv") public static native int roundUp(int a, @Cast("unsigned int") int b);
/** \overload */
@Namespace("cv") public static native @Cast("size_t") long roundUp(@Cast("size_t") long a, @Cast("unsigned int") int b);

/** \brief Alignment check of passed values
<p>
Usage: {@code isAligned<sizeof(int)>(...)}
<p>
\note Alignment(N) must be a power of 2 (2**k, 2^k)
*/
/** \overload */
/** \overload */
/** \overload */
/** \overload */

/** \brief Enables or disables the optimized code.
<p>
The function can be used to dynamically turn on and off optimized dispatched code (code that uses SSE4.2, AVX/AVX2,
and other instructions on the platforms that support it). It sets a global flag that is further
checked by OpenCV functions. Since the flag is not checked in the inner OpenCV loops, it is only
safe to call the function on the very top level in your application where you can be sure that no
other OpenCV function is currently executed.
<p>
By default, the optimized code is enabled unless you disable it in CMake. The current status can be
retrieved using useOptimized.
@param onoff The boolean flag specifying whether the optimized code should be used (onoff=true)
or not (onoff=false).
 */
@Namespace("cv") public static native void setUseOptimized(@Cast("bool") boolean onoff);

/** \brief Returns the status of optimized code usage.
<p>
The function returns true if the optimized code is enabled. Otherwise, it returns false.
 */
@Namespace("cv") public static native @Cast("bool") boolean useOptimized();

@Namespace("cv") public static native @Cast("size_t") long getElemSize(int type);
// Targeting ..\opencv_core\ParallelLoopBody.java



/** \brief Parallel data processor
<p>
\ingroup core_parallel
*/
@Namespace("cv") public static native void parallel_for_(@Const @ByRef Range range, @Const @ByRef ParallelLoopBody body, double nstripes/*=-1.*/);
@Namespace("cv") public static native void parallel_for_(@Const @ByRef Range range, @Const @ByRef ParallelLoopBody body);
// Targeting ..\opencv_core\ParallelLoopBodyLambdaWrapper.java



/** \ingroup core_parallel */
@Namespace("cv") public static native void parallel_for_(@Const @ByRef Range range, @ByVal Functor functor, double nstripes/*=-1.*/);
@Namespace("cv") public static native void parallel_for_(@Const @ByRef Range range, @ByVal Functor functor);


/////////////////////////////// forEach method of cv::Mat ////////////////////////////


/////////////////////////// Synchronization Primitives ///////////////////////////////

// #if !defined(_M_CEE)
// #ifndef OPENCV_DISABLE_THREAD_SUPPORT
// Targeting ..\opencv_core\Mutex.java


// Targeting ..\opencv_core\AutoLock.java


// #endif // OPENCV_DISABLE_THREAD_SUPPORT
// #endif // !defined(_M_CEE)


/** \brief Designed for command line parsing
<p>
The sample below demonstrates how to use CommandLineParser:
<pre>{@code
    CommandLineParser parser(argc, argv, keys);
    parser.about("Application name v1.0.0");

    if (parser.has("help"))
    {
        parser.printMessage();
        return 0;
    }

    int N = parser.get<int>("N");
    double fps = parser.get<double>("fps");
    String path = parser.get<String>("path");

    use_time_stamp = parser.has("timestamp");

    String img1 = parser.get<String>(0);
    String img2 = parser.get<String>(1);

    int repeat = parser.get<int>(2);

    if (!parser.check())
    {
        parser.printErrors();
        return 0;
    }
}</pre>
<p>
### Keys syntax
<p>
The keys parameter is a string containing several blocks, each one is enclosed in curly braces and
describes one argument. Each argument contains three parts separated by the {@code |} symbol:
<p>
-# argument names is a space-separated list of option synonyms (to mark argument as positional, prefix it with the {@code @} symbol)
-# default value will be used if the argument was not provided (can be empty)
-# help message (can be empty)
<p>
For example:
<p>
<pre>{@code {.cpp}
    const String keys =
        "{help h usage ? |      | print this message   }"
        "{@image1        |      | image1 for compare   }"
        "{@image2        |<none>| image2 for compare   }"
        "{@repeat        |1     | number               }"
        "{path           |.     | path to file         }"
        "{fps            | -1.0 | fps for output video }"
        "{N count        |100   | count of objects     }"
        "{ts timestamp   |      | use time stamp       }"
        ;
}
}</pre>
<p>
Note that there are no default values for {@code help} and {@code timestamp} so we can check their presence using the {@code has()} method.
Arguments with default values are considered to be always present. Use the {@code get()} method in these cases to check their
actual value instead.
<p>
String keys like {@code get<String>("@image1")} return the empty string {@code ""} by default - even with an empty default value.
Use the special {@code <none>} default value to enforce that the returned string must not be empty. (like in {@code get<String>("@image2")})
<p>
### Usage
<p>
For the described keys:
<p>
<pre>{@code {.sh}
    # Good call (3 positional parameters: image1, image2 and repeat; N is 200, ts is true)
    $ ./app -N=200 1.png 2.jpg 19 -ts

    # Bad call
    $ ./app -fps=aaa
    ERRORS:
    Parameter 'fps': can not convert: [aaa] to [double]
}</pre>
 */

/** \} core_utils
 <p>
 *  \cond IGNORED
<p>
/////////////////////////////// AutoBuffer implementation //////////////////////////////////////// */


















// Targeting ..\opencv_core\InstrNode.java



/** \addtogroup core_utils_samples */
// This section describes utility functions for OpenCV samples.
//
// @note Implementation of these utilities is not thread-safe.
//
/** \{
<p>
/** \brief Try to find requested data file
<p>
Search directories:
<p>
1. Directories passed via {@code addSamplesDataSearchPath()}
2. OPENCV_SAMPLES_DATA_PATH_HINT environment variable
3. OPENCV_SAMPLES_DATA_PATH environment variable
   If parameter value is not empty and nothing is found then stop searching.
4. Detects build/install path based on:
   a. current working directory (CWD)
   b. and/or binary module location (opencv_core/opencv_world, doesn't work with static linkage)
5. Scan {@code <source>/{,data,samples/data}} directories if build directory is detected or the current directory is in source tree.
6. Scan {@code <install>/share/OpenCV} directory if install directory is detected.
<p>
@see cv::utils::findDataFile
<p>
@param relative_path Relative path to data file
@param required Specify "file not found" handling.
       If true, function prints information message and raises cv::Exception.
       If false, function returns empty result
@param silentMode Disables messages
@return Returns path (absolute or relative to the current directory) or empty string if file is not found
*/
@Namespace("cv::samples") public static native @Str BytePointer findFile(@Str BytePointer relative_path, @Cast("bool") boolean required/*=true*/, @Cast("bool") boolean silentMode/*=false*/);
@Namespace("cv::samples") public static native @Str BytePointer findFile(@Str BytePointer relative_path);
@Namespace("cv::samples") public static native @Str String findFile(@Str String relative_path, @Cast("bool") boolean required/*=true*/, @Cast("bool") boolean silentMode/*=false*/);
@Namespace("cv::samples") public static native @Str String findFile(@Str String relative_path);

@Namespace("cv::samples") public static native @Str BytePointer findFileOrKeep(@Str BytePointer relative_path, @Cast("bool") boolean silentMode/*=false*/);
@Namespace("cv::samples") public static native @Str BytePointer findFileOrKeep(@Str BytePointer relative_path);
@Namespace("cv::samples") public static native @Str String findFileOrKeep(@Str String relative_path, @Cast("bool") boolean silentMode/*=false*/);
@Namespace("cv::samples") public static native @Str String findFileOrKeep(@Str String relative_path);

/** \brief Override search data path by adding new search location
<p>
Use this only to override default behavior
Passed paths are used in LIFO order.
<p>
@param path Path to used samples data
*/
@Namespace("cv::samples") public static native void addSamplesDataSearchPath(@Str BytePointer path);
@Namespace("cv::samples") public static native void addSamplesDataSearchPath(@Str String path);

/** \brief Append samples search data sub directory
<p>
General usage is to add OpenCV modules name ({@code <opencv_contrib>/modules/<name>/samples/data} -> {@code <name>/samples/data} + {@code modules/<name>/samples/data}).
Passed subdirectories are used in LIFO order.
<p>
@param subdir samples data sub directory
*/
@Namespace("cv::samples") public static native void addSamplesDataSearchSubDirectory(@Str BytePointer subdir);
@Namespace("cv::samples") public static native void addSamplesDataSearchSubDirectory(@Str String subdir);

/** \} */
 // namespace samples

@Namespace("cv::utils") public static native int getThreadID();

 // namespace

 //namespace cv

// #ifdef CV_COLLECT_IMPL_DATA
// #else
/** Collect implementation data on OpenCV function call. Requires ENABLE_IMPL_COLLECTION build option. */
// #define CV_IMPL_ADD(impl)
// #endif

// #endif //OPENCV_CORE_UTILITY_H


// Parsed from <opencv2/core/utils/instrumentation.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef OPENCV_UTILS_INSTR_HPP
// #define OPENCV_UTILS_INSTR_HPP

// #include <opencv2/core/utility.hpp>
// #include <opencv2/core/utils/tls.hpp>

/** \addtogroup core_utils
 *  \{ */

// #ifdef CV_COLLECT_IMPL_DATA
// #endif

// Instrumentation external interface

// #if !defined OPENCV_ABI_CHECK

/** enum cv::instr::TYPE */
public static final int
    TYPE_GENERAL = 0,   // OpenCV API function, e.g. exported function
    TYPE_MARKER = 1,        // Information marker
    TYPE_WRAPPER = 2,       // Wrapper function for implementation
    TYPE_FUN = 3;           // Simple function call

/** enum cv::instr::IMPL */
public static final int
    IMPL_PLAIN = 0,
    IMPL_IPP = 1,
    IMPL_OPENCL = 2;
// Targeting ..\opencv_core\NodeDataTls.java


// Targeting ..\opencv_core\NodeData.java


@Namespace("cv::instr") public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef NodeData lhs, @Const @ByRef NodeData rhs);

@Namespace("cv::instr") public static native InstrNode getTrace();

// #endif // !defined OPENCV_ABI_CHECK


@Namespace("cv::instr") public static native @Cast("bool") boolean useInstrumentation();
@Namespace("cv::instr") public static native void setUseInstrumentation(@Cast("bool") boolean flag);
@Namespace("cv::instr") public static native void resetTrace();

/** enum cv::instr::FLAGS */
public static final int
    FLAGS_NONE              = 0,
    FLAGS_MAPPING           = 0x01,
    FLAGS_EXPAND_SAME_NAMES = 0x02;

@Namespace("cv::instr") public static native void setFlags(@Cast("cv::instr::FLAGS") int modeFlags);
@Namespace("cv::instr") public static native @Cast("cv::instr::FLAGS") int getFlags();

 // namespace instr

/** \} */

 // namespace

// #endif // OPENCV_UTILS_TLS_HPP


// Parsed from <opencv2/core/utils/tls.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef OPENCV_UTILS_TLS_HPP
// #define OPENCV_UTILS_TLS_HPP

// #ifndef OPENCV_CORE_UTILITY_H
// #error "tls.hpp must be included after opencv2/core/utility.hpp or opencv2/core.hpp"
// #endif
// Targeting ..\opencv_core\TlsStorage.java

 
// Targeting ..\opencv_core\TLSDataContainer.java


// Targeting ..\opencv_core\NodeDataTlsData.java




/** TLS data accumulator with gathering methods */


/** \} */

 // namespace

// #endif // OPENCV_UTILS_TLS_HPP


// Parsed from <opencv2/core/types_c.h>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_TYPES_H
// #define OPENCV_CORE_TYPES_H

// #ifdef CV__ENABLE_C_API_CTORS  // invalid C API ctors (must be removed)
// #if defined(_WIN32) && !defined(CV__SKIP_MESSAGE_MALFORMED_C_API_CTORS)
// #error "C API ctors don't work on Win32: https://github.com/opencv/opencv/issues/15990"
// #endif
// #endif

//#define CV__VALIDATE_UNUNITIALIZED_VARS 1  // C++11 & GCC only

// #ifdef __cplusplus

// #ifdef CV__VALIDATE_UNUNITIALIZED_VARS
// #pragma GCC diagnostic ignored "-Wmissing-field-initializers"
public static native @MemberGetter int CV_STRUCT_INITIALIZER();
public static final int CV_STRUCT_INITIALIZER = CV_STRUCT_INITIALIZER();
// #else
// #if defined(__GNUC__) && __GNUC__ == 4  // GCC 4.x warns on "= {}" initialization, fixed in GCC 5.0
// #pragma GCC diagnostic ignored "-Wmissing-field-initializers"
// #endif
// #endif

// #else
// #endif


// #ifdef HAVE_IPL
// #  ifndef __IPL_H__
// #    if defined _WIN32
// #      include <ipl.h>
// #    else
// #      include <ipl/ipl.h>
// #    endif
// #  endif
// #elif defined __IPL_H__
// #  define HAVE_IPL
// #endif

// #include "opencv2/core/cvdef.h"

// #ifndef SKIP_INCLUDES
// #include <assert.h>
// #include <stdlib.h>
// #include <string.h>
// #include <float.h>
// #endif // SKIP_INCLUDES

// #if defined _WIN32
// #  define CV_CDECL __cdecl
// #  define CV_STDCALL __stdcall
// #else
// #  define CV_CDECL
// #  define CV_STDCALL
// #endif

// #ifndef CV_DEFAULT
// #  ifdef __cplusplus
// #    define CV_DEFAULT(val) = val
// #  else
// #  endif
// #endif

// #ifndef CV_EXTERN_C_FUNCPTR
// #  ifdef __cplusplus
// #    define CV_EXTERN_C_FUNCPTR(x) extern "C" { typedef x; }
// #  else
// #  endif
// #endif

// #ifndef CVAPI
// #  define CVAPI(rettype) CV_EXTERN_C CV_EXPORTS rettype CV_CDECL
// #endif

// #ifndef CV_IMPL
// #  define CV_IMPL CV_EXTERN_C
// #endif

// #ifdef __cplusplus
// #  include "opencv2/core.hpp"
// #endif

/** \addtogroup core_c
    \{
*/

/** \brief This is the "metatype" used *only* as a function parameter.
<p>
It denotes that the function accepts arrays of multiple types, such as IplImage*, CvMat* or even
CvSeq* sometimes. The particular array type is determined at runtime by analyzing the first 4
bytes of the header. In C++ interface the role of CvArr is played by InputArray and OutputArray.
 */

/** @see cv::Error::Code */
/** enum  */
public static final int
 /** everything is ok                */
 CV_StsOk = 0,
 /** pseudo error for back trace     */
 CV_StsBackTrace = -1,
 /** unknown /unspecified error      */
 CV_StsError = -2,
 /** internal error (bad state)      */
 CV_StsInternal = -3,
 /** insufficient memory             */
 CV_StsNoMem = -4,
 /** function arg/param is bad       */
 CV_StsBadArg = -5,
 /** unsupported function            */
 CV_StsBadFunc = -6,
 /** iter. didn't converge           */
 CV_StsNoConv = -7,
 /** tracing                         */
 CV_StsAutoTrace = -8,
 /** image header is NULL            */
 CV_HeaderIsNull = -9,
 /** image size is invalid           */
 CV_BadImageSize = -10,
 /** offset is invalid               */
 CV_BadOffset = -11,
 CV_BadDataPtr = -12,  /**/
 /** image step is wrong, this may happen for a non-continuous matrix */
 CV_BadStep = -13,
 CV_BadModelOrChSeq = -14,  /**/
 /** bad number of channels, for example, some functions accept only single channel matrices */
 CV_BadNumChannels = -15,
 CV_BadNumChannel1U = -16,  /**/
 /** input image depth is not supported by the function */
 CV_BadDepth = -17,
 CV_BadAlphaChannel = -18,  /**/
 /** number of dimensions is out of range */
 CV_BadOrder = -19,
 /** incorrect input origin               */
 CV_BadOrigin = -20,
 /** incorrect input align                */
 CV_BadAlign = -21,
 CV_BadCallBack = -22,  /**/
 CV_BadTileSize = -23,  /**/
 /** input COI is not supported           */
 CV_BadCOI = -24,
 /** incorrect input roi                  */
 CV_BadROISize = -25,
 CV_MaskIsTiled = -26,  /**/
 /** null pointer */
 CV_StsNullPtr = -27,
 /** incorrect vector length */
 CV_StsVecLengthErr = -28,
 /** incorrect filter structure content */
 CV_StsFilterStructContentErr = -29,
 /** incorrect transform kernel content */
 CV_StsKernelStructContentErr = -30,
 /** incorrect filter offset value */
 CV_StsFilterOffsetErr = -31,
 /** the input/output structure size is incorrect  */
 CV_StsBadSize = -201,
 /** division by zero */
 CV_StsDivByZero = -202,
 /** in-place operation is not supported */
 CV_StsInplaceNotSupported = -203,
 /** request can't be completed */
 CV_StsObjectNotFound = -204,
 /** formats of input/output arrays differ */
 CV_StsUnmatchedFormats = -205,
 /** flag is wrong or not supported */
 CV_StsBadFlag = -206,
 /** bad CvPoint */
 CV_StsBadPoint = -207,
 /** bad format of mask (neither 8uC1 nor 8sC1)*/
 CV_StsBadMask = -208,
 /** sizes of input/output structures do not match */
 CV_StsUnmatchedSizes = -209,
 /** the data format/type is not supported by the function*/
 CV_StsUnsupportedFormat = -210,
 /** some of parameters are out of range */
 CV_StsOutOfRange = -211,
 /** invalid syntax/structure of the parsed file */
 CV_StsParseError = -212,
 /** the requested function/feature is not implemented */
 CV_StsNotImplemented = -213,
 /** an allocated block has been corrupted */
 CV_StsBadMemBlock = -214,
 /** assertion failed   */
 CV_StsAssert = -215,
 /** no CUDA support    */
 CV_GpuNotSupported = -216,
 /** GPU API call error */
 CV_GpuApiCallError = -217,
 /** no OpenGL support  */
 CV_OpenGlNotSupported = -218,
 /** OpenGL API call error */
 CV_OpenGlApiCallError = -219,
 /** OpenCL API call error */
 CV_OpenCLApiCallError = -220,
 CV_OpenCLDoubleNotSupported = -221,
 /** OpenCL initialization error */
 CV_OpenCLInitError = -222,
 CV_OpenCLNoAMDBlasFft = -223;

/****************************************************************************************\
*                             Common macros and inline functions                         *
\****************************************************************************************/

// #define CV_SWAP(a,b,t) ((t) = (a), (a) = (b), (b) = (t))

/** min & max without jumps */
// #define  CV_IMIN(a, b)  ((a) ^ (((a)^(b)) & (((a) < (b)) - 1)))

// #define  CV_IMAX(a, b)  ((a) ^ (((a)^(b)) & (((a) > (b)) - 1)))

/** absolute value without jumps */
// #ifndef __cplusplus
// #else
// #  define  CV_IABS(a)     abs(a)
// #endif
// #define  CV_CMP(a,b)    (((a) > (b)) - ((a) < (b)))
// #define  CV_SIGN(a)     CV_CMP((a),0)

// #define cvInvSqrt(value) ((float)(1./sqrt(value)))
// #define cvSqrt(value)  ((float)sqrt(value))


/*************** Random number generation *******************/

public static final long CV_RNG_COEFF = 4164903690L;

/** \brief Initializes a random number generator state.
<p>
The function initializes a random number generator and returns the state. The pointer to the state
can be then passed to the cvRandInt, cvRandReal and cvRandArr functions. In the current
implementation a multiply-with-carry generator is used.
@param seed 64-bit value used to initiate a random sequence
@see the C++ class RNG replaced CvRNG.
 */
public static native @Cast("CvRNG") long cvRNG( @Cast("int64") long seed/*=-1*/);
public static native @Cast("CvRNG") long cvRNG();

/** \brief Returns a 32-bit unsigned integer and updates RNG.
<p>
The function returns a uniformly-distributed random 32-bit unsigned integer and updates the RNG
state. It is similar to the rand() function from the C runtime library, except that OpenCV functions
always generates a 32-bit random number, regardless of the platform.
@param rng CvRNG state initialized by cvRNG.
 */
public static native @Cast("unsigned") int cvRandInt( @Cast("CvRNG*") LongPointer rng );
public static native @Cast("unsigned") int cvRandInt( @Cast("CvRNG*") LongBuffer rng );
public static native @Cast("unsigned") int cvRandInt( @Cast("CvRNG*") long[] rng );

/** \brief Returns a floating-point random number and updates RNG.
<p>
The function returns a uniformly-distributed random floating-point number between 0 and 1 (1 is not
included).
@param rng RNG state initialized by cvRNG
 */
public static native double cvRandReal( @Cast("CvRNG*") LongPointer rng );
public static native double cvRandReal( @Cast("CvRNG*") LongBuffer rng );
public static native double cvRandReal( @Cast("CvRNG*") long[] rng );

/****************************************************************************************\
*                                  Image type (IplImage)                                 *
\****************************************************************************************/

// #ifndef HAVE_IPL

/*
 * The following definitions (until #endif)
 * is an extract from IPL headers.
 * Copyright (c) 1995 Intel Corporation.
 */
public static final int IPL_DEPTH_SIGN = 0x80000000;

public static final int IPL_DEPTH_1U =     1;
public static final int IPL_DEPTH_8U =     8;
public static final int IPL_DEPTH_16U =   16;
public static final int IPL_DEPTH_32F =   32;

public static final int IPL_DEPTH_8S =  (IPL_DEPTH_SIGN| 8);
public static final int IPL_DEPTH_16S = (IPL_DEPTH_SIGN|16);
public static final int IPL_DEPTH_32S = (IPL_DEPTH_SIGN|32);

public static final int IPL_DATA_ORDER_PIXEL =  0;
public static final int IPL_DATA_ORDER_PLANE =  1;

public static final int IPL_ORIGIN_TL = 0;
public static final int IPL_ORIGIN_BL = 1;

public static final int IPL_ALIGN_4BYTES =   4;
public static final int IPL_ALIGN_8BYTES =   8;
public static final int IPL_ALIGN_16BYTES = 16;
public static final int IPL_ALIGN_32BYTES = 32;

public static final int IPL_ALIGN_DWORD =   IPL_ALIGN_4BYTES;
public static final int IPL_ALIGN_QWORD =   IPL_ALIGN_8BYTES;

public static final int IPL_BORDER_CONSTANT =   0;
public static final int IPL_BORDER_REPLICATE =  1;
public static final int IPL_BORDER_REFLECT =    2;
public static final int IPL_BORDER_WRAP =       3;

// #ifdef __cplusplus
public static native @ByVal IplImage cvIplImage(@Const @ByRef Mat m);
// Targeting ..\opencv_core\IplImage.java



public static native @ByVal IplImage cvIplImage();
// Targeting ..\opencv_core\IplTileInfo.java


// Targeting ..\opencv_core\IplROI.java


// Targeting ..\opencv_core\IplConvKernel.java


// Targeting ..\opencv_core\IplConvKernelFP.java



public static final int IPL_IMAGE_HEADER = 1;
public static final int IPL_IMAGE_DATA =   2;
public static final int IPL_IMAGE_ROI =    4;

// #endif/*HAVE_IPL*/

/** extra border mode */
public static final int IPL_BORDER_REFLECT_101 =    4;
public static final int IPL_BORDER_TRANSPARENT =    5;

public static native @MemberGetter int IPL_IMAGE_MAGIC_VAL();
public static final int IPL_IMAGE_MAGIC_VAL = IPL_IMAGE_MAGIC_VAL();
public static final String CV_TYPE_NAME_IMAGE = "opencv-image";

// #define CV_IS_IMAGE_HDR(img)
//     ((img) != NULL && ((const IplImage*)(img))->nSize == sizeof(IplImage))

// #define CV_IS_IMAGE(img)
//     (CV_IS_IMAGE_HDR(img) && ((IplImage*)img)->imageData != NULL)

/** for storing double-precision
   floating point data in IplImage's */
public static final int IPL_DEPTH_64F =  64;

/** get reference to pixel at (col,row),
   for multi-channel images (col) should be multiplied by number of channels */
// #define CV_IMAGE_ELEM( image, elemtype, row, col )
//     (((elemtype*)((image)->imageData + (image)->widthStep*(row)))[(col)])

/****************************************************************************************\
*                                  Matrix type (CvMat)                                   *
\****************************************************************************************/

public static final int CV_AUTO_STEP =  0x7fffffff;
public static final CvSlice CV_WHOLE_ARR =  cvSlice( 0, 0x3fffffff );

public static final int CV_MAGIC_MASK =       0xFFFF0000;
public static final int CV_MAT_MAGIC_VAL =    0x42420000;
public static final String CV_TYPE_NAME_MAT =    "opencv-matrix";

// #ifdef __cplusplus
public static native @ByVal CvMat cvMat(@Const @ByRef Mat m);
// Targeting ..\opencv_core\CvMat.java




// #define CV_IS_MAT_HDR(mat)
//     ((mat) != NULL &&
//     (((const CvMat*)(mat))->type & CV_MAGIC_MASK) == CV_MAT_MAGIC_VAL &&
//     ((const CvMat*)(mat))->cols > 0 && ((const CvMat*)(mat))->rows > 0)

// #define CV_IS_MAT_HDR_Z(mat)
//     ((mat) != NULL &&
//     (((const CvMat*)(mat))->type & CV_MAGIC_MASK) == CV_MAT_MAGIC_VAL &&
//     ((const CvMat*)(mat))->cols >= 0 && ((const CvMat*)(mat))->rows >= 0)

// #define CV_IS_MAT(mat)
//     (CV_IS_MAT_HDR(mat) && ((const CvMat*)(mat))->data.ptr != NULL)

// #define CV_IS_MASK_ARR(mat)
//     (((mat)->type & (CV_MAT_TYPE_MASK & ~CV_8SC1)) == 0)

// #define CV_ARE_TYPES_EQ(mat1, mat2)
//     ((((mat1)->type ^ (mat2)->type) & CV_MAT_TYPE_MASK) == 0)

// #define CV_ARE_CNS_EQ(mat1, mat2)
//     ((((mat1)->type ^ (mat2)->type) & CV_MAT_CN_MASK) == 0)

// #define CV_ARE_DEPTHS_EQ(mat1, mat2)
//     ((((mat1)->type ^ (mat2)->type) & CV_MAT_DEPTH_MASK) == 0)

// #define CV_ARE_SIZES_EQ(mat1, mat2)
//     ((mat1)->rows == (mat2)->rows && (mat1)->cols == (mat2)->cols)

// #define CV_IS_MAT_CONST(mat)
//     (((mat)->rows|(mat)->cols) == 1)

// #define IPL2CV_DEPTH(depth)
//     ((((CV_8U)+(CV_16U<<4)+(CV_32F<<8)+(CV_64F<<16)+(CV_8S<<20)+
//     (CV_16S<<24)+(CV_32S<<28)) >> ((((depth) & 0xF0) >> 2) +
//     (((depth) & IPL_DEPTH_SIGN) ? 20 : 0))) & 15)

/** Inline constructor. No data is allocated internally!!!
 * (Use together with cvCreateData, or use cvCreateMat instead to
 * get a matrix with allocated data):
 */
public static native @ByVal CvMat cvMat( int rows, int cols, int type, Pointer data/*=NULL*/);
public static native @ByVal CvMat cvMat( int rows, int cols, int type);

// #ifdef __cplusplus
public static native @ByVal CvMat cvMat();
public static native @ByVal CvMat cvMat(@Const @ByRef CvMat m);

// #endif // __cplusplus


// #define CV_MAT_ELEM_PTR_FAST( mat, row, col, pix_size )
//     (assert( (unsigned)(row) < (unsigned)(mat).rows &&
//              (unsigned)(col) < (unsigned)(mat).cols ),
//      (mat).data.ptr + (size_t)(mat).step*(row) + (pix_size)*(col))

// #define CV_MAT_ELEM_PTR( mat, row, col )
//     CV_MAT_ELEM_PTR_FAST( mat, row, col, CV_ELEM_SIZE((mat).type) )

// #define CV_MAT_ELEM( mat, elemtype, row, col )
//     (*(elemtype*)CV_MAT_ELEM_PTR_FAST( mat, row, col, sizeof(elemtype)))

/** \brief Returns the particular element of single-channel floating-point matrix.
<p>
The function is a fast replacement for cvGetReal2D in the case of single-channel floating-point
matrices. It is faster because it is inline, it does fewer checks for array type and array element
type, and it checks for the row and column ranges only in debug mode.
@param mat Input matrix
@param row The zero-based index of row
@param col The zero-based index of column
 */
public static native double cvmGet( @Const CvMat mat, int row, int col );

/** \brief Sets a specific element of a single-channel floating-point matrix.
<p>
The function is a fast replacement for cvSetReal2D in the case of single-channel floating-point
matrices. It is faster because it is inline, it does fewer checks for array type and array element
type, and it checks for the row and column ranges only in debug mode.
@param mat The matrix
@param row The zero-based index of row
@param col The zero-based index of column
@param value The new value of the matrix element
 */
public static native void cvmSet( CvMat mat, int row, int col, double value );


public static native int cvIplDepth( int type );


/****************************************************************************************\
*                       Multi-dimensional dense array (CvMatND)                          *
\****************************************************************************************/

public static final int CV_MATND_MAGIC_VAL =    0x42430000;
public static final String CV_TYPE_NAME_MATND =    "opencv-nd-matrix";

public static final int CV_MAX_DIM =            32;

// #ifdef __cplusplus
public static native @ByVal CvMatND cvMatND(@Const @ByRef Mat m);
// Targeting ..\opencv_core\CvMatND.java




public static native @ByVal CvMatND cvMatND();

// #define CV_IS_MATND_HDR(mat)
//     ((mat) != NULL && (((const CvMatND*)(mat))->type & CV_MAGIC_MASK) == CV_MATND_MAGIC_VAL)

// #define CV_IS_MATND(mat)
//     (CV_IS_MATND_HDR(mat) && ((const CvMatND*)(mat))->data.ptr != NULL)


/****************************************************************************************\
*                      Multi-dimensional sparse array (CvSparseMat)                      *
\****************************************************************************************/

public static final int CV_SPARSE_MAT_MAGIC_VAL =    0x42440000;
public static final String CV_TYPE_NAME_SPARSE_MAT =    "opencv-sparse-matrix";
// Targeting ..\opencv_core\CvSparseMat.java



// #ifdef __cplusplus
public static native CvSparseMat cvCreateSparseMat(@Const @ByRef SparseMat m);
// #endif

// #define CV_IS_SPARSE_MAT_HDR(mat)
//     ((mat) != NULL &&
//     (((const CvSparseMat*)(mat))->type & CV_MAGIC_MASK) == CV_SPARSE_MAT_MAGIC_VAL)

// #define CV_IS_SPARSE_MAT(mat)
//     CV_IS_SPARSE_MAT_HDR(mat)
// Targeting ..\opencv_core\CvSparseNode.java


// Targeting ..\opencv_core\CvSparseMatIterator.java



// #define CV_NODE_VAL(mat,node)   ((void*)((uchar*)(node) + (mat)->valoffset))
// #define CV_NODE_IDX(mat,node)   ((int*)((uchar*)(node) + (mat)->idxoffset))

/****************************************************************************************\
*                                         Histogram                                      *
\****************************************************************************************/

public static final int CV_HIST_MAGIC_VAL =     0x42450000;
public static final int CV_HIST_UNIFORM_FLAG =  (1 << 10);

/** indicates whether bin ranges are set already or not */
public static final int CV_HIST_RANGES_FLAG =   (1 << 11);

public static final int CV_HIST_ARRAY =         0;
public static final int CV_HIST_SPARSE =        1;
public static final int CV_HIST_TREE =          CV_HIST_SPARSE;

/** should be used as a parameter only,
   it turns to CV_HIST_UNIFORM_FLAG of hist->type */
public static final int CV_HIST_UNIFORM =       1;
// Targeting ..\opencv_core\CvHistogram.java



// #define CV_IS_HIST( hist )
//     ((hist) != NULL  &&
//      (((CvHistogram*)(hist))->type & CV_MAGIC_MASK) == CV_HIST_MAGIC_VAL &&
//      (hist)->bins != NULL)

// #define CV_IS_UNIFORM_HIST( hist )
//     (((hist)->type & CV_HIST_UNIFORM_FLAG) != 0)

// #define CV_IS_SPARSE_HIST( hist )
//     CV_IS_SPARSE_MAT((hist)->bins)

// #define CV_HIST_HAS_RANGES( hist )
//     (((hist)->type & CV_HIST_RANGES_FLAG) != 0)
// Targeting ..\opencv_core\CvRect.java



/** constructs CvRect structure. */
public static native @ByVal CvRect cvRect( int x, int y, int width, int height );
// #ifdef __cplusplus
public static native @ByVal CvRect cvRect(@Const @ByRef Rect rc);
// #endif

public static native @ByVal IplROI cvRectToROI( @ByVal CvRect rect, int coi );


public static native @ByVal CvRect cvROIToRect( @ByVal IplROI roi );

/*********************************** CvTermCriteria *************************************/

public static final int CV_TERMCRIT_ITER =    1;
public static final int CV_TERMCRIT_NUMBER =  CV_TERMCRIT_ITER;
public static final int CV_TERMCRIT_EPS =     2;
// Targeting ..\opencv_core\CvTermCriteria.java



public static native @ByVal CvTermCriteria cvTermCriteria( int type, int max_iter, double epsilon );
// #ifdef __cplusplus
public static native @ByVal CvTermCriteria cvTermCriteria(@Const @ByRef TermCriteria t);
// Targeting ..\opencv_core\CvPoint.java



/** constructs CvPoint structure. */
public static native @ByVal CvPoint cvPoint( int x, int y );
// #ifdef __cplusplus
public static native @ByVal CvPoint cvPoint(@Const @ByRef Point pt);
// Targeting ..\opencv_core\CvPoint2D32f.java



/** constructs CvPoint2D32f structure. */
public static native @ByVal CvPoint2D32f cvPoint2D32f( double x, double y );

// #ifdef __cplusplus
// #endif

/** converts CvPoint to CvPoint2D32f. */
public static native @ByVal CvPoint2D32f cvPointTo32f( @ByVal CvPoint point );
public static native @ByVal @Cast("CvPoint2D32f*") FloatBuffer cvPointTo32f( @ByVal @Cast("CvPoint*") IntBuffer point );
public static native @ByVal @Cast("CvPoint2D32f*") float[] cvPointTo32f( @ByVal @Cast("CvPoint*") int[] point );

/** converts CvPoint2D32f to CvPoint. */
public static native @ByVal CvPoint cvPointFrom32f( @ByVal CvPoint2D32f point );
public static native @ByVal @Cast("CvPoint*") IntBuffer cvPointFrom32f( @ByVal @Cast("CvPoint2D32f*") FloatBuffer point );
public static native @ByVal @Cast("CvPoint*") int[] cvPointFrom32f( @ByVal @Cast("CvPoint2D32f*") float[] point );
// Targeting ..\opencv_core\CvPoint3D32f.java



/** constructs CvPoint3D32f structure. */
public static native @ByVal CvPoint3D32f cvPoint3D32f( double x, double y, double z );

// #ifdef __cplusplus
// Targeting ..\opencv_core\CvPoint2D64f.java



/** constructs CvPoint2D64f structure.*/
public static native @ByVal CvPoint2D64f cvPoint2D64f( double x, double y );
// Targeting ..\opencv_core\CvPoint3D64f.java



/** constructs CvPoint3D64f structure. */
public static native @ByVal CvPoint3D64f cvPoint3D64f( double x, double y, double z );
// Targeting ..\opencv_core\CvSize.java



/** constructs CvSize structure. */
public static native @ByVal CvSize cvSize( int width, int height );

// #ifdef __cplusplus
public static native @ByVal CvSize cvSize(@Const @ByRef Size sz);
// Targeting ..\opencv_core\CvSize2D32f.java



/** constructs CvSize2D32f structure. */
public static native @ByVal CvSize2D32f cvSize2D32f( double width, double height );
// #ifdef __cplusplus
// Targeting ..\opencv_core\CvBox2D.java




// #ifdef __cplusplus
public static native @ByVal CvBox2D cvBox2D(@ByVal(nullValue = "CvPoint2D32f()") CvPoint2D32f c, @ByVal(nullValue = "CvSize2D32f()") CvSize2D32f s, float a/*=0*/);
public static native @ByVal CvBox2D cvBox2D();
public static native @ByVal CvBox2D cvBox2D(@ByVal(nullValue = "CvPoint2D32f()") @Cast("CvPoint2D32f*") FloatBuffer c, @ByVal(nullValue = "CvSize2D32f()") CvSize2D32f s, float a/*=0*/);
public static native @ByVal CvBox2D cvBox2D(@ByVal(nullValue = "CvPoint2D32f()") @Cast("CvPoint2D32f*") float[] c, @ByVal(nullValue = "CvSize2D32f()") CvSize2D32f s, float a/*=0*/);
public static native @ByVal CvBox2D cvBox2D(@Const @ByRef RotatedRect rr);
// Targeting ..\opencv_core\CvLineIterator.java





/************************************* CvSlice ******************************************/
public static final int CV_WHOLE_SEQ_END_INDEX = 0x3fffffff;
public static final CvSlice CV_WHOLE_SEQ =  cvSlice(0, CV_WHOLE_SEQ_END_INDEX);
// Targeting ..\opencv_core\CvSlice.java



public static native @ByVal CvSlice cvSlice( int start, int end );

// #if defined(__cplusplus)
public static native @ByVal CvSlice cvSlice(@Const @ByRef Range r);
// Targeting ..\opencv_core\CvScalar.java



public static native @ByVal CvScalar cvScalar( double val0, double val1/*=0*/,
                               double val2/*=0*/, double val3/*=0*/);
public static native @ByVal CvScalar cvScalar( double val0);

// #ifdef __cplusplus
public static native @ByVal CvScalar cvScalar();
public static native @ByVal CvScalar cvScalar(@Const @ByRef Scalar s);
// #endif

public static native @ByVal CvScalar cvRealScalar( double val0 );

public static native @ByVal CvScalar cvScalarAll( double val0123 );
// Targeting ..\opencv_core\CvMemBlock.java



public static final int CV_STORAGE_MAGIC_VAL =    0x42890000;
// Targeting ..\opencv_core\CvMemStorage.java



// #define CV_IS_STORAGE(storage)
//     ((storage) != NULL &&
//     (((CvMemStorage*)(storage))->signature & CV_MAGIC_MASK) == CV_STORAGE_MAGIC_VAL)
// Targeting ..\opencv_core\CvMemStoragePos.java


// Targeting ..\opencv_core\CvSeqBlock.java




/** 2nd next sequence.       */
// #define CV_TREE_NODE_FIELDS(node_type)
//     int       flags;             /**< Miscellaneous flags.     */
//     int       header_size;       /**< Size of sequence header. */
//     struct    node_type* h_prev; /**< Previous sequence.       */
//     struct    node_type* h_next; /**< Next sequence.           */
//     struct    node_type* v_prev; /**< 2nd previous sequence.   */
//     struct    node_type* v_next

/**
   Read/Write sequence.
   Elements can be dynamically inserted to or deleted from the sequence.
*/
/** Pointer to the first sequence block. */
// #define CV_SEQUENCE_FIELDS()
//     CV_TREE_NODE_FIELDS(CvSeq);
//     int       total;          /**< Total number of elements.            */
//     int       elem_size;      /**< Size of sequence element in bytes.   */
//     schar*    block_max;      /**< Maximal bound of the last block.     */
//     schar*    ptr;            /**< Current write pointer.               */
//     int       delta_elems;    /**< Grow seq this many at a time.        */
//     CvMemStorage* storage;    /**< Where the seq is stored.             */
//     CvSeqBlock* free_blocks;  /**< Free blocks list.                    */
//     CvSeqBlock* first;
// Targeting ..\opencv_core\CvSeq.java



public static final String CV_TYPE_NAME_SEQ =             "opencv-sequence";
public static final String CV_TYPE_NAME_SEQ_TREE =        "opencv-sequence-tree";

/*************************************** Set ********************************************/
/** \brief Set
  Order is not preserved. There can be gaps between sequence elements.
  After the element has been inserted it stays in the same place all the time.
  The MSB(most-significant or sign bit) of the first field (flags) is 0 iff the element exists.
*/
// #define CV_SET_ELEM_FIELDS(elem_type)
//     int  flags;
//     struct elem_type* next_free;
// Targeting ..\opencv_core\CvSetElem.java



// #define CV_SET_FIELDS()
//     CV_SEQUENCE_FIELDS()
//     CvSetElem* free_elems;
//     int active_count;
// Targeting ..\opencv_core\CvSet.java




public static final int CV_SET_ELEM_IDX_MASK =   ((1 << 26) - 1);
public static native @MemberGetter int CV_SET_ELEM_FREE_FLAG();
public static final int CV_SET_ELEM_FREE_FLAG = CV_SET_ELEM_FREE_FLAG();

/** Checks whether the element pointed by ptr belongs to a set or not */
// #define CV_IS_SET_ELEM( ptr )  (((CvSetElem*)(ptr))->flags >= 0)

/************************************* Graph ********************************************/

/** \name Graph
<p>
We represent a graph as a set of vertices. Vertices contain their adjacency lists (more exactly,
pointers to first incoming or outcoming edge (or 0 if isolated vertex)). Edges are stored in
another set. There is a singly-linked list of incoming/outcoming edges for each vertex.
<p>
Each edge consists of:
<p>
- Two pointers to the starting and ending vertices (vtx[0] and vtx[1] respectively).
    <p>
    A graph may be oriented or not. In the latter case, edges between vertex i to vertex j are not
distinguished during search operations.
<p>
- Two pointers to next edges for the starting and ending vertices, where next[0] points to the
next edge in the vtx[0] adjacency list and next[1] points to the next edge in the vtx[1]
adjacency list.
<p>
@see CvGraphEdge, CvGraphVtx, CvGraphVtx2D, CvGraph
\{
*/
// #define CV_GRAPH_EDGE_FIELDS()
//     int flags;
//     float weight;
//     struct CvGraphEdge* next[2];
//     struct CvGraphVtx* vtx[2];


// #define CV_GRAPH_VERTEX_FIELDS()
//     int flags;
//     struct CvGraphEdge* first;
// Targeting ..\opencv_core\CvGraphEdge.java


// Targeting ..\opencv_core\CvGraphVtx.java


// Targeting ..\opencv_core\CvGraphVtx2D.java



/**
   Graph is "derived" from the set (this is set a of vertices)
   and includes another set (edges)
*/
// #define  CV_GRAPH_FIELDS()
//     CV_SET_FIELDS()
//     CvSet* edges;
// Targeting ..\opencv_core\CvGraph.java



public static final String CV_TYPE_NAME_GRAPH = "opencv-graph";
// Targeting ..\opencv_core\CvChain.java



// #define CV_CONTOUR_FIELDS()
//     CV_SEQUENCE_FIELDS()
//     CvRect rect;
//     int color;
//     int reserved[3];
// Targeting ..\opencv_core\CvContour.java



/****************************************************************************************\
*                                    Sequence types                                      *
\****************************************************************************************/

public static final int CV_SEQ_MAGIC_VAL =             0x42990000;

// #define CV_IS_SEQ(seq)
//     ((seq) != NULL && (((CvSeq*)(seq))->flags & CV_MAGIC_MASK) == CV_SEQ_MAGIC_VAL)

public static final int CV_SET_MAGIC_VAL =             0x42980000;
// #define CV_IS_SET(set)
//     ((set) != NULL && (((CvSeq*)(set))->flags & CV_MAGIC_MASK) == CV_SET_MAGIC_VAL)

public static final int CV_SEQ_ELTYPE_BITS =           12;
public static final int CV_SEQ_ELTYPE_MASK =           ((1 << CV_SEQ_ELTYPE_BITS) - 1);

/** (x,y) */
public static final int CV_SEQ_ELTYPE_POINT =          CV_32SC2;
/** freeman code: 0..7 */
public static final int CV_SEQ_ELTYPE_CODE =           CV_8UC1;
public static final int CV_SEQ_ELTYPE_GENERIC =        0;
public static native @MemberGetter int CV_SEQ_ELTYPE_PTR();
public static final int CV_SEQ_ELTYPE_PTR = CV_SEQ_ELTYPE_PTR();
/** &(x,y) */
public static native @MemberGetter int CV_SEQ_ELTYPE_PPOINT();
public static final int CV_SEQ_ELTYPE_PPOINT = CV_SEQ_ELTYPE_PPOINT();
/** #(x,y) */
public static final int CV_SEQ_ELTYPE_INDEX =          CV_32SC1;
/** &next_o, &next_d, &vtx_o, &vtx_d */
public static final int CV_SEQ_ELTYPE_GRAPH_EDGE =     0;
/** first_edge, &(x,y) */
public static final int CV_SEQ_ELTYPE_GRAPH_VERTEX =   0;
/** vertex of the binary tree   */
public static final int CV_SEQ_ELTYPE_TRIAN_ATR =      0;
/** connected component  */
public static final int CV_SEQ_ELTYPE_CONNECTED_COMP = 0;
/** (x,y,z)  */
public static final int CV_SEQ_ELTYPE_POINT3D =        CV_32FC3;

public static final int CV_SEQ_KIND_BITS =        2;
public static final int CV_SEQ_KIND_MASK =        (((1 << CV_SEQ_KIND_BITS) - 1)<<CV_SEQ_ELTYPE_BITS);

/** types of sequences */
public static final int CV_SEQ_KIND_GENERIC =     (0 << CV_SEQ_ELTYPE_BITS);
public static final int CV_SEQ_KIND_CURVE =       (1 << CV_SEQ_ELTYPE_BITS);
public static final int CV_SEQ_KIND_BIN_TREE =    (2 << CV_SEQ_ELTYPE_BITS);

/** types of sparse sequences (sets) */
public static final int CV_SEQ_KIND_GRAPH =       (1 << CV_SEQ_ELTYPE_BITS);
public static final int CV_SEQ_KIND_SUBDIV2D =    (2 << CV_SEQ_ELTYPE_BITS);

public static final int CV_SEQ_FLAG_SHIFT =       (CV_SEQ_KIND_BITS + CV_SEQ_ELTYPE_BITS);

/** flags for curves */
public static final int CV_SEQ_FLAG_CLOSED =     (1 << CV_SEQ_FLAG_SHIFT);
public static final int CV_SEQ_FLAG_SIMPLE =     (0 << CV_SEQ_FLAG_SHIFT);
public static final int CV_SEQ_FLAG_CONVEX =     (0 << CV_SEQ_FLAG_SHIFT);
public static final int CV_SEQ_FLAG_HOLE =       (2 << CV_SEQ_FLAG_SHIFT);

/** flags for graphs */
public static final int CV_GRAPH_FLAG_ORIENTED = (1 << CV_SEQ_FLAG_SHIFT);

public static final int CV_GRAPH =               CV_SEQ_KIND_GRAPH;
public static final int CV_ORIENTED_GRAPH =      (CV_SEQ_KIND_GRAPH|CV_GRAPH_FLAG_ORIENTED);

/** point sets */
public static final int CV_SEQ_POINT_SET =       (CV_SEQ_KIND_GENERIC| CV_SEQ_ELTYPE_POINT);
public static final int CV_SEQ_POINT3D_SET =     (CV_SEQ_KIND_GENERIC| CV_SEQ_ELTYPE_POINT3D);
public static final int CV_SEQ_POLYLINE =        (CV_SEQ_KIND_CURVE  | CV_SEQ_ELTYPE_POINT);
public static final int CV_SEQ_POLYGON =         (CV_SEQ_FLAG_CLOSED | CV_SEQ_POLYLINE );
public static final int CV_SEQ_CONTOUR =         CV_SEQ_POLYGON;
public static final int CV_SEQ_SIMPLE_POLYGON =  (CV_SEQ_FLAG_SIMPLE | CV_SEQ_POLYGON  );

/** chain-coded curves */
public static final int CV_SEQ_CHAIN =           (CV_SEQ_KIND_CURVE  | CV_SEQ_ELTYPE_CODE);
public static final int CV_SEQ_CHAIN_CONTOUR =   (CV_SEQ_FLAG_CLOSED | CV_SEQ_CHAIN);

/** binary tree for the contour */
public static final int CV_SEQ_POLYGON_TREE =    (CV_SEQ_KIND_BIN_TREE  | CV_SEQ_ELTYPE_TRIAN_ATR);

/** sequence of the connected components */
public static final int CV_SEQ_CONNECTED_COMP =  (CV_SEQ_KIND_GENERIC  | CV_SEQ_ELTYPE_CONNECTED_COMP);

/** sequence of the integer numbers */
public static final int CV_SEQ_INDEX =           (CV_SEQ_KIND_GENERIC  | CV_SEQ_ELTYPE_INDEX);

// #define CV_SEQ_ELTYPE( seq )   ((seq)->flags & CV_SEQ_ELTYPE_MASK)
// #define CV_SEQ_KIND( seq )     ((seq)->flags & CV_SEQ_KIND_MASK )

/** flag checking */
// #define CV_IS_SEQ_INDEX( seq )      ((CV_SEQ_ELTYPE(seq) == CV_SEQ_ELTYPE_INDEX) &&
//                                      (CV_SEQ_KIND(seq) == CV_SEQ_KIND_GENERIC))

// #define CV_IS_SEQ_CURVE( seq )      (CV_SEQ_KIND(seq) == CV_SEQ_KIND_CURVE)
// #define CV_IS_SEQ_CLOSED( seq )     (((seq)->flags & CV_SEQ_FLAG_CLOSED) != 0)
// #define CV_IS_SEQ_CONVEX( seq )     0
// #define CV_IS_SEQ_HOLE( seq )       (((seq)->flags & CV_SEQ_FLAG_HOLE) != 0)
// #define CV_IS_SEQ_SIMPLE( seq )     1

/** type checking macros */
// #define CV_IS_SEQ_POINT_SET( seq )
//     ((CV_SEQ_ELTYPE(seq) == CV_32SC2 || CV_SEQ_ELTYPE(seq) == CV_32FC2))

// #define CV_IS_SEQ_POINT_SUBSET( seq )
//     (CV_IS_SEQ_INDEX( seq ) || CV_SEQ_ELTYPE(seq) == CV_SEQ_ELTYPE_PPOINT)

// #define CV_IS_SEQ_POLYLINE( seq )
//     (CV_SEQ_KIND(seq) == CV_SEQ_KIND_CURVE && CV_IS_SEQ_POINT_SET(seq))

// #define CV_IS_SEQ_POLYGON( seq )
//     (CV_IS_SEQ_POLYLINE(seq) && CV_IS_SEQ_CLOSED(seq))

// #define CV_IS_SEQ_CHAIN( seq )
//     (CV_SEQ_KIND(seq) == CV_SEQ_KIND_CURVE && (seq)->elem_size == 1)

// #define CV_IS_SEQ_CONTOUR( seq )
//     (CV_IS_SEQ_CLOSED(seq) && (CV_IS_SEQ_POLYLINE(seq) || CV_IS_SEQ_CHAIN(seq)))

// #define CV_IS_SEQ_CHAIN_CONTOUR( seq )
//     (CV_IS_SEQ_CHAIN( seq ) && CV_IS_SEQ_CLOSED( seq ))

// #define CV_IS_SEQ_POLYGON_TREE( seq )
//     (CV_SEQ_ELTYPE (seq) ==  CV_SEQ_ELTYPE_TRIAN_ATR &&
//     CV_SEQ_KIND( seq ) ==  CV_SEQ_KIND_BIN_TREE )

// #define CV_IS_GRAPH( seq )
//     (CV_IS_SET(seq) && CV_SEQ_KIND((CvSet*)(seq)) == CV_SEQ_KIND_GRAPH)

// #define CV_IS_GRAPH_ORIENTED( seq )
//     (((seq)->flags & CV_GRAPH_FLAG_ORIENTED) != 0)

// #define CV_IS_SUBDIV2D( seq )
//     (CV_IS_SET(seq) && CV_SEQ_KIND((CvSet*)(seq)) == CV_SEQ_KIND_SUBDIV2D)

/****************************************************************************************/
/*                            Sequence writer & reader                                  */
/****************************************************************************************/

/** pointer to the end of block */
// #define CV_SEQ_WRITER_FIELDS()
//     int          header_size;
//     CvSeq*       seq;        /**< the sequence written */
//     CvSeqBlock*  block;      /**< current block */
//     schar*       ptr;        /**< pointer to free space */
//     schar*       block_min;  /**< pointer to the beginning of block*/
//     schar*       block_max;
// Targeting ..\opencv_core\CvSeqWriter.java




/** pointer to previous element */
// #define CV_SEQ_READER_FIELDS()
//     int          header_size;
//     CvSeq*       seq;        /**< sequence, beign read */
//     CvSeqBlock*  block;      /**< current block */
//     schar*       ptr;        /**< pointer to element be read next */
//     schar*       block_min;  /**< pointer to the beginning of block */
//     schar*       block_max;  /**< pointer to the end of block */
//     int          delta_index;/**< = seq->first->start_index   */
//     schar*       prev_elem;
// Targeting ..\opencv_core\CvSeqReader.java



/****************************************************************************************/
/*                                Operations on sequences                               */
/****************************************************************************************/

// #define  CV_SEQ_ELEM( seq, elem_type, index )
// /** assert gives some guarantee that <seq> parameter is valid */
// (   assert(sizeof((seq)->first[0]) == sizeof(CvSeqBlock) &&
//     (seq)->elem_size == sizeof(elem_type)),
//     (elem_type*)((seq)->first && (unsigned)index <
//     (unsigned)((seq)->first->count) ?
//     (seq)->first->data + (index) * sizeof(elem_type) :
//     cvGetSeqElem( (CvSeq*)(seq), (index) )))
// #define CV_GET_SEQ_ELEM( elem_type, seq, index ) CV_SEQ_ELEM( (seq), elem_type, (index) )

/** Add element to sequence: */
// #define CV_WRITE_SEQ_ELEM_VAR( elem_ptr, writer )
// {
//     if( (writer).ptr >= (writer).bock_max )
//     {
//         cvCreateSeqBlock( &writer);
//     }
//     memcpy((writer).ptr, elem_ptr, (writer).seq->elem_size);
//     (writer).ptr += (writer).seq->elem_size;
// }

// #define CV_WRITE_SEQ_ELEM( elem, writer )
// {
//     assert( (writer).seq->elem_size == sizeof(elem));
//     if( (writer).ptr >= (writer).bock_max )
//     {
//         cvCreateSeqBlock( &writer);
//     }
//     assert( (writer).ptr <= (writer).bock_max - sizeof(elem));
//     memcpy((writer).ptr, &(elem), sizeof(elem));
//     (writer).ptr += sizeof(elem);
// }


/** Move reader position forward: */
// #define CV_NEXT_SEQ_ELEM( elem_size, reader )
// {
//     if( ((reader).ptr += (elem_size)) >= (reader).bock_max )
//     {
//         cvChangeSeqBlock( &(reader), 1 );
//     }
// }


/** Move reader position backward: */
// #define CV_PREV_SEQ_ELEM( elem_size, reader )
// {
//     if( ((reader).ptr -= (elem_size)) < (reader).bock_min )
//     {
//         cvChangeSeqBlock( &(reader), -1 );
//     }
// }

/** Read element and move read position forward: */
// #define CV_READ_SEQ_ELEM( elem, reader )
// {
//     assert( (reader).seq->elem_size == sizeof(elem));
//     memcpy( &(elem), (reader).ptr, sizeof((elem)));
//     CV_NEXT_SEQ_ELEM( sizeof(elem), reader )
// }

/** Read element and move read position backward: */
// #define CV_REV_READ_SEQ_ELEM( elem, reader )
// {
//     assert( (reader).seq->elem_size == sizeof(elem));
//     memcpy(&(elem), (reader).ptr, sizeof((elem)));
//     CV_PREV_SEQ_ELEM( sizeof(elem), reader )
// }


// #define CV_READ_CHAIN_POINT( _pt, reader )
// {
//     (_pt) = (reader).pt;
//     if( (reader).ptr )
//     {
//         CV_READ_SEQ_ELEM( (reader).code, (reader));
//         assert( ((reader).code & ~7) == 0 );
//         (reader).pt.x += (reader).detas[(int)(reader).code][0];
//         (reader).pt.y += (reader).detas[(int)(reader).code][1];
//     }
// }

// #define CV_CURRENT_POINT( reader )  (*((CvPoint*)((reader).ptr)))
// #define CV_PREV_POINT( reader )     (*((CvPoint*)((reader).prev_elem)))

// #define CV_READ_EDGE( pt1, pt2, reader )
// {
//     assert( sizeof(pt1) == sizeof(CvPoint) &&
//             sizeof(pt2) == sizeof(CvPoint) &&
//             reader.seq->elem_size == sizeof(CvPoint));
//     (pt1) = CV_PREV_POINT( reader );
//     (pt2) = CV_CURRENT_POINT( reader );
//     (reader).prev_elem = (reader).ptr;
//     CV_NEXT_SEQ_ELEM( sizeof(CvPoint), (reader));
// }

/************ Graph macros ************/

/** Return next graph edge for given vertex: */
// #define  CV_NEXT_GRAPH_EDGE( edge, vertex )
//      (assert((edge)->vtx[0] == (vertex) || (edge)->vtx[1] == (vertex)),
//       (edge)->next[(edge)->vtx[1] == (vertex)])



/****************************************************************************************\
*             Data structures for persistence (a.k.a serialization) functionality        *
\****************************************************************************************/

// #if 0
// #endif

/** \} */

// #endif /*OPENCV_CORE_TYPES_H*/

/* End of file. */


// Parsed from <opencv2/core/core_c.h>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/


// #ifndef OPENCV_CORE_C_H
// #define OPENCV_CORE_C_H

// #include "opencv2/core/types_c.h"

// #ifdef __cplusplus
/* disable MSVC warning C4190 / clang-cl -Wreturn-type-c-linkage:
       'function' has C-linkage specified, but returns UDT 'typename'
       which is incompatible with C

   It is OK to disable it because we only extend few plain structures with
   C++ constructors for simpler interoperability with C++ API of the library
*/
// #  if defined(__clang__)
// #  elif defined(_MSC_VER)
// #  endif
// #endif

// #ifdef __cplusplus
// #endif

/** \addtogroup core_c
    \{
*/

/****************************************************************************************\
*          Array allocation, deallocation, initialization and access to elements         *
\****************************************************************************************/

/** {@code malloc} wrapper.
   If there is no enough memory, the function
   (as well as other OpenCV functions that call cvAlloc)
   raises an error. */
public static native Pointer cvAlloc( @Cast("size_t") long size );

/** {@code free} wrapper.
   Here and further all the memory releasing functions
   (that all call cvFree) take double pointer in order to
   to clear pointer to the data after releasing it.
   Passing pointer to NULL pointer is Ok: nothing happens in this case
*/
public static native void cvFree_( Pointer ptr );
// #define cvFree(ptr) (cvFree_(*(ptr)), *(ptr)=0)

/** \brief Creates an image header but does not allocate the image data.
<p>
@param size Image width and height
@param depth Image depth (see cvCreateImage )
@param channels Number of channels (see cvCreateImage )
 */
public static native IplImage cvCreateImageHeader( @ByVal CvSize size, int depth, int channels );

/** \brief Initializes an image header that was previously allocated.
<p>
The returned IplImage\* points to the initialized header.
@param image Image header to initialize
@param size Image width and height
@param depth Image depth (see cvCreateImage )
@param channels Number of channels (see cvCreateImage )
@param origin Top-left IPL_ORIGIN_TL or bottom-left IPL_ORIGIN_BL
@param align Alignment for image rows, typically 4 or 8 bytes
 */
public static native IplImage cvInitImageHeader( IplImage image, @ByVal CvSize size, int depth,
                                   int channels, int origin/*=0*/,
                                   int align/*=4*/);
public static native IplImage cvInitImageHeader( IplImage image, @ByVal CvSize size, int depth,
                                   int channels);

/** \brief Creates an image header and allocates the image data.
<p>
This function call is equivalent to the following code:
<pre>{@code
    header = cvCreateImageHeader(size, depth, channels);
    cvCreateData(header);
}</pre>
@param size Image width and height
@param depth Bit depth of image elements. See IplImage for valid depths.
@param channels Number of channels per pixel. See IplImage for details. This function only creates
images with interleaved channels.
 */
public static native IplImage cvCreateImage( @ByVal CvSize size, int depth, int channels );

/** \brief Deallocates an image header.
<p>
This call is an analogue of :
<pre>{@code
    if(image )
    {
        iplDeallocate(*image, IPL_IMAGE_HEADER | IPL_IMAGE_ROI);
        *image = 0;
    }
}</pre>
but it does not use IPL functions by default (see the CV_TURN_ON_IPL_COMPATIBILITY macro).
@param image Double pointer to the image header
 */
public static native void cvReleaseImageHeader( @Cast("IplImage**") PointerPointer image );
public static native void cvReleaseImageHeader( @ByPtrPtr IplImage image );

/** \brief Deallocates the image header and the image data.
<p>
This call is a shortened form of :
<pre>{@code
    if(*image )
    {
        cvReleaseData(*image);
        cvReleaseImageHeader(image);
    }
}</pre>
@param image Double pointer to the image header
*/
public static native void cvReleaseImage( @Cast("IplImage**") PointerPointer image );
public static native void cvReleaseImage( @ByPtrPtr IplImage image );

/** Creates a copy of IPL image (widthStep may differ) */
public static native IplImage cvCloneImage( @Const IplImage image );

/** \brief Sets the channel of interest in an IplImage.
<p>
If the ROI is set to NULL and the coi is *not* 0, the ROI is allocated. Most OpenCV functions do
*not* support the COI setting, so to process an individual image/matrix channel one may copy (via
cvCopy or cvSplit) the channel to a separate image/matrix, process it and then copy the result
back (via cvCopy or cvMerge) if needed.
@param image A pointer to the image header
@param coi The channel of interest. 0 - all channels are selected, 1 - first channel is selected,
etc. Note that the channel indices become 1-based.
 */
public static native void cvSetImageCOI( IplImage image, int coi );

/** \brief Returns the index of the channel of interest.
<p>
Returns the channel of interest of in an IplImage. Returned values correspond to the coi in
cvSetImageCOI.
@param image A pointer to the image header
 */
public static native int cvGetImageCOI( @Const IplImage image );

/** \brief Sets an image Region Of Interest (ROI) for a given rectangle.
<p>
If the original image ROI was NULL and the rect is not the whole image, the ROI structure is
allocated.
<p>
Most OpenCV functions support the use of ROI and treat the image rectangle as a separate image. For
example, all of the pixel coordinates are counted from the top-left (or bottom-left) corner of the
ROI, not the original image.
@param image A pointer to the image header
@param rect The ROI rectangle
 */
public static native void cvSetImageROI( IplImage image, @ByVal CvRect rect );

/** \brief Resets the image ROI to include the entire image and releases the ROI structure.
<p>
This produces a similar result to the following, but in addition it releases the ROI structure. :
<pre>{@code
    cvSetImageROI(image, cvRect(0, 0, image->width, image->height ));
    cvSetImageCOI(image, 0);
}</pre>
@param image A pointer to the image header
 */
public static native void cvResetImageROI( IplImage image );

/** \brief Returns the image ROI.
<p>
If there is no ROI set, cvRect(0,0,image-\>width,image-\>height) is returned.
@param image A pointer to the image header
 */
public static native @ByVal CvRect cvGetImageROI( @Const IplImage image );

/** \brief Creates a matrix header but does not allocate the matrix data.
<p>
The function allocates a new matrix header and returns a pointer to it. The matrix data can then be
allocated using cvCreateData or set explicitly to user-allocated data via cvSetData.
@param rows Number of rows in the matrix
@param cols Number of columns in the matrix
@param type Type of the matrix elements, see cvCreateMat
 */
public static native CvMat cvCreateMatHeader( int rows, int cols, int type );

public static final int CV_AUTOSTEP =  0x7fffffff;

/** \brief Initializes a pre-allocated matrix header.
<p>
This function is often used to process raw data with OpenCV matrix functions. For example, the
following code computes the matrix product of two matrices, stored as ordinary arrays:
<pre>{@code
    double a[] = { 1, 2, 3, 4,
                   5, 6, 7, 8,
                   9, 10, 11, 12 };

    double b[] = { 1, 5, 9,
                   2, 6, 10,
                   3, 7, 11,
                   4, 8, 12 };

    double c[9];
    CvMat Ma, Mb, Mc ;

    cvInitMatHeader(&Ma, 3, 4, CV_64FC1, a);
    cvInitMatHeader(&Mb, 4, 3, CV_64FC1, b);
    cvInitMatHeader(&Mc, 3, 3, CV_64FC1, c);

    cvMatMulAdd(&Ma, &Mb, 0, &Mc);
    // the c array now contains the product of a (3x4) and b (4x3)
}</pre>
@param mat A pointer to the matrix header to be initialized
@param rows Number of rows in the matrix
@param cols Number of columns in the matrix
@param type Type of the matrix elements, see cvCreateMat .
@param data Optional: data pointer assigned to the matrix header
@param step Optional: full row width in bytes of the assigned data. By default, the minimal
possible step is used which assumes there are no gaps between subsequent rows of the matrix.
 */
public static native CvMat cvInitMatHeader( CvMat mat, int rows, int cols,
                              int type, Pointer data/*=NULL*/,
                              int step/*=CV_AUTOSTEP*/ );
public static native CvMat cvInitMatHeader( CvMat mat, int rows, int cols,
                              int type );

/** \brief Creates a matrix header and allocates the matrix data.
<p>
The function call is equivalent to the following code:
<pre>{@code
    CvMat* mat = cvCreateMatHeader(rows, cols, type);
    cvCreateData(mat);
}</pre>
@param rows Number of rows in the matrix
@param cols Number of columns in the matrix
@param type The type of the matrix elements in the form
CV_\<bit depth\>\<S|U|F\>C\<number of channels\> , where S=signed, U=unsigned, F=float. For
example, CV _ 8UC1 means the elements are 8-bit unsigned and the there is 1 channel, and CV _
32SC2 means the elements are 32-bit signed and there are 2 channels.
 */
public static native CvMat cvCreateMat( int rows, int cols, int type );

/** \brief Deallocates a matrix.
<p>
The function decrements the matrix data reference counter and deallocates matrix header. If the data
reference counter is 0, it also deallocates the data. :
<pre>{@code
    if(*mat )
        cvDecRefData(*mat);
    cvFree((void**)mat);
}</pre>
@param mat Double pointer to the matrix
 */
public static native void cvReleaseMat( @Cast("CvMat**") PointerPointer mat );
public static native void cvReleaseMat( @ByPtrPtr CvMat mat );

/** \brief Decrements an array data reference counter.
<p>
The function decrements the data reference counter in a CvMat or CvMatND if the reference counter
<p>
pointer is not NULL. If the counter reaches zero, the data is deallocated. In the current
implementation the reference counter is not NULL only if the data was allocated using the
cvCreateData function. The counter will be NULL in other cases such as: external data was assigned
to the header using cvSetData, header is part of a larger matrix or image, or the header was
converted from an image or n-dimensional matrix header.
@param arr Pointer to an array header
 */
public static native void cvDecRefData( CvArr arr );

/** \brief Increments array data reference counter.
<p>
The function increments CvMat or CvMatND data reference counter and returns the new counter value if
the reference counter pointer is not NULL, otherwise it returns zero.
@param arr Array header
 */
public static native int cvIncRefData( CvArr arr );


/** Creates an exact copy of the input matrix (except, may be, step value) */
public static native CvMat cvCloneMat( @Const CvMat mat );


/** \brief Returns matrix header corresponding to the rectangular sub-array of input image or matrix.
<p>
The function returns header, corresponding to a specified rectangle of the input array. In other
<p>
words, it allows the user to treat a rectangular part of input array as a stand-alone array. ROI is
taken into account by the function so the sub-array of ROI is actually extracted.
@param arr Input array
@param submat Pointer to the resultant sub-array header
@param rect Zero-based coordinates of the rectangle of interest
 */
public static native CvMat cvGetSubRect( @Const CvArr arr, CvMat submat, @ByVal CvRect rect );
public static native CvMat cvGetSubArr(CvArr arg1, CvMat arg2, @ByVal CvRect arg3);

/** \brief Returns array row or row span.
<p>
The function returns the header, corresponding to a specified row/row span of the input array.
cvGetRow(arr, submat, row) is a shortcut for cvGetRows(arr, submat, row, row+1).
@param arr Input array
@param submat Pointer to the resulting sub-array header
@param start_row Zero-based index of the starting row (inclusive) of the span
@param end_row Zero-based index of the ending row (exclusive) of the span
@param delta_row Index step in the row span. That is, the function extracts every delta_row -th
row from start_row and up to (but not including) end_row .
 */
public static native CvMat cvGetRows( @Const CvArr arr, CvMat submat,
                        int start_row, int end_row,
                        int delta_row/*=1*/);
public static native CvMat cvGetRows( @Const CvArr arr, CvMat submat,
                        int start_row, int end_row);

/** \overload
@param arr Input array
@param submat Pointer to the resulting sub-array header
@param row Zero-based index of the selected row
*/
public static native CvMat cvGetRow( @Const CvArr arr, CvMat submat, int row );


/** \brief Returns one of more array columns.
<p>
The function returns the header, corresponding to a specified column span of the input array. That
<p>
is, no data is copied. Therefore, any modifications of the submatrix will affect the original array.
If you need to copy the columns, use cvCloneMat. cvGetCol(arr, submat, col) is a shortcut for
cvGetCols(arr, submat, col, col+1).
@param arr Input array
@param submat Pointer to the resulting sub-array header
@param start_col Zero-based index of the starting column (inclusive) of the span
@param end_col Zero-based index of the ending column (exclusive) of the span
 */
public static native CvMat cvGetCols( @Const CvArr arr, CvMat submat,
                        int start_col, int end_col );

/** \overload
@param arr Input array
@param submat Pointer to the resulting sub-array header
@param col Zero-based index of the selected column
*/
public static native CvMat cvGetCol( @Const CvArr arr, CvMat submat, int col );

/** \brief Returns one of array diagonals.
<p>
The function returns the header, corresponding to a specified diagonal of the input array.
@param arr Input array
@param submat Pointer to the resulting sub-array header
@param diag Index of the array diagonal. Zero value corresponds to the main diagonal, -1
corresponds to the diagonal above the main, 1 corresponds to the diagonal below the main, and so
forth.
 */
public static native CvMat cvGetDiag( @Const CvArr arr, CvMat submat,
                            int diag/*=0*/);
public static native CvMat cvGetDiag( @Const CvArr arr, CvMat submat);

/** low-level scalar <-> raw data conversion functions */
public static native void cvScalarToRawData( @Const CvScalar scalar, Pointer data, int type,
                              int extend_to_12/*=0*/ );
public static native void cvScalarToRawData( @Const CvScalar scalar, Pointer data, int type );

public static native void cvRawDataToScalar( @Const Pointer data, int type, CvScalar scalar );

/** \brief Creates a new matrix header but does not allocate the matrix data.
<p>
The function allocates a header for a multi-dimensional dense array. The array data can further be
allocated using cvCreateData or set explicitly to user-allocated data via cvSetData.
@param dims Number of array dimensions
@param sizes Array of dimension sizes
@param type Type of array elements, see cvCreateMat
 */
public static native CvMatND cvCreateMatNDHeader( int dims, @Const IntPointer sizes, int type );
public static native CvMatND cvCreateMatNDHeader( int dims, @Const IntBuffer sizes, int type );
public static native CvMatND cvCreateMatNDHeader( int dims, @Const int[] sizes, int type );

/** \brief Creates the header and allocates the data for a multi-dimensional dense array.
<p>
This function call is equivalent to the following code:
<pre>{@code
    CvMatND* mat = cvCreateMatNDHeader(dims, sizes, type);
    cvCreateData(mat);
}</pre>
@param dims Number of array dimensions. This must not exceed CV_MAX_DIM (32 by default, but can be
changed at build time).
@param sizes Array of dimension sizes.
@param type Type of array elements, see cvCreateMat .
 */
public static native CvMatND cvCreateMatND( int dims, @Const IntPointer sizes, int type );
public static native CvMatND cvCreateMatND( int dims, @Const IntBuffer sizes, int type );
public static native CvMatND cvCreateMatND( int dims, @Const int[] sizes, int type );

/** \brief Initializes a pre-allocated multi-dimensional array header.
<p>
@param mat A pointer to the array header to be initialized
@param dims The number of array dimensions
@param sizes An array of dimension sizes
@param type Type of array elements, see cvCreateMat
@param data Optional data pointer assigned to the matrix header
 */
public static native CvMatND cvInitMatNDHeader( CvMatND mat, int dims, @Const IntPointer sizes,
                                    int type, Pointer data/*=NULL*/ );
public static native CvMatND cvInitMatNDHeader( CvMatND mat, int dims, @Const IntPointer sizes,
                                    int type );
public static native CvMatND cvInitMatNDHeader( CvMatND mat, int dims, @Const IntBuffer sizes,
                                    int type, Pointer data/*=NULL*/ );
public static native CvMatND cvInitMatNDHeader( CvMatND mat, int dims, @Const IntBuffer sizes,
                                    int type );
public static native CvMatND cvInitMatNDHeader( CvMatND mat, int dims, @Const int[] sizes,
                                    int type, Pointer data/*=NULL*/ );
public static native CvMatND cvInitMatNDHeader( CvMatND mat, int dims, @Const int[] sizes,
                                    int type );

/** \brief Deallocates a multi-dimensional array.
<p>
The function decrements the array data reference counter and releases the array header. If the
reference counter reaches 0, it also deallocates the data. :
<pre>{@code
    if(*mat )
        cvDecRefData(*mat);
    cvFree((void**)mat);
}</pre>
@param mat Double pointer to the array
 */
public static native void cvReleaseMatND( @Cast("CvMatND**") PointerPointer mat );
public static native void cvReleaseMatND( @ByPtrPtr CvMatND mat );

/** Creates a copy of CvMatND (except, may be, steps) */
public static native CvMatND cvCloneMatND( @Const CvMatND mat );

/** \brief Creates sparse array.
<p>
The function allocates a multi-dimensional sparse array. Initially the array contain no elements,
that is PtrND and other related functions will return 0 for every index.
@param dims Number of array dimensions. In contrast to the dense matrix, the number of dimensions is
practically unlimited (up to {@code 2^{16}} ).
@param sizes Array of dimension sizes
@param type Type of array elements. The same as for CvMat
 */
public static native CvSparseMat cvCreateSparseMat( int dims, @Const IntPointer sizes, int type );
public static native CvSparseMat cvCreateSparseMat( int dims, @Const IntBuffer sizes, int type );
public static native CvSparseMat cvCreateSparseMat( int dims, @Const int[] sizes, int type );

/** \brief Deallocates sparse array.
<p>
The function releases the sparse array and clears the array pointer upon exit.
@param mat Double pointer to the array
 */
public static native void cvReleaseSparseMat( @Cast("CvSparseMat**") PointerPointer mat );
public static native void cvReleaseSparseMat( @ByPtrPtr CvSparseMat mat );

/** Creates a copy of CvSparseMat (except, may be, zero items) */
public static native CvSparseMat cvCloneSparseMat( @Const CvSparseMat mat );

/** \brief Initializes sparse array elements iterator.
<p>
The function initializes iterator of sparse array elements and returns pointer to the first element,
or NULL if the array is empty.
@param mat Input array
@param mat_iterator Initialized iterator
 */
public static native CvSparseNode cvInitSparseMatIterator( @Const CvSparseMat mat,
                                              CvSparseMatIterator mat_iterator );

/** \brief Returns the next sparse matrix element
<p>
The function moves iterator to the next sparse matrix element and returns pointer to it. In the
current version there is no any particular order of the elements, because they are stored in the
hash table. The sample below demonstrates how to iterate through the sparse matrix:
<pre>{@code
    // print all the non-zero sparse matrix elements and compute their sum
    double sum = 0;
    int i, dims = cvGetDims(sparsemat);
    CvSparseMatIterator it;
    CvSparseNode* node = cvInitSparseMatIterator(sparsemat, &it);

    for(; node != 0; node = cvGetNextSparseNode(&it))
    {
        int* idx = CV_NODE_IDX(array, node);
        float val = *(float*)CV_NODE_VAL(array, node);
        printf("M");
        for(i = 0; i < dims; i++ )
            printf("[%d]", idx[i]);
        printf("=%g\n", val);

        sum += val;
    }

    printf("nTotal sum = %g\n", sum);
}</pre>
@param mat_iterator Sparse array iterator
 */
public static native CvSparseNode cvGetNextSparseNode( CvSparseMatIterator mat_iterator );


public static final int CV_MAX_ARR = 10;
// Targeting ..\opencv_core\CvNArrayIterator.java



public static final int CV_NO_DEPTH_CHECK =     1;
public static final int CV_NO_CN_CHECK =        2;
public static final int CV_NO_SIZE_CHECK =      4;

/** initializes iterator that traverses through several arrays simultaneously
   (the function together with cvNextArraySlice is used for
    N-ari element-wise operations) */
public static native int cvInitNArrayIterator( int count, @Cast("CvArr**") PointerPointer arrs,
                                 @Const CvArr mask, CvMatND stubs,
                                 CvNArrayIterator array_iterator,
                                 int flags/*=0*/ );
public static native int cvInitNArrayIterator( int count, @ByPtrPtr CvArr arrs,
                                 @Const CvArr mask, CvMatND stubs,
                                 CvNArrayIterator array_iterator );
public static native int cvInitNArrayIterator( int count, @ByPtrPtr CvArr arrs,
                                 @Const CvArr mask, CvMatND stubs,
                                 CvNArrayIterator array_iterator,
                                 int flags/*=0*/ );

/** returns zero value if iteration is finished, non-zero (slice length) otherwise */
public static native int cvNextNArraySlice( CvNArrayIterator array_iterator );


/** \brief Returns type of array elements.
<p>
The function returns type of the array elements. In the case of IplImage the type is converted to
CvMat-like representation. For example, if the image has been created as:
<pre>{@code
    IplImage* img = cvCreateImage(cvSize(640, 480), IPL_DEPTH_8U, 3);
}</pre>
The code cvGetElemType(img) will return CV_8UC3.
@param arr Input array
 */
public static native int cvGetElemType( @Const CvArr arr );

/** \brief Return number of array dimensions
<p>
The function returns the array dimensionality and the array of dimension sizes. In the case of
IplImage or CvMat it always returns 2 regardless of number of image/matrix rows. For example, the
following code calculates total number of array elements:
<pre>{@code
    int sizes[CV_MAX_DIM];
    int i, total = 1;
    int dims = cvGetDims(arr, size);
    for(i = 0; i < dims; i++ )
        total *= sizes[i];
}</pre>
@param arr Input array
@param sizes Optional output vector of the array dimension sizes. For 2d arrays the number of rows
(height) goes first, number of columns (width) next.
 */
public static native int cvGetDims( @Const CvArr arr, IntPointer sizes/*=NULL*/ );
public static native int cvGetDims( @Const CvArr arr );
public static native int cvGetDims( @Const CvArr arr, IntBuffer sizes/*=NULL*/ );
public static native int cvGetDims( @Const CvArr arr, int[] sizes/*=NULL*/ );


/** \brief Returns array size along the specified dimension.
<p>
@param arr Input array
@param index Zero-based dimension index (for matrices 0 means number of rows, 1 means number of
columns; for images 0 means height, 1 means width)
 */
public static native int cvGetDimSize( @Const CvArr arr, int index );


/** \brief Return pointer to a particular array element.
<p>
The functions return a pointer to a specific array element. Number of array dimension should match
to the number of indices passed to the function except for cvPtr1D function that can be used for
sequential access to 1D, 2D or nD dense arrays.
<p>
The functions can be used for sparse arrays as well - if the requested node does not exist they
create it and set it to zero.
<p>
All these as well as other functions accessing array elements ( cvGetND , cvGetRealND , cvSet
, cvSetND , cvSetRealND ) raise an error in case if the element index is out of range.
@param arr Input array
@param idx0 The first zero-based component of the element index
@param type Optional output parameter: type of matrix elements
 */
public static native @Cast("uchar*") BytePointer cvPtr1D( @Const CvArr arr, int idx0, IntPointer type/*=NULL*/);
public static native @Cast("uchar*") BytePointer cvPtr1D( @Const CvArr arr, int idx0);
public static native @Cast("uchar*") ByteBuffer cvPtr1D( @Const CvArr arr, int idx0, IntBuffer type/*=NULL*/);
public static native @Cast("uchar*") byte[] cvPtr1D( @Const CvArr arr, int idx0, int[] type/*=NULL*/);
/** \overload */
public static native @Cast("uchar*") BytePointer cvPtr2D( @Const CvArr arr, int idx0, int idx1, IntPointer type/*=NULL*/ );
public static native @Cast("uchar*") BytePointer cvPtr2D( @Const CvArr arr, int idx0, int idx1 );
public static native @Cast("uchar*") ByteBuffer cvPtr2D( @Const CvArr arr, int idx0, int idx1, IntBuffer type/*=NULL*/ );
public static native @Cast("uchar*") byte[] cvPtr2D( @Const CvArr arr, int idx0, int idx1, int[] type/*=NULL*/ );
/** \overload */
public static native @Cast("uchar*") BytePointer cvPtr3D( @Const CvArr arr, int idx0, int idx1, int idx2,
                      IntPointer type/*=NULL*/);
public static native @Cast("uchar*") BytePointer cvPtr3D( @Const CvArr arr, int idx0, int idx1, int idx2);
public static native @Cast("uchar*") ByteBuffer cvPtr3D( @Const CvArr arr, int idx0, int idx1, int idx2,
                      IntBuffer type/*=NULL*/);
public static native @Cast("uchar*") byte[] cvPtr3D( @Const CvArr arr, int idx0, int idx1, int idx2,
                      int[] type/*=NULL*/);
/** \overload
@param arr Input array
@param idx Array of the element indices
@param type Optional output parameter: type of matrix elements
@param create_node Optional input parameter for sparse matrices. Non-zero value of the parameter
means that the requested element is created if it does not exist already.
@param precalc_hashval Optional input parameter for sparse matrices. If the pointer is not NULL,
the function does not recalculate the node hash value, but takes it from the specified location.
It is useful for speeding up pair-wise operations (TODO: provide an example)
*/
public static native @Cast("uchar*") BytePointer cvPtrND( @Const CvArr arr, @Const IntPointer idx, IntPointer type/*=NULL*/,
                      int create_node/*=1*/,
                      @Cast("unsigned*") IntPointer precalc_hashval/*=NULL*/);
public static native @Cast("uchar*") BytePointer cvPtrND( @Const CvArr arr, @Const IntPointer idx);
public static native @Cast("uchar*") ByteBuffer cvPtrND( @Const CvArr arr, @Const IntBuffer idx, IntBuffer type/*=NULL*/,
                      int create_node/*=1*/,
                      @Cast("unsigned*") IntBuffer precalc_hashval/*=NULL*/);
public static native @Cast("uchar*") ByteBuffer cvPtrND( @Const CvArr arr, @Const IntBuffer idx);
public static native @Cast("uchar*") byte[] cvPtrND( @Const CvArr arr, @Const int[] idx, int[] type/*=NULL*/,
                      int create_node/*=1*/,
                      @Cast("unsigned*") int[] precalc_hashval/*=NULL*/);
public static native @Cast("uchar*") byte[] cvPtrND( @Const CvArr arr, @Const int[] idx);

/** \brief Return a specific array element.
<p>
The functions return a specific array element. In the case of a sparse array the functions return 0
if the requested node does not exist (no new node is created by the functions).
@param arr Input array
@param idx0 The first zero-based component of the element index
 */
public static native @ByVal CvScalar cvGet1D( @Const CvArr arr, int idx0 );
/** \overload */
public static native @ByVal CvScalar cvGet2D( @Const CvArr arr, int idx0, int idx1 );
/** \overload */
public static native @ByVal CvScalar cvGet3D( @Const CvArr arr, int idx0, int idx1, int idx2 );
/** \overload
@param arr Input array
@param idx Array of the element indices
*/
public static native @ByVal CvScalar cvGetND( @Const CvArr arr, @Const IntPointer idx );
public static native @ByVal CvScalar cvGetND( @Const CvArr arr, @Const IntBuffer idx );
public static native @ByVal CvScalar cvGetND( @Const CvArr arr, @Const int[] idx );

/** \brief Return a specific element of single-channel 1D, 2D, 3D or nD array.
<p>
Returns a specific element of a single-channel array. If the array has multiple channels, a runtime
error is raised. Note that Get?D functions can be used safely for both single-channel and
multiple-channel arrays though they are a bit slower.
<p>
In the case of a sparse array the functions return 0 if the requested node does not exist (no new
node is created by the functions).
@param arr Input array. Must have a single channel.
@param idx0 The first zero-based component of the element index
 */
public static native double cvGetReal1D( @Const CvArr arr, int idx0 );
/** \overload */
public static native double cvGetReal2D( @Const CvArr arr, int idx0, int idx1 );
/** \overload */
public static native double cvGetReal3D( @Const CvArr arr, int idx0, int idx1, int idx2 );
/** \overload
@param arr Input array. Must have a single channel.
@param idx Array of the element indices
*/
public static native double cvGetRealND( @Const CvArr arr, @Const IntPointer idx );
public static native double cvGetRealND( @Const CvArr arr, @Const IntBuffer idx );
public static native double cvGetRealND( @Const CvArr arr, @Const int[] idx );

/** \brief Change the particular array element.
<p>
The functions assign the new value to a particular array element. In the case of a sparse array the
functions create the node if it does not exist yet.
@param arr Input array
@param idx0 The first zero-based component of the element index
@param value The assigned value
 */
public static native void cvSet1D( CvArr arr, int idx0, @ByVal CvScalar value );
/** \overload */
public static native void cvSet2D( CvArr arr, int idx0, int idx1, @ByVal CvScalar value );
/** \overload */
public static native void cvSet3D( CvArr arr, int idx0, int idx1, int idx2, @ByVal CvScalar value );
/** \overload
@param arr Input array
@param idx Array of the element indices
@param value The assigned value
*/
public static native void cvSetND( CvArr arr, @Const IntPointer idx, @ByVal CvScalar value );
public static native void cvSetND( CvArr arr, @Const IntBuffer idx, @ByVal CvScalar value );
public static native void cvSetND( CvArr arr, @Const int[] idx, @ByVal CvScalar value );

/** \brief Change a specific array element.
<p>
The functions assign a new value to a specific element of a single-channel array. If the array has
multiple channels, a runtime error is raised. Note that the Set\*D function can be used safely for
both single-channel and multiple-channel arrays, though they are a bit slower.
<p>
In the case of a sparse array the functions create the node if it does not yet exist.
@param arr Input array
@param idx0 The first zero-based component of the element index
@param value The assigned value
 */
public static native void cvSetReal1D( CvArr arr, int idx0, double value );
/** \overload */
public static native void cvSetReal2D( CvArr arr, int idx0, int idx1, double value );
/** \overload */
public static native void cvSetReal3D( CvArr arr, int idx0,
                        int idx1, int idx2, double value );
/** \overload
@param arr Input array
@param idx Array of the element indices
@param value The assigned value
*/
public static native void cvSetRealND( CvArr arr, @Const IntPointer idx, double value );
public static native void cvSetRealND( CvArr arr, @Const IntBuffer idx, double value );
public static native void cvSetRealND( CvArr arr, @Const int[] idx, double value );

/** clears element of ND dense array,
   in case of sparse arrays it deletes the specified node */
public static native void cvClearND( CvArr arr, @Const IntPointer idx );
public static native void cvClearND( CvArr arr, @Const IntBuffer idx );
public static native void cvClearND( CvArr arr, @Const int[] idx );

/** \brief Returns matrix header for arbitrary array.
<p>
The function returns a matrix header for the input array that can be a matrix - CvMat, an image -
IplImage, or a multi-dimensional dense array - CvMatND (the third option is allowed only if
allowND != 0) . In the case of matrix the function simply returns the input pointer. In the case of
IplImage\* or CvMatND it initializes the header structure with parameters of the current image ROI
and returns &header. Because COI is not supported by CvMat, it is returned separately.
<p>
The function provides an easy way to handle both types of arrays - IplImage and CvMat using the same
code. Input array must have non-zero data pointer, otherwise the function will report an error.
<p>
\note If the input array is IplImage with planar data layout and COI set, the function returns the
pointer to the selected plane and COI == 0. This feature allows user to process IplImage structures
with planar data layout, even though OpenCV does not support such images.
@param arr Input array
@param header Pointer to CvMat structure used as a temporary buffer
@param coi Optional output parameter for storing COI
@param allowND If non-zero, the function accepts multi-dimensional dense arrays (CvMatND\*) and
returns 2D matrix (if CvMatND has two dimensions) or 1D matrix (when CvMatND has 1 dimension or
more than 2 dimensions). The CvMatND array must be continuous.
@see cvGetImage, cvarrToMat.
 */
public static native CvMat cvGetMat( @Const CvArr arr, CvMat header,
                       IntPointer coi/*=NULL*/,
                       int allowND/*=0*/);
public static native CvMat cvGetMat( @Const CvArr arr, CvMat header);
public static native CvMat cvGetMat( @Const CvArr arr, CvMat header,
                       IntBuffer coi/*=NULL*/,
                       int allowND/*=0*/);
public static native CvMat cvGetMat( @Const CvArr arr, CvMat header,
                       int[] coi/*=NULL*/,
                       int allowND/*=0*/);

/** \brief Returns image header for arbitrary array.
<p>
The function returns the image header for the input array that can be a matrix (CvMat) or image
(IplImage). In the case of an image the function simply returns the input pointer. In the case of
CvMat it initializes an image_header structure with the parameters of the input matrix. Note that
if we transform IplImage to CvMat using cvGetMat and then transform CvMat back to IplImage using
this function, we will get different headers if the ROI is set in the original image.
@param arr Input array
@param image_header Pointer to IplImage structure used as a temporary buffer
 */
public static native IplImage cvGetImage( @Const CvArr arr, IplImage image_header );


/** \brief Changes the shape of a multi-dimensional array without copying the data.
<p>
The function is an advanced version of cvReshape that can work with multi-dimensional arrays as
well (though it can work with ordinary images and matrices) and change the number of dimensions.
<p>
Below are the two samples from the cvReshape description rewritten using cvReshapeMatND:
<pre>{@code
    IplImage* color_img = cvCreateImage(cvSize(320,240), IPL_DEPTH_8U, 3);
    IplImage gray_img_hdr, *gray_img;
    gray_img = (IplImage*)cvReshapeMatND(color_img, sizeof(gray_img_hdr), &gray_img_hdr, 1, 0, 0);
    ...
    int size[] = { 2, 2, 2 };
    CvMatND* mat = cvCreateMatND(3, size, CV_32F);
    CvMat row_header, *row;
    row = (CvMat*)cvReshapeMatND(mat, sizeof(row_header), &row_header, 0, 1, 0);
}</pre>
In C, the header file for this function includes a convenient macro cvReshapeND that does away with
the sizeof_header parameter. So, the lines containing the call to cvReshapeMatND in the examples
may be replaced as follow:
<pre>{@code
    gray_img = (IplImage*)cvReshapeND(color_img, &gray_img_hdr, 1, 0, 0);
    ...
    row = (CvMat*)cvReshapeND(mat, &row_header, 0, 1, 0);
}</pre>
@param arr Input array
@param sizeof_header Size of output header to distinguish between IplImage, CvMat and CvMatND
output headers
@param header Output header to be filled
@param new_cn New number of channels. new_cn = 0 means that the number of channels remains
unchanged.
@param new_dims New number of dimensions. new_dims = 0 means that the number of dimensions
remains the same.
@param new_sizes Array of new dimension sizes. Only new_dims-1 values are used, because the
total number of elements must remain the same. Thus, if new_dims = 1, new_sizes array is not
used.
 */
public static native CvArr cvReshapeMatND( @Const CvArr arr,
                             int sizeof_header, CvArr header,
                             int new_cn, int new_dims, IntPointer new_sizes );
public static native CvArr cvReshapeMatND( @Const CvArr arr,
                             int sizeof_header, CvArr header,
                             int new_cn, int new_dims, IntBuffer new_sizes );
public static native CvArr cvReshapeMatND( @Const CvArr arr,
                             int sizeof_header, CvArr header,
                             int new_cn, int new_dims, int[] new_sizes );

// #define cvReshapeND( arr, header, new_cn, new_dims, new_sizes )
//       cvReshapeMatND( (arr), sizeof(*(header)), (header),
//                       (new_cn), (new_dims), (new_sizes))

/** \brief Changes shape of matrix/image without copying data.
<p>
The function initializes the CvMat header so that it points to the same data as the original array
but has a different shape - different number of channels, different number of rows, or both.
<p>
The following example code creates one image buffer and two image headers, the first is for a
320x240x3 image and the second is for a 960x240x1 image:
<pre>{@code
    IplImage* color_img = cvCreateImage(cvSize(320,240), IPL_DEPTH_8U, 3);
    CvMat gray_mat_hdr;
    IplImage gray_img_hdr, *gray_img;
    cvReshape(color_img, &gray_mat_hdr, 1);
    gray_img = cvGetImage(&gray_mat_hdr, &gray_img_hdr);
}</pre>
And the next example converts a 3x3 matrix to a single 1x9 vector:
<pre>{@code
    CvMat* mat = cvCreateMat(3, 3, CV_32F);
    CvMat row_header, *row;
    row = cvReshape(mat, &row_header, 0, 1);
}</pre>
@param arr Input array
@param header Output header to be filled
@param new_cn New number of channels. 'new_cn = 0' means that the number of channels remains
unchanged.
@param new_rows New number of rows. 'new_rows = 0' means that the number of rows remains
unchanged unless it needs to be changed according to new_cn value.
*/
public static native CvMat cvReshape( @Const CvArr arr, CvMat header,
                        int new_cn, int new_rows/*=0*/ );
public static native CvMat cvReshape( @Const CvArr arr, CvMat header,
                        int new_cn );

/** Repeats source 2d array several times in both horizontal and
   vertical direction to fill destination array */
public static native void cvRepeat( @Const CvArr src, CvArr dst );

/** \brief Allocates array data
<p>
The function allocates image, matrix or multi-dimensional dense array data. Note that in the case of
matrix types OpenCV allocation functions are used. In the case of IplImage they are used unless
CV_TURN_ON_IPL_COMPATIBILITY() has been called before. In the latter case IPL functions are used
to allocate the data.
@param arr Array header
 */
public static native void cvCreateData( CvArr arr );

/** \brief Releases array data.
<p>
The function releases the array data. In the case of CvMat or CvMatND it simply calls
cvDecRefData(), that is the function can not deallocate external data. See also the note to
cvCreateData .
@param arr Array header
 */
public static native void cvReleaseData( CvArr arr );

/** \brief Assigns user data to the array header.
<p>
The function assigns user data to the array header. Header should be initialized before using
cvCreateMatHeader, cvCreateImageHeader, cvCreateMatNDHeader, cvInitMatHeader,
cvInitImageHeader or cvInitMatNDHeader.
@param arr Array header
@param data User data
@param step Full row length in bytes
 */
public static native void cvSetData( CvArr arr, Pointer data, int step );

/** \brief Retrieves low-level information about the array.
<p>
The function fills output variables with low-level information about the array data. All output
<p>
parameters are optional, so some of the pointers may be set to NULL. If the array is IplImage with
ROI set, the parameters of ROI are returned.
<p>
The following example shows how to get access to array elements. It computes absolute values of the
array elements :
<pre>{@code
    float* data;
    int step;
    CvSize size;

    cvGetRawData(array, (uchar**)&data, &step, &size);
    step /= sizeof(data[0]);

    for(int y = 0; y < size.height; y++, data += step )
        for(int x = 0; x < size.width; x++ )
            data[x] = (float)fabs(data[x]);
}</pre>
@param arr Array header
@param data Output pointer to the whole image origin or ROI origin if ROI is set
@param step Output full row length in bytes
@param roi_size Output ROI size
 */
public static native void cvGetRawData( @Const CvArr arr, @Cast("uchar**") PointerPointer data,
                         IntPointer step/*=NULL*/,
                         CvSize roi_size/*=NULL*/);
public static native void cvGetRawData( @Const CvArr arr, @Cast("uchar**") @ByPtrPtr BytePointer data);
public static native void cvGetRawData( @Const CvArr arr, @Cast("uchar**") @ByPtrPtr BytePointer data,
                         IntPointer step/*=NULL*/,
                         CvSize roi_size/*=NULL*/);
public static native void cvGetRawData( @Const CvArr arr, @Cast("uchar**") @ByPtrPtr ByteBuffer data,
                         IntBuffer step/*=NULL*/,
                         CvSize roi_size/*=NULL*/);
public static native void cvGetRawData( @Const CvArr arr, @Cast("uchar**") @ByPtrPtr ByteBuffer data);
public static native void cvGetRawData( @Const CvArr arr, @Cast("uchar**") @ByPtrPtr byte[] data,
                         int[] step/*=NULL*/,
                         CvSize roi_size/*=NULL*/);
public static native void cvGetRawData( @Const CvArr arr, @Cast("uchar**") @ByPtrPtr byte[] data);

/** \brief Returns size of matrix or image ROI.
<p>
The function returns number of rows (CvSize::height) and number of columns (CvSize::width) of the
input matrix or image. In the case of image the size of ROI is returned.
@param arr array header
 */
public static native @ByVal CvSize cvGetSize( @Const CvArr arr );

/** \brief Copies one array to another.
<p>
The function copies selected elements from an input array to an output array:
<p>
<pre>{@code \[\texttt{dst} (I)= \texttt{src} (I)  \quad \text{if} \quad \texttt{mask} (I)  \ne 0.\]}</pre>
<p>
If any of the passed arrays is of IplImage type, then its ROI and COI fields are used. Both arrays
must have the same type, the same number of dimensions, and the same size. The function can also
copy sparse arrays (mask is not supported in this case).
@param src The source array
@param dst The destination array
@param mask Operation mask, 8-bit single channel array; specifies elements of the destination array
to be changed
 */
public static native void cvCopy( @Const CvArr src, CvArr dst,
                     @Const CvArr mask/*=NULL*/ );
public static native void cvCopy( @Const CvArr src, CvArr dst );

/** \brief Sets every element of an array to a given value.
<p>
The function copies the scalar value to every selected element of the destination array:
<pre>{@code \[\texttt{arr} (I)= \texttt{value} \quad \text{if} \quad \texttt{mask} (I)  \ne 0\]}</pre>
If array arr is of IplImage type, then is ROI used, but COI must not be set.
@param arr The destination array
@param value Fill value
@param mask Operation mask, 8-bit single channel array; specifies elements of the destination
array to be changed
 */
public static native void cvSet( CvArr arr, @ByVal CvScalar value,
                    @Const CvArr mask/*=NULL*/ );
public static native void cvSet( CvArr arr, @ByVal CvScalar value );

/** \brief Clears the array.
<p>
The function clears the array. In the case of dense arrays (CvMat, CvMatND or IplImage),
cvZero(array) is equivalent to cvSet(array,cvScalarAll(0),0). In the case of sparse arrays all the
elements are removed.
@param arr Array to be cleared
 */
public static native void cvSetZero( CvArr arr );
public static native void cvZero(CvArr arg1);


/** Splits a multi-channel array into the set of single-channel arrays or
   extracts particular [color] plane */
public static native void cvSplit( @Const CvArr src, CvArr dst0, CvArr dst1,
                      CvArr dst2, CvArr dst3 );

/** Merges a set of single-channel arrays into the single multi-channel array
   or inserts one particular [color] plane to the array */
public static native void cvMerge( @Const CvArr src0, @Const CvArr src1,
                      @Const CvArr src2, @Const CvArr src3,
                      CvArr dst );

/** Copies several channels from input arrays to
   certain channels of output arrays */
public static native void cvMixChannels( @Cast("const CvArr**") PointerPointer src, int src_count,
                            @Cast("CvArr**") PointerPointer dst, int dst_count,
                            @Const IntPointer from_to, int pair_count );
public static native void cvMixChannels( @Const @ByPtrPtr CvArr src, int src_count,
                            @ByPtrPtr CvArr dst, int dst_count,
                            @Const IntPointer from_to, int pair_count );
public static native void cvMixChannels( @Const @ByPtrPtr CvArr src, int src_count,
                            @ByPtrPtr CvArr dst, int dst_count,
                            @Const IntBuffer from_to, int pair_count );
public static native void cvMixChannels( @Const @ByPtrPtr CvArr src, int src_count,
                            @ByPtrPtr CvArr dst, int dst_count,
                            @Const int[] from_to, int pair_count );

/** \brief Converts one array to another with optional linear transformation.
<p>
The function has several different purposes, and thus has several different names. It copies one
array to another with optional scaling, which is performed first, and/or optional type conversion,
performed after:
<p>
<pre>{@code \[\texttt{dst} (I) =  \texttt{scale} \texttt{src} (I) + ( \texttt{shift} _0, \texttt{shift} _1,...)\]}</pre>
<p>
All the channels of multi-channel arrays are processed independently.
<p>
The type of conversion is done with rounding and saturation, that is if the result of scaling +
conversion can not be represented exactly by a value of the destination array element type, it is
set to the nearest representable value on the real axis.
@param src Source array
@param dst Destination array
@param scale Scale factor
@param shift Value added to the scaled source array elements
 */
public static native void cvConvertScale( @Const CvArr src, CvArr dst,
                             double scale/*=1*/,
                             double shift/*=0*/ );
public static native void cvConvertScale( @Const CvArr src, CvArr dst );
public static native void cvCvtScale(CvArr arg1, CvArr arg2, double arg3, double arg4);
public static native void cvScale(CvArr arg1, CvArr arg2, double arg3, double arg4);
public static native void cvConvert(CvArr src, CvArr dst);


/** Performs linear transformation on every source array element,
   stores absolute value of the result:
   dst(x,y,c) = abs(scale*src(x,y,c)+shift).
   destination array must have 8u type.
   In other cases one may use cvConvertScale + cvAbsDiffS */
public static native void cvConvertScaleAbs( @Const CvArr src, CvArr dst,
                                double scale/*=1*/,
                                double shift/*=0*/ );
public static native void cvConvertScaleAbs( @Const CvArr src, CvArr dst );
public static native void cvCvtScaleAbs(CvArr arg1, CvArr arg2, double arg3, double arg4);


/** checks termination criteria validity and
   sets eps to default_eps (if it is not set),
   max_iter to default_max_iters (if it is not set)
*/
public static native @ByVal CvTermCriteria cvCheckTermCriteria( @ByVal CvTermCriteria criteria,
                                           double default_eps,
                                           int default_max_iters );

/****************************************************************************************\
*                   Arithmetic, logic and comparison operations                          *
\****************************************************************************************/

/** dst(mask) = src1(mask) + src2(mask) */
public static native void cvAdd( @Const CvArr src1, @Const CvArr src2, CvArr dst,
                    @Const CvArr mask/*=NULL*/);
public static native void cvAdd( @Const CvArr src1, @Const CvArr src2, CvArr dst);

/** dst(mask) = src(mask) + value */
public static native void cvAddS( @Const CvArr src, @ByVal CvScalar value, CvArr dst,
                     @Const CvArr mask/*=NULL*/);
public static native void cvAddS( @Const CvArr src, @ByVal CvScalar value, CvArr dst);

/** dst(mask) = src1(mask) - src2(mask) */
public static native void cvSub( @Const CvArr src1, @Const CvArr src2, CvArr dst,
                    @Const CvArr mask/*=NULL*/);
public static native void cvSub( @Const CvArr src1, @Const CvArr src2, CvArr dst);

/** dst(mask) = src(mask) - value = src(mask) + (-value) */
public static native void cvSubS( @Const CvArr src, @ByVal CvScalar value, CvArr dst,
                         @Const CvArr mask/*=NULL*/);
public static native void cvSubS( @Const CvArr src, @ByVal CvScalar value, CvArr dst);

/** dst(mask) = value - src(mask) */
public static native void cvSubRS( @Const CvArr src, @ByVal CvScalar value, CvArr dst,
                      @Const CvArr mask/*=NULL*/);
public static native void cvSubRS( @Const CvArr src, @ByVal CvScalar value, CvArr dst);

/** dst(idx) = src1(idx) * src2(idx) * scale
   (scaled element-wise multiplication of 2 arrays) */
public static native void cvMul( @Const CvArr src1, @Const CvArr src2,
                    CvArr dst, double scale/*=1*/ );
public static native void cvMul( @Const CvArr src1, @Const CvArr src2,
                    CvArr dst );

/** element-wise division/inversion with scaling:
    dst(idx) = src1(idx) * scale / src2(idx)
    or dst(idx) = scale / src2(idx) if src1 == 0 */
public static native void cvDiv( @Const CvArr src1, @Const CvArr src2,
                    CvArr dst, double scale/*=1*/);
public static native void cvDiv( @Const CvArr src1, @Const CvArr src2,
                    CvArr dst);

/** dst = src1 * scale + src2 */
public static native void cvScaleAdd( @Const CvArr src1, @ByVal CvScalar scale,
                         @Const CvArr src2, CvArr dst );
// #define cvAXPY( A, real_scalar, B, C ) cvScaleAdd(A, cvRealScalar(real_scalar), B, C)

/** dst = src1 * alpha + src2 * beta + gamma */
public static native void cvAddWeighted( @Const CvArr src1, double alpha,
                            @Const CvArr src2, double beta,
                            double gamma, CvArr dst );

/** \brief Calculates the dot product of two arrays in Euclidean metrics.
<p>
The function calculates and returns the Euclidean dot product of two arrays.
<p>
<pre>{@code \[src1  \bullet src2 =  \sum _I ( \texttt{src1} (I)  \texttt{src2} (I))\]}</pre>
<p>
In the case of multiple channel arrays, the results for all channels are accumulated. In particular,
cvDotProduct(a,a) where a is a complex vector, will return {@code ||\texttt{a}||^2}. The function can
process multi-dimensional arrays, row by row, layer by layer, and so on.
@param src1 The first source array
@param src2 The second source array
 */
public static native double cvDotProduct( @Const CvArr src1, @Const CvArr src2 );

/** dst(idx) = src1(idx) & src2(idx) */
public static native void cvAnd( @Const CvArr src1, @Const CvArr src2,
                  CvArr dst, @Const CvArr mask/*=NULL*/);
public static native void cvAnd( @Const CvArr src1, @Const CvArr src2,
                  CvArr dst);

/** dst(idx) = src(idx) & value */
public static native void cvAndS( @Const CvArr src, @ByVal CvScalar value,
                   CvArr dst, @Const CvArr mask/*=NULL*/);
public static native void cvAndS( @Const CvArr src, @ByVal CvScalar value,
                   CvArr dst);

/** dst(idx) = src1(idx) | src2(idx) */
public static native void cvOr( @Const CvArr src1, @Const CvArr src2,
                 CvArr dst, @Const CvArr mask/*=NULL*/);
public static native void cvOr( @Const CvArr src1, @Const CvArr src2,
                 CvArr dst);

/** dst(idx) = src(idx) | value */
public static native void cvOrS( @Const CvArr src, @ByVal CvScalar value,
                  CvArr dst, @Const CvArr mask/*=NULL*/);
public static native void cvOrS( @Const CvArr src, @ByVal CvScalar value,
                  CvArr dst);

/** dst(idx) = src1(idx) ^ src2(idx) */
public static native void cvXor( @Const CvArr src1, @Const CvArr src2,
                  CvArr dst, @Const CvArr mask/*=NULL*/);
public static native void cvXor( @Const CvArr src1, @Const CvArr src2,
                  CvArr dst);

/** dst(idx) = src(idx) ^ value */
public static native void cvXorS( @Const CvArr src, @ByVal CvScalar value,
                   CvArr dst, @Const CvArr mask/*=NULL*/);
public static native void cvXorS( @Const CvArr src, @ByVal CvScalar value,
                   CvArr dst);

/** dst(idx) = ~src(idx) */
public static native void cvNot( @Const CvArr src, CvArr dst );

/** dst(idx) = lower(idx) <= src(idx) < upper(idx) */
public static native void cvInRange( @Const CvArr src, @Const CvArr lower,
                      @Const CvArr upper, CvArr dst );

/** dst(idx) = lower <= src(idx) < upper */
public static native void cvInRangeS( @Const CvArr src, @ByVal CvScalar lower,
                       @ByVal CvScalar upper, CvArr dst );

public static final int CV_CMP_EQ =   0;
public static final int CV_CMP_GT =   1;
public static final int CV_CMP_GE =   2;
public static final int CV_CMP_LT =   3;
public static final int CV_CMP_LE =   4;
public static final int CV_CMP_NE =   5;

/** The comparison operation support single-channel arrays only.
   Destination image should be 8uC1 or 8sC1 */

/** dst(idx) = src1(idx) _cmp_op_ src2(idx) */
public static native void cvCmp( @Const CvArr src1, @Const CvArr src2, CvArr dst, int cmp_op );

/** dst(idx) = src1(idx) _cmp_op_ value */
public static native void cvCmpS( @Const CvArr src, double value, CvArr dst, int cmp_op );

/** dst(idx) = min(src1(idx),src2(idx)) */
public static native void cvMin( @Const CvArr src1, @Const CvArr src2, CvArr dst );

/** dst(idx) = max(src1(idx),src2(idx)) */
public static native void cvMax( @Const CvArr src1, @Const CvArr src2, CvArr dst );

/** dst(idx) = min(src(idx),value) */
public static native void cvMinS( @Const CvArr src, double value, CvArr dst );

/** dst(idx) = max(src(idx),value) */
public static native void cvMaxS( @Const CvArr src, double value, CvArr dst );

/** dst(x,y,c) = abs(src1(x,y,c) - src2(x,y,c)) */
public static native void cvAbsDiff( @Const CvArr src1, @Const CvArr src2, CvArr dst );

/** dst(x,y,c) = abs(src(x,y,c) - value(c)) */
public static native void cvAbsDiffS( @Const CvArr src, CvArr dst, @ByVal CvScalar value );
// #define cvAbs( src, dst ) cvAbsDiffS( (src), (dst), cvScalarAll(0))

/****************************************************************************************\
*                                Math operations                                         *
\****************************************************************************************/

/** Does cartesian->polar coordinates conversion.
   Either of output components (magnitude or angle) is optional */
public static native void cvCartToPolar( @Const CvArr x, @Const CvArr y,
                            CvArr magnitude, CvArr angle/*=NULL*/,
                            int angle_in_degrees/*=0*/);
public static native void cvCartToPolar( @Const CvArr x, @Const CvArr y,
                            CvArr magnitude);

/** Does polar->cartesian coordinates conversion.
   Either of output components (magnitude or angle) is optional.
   If magnitude is missing it is assumed to be all 1's */
public static native void cvPolarToCart( @Const CvArr magnitude, @Const CvArr angle,
                            CvArr x, CvArr y,
                            int angle_in_degrees/*=0*/);
public static native void cvPolarToCart( @Const CvArr magnitude, @Const CvArr angle,
                            CvArr x, CvArr y);

/** Does powering: dst(idx) = src(idx)^power */
public static native void cvPow( @Const CvArr src, CvArr dst, double power );

/** Does exponention: dst(idx) = exp(src(idx)).
   Overflow is not handled yet. Underflow is handled.
   Maximal relative error is ~7e-6 for single-precision input */
public static native void cvExp( @Const CvArr src, CvArr dst );

/** Calculates natural logarithms: dst(idx) = log(abs(src(idx))).
   Logarithm of 0 gives large negative number(~-700)
   Maximal relative error is ~3e-7 for single-precision output
*/
public static native void cvLog( @Const CvArr src, CvArr dst );

/** Fast arctangent calculation */
public static native float cvFastArctan( float y, float x );

/** Fast cubic root calculation */
public static native float cvCbrt( float value );

public static final int CV_CHECK_RANGE =    1;
public static final int CV_CHECK_QUIET =    2;
/** Checks array values for NaNs, Infs or simply for too large numbers
   (if CV_CHECK_RANGE is set). If CV_CHECK_QUIET is set,
   no runtime errors is raised (function returns zero value in case of "bad" values).
   Otherwise cvError is called */
public static native int cvCheckArr( @Const CvArr arr, int flags/*=0*/,
                        double min_val/*=0*/, double max_val/*=0*/);
public static native int cvCheckArr( @Const CvArr arr);
public static native int cvCheckArray(CvArr arg1, int arg2, double arg3, double arg4);

public static final int CV_RAND_UNI =      0;
public static final int CV_RAND_NORMAL =   1;

/** \brief Fills an array with random numbers and updates the RNG state.
<p>
The function fills the destination array with uniformly or normally distributed random numbers.
@param rng CvRNG state initialized by cvRNG
@param arr The destination array
@param dist_type Distribution type
> -   **CV_RAND_UNI** uniform distribution
> -   **CV_RAND_NORMAL** normal or Gaussian distribution
@param param1 The first parameter of the distribution. In the case of a uniform distribution it is
the inclusive lower boundary of the random numbers range. In the case of a normal distribution it
is the mean value of the random numbers.
@param param2 The second parameter of the distribution. In the case of a uniform distribution it
is the exclusive upper boundary of the random numbers range. In the case of a normal distribution
it is the standard deviation of the random numbers.
@see randu, randn, RNG::fill.
 */
public static native void cvRandArr( @Cast("CvRNG*") LongPointer rng, CvArr arr, int dist_type,
                      @ByVal CvScalar param1, @ByVal CvScalar param2 );
public static native void cvRandArr( @Cast("CvRNG*") LongBuffer rng, CvArr arr, int dist_type,
                      @ByVal CvScalar param1, @ByVal CvScalar param2 );
public static native void cvRandArr( @Cast("CvRNG*") long[] rng, CvArr arr, int dist_type,
                      @ByVal CvScalar param1, @ByVal CvScalar param2 );

public static native void cvRandShuffle( CvArr mat, @Cast("CvRNG*") LongPointer rng,
                           double iter_factor/*=1.*/);
public static native void cvRandShuffle( CvArr mat, @Cast("CvRNG*") LongPointer rng);
public static native void cvRandShuffle( CvArr mat, @Cast("CvRNG*") LongBuffer rng,
                           double iter_factor/*=1.*/);
public static native void cvRandShuffle( CvArr mat, @Cast("CvRNG*") LongBuffer rng);
public static native void cvRandShuffle( CvArr mat, @Cast("CvRNG*") long[] rng,
                           double iter_factor/*=1.*/);
public static native void cvRandShuffle( CvArr mat, @Cast("CvRNG*") long[] rng);

public static final int CV_SORT_EVERY_ROW = 0;
public static final int CV_SORT_EVERY_COLUMN = 1;
public static final int CV_SORT_ASCENDING = 0;
public static final int CV_SORT_DESCENDING = 16;

public static native void cvSort( @Const CvArr src, CvArr dst/*=NULL*/,
                    CvArr idxmat/*=NULL*/,
                    int flags/*=0*/);
public static native void cvSort( @Const CvArr src);

/** Finds real roots of a cubic equation */
public static native int cvSolveCubic( @Const CvMat coeffs, CvMat roots );

/** Finds all real and complex roots of a polynomial equation */
public static native void cvSolvePoly(@Const CvMat coeffs, CvMat roots2,
      int maxiter/*=20*/, int fig/*=100*/);
public static native void cvSolvePoly(@Const CvMat coeffs, CvMat roots2);

/****************************************************************************************\
*                                Matrix operations                                       *
\****************************************************************************************/

/** \brief Calculates the cross product of two 3D vectors.
<p>
The function calculates the cross product of two 3D vectors:
<pre>{@code \[\texttt{dst} =  \texttt{src1} \times \texttt{src2}\]}</pre>
or:
<pre>{@code \[\begin{array}{l} \texttt{dst} _1 =  \texttt{src1} _2  \texttt{src2} _3 -  \texttt{src1} _3  \texttt{src2} _2 \\ \texttt{dst} _2 =  \texttt{src1} _3  \texttt{src2} _1 -  \texttt{src1} _1  \texttt{src2} _3 \\ \texttt{dst} _3 =  \texttt{src1} _1  \texttt{src2} _2 -  \texttt{src1} _2  \texttt{src2} _1 \end{array}\]}</pre>
@param src1 The first source vector
@param src2 The second source vector
@param dst The destination vector
 */
public static native void cvCrossProduct( @Const CvArr src1, @Const CvArr src2, CvArr dst );

/** Matrix transform: dst = A*B + C, C is optional */
public static native void cvMatMulAdd(CvArr src1, CvArr src2, CvArr src3, CvArr dst);
public static native void cvMatMul(CvArr src1, CvArr src2, CvArr dst);

public static final int CV_GEMM_A_T = 1;
public static final int CV_GEMM_B_T = 2;
public static final int CV_GEMM_C_T = 4;
/** Extended matrix transform:
   dst = alpha*op(A)*op(B) + beta*op(C), where op(X) is X or X^T */
public static native void cvGEMM( @Const CvArr src1, @Const CvArr src2, double alpha,
                     @Const CvArr src3, double beta, CvArr dst,
                     int tABC/*=0*/);
public static native void cvGEMM( @Const CvArr src1, @Const CvArr src2, double alpha,
                     @Const CvArr src3, double beta, CvArr dst);
public static native void cvMatMulAddEx(CvArr arg1, CvArr arg2, double arg3, CvArr arg4, double arg5, CvArr arg6, int arg7);

/** Transforms each element of source array and stores
   resultant vectors in destination array */
public static native void cvTransform( @Const CvArr src, CvArr dst,
                          @Const CvMat transmat,
                          @Const CvMat shiftvec/*=NULL*/);
public static native void cvTransform( @Const CvArr src, CvArr dst,
                          @Const CvMat transmat);
public static native void cvMatMulAddS(CvArr arg1, CvArr arg2, CvMat arg3, CvMat arg4);

/** Does perspective transform on every element of input array */
public static native void cvPerspectiveTransform( @Const CvArr src, CvArr dst,
                                     @Const CvMat mat );

/** Calculates (A-delta)*(A-delta)^T (order=0) or (A-delta)^T*(A-delta) (order=1) */
public static native void cvMulTransposed( @Const CvArr src, CvArr dst, int order,
                             @Const CvArr delta/*=NULL*/,
                             double scale/*=1.*/ );
public static native void cvMulTransposed( @Const CvArr src, CvArr dst, int order );

/** Transposes matrix. Square matrices can be transposed in-place */
public static native void cvTranspose( @Const CvArr src, CvArr dst );
public static native void cvT(CvArr arg1, CvArr arg2);

/** Completes the symmetric matrix from the lower (LtoR=0) or from the upper (LtoR!=0) part */
public static native void cvCompleteSymm( CvMat matrix, int LtoR/*=0*/ );
public static native void cvCompleteSymm( CvMat matrix );

/** Mirror array data around horizontal (flip=0),
   vertical (flip=1) or both(flip=-1) axises:
   cvFlip(src) flips images vertically and sequences horizontally (inplace) */
public static native void cvFlip( @Const CvArr src, CvArr dst/*=NULL*/,
                     int flip_mode/*=0*/);
public static native void cvFlip( @Const CvArr src);
public static native void cvMirror(CvArr arg1, CvArr arg2, int arg3);


public static final int CV_SVD_MODIFY_A =   1;
public static final int CV_SVD_U_T =        2;
public static final int CV_SVD_V_T =        4;

/** Performs Singular Value Decomposition of a matrix */
public static native void cvSVD( CvArr A, CvArr W, CvArr U/*=NULL*/,
                     CvArr V/*=NULL*/, int flags/*=0*/);
public static native void cvSVD( CvArr A, CvArr W);

/** Performs Singular Value Back Substitution (solves A*X = B):
   flags must be the same as in cvSVD */
public static native void cvSVBkSb( @Const CvArr W, @Const CvArr U,
                        @Const CvArr V, @Const CvArr B,
                        CvArr X, int flags );

public static final int CV_LU =  0;
public static final int CV_SVD = 1;
public static final int CV_SVD_SYM = 2;
public static final int CV_CHOLESKY = 3;
public static final int CV_QR =  4;
public static final int CV_NORMAL = 16;

/** Inverts matrix */
public static native double cvInvert( @Const CvArr src, CvArr dst,
                         int method/*=CV_LU*/);
public static native double cvInvert( @Const CvArr src, CvArr dst);
public static native void cvInv(CvArr arg1, CvArr arg2, int arg3);

/** Solves linear system (src1)*(dst) = (src2)
   (returns 0 if src1 is a singular and CV_LU method is used) */
public static native int cvSolve( @Const CvArr src1, @Const CvArr src2, CvArr dst,
                     int method/*=CV_LU*/);
public static native int cvSolve( @Const CvArr src1, @Const CvArr src2, CvArr dst);

/** Calculates determinant of input matrix */
public static native double cvDet( @Const CvArr mat );

/** Calculates trace of the matrix (sum of elements on the main diagonal) */
public static native @ByVal CvScalar cvTrace( @Const CvArr mat );

/** Finds eigen values and vectors of a symmetric matrix */
public static native void cvEigenVV( CvArr mat, CvArr evects, CvArr evals,
                        double eps/*=0*/,
                        int lowindex/*=-1*/,
                        int highindex/*=-1*/);
public static native void cvEigenVV( CvArr mat, CvArr evects, CvArr evals);

///* Finds selected eigen values and vectors of a symmetric matrix */
//CVAPI(void)  cvSelectedEigenVV( CvArr* mat, CvArr* evects, CvArr* evals,
//                                int lowindex, int highindex );

/** Makes an identity matrix (mat_ij = i == j) */
public static native void cvSetIdentity( CvArr mat, @ByVal(nullValue = "CvScalar(cvRealScalar(1))") CvScalar value );
public static native void cvSetIdentity( CvArr mat );

/** Fills matrix with given range of numbers */
public static native CvArr cvRange( CvArr mat, double start, double end );

/**   \anchor core_c_CovarFlags
\name Flags for cvCalcCovarMatrix
@see cvCalcCovarMatrix
  \{
*/

/** flag for cvCalcCovarMatrix, transpose([v1-avg, v2-avg,...]) * [v1-avg,v2-avg,...] */
public static final int CV_COVAR_SCRAMBLED = 0;

/** flag for cvCalcCovarMatrix, [v1-avg, v2-avg,...] * transpose([v1-avg,v2-avg,...]) */
public static final int CV_COVAR_NORMAL =    1;

/** flag for cvCalcCovarMatrix, do not calc average (i.e. mean vector) - use the input vector instead
   (useful for calculating covariance matrix by parts) */
public static final int CV_COVAR_USE_AVG =   2;

/** flag for cvCalcCovarMatrix, scale the covariance matrix coefficients by number of the vectors */
public static final int CV_COVAR_SCALE =     4;

/** flag for cvCalcCovarMatrix, all the input vectors are stored in a single matrix, as its rows */
public static final int CV_COVAR_ROWS =      8;

/** flag for cvCalcCovarMatrix, all the input vectors are stored in a single matrix, as its columns */
public static final int CV_COVAR_COLS =     16;

/** \} */

/** Calculates covariation matrix for a set of vectors
@see \ref core_c_CovarFlags "flags"
*/
public static native void cvCalcCovarMatrix( @Cast("const CvArr**") PointerPointer vects, int count,
                                CvArr cov_mat, CvArr avg, int flags );
public static native void cvCalcCovarMatrix( @Const @ByPtrPtr CvArr vects, int count,
                                CvArr cov_mat, CvArr avg, int flags );

public static final int CV_PCA_DATA_AS_ROW = 0;
public static final int CV_PCA_DATA_AS_COL = 1;
public static final int CV_PCA_USE_AVG = 2;
public static native void cvCalcPCA( @Const CvArr data, CvArr mean,
                        CvArr eigenvals, CvArr eigenvects, int flags );

public static native void cvProjectPCA( @Const CvArr data, @Const CvArr mean,
                           @Const CvArr eigenvects, CvArr result );

public static native void cvBackProjectPCA( @Const CvArr proj, @Const CvArr mean,
                               @Const CvArr eigenvects, CvArr result );

/** Calculates Mahalanobis(weighted) distance */
public static native double cvMahalanobis( @Const CvArr vec1, @Const CvArr vec2, @Const CvArr mat );
public static native double cvMahalonobis(CvArr arg1, CvArr arg2, CvArr arg3);

/****************************************************************************************\
*                                    Array Statistics                                    *
\****************************************************************************************/

/** Finds sum of array elements */
public static native @ByVal CvScalar cvSum( @Const CvArr arr );

/** Calculates number of non-zero pixels */
public static native int cvCountNonZero( @Const CvArr arr );

/** Calculates mean value of array elements */
public static native @ByVal CvScalar cvAvg( @Const CvArr arr, @Const CvArr mask/*=NULL*/ );
public static native @ByVal CvScalar cvAvg( @Const CvArr arr );

/** Calculates mean and standard deviation of pixel values */
public static native void cvAvgSdv( @Const CvArr arr, CvScalar mean, CvScalar std_dev,
                       @Const CvArr mask/*=NULL*/ );
public static native void cvAvgSdv( @Const CvArr arr, CvScalar mean, CvScalar std_dev );

/** Finds global minimum, maximum and their positions */
public static native void cvMinMaxLoc( @Const CvArr arr, DoublePointer min_val, DoublePointer max_val,
                          CvPoint min_loc/*=NULL*/,
                          CvPoint max_loc/*=NULL*/,
                          @Const CvArr mask/*=NULL*/ );
public static native void cvMinMaxLoc( @Const CvArr arr, DoublePointer min_val, DoublePointer max_val );
public static native void cvMinMaxLoc( @Const CvArr arr, DoubleBuffer min_val, DoubleBuffer max_val,
                          @Cast("CvPoint*") IntBuffer min_loc/*=NULL*/,
                          @Cast("CvPoint*") IntBuffer max_loc/*=NULL*/,
                          @Const CvArr mask/*=NULL*/ );
public static native void cvMinMaxLoc( @Const CvArr arr, DoubleBuffer min_val, DoubleBuffer max_val );
public static native void cvMinMaxLoc( @Const CvArr arr, double[] min_val, double[] max_val,
                          @Cast("CvPoint*") int[] min_loc/*=NULL*/,
                          @Cast("CvPoint*") int[] max_loc/*=NULL*/,
                          @Const CvArr mask/*=NULL*/ );
public static native void cvMinMaxLoc( @Const CvArr arr, double[] min_val, double[] max_val );

/** \anchor core_c_NormFlags
  \name Flags for cvNorm and cvNormalize
  \{
*/
public static final int CV_C =            1;
public static final int CV_L1 =           2;
public static final int CV_L2 =           4;
public static final int CV_NORM_MASK =    7;
public static final int CV_RELATIVE =     8;
public static final int CV_DIFF =         16;
public static final int CV_MINMAX =       32;

public static final int CV_DIFF_C =       (CV_DIFF | CV_C);
public static final int CV_DIFF_L1 =      (CV_DIFF | CV_L1);
public static final int CV_DIFF_L2 =      (CV_DIFF | CV_L2);
public static final int CV_RELATIVE_C =   (CV_RELATIVE | CV_C);
public static final int CV_RELATIVE_L1 =  (CV_RELATIVE | CV_L1);
public static final int CV_RELATIVE_L2 =  (CV_RELATIVE | CV_L2);
/** \} */

/** Finds norm, difference norm or relative difference norm for an array (or two arrays)
@see ref core_c_NormFlags "flags"
*/
public static native double cvNorm( @Const CvArr arr1, @Const CvArr arr2/*=NULL*/,
                       int norm_type/*=CV_L2*/,
                       @Const CvArr mask/*=NULL*/ );
public static native double cvNorm( @Const CvArr arr1 );

/** @see ref core_c_NormFlags "flags" */
public static native void cvNormalize( @Const CvArr src, CvArr dst,
                          double a/*=1.*/, double b/*=0.*/,
                          int norm_type/*=CV_L2*/,
                          @Const CvArr mask/*=NULL*/ );
public static native void cvNormalize( @Const CvArr src, CvArr dst );

/** \anchor core_c_ReduceFlags
  \name Flags for cvReduce
  \{
*/
public static final int CV_REDUCE_SUM = 0;
public static final int CV_REDUCE_AVG = 1;
public static final int CV_REDUCE_MAX = 2;
public static final int CV_REDUCE_MIN = 3;
/** \} */

/** @see \ref core_c_ReduceFlags "flags" */
public static native void cvReduce( @Const CvArr src, CvArr dst, int dim/*=-1*/,
                       int op/*=CV_REDUCE_SUM*/ );
public static native void cvReduce( @Const CvArr src, CvArr dst );

/****************************************************************************************\
*                      Discrete Linear Transforms and Related Functions                  *
\****************************************************************************************/

/** \anchor core_c_DftFlags
  \name Flags for cvDFT, cvDCT and cvMulSpectrums
  \{
  */
public static final int CV_DXT_FORWARD =  0;
public static final int CV_DXT_INVERSE =  1;
/** divide result by size of array */
public static final int CV_DXT_SCALE =    2;
public static final int CV_DXT_INV_SCALE = (CV_DXT_INVERSE + CV_DXT_SCALE);
public static final int CV_DXT_INVERSE_SCALE = CV_DXT_INV_SCALE;
/** transform each row individually */
public static final int CV_DXT_ROWS =     4;
/** conjugate the second argument of cvMulSpectrums */
public static final int CV_DXT_MUL_CONJ = 8;
/** \} */

/** Discrete Fourier Transform:
    complex->complex,
    real->ccs (forward),
    ccs->real (inverse)
@see core_c_DftFlags "flags"
*/
public static native void cvDFT( @Const CvArr src, CvArr dst, int flags,
                    int nonzero_rows/*=0*/ );
public static native void cvDFT( @Const CvArr src, CvArr dst, int flags );
public static native void cvFFT(CvArr arg1, CvArr arg2, int arg3, int arg4);

/** Multiply results of DFTs: DFT(X)*DFT(Y) or DFT(X)*conj(DFT(Y))
@see core_c_DftFlags "flags"
*/
public static native void cvMulSpectrums( @Const CvArr src1, @Const CvArr src2,
                             CvArr dst, int flags );

/** Finds optimal DFT vector size >= size0 */
public static native int cvGetOptimalDFTSize( int size0 );

/** Discrete Cosine Transform
@see core_c_DftFlags "flags"
*/
public static native void cvDCT( @Const CvArr src, CvArr dst, int flags );

/****************************************************************************************\
*                              Dynamic data structures                                   *
\****************************************************************************************/

/** Calculates length of sequence slice (with support of negative indices). */
public static native int cvSliceLength( @ByVal CvSlice slice, @Const CvSeq seq );


/** Creates new memory storage.
   block_size == 0 means that default,
   somewhat optimal size, is used (currently, it is 64K) */
public static native CvMemStorage cvCreateMemStorage( int block_size/*=0*/);
public static native CvMemStorage cvCreateMemStorage();


/** Creates a memory storage that will borrow memory blocks from parent storage */
public static native CvMemStorage cvCreateChildMemStorage( CvMemStorage parent );


/** Releases memory storage. All the children of a parent must be released before
   the parent. A child storage returns all the blocks to parent when it is released */
public static native void cvReleaseMemStorage( @Cast("CvMemStorage**") PointerPointer storage );
public static native void cvReleaseMemStorage( @ByPtrPtr CvMemStorage storage );


/** Clears memory storage. This is the only way(!!!) (besides cvRestoreMemStoragePos)
   to reuse memory allocated for the storage - cvClearSeq,cvClearSet ...
   do not free any memory.
   A child storage returns all the blocks to the parent when it is cleared */
public static native void cvClearMemStorage( CvMemStorage storage );

/** Remember a storage "free memory" position */
public static native void cvSaveMemStoragePos( @Const CvMemStorage storage, CvMemStoragePos pos );

/** Restore a storage "free memory" position */
public static native void cvRestoreMemStoragePos( CvMemStorage storage, CvMemStoragePos pos );

/** Allocates continuous buffer of the specified size in the storage */
public static native Pointer cvMemStorageAlloc( CvMemStorage storage, @Cast("size_t") long size );

/** Allocates string in memory storage */
//CVAPI(CvString) cvMemStorageAllocString( CvMemStorage* storage, const char* ptr,
//                                         int len CV_DEFAULT(-1) );

/** Creates new empty sequence that will reside in the specified storage */
public static native CvSeq cvCreateSeq( int seq_flags, @Cast("size_t") long header_size,
                            @Cast("size_t") long elem_size, CvMemStorage storage );

/** Changes default size (granularity) of sequence blocks.
   The default size is ~1Kbyte */
public static native void cvSetSeqBlockSize( CvSeq seq, int delta_elems );


/** Adds new element to the end of sequence. Returns pointer to the element */
public static native @Cast("schar*") BytePointer cvSeqPush( CvSeq seq, @Const Pointer element/*=NULL*/);
public static native @Cast("schar*") BytePointer cvSeqPush( CvSeq seq);


/** Adds new element to the beginning of sequence. Returns pointer to it */
public static native @Cast("schar*") BytePointer cvSeqPushFront( CvSeq seq, @Const Pointer element/*=NULL*/);
public static native @Cast("schar*") BytePointer cvSeqPushFront( CvSeq seq);


/** Removes the last element from sequence and optionally saves it */
public static native void cvSeqPop( CvSeq seq, Pointer element/*=NULL*/);
public static native void cvSeqPop( CvSeq seq);


/** Removes the first element from sequence and optioanally saves it */
public static native void cvSeqPopFront( CvSeq seq, Pointer element/*=NULL*/);
public static native void cvSeqPopFront( CvSeq seq);


public static final int CV_FRONT = 1;
public static final int CV_BACK = 0;
/** Adds several new elements to the end of sequence */
public static native void cvSeqPushMulti( CvSeq seq, @Const Pointer elements,
                             int count, int in_front/*=0*/ );
public static native void cvSeqPushMulti( CvSeq seq, @Const Pointer elements,
                             int count );

/** Removes several elements from the end of sequence and optionally saves them */
public static native void cvSeqPopMulti( CvSeq seq, Pointer elements,
                            int count, int in_front/*=0*/ );
public static native void cvSeqPopMulti( CvSeq seq, Pointer elements,
                            int count );

/** Inserts a new element in the middle of sequence.
   cvSeqInsert(seq,0,elem) == cvSeqPushFront(seq,elem) */
public static native @Cast("schar*") BytePointer cvSeqInsert( CvSeq seq, int before_index,
                            @Const Pointer element/*=NULL*/);
public static native @Cast("schar*") BytePointer cvSeqInsert( CvSeq seq, int before_index);

/** Removes specified sequence element */
public static native void cvSeqRemove( CvSeq seq, int index );


/** Removes all the elements from the sequence. The freed memory
   can be reused later only by the same sequence unless cvClearMemStorage
   or cvRestoreMemStoragePos is called */
public static native void cvClearSeq( CvSeq seq );


/** Retrieves pointer to specified sequence element.
   Negative indices are supported and mean counting from the end
   (e.g -1 means the last sequence element) */
public static native @Cast("schar*") BytePointer cvGetSeqElem( @Const CvSeq seq, int index );

/** Calculates index of the specified sequence element.
   Returns -1 if element does not belong to the sequence */
public static native int cvSeqElemIdx( @Const CvSeq seq, @Const Pointer element,
                         @Cast("CvSeqBlock**") PointerPointer block/*=NULL*/ );
public static native int cvSeqElemIdx( @Const CvSeq seq, @Const Pointer element );
public static native int cvSeqElemIdx( @Const CvSeq seq, @Const Pointer element,
                         @ByPtrPtr CvSeqBlock block/*=NULL*/ );

/** Initializes sequence writer. The new elements will be added to the end of sequence */
public static native void cvStartAppendToSeq( CvSeq seq, CvSeqWriter writer );


/** Combination of cvCreateSeq and cvStartAppendToSeq */
public static native void cvStartWriteSeq( int seq_flags, int header_size,
                              int elem_size, CvMemStorage storage,
                              CvSeqWriter writer );

/** Closes sequence writer, updates sequence header and returns pointer
   to the resultant sequence
   (which may be useful if the sequence was created using cvStartWriteSeq))
*/
public static native CvSeq cvEndWriteSeq( CvSeqWriter writer );


/** Updates sequence header. May be useful to get access to some of previously
   written elements via cvGetSeqElem or sequence reader */
public static native void cvFlushSeqWriter( CvSeqWriter writer );


/** Initializes sequence reader.
   The sequence can be read in forward or backward direction */
public static native void cvStartReadSeq( @Const CvSeq seq, CvSeqReader reader,
                           int reverse/*=0*/ );
public static native void cvStartReadSeq( @Const CvSeq seq, CvSeqReader reader );


/** Returns current sequence reader position (currently observed sequence element) */
public static native int cvGetSeqReaderPos( CvSeqReader reader );


/** Changes sequence reader position. It may seek to an absolute or
   to relative to the current position */
public static native void cvSetSeqReaderPos( CvSeqReader reader, int index,
                                 int is_relative/*=0*/);
public static native void cvSetSeqReaderPos( CvSeqReader reader, int index);

/** Copies sequence content to a continuous piece of memory */
public static native Pointer cvCvtSeqToArray( @Const CvSeq seq, Pointer elements,
                               @ByVal(nullValue = "CvSlice(CV_WHOLE_SEQ)") CvSlice slice );
public static native Pointer cvCvtSeqToArray( @Const CvSeq seq, Pointer elements );

/** Creates sequence header for array.
   After that all the operations on sequences that do not alter the content
   can be applied to the resultant sequence */
public static native CvSeq cvMakeSeqHeaderForArray( int seq_type, int header_size,
                                       int elem_size, Pointer elements, int total,
                                       CvSeq seq, CvSeqBlock block );

/** Extracts sequence slice (with or without copying sequence elements) */
public static native CvSeq cvSeqSlice( @Const CvSeq seq, @ByVal CvSlice slice,
                         CvMemStorage storage/*=NULL*/,
                         int copy_data/*=0*/);
public static native CvSeq cvSeqSlice( @Const CvSeq seq, @ByVal CvSlice slice);

public static native CvSeq cvCloneSeq( @Const CvSeq seq, CvMemStorage storage/*=NULL*/);
public static native CvSeq cvCloneSeq( @Const CvSeq seq);

/** Removes sequence slice */
public static native void cvSeqRemoveSlice( CvSeq seq, @ByVal CvSlice slice );

/** Inserts a sequence or array into another sequence */
public static native void cvSeqInsertSlice( CvSeq seq, int before_index, @Const CvArr from_arr );
// Targeting ..\opencv_core\CvCmpFunc.java



/** Sorts sequence in-place given element comparison function */
public static native void cvSeqSort( CvSeq seq, CvCmpFunc func, Pointer userdata/*=NULL*/ );
public static native void cvSeqSort( CvSeq seq, CvCmpFunc func );

/** Finds element in a [sorted] sequence */
public static native @Cast("schar*") BytePointer cvSeqSearch( CvSeq seq, @Const Pointer elem, CvCmpFunc func,
                           int is_sorted, IntPointer elem_idx,
                           Pointer userdata/*=NULL*/ );
public static native @Cast("schar*") BytePointer cvSeqSearch( CvSeq seq, @Const Pointer elem, CvCmpFunc func,
                           int is_sorted, IntPointer elem_idx );
public static native @Cast("schar*") ByteBuffer cvSeqSearch( CvSeq seq, @Const Pointer elem, CvCmpFunc func,
                           int is_sorted, IntBuffer elem_idx,
                           Pointer userdata/*=NULL*/ );
public static native @Cast("schar*") ByteBuffer cvSeqSearch( CvSeq seq, @Const Pointer elem, CvCmpFunc func,
                           int is_sorted, IntBuffer elem_idx );
public static native @Cast("schar*") byte[] cvSeqSearch( CvSeq seq, @Const Pointer elem, CvCmpFunc func,
                           int is_sorted, int[] elem_idx,
                           Pointer userdata/*=NULL*/ );
public static native @Cast("schar*") byte[] cvSeqSearch( CvSeq seq, @Const Pointer elem, CvCmpFunc func,
                           int is_sorted, int[] elem_idx );

/** Reverses order of sequence elements in-place */
public static native void cvSeqInvert( CvSeq seq );

/** Splits sequence into one or more equivalence classes using the specified criteria */
public static native int cvSeqPartition( @Const CvSeq seq, CvMemStorage storage,
                            @Cast("CvSeq**") PointerPointer labels, CvCmpFunc is_equal, Pointer userdata );
public static native int cvSeqPartition( @Const CvSeq seq, CvMemStorage storage,
                            @ByPtrPtr CvSeq labels, CvCmpFunc is_equal, Pointer userdata );

/************ Internal sequence functions ************/
public static native void cvChangeSeqBlock( Pointer reader, int direction );
public static native void cvCreateSeqBlock( CvSeqWriter writer );


/** Creates a new set */
public static native CvSet cvCreateSet( int set_flags, int header_size,
                            int elem_size, CvMemStorage storage );

/** Adds new element to the set and returns pointer to it */
public static native int cvSetAdd( CvSet set_header, CvSetElem elem/*=NULL*/,
                      @Cast("CvSetElem**") PointerPointer inserted_elem/*=NULL*/ );
public static native int cvSetAdd( CvSet set_header );
public static native int cvSetAdd( CvSet set_header, CvSetElem elem/*=NULL*/,
                      @ByPtrPtr CvSetElem inserted_elem/*=NULL*/ );

/** Fast variant of cvSetAdd */
public static native CvSetElem cvSetNew( CvSet set_header );

/** Removes set element given its pointer */
public static native void cvSetRemoveByPtr( CvSet set_header, Pointer elem );

/** Removes element from the set by its index  */
public static native void cvSetRemove( CvSet set_header, int index );

/** Returns a set element by index. If the element doesn't belong to the set,
   NULL is returned */
public static native CvSetElem cvGetSetElem( @Const CvSet set_header, int idx );

/** Removes all the elements from the set */
public static native void cvClearSet( CvSet set_header );

/** Creates new graph */
public static native CvGraph cvCreateGraph( int graph_flags, int header_size,
                                int vtx_size, int edge_size,
                                CvMemStorage storage );

/** Adds new vertex to the graph */
public static native int cvGraphAddVtx( CvGraph graph, @Const CvGraphVtx vtx/*=NULL*/,
                           @Cast("CvGraphVtx**") PointerPointer inserted_vtx/*=NULL*/ );
public static native int cvGraphAddVtx( CvGraph graph );
public static native int cvGraphAddVtx( CvGraph graph, @Const CvGraphVtx vtx/*=NULL*/,
                           @ByPtrPtr CvGraphVtx inserted_vtx/*=NULL*/ );


/** Removes vertex from the graph together with all incident edges */
public static native int cvGraphRemoveVtx( CvGraph graph, int index );
public static native int cvGraphRemoveVtxByPtr( CvGraph graph, CvGraphVtx vtx );


/** Link two vertices specified by indices or pointers if they
   are not connected or return pointer to already existing edge
   connecting the vertices.
   Functions return 1 if a new edge was created, 0 otherwise */
public static native int cvGraphAddEdge( CvGraph graph,
                            int start_idx, int end_idx,
                            @Const CvGraphEdge edge/*=NULL*/,
                            @Cast("CvGraphEdge**") PointerPointer inserted_edge/*=NULL*/ );
public static native int cvGraphAddEdge( CvGraph graph,
                            int start_idx, int end_idx );
public static native int cvGraphAddEdge( CvGraph graph,
                            int start_idx, int end_idx,
                            @Const CvGraphEdge edge/*=NULL*/,
                            @ByPtrPtr CvGraphEdge inserted_edge/*=NULL*/ );

public static native int cvGraphAddEdgeByPtr( CvGraph graph,
                               CvGraphVtx start_vtx, CvGraphVtx end_vtx,
                               @Const CvGraphEdge edge/*=NULL*/,
                               @Cast("CvGraphEdge**") PointerPointer inserted_edge/*=NULL*/ );
public static native int cvGraphAddEdgeByPtr( CvGraph graph,
                               CvGraphVtx start_vtx, CvGraphVtx end_vtx );
public static native int cvGraphAddEdgeByPtr( CvGraph graph,
                               CvGraphVtx start_vtx, CvGraphVtx end_vtx,
                               @Const CvGraphEdge edge/*=NULL*/,
                               @ByPtrPtr CvGraphEdge inserted_edge/*=NULL*/ );

/** Remove edge connecting two vertices */
public static native void cvGraphRemoveEdge( CvGraph graph, int start_idx, int end_idx );
public static native void cvGraphRemoveEdgeByPtr( CvGraph graph, CvGraphVtx start_vtx,
                                     CvGraphVtx end_vtx );

/** Find edge connecting two vertices */
public static native CvGraphEdge cvFindGraphEdge( @Const CvGraph graph, int start_idx, int end_idx );
public static native CvGraphEdge cvFindGraphEdgeByPtr( @Const CvGraph graph,
                                           @Const CvGraphVtx start_vtx,
                                           @Const CvGraphVtx end_vtx );
public static native CvGraphEdge cvGraphFindEdge(CvGraph arg1, int arg2, int arg3);
public static native CvGraphEdge cvGraphFindEdgeByPtr(CvGraph arg1, CvGraphVtx arg2, CvGraphVtx arg3);

/** Remove all vertices and edges from the graph */
public static native void cvClearGraph( CvGraph graph );


/** Count number of edges incident to the vertex */
public static native int cvGraphVtxDegree( @Const CvGraph graph, int vtx_idx );
public static native int cvGraphVtxDegreeByPtr( @Const CvGraph graph, @Const CvGraphVtx vtx );


/** Retrieves graph vertex by given index */
// #define cvGetGraphVtx( graph, idx ) (CvGraphVtx*)cvGetSetElem((CvSet*)(graph), (idx))

/** Retrieves index of a graph vertex given its pointer */
// #define cvGraphVtxIdx( graph, vtx ) ((vtx)->flags & CV_SET_ELEM_IDX_MASK)

/** Retrieves index of a graph edge given its pointer */
// #define cvGraphEdgeIdx( graph, edge ) ((edge)->flags & CV_SET_ELEM_IDX_MASK)

// #define cvGraphGetVtxCount( graph ) ((graph)->active_count)
// #define cvGraphGetEdgeCount( graph ) ((graph)->edges->active_count)

public static final int CV_GRAPH_VERTEX =        1;
public static final int CV_GRAPH_TREE_EDGE =     2;
public static final int CV_GRAPH_BACK_EDGE =     4;
public static final int CV_GRAPH_FORWARD_EDGE =  8;
public static final int CV_GRAPH_CROSS_EDGE =    16;
public static final int CV_GRAPH_ANY_EDGE =      30;
public static final int CV_GRAPH_NEW_TREE =      32;
public static final int CV_GRAPH_BACKTRACKING =  64;
public static final int CV_GRAPH_OVER =          -1;

public static final int CV_GRAPH_ALL_ITEMS =    -1;

/** flags for graph vertices and edges */
public static final int CV_GRAPH_ITEM_VISITED_FLAG =  (1 << 30);
// #define  CV_IS_GRAPH_VERTEX_VISITED(vtx)
//     (((CvGraphVtx*)(vtx))->flags & CV_GRAPH_ITEM_VISITED_FLAG)
// #define  CV_IS_GRAPH_EDGE_VISITED(edge)
//     (((CvGraphEdge*)(edge))->flags & CV_GRAPH_ITEM_VISITED_FLAG)
public static final int CV_GRAPH_SEARCH_TREE_NODE_FLAG =   (1 << 29);
public static final int CV_GRAPH_FORWARD_EDGE_FLAG =       (1 << 28);
// Targeting ..\opencv_core\CvGraphScanner.java



/** Creates new graph scanner. */
public static native CvGraphScanner cvCreateGraphScanner( CvGraph graph,
                                             CvGraphVtx vtx/*=NULL*/,
                                             int mask/*=CV_GRAPH_ALL_ITEMS*/);
public static native CvGraphScanner cvCreateGraphScanner( CvGraph graph);

/** Releases graph scanner. */
public static native void cvReleaseGraphScanner( @Cast("CvGraphScanner**") PointerPointer scanner );
public static native void cvReleaseGraphScanner( @ByPtrPtr CvGraphScanner scanner );

/** Get next graph element */
public static native int cvNextGraphItem( CvGraphScanner scanner );

/** Creates a copy of graph */
public static native CvGraph cvCloneGraph( @Const CvGraph graph, CvMemStorage storage );


/** Does look-up transformation. Elements of the source array
   (that should be 8uC1 or 8sC1) are used as indexes in lutarr 256-element table */
public static native void cvLUT( @Const CvArr src, CvArr dst, @Const CvArr lut );
// Targeting ..\opencv_core\CvTreeNodeIterator.java



public static native void cvInitTreeNodeIterator( CvTreeNodeIterator tree_iterator,
                                   @Const Pointer first, int max_level );
public static native Pointer cvNextTreeNode( CvTreeNodeIterator tree_iterator );
public static native Pointer cvPrevTreeNode( CvTreeNodeIterator tree_iterator );

/** Inserts sequence into tree with specified "parent" sequence.
   If parent is equal to frame (e.g. the most external contour),
   then added contour will have null pointer to parent. */
public static native void cvInsertNodeIntoTree( Pointer node, Pointer parent, Pointer frame );

/** Removes contour from tree (together with the contour children). */
public static native void cvRemoveNodeFromTree( Pointer node, Pointer frame );

/** Gathers pointers to all the sequences,
   accessible from the {@code first}, to the single sequence */
public static native CvSeq cvTreeToNodeSeq( @Const Pointer first, int header_size,
                              CvMemStorage storage );

/** The function implements the K-means algorithm for clustering an array of sample
   vectors in a specified number of classes */
public static final int CV_KMEANS_USE_INITIAL_LABELS =    1;
public static native int cvKMeans2( @Const CvArr samples, int cluster_count, CvArr labels,
                      @ByVal CvTermCriteria termcrit, int attempts/*=1*/,
                      @Cast("CvRNG*") LongPointer rng/*=0*/, int flags/*=0*/,
                      CvArr _centers/*=0*/, DoublePointer compactness/*=0*/ );
public static native int cvKMeans2( @Const CvArr samples, int cluster_count, CvArr labels,
                      @ByVal CvTermCriteria termcrit );
public static native int cvKMeans2( @Const CvArr samples, int cluster_count, CvArr labels,
                      @ByVal CvTermCriteria termcrit, int attempts/*=1*/,
                      @Cast("CvRNG*") LongBuffer rng/*=0*/, int flags/*=0*/,
                      CvArr _centers/*=0*/, DoubleBuffer compactness/*=0*/ );
public static native int cvKMeans2( @Const CvArr samples, int cluster_count, CvArr labels,
                      @ByVal CvTermCriteria termcrit, int attempts/*=1*/,
                      @Cast("CvRNG*") long[] rng/*=0*/, int flags/*=0*/,
                      CvArr _centers/*=0*/, double[] compactness/*=0*/ );

/****************************************************************************************\
*                                    System functions                                    *
\****************************************************************************************/

/** Loads optimized functions from IPP, MKL etc. or switches back to pure C code */
public static native int cvUseOptimized( int on_off );
// Targeting ..\opencv_core\Cv_iplCreateImageHeader.java


// Targeting ..\opencv_core\Cv_iplAllocateImageData.java


// Targeting ..\opencv_core\Cv_iplDeallocate.java


// Targeting ..\opencv_core\Cv_iplCreateROI.java


// Targeting ..\opencv_core\Cv_iplCloneImage.java



/** \brief Makes OpenCV use IPL functions for allocating IplImage and IplROI structures.
<p>
Normally, the function is not called directly. Instead, a simple macro
CV_TURN_ON_IPL_COMPATIBILITY() is used that calls cvSetIPLAllocators and passes there pointers
to IPL allocation functions. :
<pre>{@code
    ...
    CV_TURN_ON_IPL_COMPATIBILITY()
    ...
}</pre>
@param create_header pointer to a function, creating IPL image header.
@param allocate_data pointer to a function, allocating IPL image data.
@param deallocate pointer to a function, deallocating IPL image.
@param create_roi pointer to a function, creating IPL image ROI (i.e. Region of Interest).
@param clone_image pointer to a function, cloning an IPL image.
 */
public static native void cvSetIPLAllocators( Cv_iplCreateImageHeader create_header,
                               Cv_iplAllocateImageData allocate_data,
                               Cv_iplDeallocate _deallocate,
                               Cv_iplCreateROI create_roi,
                               Cv_iplCloneImage clone_image );

// #define CV_TURN_ON_IPL_COMPATIBILITY()
//     cvSetIPLAllocators( iplCreateImageHeader, iplAllocateImage,
//                         iplDeallocate, iplCreateROI, iplCloneImage )

/****************************************************************************************\
*                                    Data Persistence                                    *
\****************************************************************************************/

// #if 0

// #endif

/** \brief Releases an object.
 <p>
 The function finds the type of a given object and calls release with the double pointer.
 @param struct_ptr Double pointer to the object
 */
public static native void cvRelease( @Cast("void**") PointerPointer struct_ptr );
public static native void cvRelease( @Cast("void**") @ByPtrPtr Pointer struct_ptr );

/** \brief Makes a clone of an object.
<p>
The function finds the type of a given object and calls clone with the passed object. Of course, if
you know the object type, for example, struct_ptr is CvMat\*, it is faster to call the specific
function, like cvCloneMat.
@param struct_ptr The object to clone
 */
public static native Pointer cvClone( @Const Pointer struct_ptr );

/*********************************** Measuring Execution Time ***************************/

/** helper functions for RNG initialization and accurate time measurement:
   uses internal clock counter on x86 */
public static native @Cast("int64") long cvGetTickCount( );
public static native double cvGetTickFrequency( );

/*********************************** CPU capabilities ***********************************/

public static native int cvCheckHardwareSupport(int feature);

/*********************************** Multi-Threading ************************************/

/** retrieve/set the number of threads used in OpenMP implementations */
public static native int cvGetNumThreads( );
public static native void cvSetNumThreads( int threads/*=0*/ );
public static native void cvSetNumThreads( );
/** get index of the thread being executed */
public static native int cvGetThreadNum( );


/********************************** Error Handling **************************************/

/** Get current OpenCV error status */
public static native int cvGetErrStatus( );

/** Sets error status silently */
public static native void cvSetErrStatus( int status );

public static final int CV_ErrModeLeaf =     0;   /* Print error and exit program */
public static final int CV_ErrModeParent =   1;   /* Print error and continue */
public static final int CV_ErrModeSilent =   2;   /* Don't print and continue */

/** Retrieves current error processing mode */
public static native int cvGetErrMode( );

/** Sets error processing mode, returns previously used mode */
public static native int cvSetErrMode( int mode );

/** Sets error status and performs some additional actions (displaying message box,
 writing message to stderr, terminating application etc.)
 depending on the current error mode */
public static native void cvError( int status, @Cast("const char*") BytePointer func_name,
                    @Cast("const char*") BytePointer err_msg, @Cast("const char*") BytePointer file_name, int line );
public static native void cvError( int status, String func_name,
                    String err_msg, String file_name, int line );

/** Retrieves textual description of the error given its code */
public static native @Cast("const char*") BytePointer cvErrorStr( int status );

/** Retrieves detailed information about the last error occurred */
public static native int cvGetErrInfo( @Cast("const char**") PointerPointer errcode_desc, @Cast("const char**") PointerPointer description,
                        @Cast("const char**") PointerPointer filename, IntPointer line );
public static native int cvGetErrInfo( @Cast("const char**") @ByPtrPtr BytePointer errcode_desc, @Cast("const char**") @ByPtrPtr BytePointer description,
                        @Cast("const char**") @ByPtrPtr BytePointer filename, IntPointer line );
public static native int cvGetErrInfo( @Cast("const char**") @ByPtrPtr ByteBuffer errcode_desc, @Cast("const char**") @ByPtrPtr ByteBuffer description,
                        @Cast("const char**") @ByPtrPtr ByteBuffer filename, IntBuffer line );
public static native int cvGetErrInfo( @Cast("const char**") @ByPtrPtr byte[] errcode_desc, @Cast("const char**") @ByPtrPtr byte[] description,
                        @Cast("const char**") @ByPtrPtr byte[] filename, int[] line );

/** Maps IPP error codes to the counterparts from OpenCV */
public static native int cvErrorFromIppStatus( int ipp_status );
// Targeting ..\opencv_core\CvErrorCallback.java



/** Assigns a new error-handling function */
public static native CvErrorCallback cvRedirectError( CvErrorCallback error_handler,
                                       Pointer userdata/*=NULL*/,
                                       @Cast("void**") PointerPointer prev_userdata/*=NULL*/ );
public static native CvErrorCallback cvRedirectError( CvErrorCallback error_handler );
public static native CvErrorCallback cvRedirectError( CvErrorCallback error_handler,
                                       Pointer userdata/*=NULL*/,
                                       @Cast("void**") @ByPtrPtr Pointer prev_userdata/*=NULL*/ );

/** Output nothing */
public static native int cvNulDevReport( int status, @Cast("const char*") BytePointer func_name, @Cast("const char*") BytePointer err_msg,
                          @Cast("const char*") BytePointer file_name, int line, Pointer userdata );
public static native int cvNulDevReport( int status, String func_name, String err_msg,
                          String file_name, int line, Pointer userdata );

/** Output to console(fprintf(stderr,...)) */
public static native int cvStdErrReport( int status, @Cast("const char*") BytePointer func_name, @Cast("const char*") BytePointer err_msg,
                          @Cast("const char*") BytePointer file_name, int line, Pointer userdata );
public static native int cvStdErrReport( int status, String func_name, String err_msg,
                          String file_name, int line, Pointer userdata );

/** Output to MessageBox(WIN32) */
public static native int cvGuiBoxReport( int status, @Cast("const char*") BytePointer func_name, @Cast("const char*") BytePointer err_msg,
                          @Cast("const char*") BytePointer file_name, int line, Pointer userdata );
public static native int cvGuiBoxReport( int status, String func_name, String err_msg,
                          String file_name, int line, Pointer userdata );

// #define OPENCV_ERROR(status,func,context)
// cvError((status),(func),(context),__FILE__,__LINE__)

// #define OPENCV_ASSERT(expr,func,context)
// {if (! (expr))
// {OPENCV_ERROR(CV_StsInternal,(func),(context));}}

// #define OPENCV_CALL( Func )
// {
// Func;
// }


/** CV_FUNCNAME macro defines icvFuncName constant which is used by CV_ERROR macro */
// #ifdef CV_NO_FUNC_NAMES
// #define CV_FUNCNAME( Name )
public static final String cvFuncName = "";
// #else
// #define CV_FUNCNAME( Name )
// static char cvFuncName[] = Name
// #endif


/**
 CV_ERROR macro unconditionally raises error with passed code and message.
 After raising error, control will be transferred to the exit label.
 */
// #define CV_ERROR( Code, Msg )
// {
//     cvError( (Code), cvFuncName, Msg, __FILE__, __LINE__ );
//     __CV_EXIT__;
// }

/**
 CV_CHECK macro checks error status after CV (or IPL)
 function call. If error detected, control will be transferred to the exit
 label.
 */
// #define CV_CHECK()
// {
//     if( cvGetErrStatus() < 0 )
//         CV_ERROR( CV_StsBackTrace, "Inner function failed." );
// }


/**
 CV_CALL macro calls CV (or IPL) function, checks error status and
 signals a error if the function failed. Useful in "parent node"
 error processing mode
 */
// #define CV_CALL( Func )
// {
//     Func;
//     CV_CHECK();
// }


/** Runtime assertion macro */
// #define CV_ASSERT( Condition )
// {
//     if( !(Condition) )
//         CV_ERROR( CV_StsInternal, "Assertion: " #Condition " failed" );
// }

// #define __CV_BEGIN__       {
// #define __CV_END__         goto exit; exit: ; }
// #define __CV_EXIT__        goto exit

/** \} core_c */

// #ifdef __cplusplus // extern "C"
// #endif

// #ifdef __cplusplus

// #include "opencv2/core/utility.hpp"

/** \addtogroup core_c_glue
 *  \{
<p>
/////////////////////////////////////////// glue ///////////////////////////////////////////
 <p>
 *  converts array (CvMat or IplImage) to cv::Mat */
@Namespace("cv") public static native @ByVal Mat cvarrToMat(@Const CvArr arr, @Cast("bool") boolean copyData/*=false*/,
                          @Cast("bool") boolean allowND/*=true*/, int coiMode/*=0*/,
                          @Cast("cv::AutoBuffer<double>*") Pointer buf/*=0*/);
@Namespace("cv") public static native @ByVal Mat cvarrToMat(@Const CvArr arr);

@Namespace("cv") public static native @ByVal Mat cvarrToMatND(@Const CvArr arr, @Cast("bool") boolean copyData/*=false*/, int coiMode/*=0*/);
@Namespace("cv") public static native @ByVal Mat cvarrToMatND(@Const CvArr arr);


/** extracts Channel of Interest from CvMat or IplImage and makes cv::Mat out of it. */
@Namespace("cv") public static native void extractImageCOI(@Const CvArr arr, @ByVal Mat coiimg, int coi/*=-1*/);
@Namespace("cv") public static native void extractImageCOI(@Const CvArr arr, @ByVal Mat coiimg);
@Namespace("cv") public static native void extractImageCOI(@Const CvArr arr, @ByVal UMat coiimg, int coi/*=-1*/);
@Namespace("cv") public static native void extractImageCOI(@Const CvArr arr, @ByVal UMat coiimg);
@Namespace("cv") public static native void extractImageCOI(@Const CvArr arr, @ByVal GpuMat coiimg, int coi/*=-1*/);
@Namespace("cv") public static native void extractImageCOI(@Const CvArr arr, @ByVal GpuMat coiimg);
/** inserts single-channel cv::Mat into a multi-channel CvMat or IplImage */
@Namespace("cv") public static native void insertImageCOI(@ByVal Mat coiimg, CvArr arr, int coi/*=-1*/);
@Namespace("cv") public static native void insertImageCOI(@ByVal Mat coiimg, CvArr arr);
@Namespace("cv") public static native void insertImageCOI(@ByVal UMat coiimg, CvArr arr, int coi/*=-1*/);
@Namespace("cv") public static native void insertImageCOI(@ByVal UMat coiimg, CvArr arr);
@Namespace("cv") public static native void insertImageCOI(@ByVal GpuMat coiimg, CvArr arr, int coi/*=-1*/);
@Namespace("cv") public static native void insertImageCOI(@ByVal GpuMat coiimg, CvArr arr);



////// specialized implementations of DefaultDeleter::operator() for classic OpenCV types //////

////////////// convenient wrappers for operating old-style dynamic structures //////////////

/**
 Template Sequence Class derived from CvSeq
 <p>
 The class provides more convenient access to sequence elements,
 STL-style operations and iterators.
 <p>
 \note The class is targeted for simple data types,
    i.e. no constructors or destructors
    are called for the sequence elements.
*/


/**
 STL-style Sequence Iterator inherited from the CvSeqReader structure
*/



// bridge C++ => C Seq API
@Namespace("cv") public static native @Cast("schar*") BytePointer seqPush( CvSeq seq, @Const Pointer element/*=0*/);
@Namespace("cv") public static native @Cast("schar*") BytePointer seqPush( CvSeq seq);
@Namespace("cv") public static native @Cast("schar*") BytePointer seqPushFront( CvSeq seq, @Const Pointer element/*=0*/);
@Namespace("cv") public static native @Cast("schar*") BytePointer seqPushFront( CvSeq seq);
@Namespace("cv") public static native void seqPop( CvSeq seq, Pointer element/*=0*/);
@Namespace("cv") public static native void seqPop( CvSeq seq);
@Namespace("cv") public static native void seqPopFront( CvSeq seq, Pointer element/*=0*/);
@Namespace("cv") public static native void seqPopFront( CvSeq seq);

@Namespace("cv") public static native void seqRemove( CvSeq seq, int index );
@Namespace("cv") public static native void clearSeq( CvSeq seq );
@Namespace("cv") public static native @Cast("schar*") BytePointer getSeqElem( @Const CvSeq seq, int index );
@Namespace("cv") public static native void seqRemoveSlice( CvSeq seq, @ByVal CvSlice slice );
@Namespace("cv") public static native void seqInsertSlice( CvSeq seq, int before_index, @Const CvArr from_arr );


























































































/** \} */

 // cv

// #endif

// #endif


// Parsed from <opencv2/core/types.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_TYPES_HPP
// #define OPENCV_CORE_TYPES_HPP

// #ifndef __cplusplus
// #endif

// #include <climits>
// #include <cfloat>
// #include <vector>
// #include <limits>

// #include "opencv2/core/cvdef.h"
// #include "opencv2/core/cvstd.hpp"
// #include "opencv2/core/matx.hpp"

// #ifdef _MSC_VER
// #pragma warning(push)
// #pragma warning(disable: 4459)  // declaration of '...' hides global declaration
// #endif
// Targeting ..\opencv_core\Complexf.java


// Targeting ..\opencv_core\Complexd.java



// Targeting ..\opencv_core\Point.java


// Targeting ..\opencv_core\Point2f.java


// Targeting ..\opencv_core\Point2d.java



// Targeting ..\opencv_core\Point3i.java


// Targeting ..\opencv_core\Point3f.java


// Targeting ..\opencv_core\Point3d.java



// Targeting ..\opencv_core\Size.java


// Targeting ..\opencv_core\Size2f.java


// Targeting ..\opencv_core\Size2d.java



// Targeting ..\opencv_core\Rect.java


// Targeting ..\opencv_core\Rect2f.java


// Targeting ..\opencv_core\Rect2d.java



// Targeting ..\opencv_core\RotatedRect.java



// Targeting ..\opencv_core\Range.java



// Targeting ..\opencv_core\Scalar.java


// Targeting ..\opencv_core\Scalar4i.java


// Targeting ..\opencv_core\Scalar4f.java



// Targeting ..\opencv_core\KeyPoint.java



// #ifdef OPENCV_TRAITS_ENABLE_DEPRECATED
// Targeting ..\opencv_core\DMatch.java



// #ifdef OPENCV_TRAITS_ENABLE_DEPRECATED
// Targeting ..\opencv_core\TermCriteria.java


// Targeting ..\opencv_core\Moments.java


 // namespace

/** \} imgproc_shape
 <p>
 *  \cond IGNORED
<p>
/////////////////////////////////////////////////////////////////////////
///////////////////////////// Implementation ////////////////////////////
/////////////////////////////////////////////////////////////////////////
<p>
//////////////////////////////// Complex //////////////////////////////// */











//////////////////////////////// 2D Point ///////////////////////////////





// #if (defined(__GNUC__) && __GNUC__ < 5) && !defined(__clang__)  // GCC 4.x bug. Details: https://github.com/opencv/opencv/pull/20837

// #endif





// #if (defined(__GNUC__) && __GNUC__ < 5) && !defined(__clang__)  // GCC 4.x bug. Details: https://github.com/opencv/opencv/pull/20837

// #endif





























//////////////////////////////// 3D Point ///////////////////////////////





















////////////////////////////////// Size /////////////////////////////////

















////////////////////////////////// Rect /////////////////////////////////























/**
 * \brief measure dissimilarity between two sample sets
 *
 * computes the complement of the Jaccard Index as described in <https://en.wikipedia.org/wiki/Jaccard_index>.
 * For rectangles this reduces to computing the intersection over the union.
 */

/** \brief Finds out if there is any intersection between two rectangles
 *
 * mainly useful for language bindings
 * @param a First rectangle
 * @param b Second rectangle
 * @return the area of the intersection
 */
@Namespace("cv") public static native double rectangleIntersectionArea(@Const @ByRef Rect2d a, @Const @ByRef Rect2d b);

////////////////////////////// RotatedRect //////////////////////////////





///////////////////////////////// Range /////////////////////////////////












@Namespace("cv") public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef Range r1, @Const @ByRef Range r2);

@Namespace("cv") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef Range r1, @Const @ByRef Range r2);

@Namespace("cv") public static native @Cast("bool") @Name("operator !") boolean not(@Const @ByRef Range r);

@Namespace("cv") public static native @ByVal @Name("operator &") Range and(@Const @ByRef Range r1, @Const @ByRef Range r2);

@Namespace("cv") public static native @ByRef @Name("operator &=") Range andPut(@ByRef Range r1, @Const @ByRef Range r2);

@Namespace("cv") public static native @ByVal @Name("operator +") Range add(@Const @ByRef Range r1, int delta);

@Namespace("cv") public static native @ByVal @Name("operator +") Range add(int delta, @Const @ByRef Range r1);

@Namespace("cv") public static native @ByVal @Name("operator -") Range subtract(@Const @ByRef Range r1, int delta);



///////////////////////////////// Scalar ////////////////////////////////































//////////////////////////////// KeyPoint ///////////////////////////////









///////////////////////////////// DMatch ////////////////////////////////











////////////////////////////// TermCriteria /////////////////////////////





/** \endcond */

 // cv

// #ifdef _MSC_VER
// #pragma warning(pop)
// #endif

// #endif //OPENCV_CORE_TYPES_HPP


// Parsed from <opencv2/core.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2015, Intel Corporation, all rights reserved.
// Copyright (C) 2009-2011, Willow Garage Inc., all rights reserved.
// Copyright (C) 2015, OpenCV Foundation, all rights reserved.
// Copyright (C) 2015, Itseez Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_HPP
// #define OPENCV_CORE_HPP

// #ifndef __cplusplus
// #endif

// #include "opencv2/core/cvdef.h"
// #include "opencv2/core/base.hpp"
// #include "opencv2/core/cvstd.hpp"
// #include "opencv2/core/traits.hpp"
// #include "opencv2/core/matx.hpp"
// #include "opencv2/core/types.hpp"
// #include "opencv2/core/mat.hpp"
// #include "opencv2/core/persistence.hpp"

/**
\defgroup core Core functionality
\{
    \defgroup core_basic Basic structures
    \defgroup core_c C structures and operations
    \{
        \defgroup core_c_glue Connections with C++
    \}
    \defgroup core_array Operations on arrays
    \defgroup core_async Asynchronous API
    \defgroup core_xml XML/YAML Persistence
    \defgroup core_cluster Clustering
    \defgroup core_utils Utility and system functions and macros
    \{
        \defgroup core_logging Logging facilities
        \defgroup core_utils_sse SSE utilities
        \defgroup core_utils_neon NEON utilities
        \defgroup core_utils_vsx VSX utilities
        \defgroup core_utils_softfloat Softfloat support
        \defgroup core_utils_samples Utility functions for OpenCV samples
    \}
    \defgroup core_opengl OpenGL interoperability
    \defgroup core_ipp Intel IPP Asynchronous C/C++ Converters
    \defgroup core_optim Optimization Algorithms
    \defgroup core_directx DirectX interoperability
    \defgroup core_eigen Eigen support
    \defgroup core_opencl OpenCL support
    \defgroup core_va_intel Intel VA-API/OpenCL (CL-VA) interoperability
    \defgroup core_hal Hardware Acceleration Layer
    \{
        \defgroup core_hal_functions Functions
        \defgroup core_hal_interface Interface
        \defgroup core_hal_intrin Universal intrinsics
        \{
            \defgroup core_hal_intrin_impl Private implementation helpers
        \}
        \defgroup core_lowlevel_api Low-level API for external libraries / plugins
    \}
    \defgroup core_parallel Parallel Processing
    \{
        \defgroup core_parallel_backend Parallel backends API
    \}
\}
 */

/** \addtogroup core_utils
 *  \{
<p>
/** \brief Class passed to an error.
<p>
This class encapsulates all or almost all necessary
information about the error happened in the program. The exception is
usually constructed and thrown implicitly via CV_Error and CV_Error_ macros.
@see error
 */

/** \brief Signals an error and raises the exception.
<p>
By default the function prints information about the error to stderr,
then it either stops if cv::setBreakOnError() had been called before or raises the exception.
It is possible to alternate error processing by using #redirectError().
@param exc the exception raisen.
@deprecated drop this version
 */
/* nothing by default */

/** enum cv::SortFlags */
public static final int /** each matrix row is sorted independently */
 SORT_EVERY_ROW    = 0,
                 /** each matrix column is sorted
 *  independently; this flag and the previous one are
 *  mutually exclusive. */
                 SORT_EVERY_COLUMN = 1,
                 /** each matrix row is sorted in the ascending
 *  order. */
                 SORT_ASCENDING    = 0,
                 /** each matrix row is sorted in the
 *  descending order; this flag and the previous one are also
 *  mutually exclusive. */
                 SORT_DESCENDING   = 16;

/** \} core_utils
 <p>
 *  \addtogroup core
 *  \{
 <p>
 *  Covariation flags */
/** enum cv::CovarFlags */
public static final int
    /** The output covariance matrix is calculated as:
       <pre>{@code \[\texttt{scale}   \cdot  [  \texttt{vects}  [0]-  \texttt{mean}  , \texttt{vects}  [1]-  \texttt{mean}  ,...]^T  \cdot  [ \texttt{vects}  [0]- \texttt{mean}  , \texttt{vects}  [1]- \texttt{mean}  ,...],\]}</pre>
       The covariance matrix will be nsamples x nsamples. Such an unusual covariance matrix is used
       for fast PCA of a set of very large vectors (see, for example, the EigenFaces technique for
       face recognition). Eigenvalues of this "scrambled" matrix match the eigenvalues of the true
       covariance matrix. The "true" eigenvectors can be easily calculated from the eigenvectors of
       the "scrambled" covariance matrix. */
    COVAR_SCRAMBLED = 0,
    /**The output covariance matrix is calculated as:
        <pre>{@code \[\texttt{scale}   \cdot  [  \texttt{vects}  [0]-  \texttt{mean}  , \texttt{vects}  [1]-  \texttt{mean}  ,...]  \cdot  [ \texttt{vects}  [0]- \texttt{mean}  , \texttt{vects}  [1]- \texttt{mean}  ,...]^T,\]}</pre>
        covar will be a square matrix of the same size as the total number of elements in each input
        vector. One and only one of #COVAR_SCRAMBLED and #COVAR_NORMAL must be specified.*/
    COVAR_NORMAL    = 1,
    /** If the flag is specified, the function does not calculate mean from
        the input vectors but, instead, uses the passed mean vector. This is useful if mean has been
        pre-calculated or known in advance, or if the covariance matrix is calculated by parts. In
        this case, mean is not a mean vector of the input sub-set of vectors but rather the mean
        vector of the whole set.*/
    COVAR_USE_AVG   = 2,
    /** If the flag is specified, the covariance matrix is scaled. In the
        "normal" mode, scale is 1./nsamples . In the "scrambled" mode, scale is the reciprocal of the
        total number of elements in each input vector. By default (if the flag is not specified), the
        covariance matrix is not scaled ( scale=1 ).*/
    COVAR_SCALE     = 4,
    /** If the flag is
        specified, all the input vectors are stored as rows of the samples matrix. mean should be a
        single-row vector in this case.*/
    COVAR_ROWS      = 8,
    /** If the flag is
        specified, all the input vectors are stored as columns of the samples matrix. mean should be a
        single-column vector in this case.*/
    COVAR_COLS      = 16;

/** \addtogroup core_cluster
 *   \{
 <p>
 *  k-Means flags */
/** enum cv::KmeansFlags */
public static final int
    /** Select random initial centers in each attempt.*/
    KMEANS_RANDOM_CENTERS     = 0,
    /** Use kmeans++ center initialization by Arthur and Vassilvitskii [Arthur2007].*/
    KMEANS_PP_CENTERS         = 2,
    /** During the first (and possibly the only) attempt, use the
        user-supplied labels instead of computing them from the initial centers. For the second and
        further attempts, use the random or semi-random centers. Use one of KMEANS_\*_CENTERS flag
        to specify the exact method.*/
    KMEANS_USE_INITIAL_LABELS = 1;

/** \} core_cluster
 <p>
 *  \addtogroup core_array
 *  \{ */

/** enum cv::ReduceTypes */
public static final int /** the output is the sum of all rows/columns of the matrix. */
 REDUCE_SUM = 0,
                   /** the output is the mean vector of all rows/columns of the matrix. */
                   REDUCE_AVG = 1,
                   /** the output is the maximum (column/row-wise) of all rows/columns of the matrix. */
                   REDUCE_MAX = 2,
                   /** the output is the minimum (column/row-wise) of all rows/columns of the matrix. */
                   REDUCE_MIN = 3,
                   /** the output is the sum of all squared rows/columns of the matrix. */
                   REDUCE_SUM2 = 4;

/** \} core_array
<p>
/** \brief Swaps two matrices
*/
@Namespace("cv") public static native void swap(@ByRef Mat a, @ByRef Mat b);
/** \overload */
@Namespace("cv") public static native void swap( @ByRef UMat a, @ByRef UMat b );

/** \} core
 <p>
 *  \addtogroup core_array
 *  \{
<p>
/** \brief Computes the source location of an extrapolated pixel.
<p>
The function computes and returns the coordinate of a donor pixel corresponding to the specified
extrapolated pixel when using the specified extrapolation border mode. For example, if you use
cv::BORDER_WRAP mode in the horizontal direction, cv::BORDER_REFLECT_101 in the vertical direction and
want to compute value of the "virtual" pixel Point(-5, 100) in a floating-point image img , it
looks like:
<pre>{@code {.cpp}
    float val = img.at<float>(borderInterpolate(100, img.rows, cv::BORDER_REFLECT_101),
                              borderInterpolate(-5, img.cols, cv::BORDER_WRAP));
}</pre>
Normally, the function is not called directly. It is used inside filtering functions and also in
copyMakeBorder.
@param p 0-based coordinate of the extrapolated pixel along one of the axes, likely \<0 or \>= len
@param len Length of the array along the corresponding axis.
@param borderType Border type, one of the #BorderTypes, except for #BORDER_TRANSPARENT and
#BORDER_ISOLATED . When borderType==#BORDER_CONSTANT , the function always returns -1, regardless
of p and len.
<p>
@see copyMakeBorder
*/
@Namespace("cv") public static native int borderInterpolate(int p, int len, int borderType);

/** \example samples/cpp/tutorial_code/ImgTrans/copyMakeBorder_demo.cpp
An example using copyMakeBorder function.
Check \ref tutorial_copyMakeBorder "the corresponding tutorial" for more details
*/

/** \brief Forms a border around an image.
<p>
The function copies the source image into the middle of the destination image. The areas to the
left, to the right, above and below the copied source image will be filled with extrapolated
pixels. This is not what filtering functions based on it do (they extrapolate pixels on-fly), but
what other more complex functions, including your own, may do to simplify image boundary handling.
<p>
The function supports the mode when src is already in the middle of dst . In this case, the
function does not copy src itself but simply constructs the border, for example:
<p>
<pre>{@code {.cpp}
    // let border be the same in all directions
    int border=2;
    // constructs a larger image to fit both the image and the border
    Mat gray_buf(rgb.rows + border*2, rgb.cols + border*2, rgb.depth());
    // select the middle part of it w/o copying data
    Mat gray(gray_canvas, Rect(border, border, rgb.cols, rgb.rows));
    // convert image from RGB to grayscale
    cvtColor(rgb, gray, COLOR_RGB2GRAY);
    // form a border in-place
    copyMakeBorder(gray, gray_buf, border, border,
                   border, border, BORDER_REPLICATE);
    // now do some custom filtering ...
    ...
}</pre>
\note When the source image is a part (ROI) of a bigger image, the function will try to use the
pixels outside of the ROI to form a border. To disable this feature and always do extrapolation, as
if src was not a ROI, use borderType | #BORDER_ISOLATED.
<p>
@param src Source image.
@param dst Destination image of the same type as src and the size Size(src.cols+left+right,
src.rows+top+bottom) .
@param top the top pixels
@param bottom the bottom pixels
@param left the left pixels
@param right Parameter specifying how many pixels in each direction from the source image rectangle
to extrapolate. For example, top=1, bottom=1, left=1, right=1 mean that 1 pixel-wide border needs
to be built.
@param borderType Border type. See borderInterpolate for details.
@param value Border value if borderType==BORDER_CONSTANT .
<p>
@see  borderInterpolate
*/
@Namespace("cv") public static native void copyMakeBorder(@ByVal Mat src, @ByVal Mat dst,
                                 int top, int bottom, int left, int right,
                                 int borderType, @Const @ByRef(nullValue = "cv::Scalar()") Scalar value );
@Namespace("cv") public static native void copyMakeBorder(@ByVal Mat src, @ByVal Mat dst,
                                 int top, int bottom, int left, int right,
                                 int borderType );
@Namespace("cv") public static native void copyMakeBorder(@ByVal UMat src, @ByVal UMat dst,
                                 int top, int bottom, int left, int right,
                                 int borderType, @Const @ByRef(nullValue = "cv::Scalar()") Scalar value );
@Namespace("cv") public static native void copyMakeBorder(@ByVal UMat src, @ByVal UMat dst,
                                 int top, int bottom, int left, int right,
                                 int borderType );
@Namespace("cv") public static native void copyMakeBorder(@ByVal GpuMat src, @ByVal GpuMat dst,
                                 int top, int bottom, int left, int right,
                                 int borderType, @Const @ByRef(nullValue = "cv::Scalar()") Scalar value );
@Namespace("cv") public static native void copyMakeBorder(@ByVal GpuMat src, @ByVal GpuMat dst,
                                 int top, int bottom, int left, int right,
                                 int borderType );

/** \brief Calculates the per-element sum of two arrays or an array and a scalar.
<p>
The function add calculates:
- Sum of two arrays when both input arrays have the same size and the same number of channels:
<pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} ( \texttt{src1}(I) +  \texttt{src2}(I)) \quad \texttt{if mask}(I) \ne0\]}</pre>
- Sum of an array and a scalar when src2 is constructed from Scalar or has the same number of
elements as {@code src1.channels()}:
<pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} ( \texttt{src1}(I) +  \texttt{src2} ) \quad \texttt{if mask}(I) \ne0\]}</pre>
- Sum of a scalar and an array when src1 is constructed from Scalar or has the same number of
elements as {@code src2.channels()}:
<pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} ( \texttt{src1} +  \texttt{src2}(I) ) \quad \texttt{if mask}(I) \ne0\]}</pre>
where {@code I} is a multi-dimensional index of array elements. In case of multi-channel arrays, each
channel is processed independently.
<p>
The first function in the list above can be replaced with matrix expressions:
<pre>{@code {.cpp}
    dst = src1 + src2;
    dst += src1; // equivalent to add(dst, src1, dst);
}</pre>
The input arrays and the output array can all have the same or different depths. For example, you
can add a 16-bit unsigned array to a 8-bit signed array and store the sum as a 32-bit
floating-point array. Depth of the output array is determined by the dtype parameter. In the second
and third cases above, as well as in the first case, when src1.depth() == src2.depth(), dtype can
be set to the default -1. In this case, the output array will have the same depth as the input
array, be it src1, src2 or both.
\note Saturation is not applied when the output array has the depth CV_32S. You may even get
result of an incorrect sign in the case of overflow.
\note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.
{@code add(src,X)} means {@code add(src,(X,X,X,X))}.
{@code add(src,(X,))} means {@code add(src,(X,0,0,0))}.
@param src1 first input array or a scalar.
@param src2 second input array or a scalar.
@param dst output array that has the same size and number of channels as the input array(s); the
depth is defined by dtype or src1/src2.
@param mask optional operation mask - 8-bit single channel array, that specifies elements of the
output array to be changed.
@param dtype optional depth of the output array (see the discussion below).
@see subtract, addWeighted, scaleAdd, Mat::convertTo
*/
@Namespace("cv") public static native void add(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst,
                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, int dtype/*=-1*/);
@Namespace("cv") public static native void add(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv") public static native void add(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst,
                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, int dtype/*=-1*/);
@Namespace("cv") public static native void add(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv") public static native void add(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst,
                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, int dtype/*=-1*/);
@Namespace("cv") public static native void add(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Calculates the per-element difference between two arrays or array and a scalar.
<p>
The function subtract calculates:
- Difference between two arrays, when both input arrays have the same size and the same number of
channels:
    <pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} ( \texttt{src1}(I) -  \texttt{src2}(I)) \quad \texttt{if mask}(I) \ne0\]}</pre>
- Difference between an array and a scalar, when src2 is constructed from Scalar or has the same
number of elements as {@code src1.channels()}:
    <pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} ( \texttt{src1}(I) -  \texttt{src2} ) \quad \texttt{if mask}(I) \ne0\]}</pre>
- Difference between a scalar and an array, when src1 is constructed from Scalar or has the same
number of elements as {@code src2.channels()}:
    <pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} ( \texttt{src1} -  \texttt{src2}(I) ) \quad \texttt{if mask}(I) \ne0\]}</pre>
- The reverse difference between a scalar and an array in the case of {@code SubRS}:
    <pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} ( \texttt{src2} -  \texttt{src1}(I) ) \quad \texttt{if mask}(I) \ne0\]}</pre>
where I is a multi-dimensional index of array elements. In case of multi-channel arrays, each
channel is processed independently.
<p>
The first function in the list above can be replaced with matrix expressions:
<pre>{@code {.cpp}
    dst = src1 - src2;
    dst -= src1; // equivalent to subtract(dst, src1, dst);
}</pre>
The input arrays and the output array can all have the same or different depths. For example, you
can subtract to 8-bit unsigned arrays and store the difference in a 16-bit signed array. Depth of
the output array is determined by dtype parameter. In the second and third cases above, as well as
in the first case, when src1.depth() == src2.depth(), dtype can be set to the default -1. In this
case the output array will have the same depth as the input array, be it src1, src2 or both.
\note Saturation is not applied when the output array has the depth CV_32S. You may even get
result of an incorrect sign in the case of overflow.
\note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.
{@code subtract(src,X)} means {@code subtract(src,(X,X,X,X))}.
{@code subtract(src,(X,))} means {@code subtract(src,(X,0,0,0))}.
@param src1 first input array or a scalar.
@param src2 second input array or a scalar.
@param dst output array of the same size and the same number of channels as the input array.
@param mask optional operation mask; this is an 8-bit single channel array that specifies elements
of the output array to be changed.
@param dtype optional depth of the output array
@see  add, addWeighted, scaleAdd, Mat::convertTo
  */
@Namespace("cv") public static native void subtract(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst,
                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, int dtype/*=-1*/);
@Namespace("cv") public static native void subtract(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv") public static native void subtract(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst,
                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, int dtype/*=-1*/);
@Namespace("cv") public static native void subtract(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv") public static native void subtract(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst,
                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, int dtype/*=-1*/);
@Namespace("cv") public static native void subtract(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);


/** \brief Calculates the per-element scaled product of two arrays.
<p>
The function multiply calculates the per-element product of two arrays:
<p>
<pre>{@code \[\texttt{dst} (I)= \texttt{saturate} ( \texttt{scale} \cdot \texttt{src1} (I)  \cdot \texttt{src2} (I))\]}</pre>
<p>
There is also a \ref MatrixExpressions -friendly variant of the first function. See Mat::mul .
<p>
For a not-per-element matrix product, see gemm .
<p>
\note Saturation is not applied when the output array has the depth
CV_32S. You may even get result of an incorrect sign in the case of
overflow.
\note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.
{@code multiply(src,X)} means {@code multiply(src,(X,X,X,X))}.
{@code multiply(src,(X,))} means {@code multiply(src,(X,0,0,0))}.
@param src1 first input array.
@param src2 second input array of the same size and the same type as src1.
@param dst output array of the same size and type as src1.
@param scale optional scale factor.
@param dtype optional depth of the output array
@see add, subtract, divide, scaleAdd, addWeighted, accumulate, accumulateProduct, accumulateSquare,
Mat::convertTo
*/
@Namespace("cv") public static native void multiply(@ByVal Mat src1, @ByVal Mat src2,
                           @ByVal Mat dst, double scale/*=1*/, int dtype/*=-1*/);
@Namespace("cv") public static native void multiply(@ByVal Mat src1, @ByVal Mat src2,
                           @ByVal Mat dst);
@Namespace("cv") public static native void multiply(@ByVal UMat src1, @ByVal UMat src2,
                           @ByVal UMat dst, double scale/*=1*/, int dtype/*=-1*/);
@Namespace("cv") public static native void multiply(@ByVal UMat src1, @ByVal UMat src2,
                           @ByVal UMat dst);
@Namespace("cv") public static native void multiply(@ByVal GpuMat src1, @ByVal GpuMat src2,
                           @ByVal GpuMat dst, double scale/*=1*/, int dtype/*=-1*/);
@Namespace("cv") public static native void multiply(@ByVal GpuMat src1, @ByVal GpuMat src2,
                           @ByVal GpuMat dst);

/** \brief Performs per-element division of two arrays or a scalar by an array.
<p>
The function cv::divide divides one array by another:
<pre>{@code \[\texttt{dst(I) = saturate(src1(I)*scale/src2(I))}\]}</pre>
or a scalar by an array when there is no src1 :
<pre>{@code \[\texttt{dst(I) = saturate(scale/src2(I))}\]}</pre>
<p>
Different channels of multi-channel arrays are processed independently.
<p>
For integer types when src2(I) is zero, dst(I) will also be zero.
<p>
\note In case of floating point data there is no special defined behavior for zero src2(I) values.
Regular floating-point division is used.
Expect correct IEEE-754 behaviour for floating-point data (with NaN, Inf result values).
<p>
\note Saturation is not applied when the output array has the depth CV_32S. You may even get
result of an incorrect sign in the case of overflow.
\note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.
{@code divide(src,X)} means {@code divide(src,(X,X,X,X))}.
{@code divide(src,(X,))} means {@code divide(src,(X,0,0,0))}.
@param src1 first input array.
@param src2 second input array of the same size and type as src1.
@param scale scalar factor.
@param dst output array of the same size and type as src2.
@param dtype optional depth of the output array; if -1, dst will have depth src2.depth(), but in
case of an array-by-array division, you can only pass -1 when src1.depth()==src2.depth().
@see  multiply, add, subtract
*/
@Namespace("cv") public static native void divide(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst,
                         double scale/*=1*/, int dtype/*=-1*/);
@Namespace("cv") public static native void divide(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv") public static native void divide(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst,
                         double scale/*=1*/, int dtype/*=-1*/);
@Namespace("cv") public static native void divide(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv") public static native void divide(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst,
                         double scale/*=1*/, int dtype/*=-1*/);
@Namespace("cv") public static native void divide(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \overload */
@Namespace("cv") public static native void divide(double scale, @ByVal Mat src2,
                         @ByVal Mat dst, int dtype/*=-1*/);
@Namespace("cv") public static native void divide(double scale, @ByVal Mat src2,
                         @ByVal Mat dst);
@Namespace("cv") public static native void divide(double scale, @ByVal UMat src2,
                         @ByVal UMat dst, int dtype/*=-1*/);
@Namespace("cv") public static native void divide(double scale, @ByVal UMat src2,
                         @ByVal UMat dst);
@Namespace("cv") public static native void divide(double scale, @ByVal GpuMat src2,
                         @ByVal GpuMat dst, int dtype/*=-1*/);
@Namespace("cv") public static native void divide(double scale, @ByVal GpuMat src2,
                         @ByVal GpuMat dst);

/** \brief Calculates the sum of a scaled array and another array.
<p>
The function scaleAdd is one of the classical primitive linear algebra operations, known as DAXPY
or SAXPY in [BLAS](http://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms). It calculates
the sum of a scaled array and another array:
<pre>{@code \[\texttt{dst} (I)= \texttt{scale} \cdot \texttt{src1} (I) +  \texttt{src2} (I)\]}</pre>
The function can also be emulated with a matrix expression, for example:
<pre>{@code {.cpp}
    Mat A(3, 3, CV_64F);
    ...
    A.row(0) = A.row(1)*2 + A.row(2);
}</pre>
@param src1 first input array.
@param alpha scale factor for the first array.
@param src2 second input array of the same size and type as src1.
@param dst output array of the same size and type as src1.
@see add, addWeighted, subtract, Mat::dot, Mat::convertTo
*/
@Namespace("cv") public static native void scaleAdd(@ByVal Mat src1, double alpha, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv") public static native void scaleAdd(@ByVal UMat src1, double alpha, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv") public static native void scaleAdd(@ByVal GpuMat src1, double alpha, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \example samples/cpp/tutorial_code/HighGUI/AddingImagesTrackbar.cpp
Check \ref tutorial_trackbar "the corresponding tutorial" for more details
*/

/** \brief Calculates the weighted sum of two arrays.
<p>
The function addWeighted calculates the weighted sum of two arrays as follows:
<pre>{@code \[\texttt{dst} (I)= \texttt{saturate} ( \texttt{src1} (I)* \texttt{alpha} +  \texttt{src2} (I)* \texttt{beta} +  \texttt{gamma} )\]}</pre>
where I is a multi-dimensional index of array elements. In case of multi-channel arrays, each
channel is processed independently.
The function can be replaced with a matrix expression:
<pre>{@code {.cpp}
    dst = src1*alpha + src2*beta + gamma;
}</pre>
\note Saturation is not applied when the output array has the depth CV_32S. You may even get
result of an incorrect sign in the case of overflow.
@param src1 first input array.
@param alpha weight of the first array elements.
@param src2 second input array of the same size and channel number as src1.
@param beta weight of the second array elements.
@param gamma scalar added to each sum.
@param dst output array that has the same size and number of channels as the input arrays.
@param dtype optional depth of the output array; when both input arrays have the same depth, dtype
can be set to -1, which will be equivalent to src1.depth().
@see  add, subtract, scaleAdd, Mat::convertTo
*/
@Namespace("cv") public static native void addWeighted(@ByVal Mat src1, double alpha, @ByVal Mat src2,
                              double beta, double gamma, @ByVal Mat dst, int dtype/*=-1*/);
@Namespace("cv") public static native void addWeighted(@ByVal Mat src1, double alpha, @ByVal Mat src2,
                              double beta, double gamma, @ByVal Mat dst);
@Namespace("cv") public static native void addWeighted(@ByVal UMat src1, double alpha, @ByVal UMat src2,
                              double beta, double gamma, @ByVal UMat dst, int dtype/*=-1*/);
@Namespace("cv") public static native void addWeighted(@ByVal UMat src1, double alpha, @ByVal UMat src2,
                              double beta, double gamma, @ByVal UMat dst);
@Namespace("cv") public static native void addWeighted(@ByVal GpuMat src1, double alpha, @ByVal GpuMat src2,
                              double beta, double gamma, @ByVal GpuMat dst, int dtype/*=-1*/);
@Namespace("cv") public static native void addWeighted(@ByVal GpuMat src1, double alpha, @ByVal GpuMat src2,
                              double beta, double gamma, @ByVal GpuMat dst);

/** \brief Scales, calculates absolute values, and converts the result to 8-bit.
<p>
On each element of the input array, the function convertScaleAbs
performs three operations sequentially: scaling, taking an absolute
value, conversion to an unsigned 8-bit type:
<pre>{@code \[\texttt{dst} (I)= \texttt{saturate\_cast<uchar>} (| \texttt{src} (I)* \texttt{alpha} +  \texttt{beta} |)\]}</pre>
In case of multi-channel arrays, the function processes each channel
independently. When the output is not 8-bit, the operation can be
emulated by calling the Mat::convertTo method (or by using matrix
expressions) and then by calculating an absolute value of the result.
For example:
<pre>{@code {.cpp}
    Mat_<float> A(30,30);
    randu(A, Scalar(-100), Scalar(100));
    Mat_<float> B = A*5 + 3;
    B = abs(B);
    // Mat_<float> B = abs(A*5+3) will also do the job,
    // but it will allocate a temporary matrix
}</pre>
@param src input array.
@param dst output array.
@param alpha optional scale factor.
@param beta optional delta added to the scaled values.
@see  Mat::convertTo, cv::abs(const Mat&)
*/
@Namespace("cv") public static native void convertScaleAbs(@ByVal Mat src, @ByVal Mat dst,
                                  double alpha/*=1*/, double beta/*=0*/);
@Namespace("cv") public static native void convertScaleAbs(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void convertScaleAbs(@ByVal UMat src, @ByVal UMat dst,
                                  double alpha/*=1*/, double beta/*=0*/);
@Namespace("cv") public static native void convertScaleAbs(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void convertScaleAbs(@ByVal GpuMat src, @ByVal GpuMat dst,
                                  double alpha/*=1*/, double beta/*=0*/);
@Namespace("cv") public static native void convertScaleAbs(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Converts an array to half precision floating number.
<p>
This function converts FP32 (single precision floating point) from/to FP16 (half precision floating point). CV_16S format is used to represent FP16 data.
There are two use modes (src -> dst): CV_32F -> CV_16S and CV_16S -> CV_32F. The input array has to have type of CV_32F or
CV_16S to represent the bit depth. If the input array is neither of them, the function will raise an error.
The format of half precision floating point is defined in IEEE 754-2008.
<p>
@param src input array.
@param dst output array.
*/
@Namespace("cv") public static native void convertFp16(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void convertFp16(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void convertFp16(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Performs a look-up table transform of an array.
<p>
The function LUT fills the output array with values from the look-up table. Indices of the entries
are taken from the input array. That is, the function processes each element of src as follows:
<pre>{@code \[\texttt{dst} (I)  \leftarrow \texttt{lut(src(I) + d)}\]}</pre>
where
<pre>{@code \[d =  \fork{0}{if \(\texttt{src}\) has depth \(\texttt{CV_8U}\)}{128}{if \(\texttt{src}\) has depth \(\texttt{CV_8S}\)}\]}</pre>
@param src input array of 8-bit elements.
@param lut look-up table of 256 elements; in case of multi-channel input array, the table should
either have a single channel (in this case the same table is used for all channels) or the same
number of channels as in the input array.
@param dst output array of the same size and number of channels as src, and the same depth as lut.
@see  convertScaleAbs, Mat::convertTo
*/
@Namespace("cv") public static native void LUT(@ByVal Mat src, @ByVal Mat lut, @ByVal Mat dst);
@Namespace("cv") public static native void LUT(@ByVal UMat src, @ByVal UMat lut, @ByVal UMat dst);
@Namespace("cv") public static native void LUT(@ByVal GpuMat src, @ByVal GpuMat lut, @ByVal GpuMat dst);

/** \brief Calculates the sum of array elements.
<p>
The function cv::sum calculates and returns the sum of array elements,
independently for each channel.
@param src input array that must have from 1 to 4 channels.
@see  countNonZero, mean, meanStdDev, norm, minMaxLoc, reduce
*/
@Namespace("cv") public static native @ByVal @Name("sum") Scalar sumElems(@ByVal Mat src);
@Namespace("cv") public static native @ByVal @Name("sum") Scalar sumElems(@ByVal UMat src);
@Namespace("cv") public static native @ByVal @Name("sum") Scalar sumElems(@ByVal GpuMat src);

/** \brief Checks for the presence of at least one non-zero array element.
<p>
The function returns whether there are non-zero elements in src
@param src single-channel array.
@see  mean, meanStdDev, norm, minMaxLoc, calcCovarMatrix
*/
@Namespace("cv") public static native @Cast("bool") boolean hasNonZero( @ByVal Mat src );
@Namespace("cv") public static native @Cast("bool") boolean hasNonZero( @ByVal UMat src );
@Namespace("cv") public static native @Cast("bool") boolean hasNonZero( @ByVal GpuMat src );

/** \brief Counts non-zero array elements.
<p>
The function returns the number of non-zero elements in src :
<pre>{@code \[\sum _{I: \; \texttt{src} (I) \ne0 } 1\]}</pre>
@param src single-channel array.
@see  mean, meanStdDev, norm, minMaxLoc, calcCovarMatrix
*/
@Namespace("cv") public static native int countNonZero( @ByVal Mat src );
@Namespace("cv") public static native int countNonZero( @ByVal UMat src );
@Namespace("cv") public static native int countNonZero( @ByVal GpuMat src );

/** \brief Returns the list of locations of non-zero pixels
<p>
Given a binary matrix (likely returned from an operation such
as threshold(), compare(), >, ==, etc, return all of
the non-zero indices as a cv::Mat or std::vector<cv::Point> (x,y)
For example:
<pre>{@code {.cpp}
    cv::Mat binaryImage; // input, binary image
    cv::Mat locations;   // output, locations of non-zero pixels
    cv::findNonZero(binaryImage, locations);

    // access pixel coordinates
    Point pnt = locations.at<Point>(i);
}</pre>
or
<pre>{@code {.cpp}
    cv::Mat binaryImage; // input, binary image
    vector<Point> locations;   // output, locations of non-zero pixels
    cv::findNonZero(binaryImage, locations);

    // access pixel coordinates
    Point pnt = locations[i];
}</pre>
@param src single-channel array
@param idx the output array, type of cv::Mat or std::vector<Point>, corresponding to non-zero indices in the input
*/
@Namespace("cv") public static native void findNonZero( @ByVal Mat src, @ByVal Mat idx );
@Namespace("cv") public static native void findNonZero( @ByVal UMat src, @ByVal UMat idx );
@Namespace("cv") public static native void findNonZero( @ByVal GpuMat src, @ByVal GpuMat idx );

/** \brief Calculates an average (mean) of array elements.
<p>
The function cv::mean calculates the mean value M of array elements,
independently for each channel, and return it:
<pre>{@code \[\begin{array}{l} N =  \sum _{I: \; \texttt{mask} (I) \ne 0} 1 \\ M_c =  \left ( \sum _{I: \; \texttt{mask} (I) \ne 0}{ \texttt{mtx} (I)_c} \right )/N \end{array}\]}</pre>
When all the mask elements are 0's, the function returns Scalar::all(0)
@param src input array that should have from 1 to 4 channels so that the result can be stored in
Scalar_ .
@param mask optional operation mask.
@see  countNonZero, meanStdDev, norm, minMaxLoc
*/
@Namespace("cv") public static native @ByVal Scalar mean(@ByVal Mat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native @ByVal Scalar mean(@ByVal Mat src);
@Namespace("cv") public static native @ByVal Scalar mean(@ByVal UMat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native @ByVal Scalar mean(@ByVal UMat src);
@Namespace("cv") public static native @ByVal Scalar mean(@ByVal GpuMat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native @ByVal Scalar mean(@ByVal GpuMat src);

/** Calculates a mean and standard deviation of array elements.
<p>
The function cv::meanStdDev calculates the mean and the standard deviation M
of array elements independently for each channel and returns it via the
output parameters:
<pre>{@code \[\begin{array}{l} N =  \sum _{I, \texttt{mask} (I)  \ne 0} 1 \\ \texttt{mean} _c =  \frac{\sum_{ I: \; \texttt{mask}(I) \ne 0} \texttt{src} (I)_c}{N} \\ \texttt{stddev} _c =  \sqrt{\frac{\sum_{ I: \; \texttt{mask}(I) \ne 0} \left ( \texttt{src} (I)_c -  \texttt{mean} _c \right )^2}{N}} \end{array}\]}</pre>
When all the mask elements are 0's, the function returns
mean=stddev=Scalar::all(0).
\note The calculated standard deviation is only the diagonal of the
complete normalized covariance matrix. If the full matrix is needed, you
can reshape the multi-channel array M x N to the single-channel array
M\*N x mtx.channels() (only possible when the matrix is continuous) and
then pass the matrix to calcCovarMatrix .
@param src input array that should have from 1 to 4 channels so that the results can be stored in
Scalar_ 's.
@param mean output parameter: calculated mean value.
@param stddev output parameter: calculated standard deviation.
@param mask optional operation mask.
@see  countNonZero, mean, norm, minMaxLoc, calcCovarMatrix
*/
@Namespace("cv") public static native void meanStdDev(@ByVal Mat src, @ByVal Mat mean, @ByVal Mat stddev,
                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void meanStdDev(@ByVal Mat src, @ByVal Mat mean, @ByVal Mat stddev);
@Namespace("cv") public static native void meanStdDev(@ByVal UMat src, @ByVal UMat mean, @ByVal UMat stddev,
                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void meanStdDev(@ByVal UMat src, @ByVal UMat mean, @ByVal UMat stddev);
@Namespace("cv") public static native void meanStdDev(@ByVal GpuMat src, @ByVal GpuMat mean, @ByVal GpuMat stddev,
                             @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void meanStdDev(@ByVal GpuMat src, @ByVal GpuMat mean, @ByVal GpuMat stddev);

/** \brief Calculates the  absolute norm of an array.
<p>
This version of #norm calculates the absolute norm of src1. The type of norm to calculate is specified using #NormTypes.
<p>
As example for one array consider the function {@code r(x)= \begin{pmatrix} x \\ 1-x \end{pmatrix}, x \in [-1;1]}.
The {@code  L_{1}, L_{2} } and {@code  L_{\infty} } norm for the sample value {@code r(-1) = \begin{pmatrix} -1 \\ 2 \end{pmatrix}}
is calculated as follows
\f{align*}
    \| r(-1) \|_{L_1} &= |-1| + |2| = 3 \
    \| r(-1) \|_{L_2} &= \sqrt{(-1)^{2} + (2)^{2}} = \sqrt{5} \
    \| r(-1) \|_{L_\infty} &= \max(|-1|,|2|) = 2
\f}
and for {@code r(0.5) = \begin{pmatrix} 0.5 \\ 0.5 \end{pmatrix}} the calculation is
\f{align*}
    \| r(0.5) \|_{L_1} &= |0.5| + |0.5| = 1 \
    \| r(0.5) \|_{L_2} &= \sqrt{(0.5)^{2} + (0.5)^{2}} = \sqrt{0.5} \
    \| r(0.5) \|_{L_\infty} &= \max(|0.5|,|0.5|) = 0.5.
\f}
The following graphic shows all values for the three norm functions {@code \| r(x) \|_{L_1}, \| r(x) \|_{L_2}} and {@code \| r(x) \|_{L_\infty}}.
It is notable that the {@code  L_{1} } norm forms the upper and the {@code  L_{\infty} } norm forms the lower border for the example function {@code  r(x) }.
![Graphs for the different norm functions from the above example](pics/NormTypes_OneArray_1-2-INF.png)
<p>
When the mask parameter is specified and it is not empty, the norm is
<p>
If normType is not specified, #NORM_L2 is used.
calculated only over the region specified by the mask.
<p>
Multi-channel input arrays are treated as single-channel arrays, that is,
the results for all channels are combined.
<p>
Hamming norms can only be calculated with CV_8U depth arrays.
<p>
@param src1 first input array.
@param normType type of the norm (see #NormTypes).
@param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type.
*/
@Namespace("cv") public static native double norm(@ByVal Mat src1, int normType/*=cv::NORM_L2*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native double norm(@ByVal Mat src1);
@Namespace("cv") public static native double norm(@ByVal UMat src1, int normType/*=cv::NORM_L2*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native double norm(@ByVal UMat src1);
@Namespace("cv") public static native double norm(@ByVal GpuMat src1, int normType/*=cv::NORM_L2*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native double norm(@ByVal GpuMat src1);

/** \brief Calculates an absolute difference norm or a relative difference norm.
<p>
This version of cv::norm calculates the absolute difference norm
or the relative difference norm of arrays src1 and src2.
The type of norm to calculate is specified using #NormTypes.
<p>
@param src1 first input array.
@param src2 second input array of the same size and the same type as src1.
@param normType type of the norm (see #NormTypes).
@param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type.
*/
@Namespace("cv") public static native double norm(@ByVal Mat src1, @ByVal Mat src2,
                         int normType/*=cv::NORM_L2*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native double norm(@ByVal Mat src1, @ByVal Mat src2);
@Namespace("cv") public static native double norm(@ByVal UMat src1, @ByVal UMat src2,
                         int normType/*=cv::NORM_L2*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native double norm(@ByVal UMat src1, @ByVal UMat src2);
@Namespace("cv") public static native double norm(@ByVal GpuMat src1, @ByVal GpuMat src2,
                         int normType/*=cv::NORM_L2*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native double norm(@ByVal GpuMat src1, @ByVal GpuMat src2);
/** \overload
@param src first input array.
@param normType type of the norm (see #NormTypes).
*/
@Namespace("cv") public static native double norm( @Const @ByRef SparseMat src, int normType );

/** \brief Computes the Peak Signal-to-Noise Ratio (PSNR) image quality metric.
<p>
This function calculates the Peak Signal-to-Noise Ratio (PSNR) image quality metric in decibels (dB),
between two input arrays src1 and src2. The arrays must have the same type.
<p>
The PSNR is calculated as follows:
<p>
<pre>{@code \[
\texttt{PSNR} = 10 \cdot \log_{10}{\left( \frac{R^2}{MSE} \right) }
\]}</pre>
<p>
where R is the maximum integer value of depth (e.g. 255 in the case of CV_8U data)
and MSE is the mean squared error between the two arrays.
<p>
@param src1 first input array.
@param src2 second input array of the same size as src1.
@param R the maximum pixel value (255 by default)
  <p>
  */
@Namespace("cv") public static native double PSNR(@ByVal Mat src1, @ByVal Mat src2, double R/*=255.*/);
@Namespace("cv") public static native double PSNR(@ByVal Mat src1, @ByVal Mat src2);
@Namespace("cv") public static native double PSNR(@ByVal UMat src1, @ByVal UMat src2, double R/*=255.*/);
@Namespace("cv") public static native double PSNR(@ByVal UMat src1, @ByVal UMat src2);
@Namespace("cv") public static native double PSNR(@ByVal GpuMat src1, @ByVal GpuMat src2, double R/*=255.*/);
@Namespace("cv") public static native double PSNR(@ByVal GpuMat src1, @ByVal GpuMat src2);

/** \brief naive nearest neighbor finder
<p>
see http://en.wikipedia.org/wiki/Nearest_neighbor_search
\todo document
  */
@Namespace("cv") public static native void batchDistance(@ByVal Mat src1, @ByVal Mat src2,
                                @ByVal Mat dist, int dtype, @ByVal Mat nidx,
                                int normType/*=cv::NORM_L2*/, int K/*=0*/,
                                @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, int update/*=0*/,
                                @Cast("bool") boolean crosscheck/*=false*/);
@Namespace("cv") public static native void batchDistance(@ByVal Mat src1, @ByVal Mat src2,
                                @ByVal Mat dist, int dtype, @ByVal Mat nidx);
@Namespace("cv") public static native void batchDistance(@ByVal UMat src1, @ByVal UMat src2,
                                @ByVal UMat dist, int dtype, @ByVal UMat nidx,
                                int normType/*=cv::NORM_L2*/, int K/*=0*/,
                                @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, int update/*=0*/,
                                @Cast("bool") boolean crosscheck/*=false*/);
@Namespace("cv") public static native void batchDistance(@ByVal UMat src1, @ByVal UMat src2,
                                @ByVal UMat dist, int dtype, @ByVal UMat nidx);
@Namespace("cv") public static native void batchDistance(@ByVal GpuMat src1, @ByVal GpuMat src2,
                                @ByVal GpuMat dist, int dtype, @ByVal GpuMat nidx,
                                int normType/*=cv::NORM_L2*/, int K/*=0*/,
                                @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, int update/*=0*/,
                                @Cast("bool") boolean crosscheck/*=false*/);
@Namespace("cv") public static native void batchDistance(@ByVal GpuMat src1, @ByVal GpuMat src2,
                                @ByVal GpuMat dist, int dtype, @ByVal GpuMat nidx);

/** \brief Normalizes the norm or value range of an array.
<p>
The function cv::normalize normalizes scale and shift the input array elements so that
<pre>{@code \[\| \texttt{dst} \| _{L_p}= \texttt{alpha}\]}</pre>
(where p=Inf, 1 or 2) when normType=NORM_INF, NORM_L1, or NORM_L2, respectively; or so that
<pre>{@code \[\min _I  \texttt{dst} (I)= \texttt{alpha} , \, \, \max _I  \texttt{dst} (I)= \texttt{beta}\]}</pre>
<p>
when normType=NORM_MINMAX (for dense arrays only). The optional mask specifies a sub-array to be
normalized. This means that the norm or min-n-max are calculated over the sub-array, and then this
sub-array is modified to be normalized. If you want to only use the mask to calculate the norm or
min-max but modify the whole array, you can use norm and Mat::convertTo.
<p>
In case of sparse matrices, only the non-zero values are analyzed and transformed. Because of this,
the range transformation for sparse matrices is not allowed since it can shift the zero level.
<p>
Possible usage with some positive example data:
<pre>{@code {.cpp}
    vector<double> positiveData = { 2.0, 8.0, 10.0 };
    vector<double> normalizedData_l1, normalizedData_l2, normalizedData_inf, normalizedData_minmax;

    // Norm to probability (total count)
    // sum(numbers) = 20.0
    // 2.0      0.1     (2.0/20.0)
    // 8.0      0.4     (8.0/20.0)
    // 10.0     0.5     (10.0/20.0)
    normalize(positiveData, normalizedData_l1, 1.0, 0.0, NORM_L1);

    // Norm to unit vector: ||positiveData|| = 1.0
    // 2.0      0.15
    // 8.0      0.62
    // 10.0     0.77
    normalize(positiveData, normalizedData_l2, 1.0, 0.0, NORM_L2);

    // Norm to max element
    // 2.0      0.2     (2.0/10.0)
    // 8.0      0.8     (8.0/10.0)
    // 10.0     1.0     (10.0/10.0)
    normalize(positiveData, normalizedData_inf, 1.0, 0.0, NORM_INF);

    // Norm to range [0.0;1.0]
    // 2.0      0.0     (shift to left border)
    // 8.0      0.75    (6.0/8.0)
    // 10.0     1.0     (shift to right border)
    normalize(positiveData, normalizedData_minmax, 1.0, 0.0, NORM_MINMAX);
}</pre>
<p>
@param src input array.
@param dst output array of the same size as src .
@param alpha norm value to normalize to or the lower range boundary in case of the range
normalization.
@param beta upper range boundary in case of the range normalization; it is not used for the norm
normalization.
@param norm_type normalization type (see cv::NormTypes).
@param dtype when negative, the output array has the same type as src; otherwise, it has the same
number of channels as src and the depth =CV_MAT_DEPTH(dtype).
@param mask optional operation mask.
@see norm, Mat::convertTo, SparseMat::convertTo
*/
@Namespace("cv") public static native void normalize( @ByVal Mat src, @ByVal Mat dst, double alpha/*=1*/, double beta/*=0*/,
                             int norm_type/*=cv::NORM_L2*/, int dtype/*=-1*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void normalize( @ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void normalize( @ByVal UMat src, @ByVal UMat dst, double alpha/*=1*/, double beta/*=0*/,
                             int norm_type/*=cv::NORM_L2*/, int dtype/*=-1*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void normalize( @ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void normalize( @ByVal GpuMat src, @ByVal GpuMat dst, double alpha/*=1*/, double beta/*=0*/,
                             int norm_type/*=cv::NORM_L2*/, int dtype/*=-1*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void normalize( @ByVal GpuMat src, @ByVal GpuMat dst);

/** \overload
@param src input array.
@param dst output array of the same size as src .
@param alpha norm value to normalize to or the lower range boundary in case of the range
normalization.
@param normType normalization type (see cv::NormTypes).
*/
@Namespace("cv") public static native void normalize( @Const @ByRef SparseMat src, @ByRef SparseMat dst, double alpha, int normType );

/** \brief Finds the global minimum and maximum in an array.
<p>
The function cv::minMaxLoc finds the minimum and maximum element values and their positions. The
extremums are searched across the whole array or, if mask is not an empty array, in the specified
array region.
<p>
The function do not work with multi-channel arrays. If you need to find minimum or maximum
elements across all the channels, use Mat::reshape first to reinterpret the array as
single-channel. Or you may extract the particular channel using either extractImageCOI , or
mixChannels , or split .
@param src input single-channel array.
@param minVal pointer to the returned minimum value; NULL is used if not required.
@param maxVal pointer to the returned maximum value; NULL is used if not required.
@param minLoc pointer to the returned minimum location (in 2D case); NULL is used if not required.
@param maxLoc pointer to the returned maximum location (in 2D case); NULL is used if not required.
@param mask optional mask used to select a sub-array.
@see max, min, reduceArgMin, reduceArgMax, compare, inRange, extractImageCOI, mixChannels, split, Mat::reshape
*/
@Namespace("cv") public static native void minMaxLoc(@ByVal Mat src, DoublePointer minVal,
                            DoublePointer maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal Mat src, DoublePointer minVal);
@Namespace("cv") public static native void minMaxLoc(@ByVal Mat src, DoubleBuffer minVal,
                            DoubleBuffer maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal Mat src, DoubleBuffer minVal);
@Namespace("cv") public static native void minMaxLoc(@ByVal Mat src, double[] minVal,
                            double[] maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal Mat src, double[] minVal);
@Namespace("cv") public static native void minMaxLoc(@ByVal UMat src, DoublePointer minVal,
                            DoublePointer maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal UMat src, DoublePointer minVal);
@Namespace("cv") public static native void minMaxLoc(@ByVal UMat src, DoubleBuffer minVal,
                            DoubleBuffer maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal UMat src, DoubleBuffer minVal);
@Namespace("cv") public static native void minMaxLoc(@ByVal UMat src, double[] minVal,
                            double[] maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal UMat src, double[] minVal);
@Namespace("cv") public static native void minMaxLoc(@ByVal GpuMat src, DoublePointer minVal,
                            DoublePointer maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal GpuMat src, DoublePointer minVal);
@Namespace("cv") public static native void minMaxLoc(@ByVal GpuMat src, DoubleBuffer minVal,
                            DoubleBuffer maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal GpuMat src, DoubleBuffer minVal);
@Namespace("cv") public static native void minMaxLoc(@ByVal GpuMat src, double[] minVal,
                            double[] maxVal/*=0*/, Point minLoc/*=0*/,
                            Point maxLoc/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void minMaxLoc(@ByVal GpuMat src, double[] minVal);

/**
 * \brief Finds indices of min elements along provided axis
 *
 * \note
 *      - If input or output array is not continuous, this function will create an internal copy.
 *      - NaN handling is left unspecified, see patchNaNs().
 *      - The returned index is always in bounds of input matrix.
 *
 * @param src input single-channel array.
 * @param dst output array of type CV_32SC1 with the same dimensionality as src,
 * except for axis being reduced - it should be set to 1.
 * @param lastIndex whether to get the index of first or last occurrence of min.
 * @param axis axis to reduce along.
 * @see reduceArgMax, minMaxLoc, min, max, compare, reduce
 */
@Namespace("cv") public static native void reduceArgMin(@ByVal Mat src, @ByVal Mat dst, int axis, @Cast("bool") boolean lastIndex/*=false*/);
@Namespace("cv") public static native void reduceArgMin(@ByVal Mat src, @ByVal Mat dst, int axis);
@Namespace("cv") public static native void reduceArgMin(@ByVal UMat src, @ByVal UMat dst, int axis, @Cast("bool") boolean lastIndex/*=false*/);
@Namespace("cv") public static native void reduceArgMin(@ByVal UMat src, @ByVal UMat dst, int axis);
@Namespace("cv") public static native void reduceArgMin(@ByVal GpuMat src, @ByVal GpuMat dst, int axis, @Cast("bool") boolean lastIndex/*=false*/);
@Namespace("cv") public static native void reduceArgMin(@ByVal GpuMat src, @ByVal GpuMat dst, int axis);

/**
 * \brief Finds indices of max elements along provided axis
 *
 * \note
 *      - If input or output array is not continuous, this function will create an internal copy.
 *      - NaN handling is left unspecified, see patchNaNs().
 *      - The returned index is always in bounds of input matrix.
 *
 * @param src input single-channel array.
 * @param dst output array of type CV_32SC1 with the same dimensionality as src,
 * except for axis being reduced - it should be set to 1.
 * @param lastIndex whether to get the index of first or last occurrence of max.
 * @param axis axis to reduce along.
 * @see reduceArgMin, minMaxLoc, min, max, compare, reduce
 */
@Namespace("cv") public static native void reduceArgMax(@ByVal Mat src, @ByVal Mat dst, int axis, @Cast("bool") boolean lastIndex/*=false*/);
@Namespace("cv") public static native void reduceArgMax(@ByVal Mat src, @ByVal Mat dst, int axis);
@Namespace("cv") public static native void reduceArgMax(@ByVal UMat src, @ByVal UMat dst, int axis, @Cast("bool") boolean lastIndex/*=false*/);
@Namespace("cv") public static native void reduceArgMax(@ByVal UMat src, @ByVal UMat dst, int axis);
@Namespace("cv") public static native void reduceArgMax(@ByVal GpuMat src, @ByVal GpuMat dst, int axis, @Cast("bool") boolean lastIndex/*=false*/);
@Namespace("cv") public static native void reduceArgMax(@ByVal GpuMat src, @ByVal GpuMat dst, int axis);

/** \brief Finds the global minimum and maximum in an array
<p>
The function cv::minMaxIdx finds the minimum and maximum element values and their positions. The
extremums are searched across the whole array or, if mask is not an empty array, in the specified
array region. The function does not work with multi-channel arrays. If you need to find minimum or
maximum elements across all the channels, use Mat::reshape first to reinterpret the array as
single-channel. Or you may extract the particular channel using either extractImageCOI , or
mixChannels , or split . In case of a sparse matrix, the minimum is found among non-zero elements
only.
\note When minIdx is not NULL, it must have at least 2 elements (as well as maxIdx), even if src is
a single-row or single-column matrix. In OpenCV (following MATLAB) each array has at least 2
dimensions, i.e. single-column matrix is Mx1 matrix (and therefore minIdx/maxIdx will be
(i1,0)/(i2,0)) and single-row matrix is 1xN matrix (and therefore minIdx/maxIdx will be
(0,j1)/(0,j2)).
@param src input single-channel array.
@param minVal pointer to the returned minimum value; NULL is used if not required.
@param maxVal pointer to the returned maximum value; NULL is used if not required.
@param minIdx pointer to the returned minimum location (in nD case); NULL is used if not required;
Otherwise, it must point to an array of src.dims elements, the coordinates of the minimum element
in each dimension are stored there sequentially.
@param maxIdx pointer to the returned maximum location (in nD case). NULL is used if not required.
@param mask specified array region
*/
@Namespace("cv") public static native void minMaxIdx(@ByVal Mat src, DoublePointer minVal, DoublePointer maxVal/*=0*/,
                          IntPointer minIdx/*=0*/, IntPointer maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal Mat src, DoublePointer minVal);
@Namespace("cv") public static native void minMaxIdx(@ByVal Mat src, DoubleBuffer minVal, DoubleBuffer maxVal/*=0*/,
                          IntBuffer minIdx/*=0*/, IntBuffer maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal Mat src, DoubleBuffer minVal);
@Namespace("cv") public static native void minMaxIdx(@ByVal Mat src, double[] minVal, double[] maxVal/*=0*/,
                          int[] minIdx/*=0*/, int[] maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal Mat src, double[] minVal);
@Namespace("cv") public static native void minMaxIdx(@ByVal UMat src, DoublePointer minVal, DoublePointer maxVal/*=0*/,
                          IntPointer minIdx/*=0*/, IntPointer maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal UMat src, DoublePointer minVal);
@Namespace("cv") public static native void minMaxIdx(@ByVal UMat src, DoubleBuffer minVal, DoubleBuffer maxVal/*=0*/,
                          IntBuffer minIdx/*=0*/, IntBuffer maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal UMat src, DoubleBuffer minVal);
@Namespace("cv") public static native void minMaxIdx(@ByVal UMat src, double[] minVal, double[] maxVal/*=0*/,
                          int[] minIdx/*=0*/, int[] maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal UMat src, double[] minVal);
@Namespace("cv") public static native void minMaxIdx(@ByVal GpuMat src, DoublePointer minVal, DoublePointer maxVal/*=0*/,
                          IntPointer minIdx/*=0*/, IntPointer maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal GpuMat src, DoublePointer minVal);
@Namespace("cv") public static native void minMaxIdx(@ByVal GpuMat src, DoubleBuffer minVal, DoubleBuffer maxVal/*=0*/,
                          IntBuffer minIdx/*=0*/, IntBuffer maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal GpuMat src, DoubleBuffer minVal);
@Namespace("cv") public static native void minMaxIdx(@ByVal GpuMat src, double[] minVal, double[] maxVal/*=0*/,
                          int[] minIdx/*=0*/, int[] maxIdx/*=0*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void minMaxIdx(@ByVal GpuMat src, double[] minVal);

/** \overload
@param a input single-channel array.
@param minVal pointer to the returned minimum value; NULL is used if not required.
@param maxVal pointer to the returned maximum value; NULL is used if not required.
@param minIdx pointer to the returned minimum location (in nD case); NULL is used if not required;
Otherwise, it must point to an array of src.dims elements, the coordinates of the minimum element
in each dimension are stored there sequentially.
@param maxIdx pointer to the returned maximum location (in nD case). NULL is used if not required.
*/
@Namespace("cv") public static native void minMaxLoc(@Const @ByRef SparseMat a, DoublePointer minVal,
                          DoublePointer maxVal, IntPointer minIdx/*=0*/, IntPointer maxIdx/*=0*/);
@Namespace("cv") public static native void minMaxLoc(@Const @ByRef SparseMat a, DoublePointer minVal,
                          DoublePointer maxVal);
@Namespace("cv") public static native void minMaxLoc(@Const @ByRef SparseMat a, DoubleBuffer minVal,
                          DoubleBuffer maxVal, IntBuffer minIdx/*=0*/, IntBuffer maxIdx/*=0*/);
@Namespace("cv") public static native void minMaxLoc(@Const @ByRef SparseMat a, DoubleBuffer minVal,
                          DoubleBuffer maxVal);
@Namespace("cv") public static native void minMaxLoc(@Const @ByRef SparseMat a, double[] minVal,
                          double[] maxVal, int[] minIdx/*=0*/, int[] maxIdx/*=0*/);
@Namespace("cv") public static native void minMaxLoc(@Const @ByRef SparseMat a, double[] minVal,
                          double[] maxVal);

/** \brief Reduces a matrix to a vector.
<p>
The function #reduce reduces the matrix to a vector by treating the matrix rows/columns as a set of
1D vectors and performing the specified operation on the vectors until a single row/column is
obtained. For example, the function can be used to compute horizontal and vertical projections of a
raster image. In case of #REDUCE_MAX and #REDUCE_MIN , the output image should have the same type as the source one.
In case of #REDUCE_SUM, #REDUCE_SUM2 and #REDUCE_AVG , the output may have a larger element bit-depth to preserve accuracy.
And multi-channel arrays are also supported in these two reduction modes.
<p>
The following code demonstrates its usage for a single channel matrix.
\snippet snippets/core_reduce.cpp example
<p>
And the following code demonstrates its usage for a two-channel matrix.
\snippet snippets/core_reduce.cpp example2
<p>
@param src input 2D matrix.
@param dst output vector. Its size and type is defined by dim and dtype parameters.
@param dim dimension index along which the matrix is reduced. 0 means that the matrix is reduced to
a single row. 1 means that the matrix is reduced to a single column.
@param rtype reduction operation that could be one of #ReduceTypes
@param dtype when negative, the output vector will have the same type as the input matrix,
otherwise, its type will be CV_MAKE_TYPE(CV_MAT_DEPTH(dtype), src.channels()).
@see repeat, reduceArgMin, reduceArgMax
*/
@Namespace("cv") public static native void reduce(@ByVal Mat src, @ByVal Mat dst, int dim, int rtype, int dtype/*=-1*/);
@Namespace("cv") public static native void reduce(@ByVal Mat src, @ByVal Mat dst, int dim, int rtype);
@Namespace("cv") public static native void reduce(@ByVal UMat src, @ByVal UMat dst, int dim, int rtype, int dtype/*=-1*/);
@Namespace("cv") public static native void reduce(@ByVal UMat src, @ByVal UMat dst, int dim, int rtype);
@Namespace("cv") public static native void reduce(@ByVal GpuMat src, @ByVal GpuMat dst, int dim, int rtype, int dtype/*=-1*/);
@Namespace("cv") public static native void reduce(@ByVal GpuMat src, @ByVal GpuMat dst, int dim, int rtype);

/** \brief Creates one multi-channel array out of several single-channel ones.
<p>
The function cv::merge merges several arrays to make a single multi-channel array. That is, each
element of the output array will be a concatenation of the elements of the input arrays, where
elements of i-th input array are treated as mv[i].channels()-element vectors.
<p>
The function cv::split does the reverse operation. If you need to shuffle channels in some other
advanced way, use cv::mixChannels.
<p>
The following example shows how to merge 3 single channel matrices into a single 3-channel matrix.
\snippet snippets/core_merge.cpp example
<p>
@param mv input array of matrices to be merged; all the matrices in mv must have the same
size and the same depth.
@param count number of input matrices when mv is a plain C array; it must be greater than zero.
@param dst output array of the same size and the same depth as mv[0]; The number of channels will
be equal to the parameter count.
@see  mixChannels, split, Mat::reshape
*/
@Namespace("cv") public static native void merge(@Const Mat mv, @Cast("size_t") long count, @ByVal Mat dst);
@Namespace("cv") public static native void merge(@Const Mat mv, @Cast("size_t") long count, @ByVal UMat dst);
@Namespace("cv") public static native void merge(@Const Mat mv, @Cast("size_t") long count, @ByVal GpuMat dst);

/** \overload
@param mv input vector of matrices to be merged; all the matrices in mv must have the same
size and the same depth.
@param dst output array of the same size and the same depth as mv[0]; The number of channels will
be the total number of channels in the matrix array.
  */
@Namespace("cv") public static native void merge(@ByVal MatVector mv, @ByVal Mat dst);
@Namespace("cv") public static native void merge(@ByVal UMatVector mv, @ByVal Mat dst);
@Namespace("cv") public static native void merge(@ByVal GpuMatVector mv, @ByVal Mat dst);
@Namespace("cv") public static native void merge(@ByVal MatVector mv, @ByVal UMat dst);
@Namespace("cv") public static native void merge(@ByVal UMatVector mv, @ByVal UMat dst);
@Namespace("cv") public static native void merge(@ByVal GpuMatVector mv, @ByVal UMat dst);
@Namespace("cv") public static native void merge(@ByVal MatVector mv, @ByVal GpuMat dst);
@Namespace("cv") public static native void merge(@ByVal UMatVector mv, @ByVal GpuMat dst);
@Namespace("cv") public static native void merge(@ByVal GpuMatVector mv, @ByVal GpuMat dst);

/** \brief Divides a multi-channel array into several single-channel arrays.
<p>
The function cv::split splits a multi-channel array into separate single-channel arrays:
<pre>{@code \[\texttt{mv} [c](I) =  \texttt{src} (I)_c\]}</pre>
If you need to extract a single channel or do some other sophisticated channel permutation, use
mixChannels .
<p>
The following example demonstrates how to split a 3-channel matrix into 3 single channel matrices.
\snippet snippets/core_split.cpp example
<p>
@param src input multi-channel array.
@param mvbegin output array; the number of arrays must match src.channels(); the arrays themselves are
reallocated, if needed.
@see merge, mixChannels, cvtColor
*/
@Namespace("cv") public static native void split(@Const @ByRef Mat src, Mat mvbegin);

/** \overload
@param m input multi-channel array.
@param mv output vector of arrays; the arrays themselves are reallocated, if needed.
*/
@Namespace("cv") public static native void split(@ByVal Mat m, @ByVal MatVector mv);
@Namespace("cv") public static native void split(@ByVal Mat m, @ByVal UMatVector mv);
@Namespace("cv") public static native void split(@ByVal Mat m, @ByVal GpuMatVector mv);
@Namespace("cv") public static native void split(@ByVal UMat m, @ByVal MatVector mv);
@Namespace("cv") public static native void split(@ByVal UMat m, @ByVal UMatVector mv);
@Namespace("cv") public static native void split(@ByVal UMat m, @ByVal GpuMatVector mv);
@Namespace("cv") public static native void split(@ByVal GpuMat m, @ByVal MatVector mv);
@Namespace("cv") public static native void split(@ByVal GpuMat m, @ByVal UMatVector mv);
@Namespace("cv") public static native void split(@ByVal GpuMat m, @ByVal GpuMatVector mv);

/** \brief Copies specified channels from input arrays to the specified channels of
output arrays.
<p>
The function cv::mixChannels provides an advanced mechanism for shuffling image channels.
<p>
cv::split,cv::merge,cv::extractChannel,cv::insertChannel and some forms of cv::cvtColor are partial cases of cv::mixChannels.
<p>
In the example below, the code splits a 4-channel BGRA image into a 3-channel BGR (with B and R
channels swapped) and a separate alpha-channel image:
<pre>{@code {.cpp}
    Mat bgra( 100, 100, CV_8UC4, Scalar(255,0,0,255) );
    Mat bgr( bgra.rows, bgra.cols, CV_8UC3 );
    Mat alpha( bgra.rows, bgra.cols, CV_8UC1 );

    // forming an array of matrices is a quite efficient operation,
    // because the matrix data is not copied, only the headers
    Mat out[] = { bgr, alpha };
    // bgra[0] -> bgr[2], bgra[1] -> bgr[1],
    // bgra[2] -> bgr[0], bgra[3] -> alpha[0]
    int from_to[] = { 0,2, 1,1, 2,0, 3,3 };
    mixChannels( &bgra, 1, out, 2, from_to, 4 );
}</pre>
\note Unlike many other new-style C++ functions in OpenCV (see the introduction section and
Mat::create ), cv::mixChannels requires the output arrays to be pre-allocated before calling the
function.
@param src input array or vector of matrices; all of the matrices must have the same size and the
same depth.
@param nsrcs number of matrices in {@code src}.
@param dst output array or vector of matrices; all the matrices **must be allocated**; their size and
depth must be the same as in {@code src[0]}.
@param ndsts number of matrices in {@code dst}.
@param fromTo array of index pairs specifying which channels are copied and where; fromTo[k\*2] is
a 0-based index of the input channel in src, fromTo[k\*2+1] is an index of the output channel in
dst; the continuous channel numbering is used: the first input image channels are indexed from 0 to
src[0].channels()-1, the second input image channels are indexed from src[0].channels() to
src[0].channels() + src[1].channels()-1, and so on, the same scheme is used for the output image
channels; as a special case, when fromTo[k\*2] is negative, the corresponding output channel is
filled with zero .
@param npairs number of index pairs in {@code fromTo}.
@see split, merge, extractChannel, insertChannel, cvtColor
*/
@Namespace("cv") public static native void mixChannels(@Const Mat src, @Cast("size_t") long nsrcs, Mat dst, @Cast("size_t") long ndsts,
                            @Const IntPointer fromTo, @Cast("size_t") long npairs);
@Namespace("cv") public static native void mixChannels(@Const Mat src, @Cast("size_t") long nsrcs, Mat dst, @Cast("size_t") long ndsts,
                            @Const IntBuffer fromTo, @Cast("size_t") long npairs);
@Namespace("cv") public static native void mixChannels(@Const Mat src, @Cast("size_t") long nsrcs, Mat dst, @Cast("size_t") long ndsts,
                            @Const int[] fromTo, @Cast("size_t") long npairs);

/** \overload
@param src input array or vector of matrices; all of the matrices must have the same size and the
same depth.
@param dst output array or vector of matrices; all the matrices **must be allocated**; their size and
depth must be the same as in src[0].
@param fromTo array of index pairs specifying which channels are copied and where; fromTo[k\*2] is
a 0-based index of the input channel in src, fromTo[k\*2+1] is an index of the output channel in
dst; the continuous channel numbering is used: the first input image channels are indexed from 0 to
src[0].channels()-1, the second input image channels are indexed from src[0].channels() to
src[0].channels() + src[1].channels()-1, and so on, the same scheme is used for the output image
channels; as a special case, when fromTo[k\*2] is negative, the corresponding output channel is
filled with zero .
@param npairs number of index pairs in fromTo.
*/
@Namespace("cv") public static native void mixChannels(@ByVal MatVector src, @ByVal MatVector dst,
                            @Const IntPointer fromTo, @Cast("size_t") long npairs);
@Namespace("cv") public static native void mixChannels(@ByVal UMatVector src, @ByVal UMatVector dst,
                            @Const IntBuffer fromTo, @Cast("size_t") long npairs);
@Namespace("cv") public static native void mixChannels(@ByVal GpuMatVector src, @ByVal GpuMatVector dst,
                            @Const int[] fromTo, @Cast("size_t") long npairs);

/** \overload
@param src input array or vector of matrices; all of the matrices must have the same size and the
same depth.
@param dst output array or vector of matrices; all the matrices **must be allocated**; their size and
depth must be the same as in src[0].
@param fromTo array of index pairs specifying which channels are copied and where; fromTo[k\*2] is
a 0-based index of the input channel in src, fromTo[k\*2+1] is an index of the output channel in
dst; the continuous channel numbering is used: the first input image channels are indexed from 0 to
src[0].channels()-1, the second input image channels are indexed from src[0].channels() to
src[0].channels() + src[1].channels()-1, and so on, the same scheme is used for the output image
channels; as a special case, when fromTo[k\*2] is negative, the corresponding output channel is
filled with zero .
*/
@Namespace("cv") public static native void mixChannels(@ByVal MatVector src, @ByVal MatVector dst,
                              @StdVector IntPointer fromTo);
@Namespace("cv") public static native void mixChannels(@ByVal UMatVector src, @ByVal UMatVector dst,
                              @StdVector IntBuffer fromTo);
@Namespace("cv") public static native void mixChannels(@ByVal GpuMatVector src, @ByVal GpuMatVector dst,
                              @StdVector int[] fromTo);

/** \brief Extracts a single channel from src (coi is 0-based index)
@param src input array
@param dst output array
@param coi index of channel to extract
@see mixChannels, split
*/
@Namespace("cv") public static native void extractChannel(@ByVal Mat src, @ByVal Mat dst, int coi);
@Namespace("cv") public static native void extractChannel(@ByVal UMat src, @ByVal UMat dst, int coi);
@Namespace("cv") public static native void extractChannel(@ByVal GpuMat src, @ByVal GpuMat dst, int coi);

/** \brief Inserts a single channel to dst (coi is 0-based index)
@param src input array
@param dst output array
@param coi index of channel for insertion
@see mixChannels, merge
*/
@Namespace("cv") public static native void insertChannel(@ByVal Mat src, @ByVal Mat dst, int coi);
@Namespace("cv") public static native void insertChannel(@ByVal UMat src, @ByVal UMat dst, int coi);
@Namespace("cv") public static native void insertChannel(@ByVal GpuMat src, @ByVal GpuMat dst, int coi);

/** \brief Flips a 2D array around vertical, horizontal, or both axes.
<p>
The function cv::flip flips the array in one of three different ways (row
and column indices are 0-based):
<pre>{@code \[\texttt{dst} _{ij} =
\left\{
\begin{array}{l l}
\texttt{src} _{\texttt{src.rows}-i-1,j} & if\;  \texttt{flipCode} = 0 \\
\texttt{src} _{i, \texttt{src.cols} -j-1} & if\;  \texttt{flipCode} > 0 \\
\texttt{src} _{ \texttt{src.rows} -i-1, \texttt{src.cols} -j-1} & if\; \texttt{flipCode} < 0 \\
\end{array}
\right.\]}</pre>
The example scenarios of using the function are the following:
*   Vertical flipping of the image (flipCode == 0) to switch between
    top-left and bottom-left image origin. This is a typical operation
    in video processing on Microsoft Windows\* OS.
*   Horizontal flipping of the image with the subsequent horizontal
    shift and absolute difference calculation to check for a
    vertical-axis symmetry (flipCode \> 0).
*   Simultaneous horizontal and vertical flipping of the image with
    the subsequent shift and absolute difference calculation to check
    for a central symmetry (flipCode \< 0).
*   Reversing the order of point arrays (flipCode \> 0 or
    flipCode == 0).
@param src input array.
@param dst output array of the same size and type as src.
@param flipCode a flag to specify how to flip the array; 0 means
flipping around the x-axis and positive value (for example, 1) means
flipping around y-axis. Negative value (for example, -1) means flipping
around both axes.
@see transpose , repeat , completeSymm
*/
@Namespace("cv") public static native void flip(@ByVal Mat src, @ByVal Mat dst, int flipCode);
@Namespace("cv") public static native void flip(@ByVal UMat src, @ByVal UMat dst, int flipCode);
@Namespace("cv") public static native void flip(@ByVal GpuMat src, @ByVal GpuMat dst, int flipCode);

/** \brief Flips a n-dimensional at given axis
 *  @param src input array
 *  @param dst output array that has the same shape of src
 *  @param axis axis that performs a flip on. 0 <= axis < src.dims.
 */
@Namespace("cv") public static native void flipND(@ByVal Mat src, @ByVal Mat dst, int axis);
@Namespace("cv") public static native void flipND(@ByVal UMat src, @ByVal UMat dst, int axis);
@Namespace("cv") public static native void flipND(@ByVal GpuMat src, @ByVal GpuMat dst, int axis);

/** \brief Broadcast the given Mat to the given shape.
 * @param src input array
 * @param shape target shape. Should be a list of CV_32S numbers. Note that negative values are not supported.
 * @param dst output array that has the given shape
 */
@Namespace("cv") public static native void broadcast(@ByVal Mat src, @ByVal Mat shape, @ByVal Mat dst);
@Namespace("cv") public static native void broadcast(@ByVal UMat src, @ByVal UMat shape, @ByVal UMat dst);
@Namespace("cv") public static native void broadcast(@ByVal GpuMat src, @ByVal GpuMat shape, @ByVal GpuMat dst);

/** enum cv::RotateFlags */
public static final int
    /**Rotate 90 degrees clockwise */
    ROTATE_90_CLOCKWISE = 0,
    /**Rotate 180 degrees clockwise */
    ROTATE_180 = 1,
    /**Rotate 270 degrees clockwise */
    ROTATE_90_COUNTERCLOCKWISE = 2;
/** \brief Rotates a 2D array in multiples of 90 degrees.
The function cv::rotate rotates the array in one of three different ways:
*   Rotate by 90 degrees clockwise (rotateCode = ROTATE_90_CLOCKWISE).
*   Rotate by 180 degrees clockwise (rotateCode = ROTATE_180).
*   Rotate by 270 degrees clockwise (rotateCode = ROTATE_90_COUNTERCLOCKWISE).
@param src input array.
@param dst output array of the same type as src.  The size is the same with ROTATE_180,
and the rows and cols are switched for ROTATE_90_CLOCKWISE and ROTATE_90_COUNTERCLOCKWISE.
@param rotateCode an enum to specify how to rotate the array; see the enum #RotateFlags
@see transpose , repeat , completeSymm, flip, RotateFlags
*/
@Namespace("cv") public static native void rotate(@ByVal Mat src, @ByVal Mat dst, int rotateCode);
@Namespace("cv") public static native void rotate(@ByVal UMat src, @ByVal UMat dst, int rotateCode);
@Namespace("cv") public static native void rotate(@ByVal GpuMat src, @ByVal GpuMat dst, int rotateCode);

/** \brief Fills the output array with repeated copies of the input array.
<p>
The function cv::repeat duplicates the input array one or more times along each of the two axes:
<pre>{@code \[\texttt{dst} _{ij}= \texttt{src} _{i\mod src.rows, \; j\mod src.cols }\]}</pre>
The second variant of the function is more convenient to use with \ref MatrixExpressions.
@param src input array to replicate.
@param ny Flag to specify how many times the {@code src} is repeated along the
vertical axis.
@param nx Flag to specify how many times the {@code src} is repeated along the
horizontal axis.
@param dst output array of the same type as {@code src}.
@see cv::reduce
*/
@Namespace("cv") public static native void repeat(@ByVal Mat src, int ny, int nx, @ByVal Mat dst);
@Namespace("cv") public static native void repeat(@ByVal UMat src, int ny, int nx, @ByVal UMat dst);
@Namespace("cv") public static native void repeat(@ByVal GpuMat src, int ny, int nx, @ByVal GpuMat dst);

/** \overload
@param src input array to replicate.
@param ny Flag to specify how many times the {@code src} is repeated along the
vertical axis.
@param nx Flag to specify how many times the {@code src} is repeated along the
horizontal axis.
  */
@Namespace("cv") public static native @ByVal Mat repeat(@Const @ByRef Mat src, int ny, int nx);

/** \brief Applies horizontal concatenation to given matrices.
<p>
The function horizontally concatenates two or more cv::Mat matrices (with the same number of rows).
<pre>{@code {.cpp}
    cv::Mat matArray[] = { cv::Mat(4, 1, CV_8UC1, cv::Scalar(1)),
                           cv::Mat(4, 1, CV_8UC1, cv::Scalar(2)),
                           cv::Mat(4, 1, CV_8UC1, cv::Scalar(3)),};

    cv::Mat out;
    cv::hconcat( matArray, 3, out );
    //out:
    //[1, 2, 3;
    // 1, 2, 3;
    // 1, 2, 3;
    // 1, 2, 3]
}</pre>
@param src input array or vector of matrices. all of the matrices must have the same number of rows and the same depth.
@param nsrc number of matrices in src.
@param dst output array. It has the same number of rows and depth as the src, and the sum of cols of the src.
@see cv::vconcat(const Mat*, size_t, OutputArray), @see cv::vconcat(InputArrayOfArrays, OutputArray) and @see cv::vconcat(InputArray, InputArray, OutputArray)
*/
@Namespace("cv") public static native void hconcat(@Const Mat src, @Cast("size_t") long nsrc, @ByVal Mat dst);
@Namespace("cv") public static native void hconcat(@Const Mat src, @Cast("size_t") long nsrc, @ByVal UMat dst);
@Namespace("cv") public static native void hconcat(@Const Mat src, @Cast("size_t") long nsrc, @ByVal GpuMat dst);
/** \overload
 <pre>{@code {.cpp}
    cv::Mat_<float> A = (cv::Mat_<float>(3, 2) << 1, 4,
                                                  2, 5,
                                                  3, 6);
    cv::Mat_<float> B = (cv::Mat_<float>(3, 2) << 7, 10,
                                                  8, 11,
                                                  9, 12);

    cv::Mat C;
    cv::hconcat(A, B, C);
    //C:
    //[1, 4, 7, 10;
    // 2, 5, 8, 11;
    // 3, 6, 9, 12]
 }</pre>
 @param src1 first input array to be considered for horizontal concatenation.
 @param src2 second input array to be considered for horizontal concatenation.
 @param dst output array. It has the same number of rows and depth as the src1 and src2, and the sum of cols of the src1 and src2.
 */
@Namespace("cv") public static native void hconcat(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv") public static native void hconcat(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv") public static native void hconcat(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);
/** \overload
 <pre>{@code {.cpp}
    std::vector<cv::Mat> matrices = { cv::Mat(4, 1, CV_8UC1, cv::Scalar(1)),
                                      cv::Mat(4, 1, CV_8UC1, cv::Scalar(2)),
                                      cv::Mat(4, 1, CV_8UC1, cv::Scalar(3)),};

    cv::Mat out;
    cv::hconcat( matrices, out );
    //out:
    //[1, 2, 3;
    // 1, 2, 3;
    // 1, 2, 3;
    // 1, 2, 3]
 }</pre>
 @param src input array or vector of matrices. all of the matrices must have the same number of rows and the same depth.
 @param dst output array. It has the same number of rows and depth as the src, and the sum of cols of the src.
same depth.
 */
@Namespace("cv") public static native void hconcat(@ByVal MatVector src, @ByVal Mat dst);
@Namespace("cv") public static native void hconcat(@ByVal UMatVector src, @ByVal Mat dst);
@Namespace("cv") public static native void hconcat(@ByVal GpuMatVector src, @ByVal Mat dst);
@Namespace("cv") public static native void hconcat(@ByVal MatVector src, @ByVal UMat dst);
@Namespace("cv") public static native void hconcat(@ByVal UMatVector src, @ByVal UMat dst);
@Namespace("cv") public static native void hconcat(@ByVal GpuMatVector src, @ByVal UMat dst);
@Namespace("cv") public static native void hconcat(@ByVal MatVector src, @ByVal GpuMat dst);
@Namespace("cv") public static native void hconcat(@ByVal UMatVector src, @ByVal GpuMat dst);
@Namespace("cv") public static native void hconcat(@ByVal GpuMatVector src, @ByVal GpuMat dst);

/** \brief Applies vertical concatenation to given matrices.
<p>
The function vertically concatenates two or more cv::Mat matrices (with the same number of cols).
<pre>{@code {.cpp}
    cv::Mat matArray[] = { cv::Mat(1, 4, CV_8UC1, cv::Scalar(1)),
                           cv::Mat(1, 4, CV_8UC1, cv::Scalar(2)),
                           cv::Mat(1, 4, CV_8UC1, cv::Scalar(3)),};

    cv::Mat out;
    cv::vconcat( matArray, 3, out );
    //out:
    //[1,   1,   1,   1;
    // 2,   2,   2,   2;
    // 3,   3,   3,   3]
}</pre>
@param src input array or vector of matrices. all of the matrices must have the same number of cols and the same depth.
@param nsrc number of matrices in src.
@param dst output array. It has the same number of cols and depth as the src, and the sum of rows of the src.
@see cv::hconcat(const Mat*, size_t, OutputArray), @see cv::hconcat(InputArrayOfArrays, OutputArray) and @see cv::hconcat(InputArray, InputArray, OutputArray)
*/
@Namespace("cv") public static native void vconcat(@Const Mat src, @Cast("size_t") long nsrc, @ByVal Mat dst);
@Namespace("cv") public static native void vconcat(@Const Mat src, @Cast("size_t") long nsrc, @ByVal UMat dst);
@Namespace("cv") public static native void vconcat(@Const Mat src, @Cast("size_t") long nsrc, @ByVal GpuMat dst);
/** \overload
 <pre>{@code {.cpp}
    cv::Mat_<float> A = (cv::Mat_<float>(3, 2) << 1, 7,
                                                  2, 8,
                                                  3, 9);
    cv::Mat_<float> B = (cv::Mat_<float>(3, 2) << 4, 10,
                                                  5, 11,
                                                  6, 12);

    cv::Mat C;
    cv::vconcat(A, B, C);
    //C:
    //[1, 7;
    // 2, 8;
    // 3, 9;
    // 4, 10;
    // 5, 11;
    // 6, 12]
 }</pre>
 @param src1 first input array to be considered for vertical concatenation.
 @param src2 second input array to be considered for vertical concatenation.
 @param dst output array. It has the same number of cols and depth as the src1 and src2, and the sum of rows of the src1 and src2.
 */
@Namespace("cv") public static native void vconcat(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv") public static native void vconcat(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv") public static native void vconcat(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);
/** \overload
 <pre>{@code {.cpp}
    std::vector<cv::Mat> matrices = { cv::Mat(1, 4, CV_8UC1, cv::Scalar(1)),
                                      cv::Mat(1, 4, CV_8UC1, cv::Scalar(2)),
                                      cv::Mat(1, 4, CV_8UC1, cv::Scalar(3)),};

    cv::Mat out;
    cv::vconcat( matrices, out );
    //out:
    //[1,   1,   1,   1;
    // 2,   2,   2,   2;
    // 3,   3,   3,   3]
 }</pre>
 @param src input array or vector of matrices. all of the matrices must have the same number of cols and the same depth
 @param dst output array. It has the same number of cols and depth as the src, and the sum of rows of the src.
same depth.
 */
@Namespace("cv") public static native void vconcat(@ByVal MatVector src, @ByVal Mat dst);
@Namespace("cv") public static native void vconcat(@ByVal UMatVector src, @ByVal Mat dst);
@Namespace("cv") public static native void vconcat(@ByVal GpuMatVector src, @ByVal Mat dst);
@Namespace("cv") public static native void vconcat(@ByVal MatVector src, @ByVal UMat dst);
@Namespace("cv") public static native void vconcat(@ByVal UMatVector src, @ByVal UMat dst);
@Namespace("cv") public static native void vconcat(@ByVal GpuMatVector src, @ByVal UMat dst);
@Namespace("cv") public static native void vconcat(@ByVal MatVector src, @ByVal GpuMat dst);
@Namespace("cv") public static native void vconcat(@ByVal UMatVector src, @ByVal GpuMat dst);
@Namespace("cv") public static native void vconcat(@ByVal GpuMatVector src, @ByVal GpuMat dst);

/** \brief computes bitwise conjunction of the two arrays (dst = src1 & src2)
Calculates the per-element bit-wise conjunction of two arrays or an
array and a scalar.
<p>
The function cv::bitwise_and calculates the per-element bit-wise logical conjunction for:
*   Two arrays when src1 and src2 have the same size:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1} (I)  \wedge \texttt{src2} (I) \quad \texttt{if mask} (I) \ne0\]}</pre>
*   An array and a scalar when src2 is constructed from Scalar or has
    the same number of elements as {@code src1.channels()}:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1} (I)  \wedge \texttt{src2} \quad \texttt{if mask} (I) \ne0\]}</pre>
*   A scalar and an array when src1 is constructed from Scalar or has
    the same number of elements as {@code src2.channels()}:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1}  \wedge \texttt{src2} (I) \quad \texttt{if mask} (I) \ne0\]}</pre>
In case of floating-point arrays, their machine-specific bit
representations (usually IEEE754-compliant) are used for the operation.
In case of multi-channel arrays, each channel is processed
independently. In the second and third cases above, the scalar is first
converted to the array type.
@param src1 first input array or a scalar.
@param src2 second input array or a scalar.
@param dst output array that has the same size and type as the input
arrays.
@param mask optional operation mask, 8-bit single channel array, that
specifies elements of the output array to be changed.
*/
@Namespace("cv") public static native void bitwise_and(@ByVal Mat src1, @ByVal Mat src2,
                              @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void bitwise_and(@ByVal Mat src1, @ByVal Mat src2,
                              @ByVal Mat dst);
@Namespace("cv") public static native void bitwise_and(@ByVal UMat src1, @ByVal UMat src2,
                              @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void bitwise_and(@ByVal UMat src1, @ByVal UMat src2,
                              @ByVal UMat dst);
@Namespace("cv") public static native void bitwise_and(@ByVal GpuMat src1, @ByVal GpuMat src2,
                              @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void bitwise_and(@ByVal GpuMat src1, @ByVal GpuMat src2,
                              @ByVal GpuMat dst);

/** \brief Calculates the per-element bit-wise disjunction of two arrays or an
array and a scalar.
<p>
The function cv::bitwise_or calculates the per-element bit-wise logical disjunction for:
*   Two arrays when src1 and src2 have the same size:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1} (I)  \vee \texttt{src2} (I) \quad \texttt{if mask} (I) \ne0\]}</pre>
*   An array and a scalar when src2 is constructed from Scalar or has
    the same number of elements as {@code src1.channels()}:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1} (I)  \vee \texttt{src2} \quad \texttt{if mask} (I) \ne0\]}</pre>
*   A scalar and an array when src1 is constructed from Scalar or has
    the same number of elements as {@code src2.channels()}:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1}  \vee \texttt{src2} (I) \quad \texttt{if mask} (I) \ne0\]}</pre>
In case of floating-point arrays, their machine-specific bit
representations (usually IEEE754-compliant) are used for the operation.
In case of multi-channel arrays, each channel is processed
independently. In the second and third cases above, the scalar is first
converted to the array type.
@param src1 first input array or a scalar.
@param src2 second input array or a scalar.
@param dst output array that has the same size and type as the input
arrays.
@param mask optional operation mask, 8-bit single channel array, that
specifies elements of the output array to be changed.
*/
@Namespace("cv") public static native void bitwise_or(@ByVal Mat src1, @ByVal Mat src2,
                             @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void bitwise_or(@ByVal Mat src1, @ByVal Mat src2,
                             @ByVal Mat dst);
@Namespace("cv") public static native void bitwise_or(@ByVal UMat src1, @ByVal UMat src2,
                             @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void bitwise_or(@ByVal UMat src1, @ByVal UMat src2,
                             @ByVal UMat dst);
@Namespace("cv") public static native void bitwise_or(@ByVal GpuMat src1, @ByVal GpuMat src2,
                             @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void bitwise_or(@ByVal GpuMat src1, @ByVal GpuMat src2,
                             @ByVal GpuMat dst);

/** \brief Calculates the per-element bit-wise "exclusive or" operation on two
arrays or an array and a scalar.
<p>
The function cv::bitwise_xor calculates the per-element bit-wise logical "exclusive-or"
operation for:
*   Two arrays when src1 and src2 have the same size:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1} (I)  \oplus \texttt{src2} (I) \quad \texttt{if mask} (I) \ne0\]}</pre>
*   An array and a scalar when src2 is constructed from Scalar or has
    the same number of elements as {@code src1.channels()}:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1} (I)  \oplus \texttt{src2} \quad \texttt{if mask} (I) \ne0\]}</pre>
*   A scalar and an array when src1 is constructed from Scalar or has
    the same number of elements as {@code src2.channels()}:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1}  \oplus \texttt{src2} (I) \quad \texttt{if mask} (I) \ne0\]}</pre>
In case of floating-point arrays, their machine-specific bit
representations (usually IEEE754-compliant) are used for the operation.
In case of multi-channel arrays, each channel is processed
independently. In the 2nd and 3rd cases above, the scalar is first
converted to the array type.
@param src1 first input array or a scalar.
@param src2 second input array or a scalar.
@param dst output array that has the same size and type as the input
arrays.
@param mask optional operation mask, 8-bit single channel array, that
specifies elements of the output array to be changed.
*/
@Namespace("cv") public static native void bitwise_xor(@ByVal Mat src1, @ByVal Mat src2,
                              @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void bitwise_xor(@ByVal Mat src1, @ByVal Mat src2,
                              @ByVal Mat dst);
@Namespace("cv") public static native void bitwise_xor(@ByVal UMat src1, @ByVal UMat src2,
                              @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void bitwise_xor(@ByVal UMat src1, @ByVal UMat src2,
                              @ByVal UMat dst);
@Namespace("cv") public static native void bitwise_xor(@ByVal GpuMat src1, @ByVal GpuMat src2,
                              @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void bitwise_xor(@ByVal GpuMat src1, @ByVal GpuMat src2,
                              @ByVal GpuMat dst);

/** \brief  Inverts every bit of an array.
<p>
The function cv::bitwise_not calculates per-element bit-wise inversion of the input
array:
<pre>{@code \[\texttt{dst} (I) =  \neg \texttt{src} (I)\]}</pre>
In case of a floating-point input array, its machine-specific bit
representation (usually IEEE754-compliant) is used for the operation. In
case of multi-channel arrays, each channel is processed independently.
@param src input array.
@param dst output array that has the same size and type as the input
array.
@param mask optional operation mask, 8-bit single channel array, that
specifies elements of the output array to be changed.
*/
@Namespace("cv") public static native void bitwise_not(@ByVal Mat src, @ByVal Mat dst,
                              @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv") public static native void bitwise_not(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void bitwise_not(@ByVal UMat src, @ByVal UMat dst,
                              @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv") public static native void bitwise_not(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void bitwise_not(@ByVal GpuMat src, @ByVal GpuMat dst,
                              @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv") public static native void bitwise_not(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Calculates the per-element absolute difference between two arrays or between an array and a scalar.
<p>
The function cv::absdiff calculates:
*   Absolute difference between two arrays when they have the same
    size and type:
    <pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} (| \texttt{src1}(I) -  \texttt{src2}(I)|)\]}</pre>
*   Absolute difference between an array and a scalar when the second
    array is constructed from Scalar or has as many elements as the
    number of channels in {@code src1}:
    <pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} (| \texttt{src1}(I) -  \texttt{src2} |)\]}</pre>
*   Absolute difference between a scalar and an array when the first
    array is constructed from Scalar or has as many elements as the
    number of channels in {@code src2}:
    <pre>{@code \[\texttt{dst}(I) =  \texttt{saturate} (| \texttt{src1} -  \texttt{src2}(I) |)\]}</pre>
    where I is a multi-dimensional index of array elements. In case of
    multi-channel arrays, each channel is processed independently.
\note Saturation is not applied when the arrays have the depth CV_32S.
You may even get a negative value in the case of overflow.
\note (Python) Be careful to difference behaviour between src1/src2 are single number and they are tuple/array.
{@code absdiff(src,X)} means {@code absdiff(src,(X,X,X,X))}.
{@code absdiff(src,(X,))} means {@code absdiff(src,(X,0,0,0))}.
@param src1 first input array or a scalar.
@param src2 second input array or a scalar.
@param dst output array that has the same size and type as input arrays.
@see cv::abs(const Mat&)
*/
@Namespace("cv") public static native void absdiff(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv") public static native void absdiff(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv") public static native void absdiff(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief  This is an overloaded member function, provided for convenience (python)
Copies the matrix to another one.
When the operation mask is specified, if the Mat::create call shown above reallocates the matrix, the newly allocated matrix is initialized with all zeros before copying the data.
@param src source matrix.
@param dst Destination matrix. If it does not have a proper size or type before the operation, it is
reallocated.
@param mask Operation mask of the same size as \*this. Its non-zero elements indicate which matrix
elements need to be copied. The mask has to be of type CV_8U and can have 1 or multiple channels.
*/

@Namespace("cv") public static native void copyTo(@ByVal Mat src, @ByVal Mat dst, @ByVal Mat mask);
@Namespace("cv") public static native void copyTo(@ByVal UMat src, @ByVal UMat dst, @ByVal UMat mask);
@Namespace("cv") public static native void copyTo(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal GpuMat mask);
/** \brief  Checks if array elements lie between the elements of two other arrays.
<p>
The function checks the range as follows:
-   For every element of a single-channel input array:
    <pre>{@code \[\texttt{dst} (I)= \texttt{lowerb} (I)_0  \leq \texttt{src} (I)_0 \leq  \texttt{upperb} (I)_0\]}</pre>
-   For two-channel arrays:
    <pre>{@code \[\texttt{dst} (I)= \texttt{lowerb} (I)_0  \leq \texttt{src} (I)_0 \leq  \texttt{upperb} (I)_0  \land \texttt{lowerb} (I)_1  \leq \texttt{src} (I)_1 \leq  \texttt{upperb} (I)_1\]}</pre>
-   and so forth.
<p>
That is, dst (I) is set to 255 (all 1 -bits) if src (I) is within the
specified 1D, 2D, 3D, ... box and 0 otherwise.
<p>
When the lower and/or upper boundary parameters are scalars, the indexes
(I) at lowerb and upperb in the above formulas should be omitted.
@param src first input array.
@param lowerb inclusive lower boundary array or a scalar.
@param upperb inclusive upper boundary array or a scalar.
@param dst output array of the same size as src and CV_8U type.
*/
@Namespace("cv") public static native void inRange(@ByVal Mat src, @ByVal Mat lowerb,
                          @ByVal Mat upperb, @ByVal Mat dst);
@Namespace("cv") public static native void inRange(@ByVal UMat src, @ByVal UMat lowerb,
                          @ByVal UMat upperb, @ByVal UMat dst);
@Namespace("cv") public static native void inRange(@ByVal GpuMat src, @ByVal GpuMat lowerb,
                          @ByVal GpuMat upperb, @ByVal GpuMat dst);

/** \brief Performs the per-element comparison of two arrays or an array and scalar value.
<p>
The function compares:
*   Elements of two arrays when src1 and src2 have the same size:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1} (I)  \,\texttt{cmpop}\, \texttt{src2} (I)\]}</pre>
*   Elements of src1 with a scalar src2 when src2 is constructed from
    Scalar or has a single element:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1}(I) \,\texttt{cmpop}\,  \texttt{src2}\]}</pre>
*   src1 with elements of src2 when src1 is constructed from Scalar or
    has a single element:
    <pre>{@code \[\texttt{dst} (I) =  \texttt{src1}  \,\texttt{cmpop}\, \texttt{src2} (I)\]}</pre>
When the comparison result is true, the corresponding element of output
array is set to 255. The comparison operations can be replaced with the
equivalent matrix expressions:
<pre>{@code {.cpp}
    Mat dst1 = src1 >= src2;
    Mat dst2 = src1 < 8;
    ...
}</pre>
@param src1 first input array or a scalar; when it is an array, it must have a single channel.
@param src2 second input array or a scalar; when it is an array, it must have a single channel.
@param dst output array of type ref CV_8U that has the same size and the same number of channels as
    the input arrays.
@param cmpop a flag, that specifies correspondence between the arrays (cv::CmpTypes)
@see checkRange, min, max, threshold
*/
@Namespace("cv") public static native void compare(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, int cmpop);
@Namespace("cv") public static native void compare(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, int cmpop);
@Namespace("cv") public static native void compare(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, int cmpop);

/** \brief Calculates per-element minimum of two arrays or an array and a scalar.
<p>
The function cv::min calculates the per-element minimum of two arrays:
<pre>{@code \[\texttt{dst} (I)= \min ( \texttt{src1} (I), \texttt{src2} (I))\]}</pre>
or array and a scalar:
<pre>{@code \[\texttt{dst} (I)= \min ( \texttt{src1} (I), \texttt{value} )\]}</pre>
@param src1 first input array.
@param src2 second input array of the same size and type as src1.
@param dst output array of the same size and type as src1.
@see max, compare, inRange, minMaxLoc
*/

/** \overload
needed to avoid conflicts with const _Tp& std::min(const _Tp&, const _Tp&, _Compare)
*/
@Namespace("cv") public static native void min(@Const @ByRef Mat src1, @Const @ByRef Mat src2, @ByRef Mat dst);
/** \overload
needed to avoid conflicts with const _Tp& std::min(const _Tp&, const _Tp&, _Compare)
*/
@Namespace("cv") public static native void min(@Const @ByRef UMat src1, @Const @ByRef UMat src2, @ByRef UMat dst);

/** \brief Calculates per-element maximum of two arrays or an array and a scalar.
<p>
The function cv::max calculates the per-element maximum of two arrays:
<pre>{@code \[\texttt{dst} (I)= \max ( \texttt{src1} (I), \texttt{src2} (I))\]}</pre>
or array and a scalar:
<pre>{@code \[\texttt{dst} (I)= \max ( \texttt{src1} (I), \texttt{value} )\]}</pre>
@param src1 first input array.
@param src2 second input array of the same size and type as src1 .
@param dst output array of the same size and type as src1.
@see  min, compare, inRange, minMaxLoc, \ref MatrixExpressions
*/

/** \overload
needed to avoid conflicts with const _Tp& std::min(const _Tp&, const _Tp&, _Compare)
*/
@Namespace("cv") public static native void max(@Const @ByRef Mat src1, @Const @ByRef Mat src2, @ByRef Mat dst);
/** \overload
needed to avoid conflicts with const _Tp& std::min(const _Tp&, const _Tp&, _Compare)
*/
@Namespace("cv") public static native void max(@Const @ByRef UMat src1, @Const @ByRef UMat src2, @ByRef UMat dst);

/** \brief Calculates a square root of array elements.
<p>
The function cv::sqrt calculates a square root of each input array element.
In case of multi-channel arrays, each channel is processed
independently. The accuracy is approximately the same as of the built-in
std::sqrt .
@param src input floating-point array.
@param dst output array of the same size and type as src.
*/
@Namespace("cv") public static native void sqrt(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void sqrt(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void sqrt(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Raises every array element to a power.
<p>
The function cv::pow raises every element of the input array to power :
<pre>{@code \[\texttt{dst} (I) =  \fork{\texttt{src}(I)^{power}}{if \(\texttt{power}\) is integer}{|\texttt{src}(I)|^{power}}{otherwise}\]}</pre>
<p>
So, for a non-integer power exponent, the absolute values of input array
elements are used. However, it is possible to get true values for
negative values using some extra operations. In the example below,
computing the 5th root of array src shows:
<pre>{@code {.cpp}
    Mat mask = src < 0;
    pow(src, 1./5, dst);
    subtract(Scalar::all(0), dst, dst, mask);
}</pre>
For some values of power, such as integer values, 0.5 and -0.5,
specialized faster algorithms are used.
<p>
Special values (NaN, Inf) are not handled.
@param src input array.
@param power exponent of power.
@param dst output array of the same size and type as src.
@see sqrt, exp, log, cartToPolar, polarToCart
*/
@Namespace("cv") public static native void pow(@ByVal Mat src, double power, @ByVal Mat dst);
@Namespace("cv") public static native void pow(@ByVal UMat src, double power, @ByVal UMat dst);
@Namespace("cv") public static native void pow(@ByVal GpuMat src, double power, @ByVal GpuMat dst);

/** \brief Calculates the exponent of every array element.
<p>
The function cv::exp calculates the exponent of every element of the input
array:
<pre>{@code \[\texttt{dst} [I] = e^{ src(I) }\]}</pre>
<p>
The maximum relative error is about 7e-6 for single-precision input and
less than 1e-10 for double-precision input. Currently, the function
converts denormalized values to zeros on output. Special values (NaN,
Inf) are not handled.
@param src input array.
@param dst output array of the same size and type as src.
@see log , cartToPolar , polarToCart , phase , pow , sqrt , magnitude
*/
@Namespace("cv") public static native void exp(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void exp(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void exp(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Calculates the natural logarithm of every array element.
<p>
The function cv::log calculates the natural logarithm of every element of the input array:
<pre>{@code \[\texttt{dst} (I) =  \log (\texttt{src}(I)) \]}</pre>
<p>
Output on zero, negative and special (NaN, Inf) values is undefined.
<p>
@param src input array.
@param dst output array of the same size and type as src .
@see exp, cartToPolar, polarToCart, phase, pow, sqrt, magnitude
*/
@Namespace("cv") public static native void log(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void log(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void log(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Calculates x and y coordinates of 2D vectors from their magnitude and angle.
<p>
The function cv::polarToCart calculates the Cartesian coordinates of each 2D
vector represented by the corresponding elements of magnitude and angle:
<pre>{@code \[\begin{array}{l} \texttt{x} (I) =  \texttt{magnitude} (I) \cos ( \texttt{angle} (I)) \\ \texttt{y} (I) =  \texttt{magnitude} (I) \sin ( \texttt{angle} (I)) \\ \end{array}\]}</pre>
<p>
The relative accuracy of the estimated coordinates is about 1e-6.
@param magnitude input floating-point array of magnitudes of 2D vectors;
it can be an empty matrix (=Mat()), in this case, the function assumes
that all the magnitudes are =1; if it is not empty, it must have the
same size and type as angle.
@param angle input floating-point array of angles of 2D vectors.
@param x output array of x-coordinates of 2D vectors; it has the same
size and type as angle.
@param y output array of y-coordinates of 2D vectors; it has the same
size and type as angle.
@param angleInDegrees when true, the input angles are measured in
degrees, otherwise, they are measured in radians.
@see cartToPolar, magnitude, phase, exp, log, pow, sqrt
*/
@Namespace("cv") public static native void polarToCart(@ByVal Mat magnitude, @ByVal Mat angle,
                              @ByVal Mat x, @ByVal Mat y, @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void polarToCart(@ByVal Mat magnitude, @ByVal Mat angle,
                              @ByVal Mat x, @ByVal Mat y);
@Namespace("cv") public static native void polarToCart(@ByVal UMat magnitude, @ByVal UMat angle,
                              @ByVal UMat x, @ByVal UMat y, @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void polarToCart(@ByVal UMat magnitude, @ByVal UMat angle,
                              @ByVal UMat x, @ByVal UMat y);
@Namespace("cv") public static native void polarToCart(@ByVal GpuMat magnitude, @ByVal GpuMat angle,
                              @ByVal GpuMat x, @ByVal GpuMat y, @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void polarToCart(@ByVal GpuMat magnitude, @ByVal GpuMat angle,
                              @ByVal GpuMat x, @ByVal GpuMat y);

/** \brief Calculates the magnitude and angle of 2D vectors.
<p>
The function cv::cartToPolar calculates either the magnitude, angle, or both
for every 2D vector (x(I),y(I)):
<pre>{@code \[\begin{array}{l} \texttt{magnitude} (I)= \sqrt{\texttt{x}(I)^2+\texttt{y}(I)^2} , \\ \texttt{angle} (I)= \texttt{atan2} ( \texttt{y} (I), \texttt{x} (I))[ \cdot180 / \pi ] \end{array}\]}</pre>
<p>
The angles are calculated with accuracy about 0.3 degrees. For the point
(0,0), the angle is set to 0.
@param x array of x-coordinates; this must be a single-precision or
double-precision floating-point array.
@param y array of y-coordinates, that must have the same size and same type as x.
@param magnitude output array of magnitudes of the same size and type as x.
@param angle output array of angles that has the same size and type as
x; the angles are measured in radians (from 0 to 2\*Pi) or in degrees (0 to 360 degrees).
@param angleInDegrees a flag, indicating whether the angles are measured
in radians (which is by default), or in degrees.
@see Sobel, Scharr
*/
@Namespace("cv") public static native void cartToPolar(@ByVal Mat x, @ByVal Mat y,
                              @ByVal Mat magnitude, @ByVal Mat angle,
                              @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void cartToPolar(@ByVal Mat x, @ByVal Mat y,
                              @ByVal Mat magnitude, @ByVal Mat angle);
@Namespace("cv") public static native void cartToPolar(@ByVal UMat x, @ByVal UMat y,
                              @ByVal UMat magnitude, @ByVal UMat angle,
                              @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void cartToPolar(@ByVal UMat x, @ByVal UMat y,
                              @ByVal UMat magnitude, @ByVal UMat angle);
@Namespace("cv") public static native void cartToPolar(@ByVal GpuMat x, @ByVal GpuMat y,
                              @ByVal GpuMat magnitude, @ByVal GpuMat angle,
                              @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void cartToPolar(@ByVal GpuMat x, @ByVal GpuMat y,
                              @ByVal GpuMat magnitude, @ByVal GpuMat angle);

/** \brief Calculates the rotation angle of 2D vectors.
<p>
The function cv::phase calculates the rotation angle of each 2D vector that
is formed from the corresponding elements of x and y :
<pre>{@code \[\texttt{angle} (I) =  \texttt{atan2} ( \texttt{y} (I), \texttt{x} (I))\]}</pre>
<p>
The angle estimation accuracy is about 0.3 degrees. When x(I)=y(I)=0 ,
the corresponding angle(I) is set to 0.
@param x input floating-point array of x-coordinates of 2D vectors.
@param y input array of y-coordinates of 2D vectors; it must have the
same size and the same type as x.
@param angle output array of vector angles; it has the same size and
same type as x .
@param angleInDegrees when true, the function calculates the angle in
degrees, otherwise, they are measured in radians.
*/
@Namespace("cv") public static native void phase(@ByVal Mat x, @ByVal Mat y, @ByVal Mat angle,
                        @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void phase(@ByVal Mat x, @ByVal Mat y, @ByVal Mat angle);
@Namespace("cv") public static native void phase(@ByVal UMat x, @ByVal UMat y, @ByVal UMat angle,
                        @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void phase(@ByVal UMat x, @ByVal UMat y, @ByVal UMat angle);
@Namespace("cv") public static native void phase(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat angle,
                        @Cast("bool") boolean angleInDegrees/*=false*/);
@Namespace("cv") public static native void phase(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat angle);

/** \brief Calculates the magnitude of 2D vectors.
<p>
The function cv::magnitude calculates the magnitude of 2D vectors formed
from the corresponding elements of x and y arrays:
<pre>{@code \[\texttt{dst} (I) =  \sqrt{\texttt{x}(I)^2 + \texttt{y}(I)^2}\]}</pre>
@param x floating-point array of x-coordinates of the vectors.
@param y floating-point array of y-coordinates of the vectors; it must
have the same size as x.
@param magnitude output array of the same size and type as x.
@see cartToPolar, polarToCart, phase, sqrt
*/
@Namespace("cv") public static native void magnitude(@ByVal Mat x, @ByVal Mat y, @ByVal Mat magnitude);
@Namespace("cv") public static native void magnitude(@ByVal UMat x, @ByVal UMat y, @ByVal UMat magnitude);
@Namespace("cv") public static native void magnitude(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat magnitude);

/** \brief Checks every element of an input array for invalid values.
<p>
The function cv::checkRange checks that every array element is neither NaN nor infinite. When minVal \>
-DBL_MAX and maxVal \< DBL_MAX, the function also checks that each value is between minVal and
maxVal. In case of multi-channel arrays, each channel is processed independently. If some values
are out of range, position of the first outlier is stored in pos (when pos != NULL). Then, the
function either returns false (when quiet=true) or throws an exception.
@param a input array.
@param quiet a flag, indicating whether the functions quietly return false when the array elements
are out of range or they throw an exception.
@param pos optional output parameter, when not NULL, must be a pointer to array of src.dims
elements.
@param minVal inclusive lower boundary of valid values range.
@param maxVal exclusive upper boundary of valid values range.
*/
@Namespace("cv") public static native @Cast("bool") boolean checkRange(@ByVal Mat a, @Cast("bool") boolean quiet/*=true*/, Point pos/*=0*/,
                            double minVal/*=-DBL_MAX*/, double maxVal/*=DBL_MAX*/);
@Namespace("cv") public static native @Cast("bool") boolean checkRange(@ByVal Mat a);
@Namespace("cv") public static native @Cast("bool") boolean checkRange(@ByVal UMat a, @Cast("bool") boolean quiet/*=true*/, Point pos/*=0*/,
                            double minVal/*=-DBL_MAX*/, double maxVal/*=DBL_MAX*/);
@Namespace("cv") public static native @Cast("bool") boolean checkRange(@ByVal UMat a);
@Namespace("cv") public static native @Cast("bool") boolean checkRange(@ByVal GpuMat a, @Cast("bool") boolean quiet/*=true*/, Point pos/*=0*/,
                            double minVal/*=-DBL_MAX*/, double maxVal/*=DBL_MAX*/);
@Namespace("cv") public static native @Cast("bool") boolean checkRange(@ByVal GpuMat a);

/** \brief Replaces NaNs by given number
@param a input/output matrix (CV_32F type).
@param val value to convert the NaNs
*/
@Namespace("cv") public static native void patchNaNs(@ByVal Mat a, double val/*=0*/);
@Namespace("cv") public static native void patchNaNs(@ByVal Mat a);
@Namespace("cv") public static native void patchNaNs(@ByVal UMat a, double val/*=0*/);
@Namespace("cv") public static native void patchNaNs(@ByVal UMat a);
@Namespace("cv") public static native void patchNaNs(@ByVal GpuMat a, double val/*=0*/);
@Namespace("cv") public static native void patchNaNs(@ByVal GpuMat a);

/** \brief Performs generalized matrix multiplication.
<p>
The function cv::gemm performs generalized matrix multiplication similar to the
gemm functions in BLAS level 3. For example,
{@code gemm(src1, src2, alpha, src3, beta, dst, GEMM_1_T + GEMM_3_T)}
corresponds to
<pre>{@code \[\texttt{dst} =  \texttt{alpha} \cdot \texttt{src1} ^T  \cdot \texttt{src2} +  \texttt{beta} \cdot \texttt{src3} ^T\]}</pre>
<p>
In case of complex (two-channel) data, performed a complex matrix
multiplication.
<p>
The function can be replaced with a matrix expression. For example, the
above call can be replaced with:
<pre>{@code {.cpp}
    dst = alpha*src1.t()*src2 + beta*src3.t();
}</pre>
@param src1 first multiplied input matrix that could be real(CV_32FC1,
CV_64FC1) or complex(CV_32FC2, CV_64FC2).
@param src2 second multiplied input matrix of the same type as src1.
@param alpha weight of the matrix product.
@param src3 third optional delta matrix added to the matrix product; it
should have the same type as src1 and src2.
@param beta weight of src3.
@param dst output matrix; it has the proper size and the same type as
input matrices.
@param flags operation flags (cv::GemmFlags)
@see mulTransposed , transform
*/
@Namespace("cv") public static native void gemm(@ByVal Mat src1, @ByVal Mat src2, double alpha,
                       @ByVal Mat src3, double beta, @ByVal Mat dst, int flags/*=0*/);
@Namespace("cv") public static native void gemm(@ByVal Mat src1, @ByVal Mat src2, double alpha,
                       @ByVal Mat src3, double beta, @ByVal Mat dst);
@Namespace("cv") public static native void gemm(@ByVal UMat src1, @ByVal UMat src2, double alpha,
                       @ByVal UMat src3, double beta, @ByVal UMat dst, int flags/*=0*/);
@Namespace("cv") public static native void gemm(@ByVal UMat src1, @ByVal UMat src2, double alpha,
                       @ByVal UMat src3, double beta, @ByVal UMat dst);
@Namespace("cv") public static native void gemm(@ByVal GpuMat src1, @ByVal GpuMat src2, double alpha,
                       @ByVal GpuMat src3, double beta, @ByVal GpuMat dst, int flags/*=0*/);
@Namespace("cv") public static native void gemm(@ByVal GpuMat src1, @ByVal GpuMat src2, double alpha,
                       @ByVal GpuMat src3, double beta, @ByVal GpuMat dst);

/** \brief Calculates the product of a matrix and its transposition.
<p>
The function cv::mulTransposed calculates the product of src and its
transposition:
<pre>{@code \[\texttt{dst} = \texttt{scale} ( \texttt{src} - \texttt{delta} )^T ( \texttt{src} - \texttt{delta} )\]}</pre>
if aTa=true , and
<pre>{@code \[\texttt{dst} = \texttt{scale} ( \texttt{src} - \texttt{delta} ) ( \texttt{src} - \texttt{delta} )^T\]}</pre>
otherwise. The function is used to calculate the covariance matrix. With
zero delta, it can be used as a faster substitute for general matrix
product A\*B when B=A'
@param src input single-channel matrix. Note that unlike gemm, the
function can multiply not only floating-point matrices.
@param dst output square matrix.
@param aTa Flag specifying the multiplication ordering. See the
description below.
@param delta Optional delta matrix subtracted from src before the
multiplication. When the matrix is empty ( delta=noArray() ), it is
assumed to be zero, that is, nothing is subtracted. If it has the same
size as src , it is simply subtracted. Otherwise, it is "repeated" (see
repeat ) to cover the full src and then subtracted. Type of the delta
matrix, when it is not empty, must be the same as the type of created
output matrix. See the dtype parameter description below.
@param scale Optional scale factor for the matrix product.
@param dtype Optional type of the output matrix. When it is negative,
the output matrix will have the same type as src . Otherwise, it will be
type=CV_MAT_DEPTH(dtype) that should be either CV_32F or CV_64F .
@see calcCovarMatrix, gemm, repeat, reduce
*/
@Namespace("cv") public static native void mulTransposed( @ByVal Mat src, @ByVal Mat dst, @Cast("bool") boolean aTa,
                                 @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat delta,
                                 double scale/*=1*/, int dtype/*=-1*/ );
@Namespace("cv") public static native void mulTransposed( @ByVal Mat src, @ByVal Mat dst, @Cast("bool") boolean aTa );
@Namespace("cv") public static native void mulTransposed( @ByVal UMat src, @ByVal UMat dst, @Cast("bool") boolean aTa,
                                 @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat delta,
                                 double scale/*=1*/, int dtype/*=-1*/ );
@Namespace("cv") public static native void mulTransposed( @ByVal UMat src, @ByVal UMat dst, @Cast("bool") boolean aTa );
@Namespace("cv") public static native void mulTransposed( @ByVal GpuMat src, @ByVal GpuMat dst, @Cast("bool") boolean aTa,
                                 @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat delta,
                                 double scale/*=1*/, int dtype/*=-1*/ );
@Namespace("cv") public static native void mulTransposed( @ByVal GpuMat src, @ByVal GpuMat dst, @Cast("bool") boolean aTa );

/** \brief Transposes a matrix.
<p>
The function cv::transpose transposes the matrix src :
<pre>{@code \[\texttt{dst} (i,j) =  \texttt{src} (j,i)\]}</pre>
\note No complex conjugation is done in case of a complex matrix. It
should be done separately if needed.
@param src input array.
@param dst output array of the same type as src.
*/
@Namespace("cv") public static native void transpose(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void transpose(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void transpose(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Transpose for n-dimensional matrices.
 *
 * \note Input should be continuous single-channel matrix.
 * @param src input array.
 * @param order a permutation of [0,1,..,N-1] where N is the number of axes of src.
 * The i’th axis of dst will correspond to the axis numbered order[i] of the input.
 * @param dst output array of the same type as src.
 */
@Namespace("cv") public static native void transposeND(@ByVal Mat src, @StdVector IntPointer order, @ByVal Mat dst);
@Namespace("cv") public static native void transposeND(@ByVal Mat src, @StdVector IntBuffer order, @ByVal Mat dst);
@Namespace("cv") public static native void transposeND(@ByVal Mat src, @StdVector int[] order, @ByVal Mat dst);
@Namespace("cv") public static native void transposeND(@ByVal UMat src, @StdVector IntPointer order, @ByVal UMat dst);
@Namespace("cv") public static native void transposeND(@ByVal UMat src, @StdVector IntBuffer order, @ByVal UMat dst);
@Namespace("cv") public static native void transposeND(@ByVal UMat src, @StdVector int[] order, @ByVal UMat dst);
@Namespace("cv") public static native void transposeND(@ByVal GpuMat src, @StdVector IntPointer order, @ByVal GpuMat dst);
@Namespace("cv") public static native void transposeND(@ByVal GpuMat src, @StdVector IntBuffer order, @ByVal GpuMat dst);
@Namespace("cv") public static native void transposeND(@ByVal GpuMat src, @StdVector int[] order, @ByVal GpuMat dst);

/** \brief Performs the matrix transformation of every array element.
<p>
The function cv::transform performs the matrix transformation of every
element of the array src and stores the results in dst :
<pre>{@code \[\texttt{dst} (I) =  \texttt{m} \cdot \texttt{src} (I)\]}</pre>
(when m.cols=src.channels() ), or
<pre>{@code \[\texttt{dst} (I) =  \texttt{m} \cdot [ \texttt{src} (I); 1]\]}</pre>
(when m.cols=src.channels()+1 )
<p>
Every element of the N -channel array src is interpreted as N -element
vector that is transformed using the M x N or M x (N+1) matrix m to
M-element vector - the corresponding element of the output array dst .
<p>
The function may be used for geometrical transformation of
N -dimensional points, arbitrary linear color space transformation (such
as various kinds of RGB to YUV transforms), shuffling the image
channels, and so forth.
@param src input array that must have as many channels (1 to 4) as
m.cols or m.cols-1.
@param dst output array of the same size and depth as src; it has as
many channels as m.rows.
@param m transformation 2x2 or 2x3 floating-point matrix.
@see perspectiveTransform, getAffineTransform, estimateAffine2D, warpAffine, warpPerspective
*/
@Namespace("cv") public static native void transform(@ByVal Mat src, @ByVal Mat dst, @ByVal Mat m );
@Namespace("cv") public static native void transform(@ByVal UMat src, @ByVal UMat dst, @ByVal UMat m );
@Namespace("cv") public static native void transform(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal GpuMat m );

/** \brief Performs the perspective matrix transformation of vectors.
<p>
The function cv::perspectiveTransform transforms every element of src by
treating it as a 2D or 3D vector, in the following way:
<pre>{@code \[(x, y, z)  \rightarrow (x'/w, y'/w, z'/w)\]}</pre>
where
<pre>{@code \[(x', y', z', w') =  \texttt{mat} \cdot \begin{bmatrix} x & y & z & 1  \end{bmatrix}\]}</pre>
and
<pre>{@code \[w =  \fork{w'}{if \(w' \ne 0\)}{\infty}{otherwise}\]}</pre>
<p>
Here a 3D vector transformation is shown. In case of a 2D vector
transformation, the z component is omitted.
<p>
\note The function transforms a sparse set of 2D or 3D vectors. If you
want to transform an image using perspective transformation, use
warpPerspective . If you have an inverse problem, that is, you want to
compute the most probable perspective transformation out of several
pairs of corresponding points, you can use getPerspectiveTransform or
findHomography .
@param src input two-channel or three-channel floating-point array; each
element is a 2D/3D vector to be transformed.
@param dst output array of the same size and type as src.
@param m 3x3 or 4x4 floating-point transformation matrix.
@see  transform, warpPerspective, getPerspectiveTransform, findHomography
*/
@Namespace("cv") public static native void perspectiveTransform(@ByVal Mat src, @ByVal Mat dst, @ByVal Mat m );
@Namespace("cv") public static native void perspectiveTransform(@ByVal UMat src, @ByVal UMat dst, @ByVal UMat m );
@Namespace("cv") public static native void perspectiveTransform(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal GpuMat m );

/** \brief Copies the lower or the upper half of a square matrix to its another half.
<p>
The function cv::completeSymm copies the lower or the upper half of a square matrix to
its another half. The matrix diagonal remains unchanged:
 - {@code \texttt{m}_{ij}=\texttt{m}_{ji}} for {@code i > j} if
    lowerToUpper=false
 - {@code \texttt{m}_{ij}=\texttt{m}_{ji}} for {@code i < j} if
    lowerToUpper=true
<p>
@param m input-output floating-point square matrix.
@param lowerToUpper operation flag; if true, the lower half is copied to
the upper half. Otherwise, the upper half is copied to the lower half.
@see flip, transpose
*/
@Namespace("cv") public static native void completeSymm(@ByVal Mat m, @Cast("bool") boolean lowerToUpper/*=false*/);
@Namespace("cv") public static native void completeSymm(@ByVal Mat m);
@Namespace("cv") public static native void completeSymm(@ByVal UMat m, @Cast("bool") boolean lowerToUpper/*=false*/);
@Namespace("cv") public static native void completeSymm(@ByVal UMat m);
@Namespace("cv") public static native void completeSymm(@ByVal GpuMat m, @Cast("bool") boolean lowerToUpper/*=false*/);
@Namespace("cv") public static native void completeSymm(@ByVal GpuMat m);

/** \brief Initializes a scaled identity matrix.
<p>
The function cv::setIdentity initializes a scaled identity matrix:
<pre>{@code \[\texttt{mtx} (i,j)= \fork{\texttt{value}}{ if \(i=j\)}{0}{otherwise}\]}</pre>
<p>
The function can also be emulated using the matrix initializers and the
matrix expressions:
<pre>{@code
    Mat A = Mat::eye(4, 3, CV_32F)*5;
    // A will be set to [[5, 0, 0], [0, 5, 0], [0, 0, 5], [0, 0, 0]]
}</pre>
@param mtx matrix to initialize (not necessarily square).
@param s value to assign to diagonal elements.
@see Mat::zeros, Mat::ones, Mat::setTo, Mat::operator=
*/
@Namespace("cv") public static native void setIdentity(@ByVal Mat mtx, @Const @ByRef(nullValue = "cv::Scalar(1)") Scalar s);
@Namespace("cv") public static native void setIdentity(@ByVal Mat mtx);
@Namespace("cv") public static native void setIdentity(@ByVal UMat mtx, @Const @ByRef(nullValue = "cv::Scalar(1)") Scalar s);
@Namespace("cv") public static native void setIdentity(@ByVal UMat mtx);
@Namespace("cv") public static native void setIdentity(@ByVal GpuMat mtx, @Const @ByRef(nullValue = "cv::Scalar(1)") Scalar s);
@Namespace("cv") public static native void setIdentity(@ByVal GpuMat mtx);

/** \brief Returns the determinant of a square floating-point matrix.
<p>
The function cv::determinant calculates and returns the determinant of the
specified matrix. For small matrices ( mtx.cols=mtx.rows\<=3 ), the
direct method is used. For larger matrices, the function uses LU
factorization with partial pivoting.
<p>
For symmetric positively-determined matrices, it is also possible to use
eigen decomposition to calculate the determinant.
@param mtx input matrix that must have CV_32FC1 or CV_64FC1 type and
square size.
@see trace, invert, solve, eigen, \ref MatrixExpressions
*/
@Namespace("cv") public static native double determinant(@ByVal Mat mtx);
@Namespace("cv") public static native double determinant(@ByVal UMat mtx);
@Namespace("cv") public static native double determinant(@ByVal GpuMat mtx);

/** \brief Returns the trace of a matrix.
<p>
The function cv::trace returns the sum of the diagonal elements of the
matrix mtx .
<pre>{@code \[\mathrm{tr} ( \texttt{mtx} ) =  \sum _i  \texttt{mtx} (i,i)\]}</pre>
@param mtx input matrix.
*/
@Namespace("cv") public static native @ByVal Scalar trace(@ByVal Mat mtx);
@Namespace("cv") public static native @ByVal Scalar trace(@ByVal UMat mtx);
@Namespace("cv") public static native @ByVal Scalar trace(@ByVal GpuMat mtx);

/** \brief Finds the inverse or pseudo-inverse of a matrix.
<p>
The function cv::invert inverts the matrix src and stores the result in dst
. When the matrix src is singular or non-square, the function calculates
the pseudo-inverse matrix (the dst matrix) so that norm(src\*dst - I) is
minimal, where I is an identity matrix.
<p>
In case of the #DECOMP_LU method, the function returns non-zero value if
the inverse has been successfully calculated and 0 if src is singular.
<p>
In case of the #DECOMP_SVD method, the function returns the inverse
condition number of src (the ratio of the smallest singular value to the
largest singular value) and 0 if src is singular. The SVD method
calculates a pseudo-inverse matrix if src is singular.
<p>
Similarly to #DECOMP_LU, the method #DECOMP_CHOLESKY works only with
non-singular square matrices that should also be symmetrical and
positively defined. In this case, the function stores the inverted
matrix in dst and returns non-zero. Otherwise, it returns 0.
<p>
@param src input floating-point M x N matrix.
@param dst output matrix of N x M size and the same type as src.
@param flags inversion method (cv::DecompTypes)
@see solve, SVD
*/
@Namespace("cv") public static native double invert(@ByVal Mat src, @ByVal Mat dst, int flags/*=cv::DECOMP_LU*/);
@Namespace("cv") public static native double invert(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native double invert(@ByVal UMat src, @ByVal UMat dst, int flags/*=cv::DECOMP_LU*/);
@Namespace("cv") public static native double invert(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native double invert(@ByVal GpuMat src, @ByVal GpuMat dst, int flags/*=cv::DECOMP_LU*/);
@Namespace("cv") public static native double invert(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Solves one or more linear systems or least-squares problems.
<p>
The function cv::solve solves a linear system or least-squares problem (the
latter is possible with SVD or QR methods, or by specifying the flag
#DECOMP_NORMAL ):
<pre>{@code \[\texttt{dst} =  \arg \min _X \| \texttt{src1} \cdot \texttt{X} -  \texttt{src2} \|\]}</pre>
<p>
If #DECOMP_LU or #DECOMP_CHOLESKY method is used, the function returns 1
if src1 (or {@code \texttt{src1}^T\texttt{src1}} ) is non-singular. Otherwise,
it returns 0. In the latter case, dst is not valid. Other methods find a
pseudo-solution in case of a singular left-hand side part.
<p>
\note If you want to find a unity-norm solution of an under-defined
singular system {@code \texttt{src1}\cdot\texttt{dst}=0} , the function solve
will not do the work. Use SVD::solveZ instead.
<p>
@param src1 input matrix on the left-hand side of the system.
@param src2 input matrix on the right-hand side of the system.
@param dst output solution.
@param flags solution (matrix inversion) method (#DecompTypes)
@see invert, SVD, eigen
*/
@Namespace("cv") public static native @Cast("bool") boolean solve(@ByVal Mat src1, @ByVal Mat src2,
                        @ByVal Mat dst, int flags/*=cv::DECOMP_LU*/);
@Namespace("cv") public static native @Cast("bool") boolean solve(@ByVal Mat src1, @ByVal Mat src2,
                        @ByVal Mat dst);
@Namespace("cv") public static native @Cast("bool") boolean solve(@ByVal UMat src1, @ByVal UMat src2,
                        @ByVal UMat dst, int flags/*=cv::DECOMP_LU*/);
@Namespace("cv") public static native @Cast("bool") boolean solve(@ByVal UMat src1, @ByVal UMat src2,
                        @ByVal UMat dst);
@Namespace("cv") public static native @Cast("bool") boolean solve(@ByVal GpuMat src1, @ByVal GpuMat src2,
                        @ByVal GpuMat dst, int flags/*=cv::DECOMP_LU*/);
@Namespace("cv") public static native @Cast("bool") boolean solve(@ByVal GpuMat src1, @ByVal GpuMat src2,
                        @ByVal GpuMat dst);

/** \brief Sorts each row or each column of a matrix.
<p>
The function cv::sort sorts each matrix row or each matrix column in
ascending or descending order. So you should pass two operation flags to
get desired behaviour. If you want to sort matrix rows or columns
lexicographically, you can use STL std::sort generic function with the
proper comparison predicate.
<p>
@param src input single-channel array.
@param dst output array of the same size and type as src.
@param flags operation flags, a combination of #SortFlags
@see sortIdx, randShuffle
*/
@Namespace("cv") public static native void sort(@ByVal Mat src, @ByVal Mat dst, int flags);
@Namespace("cv") public static native void sort(@ByVal UMat src, @ByVal UMat dst, int flags);
@Namespace("cv") public static native void sort(@ByVal GpuMat src, @ByVal GpuMat dst, int flags);

/** \brief Sorts each row or each column of a matrix.
<p>
The function cv::sortIdx sorts each matrix row or each matrix column in the
ascending or descending order. So you should pass two operation flags to
get desired behaviour. Instead of reordering the elements themselves, it
stores the indices of sorted elements in the output array. For example:
<pre>{@code
    Mat A = Mat::eye(3,3,CV_32F), B;
    sortIdx(A, B, SORT_EVERY_ROW + SORT_ASCENDING);
    // B will probably contain
    // (because of equal elements in A some permutations are possible):
    // [[1, 2, 0], [0, 2, 1], [0, 1, 2]]
}</pre>
@param src input single-channel array.
@param dst output integer array of the same size as src.
@param flags operation flags that could be a combination of cv::SortFlags
@see sort, randShuffle
*/
@Namespace("cv") public static native void sortIdx(@ByVal Mat src, @ByVal Mat dst, int flags);
@Namespace("cv") public static native void sortIdx(@ByVal UMat src, @ByVal UMat dst, int flags);
@Namespace("cv") public static native void sortIdx(@ByVal GpuMat src, @ByVal GpuMat dst, int flags);

/** \brief Finds the real roots of a cubic equation.
<p>
The function solveCubic finds the real roots of a cubic equation:
-   if coeffs is a 4-element vector:
<pre>{@code \[\texttt{coeffs} [0] x^3 +  \texttt{coeffs} [1] x^2 +  \texttt{coeffs} [2] x +  \texttt{coeffs} [3] = 0\]}</pre>
-   if coeffs is a 3-element vector:
<pre>{@code \[x^3 +  \texttt{coeffs} [0] x^2 +  \texttt{coeffs} [1] x +  \texttt{coeffs} [2] = 0\]}</pre>
<p>
The roots are stored in the roots array.
@param coeffs equation coefficients, an array of 3 or 4 elements.
@param roots output array of real roots that has 1 or 3 elements.
@return number of real roots. It can be 0, 1 or 2.
*/
@Namespace("cv") public static native int solveCubic(@ByVal Mat coeffs, @ByVal Mat roots);
@Namespace("cv") public static native int solveCubic(@ByVal UMat coeffs, @ByVal UMat roots);
@Namespace("cv") public static native int solveCubic(@ByVal GpuMat coeffs, @ByVal GpuMat roots);

/** \brief Finds the real or complex roots of a polynomial equation.
<p>
The function cv::solvePoly finds real and complex roots of a polynomial equation:
<pre>{@code \[\texttt{coeffs} [n] x^{n} +  \texttt{coeffs} [n-1] x^{n-1} + ... +  \texttt{coeffs} [1] x +  \texttt{coeffs} [0] = 0\]}</pre>
@param coeffs array of polynomial coefficients.
@param roots output (complex) array of roots.
@param maxIters maximum number of iterations the algorithm does.
*/
@Namespace("cv") public static native double solvePoly(@ByVal Mat coeffs, @ByVal Mat roots, int maxIters/*=300*/);
@Namespace("cv") public static native double solvePoly(@ByVal Mat coeffs, @ByVal Mat roots);
@Namespace("cv") public static native double solvePoly(@ByVal UMat coeffs, @ByVal UMat roots, int maxIters/*=300*/);
@Namespace("cv") public static native double solvePoly(@ByVal UMat coeffs, @ByVal UMat roots);
@Namespace("cv") public static native double solvePoly(@ByVal GpuMat coeffs, @ByVal GpuMat roots, int maxIters/*=300*/);
@Namespace("cv") public static native double solvePoly(@ByVal GpuMat coeffs, @ByVal GpuMat roots);

/** \brief Calculates eigenvalues and eigenvectors of a symmetric matrix.
<p>
The function cv::eigen calculates just eigenvalues, or eigenvalues and eigenvectors of the symmetric
matrix src:
<pre>{@code
    src*eigenvectors.row(i).t() = eigenvalues.at<srcType>(i)*eigenvectors.row(i).t()
}</pre>
<p>
\note Use cv::eigenNonSymmetric for calculation of real eigenvalues and eigenvectors of non-symmetric matrix.
<p>
@param src input matrix that must have CV_32FC1 or CV_64FC1 type, square size and be symmetrical
(src ^T^ == src).
@param eigenvalues output vector of eigenvalues of the same type as src; the eigenvalues are stored
in the descending order.
@param eigenvectors output matrix of eigenvectors; it has the same size and type as src; the
eigenvectors are stored as subsequent matrix rows, in the same order as the corresponding
eigenvalues.
@see eigenNonSymmetric, completeSymm , PCA
*/
@Namespace("cv") public static native @Cast("bool") boolean eigen(@ByVal Mat src, @ByVal Mat eigenvalues,
                        @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat eigenvectors);
@Namespace("cv") public static native @Cast("bool") boolean eigen(@ByVal Mat src, @ByVal Mat eigenvalues);
@Namespace("cv") public static native @Cast("bool") boolean eigen(@ByVal UMat src, @ByVal UMat eigenvalues,
                        @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat eigenvectors);
@Namespace("cv") public static native @Cast("bool") boolean eigen(@ByVal UMat src, @ByVal UMat eigenvalues);
@Namespace("cv") public static native @Cast("bool") boolean eigen(@ByVal GpuMat src, @ByVal GpuMat eigenvalues,
                        @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat eigenvectors);
@Namespace("cv") public static native @Cast("bool") boolean eigen(@ByVal GpuMat src, @ByVal GpuMat eigenvalues);

/** \brief Calculates eigenvalues and eigenvectors of a non-symmetric matrix (real eigenvalues only).
<p>
\note Assumes real eigenvalues.
<p>
The function calculates eigenvalues and eigenvectors (optional) of the square matrix src:
<pre>{@code
    src*eigenvectors.row(i).t() = eigenvalues.at<srcType>(i)*eigenvectors.row(i).t()
}</pre>
<p>
@param src input matrix (CV_32FC1 or CV_64FC1 type).
@param eigenvalues output vector of eigenvalues (type is the same type as src).
@param eigenvectors output matrix of eigenvectors (type is the same type as src). The eigenvectors are stored as subsequent matrix rows, in the same order as the corresponding eigenvalues.
@see eigen
*/
@Namespace("cv") public static native void eigenNonSymmetric(@ByVal Mat src, @ByVal Mat eigenvalues,
                                    @ByVal Mat eigenvectors);
@Namespace("cv") public static native void eigenNonSymmetric(@ByVal UMat src, @ByVal UMat eigenvalues,
                                    @ByVal UMat eigenvectors);
@Namespace("cv") public static native void eigenNonSymmetric(@ByVal GpuMat src, @ByVal GpuMat eigenvalues,
                                    @ByVal GpuMat eigenvectors);

/** \brief Calculates the covariance matrix of a set of vectors.
<p>
The function cv::calcCovarMatrix calculates the covariance matrix and, optionally, the mean vector of
the set of input vectors.
@param samples samples stored as separate matrices
@param nsamples number of samples
@param covar output covariance matrix of the type ctype and square size.
@param mean input or output (depending on the flags) array as the average value of the input vectors.
@param flags operation flags as a combination of #CovarFlags
@param ctype type of the matrixl; it equals 'CV_64F' by default.
@see PCA, mulTransposed, Mahalanobis
\todo InputArrayOfArrays
*/
@Namespace("cv") public static native void calcCovarMatrix( @Const Mat samples, int nsamples, @ByRef Mat covar, @ByRef Mat mean,
                                 int flags, int ctype/*=CV_64F*/);
@Namespace("cv") public static native void calcCovarMatrix( @Const Mat samples, int nsamples, @ByRef Mat covar, @ByRef Mat mean,
                                 int flags);

/** \overload
\note use #COVAR_ROWS or #COVAR_COLS flag
@param samples samples stored as rows/columns of a single matrix.
@param covar output covariance matrix of the type ctype and square size.
@param mean input or output (depending on the flags) array as the average value of the input vectors.
@param flags operation flags as a combination of #CovarFlags
@param ctype type of the matrixl; it equals 'CV_64F' by default.
*/
@Namespace("cv") public static native void calcCovarMatrix( @ByVal Mat samples, @ByVal Mat covar,
                                   @ByVal Mat mean, int flags, int ctype/*=CV_64F*/);
@Namespace("cv") public static native void calcCovarMatrix( @ByVal Mat samples, @ByVal Mat covar,
                                   @ByVal Mat mean, int flags);
@Namespace("cv") public static native void calcCovarMatrix( @ByVal UMat samples, @ByVal UMat covar,
                                   @ByVal UMat mean, int flags, int ctype/*=CV_64F*/);
@Namespace("cv") public static native void calcCovarMatrix( @ByVal UMat samples, @ByVal UMat covar,
                                   @ByVal UMat mean, int flags);
@Namespace("cv") public static native void calcCovarMatrix( @ByVal GpuMat samples, @ByVal GpuMat covar,
                                   @ByVal GpuMat mean, int flags, int ctype/*=CV_64F*/);
@Namespace("cv") public static native void calcCovarMatrix( @ByVal GpuMat samples, @ByVal GpuMat covar,
                                   @ByVal GpuMat mean, int flags);

/** wrap PCA::operator() */
@Namespace("cv") public static native void PCACompute(@ByVal Mat data, @ByVal Mat mean,
                             @ByVal Mat eigenvectors, int maxComponents/*=0*/);
@Namespace("cv") public static native void PCACompute(@ByVal Mat data, @ByVal Mat mean,
                             @ByVal Mat eigenvectors);
@Namespace("cv") public static native void PCACompute(@ByVal UMat data, @ByVal UMat mean,
                             @ByVal UMat eigenvectors, int maxComponents/*=0*/);
@Namespace("cv") public static native void PCACompute(@ByVal UMat data, @ByVal UMat mean,
                             @ByVal UMat eigenvectors);
@Namespace("cv") public static native void PCACompute(@ByVal GpuMat data, @ByVal GpuMat mean,
                             @ByVal GpuMat eigenvectors, int maxComponents/*=0*/);
@Namespace("cv") public static native void PCACompute(@ByVal GpuMat data, @ByVal GpuMat mean,
                             @ByVal GpuMat eigenvectors);

/** wrap PCA::operator() and add eigenvalues output parameter */
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal Mat data, @ByVal Mat mean,
                                           @ByVal Mat eigenvectors, @ByVal Mat eigenvalues,
                                           int maxComponents/*=0*/);
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal Mat data, @ByVal Mat mean,
                                           @ByVal Mat eigenvectors, @ByVal Mat eigenvalues);
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal UMat data, @ByVal UMat mean,
                                           @ByVal UMat eigenvectors, @ByVal UMat eigenvalues,
                                           int maxComponents/*=0*/);
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal UMat data, @ByVal UMat mean,
                                           @ByVal UMat eigenvectors, @ByVal UMat eigenvalues);
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal GpuMat data, @ByVal GpuMat mean,
                                           @ByVal GpuMat eigenvectors, @ByVal GpuMat eigenvalues,
                                           int maxComponents/*=0*/);
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal GpuMat data, @ByVal GpuMat mean,
                                           @ByVal GpuMat eigenvectors, @ByVal GpuMat eigenvalues);

/** wrap PCA::operator() */
@Namespace("cv") public static native void PCACompute(@ByVal Mat data, @ByVal Mat mean,
                             @ByVal Mat eigenvectors, double retainedVariance);
@Namespace("cv") public static native void PCACompute(@ByVal UMat data, @ByVal UMat mean,
                             @ByVal UMat eigenvectors, double retainedVariance);
@Namespace("cv") public static native void PCACompute(@ByVal GpuMat data, @ByVal GpuMat mean,
                             @ByVal GpuMat eigenvectors, double retainedVariance);

/** wrap PCA::operator() and add eigenvalues output parameter */
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal Mat data, @ByVal Mat mean,
                                           @ByVal Mat eigenvectors, @ByVal Mat eigenvalues,
                                           double retainedVariance);
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal UMat data, @ByVal UMat mean,
                                           @ByVal UMat eigenvectors, @ByVal UMat eigenvalues,
                                           double retainedVariance);
@Namespace("cv") public static native @Name("PCACompute") void PCACompute2(@ByVal GpuMat data, @ByVal GpuMat mean,
                                           @ByVal GpuMat eigenvectors, @ByVal GpuMat eigenvalues,
                                           double retainedVariance);

/** wrap PCA::project */
@Namespace("cv") public static native void PCAProject(@ByVal Mat data, @ByVal Mat mean,
                             @ByVal Mat eigenvectors, @ByVal Mat result);
@Namespace("cv") public static native void PCAProject(@ByVal UMat data, @ByVal UMat mean,
                             @ByVal UMat eigenvectors, @ByVal UMat result);
@Namespace("cv") public static native void PCAProject(@ByVal GpuMat data, @ByVal GpuMat mean,
                             @ByVal GpuMat eigenvectors, @ByVal GpuMat result);

/** wrap PCA::backProject */
@Namespace("cv") public static native void PCABackProject(@ByVal Mat data, @ByVal Mat mean,
                                 @ByVal Mat eigenvectors, @ByVal Mat result);
@Namespace("cv") public static native void PCABackProject(@ByVal UMat data, @ByVal UMat mean,
                                 @ByVal UMat eigenvectors, @ByVal UMat result);
@Namespace("cv") public static native void PCABackProject(@ByVal GpuMat data, @ByVal GpuMat mean,
                                 @ByVal GpuMat eigenvectors, @ByVal GpuMat result);

/** wrap SVD::compute */
@Namespace("cv") public static native void SVDecomp( @ByVal Mat src, @ByVal Mat w, @ByVal Mat u, @ByVal Mat vt, int flags/*=0*/ );
@Namespace("cv") public static native void SVDecomp( @ByVal Mat src, @ByVal Mat w, @ByVal Mat u, @ByVal Mat vt );
@Namespace("cv") public static native void SVDecomp( @ByVal UMat src, @ByVal UMat w, @ByVal UMat u, @ByVal UMat vt, int flags/*=0*/ );
@Namespace("cv") public static native void SVDecomp( @ByVal UMat src, @ByVal UMat w, @ByVal UMat u, @ByVal UMat vt );
@Namespace("cv") public static native void SVDecomp( @ByVal GpuMat src, @ByVal GpuMat w, @ByVal GpuMat u, @ByVal GpuMat vt, int flags/*=0*/ );
@Namespace("cv") public static native void SVDecomp( @ByVal GpuMat src, @ByVal GpuMat w, @ByVal GpuMat u, @ByVal GpuMat vt );

/** wrap SVD::backSubst */
@Namespace("cv") public static native void SVBackSubst( @ByVal Mat w, @ByVal Mat u, @ByVal Mat vt,
                               @ByVal Mat rhs, @ByVal Mat dst );
@Namespace("cv") public static native void SVBackSubst( @ByVal UMat w, @ByVal UMat u, @ByVal UMat vt,
                               @ByVal UMat rhs, @ByVal UMat dst );
@Namespace("cv") public static native void SVBackSubst( @ByVal GpuMat w, @ByVal GpuMat u, @ByVal GpuMat vt,
                               @ByVal GpuMat rhs, @ByVal GpuMat dst );

/** \brief Calculates the Mahalanobis distance between two vectors.
<p>
The function cv::Mahalanobis calculates and returns the weighted distance between two vectors:
<pre>{@code \[d( \texttt{vec1} , \texttt{vec2} )= \sqrt{\sum_{i,j}{\texttt{icovar(i,j)}\cdot(\texttt{vec1}(I)-\texttt{vec2}(I))\cdot(\texttt{vec1(j)}-\texttt{vec2(j)})} }\]}</pre>
The covariance matrix may be calculated using the #calcCovarMatrix function and then inverted using
the invert function (preferably using the #DECOMP_SVD method, as the most accurate).
@param v1 first 1D input vector.
@param v2 second 1D input vector.
@param icovar inverse covariance matrix.
*/
@Namespace("cv") public static native double Mahalanobis(@ByVal Mat v1, @ByVal Mat v2, @ByVal Mat icovar);
@Namespace("cv") public static native double Mahalanobis(@ByVal UMat v1, @ByVal UMat v2, @ByVal UMat icovar);
@Namespace("cv") public static native double Mahalanobis(@ByVal GpuMat v1, @ByVal GpuMat v2, @ByVal GpuMat icovar);

/** \brief Performs a forward or inverse Discrete Fourier transform of a 1D or 2D floating-point array.
<p>
The function cv::dft performs one of the following:
-   Forward the Fourier transform of a 1D vector of N elements:
    <pre>{@code \[Y = F^{(N)}  \cdot X,\]}</pre>
    where {@code F^{(N)}_{jk}=\exp(-2\pi i j k/N)} and {@code i=\sqrt{-1}}
-   Inverse the Fourier transform of a 1D vector of N elements:
    <pre>{@code \[\begin{array}{l} X'=  \left (F^{(N)} \right )^{-1}  \cdot Y =  \left (F^{(N)} \right )^*  \cdot y  \\ X = (1/N)  \cdot X, \end{array}\]}</pre>
    where {@code F^*=\left(\textrm{Re}(F^{(N)})-\textrm{Im}(F^{(N)})\right)^T}
-   Forward the 2D Fourier transform of a M x N matrix:
    <pre>{@code \[Y = F^{(M)}  \cdot X  \cdot F^{(N)}\]}</pre>
-   Inverse the 2D Fourier transform of a M x N matrix:
    <pre>{@code \[\begin{array}{l} X'=  \left (F^{(M)} \right )^*  \cdot Y  \cdot \left (F^{(N)} \right )^* \\ X =  \frac{1}{M \cdot N} \cdot X' \end{array}\]}</pre>
<p>
In case of real (single-channel) data, the output spectrum of the forward Fourier transform or input
spectrum of the inverse Fourier transform can be represented in a packed format called *CCS*
(complex-conjugate-symmetrical). It was borrowed from IPL (Intel\* Image Processing Library). Here
is how 2D *CCS* spectrum looks:
<pre>{@code \[\begin{bmatrix} Re Y_{0,0} & Re Y_{0,1} & Im Y_{0,1} & Re Y_{0,2} & Im Y_{0,2} &  \cdots & Re Y_{0,N/2-1} & Im Y_{0,N/2-1} & Re Y_{0,N/2}  \\ Re Y_{1,0} & Re Y_{1,1} & Im Y_{1,1} & Re Y_{1,2} & Im Y_{1,2} &  \cdots & Re Y_{1,N/2-1} & Im Y_{1,N/2-1} & Re Y_{1,N/2}  \\ Im Y_{1,0} & Re Y_{2,1} & Im Y_{2,1} & Re Y_{2,2} & Im Y_{2,2} &  \cdots & Re Y_{2,N/2-1} & Im Y_{2,N/2-1} & Im Y_{1,N/2}  \\ \hdotsfor{9} \\ Re Y_{M/2-1,0} &  Re Y_{M-3,1}  & Im Y_{M-3,1} &  \hdotsfor{3} & Re Y_{M-3,N/2-1} & Im Y_{M-3,N/2-1}& Re Y_{M/2-1,N/2}  \\ Im Y_{M/2-1,0} &  Re Y_{M-2,1}  & Im Y_{M-2,1} &  \hdotsfor{3} & Re Y_{M-2,N/2-1} & Im Y_{M-2,N/2-1}& Im Y_{M/2-1,N/2}  \\ Re Y_{M/2,0}  &  Re Y_{M-1,1} &  Im Y_{M-1,1} &  \hdotsfor{3} & Re Y_{M-1,N/2-1} & Im Y_{M-1,N/2-1}& Re Y_{M/2,N/2} \end{bmatrix}\]}</pre>
<p>
In case of 1D transform of a real vector, the output looks like the first row of the matrix above.
<p>
So, the function chooses an operation mode depending on the flags and size of the input array:
-   If #DFT_ROWS is set or the input array has a single row or single column, the function
    performs a 1D forward or inverse transform of each row of a matrix when #DFT_ROWS is set.
    Otherwise, it performs a 2D transform.
-   If the input array is real and #DFT_INVERSE is not set, the function performs a forward 1D or
    2D transform:
    -   When #DFT_COMPLEX_OUTPUT is set, the output is a complex matrix of the same size as
        input.
    -   When #DFT_COMPLEX_OUTPUT is not set, the output is a real matrix of the same size as
        input. In case of 2D transform, it uses the packed format as shown above. In case of a
        single 1D transform, it looks like the first row of the matrix above. In case of
        multiple 1D transforms (when using the #DFT_ROWS flag), each row of the output matrix
        looks like the first row of the matrix above.
-   If the input array is complex and either #DFT_INVERSE or #DFT_REAL_OUTPUT are not set, the
    output is a complex array of the same size as input. The function performs a forward or
    inverse 1D or 2D transform of the whole input array or each row of the input array
    independently, depending on the flags DFT_INVERSE and DFT_ROWS.
-   When #DFT_INVERSE is set and the input array is real, or it is complex but #DFT_REAL_OUTPUT
    is set, the output is a real array of the same size as input. The function performs a 1D or 2D
    inverse transformation of the whole input array or each individual row, depending on the flags
    #DFT_INVERSE and #DFT_ROWS.
<p>
If #DFT_SCALE is set, the scaling is done after the transformation.
<p>
Unlike dct , the function supports arrays of arbitrary size. But only those arrays are processed
efficiently, whose sizes can be factorized in a product of small prime numbers (2, 3, and 5 in the
current implementation). Such an efficient DFT size can be calculated using the getOptimalDFTSize
method.
<p>
The sample below illustrates how to calculate a DFT-based convolution of two 2D real arrays:
<pre>{@code
    void convolveDFT(InputArray A, InputArray B, OutputArray C)
    {
        // reallocate the output array if needed
        C.create(abs(A.rows - B.rows)+1, abs(A.cols - B.cols)+1, A.type());
        Size dftSize;
        // calculate the size of DFT transform
        dftSize.width = getOptimalDFTSize(A.cols + B.cols - 1);
        dftSize.height = getOptimalDFTSize(A.rows + B.rows - 1);

        // allocate temporary buffers and initialize them with 0's
        Mat tempA(dftSize, A.type(), Scalar::all(0));
        Mat tempB(dftSize, B.type(), Scalar::all(0));

        // copy A and B to the top-left corners of tempA and tempB, respectively
        Mat roiA(tempA, Rect(0,0,A.cols,A.rows));
        A.copyTo(roiA);
        Mat roiB(tempB, Rect(0,0,B.cols,B.rows));
        B.copyTo(roiB);

        // now transform the padded A & B in-place;
        // use "nonzeroRows" hint for faster processing
        dft(tempA, tempA, 0, A.rows);
        dft(tempB, tempB, 0, B.rows);

        // multiply the spectrums;
        // the function handles packed spectrum representations well
        mulSpectrums(tempA, tempB, tempA);

        // transform the product back from the frequency domain.
        // Even though all the result rows will be non-zero,
        // you need only the first C.rows of them, and thus you
        // pass nonzeroRows == C.rows
        dft(tempA, tempA, DFT_INVERSE + DFT_SCALE, C.rows);

        // now copy the result back to C.
        tempA(Rect(0, 0, C.cols, C.rows)).copyTo(C);

        // all the temporary buffers will be deallocated automatically
    }
}</pre>
To optimize this sample, consider the following approaches:
-   Since nonzeroRows != 0 is passed to the forward transform calls and since A and B are copied to
    the top-left corners of tempA and tempB, respectively, it is not necessary to clear the whole
    tempA and tempB. It is only necessary to clear the tempA.cols - A.cols ( tempB.cols - B.cols)
    rightmost columns of the matrices.
-   This DFT-based convolution does not have to be applied to the whole big arrays, especially if B
    is significantly smaller than A or vice versa. Instead, you can calculate convolution by parts.
    To do this, you need to split the output array C into multiple tiles. For each tile, estimate
    which parts of A and B are required to calculate convolution in this tile. If the tiles in C are
    too small, the speed will decrease a lot because of repeated work. In the ultimate case, when
    each tile in C is a single pixel, the algorithm becomes equivalent to the naive convolution
    algorithm. If the tiles are too big, the temporary arrays tempA and tempB become too big and
    there is also a slowdown because of bad cache locality. So, there is an optimal tile size
    somewhere in the middle.
-   If different tiles in C can be calculated in parallel and, thus, the convolution is done by
    parts, the loop can be threaded.
<p>
All of the above improvements have been implemented in #matchTemplate and #filter2D . Therefore, by
using them, you can get the performance even better than with the above theoretically optimal
implementation. Though, those two functions actually calculate cross-correlation, not convolution,
so you need to "flip" the second convolution operand B vertically and horizontally using flip .
\note
-   An example using the discrete fourier transform can be found at
    opencv_source_code/samples/cpp/dft.cpp
-   (Python) An example using the dft functionality to perform Wiener deconvolution can be found
    at opencv_source/samples/python/deconvolution.py
-   (Python) An example rearranging the quadrants of a Fourier image can be found at
    opencv_source/samples/python/dft.py
@param src input array that could be real or complex.
@param dst output array whose size and type depends on the flags .
@param flags transformation flags, representing a combination of the #DftFlags
@param nonzeroRows when the parameter is not zero, the function assumes that only the first
nonzeroRows rows of the input array (#DFT_INVERSE is not set) or only the first nonzeroRows of the
output array (#DFT_INVERSE is set) contain non-zeros, thus, the function can handle the rest of the
rows more efficiently and save some time; this technique is very useful for calculating array
cross-correlation or convolution using DFT.
@see dct , getOptimalDFTSize , mulSpectrums, filter2D , matchTemplate , flip , cartToPolar ,
magnitude , phase
*/
@Namespace("cv") public static native void dft(@ByVal Mat src, @ByVal Mat dst, int flags/*=0*/, int nonzeroRows/*=0*/);
@Namespace("cv") public static native void dft(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void dft(@ByVal UMat src, @ByVal UMat dst, int flags/*=0*/, int nonzeroRows/*=0*/);
@Namespace("cv") public static native void dft(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void dft(@ByVal GpuMat src, @ByVal GpuMat dst, int flags/*=0*/, int nonzeroRows/*=0*/);
@Namespace("cv") public static native void dft(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Calculates the inverse Discrete Fourier Transform of a 1D or 2D array.
<p>
idft(src, dst, flags) is equivalent to dft(src, dst, flags | #DFT_INVERSE) .
\note None of dft and idft scales the result by default. So, you should pass #DFT_SCALE to one of
dft or idft explicitly to make these transforms mutually inverse.
@see dft, dct, idct, mulSpectrums, getOptimalDFTSize
@param src input floating-point real or complex array.
@param dst output array whose size and type depend on the flags.
@param flags operation flags (see dft and #DftFlags).
@param nonzeroRows number of dst rows to process; the rest of the rows have undefined content (see
the convolution sample in dft description.
*/
@Namespace("cv") public static native void idft(@ByVal Mat src, @ByVal Mat dst, int flags/*=0*/, int nonzeroRows/*=0*/);
@Namespace("cv") public static native void idft(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void idft(@ByVal UMat src, @ByVal UMat dst, int flags/*=0*/, int nonzeroRows/*=0*/);
@Namespace("cv") public static native void idft(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void idft(@ByVal GpuMat src, @ByVal GpuMat dst, int flags/*=0*/, int nonzeroRows/*=0*/);
@Namespace("cv") public static native void idft(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Performs a forward or inverse discrete Cosine transform of 1D or 2D array.
<p>
The function cv::dct performs a forward or inverse discrete Cosine transform (DCT) of a 1D or 2D
floating-point array:
-   Forward Cosine transform of a 1D vector of N elements:
    <pre>{@code \[Y = C^{(N)}  \cdot X\]}</pre>
    where
    <pre>{@code \[C^{(N)}_{jk}= \sqrt{\alpha_j/N} \cos \left ( \frac{\pi(2k+1)j}{2N} \right )\]}</pre>
    and
    {@code \alpha_0=1}, {@code \alpha_j=2} for *j \> 0*.
-   Inverse Cosine transform of a 1D vector of N elements:
    <pre>{@code \[X =  \left (C^{(N)} \right )^{-1}  \cdot Y =  \left (C^{(N)} \right )^T  \cdot Y\]}</pre>
    (since {@code C^{(N)}} is an orthogonal matrix, {@code C^{(N)} \cdot \left(C^{(N)}\right)^T = I} )
-   Forward 2D Cosine transform of M x N matrix:
    <pre>{@code \[Y = C^{(N)}  \cdot X  \cdot \left (C^{(N)} \right )^T\]}</pre>
-   Inverse 2D Cosine transform of M x N matrix:
    <pre>{@code \[X =  \left (C^{(N)} \right )^T  \cdot X  \cdot C^{(N)}\]}</pre>
<p>
The function chooses the mode of operation by looking at the flags and size of the input array:
-   If (flags & #DCT_INVERSE) == 0 , the function does a forward 1D or 2D transform. Otherwise, it
    is an inverse 1D or 2D transform.
-   If (flags & #DCT_ROWS) != 0 , the function performs a 1D transform of each row.
-   If the array is a single column or a single row, the function performs a 1D transform.
-   If none of the above is true, the function performs a 2D transform.
<p>
\note Currently dct supports even-size arrays (2, 4, 6 ...). For data analysis and approximation, you
can pad the array when necessary.
Also, the function performance depends very much, and not monotonically, on the array size (see
getOptimalDFTSize ). In the current implementation DCT of a vector of size N is calculated via DFT
of a vector of size N/2 . Thus, the optimal DCT size N1 \>= N can be calculated as:
<pre>{@code
    size_t getOptimalDCTSize(size_t N) { return 2*getOptimalDFTSize((N+1)/2); }
    N1 = getOptimalDCTSize(N);
}</pre>
@param src input floating-point array.
@param dst output array of the same size and type as src .
@param flags transformation flags as a combination of cv::DftFlags (DCT_*)
@see dft , getOptimalDFTSize , idct
*/
@Namespace("cv") public static native void dct(@ByVal Mat src, @ByVal Mat dst, int flags/*=0*/);
@Namespace("cv") public static native void dct(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void dct(@ByVal UMat src, @ByVal UMat dst, int flags/*=0*/);
@Namespace("cv") public static native void dct(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void dct(@ByVal GpuMat src, @ByVal GpuMat dst, int flags/*=0*/);
@Namespace("cv") public static native void dct(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Calculates the inverse Discrete Cosine Transform of a 1D or 2D array.
<p>
idct(src, dst, flags) is equivalent to dct(src, dst, flags | DCT_INVERSE).
@param src input floating-point single-channel array.
@param dst output array of the same size and type as src.
@param flags operation flags.
@see  dct, dft, idft, getOptimalDFTSize
*/
@Namespace("cv") public static native void idct(@ByVal Mat src, @ByVal Mat dst, int flags/*=0*/);
@Namespace("cv") public static native void idct(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv") public static native void idct(@ByVal UMat src, @ByVal UMat dst, int flags/*=0*/);
@Namespace("cv") public static native void idct(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv") public static native void idct(@ByVal GpuMat src, @ByVal GpuMat dst, int flags/*=0*/);
@Namespace("cv") public static native void idct(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Performs the per-element multiplication of two Fourier spectrums.
<p>
The function cv::mulSpectrums performs the per-element multiplication of the two CCS-packed or complex
matrices that are results of a real or complex Fourier transform.
<p>
The function, together with dft and idft , may be used to calculate convolution (pass conjB=false )
or correlation (pass conjB=true ) of two arrays rapidly. When the arrays are complex, they are
simply multiplied (per element) with an optional conjugation of the second-array elements. When the
arrays are real, they are assumed to be CCS-packed (see dft for details).
@param a first input array.
@param b second input array of the same size and type as src1 .
@param c output array of the same size and type as src1 .
@param flags operation flags; currently, the only supported flag is cv::DFT_ROWS, which indicates that
each row of src1 and src2 is an independent 1D Fourier spectrum. If you do not want to use this flag, then simply add a {@code 0} as value.
@param conjB optional flag that conjugates the second input array before the multiplication (true)
or not (false).
*/
@Namespace("cv") public static native void mulSpectrums(@ByVal Mat a, @ByVal Mat b, @ByVal Mat c,
                               int flags, @Cast("bool") boolean conjB/*=false*/);
@Namespace("cv") public static native void mulSpectrums(@ByVal Mat a, @ByVal Mat b, @ByVal Mat c,
                               int flags);
@Namespace("cv") public static native void mulSpectrums(@ByVal UMat a, @ByVal UMat b, @ByVal UMat c,
                               int flags, @Cast("bool") boolean conjB/*=false*/);
@Namespace("cv") public static native void mulSpectrums(@ByVal UMat a, @ByVal UMat b, @ByVal UMat c,
                               int flags);
@Namespace("cv") public static native void mulSpectrums(@ByVal GpuMat a, @ByVal GpuMat b, @ByVal GpuMat c,
                               int flags, @Cast("bool") boolean conjB/*=false*/);
@Namespace("cv") public static native void mulSpectrums(@ByVal GpuMat a, @ByVal GpuMat b, @ByVal GpuMat c,
                               int flags);

/** \brief Returns the optimal DFT size for a given vector size.
<p>
DFT performance is not a monotonic function of a vector size. Therefore, when you calculate
convolution of two arrays or perform the spectral analysis of an array, it usually makes sense to
pad the input data with zeros to get a bit larger array that can be transformed much faster than the
original one. Arrays whose size is a power-of-two (2, 4, 8, 16, 32, ...) are the fastest to process.
Though, the arrays whose size is a product of 2's, 3's, and 5's (for example, 300 = 5\*5\*3\*2\*2)
are also processed quite efficiently.
<p>
The function cv::getOptimalDFTSize returns the minimum number N that is greater than or equal to vecsize
so that the DFT of a vector of size N can be processed efficiently. In the current implementation N
= 2 ^p^ \* 3 ^q^ \* 5 ^r^ for some integer p, q, r.
<p>
The function returns a negative number if vecsize is too large (very close to INT_MAX ).
<p>
While the function cannot be used directly to estimate the optimal vector size for DCT transform
(since the current DCT implementation supports only even-size vectors), it can be easily processed
as getOptimalDFTSize((vecsize+1)/2)\*2.
@param vecsize vector size.
@see dft , dct , idft , idct , mulSpectrums
*/
@Namespace("cv") public static native int getOptimalDFTSize(int vecsize);

/** \brief Returns the default random number generator.
<p>
The function cv::theRNG returns the default random number generator. For each thread, there is a
separate random number generator, so you can use the function safely in multi-thread environments.
If you just need to get a single random number using this generator or initialize an array, you can
use randu or randn instead. But if you are going to generate many random numbers inside a loop, it
is much faster to use this function to retrieve the generator and then use RNG::operator _Tp() .
@see RNG, randu, randn
*/
@Namespace("cv") public static native @ByRef RNG theRNG();

/** \brief Sets state of default random number generator.
<p>
The function cv::setRNGSeed sets state of default random number generator to custom value.
@param seed new state for default random number generator
@see RNG, randu, randn
*/
@Namespace("cv") public static native void setRNGSeed(int seed);

/** \brief Generates a single uniformly-distributed random number or an array of random numbers.
<p>
Non-template variant of the function fills the matrix dst with uniformly-distributed
random numbers from the specified range:
<pre>{@code \[\texttt{low} _c  \leq \texttt{dst} (I)_c <  \texttt{high} _c\]}</pre>
@param dst output array of random numbers; the array must be pre-allocated.
@param low inclusive lower boundary of the generated random numbers.
@param high exclusive upper boundary of the generated random numbers.
@see RNG, randn, theRNG
*/
@Namespace("cv") public static native void randu(@ByVal Mat dst, @ByVal Mat low, @ByVal Mat high);
@Namespace("cv") public static native void randu(@ByVal UMat dst, @ByVal UMat low, @ByVal UMat high);
@Namespace("cv") public static native void randu(@ByVal GpuMat dst, @ByVal GpuMat low, @ByVal GpuMat high);

/** \brief Fills the array with normally distributed random numbers.
<p>
The function cv::randn fills the matrix dst with normally distributed random numbers with the specified
mean vector and the standard deviation matrix. The generated random numbers are clipped to fit the
value range of the output array data type.
@param dst output array of random numbers; the array must be pre-allocated and have 1 to 4 channels.
@param mean mean value (expectation) of the generated random numbers.
@param stddev standard deviation of the generated random numbers; it can be either a vector (in
which case a diagonal standard deviation matrix is assumed) or a square matrix.
@see RNG, randu
*/
@Namespace("cv") public static native void randn(@ByVal Mat dst, @ByVal Mat mean, @ByVal Mat stddev);
@Namespace("cv") public static native void randn(@ByVal UMat dst, @ByVal UMat mean, @ByVal UMat stddev);
@Namespace("cv") public static native void randn(@ByVal GpuMat dst, @ByVal GpuMat mean, @ByVal GpuMat stddev);

/** \brief Shuffles the array elements randomly.
<p>
The function cv::randShuffle shuffles the specified 1D array by randomly choosing pairs of elements and
swapping them. The number of such swap operations will be dst.rows\*dst.cols\*iterFactor .
@param dst input/output numerical 1D array.
@param iterFactor scale factor that determines the number of random swap operations (see the details
below).
@param rng optional random number generator used for shuffling; if it is zero, theRNG () is used
instead.
@see RNG, sort
*/
@Namespace("cv") public static native void randShuffle(@ByVal Mat dst, double iterFactor/*=1.*/, RNG rng/*=0*/);
@Namespace("cv") public static native void randShuffle(@ByVal Mat dst);
@Namespace("cv") public static native void randShuffle(@ByVal UMat dst, double iterFactor/*=1.*/, RNG rng/*=0*/);
@Namespace("cv") public static native void randShuffle(@ByVal UMat dst);
@Namespace("cv") public static native void randShuffle(@ByVal GpuMat dst, double iterFactor/*=1.*/, RNG rng/*=0*/);
@Namespace("cv") public static native void randShuffle(@ByVal GpuMat dst);
// Targeting ..\opencv_core\PCA.java


// Targeting ..\opencv_core\LDA.java


// Targeting ..\opencv_core\SVD.java


// Targeting ..\opencv_core\RNG.java


// Targeting ..\opencv_core\RNG_MT19937.java



/** \} core_array
 <p>
 *  \addtogroup core_cluster
 *   \{
<p>
/** \example samples/cpp/kmeans.cpp
An example on K-means clustering
*/

/** \brief Finds centers of clusters and groups input samples around the clusters.
<p>
The function kmeans implements a k-means algorithm that finds the centers of cluster_count clusters
and groups the input samples around the clusters. As an output, {@code \texttt{bestLabels}_i} contains a
0-based cluster index for the sample stored in the {@code i^{th}} row of the samples matrix.
<p>
\note
-   (Python) An example on K-means clustering can be found at
    opencv_source_code/samples/python/kmeans.py
@param data Data for clustering. An array of N-Dimensional points with float coordinates is needed.
Examples of this array can be:
-   Mat points(count, 2, CV_32F);
-   Mat points(count, 1, CV_32FC2);
-   Mat points(1, count, CV_32FC2);
-   std::vector\<cv::Point2f\> points(sampleCount);
@param K Number of clusters to split the set by.
@param bestLabels Input/output integer array that stores the cluster indices for every sample.
@param criteria The algorithm termination criteria, that is, the maximum number of iterations and/or
the desired accuracy. The accuracy is specified as criteria.epsilon. As soon as each of the cluster
centers moves by less than criteria.epsilon on some iteration, the algorithm stops.
@param attempts Flag to specify the number of times the algorithm is executed using different
initial labellings. The algorithm returns the labels that yield the best compactness (see the last
function parameter).
@param flags Flag that can take values of cv::KmeansFlags
@param centers Output matrix of the cluster centers, one row per each cluster center.
@return The function returns the compactness measure that is computed as
<pre>{@code \[\sum _i  \| \texttt{samples} _i -  \texttt{centers} _{ \texttt{labels} _i} \| ^2\]}</pre>
after every attempt. The best (minimum) value is chosen and the corresponding labels and the
compactness value are returned by the function. Basically, you can use only the core of the
function, set the number of attempts to 1, initialize labels each time using a custom algorithm,
pass them with the ( flags = #KMEANS_USE_INITIAL_LABELS ) flag, and then choose the best
(most-compact) clustering.
*/
@Namespace("cv") public static native double kmeans( @ByVal Mat data, int K, @ByVal Mat bestLabels,
                            @ByVal TermCriteria criteria, int attempts,
                            int flags, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat centers );
@Namespace("cv") public static native double kmeans( @ByVal Mat data, int K, @ByVal Mat bestLabels,
                            @ByVal TermCriteria criteria, int attempts,
                            int flags );
@Namespace("cv") public static native double kmeans( @ByVal UMat data, int K, @ByVal UMat bestLabels,
                            @ByVal TermCriteria criteria, int attempts,
                            int flags, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat centers );
@Namespace("cv") public static native double kmeans( @ByVal UMat data, int K, @ByVal UMat bestLabels,
                            @ByVal TermCriteria criteria, int attempts,
                            int flags );
@Namespace("cv") public static native double kmeans( @ByVal GpuMat data, int K, @ByVal GpuMat bestLabels,
                            @ByVal TermCriteria criteria, int attempts,
                            int flags, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat centers );
@Namespace("cv") public static native double kmeans( @ByVal GpuMat data, int K, @ByVal GpuMat bestLabels,
                            @ByVal TermCriteria criteria, int attempts,
                            int flags );
// Targeting ..\opencv_core\Formatted.java


// Targeting ..\opencv_core\Formatter.java



@Namespace("cv") public static native @Str @Name("operator <<") BytePointer shiftLeft(@Str BytePointer out, @Ptr Formatted fmtd);
@Namespace("cv") public static native @Str @Name("operator <<") String shiftLeft(@Str String out, @Ptr Formatted fmtd);

@Namespace("cv") public static native @Str @Name("operator <<") BytePointer shiftLeft(@Str BytePointer out, @Const @ByRef Mat mtx);
@Namespace("cv") public static native @Str @Name("operator <<") String shiftLeft(@Str String out, @Const @ByRef Mat mtx);

//////////////////////////////////////// Algorithm ////////////////////////////////////
// Targeting ..\opencv_core\Algorithm.java



/** enum struct cv::Param */
public static final int
    INT = 0, BOOLEAN = 1, REAL = 2, STRING = 3, MAT = 4, MAT_VECTOR = 5, ALGORITHM = 6, FLOAT = 7,
    UNSIGNED_INT = 8, UINT64 = 9, UCHAR = 11, SCALAR = 12;

/** \} core_basic */

 //namespace cv

// #include "opencv2/core/operations.hpp"
// #include "opencv2/core/cvstd.inl.hpp"
// #include "opencv2/core/utility.hpp"
// #include "opencv2/core/optim.hpp"
// #include "opencv2/core/ovx.hpp"

// #endif /*OPENCV_CORE_HPP*/


// Parsed from <opencv2/core/cuda.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_CUDA_HPP
// #define OPENCV_CORE_CUDA_HPP

// #ifndef __cplusplus
// #endif

// #include "opencv2/core.hpp"
// #include "opencv2/core/cuda_types.hpp"

/**
  \defgroup cuda CUDA-accelerated Computer Vision
  \{
    \defgroup cudacore Core part
    \{
      \defgroup cudacore_init Initialization and Information
      \defgroup cudacore_struct Data Structures
    \}
  \}
 */
// Targeting ..\opencv_core\GpuMat.java


// Targeting ..\opencv_core\GpuData.java


// Targeting ..\opencv_core\GpuMatND.java



/** \brief Creates a continuous matrix.
<p>
@param rows Row count.
@param cols Column count.
@param type Type of the matrix.
@param arr Destination matrix. This parameter changes only if it has a proper type and area (
{@code \texttt{rows} \times \texttt{cols}} ).
<p>
Matrix is called continuous if its elements are stored continuously, that is, without gaps at the
end of each row.
 */
@Namespace("cv::cuda") public static native void createContinuous(int rows, int cols, int type, @ByVal Mat arr);
@Namespace("cv::cuda") public static native void createContinuous(int rows, int cols, int type, @ByVal UMat arr);
@Namespace("cv::cuda") public static native void createContinuous(int rows, int cols, int type, @ByVal GpuMat arr);

/** \brief Ensures that the size of a matrix is big enough and the matrix has a proper type.
<p>
@param rows Minimum desired number of rows.
@param cols Minimum desired number of columns.
@param type Desired matrix type.
@param arr Destination matrix.
<p>
The function does not reallocate memory if the matrix has proper attributes already.
 */
@Namespace("cv::cuda") public static native void ensureSizeIsEnough(int rows, int cols, int type, @ByVal Mat arr);
@Namespace("cv::cuda") public static native void ensureSizeIsEnough(int rows, int cols, int type, @ByVal UMat arr);
@Namespace("cv::cuda") public static native void ensureSizeIsEnough(int rows, int cols, int type, @ByVal GpuMat arr);

/** \brief Bindings overload to create a GpuMat from existing GPU memory.
@param rows Row count.
@param cols Column count.
@param type Type of the matrix.
@param cudaMemoryAddress Address of the allocated GPU memory on the device. This does not allocate matrix data. Instead, it just initializes the matrix header that points to the specified \a cudaMemoryAddress, which means that no data is copied. This operation is very efficient and can be used to process external data using OpenCV functions. The external data is not automatically deallocated, so you should take care of it.
@param step Number of bytes each matrix row occupies. The value should include the padding bytes at the end of each row, if any. If the parameter is missing (set to Mat::AUTO_STEP ), no padding is assumed and the actual step is calculated as cols*elemSize(). See GpuMat::elemSize.
\note Overload for generation of bindings only, not exported or intended for use internally from C++.
 */
@Namespace("cv::cuda") public static native @ByVal GpuMat createGpuMatFromCudaMemory(int rows, int cols, int type, @Cast("size_t") long cudaMemoryAddress, @Cast("size_t") long step/*=cv::Mat::AUTO_STEP*/);
@Namespace("cv::cuda") public static native @ByVal GpuMat createGpuMatFromCudaMemory(int rows, int cols, int type, @Cast("size_t") long cudaMemoryAddress);

 /** \overload
@param size 2D array size: Size(cols, rows). In the Size() constructor, the number of rows and the number of columns go in the reverse order.
@param type Type of the matrix.
@param cudaMemoryAddress Address of the allocated GPU memory on the device. This does not allocate matrix data. Instead, it just initializes the matrix header that points to the specified \a cudaMemoryAddress, which means that no data is copied. This operation is very efficient and can be used to process external data using OpenCV functions. The external data is not automatically deallocated, so you should take care of it.
@param step Number of bytes each matrix row occupies. The value should include the padding bytes at the end of each row, if any. If the parameter is missing (set to Mat::AUTO_STEP ), no padding is assumed and the actual step is calculated as cols*elemSize(). See GpuMat::elemSize.
\note Overload for generation of bindings only, not exported or intended for use internally from C++.
 */
@Namespace("cv::cuda") public static native @ByVal GpuMat createGpuMatFromCudaMemory(@ByVal Size size, int type, @Cast("size_t") long cudaMemoryAddress, @Cast("size_t") long step/*=cv::Mat::AUTO_STEP*/);
@Namespace("cv::cuda") public static native @ByVal GpuMat createGpuMatFromCudaMemory(@ByVal Size size, int type, @Cast("size_t") long cudaMemoryAddress);
// Targeting ..\opencv_core\BufferPool.java



/** BufferPool management (must be called before Stream creation) */
@Namespace("cv::cuda") public static native void setBufferPoolUsage(@Cast("bool") boolean on);
@Namespace("cv::cuda") public static native void setBufferPoolConfig(int deviceId, @Cast("size_t") long stackSize, int stackCount);
// Targeting ..\opencv_core\HostMem.java



/** \brief Page-locks the memory of matrix and maps it for the device(s).
<p>
@param m Input matrix.
 */
@Namespace("cv::cuda") public static native void registerPageLocked(@ByRef Mat m);

/** \brief Unmaps the memory of matrix and makes it pageable again.
<p>
@param m Input matrix.
 */
@Namespace("cv::cuda") public static native void unregisterPageLocked(@ByRef Mat m);
// Targeting ..\opencv_core\Stream.java




/** \brief Bindings overload to create a Stream object from the address stored in an existing CUDA Runtime API stream pointer (cudaStream_t).
@param cudaStreamMemoryAddress Memory address stored in a CUDA Runtime API stream pointer (cudaStream_t). The created Stream object does not perform any allocation or deallocation and simply wraps existing raw CUDA Runtime API stream pointer.
\note Overload for generation of bindings only, not exported or intended for use internally from C++.
 */
@Namespace("cv::cuda") public static native @ByVal Stream wrapStream(@Cast("size_t") long cudaStreamMemoryAddress);
// Targeting ..\opencv_core\Event.java


@Namespace("cv::cuda") public static native @Cast("bool") @Name("operator !") boolean not(@Cast("const cv::cuda::Event::CreateFlags") int val);

@Namespace("cv::cuda") public static native @Cast("bool") @Name("operator ==") boolean equals(@Cast("const cv::cuda::Event::CreateFlags") int a, int b);

@Namespace("cv::cuda") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Cast("const cv::cuda::Event::CreateFlags") int a, int b);


@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags") @Name("operator |") int or(@Cast("const cv::cuda::Event::CreateFlags") int a, @Cast("const cv::cuda::Event::CreateFlags") int b);

@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags") @Name("operator &") int and(@Cast("const cv::cuda::Event::CreateFlags") int a, @Cast("const cv::cuda::Event::CreateFlags") int b);

@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags") @Name("operator ^") int xor(@Cast("const cv::cuda::Event::CreateFlags") int a, @Cast("const cv::cuda::Event::CreateFlags") int b);


@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator |=") IntPointer orPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef IntPointer _this, @Cast("const cv::cuda::Event::CreateFlags") int val);
@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator |=") IntBuffer orPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef IntBuffer _this, @Cast("const cv::cuda::Event::CreateFlags") int val);
@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator |=") int[] orPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef int[] _this, @Cast("const cv::cuda::Event::CreateFlags") int val);

@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator &=") IntPointer andPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef IntPointer _this, @Cast("const cv::cuda::Event::CreateFlags") int val);
@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator &=") IntBuffer andPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef IntBuffer _this, @Cast("const cv::cuda::Event::CreateFlags") int val);
@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator &=") int[] andPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef int[] _this, @Cast("const cv::cuda::Event::CreateFlags") int val);

@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator ^=") IntPointer xorPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef IntPointer _this, @Cast("const cv::cuda::Event::CreateFlags") int val);
@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator ^=") IntBuffer xorPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef IntBuffer _this, @Cast("const cv::cuda::Event::CreateFlags") int val);
@Namespace("cv::cuda") public static native @Cast("cv::cuda::Event::CreateFlags*") @ByRef @Name("operator ^=") int[] xorPut(@Cast("cv::cuda::Event::CreateFlags*") @ByRef int[] _this, @Cast("const cv::cuda::Event::CreateFlags") int val);



/** \} cudacore_struct */

//===================================================================================
// Initialization & Info
//===================================================================================

/** \addtogroup cudacore_init
/** \{
<p>
/** \brief Returns the number of installed CUDA-enabled devices.
<p>
Use this function before any other CUDA functions calls. If OpenCV is compiled without CUDA support,
this function returns 0. If the CUDA driver is not installed, or is incompatible, this function
returns -1.
 */
@Namespace("cv::cuda") public static native int getCudaEnabledDeviceCount();

/** \brief Sets a device and initializes it for the current thread.
<p>
@param device System index of a CUDA device starting with 0.
<p>
If the call of this function is omitted, a default device is initialized at the fist CUDA usage.
 */
@Namespace("cv::cuda") public static native void setDevice(int device);

/** \brief Returns the current device index set by cuda::setDevice or initialized by default.
 */
@Namespace("cv::cuda") public static native int getDevice();

/** \brief Explicitly destroys and cleans up all resources associated with the current device in the current
process.
<p>
Any subsequent API call to this device will reinitialize the device.
 */
@Namespace("cv::cuda") public static native void resetDevice();

/** \brief Enumeration providing CUDA computing features.
 */
/** enum cv::cuda::FeatureSet */
public static final int
    FEATURE_SET_COMPUTE_10 = 10,
    FEATURE_SET_COMPUTE_11 = 11,
    FEATURE_SET_COMPUTE_12 = 12,
    FEATURE_SET_COMPUTE_13 = 13,
    FEATURE_SET_COMPUTE_20 = 20,
    FEATURE_SET_COMPUTE_21 = 21,
    FEATURE_SET_COMPUTE_30 = 30,
    FEATURE_SET_COMPUTE_32 = 32,
    FEATURE_SET_COMPUTE_35 = 35,
    FEATURE_SET_COMPUTE_50 = 50,

    GLOBAL_ATOMICS = FEATURE_SET_COMPUTE_11,
    SHARED_ATOMICS = FEATURE_SET_COMPUTE_12,
    NATIVE_DOUBLE = FEATURE_SET_COMPUTE_13,
    WARP_SHUFFLE_FUNCTIONS = FEATURE_SET_COMPUTE_30,
    DYNAMIC_PARALLELISM = FEATURE_SET_COMPUTE_35;

/** checks whether current device supports the given feature */
@Namespace("cv::cuda") public static native @Cast("bool") boolean deviceSupports(@Cast("cv::cuda::FeatureSet") int feature_set);
// Targeting ..\opencv_core\TargetArchs.java


// Targeting ..\opencv_core\DeviceInfo.java



@Namespace("cv::cuda") public static native void printCudaDeviceInfo(int device);
@Namespace("cv::cuda") public static native void printShortCudaDeviceInfo(int device);

/** \brief Converts an array to half precision floating number.
<p>
@param _src input array.
@param _dst output array.
@param stream Stream for the asynchronous version.
@see convertFp16
*/


/** \} cudacore_init */

 // namespace cv { namespace cuda {


// #include "opencv2/core/cuda.inl.hpp"

// #endif /* OPENCV_CORE_CUDA_HPP */


// Parsed from <opencv2/core/ocl.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the OpenCV Foundation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_OPENCL_HPP
// #define OPENCV_OPENCL_HPP

// #include "opencv2/core.hpp"
// #include <typeinfo>
// #include <typeindex>

/** \addtogroup core_opencl
 *  \{ */

@Namespace("cv::ocl") public static native @Cast("bool") boolean haveOpenCL();
@Namespace("cv::ocl") public static native @Cast("bool") boolean useOpenCL();
@Namespace("cv::ocl") public static native @Cast("bool") boolean haveAmdBlas();
@Namespace("cv::ocl") public static native @Cast("bool") boolean haveAmdFft();
@Namespace("cv::ocl") public static native void setUseOpenCL(@Cast("bool") boolean flag);
@Namespace("cv::ocl") public static native void finish();

@Namespace("cv::ocl") public static native @Cast("bool") boolean haveSVM();
// Targeting ..\opencv_core\Device.java


// Targeting ..\opencv_core\Context.java


// Targeting ..\opencv_core\OclPlatform.java



/** \brief Attaches OpenCL context to OpenCV
\note
  OpenCV will check if available OpenCL platform has platformName name, then assign context to
  OpenCV and call {@code clRetainContext} function. The deviceID device will be used as target device and
  new command queue will be created.
@param platformName name of OpenCL platform to attach, this string is used to check if platform is available to OpenCV at runtime
@param platformID ID of platform attached context was created for
@param context OpenCL context to be attached to OpenCV
@param deviceID ID of device, must be created from attached context
*/
@Namespace("cv::ocl") public static native void attachContext(@Str BytePointer platformName, Pointer platformID, Pointer context, Pointer deviceID);
@Namespace("cv::ocl") public static native void attachContext(@Str String platformName, Pointer platformID, Pointer context, Pointer deviceID);

/** \brief Convert OpenCL buffer to UMat
\note
  OpenCL buffer (cl_mem_buffer) should contain 2D image data, compatible with OpenCV. Memory
  content is not copied from {@code clBuffer} to UMat. Instead, buffer handle assigned to UMat and
  {@code clRetainMemObject} is called.
@param cl_mem_buffer source clBuffer handle
@param step num of bytes in single row
@param rows number of rows
@param cols number of cols
@param type OpenCV type of image
@param dst destination UMat
*/
@Namespace("cv::ocl") public static native void convertFromBuffer(Pointer cl_mem_buffer, @Cast("size_t") long step, int rows, int cols, int type, @ByRef UMat dst);

/** \brief Convert OpenCL image2d_t to UMat
\note
  OpenCL {@code image2d_t} (cl_mem_image), should be compatible with OpenCV UMat formats. Memory content
  is copied from image to UMat with {@code clEnqueueCopyImageToBuffer} function.
@param cl_mem_image source image2d_t handle
@param dst destination UMat
*/
@Namespace("cv::ocl") public static native void convertFromImage(Pointer cl_mem_image, @ByRef UMat dst);

// TODO Move to internal header
/** @deprecated */

// Targeting ..\opencv_core\Queue.java


// Targeting ..\opencv_core\KernelArg.java


// Targeting ..\opencv_core\Kernel.java


// Targeting ..\opencv_core\Program.java


// Targeting ..\opencv_core\ProgramSource.java


// Targeting ..\opencv_core\PlatformInfo.java



@Namespace("cv::ocl") public static native @Deprecated @Cast("const char*") BytePointer convertTypeStr(int sdepth, int ddepth, int cn, @Cast("char*") BytePointer buf);
@Namespace("cv::ocl") public static native @Deprecated String convertTypeStr(int sdepth, int ddepth, int cn, @Cast("char*") ByteBuffer buf);
@Namespace("cv::ocl") public static native @Deprecated @Cast("const char*") BytePointer convertTypeStr(int sdepth, int ddepth, int cn, @Cast("char*") byte[] buf);
@Namespace("cv::ocl") public static native @Cast("const char*") BytePointer convertTypeStr(int sdepth, int ddepth, int cn, @Cast("char*") BytePointer buf, @Cast("size_t") long buf_size);
@Namespace("cv::ocl") public static native String convertTypeStr(int sdepth, int ddepth, int cn, @Cast("char*") ByteBuffer buf, @Cast("size_t") long buf_size);
@Namespace("cv::ocl") public static native @Cast("const char*") BytePointer convertTypeStr(int sdepth, int ddepth, int cn, @Cast("char*") byte[] buf, @Cast("size_t") long buf_size);
@Namespace("cv::ocl") public static native @Cast("const char*") BytePointer typeToStr(int t);
@Namespace("cv::ocl") public static native @Cast("const char*") BytePointer memopTypeToStr(int t);
@Namespace("cv::ocl") public static native @Cast("const char*") BytePointer vecopTypeToStr(int t);
@Namespace("cv::ocl") public static native @Cast("const char*") BytePointer getOpenCLErrorString(int errorCode);
@Namespace("cv::ocl") public static native @Str BytePointer kernelToStr(@ByVal Mat _kernel, int ddepth/*=-1*/, @Cast("const char*") BytePointer name/*=NULL*/);
@Namespace("cv::ocl") public static native @Str BytePointer kernelToStr(@ByVal Mat _kernel);
@Namespace("cv::ocl") public static native @Str String kernelToStr(@ByVal Mat _kernel, int ddepth/*=-1*/, String name/*=NULL*/);
@Namespace("cv::ocl") public static native @Str String kernelToStr(@ByVal UMat _kernel, int ddepth/*=-1*/, String name/*=NULL*/);
@Namespace("cv::ocl") public static native @Str String kernelToStr(@ByVal UMat _kernel);
@Namespace("cv::ocl") public static native @Str BytePointer kernelToStr(@ByVal UMat _kernel, int ddepth/*=-1*/, @Cast("const char*") BytePointer name/*=NULL*/);
@Namespace("cv::ocl") public static native @Str BytePointer kernelToStr(@ByVal GpuMat _kernel, int ddepth/*=-1*/, @Cast("const char*") BytePointer name/*=NULL*/);
@Namespace("cv::ocl") public static native @Str BytePointer kernelToStr(@ByVal GpuMat _kernel);
@Namespace("cv::ocl") public static native @Str String kernelToStr(@ByVal GpuMat _kernel, int ddepth/*=-1*/, String name/*=NULL*/);
@Namespace("cv::ocl") public static native void getPlatfomsInfo(@StdVector PlatformInfo platform_info);


/** enum cv::ocl::OclVectorStrategy */
public static final int
    // all matrices have its own vector width
    OCL_VECTOR_OWN = 0,
    // all matrices have maximal vector width among all matrices
    // (useful for cases when matrices have different data types)
    OCL_VECTOR_MAX = 1,

    // default strategy
    OCL_VECTOR_DEFAULT = OCL_VECTOR_OWN;

@Namespace("cv::ocl") public static native int predictOptimalVectorWidth(@ByVal Mat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src3,
                                         @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src6,
                                         @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src9,
                                         @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidth(@ByVal Mat src1);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidth(@ByVal UMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src3,
                                         @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src6,
                                         @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src9,
                                         @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidth(@ByVal UMat src1);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidth(@ByVal GpuMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src3,
                                         @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src6,
                                         @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src9,
                                         @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidth(@ByVal GpuMat src1);

@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntPointer vectorWidths,
                                       @ByVal Mat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntPointer vectorWidths,
                                       @ByVal Mat src1);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntBuffer vectorWidths,
                                       @ByVal Mat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntBuffer vectorWidths,
                                       @ByVal Mat src1);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const int[] vectorWidths,
                                       @ByVal Mat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const int[] vectorWidths,
                                       @ByVal Mat src1);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntPointer vectorWidths,
                                       @ByVal UMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntPointer vectorWidths,
                                       @ByVal UMat src1);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntBuffer vectorWidths,
                                       @ByVal UMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntBuffer vectorWidths,
                                       @ByVal UMat src1);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const int[] vectorWidths,
                                       @ByVal UMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const int[] vectorWidths,
                                       @ByVal UMat src1);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntPointer vectorWidths,
                                       @ByVal GpuMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntPointer vectorWidths,
                                       @ByVal GpuMat src1);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntBuffer vectorWidths,
                                       @ByVal GpuMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const IntBuffer vectorWidths,
                                       @ByVal GpuMat src1);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const int[] vectorWidths,
                                       @ByVal GpuMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src3,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src6,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src9,
                                       @Cast("cv::ocl::OclVectorStrategy") int strat/*=cv::ocl::OCL_VECTOR_DEFAULT*/);
@Namespace("cv::ocl") public static native int checkOptimalVectorWidth(@Const int[] vectorWidths,
                                       @ByVal GpuMat src1);

// with OCL_VECTOR_MAX strategy
@Namespace("cv::ocl") public static native int predictOptimalVectorWidthMax(@ByVal Mat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src3,
                                            @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src6,
                                            @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat src9);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidthMax(@ByVal Mat src1);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidthMax(@ByVal UMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src3,
                                            @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src6,
                                            @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat src9);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidthMax(@ByVal UMat src1);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidthMax(@ByVal GpuMat src1, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src2, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src3,
                                            @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src4, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src5, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src6,
                                            @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src7, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src8, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat src9);
@Namespace("cv::ocl") public static native int predictOptimalVectorWidthMax(@ByVal GpuMat src1);

@Namespace("cv::ocl") public static native void buildOptionsAddMatrixDescription(@Str BytePointer buildOptions, @Str BytePointer name, @ByVal Mat _m);
@Namespace("cv::ocl") public static native void buildOptionsAddMatrixDescription(@Str String buildOptions, @Str String name, @ByVal Mat _m);
@Namespace("cv::ocl") public static native void buildOptionsAddMatrixDescription(@Str String buildOptions, @Str String name, @ByVal UMat _m);
@Namespace("cv::ocl") public static native void buildOptionsAddMatrixDescription(@Str BytePointer buildOptions, @Str BytePointer name, @ByVal UMat _m);
@Namespace("cv::ocl") public static native void buildOptionsAddMatrixDescription(@Str BytePointer buildOptions, @Str BytePointer name, @ByVal GpuMat _m);
@Namespace("cv::ocl") public static native void buildOptionsAddMatrixDescription(@Str String buildOptions, @Str String name, @ByVal GpuMat _m);
// Targeting ..\opencv_core\Image2D.java


// Targeting ..\opencv_core\Timer.java



@Namespace("cv::ocl") public static native MatAllocator getOpenCLAllocator();
// Targeting ..\opencv_core\OpenCLExecutionContext.java


// Targeting ..\opencv_core\OpenCLExecutionContextScope.java



// #ifdef __OPENCV_BUILD
// #endif

/** \} */



// #endif


// Parsed from <opencv2/core/operations.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Copyright (C) 2015, Itseez Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_OPERATIONS_HPP
// #define OPENCV_CORE_OPERATIONS_HPP

// #ifndef __cplusplus
// #endif

// #include <cstdio>

// #if defined(__GNUC__) || defined(__clang__) // at least GCC 3.1+, clang 3.5+
// #  if defined(__MINGW_PRINTF_FORMAT)  // https://sourceforge.net/p/mingw-w64/wiki2/gnu%20printf/.
// #    define CV_FORMAT_PRINTF(string_idx, first_to_check) __attribute__ ((format (__MINGW_PRINTF_FORMAT, string_idx, first_to_check)))
// #  else
// #    define CV_FORMAT_PRINTF(string_idx, first_to_check) __attribute__ ((format (printf, string_idx, first_to_check)))
// #  endif
// #else
// #  define CV_FORMAT_PRINTF(A, B)
// #endif
/** \cond IGNORED
<p>
<p>
////////////////////////////// Matx methods depending on core API ///////////////////////////// */

 // internal















////////////////////////// Augmenting algebraic & logical operations //////////////////////////

// #define CV_MAT_AUG_OPERATOR1(op, cvop, A, B)
//     static inline A& operator op (A& a, const B& b) { cvop; return a; }

// #define CV_MAT_AUG_OPERATOR(op, cvop, A, B)
//     CV_MAT_AUG_OPERATOR1(op, cvop, A, B)
//     CV_MAT_AUG_OPERATOR1(op, cvop, const A, B)

// #define CV_MAT_AUG_OPERATOR_T(op, cvop, A, B)
//     template<typename _Tp> CV_MAT_AUG_OPERATOR1(op, cvop, A, B)
//     template<typename _Tp> CV_MAT_AUG_OPERATOR1(op, cvop, const A, B)

// #define CV_MAT_AUG_OPERATOR_TN(op, cvop, A)
//     template<typename _Tp, int m, int n> static inline A& operator op (A& a, const Matx<_Tp,m,n>& b) { cvop; return a; }
//     template<typename _Tp, int m, int n> static inline const A& operator op (const A& a, const Matx<_Tp,m,n>& b) { cvop; return a; }

@Namespace("cv") public static native @ByRef @Name("operator +=") Mat addPut(  @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByRef @Name("operator +=") Mat addPut(  @ByRef Mat a, @Const @ByRef Scalar b);

@Namespace("cv") public static native @ByRef @Name("operator -=") Mat subtractPut(  @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByRef @Name("operator -=") Mat subtractPut(  @ByRef Mat a, @Const @ByRef Scalar b);

@Namespace("cv") public static native @ByRef @Name("operator *=") Mat multiplyPut(  @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByRef @Name("operator *=") Mat multiplyPut(  @ByRef Mat a, double b);

@Namespace("cv") public static native @ByRef @Name("operator /=") Mat dividePut(  @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByRef @Name("operator /=") Mat dividePut(  @ByRef Mat a, double b);

@Namespace("cv") public static native @ByRef @Name("operator &=") Mat andPut(  @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByRef @Name("operator &=") Mat andPut(  @ByRef Mat a, @Const @ByRef Scalar b);

@Namespace("cv") public static native @ByRef @Name("operator |=") Mat orPut(  @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByRef @Name("operator |=") Mat orPut(  @ByRef Mat a, @Const @ByRef Scalar b);

@Namespace("cv") public static native @ByRef @Name("operator ^=") Mat xorPut(  @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByRef @Name("operator ^=") Mat xorPut(  @ByRef Mat a, @Const @ByRef Scalar b);

// #undef CV_MAT_AUG_OPERATOR_TN
// #undef CV_MAT_AUG_OPERATOR_T
// #undef CV_MAT_AUG_OPERATOR
// #undef CV_MAT_AUG_OPERATOR1



///////////////////////////////////////////// SVD /////////////////////////////////////////////













/////////////////////////////////// Multiply-with-Carry RNG ///////////////////////////////////
























/** returns the next uniformly-distributed random number of the specified type */
@Namespace("cv") public static native @Name("randu<int>") int intRand();
@Namespace("cv") public static native @Name("randu<float>") float floatRand();
@Namespace("cv") public static native @Name("randu<double>") double doubleRand();


///////////////////////////////// Formatted output of cv::Mat /////////////////////////////////

@Namespace("cv") public static native @Ptr Formatted format(@ByVal Mat mtx, @Cast("cv::Formatter::FormatType") int fmt);
@Namespace("cv") public static native @Ptr Formatted format(@ByVal UMat mtx, @Cast("cv::Formatter::FormatType") int fmt);
@Namespace("cv") public static native @Ptr Formatted format(@ByVal GpuMat mtx, @Cast("cv::Formatter::FormatType") int fmt);

@Namespace("cv") public static native int print(@Ptr Formatted fmtd, @Cast("FILE*") Pointer stream/*=stdout*/);
@Namespace("cv") public static native int print(@Ptr Formatted fmtd);

@Namespace("cv") public static native int print(@Const @ByRef Mat mtx, @Cast("FILE*") Pointer stream/*=stdout*/);
@Namespace("cv") public static native int print(@Const @ByRef Mat mtx);

@Namespace("cv") public static native int print(@Const @ByRef UMat mtx, @Cast("FILE*") Pointer stream/*=stdout*/);
@Namespace("cv") public static native int print(@Const @ByRef UMat mtx);

/** \endcond
<p>
///////////////////////////////// Formatted string generation /////////////////////////////////
<p>
/** \brief Returns a text string formatted using the printf-like expression.
<p>
The function acts like sprintf but forms and returns an STL string. It can be used to form an error
message in the Exception constructor.
@param fmt printf-compatible formatting specifiers.
<p>
**Note**:
|Type|Specifier|
|-|-|
|{@code const char*}|{@code %s}|
|{@code char}|{@code %c}|
|{@code float} / {@code double}|{@code %f},{@code %g}|
|{@code int}, {@code long}, {@code long long}|{@code %d}, {@code %ld}, {@code }%lld{@code |
|}unsigned{@code , }unsigned long{@code , }unsigned long long{@code |}%u{@code , }%lu{@code , }%llu{@code |
|}uint64{@code  -> }uintmax_t{@code , }int64{@code  -> }intmax_t{@code |}%ju{@code , }%jd{@code |
|}size_t{@code |}%zu{@code |
@ingroup core_utils
 */
@Namespace("cv") public static native @Str BytePointer format(@Cast("const char*") BytePointer fmt);
@Namespace("cv") public static native @Str String format(String fmt);

/****************************************************************************************\
*                                  Auxiliary algorithms                                  *
\****************************************************************************************/

/** \brief Splits an element set into equivalency classes.
<p>
The generic function partition implements an {@code O(N^2)} algorithm for splitting a set of {@code N} elements
into one or more equivalency classes, as described in
<http://en.wikipedia.org/wiki/Disjoint-set_data_structure> . The function returns the number of
equivalency classes.
@param _vec Set of elements stored as a vector.
@param labels Output vector of labels. It contains as many elements as vec. Each label labels[i] is
a 0-based cluster index of {@code vec[i]}.
@param predicate Equivalence predicate (pointer to a boolean function of two arguments or an
instance of the class that has the method bool operator()(const _Tp& a, const _Tp& b) ). The
predicate returns true when the elements are certainly in the same class, and returns false if they
may or may not be in the same class.
\ingroup core_cluster
*/

 // cv

// #endif


// Parsed from <opencv2/core/bufferpool.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.
//
// Copyright (C) 2014, Advanced Micro Devices, Inc., all rights reserved.

// #ifndef OPENCV_CORE_BUFFER_POOL_HPP
// #define OPENCV_CORE_BUFFER_POOL_HPP

// #ifdef _MSC_VER
// #pragma warning(push)
// #pragma warning(disable: 4265)
// #endif
// Targeting ..\opencv_core\BufferPoolController.java



/** \} */



// #ifdef _MSC_VER
// #pragma warning(pop)
// #endif

// #endif // OPENCV_CORE_BUFFER_POOL_HPP


// Parsed from <opencv2/core/mat.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_MAT_HPP
// #define OPENCV_CORE_MAT_HPP

// #ifndef __cplusplus
// #endif

// #include "opencv2/core/matx.hpp"
// #include "opencv2/core/types.hpp"

// #include "opencv2/core/bufferpool.hpp"

// #include <type_traits>

/** \addtogroup core_basic
 *  \{ */

/** enum cv::AccessFlag */
public static final int ACCESS_READ = 1<<24, ACCESS_WRITE = 1<<25,
    ACCESS_RW = 3<<24, ACCESS_MASK = ACCESS_RW, ACCESS_FAST = 1<<26;













//////////////////////// Input/Output Array Arguments /////////////////////////////////

/** \brief This is the proxy class for passing read-only input arrays into OpenCV functions.
<p>
It is defined as:
<pre>{@code
    typedef const _InputArray& InputArray;
}</pre>
where _InputArray is a class that can be constructed from {@code Mat}, {@code Mat_<T>}, {@code Matx<T, m, n>},
{@code std::vector<T>}, {@code std::vector<std::vector<T> >}, {@code std::vector<Mat>}, {@code std::vector<Mat_<T> >},
{@code UMat}, {@code std::vector<UMat>} or {@code double}. It can also be constructed from a matrix expression.
<p>
Since this is mostly implementation-level class, and its interface may change in future versions, we
do not describe it in details. There are a few key things, though, that should be kept in mind:
<p>
-   When you see in the reference manual or in OpenCV source code a function that takes
    InputArray, it means that you can actually pass {@code Mat}, {@code Matx}, {@code vector<T>} etc. (see above the
    complete list).
-   Optional input arguments: If some of the input arrays may be empty, pass cv::noArray() (or
    simply cv::Mat() as you probably did before).
-   The class is designed solely for passing parameters. That is, normally you *should not*
    declare class members, local and global variables of this type.
-   If you want to design your own function or a class method that can operate of arrays of
    multiple types, you can use InputArray (or OutputArray) for the respective parameters. Inside
    a function you should use _InputArray::getMat() method to construct a matrix header for the
    array (without copying data). _InputArray::kind() can be used to distinguish Mat from
    {@code vector<>} etc., but normally it is not needed.
<p>
Here is how you can use a function that takes InputArray :
<pre>{@code
    std::vector<Point2f> vec;
    // points or a circle
    for( int i = 0; i < 30; i++ )
        vec.push_back(Point2f((float)(100 + 30*cos(i*CV_PI*2/5)),
                              (float)(100 - 30*sin(i*CV_PI*2/5))));
    cv::transform(vec, vec, cv::Matx23f(0.707, -0.707, 10, 0.707, 0.707, 20));
}</pre>
That is, we form an STL vector containing points, and apply in-place affine transformation to the
vector using the 2x3 matrix created inline as {@code Matx<float, 2, 3>} instance.
<p>
Here is how such a function can be implemented (for simplicity, we implement a very specific case of
it, according to the assertion statement inside) :
<pre>{@code
    void myAffineTransform(InputArray _src, OutputArray _dst, InputArray _m)
    {
        // get Mat headers for input arrays. This is O(1) operation,
        // unless _src and/or _m are matrix expressions.
        Mat src = _src.getMat(), m = _m.getMat();
        CV_Assert( src.type() == CV_32FC2 && m.type() == CV_32F && m.size() == Size(3, 2) );

        // [re]create the output array so that it has the proper size and type.
        // In case of Mat it calls Mat::create, in case of STL vector it calls vector::resize.
        _dst.create(src.size(), src.type());
        Mat dst = _dst.getMat();

        for( int i = 0; i < src.rows; i++ )
            for( int j = 0; j < src.cols; j++ )
            {
                Point2f pt = src.at<Point2f>(i, j);
                dst.at<Point2f>(i, j) = Point2f(m.at<float>(0, 0)*pt.x +
                                                m.at<float>(0, 1)*pt.y +
                                                m.at<float>(0, 2),
                                                m.at<float>(1, 0)*pt.x +
                                                m.at<float>(1, 1)*pt.y +
                                                m.at<float>(1, 2));
            }
    }
}</pre>
There is another related type, InputArrayOfArrays, which is currently defined as a synonym for
InputArray:
<pre>{@code
    typedef InputArray InputArrayOfArrays;
}</pre>
It denotes function arguments that are either vectors of vectors or vectors of matrices. A separate
synonym is needed to generate Python/Java etc. wrappers properly. At the function implementation
level their use is similar, but _InputArray::getMat(idx) should be used to get header for the
idx-th component of the outer vector and _InputArray::size().area() should be used to find the
number of components (vectors/matrices) of the outer vector.
<p>
In general, type support is limited to cv::Mat types. Other types are forbidden.
But in some cases we need to support passing of custom non-general Mat types, like arrays of cv::KeyPoint, cv::DMatch, etc.
This data is not intended to be interpreted as an image data, or processed somehow like regular cv::Mat.
To pass such custom type use rawIn() / rawOut() / rawInOut() wrappers.
Custom type is wrapped as Mat-compatible {@code CV_8UC<N>} values (N = sizeof(T), N <= CV_CN_MAX).
 */













/** \brief This type is very similar to InputArray except that it is used for input/output and output function
parameters.
<p>
Just like with InputArray, OpenCV users should not care about OutputArray, they just pass {@code Mat},
{@code vector<T>} etc. to the functions. The same limitation as for {@code InputArray}: *Do not explicitly
create OutputArray instances* applies here too.
<p>
If you want to make your function polymorphic (i.e. accept different arrays as output parameters),
it is also not very difficult. Take the sample above as the reference. Note that
_OutputArray::create() needs to be called before _OutputArray::getMat(). This way you guarantee
that the output array is properly allocated.
<p>
Optional output parameters. If you do not need certain output array to be computed and returned to
you, pass cv::noArray(), just like you would in the case of optional input array. At the
implementation level, use _OutputArray::needed() to check if certain output array needs to be
computed or not.
<p>
There are several synonyms for OutputArray that are used to assist automatic Python/Java/... wrapper
generators:
<pre>{@code
    typedef OutputArray OutputArrayOfArrays;
    typedef OutputArray InputOutputArray;
    typedef OutputArray InputOutputArrayOfArrays;
}</pre>
 */

/** Helper to wrap custom types. @see InputArray */
/** Helper to wrap custom types. @see InputArray */
/** Helper to wrap custom types. @see InputArray */

public static Mat noArray() { return null; }

/////////////////////////////////// MatAllocator //////////////////////////////////////

/** \brief  Usage flags for allocator
 <p>
 \warning  All flags except {@code USAGE_DEFAULT} are experimental.
 <p>
 \warning  For the OpenCL allocator, {@code USAGE_ALLOCATE_SHARED_MEMORY} depends on
 OpenCV's optional, experimental integration with OpenCL SVM. To enable this
 integration, build OpenCV using the {@code WITH_OPENCL_SVM=ON} CMake option and, at
 runtime, call {@code cv::ocl::Context::getDefault().setUseSVM(true);} or similar
 code. Note that SVM is incompatible with OpenCL 1.x.
*/
/** enum cv::UMatUsageFlags */
public static final int
    USAGE_DEFAULT = 0,

    // buffer allocation policy is platform and usage specific
    USAGE_ALLOCATE_HOST_MEMORY = 1 << 0,
    USAGE_ALLOCATE_DEVICE_MEMORY = 1 << 1,
    USAGE_ALLOCATE_SHARED_MEMORY = 1 << 2, // It is not equal to: USAGE_ALLOCATE_HOST_MEMORY | USAGE_ALLOCATE_DEVICE_MEMORY

    __UMAT_USAGE_FLAGS_32BIT = 0x7fffffff; // Binary compatibility hint
// Targeting ..\opencv_core\MatAllocator.java




//////////////////////////////// MatCommaInitializer //////////////////////////////////

/** \brief  Comma-separated Matrix Initializer
 <p>
 The class instances are usually not created explicitly.
 Instead, they are created on "matrix << firstValue" operator.
 <p>
 The sample below initializes 2x2 rotation matrix:
 <p>
 <pre>{@code
 double angle = 30, a = cos(angle*CV_PI/180), b = sin(angle*CV_PI/180);
 Mat R = (Mat_<double>(2,2) << a, -b, b, a);
 }</pre>
*/
// Targeting ..\opencv_core\UMatData.java











// Targeting ..\opencv_core\MatSize.java


// Targeting ..\opencv_core\MatStep.java


// Targeting ..\opencv_core\Mat.java




///////////////////////////////// Mat_<_Tp> ////////////////////////////////////

/** \brief Template matrix class derived from Mat
<p>
<pre>{@code {.cpp}
    template<typename _Tp> class Mat_ : public Mat
    {
    public:
        // ... some specific methods
        //         and
        // no new extra fields
    };
}</pre>
The class {@code Mat_<_Tp>} is a *thin* template wrapper on top of the Mat class. It does not have any
extra data fields. Nor this class nor Mat has any virtual methods. Thus, references or pointers to
these two classes can be freely but carefully converted one to another. For example:
<pre>{@code {.cpp}
    // create a 100x100 8-bit matrix
    Mat M(100,100,CV_8U);
    // this will be compiled fine. no any data conversion will be done.
    Mat_<float>& M1 = (Mat_<float>&)M;
    // the program is likely to crash at the statement below
    M1(99,99) = 1.f;
}</pre>
While Mat is sufficient in most cases, Mat_ can be more convenient if you use a lot of element
access operations and if you know matrix type at the compilation time. Note that
{@code Mat::at(int y,int x)} and {@code Mat_::operator()(int y,int x)} do absolutely the same
and run at the same speed, but the latter is certainly shorter:
<pre>{@code {.cpp}
    Mat_<double> M(20,20);
    for(int i = 0; i < M.rows; i++)
        for(int j = 0; j < M.cols; j++)
            M(i,j) = 1./(i+j+1);
    Mat E, V;
    eigen(M,E,V);
    cout << E.at<double>(0,0)/E.at<double>(M.rows-1,0);
}</pre>
To use Mat_ for multi-channel images/matrices, pass Vec as a Mat_ parameter:
<pre>{@code {.cpp}
    // allocate a 320x240 color image and fill it with green (in RGB space)
    Mat_<Vec3b> img(240, 320, Vec3b(0,255,0));
    // now draw a diagonal white line
    for(int i = 0; i < 100; i++)
        img(i,i)=Vec3b(255,255,255);
    // and now scramble the 2nd (red) channel of each pixel
    for(int i = 0; i < img.rows; i++)
        for(int j = 0; j < img.cols; j++)
            img(i,j)[2] ^= (uchar)(i ^ j);
}</pre>
Mat_ is fully compatible with C++11 range-based for loop. For example such loop
can be used to safely apply look-up table:
<pre>{@code {.cpp}
void applyTable(Mat_<uchar>& I, const uchar* const table)
{
    for(auto& pixel : I)
    {
        pixel = table[pixel];
    }
}
}</pre>
 */
// Targeting ..\opencv_core\UMat.java


// Targeting ..\opencv_core\SparseMat.java





///////////////////////////////// SparseMat_<_Tp> ////////////////////////////////////

/** \brief Template sparse n-dimensional array class derived from SparseMat
<p>
SparseMat_ is a thin wrapper on top of SparseMat created in the same way as Mat_ . It simplifies
notation of some operations:
<pre>{@code
    int sz[] = {10, 20, 30};
    SparseMat_<double> M(3, sz);
    ...
    M.ref(1, 2, 3) = M(4, 5, 6) + M(7, 8, 9);
}</pre>
 */
// Targeting ..\opencv_core\MatConstIterator.java





////////////////////////////////// MatConstIterator_ /////////////////////////////////

/** \brief Matrix read-only iterator
 */



//////////////////////////////////// MatIterator_ ////////////////////////////////////

/** \brief Matrix read-write iterator
*/
// Targeting ..\opencv_core\SparseMatConstIterator.java


// Targeting ..\opencv_core\SparseMatIterator.java





/////////////////////////////// SparseMatConstIterator_ //////////////////////////////

/** \brief  Template Read-Only Sparse Matrix Iterator Class.
 <p>
 This is the derived from SparseMatConstIterator class that
 introduces more convenient operator *() for accessing the current element.
*/



///////////////////////////////// SparseMatIterator_ /////////////////////////////////

/** \brief  Template Read-Write Sparse Matrix Iterator Class.
 <p>
 This is the derived from cv::SparseMatConstIterator_ class that
 introduces more convenient operator *() for accessing the current element.
*/
// Targeting ..\opencv_core\NAryMatIterator.java


// Targeting ..\opencv_core\MatOp.java


// Targeting ..\opencv_core\MatExpr.java



/** \} core_basic
 <p>
 *  \relates cv::MatExpr
 *  \{ */
@Namespace("cv") public static native @ByVal @Name("operator +") MatExpr add(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator +") MatExpr add(@Const @ByRef Mat a, @Const @ByRef Scalar s);
@Namespace("cv") public static native @ByVal @Name("operator +") MatExpr add(@Const @ByRef Scalar s, @Const @ByRef Mat a);
@Namespace("cv") public static native @ByVal @Name("operator +") MatExpr add(@Const @ByRef MatExpr e, @Const @ByRef Mat m);
@Namespace("cv") public static native @ByVal @Name("operator +") MatExpr add(@Const @ByRef Mat m, @Const @ByRef MatExpr e);
@Namespace("cv") public static native @ByVal @Name("operator +") MatExpr add(@Const @ByRef MatExpr e, @Const @ByRef Scalar s);
@Namespace("cv") public static native @ByVal @Name("operator +") MatExpr add(@Const @ByRef Scalar s, @Const @ByRef MatExpr e);
@Namespace("cv") public static native @ByVal @Name("operator +") MatExpr add(@Const @ByRef MatExpr e1, @Const @ByRef MatExpr e2);

@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef Mat a, @Const @ByRef Scalar s);
@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef Scalar s, @Const @ByRef Mat a);
@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef MatExpr e, @Const @ByRef Mat m);
@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef Mat m, @Const @ByRef MatExpr e);
@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef MatExpr e, @Const @ByRef Scalar s);
@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef Scalar s, @Const @ByRef MatExpr e);
@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef MatExpr e1, @Const @ByRef MatExpr e2);

@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef Mat m);
@Namespace("cv") public static native @ByVal @Name("operator -") MatExpr subtract(@Const @ByRef MatExpr e);

@Namespace("cv") public static native @ByVal @Name("operator *") MatExpr multiply(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator *") MatExpr multiply(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal @Name("operator *") MatExpr multiply(double s, @Const @ByRef Mat a);
@Namespace("cv") public static native @ByVal @Name("operator *") MatExpr multiply(@Const @ByRef MatExpr e, @Const @ByRef Mat m);
@Namespace("cv") public static native @ByVal @Name("operator *") MatExpr multiply(@Const @ByRef Mat m, @Const @ByRef MatExpr e);
@Namespace("cv") public static native @ByVal @Name("operator *") MatExpr multiply(@Const @ByRef MatExpr e, double s);
@Namespace("cv") public static native @ByVal @Name("operator *") MatExpr multiply(double s, @Const @ByRef MatExpr e);
@Namespace("cv") public static native @ByVal @Name("operator *") MatExpr multiply(@Const @ByRef MatExpr e1, @Const @ByRef MatExpr e2);

@Namespace("cv") public static native @ByVal @Name("operator /") MatExpr divide(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator /") MatExpr divide(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal @Name("operator /") MatExpr divide(double s, @Const @ByRef Mat a);
@Namespace("cv") public static native @ByVal @Name("operator /") MatExpr divide(@Const @ByRef MatExpr e, @Const @ByRef Mat m);
@Namespace("cv") public static native @ByVal @Name("operator /") MatExpr divide(@Const @ByRef Mat m, @Const @ByRef MatExpr e);
@Namespace("cv") public static native @ByVal @Name("operator /") MatExpr divide(@Const @ByRef MatExpr e, double s);
@Namespace("cv") public static native @ByVal @Name("operator /") MatExpr divide(double s, @Const @ByRef MatExpr e);
@Namespace("cv") public static native @ByVal @Name("operator /") MatExpr divide(@Const @ByRef MatExpr e1, @Const @ByRef MatExpr e2);

@Namespace("cv") public static native @ByVal @Name("operator <") MatExpr lessThan(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator <") MatExpr lessThan(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal @Name("operator <") MatExpr lessThan(double s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator <=") MatExpr lessThanEquals(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator <=") MatExpr lessThanEquals(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal @Name("operator <=") MatExpr lessThanEquals(double s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator ==") MatExpr equals(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator ==") MatExpr equals(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal @Name("operator ==") MatExpr equals(double s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator !=") MatExpr notEquals(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator !=") MatExpr notEquals(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal @Name("operator !=") MatExpr notEquals(double s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator >=") MatExpr greaterThanEquals(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator >=") MatExpr greaterThanEquals(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal @Name("operator >=") MatExpr greaterThanEquals(double s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator >") MatExpr greaterThan(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator >") MatExpr greaterThan(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal @Name("operator >") MatExpr greaterThan(double s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator &") MatExpr and(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator &") MatExpr and(@Const @ByRef Mat a, @Const @ByRef Scalar s);
@Namespace("cv") public static native @ByVal @Name("operator &") MatExpr and(@Const @ByRef Scalar s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator |") MatExpr or(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator |") MatExpr or(@Const @ByRef Mat a, @Const @ByRef Scalar s);
@Namespace("cv") public static native @ByVal @Name("operator |") MatExpr or(@Const @ByRef Scalar s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator ^") MatExpr xor(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal @Name("operator ^") MatExpr xor(@Const @ByRef Mat a, @Const @ByRef Scalar s);
@Namespace("cv") public static native @ByVal @Name("operator ^") MatExpr xor(@Const @ByRef Scalar s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal @Name("operator ~") MatExpr not(@Const @ByRef Mat m);

@Namespace("cv") public static native @ByVal MatExpr min(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal MatExpr min(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal MatExpr min(double s, @Const @ByRef Mat a);

@Namespace("cv") public static native @ByVal MatExpr max(@Const @ByRef Mat a, @Const @ByRef Mat b);
@Namespace("cv") public static native @ByVal MatExpr max(@Const @ByRef Mat a, double s);
@Namespace("cv") public static native @ByVal MatExpr max(double s, @Const @ByRef Mat a);

/** \brief Calculates an absolute value of each matrix element.
<p>
abs is a meta-function that is expanded to one of absdiff or convertScaleAbs forms:
- C = abs(A-B) is equivalent to {@code absdiff(A, B, C)}
- C = abs(A) is equivalent to {@code absdiff(A, Scalar::all(0), C)}
- C = {@code Mat_<Vec<uchar,n> >(abs(A*alpha + beta))} is equivalent to {@code convertScaleAbs(A, C, alpha,
beta)}
<p>
The output matrix has the same size and the same type as the input one except for the last case,
where C is depth=CV_8U .
@param m matrix.
@see \ref MatrixExpressions, absdiff, convertScaleAbs
 */
@Namespace("cv") public static native @ByVal MatExpr abs(@Const @ByRef Mat m);
/** \overload
@param e matrix expression.
*/
@Namespace("cv") public static native @ByVal MatExpr abs(@Const @ByRef MatExpr e);
/** \} relates cv::MatExpr */

 // cv

// #include "opencv2/core/mat.inl.hpp"

// #endif // OPENCV_CORE_MAT_HPP


// Parsed from <opencv2/core/persistence.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CORE_PERSISTENCE_HPP
// #define OPENCV_CORE_PERSISTENCE_HPP

// #ifndef CV_DOXYGEN
/** Define to support persistence legacy formats */
// #define CV__LEGACY_PERSISTENCE
// #endif

// #ifndef __cplusplus
// #endif

/** \addtogroup core_c
 *  \{
<p>
/** \brief "black box" representation of the file storage associated with a file on disk.
<p>
Several functions that are described below take CvFileStorage\* as inputs and allow the user to
save or to load hierarchical collections that consist of scalar values, standard CXCore objects
(such as matrices, sequences, graphs), and user-defined objects.
<p>
OpenCV can read and write data in XML (<http://www.w3c.org/XML>), YAML (<http://www.yaml.org>) or
JSON (<http://www.json.org/>) formats. Below is an example of 3x3 floating-point identity matrix A,
stored in XML and YAML files
using CXCore functions:
XML:
<pre>{@code {.xml}
    <?xml version="1.0">
    <opencv_storage>
    <A type_id="opencv-matrix">
      <rows>3</rows>
      <cols>3</cols>
      <dt>f</dt>
      <data>1. 0. 0. 0. 1. 0. 0. 0. 1.</data>
    </A>
    </opencv_storage>
}</pre>
YAML:
<pre>{@code {.yaml}
    %YAML:1.0
    A: !!opencv-matrix
      rows: 3
      cols: 3
      dt: f
      data: [ 1., 0., 0., 0., 1., 0., 0., 0., 1.]
}</pre>
As it can be seen from the examples, XML uses nested tags to represent hierarchy, while YAML uses
indentation for that purpose (similar to the Python programming language).
<p>
The same functions can read and write data in both formats; the particular format is determined by
the extension of the opened file, ".xml" for XML files, ".yml" or ".yaml" for YAML and ".json" for
JSON.
 */

/** \} core_c */

// #include "opencv2/core/types.hpp"
// #include "opencv2/core/mat.hpp"

/** \addtogroup core_xml
<p>
XML/YAML/JSON file storages.     {#xml_storage}
=======================
Writing to a file storage.
--------------------------
You can store and then restore various OpenCV data structures to/from XML (<http://www.w3c.org/XML>),
YAML (<http://www.yaml.org>) or JSON (<http://www.json.org/>) formats. Also, it is possible to store
and load arbitrarily complex data structures, which include OpenCV data structures, as well as
primitive data types (integer and floating-point numbers and text strings) as their elements.
<p>
Use the following procedure to write something to XML, YAML or JSON:
-# Create new FileStorage and open it for writing. It can be done with a single call to
FileStorage::FileStorage constructor that takes a filename, or you can use the default constructor
and then call FileStorage::open. Format of the file (XML, YAML or JSON) is determined from the filename
extension (".xml", ".yml"/".yaml" and ".json", respectively)
-# Write all the data you want using the streaming operator {@code <<}, just like in the case of STL
streams.
-# Close the file using FileStorage::release. FileStorage destructor also closes the file.
<p>
Here is an example:
<pre>{@code
    #include "opencv2/core.hpp"
    #include <time.h>

    using namespace cv;

    int main(int, char** argv)
    {
        FileStorage fs("test.yml", FileStorage::WRITE);

        fs << "frameCount" << 5;
        time_t rawtime; time(&rawtime);
        fs << "calibrationDate" << asctime(localtime(&rawtime));
        Mat cameraMatrix = (Mat_<double>(3,3) << 1000, 0, 320, 0, 1000, 240, 0, 0, 1);
        Mat distCoeffs = (Mat_<double>(5,1) << 0.1, 0.01, -0.001, 0, 0);
        fs << "cameraMatrix" << cameraMatrix << "distCoeffs" << distCoeffs;
        fs << "features" << "[";
        for( int i = 0; i < 3; i++ )
        {
            int x = rand() % 640;
            int y = rand() % 480;
            uchar lbp = rand() % 256;

            fs << "{:" << "x" << x << "y" << y << "lbp" << "[:";
            for( int j = 0; j < 8; j++ )
                fs << ((lbp >> j) & 1);
            fs << "]" << "}";
        }
        fs << "]";
        fs.release();
        return 0;
    }
}</pre>
The sample above stores to YML an integer, a text string (calibration date), 2 matrices, and a custom
structure "feature", which includes feature coordinates and LBP (local binary pattern) value. Here
is output of the sample:
<pre>{@code {.yaml}
%YAML:1.0
frameCount: 5
calibrationDate: "Fri Jun 17 14:09:29 2011\n"
cameraMatrix: !!opencv-matrix
   rows: 3
   cols: 3
   dt: d
   data: [ 1000., 0., 320., 0., 1000., 240., 0., 0., 1. ]
distCoeffs: !!opencv-matrix
   rows: 5
   cols: 1
   dt: d
   data: [ 1.0000000000000001e-01, 1.0000000000000000e-02,
       -1.0000000000000000e-03, 0., 0. ]
features:
   - { x:167, y:49, lbp:[ 1, 0, 0, 1, 1, 0, 1, 1 ] }
   - { x:298, y:130, lbp:[ 0, 0, 0, 1, 0, 0, 1, 1 ] }
   - { x:344, y:158, lbp:[ 1, 1, 0, 0, 0, 0, 1, 0 ] }
}</pre>
<p>
As an exercise, you can replace ".yml" with ".xml" or ".json" in the sample above and see, how the
corresponding XML file will look like.
<p>
Several things can be noted by looking at the sample code and the output:
<p>
-   The produced YAML (and XML/JSON) consists of heterogeneous collections that can be nested. There are
    2 types of collections: named collections (mappings) and unnamed collections (sequences). In mappings
    each element has a name and is accessed by name. This is similar to structures and std::map in
    C/C++ and dictionaries in Python. In sequences elements do not have names, they are accessed by
    indices. This is similar to arrays and std::vector in C/C++ and lists, tuples in Python.
    "Heterogeneous" means that elements of each single collection can have different types.
    <p>
    Top-level collection in YAML/XML/JSON is a mapping. Each matrix is stored as a mapping, and the matrix
    elements are stored as a sequence. Then, there is a sequence of features, where each feature is
    represented a mapping, and lbp value in a nested sequence.
<p>
-   When you write to a mapping (a structure), you write element name followed by its value. When you
    write to a sequence, you simply write the elements one by one. OpenCV data structures (such as
    cv::Mat) are written in absolutely the same way as simple C data structures - using {@code <<}
    operator.
<p>
-   To write a mapping, you first write the special string {@code {} to the storage, then write the
    elements as pairs ({@code fs << <element_name> << <element_value>}) and then write the closing
    {@code }}.
<p>
-   To write a sequence, you first write the special string {@code [}, then write the elements, then
    write the closing {@code ]}.
<p>
-   In YAML/JSON (but not XML), mappings and sequences can be written in a compact Python-like inline
    form. In the sample above matrix elements, as well as each feature, including its lbp value, is
    stored in such inline form. To store a mapping/sequence in a compact form, put {@code :} after the
    opening character, e.g. use {@code {:} instead of {@code {} and {@code [:} instead of {@code [}. When the
    data is written to XML, those extra {@code :} are ignored.
<p>
Reading data from a file storage.
---------------------------------
To read the previously written XML, YAML or JSON file, do the following:
-#  Open the file storage using FileStorage::FileStorage constructor or FileStorage::open method.
    In the current implementation the whole file is parsed and the whole representation of file
    storage is built in memory as a hierarchy of file nodes (see FileNode)
<p>
-#  Read the data you are interested in. Use FileStorage::operator [], FileNode::operator []
    and/or FileNodeIterator.
<p>
-#  Close the storage using FileStorage::release.
<p>
Here is how to read the file created by the code sample above:
<pre>{@code
    FileStorage fs2("test.yml", FileStorage::READ);

    // first method: use (type) operator on FileNode.
    int frameCount = (int)fs2["frameCount"];

    String date;
    // second method: use FileNode::operator >>
    fs2["calibrationDate"] >> date;

    Mat cameraMatrix2, distCoeffs2;
    fs2["cameraMatrix"] >> cameraMatrix2;
    fs2["distCoeffs"] >> distCoeffs2;

    cout << "frameCount: " << frameCount << endl
         << "calibration date: " << date << endl
         << "camera matrix: " << cameraMatrix2 << endl
         << "distortion coeffs: " << distCoeffs2 << endl;

    FileNode features = fs2["features"];
    FileNodeIterator it = features.begin(), it_end = features.end();
    int idx = 0;
    std::vector<uchar> lbpval;

    // iterate through a sequence using FileNodeIterator
    for( ; it != it_end; ++it, idx++ )
    {
        cout << "feature #" << idx << ": ";
        cout << "x=" << (int)(*it)["x"] << ", y=" << (int)(*it)["y"] << ", lbp: (";
        // you can also easily read numerical arrays using FileNode >> std::vector operator.
        (*it)["lbp"] >> lbpval;
        for( int i = 0; i < (int)lbpval.size(); i++ )
            cout << " " << (int)lbpval[i];
        cout << ")" << endl;
    }
    fs2.release();
}</pre>
<p>
Format specification    {#format_spec}
--------------------
{@code ([count]{u|c|w|s|i|f|d})}... where the characters correspond to fundamental C++ types:
-   {@code u} 8-bit unsigned number
-   {@code c} 8-bit signed number
-   {@code w} 16-bit unsigned number
-   {@code s} 16-bit signed number
-   {@code i} 32-bit signed number
-   {@code f} single precision floating-point number
-   {@code d} double precision floating-point number
-   {@code r} pointer, 32 lower bits of which are written as a signed integer. The type can be used to
    store structures with links between the elements.
<p>
{@code count} is the optional counter of values of a given type. For example, {@code 2if} means that each array
element is a structure of 2 integers, followed by a single-precision floating-point number. The
equivalent notations of the above specification are {@code iif}, {@code 2i1f} and so forth. Other examples: {@code u}
means that the array consists of bytes, and {@code 2d} means the array consists of pairs of doubles.
<p>
@see \ref samples/cpp/filestorage.cpp
*/

/** \{
<p>
/** \example samples/cpp/filestorage.cpp
A complete example using the FileStorage interface
*/

////////////////////////// XML & YAML I/O ////////////////////////// */
// Targeting ..\opencv_core\FileStorage.java


// Targeting ..\opencv_core\FileNode.java


// Targeting ..\opencv_core\FileNodeIterator.java



/** \} core_xml
<p>
/////////////////// XML & YAML I/O implementation //////////////////
 <p>
 *  \relates cv::FileStorage
 *  \{ */

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, int value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, int value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, float value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, float value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, double value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, double value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Str BytePointer value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Str String value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Mat value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Mat value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef SparseMat value );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef SparseMat value );
// #ifdef CV__LEGACY_PERSISTENCE
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef KeyPointVector value);
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef KeyPointVector value);
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef DMatchVector value);
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef DMatchVector value);
// #endif

@Namespace("cv") public static native void writeScalar( @ByRef FileStorage fs, int value );
@Namespace("cv") public static native void writeScalar( @ByRef FileStorage fs, float value );
@Namespace("cv") public static native void writeScalar( @ByRef FileStorage fs, double value );
@Namespace("cv") public static native void writeScalar( @ByRef FileStorage fs, @Str BytePointer value );
@Namespace("cv") public static native void writeScalar( @ByRef FileStorage fs, @Str String value );

/** \}
 <p>
 *  \relates cv::FileNode
 *  \{ */

@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef IntPointer value, int default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef IntBuffer value, int default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef int[] value, int default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef FloatPointer value, float default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef FloatBuffer value, float default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef float[] value, float default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef DoublePointer value, double default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef DoubleBuffer value, double default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef double[] value, double default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @StdString @ByRef BytePointer value, @StdString BytePointer default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @StdString @ByRef BytePointer value, @StdString String default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef Mat mat, @Const @ByRef(nullValue = "cv::Mat()") Mat default_mat );
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef Mat mat );
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef SparseMat mat, @Const @ByRef(nullValue = "cv::SparseMat()") SparseMat default_mat );
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef SparseMat mat );
// #ifdef CV__LEGACY_PERSISTENCE
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef KeyPointVector keypoints);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef DMatchVector matches);
// #endif
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef KeyPoint value, @Const @ByRef KeyPoint default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef DMatch value, @Const @ByRef DMatch default_value);

@Namespace("cv") public static native @Name("read<int>") void read(@Const @ByRef FileNode node, @ByRef Point value, @Const @ByRef Point default_value);

@Namespace("cv") public static native @Name("read<int>") void read(@Const @ByRef FileNode node, @ByRef Point3i value, @Const @ByRef Point3i default_value);

@Namespace("cv") public static native @Name("read<int>") void read(@Const @ByRef FileNode node, @ByRef Size value, @Const @ByRef Size default_value);



@Namespace("cv") public static native @Name("read<int>") void read(@Const @ByRef FileNode node, @ByRef Rect value, @Const @ByRef Rect default_value);

@Namespace("cv") public static native @Name("read<int>") void read(@Const @ByRef FileNode node, @ByRef Scalar4i value, @Const @ByRef Scalar4i default_value);

@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @ByRef Range value, @Const @ByRef Range default_value);

/** \}
<p>
/** \brief Writes string to a file storage.
\relates cv::FileStorage
 */
@Namespace("cv") public static native @ByRef @Name("operator <<") FileStorage shiftLeft(@ByRef FileStorage fs, @Str BytePointer str);
@Namespace("cv") public static native @ByRef @Name("operator <<") FileStorage shiftLeft(@ByRef FileStorage fs, @Str String str);
// Targeting ..\opencv_core\WriteStructContext.java



 // internal

/** \endcond
 <p>
 *  \relates cv::FileStorage
 *  \{ */

@Namespace("cv") public static native void write(@ByRef FileStorage fs, int value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, float value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, double value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Str BytePointer value);
@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Str String value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Point value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Point2f value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Point2d value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Point3i value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Point3f value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Point3d value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Size value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Size2f value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Size2d value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Complexf value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Complexd value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Rect value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Rect2f value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Rect2d value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Scalar4i value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Scalar4f value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Scalar value);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef Range r );

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Range r );
@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Str String name, @Const @ByRef Range r );

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef KeyPoint kpt);
@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Str String name, @Const @ByRef KeyPoint kpt);

@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef DMatch m);
@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Str String name, @Const @ByRef DMatch m);

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Point val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Point val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Point2f val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Point2f val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Point2d val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Point2d val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Point3i val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Point3i val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Point3f val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Point3f val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Point3d val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Point3d val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Size val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Size val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Size2f val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Size2f val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Size2d val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Size2d val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Complexf val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Complexf val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Complexd val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Complexd val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Rect val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Rect val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Rect2f val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Rect2f val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Rect2d val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Rect2d val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Scalar4i val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Scalar4i val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Scalar4f val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Scalar4f val );

@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str BytePointer name, @Const @ByRef Scalar val );
@Namespace("cv") public static native void write( @ByRef FileStorage fs, @Str String name, @Const @ByRef Scalar val );

// #ifdef CV__LEGACY_PERSISTENCE
// This code is not needed anymore, but it is preserved here to keep source compatibility
// Implementation is similar to templates instantiations
@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef KeyPoint kpt);
@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef DMatch m);
@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef KeyPointVector vec);
@Namespace("cv") public static native void write(@ByRef FileStorage fs, @Const @ByRef DMatchVector vec);
// #endif

/** \} FileStorage
 <p>
 *  \relates cv::FileNode
 *  \{ */

@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @Cast("bool*") @ByRef BoolPointer value, @Cast("bool") boolean default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @Cast("bool*") @ByRef boolean[] value, @Cast("bool") boolean default_value);

@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @Cast("uchar*") @ByRef BytePointer value, @Cast("uchar") byte default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @Cast("uchar*") @ByRef ByteBuffer value, @Cast("uchar") byte default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @Cast("uchar*") @ByRef byte[] value, @Cast("uchar") byte default_value);

@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @Cast("ushort*") @ByRef ShortPointer value, @Cast("ushort") short default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @Cast("ushort*") @ByRef ShortBuffer value, @Cast("ushort") short default_value);
@Namespace("cv") public static native void read(@Const @ByRef FileNode node, @Cast("ushort*") @ByRef short[] value, @Cast("ushort") short default_value);

@Namespace("cv") public static native @Name("read<int>") void read( @ByRef FileNodeIterator it, @StdVector IntPointer vec, @Cast("size_t") long maxCount/*=(size_t)INT_MAX*/ );
@Namespace("cv") public static native @Name("read<int>") void read( @ByRef FileNodeIterator it, @StdVector IntPointer vec );
@Namespace("cv") public static native @Name("read<int>") void read( @ByRef FileNodeIterator it, @StdVector IntBuffer vec, @Cast("size_t") long maxCount/*=(size_t)INT_MAX*/ );
@Namespace("cv") public static native @Name("read<int>") void read( @ByRef FileNodeIterator it, @StdVector IntBuffer vec );
@Namespace("cv") public static native @Name("read<int>") void read( @ByRef FileNodeIterator it, @StdVector int[] vec, @Cast("size_t") long maxCount/*=(size_t)INT_MAX*/ );
@Namespace("cv") public static native @Name("read<int>") void read( @ByRef FileNodeIterator it, @StdVector int[] vec );



@Namespace("cv") public static native @Name("read<int>") void read( @Const @ByRef FileNode node, @StdVector IntPointer vec, @StdVector IntPointer default_value/*=std::vector<int>()*/ );
@Namespace("cv") public static native @Name("read<int>") void read( @Const @ByRef FileNode node, @StdVector IntPointer vec );
@Namespace("cv") public static native @Name("read<int>") void read( @Const @ByRef FileNode node, @StdVector IntBuffer vec, @StdVector IntBuffer default_value/*=std::vector<int>()*/ );
@Namespace("cv") public static native @Name("read<int>") void read( @Const @ByRef FileNode node, @StdVector IntBuffer vec );
@Namespace("cv") public static native @Name("read<int>") void read( @Const @ByRef FileNode node, @StdVector int[] vec, @StdVector int[] default_value/*=std::vector<int>()*/ );
@Namespace("cv") public static native @Name("read<int>") void read( @Const @ByRef FileNode node, @StdVector int[] vec );

@Namespace("cv") public static native void read( @Const @ByRef FileNode node, @ByRef KeyPointVector vec, @Const @ByRef KeyPointVector default_value );

@Namespace("cv") public static native void read( @Const @ByRef FileNode node, @ByRef DMatchVector vec, @Const @ByRef DMatchVector default_value );

/** \} FileNode
 <p>
 *  \relates cv::FileStorage
 *  \{
<p>
/** \brief Writes data to a file storage.
 */

/** \brief Writes data to a file storage.
 */

/** \brief Writes data to a file storage.
 */
@Namespace("cv") public static native @ByRef @Name("operator <<") FileStorage shiftLeft(@ByRef FileStorage fs, @Cast("char*") ByteBuffer value);
@Namespace("cv") public static native @ByRef @Name("operator <<") FileStorage shiftLeft(@ByRef FileStorage fs, @Cast("char*") byte[] value);

/** \} FileStorage
 <p>
 *  \relates cv::FileNodeIterator
 *  \{
<p>
/** \brief Reads data from a file storage.
 */

/** \brief Reads data from a file storage.
 */

/** \} FileNodeIterator
 <p>
 *  \relates cv::FileNode
 *  \{
<p>
/** \brief Reads data from a file storage.
 */

/** \brief Reads data from a file storage.
 */

/** \brief Reads KeyPoint from a file storage.
*/
//It needs special handling because it contains two types of fields, int & float.
@Namespace("cv") public static native @Name("operator >>") void shiftRight(@Const @ByRef FileNode n, @ByRef KeyPoint kpt);

// #ifdef CV__LEGACY_PERSISTENCE
@Namespace("cv") public static native @Name("operator >>") void shiftRight(@Const @ByRef FileNode n, @ByRef KeyPointVector vec);
@Namespace("cv") public static native @Name("operator >>") void shiftRight(@Const @ByRef FileNode n, @ByRef DMatchVector vec);
// #endif

/** \brief Reads DMatch from a file storage.
*/
//It needs special handling because it contains two types of fields, int & float.
@Namespace("cv") public static native @Name("operator >>") void shiftRight(@Const @ByRef FileNode n, @ByRef DMatch m);

/** \} FileNode
 <p>
 *  \relates cv::FileNodeIterator
 *  \{ */

@Namespace("cv") public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef FileNodeIterator it1, @Const @ByRef FileNodeIterator it2);
@Namespace("cv") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef FileNodeIterator it1, @Const @ByRef FileNodeIterator it2);

@Namespace("cv") public static native @Cast("ptrdiff_t") @Name("operator -") long subtract(@Const @ByRef FileNodeIterator it1, @Const @ByRef FileNodeIterator it2);

@Namespace("cv") public static native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef FileNodeIterator it1, @Const @ByRef FileNodeIterator it2);

/** \} FileNodeIterator */

 // cv

// #endif // OPENCV_CORE_PERSISTENCE_HPP


// Parsed from <opencv2/core/optim.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the OpenCV Foundation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_OPTIM_HPP
// #define OPENCV_OPTIM_HPP

// #include "opencv2/core.hpp"
// Targeting ..\opencv_core\MinProblemSolver.java


// Targeting ..\opencv_core\DownhillSolver.java


// Targeting ..\opencv_core\ConjGradSolver.java



/** return codes for cv::solveLP() function */
/** enum cv::SolveLPResult */
public static final int
    /** problem is feasible, but solver lost solution due to floating-point arithmetic errors */
    SOLVELP_LOST   = -3,
    /** problem is unbounded (target function can achieve arbitrary high values) */
    SOLVELP_UNBOUNDED    = -2,
    /** problem is unfeasible (there are no points that satisfy all the constraints imposed) */
    SOLVELP_UNFEASIBLE    = -1,
    /** there is only one maximum for target function */
    SOLVELP_SINGLE    = 0,
    /** there are multiple maxima for target function - the arbitrary one is returned */
    SOLVELP_MULTI    = 1;

/** \brief Solve given (non-integer) linear programming problem using the Simplex Algorithm (Simplex Method).
<p>
What we mean here by "linear programming problem" (or LP problem, for short) can be formulated as:
<p>
<pre>{@code \[\mbox{Maximize } c\cdot x\\
 \mbox{Subject to:}\\
 Ax\leq b\\
 x\geq 0\]}</pre>
<p>
Where {@code c} is fixed {@code 1}-by-{@code n} row-vector, {@code A} is fixed {@code m}-by-{@code n} matrix, {@code b} is fixed {@code m}-by-{@code 1}
column vector and {@code x} is an arbitrary {@code n}-by-{@code 1} column vector, which satisfies the constraints.
<p>
Simplex algorithm is one of many algorithms that are designed to handle this sort of problems
efficiently. Although it is not optimal in theoretical sense (there exist algorithms that can solve
any problem written as above in polynomial time, while simplex method degenerates to exponential
time for some special cases), it is well-studied, easy to implement and is shown to work well for
real-life purposes.
<p>
The particular implementation is taken almost verbatim from **Introduction to Algorithms, third
edition** by T. H. Cormen, C. E. Leiserson, R. L. Rivest and Clifford Stein. In particular, the
Bland's rule <http://en.wikipedia.org/wiki/Bland%27s_rule> is used to prevent cycling.
<p>
@param Func This row-vector corresponds to {@code c} in the LP problem formulation (see above). It should
contain 32- or 64-bit floating point numbers. As a convenience, column-vector may be also submitted,
in the latter case it is understood to correspond to {@code c^T}.
@param Constr {@code m}-by-{@code n+1} matrix, whose rightmost column corresponds to {@code b} in formulation above
and the remaining to {@code A}. It should contain 32- or 64-bit floating point numbers.
@param z The solution will be returned here as a column-vector - it corresponds to {@code c} in the
formulation above. It will contain 64-bit floating point numbers.
@param constr_eps allowed numeric disparity for constraints
@return One of cv::SolveLPResult
 */
@Namespace("cv") public static native int solveLP(@ByVal Mat Func, @ByVal Mat Constr, @ByVal Mat z, double constr_eps);
@Namespace("cv") public static native int solveLP(@ByVal UMat Func, @ByVal UMat Constr, @ByVal UMat z, double constr_eps);
@Namespace("cv") public static native int solveLP(@ByVal GpuMat Func, @ByVal GpuMat Constr, @ByVal GpuMat z, double constr_eps);

/** \overload */
@Namespace("cv") public static native int solveLP(@ByVal Mat Func, @ByVal Mat Constr, @ByVal Mat z);
@Namespace("cv") public static native int solveLP(@ByVal UMat Func, @ByVal UMat Constr, @ByVal UMat z);
@Namespace("cv") public static native int solveLP(@ByVal GpuMat Func, @ByVal GpuMat Constr, @ByVal GpuMat z);

/** \} */

// cv

// #endif


// Parsed from <opencv2/core/async.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html.

// #ifndef OPENCV_CORE_ASYNC_HPP
// #define OPENCV_CORE_ASYNC_HPP

// #include <opencv2/core/mat.hpp>

// #ifdef CV_CXX11
// #endif
// Targeting ..\opencv_core\AsyncArray.java




/** \} */
 // namespace
// #endif // OPENCV_CORE_ASYNC_HPP


}
