// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_quality;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import org.bytedeco.opencv.opencv_ml.*;
import static org.bytedeco.opencv.global.opencv_ml.*;

import static org.bytedeco.opencv.global.opencv_quality.*;


/** \addtogroup quality
 *  \{
<p>
/************************************ Quality Base Class ************************************/

@Namespace("cv::quality") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_quality.class)
public class QualityBase extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public QualityBase(Pointer p) { super(p); }


    /** \brief Destructor */

    /**
    \brief Compute quality score per channel with the per-channel score in each element of the resulting cv::Scalar.  See specific algorithm for interpreting result scores
    @param cmpImgs comparison image(s), or image(s) to evalute for no-reference quality algorithms
    */
    public native @ByVal Scalar compute( @ByVal MatVector cmpImgs );
    public native @ByVal Scalar compute( @ByVal UMatVector cmpImgs );
    public native @ByVal Scalar compute( @ByVal GpuMatVector cmpImgs );

    /** \brief Returns output quality map images that were generated during computation, if supported by the algorithm  */
    public native void getQualityMaps(@ByVal MatVector dst);
    public native void getQualityMaps(@ByVal UMatVector dst);
    public native void getQualityMaps(@ByVal GpuMatVector dst);

    /** \brief Implements Algorithm::clear()  */
    public native @Override void clear();

    /** \brief Implements Algorithm::empty()  */
    public native @Cast("bool") @Override boolean empty();

}
