/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.leptonica;

import java.nio.DoubleBuffer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.leptonica.DPIX;
import org.bytedeco.leptonica.global.leptonica;

@Properties(inherit={org.bytedeco.leptonica.presets.leptonica.class})
public abstract class AbstractDPIX
extends Pointer
implements Indexable {
    public AbstractDPIX(Pointer p) {
        super(p);
    }

    public static DPIX create(int width, int height) {
        DPIX p = leptonica.dpixCreate(width, height);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static DPIX createTemplate(DPIX dpixs) {
        DPIX p = leptonica.dpixCreateTemplate(dpixs);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public DPIX clone() {
        DPIX p = new DPIX(leptonica.dpixClone((DPIX)this));
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public DoubleBuffer createBuffer() {
        return this.createBuffer(0);
    }

    public DoubleBuffer createBuffer(int index) {
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        leptonica.dpixGetDimensions((DPIX)this, w, h);
        int wpl = leptonica.dpixGetWpl((DPIX)this);
        DoublePointer data = new DoublePointer((Pointer)leptonica.dpixGetData((DPIX)this)).position((long)index).capacity((long)(h[0] * wpl));
        return data.asBuffer();
    }

    public DoubleIndexer createIndexer() {
        return this.createIndexer(true);
    }

    public DoubleIndexer createIndexer(boolean direct) {
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        leptonica.dpixGetDimensions((DPIX)this, w, h);
        int wpl = leptonica.dpixGetWpl((DPIX)this);
        long[] sizes = new long[]{h[0], w[0], wpl / w[0]};
        long[] strides = new long[]{wpl, wpl / w[0], 1L};
        DoublePointer data = new DoublePointer((Pointer)leptonica.dpixGetData((DPIX)this)).capacity((long)(h[0] * wpl));
        return DoubleIndexer.create((DoublePointer)data, (long[])sizes, (long[])strides, (boolean)direct);
    }

    public void destroy() {
        this.deallocate();
    }

    protected static class DestroyDeallocator
    extends DPIX
    implements Pointer.Deallocator {
        DestroyDeallocator(DPIX p) {
            super(p);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            leptonica.dpixDestroy(this);
            this.setNull();
        }
    }
}

