/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_calib3d;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.MarkedPlane;
import org.bytedeco.javacv.Marker;
import org.bytedeco.javacv.MarkerDetector;
import org.bytedeco.javacv.ProjectiveDevice;

public class GeometricCalibrator {
    private Settings settings;
    MarkerDetector markerDetector;
    private MarkedPlane markedPlane;
    private ProjectiveDevice projectiveDevice;
    private LinkedList<Marker[]> allObjectMarkers = new LinkedList();
    private LinkedList<Marker[]> allImageMarkers = new LinkedList();
    private opencv_core.IplImage tempImage = null;
    private Marker[] lastDetectedMarkers = null;
    private opencv_core.CvMat warp = opencv_core.CvMat.create((int)3, (int)3);
    private opencv_core.CvMat prevWarp = opencv_core.CvMat.create((int)3, (int)3);
    private opencv_core.CvMat lastWarp = opencv_core.CvMat.create((int)3, (int)3);
    private opencv_core.CvMat warpSrcPts = opencv_core.CvMat.create((int)1, (int)4, (int)6, (int)2);
    private opencv_core.CvMat warpDstPts = opencv_core.CvMat.create((int)1, (int)4, (int)6, (int)2);
    private opencv_core.CvMat tempPts = opencv_core.CvMat.create((int)1, (int)4, (int)6, (int)2);

    public GeometricCalibrator(Settings settings, MarkerDetector.Settings detectorSettings, MarkedPlane markedPlane, ProjectiveDevice projectiveDevice) {
        this.settings = settings;
        this.markerDetector = new MarkerDetector(detectorSettings);
        this.markedPlane = markedPlane;
        this.projectiveDevice = projectiveDevice;
        opencv_core.cvSetIdentity((opencv_core.CvArr)this.prevWarp);
        opencv_core.cvSetIdentity((opencv_core.CvArr)this.lastWarp);
        if (markedPlane != null) {
            int w = markedPlane.getImage().width();
            int h = markedPlane.getImage().height();
            this.warpSrcPts.put(new double[]{0.0, 0.0, w, 0.0, w, h, 0.0, h});
        }
    }

    public MarkerDetector getMarkerDetector() {
        return this.markerDetector;
    }

    public MarkedPlane getMarkedPlane() {
        return this.markedPlane;
    }

    public ProjectiveDevice getProjectiveDevice() {
        return this.projectiveDevice;
    }

    public LinkedList<Marker[]> getAllObjectMarkers() {
        return this.allObjectMarkers;
    }

    public void setAllObjectMarkers(LinkedList<Marker[]> allObjectMarkers) {
        this.allObjectMarkers = allObjectMarkers;
    }

    public LinkedList<Marker[]> getAllImageMarkers() {
        return this.allImageMarkers;
    }

    public void setAllImageMarkers(LinkedList<Marker[]> allImageMarkers) {
        this.allImageMarkers = allImageMarkers;
    }

    public Marker[] processImage(opencv_core.IplImage image) {
        boolean whiteMarkers;
        this.projectiveDevice.imageWidth = image.width();
        this.projectiveDevice.imageHeight = image.height();
        boolean bl = whiteMarkers = this.markedPlane.getForegroundColor().magnitude() > this.markedPlane.getBackgroundColor().magnitude();
        if (image.depth() > 8) {
            if (this.tempImage == null || this.tempImage.width() != image.width() || this.tempImage.height() != image.height()) {
                this.tempImage = opencv_core.IplImage.create((int)image.width(), (int)image.height(), (int)8, (int)1, (int)image.origin());
            }
            opencv_core.cvConvertScale((opencv_core.CvArr)image, (opencv_core.CvArr)this.tempImage, (double)0.00390625, (double)0.0);
            this.lastDetectedMarkers = this.markerDetector.detect(this.tempImage, whiteMarkers);
        } else {
            this.lastDetectedMarkers = this.markerDetector.detect(image, whiteMarkers);
        }
        if ((double)this.lastDetectedMarkers.length < (double)this.markedPlane.getMarkers().length * this.settings.detectedBoardMin) {
            return null;
        }
        this.markedPlane.getTotalWarp(this.lastDetectedMarkers, this.warp);
        opencv_core.cvPerspectiveTransform((opencv_core.CvArr)this.warpSrcPts, (opencv_core.CvArr)this.warpDstPts, (opencv_core.CvMat)this.warp);
        opencv_core.cvPerspectiveTransform((opencv_core.CvArr)this.warpSrcPts, (opencv_core.CvArr)this.tempPts, (opencv_core.CvMat)this.prevWarp);
        double rmsePrev = opencv_core.cvNorm((opencv_core.CvArr)this.warpDstPts, (opencv_core.CvArr)this.tempPts);
        opencv_core.cvPerspectiveTransform((opencv_core.CvArr)this.warpSrcPts, (opencv_core.CvArr)this.tempPts, (opencv_core.CvMat)this.lastWarp);
        double rmseLast = opencv_core.cvNorm((opencv_core.CvArr)this.warpDstPts, (opencv_core.CvArr)this.tempPts);
        opencv_core.cvCopy((opencv_core.CvArr)this.warp, (opencv_core.CvArr)this.prevWarp);
        int imageSize = (image.width() + image.height()) / 2;
        if (rmsePrev < this.settings.patternSteadySize * (double)imageSize && rmseLast > this.settings.patternMovedSize * (double)imageSize) {
            return this.lastDetectedMarkers;
        }
        return null;
    }

    public void drawMarkers(opencv_core.IplImage image) {
        this.markerDetector.draw(image, this.lastDetectedMarkers);
    }

    public void addMarkers() {
        this.addMarkers(this.markedPlane.getMarkers(), this.lastDetectedMarkers);
    }

    public void addMarkers(Marker[] imageMarkers) {
        this.addMarkers(this.markedPlane.getMarkers(), imageMarkers);
    }

    public void addMarkers(Marker[] objectMarkers, Marker[] imageMarkers) {
        int maxLength = Math.min(objectMarkers.length, imageMarkers.length);
        Marker[] om = new Marker[maxLength];
        Marker[] im = new Marker[maxLength];
        int i = 0;
        block0: for (Marker m1 : objectMarkers) {
            for (Marker m2 : imageMarkers) {
                if (m1.id != m2.id) continue;
                om[i] = m1;
                im[i] = m2;
                ++i;
                continue block0;
            }
        }
        if (i < maxLength) {
            om = Arrays.copyOf(om, i);
            im = Arrays.copyOf(im, i);
        }
        this.allObjectMarkers.add(om);
        this.allImageMarkers.add(im);
        opencv_core.cvCopy((opencv_core.CvArr)this.prevWarp, (opencv_core.CvArr)this.lastWarp);
    }

    public int getImageCount() {
        assert (this.allObjectMarkers.size() == this.allImageMarkers.size());
        return this.allObjectMarkers.size();
    }

    private opencv_core.CvMat[] getPoints(boolean useCenters) {
        assert (this.allObjectMarkers.size() == this.allImageMarkers.size());
        Iterator i1 = this.allObjectMarkers.iterator();
        Iterator i2 = this.allImageMarkers.iterator();
        opencv_core.CvMat pointCounts = opencv_core.CvMat.create((int)1, (int)this.allImageMarkers.size(), (int)4, (int)1);
        IntBuffer pointCountsBuf = pointCounts.getIntBuffer();
        int totalPointCount = 0;
        while (i1.hasNext() && i2.hasNext()) {
            Marker[] m1 = (Marker[])i1.next();
            Marker[] m2 = (Marker[])i2.next();
            assert (m1.length == m2.length);
            int n = m1.length * (useCenters ? 1 : 4);
            pointCountsBuf.put(n);
            totalPointCount += n;
        }
        i1 = this.allObjectMarkers.iterator();
        i2 = this.allImageMarkers.iterator();
        opencv_core.CvMat objectPoints = opencv_core.CvMat.create((int)1, (int)totalPointCount, (int)5, (int)3);
        opencv_core.CvMat imagePoints = opencv_core.CvMat.create((int)1, (int)totalPointCount, (int)5, (int)2);
        FloatBuffer objectPointsBuf = objectPoints.getFloatBuffer();
        FloatBuffer imagePointsBuf = imagePoints.getFloatBuffer();
        while (i1.hasNext() && i2.hasNext()) {
            Marker[] m1 = (Marker[])i1.next();
            Marker[] m2 = (Marker[])i2.next();
            for (int j = 0; j < m1.length; ++j) {
                if (useCenters) {
                    double[] c1 = m1[j].getCenter();
                    objectPointsBuf.put((float)c1[0]);
                    objectPointsBuf.put((float)c1[1]);
                    objectPointsBuf.put(0.0f);
                    double[] c2 = m2[j].getCenter();
                    imagePointsBuf.put((float)c2[0]);
                    imagePointsBuf.put((float)c2[1]);
                    continue;
                }
                for (int k = 0; k < 4; ++k) {
                    objectPointsBuf.put((float)m1[j].corners[2 * k]);
                    objectPointsBuf.put((float)m1[j].corners[2 * k + 1]);
                    objectPointsBuf.put(0.0f);
                    imagePointsBuf.put((float)m2[j].corners[2 * k]);
                    imagePointsBuf.put((float)m2[j].corners[2 * k + 1]);
                }
            }
        }
        return new opencv_core.CvMat[]{objectPoints, imagePoints, pointCounts};
    }

    public static double[] computeReprojectionError(opencv_core.CvMat object_points, opencv_core.CvMat image_points, opencv_core.CvMat point_counts, opencv_core.CvMat camera_matrix, opencv_core.CvMat dist_coeffs, opencv_core.CvMat rot_vects, opencv_core.CvMat trans_vects, opencv_core.CvMat per_view_errors) {
        opencv_core.CvMat image_points2 = opencv_core.CvMat.create((int)image_points.rows(), (int)image_points.cols(), (int)image_points.type());
        int image_count = rot_vects.rows();
        int points_so_far = 0;
        double total_err = 0.0;
        double max_err = 0.0;
        opencv_core.CvMat object_points_i = new opencv_core.CvMat();
        opencv_core.CvMat image_points_i = new opencv_core.CvMat();
        opencv_core.CvMat image_points2_i = new opencv_core.CvMat();
        IntBuffer point_counts_buf = point_counts.getIntBuffer();
        opencv_core.CvMat rot_vect = new opencv_core.CvMat();
        opencv_core.CvMat trans_vect = new opencv_core.CvMat();
        for (int i = 0; i < image_count; ++i) {
            object_points_i.reset();
            image_points_i.reset();
            image_points2_i.reset();
            int point_count = point_counts_buf.get(i);
            opencv_core.cvGetCols((opencv_core.CvArr)object_points, (opencv_core.CvMat)object_points_i, (int)points_so_far, (int)(points_so_far + point_count));
            opencv_core.cvGetCols((opencv_core.CvArr)image_points, (opencv_core.CvMat)image_points_i, (int)points_so_far, (int)(points_so_far + point_count));
            opencv_core.cvGetCols((opencv_core.CvArr)image_points2, (opencv_core.CvMat)image_points2_i, (int)points_so_far, (int)(points_so_far + point_count));
            points_so_far += point_count;
            opencv_core.cvGetRows((opencv_core.CvArr)rot_vects, (opencv_core.CvMat)rot_vect, (int)i, (int)(i + 1), (int)1);
            opencv_core.cvGetRows((opencv_core.CvArr)trans_vects, (opencv_core.CvMat)trans_vect, (int)i, (int)(i + 1), (int)1);
            opencv_calib3d.cvProjectPoints2((opencv_core.CvMat)object_points_i, (opencv_core.CvMat)rot_vect, (opencv_core.CvMat)trans_vect, (opencv_core.CvMat)camera_matrix, (opencv_core.CvMat)dist_coeffs, (opencv_core.CvMat)image_points2_i);
            double err = opencv_core.cvNorm((opencv_core.CvArr)image_points_i, (opencv_core.CvArr)image_points2_i);
            err *= err;
            if (per_view_errors != null) {
                per_view_errors.put(i, Math.sqrt(err / (double)point_count));
            }
            total_err += err;
            for (int j = 0; j < point_count; ++j) {
                double y2;
                double dy;
                double x1 = image_points_i.get(0, j, 0);
                double y1 = image_points_i.get(0, j, 1);
                double x2 = image_points2_i.get(0, j, 0);
                double dx = x1 - x2;
                err = Math.sqrt(dx * dx + (dy = y1 - (y2 = image_points2_i.get(0, j, 1))) * dy);
                if (!(err > max_err)) continue;
                max_err = err;
            }
        }
        return new double[]{Math.sqrt(total_err / (double)points_so_far), max_err};
    }

    public double[] calibrate(boolean useCenters) {
        int kn;
        ProjectiveDevice d = this.projectiveDevice;
        ProjectiveDevice.CalibrationSettings dsettings = (ProjectiveDevice.CalibrationSettings)d.getSettings();
        if (d.cameraMatrix == null) {
            d.cameraMatrix = opencv_core.CvMat.create((int)3, (int)3);
            opencv_core.cvSetZero((opencv_core.CvArr)d.cameraMatrix);
            if ((dsettings.flags & 2) != 0) {
                d.cameraMatrix.put(0, dsettings.initAspectRatio);
                d.cameraMatrix.put(4, 1.0);
            }
        }
        int n = kn = dsettings.isFixK3() ? 4 : 5;
        if (dsettings.isRationalModel() && !dsettings.isFixK4() && !dsettings.isFixK4() && !dsettings.isFixK5()) {
            kn = 8;
        }
        if (d.distortionCoeffs == null || d.distortionCoeffs.cols() != kn) {
            d.distortionCoeffs = opencv_core.CvMat.create((int)1, (int)kn);
            opencv_core.cvSetZero((opencv_core.CvArr)d.distortionCoeffs);
        }
        opencv_core.CvMat rotVects = new opencv_core.CvMat();
        opencv_core.CvMat transVects = new opencv_core.CvMat();
        d.extrParams = opencv_core.CvMat.create((int)this.allImageMarkers.size(), (int)6);
        opencv_core.cvGetCols((opencv_core.CvArr)d.extrParams, (opencv_core.CvMat)rotVects, (int)0, (int)3);
        opencv_core.cvGetCols((opencv_core.CvArr)d.extrParams, (opencv_core.CvMat)transVects, (int)3, (int)6);
        opencv_core.CvMat[] points = this.getPoints(useCenters);
        opencv_calib3d.cvCalibrateCamera2((opencv_core.CvMat)points[0], (opencv_core.CvMat)points[1], (opencv_core.CvMat)points[2], (opencv_core.CvSize)opencv_core.cvSize((int)d.imageWidth, (int)d.imageHeight), (opencv_core.CvMat)d.cameraMatrix, (opencv_core.CvMat)d.distortionCoeffs, (opencv_core.CvMat)rotVects, (opencv_core.CvMat)transVects, (int)dsettings.flags, (opencv_core.CvTermCriteria)opencv_core.cvTermCriteria((int)3, (int)30, (double)2.220446049250313E-16));
        if (opencv_core.cvCheckArr((opencv_core.CvArr)d.cameraMatrix, (int)2, (double)0.0, (double)0.0) != 0 && opencv_core.cvCheckArr((opencv_core.CvArr)d.distortionCoeffs, (int)2, (double)0.0, (double)0.0) != 0 && opencv_core.cvCheckArr((opencv_core.CvArr)d.extrParams, (int)2, (double)0.0, (double)0.0) != 0) {
            d.reprojErrs = opencv_core.CvMat.create((int)1, (int)this.allImageMarkers.size());
            double[] err = GeometricCalibrator.computeReprojectionError(points[0], points[1], points[2], d.cameraMatrix, d.distortionCoeffs, rotVects, transVects, d.reprojErrs);
            d.avgReprojErr = err[0];
            d.maxReprojErr = err[1];
            return err;
        }
        d.cameraMatrix = null;
        d.avgReprojErr = -1.0;
        d.maxReprojErr = -1.0;
        return null;
    }

    public static double[] computeStereoError(opencv_core.CvMat imagePoints1, opencv_core.CvMat imagePoints2, opencv_core.CvMat M1, opencv_core.CvMat D1, opencv_core.CvMat M2, opencv_core.CvMat D2, opencv_core.CvMat F) {
        int N = imagePoints1.cols();
        opencv_core.CvMat L1 = opencv_core.CvMat.create((int)1, (int)N, (int)5, (int)3);
        opencv_core.CvMat L2 = opencv_core.CvMat.create((int)1, (int)N, (int)5, (int)3);
        opencv_imgproc.cvUndistortPoints((opencv_core.CvMat)imagePoints1, (opencv_core.CvMat)imagePoints1, (opencv_core.CvMat)M1, (opencv_core.CvMat)D1, null, (opencv_core.CvMat)M1);
        opencv_imgproc.cvUndistortPoints((opencv_core.CvMat)imagePoints2, (opencv_core.CvMat)imagePoints2, (opencv_core.CvMat)M2, (opencv_core.CvMat)D2, null, (opencv_core.CvMat)M2);
        opencv_calib3d.cvComputeCorrespondEpilines((opencv_core.CvMat)imagePoints1, (int)1, (opencv_core.CvMat)F, (opencv_core.CvMat)L1);
        opencv_calib3d.cvComputeCorrespondEpilines((opencv_core.CvMat)imagePoints2, (int)2, (opencv_core.CvMat)F, (opencv_core.CvMat)L2);
        double avgErr = 0.0;
        double maxErr = 0.0;
        opencv_core.CvMat p1 = imagePoints1;
        opencv_core.CvMat p2 = imagePoints2;
        for (int i = 0; i < N; ++i) {
            double e1 = p1.get(0, i, 0) * L2.get(0, i, 0) + p1.get(0, i, 1) * L2.get(0, i, 1) + L2.get(0, i, 2);
            double e2 = p2.get(0, i, 0) * L1.get(0, i, 0) + p2.get(0, i, 1) * L1.get(0, i, 1) + L1.get(0, i, 2);
            double err = e1 * e1 + e2 * e2;
            avgErr += err;
            if (!((err = Math.sqrt(err)) > maxErr)) continue;
            maxErr = err;
        }
        return new double[]{Math.sqrt(avgErr / (double)N), maxErr};
    }

    public double[] calibrateStereo(boolean useCenters, GeometricCalibrator peer) {
        ProjectiveDevice d = this.projectiveDevice;
        ProjectiveDevice dp = peer.projectiveDevice;
        ProjectiveDevice.CalibrationSettings dsettings = (ProjectiveDevice.CalibrationSettings)d.getSettings();
        ProjectiveDevice.CalibrationSettings dpsettings = (ProjectiveDevice.CalibrationSettings)dp.getSettings();
        opencv_core.CvMat[] points1 = this.getPoints(useCenters);
        opencv_core.CvMat[] points2 = peer.getPoints(useCenters);
        FloatBuffer objPts1 = points1[0].getFloatBuffer();
        FloatBuffer imgPts1 = points1[1].getFloatBuffer();
        IntBuffer imgCount1 = points1[2].getIntBuffer();
        FloatBuffer objPts2 = points2[0].getFloatBuffer();
        FloatBuffer imgPts2 = points2[1].getFloatBuffer();
        IntBuffer imgCount2 = points2[2].getIntBuffer();
        assert (imgCount1.capacity() == imgCount2.capacity());
        opencv_core.CvMat objectPointsMat = opencv_core.CvMat.create((int)1, (int)Math.min(objPts1.capacity(), objPts2.capacity()), (int)5, (int)3);
        opencv_core.CvMat imagePoints1Mat = opencv_core.CvMat.create((int)1, (int)Math.min(imgPts1.capacity(), imgPts2.capacity()), (int)5, (int)2);
        opencv_core.CvMat imagePoints2Mat = opencv_core.CvMat.create((int)1, (int)Math.min(imgPts1.capacity(), imgPts2.capacity()), (int)5, (int)2);
        opencv_core.CvMat pointCountsMat = opencv_core.CvMat.create((int)1, (int)imgCount1.capacity(), (int)4, (int)1);
        FloatBuffer objectPoints = objectPointsMat.getFloatBuffer();
        FloatBuffer imagePoints1 = imagePoints1Mat.getFloatBuffer();
        FloatBuffer imagePoints2 = imagePoints2Mat.getFloatBuffer();
        IntBuffer pointCounts = pointCountsMat.getIntBuffer();
        int end1 = 0;
        int end2 = 0;
        for (int i = 0; i < imgCount1.capacity(); ++i) {
            int start1 = end1;
            int start2 = end2;
            end1 = start1 + imgCount1.get(i);
            end2 = start2 + imgCount2.get(i);
            int count = 0;
            block1: for (int j = start1; j < end1; ++j) {
                float x1 = objPts1.get(j * 3);
                float y1 = objPts1.get(j * 3 + 1);
                float z1 = objPts1.get(j * 3 + 2);
                for (int k = start2; k < end2; ++k) {
                    float x2 = objPts2.get(k * 3);
                    float y2 = objPts2.get(k * 3 + 1);
                    float z2 = objPts2.get(k * 3 + 2);
                    if (x1 != x2 || y1 != y2 || z1 != z2) continue;
                    objectPoints.put(x1);
                    objectPoints.put(y1);
                    objectPoints.put(z1);
                    imagePoints1.put(imgPts1.get(j * 2));
                    imagePoints1.put(imgPts1.get(j * 2 + 1));
                    imagePoints2.put(imgPts2.get(k * 2));
                    imagePoints2.put(imgPts2.get(k * 2 + 1));
                    ++count;
                    continue block1;
                }
            }
            if (count <= 0) continue;
            pointCounts.put(count);
        }
        objectPointsMat.cols(objectPoints.position() / 3);
        imagePoints1Mat.cols(imagePoints1.position() / 2);
        imagePoints2Mat.cols(imagePoints2.position() / 2);
        pointCountsMat.cols(pointCounts.position());
        d.R = opencv_core.CvMat.create((int)3, (int)3);
        d.R.put(new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0});
        d.T = opencv_core.CvMat.create((int)3, (int)1);
        d.T.put(new double[]{0.0, 0.0, 0.0});
        d.E = opencv_core.CvMat.create((int)3, (int)3);
        opencv_core.cvSetZero((opencv_core.CvArr)d.E);
        d.F = opencv_core.CvMat.create((int)3, (int)3);
        opencv_core.cvSetZero((opencv_core.CvArr)d.F);
        dp.R = opencv_core.CvMat.create((int)3, (int)3);
        dp.T = opencv_core.CvMat.create((int)3, (int)1);
        dp.E = opencv_core.CvMat.create((int)3, (int)3);
        dp.F = opencv_core.CvMat.create((int)3, (int)3);
        opencv_calib3d.cvStereoCalibrate((opencv_core.CvMat)objectPointsMat, (opencv_core.CvMat)imagePoints1Mat, (opencv_core.CvMat)imagePoints2Mat, (opencv_core.CvMat)pointCountsMat, (opencv_core.CvMat)d.cameraMatrix, (opencv_core.CvMat)d.distortionCoeffs, (opencv_core.CvMat)dp.cameraMatrix, (opencv_core.CvMat)dp.distortionCoeffs, (opencv_core.CvSize)opencv_core.cvSize((int)d.imageWidth, (int)d.imageHeight), (opencv_core.CvMat)dp.R, (opencv_core.CvMat)dp.T, (opencv_core.CvMat)dp.E, (opencv_core.CvMat)dp.F, (int)dpsettings.flags, (opencv_core.CvTermCriteria)opencv_core.cvTermCriteria((int)3, (int)100, (double)1.0E-6));
        d.avgEpipolarErr = 0.0;
        d.maxEpipolarErr = 0.0;
        double[] err = GeometricCalibrator.computeStereoError(imagePoints1Mat, imagePoints2Mat, d.cameraMatrix, d.distortionCoeffs, dp.cameraMatrix, dp.distortionCoeffs, dp.F);
        dp.avgEpipolarErr = err[0];
        dp.maxEpipolarErr = err[1];
        return err;
    }

    public static class Settings
    extends BaseChildSettings {
        double detectedBoardMin = 0.5;
        double patternSteadySize = 0.005;
        double patternMovedSize = 0.05;

        public double getDetectedBoardMin() {
            return this.detectedBoardMin;
        }

        public void setDetectedBoardMin(double detectedBoardMin) {
            this.detectedBoardMin = detectedBoardMin;
        }

        public double getPatternSteadySize() {
            return this.patternSteadySize;
        }

        public void setPatternSteadySize(double patternSteadySize) {
            this.patternSteadySize = patternSteadySize;
        }

        public double getPatternMovedSize() {
            return this.patternMovedSize;
        }

        public void setPatternMovedSize(double patternMovedSize) {
            this.patternMovedSize = patternMovedSize;
        }
    }
}

