/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.io.File;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_highgui;
import org.bytedeco.javacpp.opencv_videoio;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameRecorder;
import org.bytedeco.javacv.OpenCVFrameConverter;

public class OpenCVFrameRecorder
extends FrameRecorder {
    private static FrameRecorder.Exception loadingException = null;
    private static final boolean windows = Loader.getPlatform().startsWith("windows");
    private String filename;
    private opencv_videoio.VideoWriter writer = null;
    private OpenCVFrameConverter.ToMat converter = new OpenCVFrameConverter.ToMat();

    public static OpenCVFrameRecorder createDefault(File f, int w, int h) throws FrameRecorder.Exception {
        return new OpenCVFrameRecorder(f, w, h);
    }

    public static OpenCVFrameRecorder createDefault(String f, int w, int h) throws FrameRecorder.Exception {
        return new OpenCVFrameRecorder(f, w, h);
    }

    public static void tryLoad() throws FrameRecorder.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(opencv_highgui.class);
        }
        catch (Throwable t) {
            loadingException = new FrameRecorder.Exception("Failed to load " + OpenCVFrameRecorder.class, t);
            throw loadingException;
        }
    }

    public OpenCVFrameRecorder(File file, int imageWidth, int imageHeight) {
        this(file.getAbsolutePath(), imageWidth, imageHeight);
    }

    public OpenCVFrameRecorder(String filename, int imageWidth, int imageHeight) {
        this.filename = filename;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.pixelFormat = 1;
        this.videoCodec = windows ? -1 : opencv_videoio.CV_FOURCC_DEFAULT;
        this.frameRate = 30.0;
    }

    @Override
    public void release() throws FrameRecorder.Exception {
        if (this.writer != null) {
            this.writer.release();
            this.writer = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public void start() throws FrameRecorder.Exception {
        this.writer = new opencv_videoio.VideoWriter(this.filename, this.fourCCCodec(), this.frameRate, new opencv_core.Size(this.imageWidth, this.imageHeight), this.isColour());
    }

    private boolean isColour() {
        return this.pixelFormat != 0;
    }

    private int fourCCCodec() {
        return this.videoCodec;
    }

    @Override
    public void stop() throws FrameRecorder.Exception {
        this.release();
    }

    @Override
    public void record(Frame frame) throws FrameRecorder.Exception {
        opencv_core.Mat mat = this.converter.convert(frame);
        if (this.writer == null) {
            throw new FrameRecorder.Exception("Cannot record: There is no writer (Has start() been called?)");
        }
        this.writer.write(mat);
        frame.keyFrame = true;
    }
}

