/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class RecipientInformationStore {
    private final List all;
    private final Map table = new HashMap();

    public RecipientInformationStore(Collection collection) {
        for (RecipientInformation recipientInformation : collection) {
            RecipientId recipientId = recipientInformation.getRID();
            ArrayList<RecipientInformation> arrayList = (ArrayList<RecipientInformation>)this.table.get(recipientId);
            if (arrayList == null) {
                arrayList = new ArrayList<RecipientInformation>(1);
                this.table.put(recipientId, arrayList);
            }
            arrayList.add(recipientInformation);
        }
        this.all = new ArrayList(collection);
    }

    public RecipientInformation get(RecipientId recipientId) {
        Collection collection = this.getRecipients(recipientId);
        return collection.size() == 0 ? null : (RecipientInformation)collection.iterator().next();
    }

    public int size() {
        return this.all.size();
    }

    public Collection getRecipients() {
        return new ArrayList(this.all);
    }

    public Collection getRecipients(RecipientId recipientId) {
        if (recipientId instanceof KeyTransRecipientId) {
            KeyTransRecipientId keyTransRecipientId = (KeyTransRecipientId)recipientId;
            byte[] byArray = keyTransRecipientId.getSubjectKeyIdentifier();
            if (keyTransRecipientId.getIssuer() != null && byArray != null) {
                Collection collection;
                ArrayList arrayList = new ArrayList();
                Collection collection2 = this.getRecipients(new KeyTransRecipientId(keyTransRecipientId.getIssuer(), keyTransRecipientId.getSerialNumber()));
                if (collection2 != null) {
                    arrayList.addAll(collection2);
                }
                if ((collection = this.getRecipients(new KeyTransRecipientId(byArray))) != null) {
                    arrayList.addAll(collection);
                }
                return arrayList;
            }
            ArrayList arrayList = (ArrayList)this.table.get(recipientId);
            return arrayList == null ? new ArrayList() : new ArrayList(arrayList);
        }
        ArrayList arrayList = (ArrayList)this.table.get(recipientId);
        return arrayList == null ? new ArrayList() : new ArrayList(arrayList);
    }
}

