/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.Zhang99Parameters;
import georegression.struct.point.Point2D_F64;

public class ParametersPointsZhang99
extends Zhang99Parameters {
    int numCalibrationPoints;
    Point2D_F64[][] points;

    public ParametersPointsZhang99(boolean assumeZeroSkew, int numDistort, int numViews, int numCalibrationPoints) {
        super(assumeZeroSkew, numDistort, numViews);
        this.numCalibrationPoints = numCalibrationPoints;
        this.points = new Point2D_F64[numViews][];
        for (int i = 0; i < numViews; ++i) {
            this.points[i] = new Point2D_F64[numCalibrationPoints];
            Point2D_F64[] v = this.points[i];
            for (int j = 0; j < v.length; ++j) {
                v[j] = new Point2D_F64();
            }
        }
    }

    @Override
    public ParametersPointsZhang99 createNew() {
        return new ParametersPointsZhang99(this.assumeZeroSkew, this.distortion.length, this.views.length, this.numCalibrationPoints);
    }

    @Override
    public ParametersPointsZhang99 copy() {
        int i;
        ParametersPointsZhang99 ret = this.createNew();
        ret.a = this.a;
        ret.b = this.b;
        ret.c = this.c;
        ret.x0 = this.x0;
        ret.y0 = this.y0;
        for (i = 0; i < this.distortion.length; ++i) {
            ret.distortion[i] = this.distortion[i];
        }
        for (i = 0; i < this.views.length; ++i) {
            Zhang99Parameters.View a = this.views[i];
            Zhang99Parameters.View b = ret.views[i];
            b.rotation.unitAxisRotation.set(a.rotation.unitAxisRotation);
            b.rotation.theta = a.rotation.theta;
            b.T.set(a.T);
            Point2D_F64[] pts = this.points[i];
            Point2D_F64[] ptsb = ret.points[i];
            for (int j = 0; j < this.numCalibrationPoints; ++j) {
                ptsb[j].set(pts[j]);
            }
        }
        return ret;
    }

    @Override
    public int size() {
        return 5 + this.distortion.length + (7 + this.numCalibrationPoints) * this.views.length;
    }

    @Override
    public void setFromParam(double[] param) {
        super.setFromParam(param);
        int index = super.size();
        for (int viewIndex = 0; viewIndex < this.views.length; ++viewIndex) {
            Point2D_F64[] pts = this.points[viewIndex];
            for (int i = 0; i < this.numCalibrationPoints; ++i) {
                pts[i].set(param[index++], param[index++]);
            }
        }
    }

    @Override
    public void convertToParam(double[] param) {
        super.convertToParam(param);
        int index = super.size();
        for (int viewIndex = 0; viewIndex < this.views.length; ++viewIndex) {
            Point2D_F64[] pts = this.points[viewIndex];
            for (int i = 0; i < this.numCalibrationPoints; ++i) {
                Point2D_F64 p = pts[i];
                param[index++] = p.x;
                param[index++] = p.y;
            }
        }
    }
}

