/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.forester.util.ForesterUtil;

class ThreadedStreamHandler
extends Thread {
    InputStream inputStream;
    String adminPassword;
    OutputStream outputStream;
    PrintWriter printWriter;
    StringBuilder outputBuffer = new StringBuilder(65536);
    private boolean sudoIsRequested = false;

    ThreadedStreamHandler(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    ThreadedStreamHandler(InputStream inputStream, OutputStream outputStream, String adminPassword) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.printWriter = new PrintWriter(outputStream);
        this.adminPassword = adminPassword;
        this.sudoIsRequested = true;
    }

    ThreadedStreamHandler(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.printWriter = new PrintWriter(outputStream);
        this.sudoIsRequested = false;
    }

    private void doSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public StringBuilder getOutputBuffer() {
        return this.outputBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.sudoIsRequested) {
            this.printWriter.println(this.adminPassword);
            this.printWriter.flush();
        }
        BufferedReader bufferedReader = null;
        String newline = ForesterUtil.LINE_SEPARATOR;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                this.outputBuffer.append(line);
                this.outputBuffer.append(newline);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException ioe) {}
        }
    }
}

