/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.phylogeny.Phylogeny;
import org.forester.species.Species;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.DomainArchitectureBasedGenomeSimilarityCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class PairwiseGenomeComparator {
    private List<DistanceMatrix> _domain_distance_scores_means;
    private List<DistanceMatrix> _shared_binary_combinations_based_distances;
    private List<DistanceMatrix> _shared_domains_based_distances;

    public PairwiseGenomeComparator() {
        this.init();
    }

    public List<DistanceMatrix> getDomainDistanceScoresMeans() {
        return this._domain_distance_scores_means;
    }

    public List<DistanceMatrix> getSharedBinaryCombinationsBasedDistances() {
        return this._shared_binary_combinations_based_distances;
    }

    public List<DistanceMatrix> getSharedDomainsBasedDistances() {
        return this._shared_domains_based_distances;
    }

    public void performPairwiseComparisons(StringBuilder html_desc, boolean sort_by_species_count_first, DomainSimilarityCalculator.Detailedness detailedness, boolean ignore_domains_without_combs_in_all_spec, boolean ignore_domains_specific_to_one_species, DomainSimilarity.DomainSimilaritySortField domain_similarity_sort_field, DomainSimilarity.PRINT_OPTION domain_similarity_print_option, DomainSimilarity.DomainSimilarityScoring scoring, Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, GoNameSpace go_namespace_limit, Species[] species, int number_of_genomes, List<GenomeWideCombinableDomains> list_of_genome_wide_combinable_domains, PairwiseDomainSimilarityCalculator pw_calc, String automated_pairwise_comparison_suffix, boolean verbose, String automated_pairwise_comparison_prefix, String command_line_prg_name, File out_dir, boolean write_pairwise_comparisons, Map<String, Integer> tax_code_to_id_map, boolean calc_similarity_scores, Phylogeny phy) {
        this.init();
        BasicSymmetricalDistanceMatrix domain_distance_scores_means = new BasicSymmetricalDistanceMatrix(number_of_genomes);
        BasicSymmetricalDistanceMatrix shared_domains_based_distances = new BasicSymmetricalDistanceMatrix(number_of_genomes);
        BasicSymmetricalDistanceMatrix shared_binary_combinations_based_distances = new BasicSymmetricalDistanceMatrix(number_of_genomes);
        if (verbose) {
            System.out.println();
            System.out.println("Pairwise genome distances:");
            System.out.print("[species-i - species-j:");
            System.out.print(" mean-score-based");
            System.out.print(" (sd)");
            System.out.print(" [N]");
            System.out.print(" | shared-domains-based");
            System.out.println(" | shared-binary-combinations-based]");
            System.out.println();
        }
        for (int i = 0; i < number_of_genomes; ++i) {
            String species_i = species[i].getSpeciesId();
            domain_distance_scores_means.setIdentifier(i, species_i);
            shared_domains_based_distances.setIdentifier(i, species_i);
            shared_binary_combinations_based_distances.setIdentifier(i, species_i);
            if (verbose) {
                System.out.println(i + 1 + "/" + number_of_genomes);
            }
            for (int j = 0; j < i; ++j) {
                if (list_of_genome_wide_combinable_domains.get(i).getSize() < 1 || list_of_genome_wide_combinable_domains.get(j).getSize() < 1) {
                    domain_distance_scores_means.setValue(i, j, 1.0);
                    shared_domains_based_distances.setValue(i, j, 1.0);
                    shared_binary_combinations_based_distances.setValue(i, j, 1.0);
                    continue;
                }
                ArrayList<GenomeWideCombinableDomains> genome_pair = new ArrayList<GenomeWideCombinableDomains>(2);
                genome_pair.add(list_of_genome_wide_combinable_domains.get(i));
                genome_pair.add(list_of_genome_wide_combinable_domains.get(j));
                DomainSimilarityCalculator.GoAnnotationOutput go_annotation_output = DomainSimilarityCalculator.GoAnnotationOutput.NONE;
                if (domain_id_to_go_ids_map != null) {
                    go_annotation_output = DomainSimilarityCalculator.GoAnnotationOutput.ALL;
                }
                BasicDomainSimilarityCalculator calc = new BasicDomainSimilarityCalculator(domain_similarity_sort_field, sort_by_species_count_first, true, calc_similarity_scores, true);
                SortedSet<DomainSimilarity> similarities = calc.calculateSimilarities(pw_calc, genome_pair, ignore_domains_without_combs_in_all_spec, ignore_domains_specific_to_one_species);
                SurfacingUtil.decoratePrintableDomainSimilarities(similarities, detailedness);
                DescriptiveStatistics stats = SurfacingUtil.calculateDescriptiveStatisticsForMeanValues(similarities);
                String species_j = species[j].getSpeciesId();
                DomainArchitectureBasedGenomeSimilarityCalculator genome_similarity_calculator = new DomainArchitectureBasedGenomeSimilarityCalculator(list_of_genome_wide_combinable_domains.get(i), list_of_genome_wide_combinable_domains.get(j));
                genome_similarity_calculator.setAllowDomainsToBeIgnored(false);
                double dissimilarity_score_mean = stats.getN() < 1 ? 1.0 : 1.0 - stats.arithmeticMean();
                double shared_domains_based_genome_distance = 1.0 - genome_similarity_calculator.calculateSharedDomainsBasedGenomeSimilarityScore();
                double shared_binary_combinations_based_genome_distance = 1.0 - genome_similarity_calculator.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore();
                domain_distance_scores_means.setValue(i, j, dissimilarity_score_mean);
                shared_domains_based_distances.setValue(i, j, shared_domains_based_genome_distance);
                shared_binary_combinations_based_distances.setValue(i, j, shared_binary_combinations_based_genome_distance);
                if (verbose) {
                    System.out.print(species_i + "-");
                    System.out.print(species_j + ": ");
                    System.out.print(ForesterUtil.round(dissimilarity_score_mean, 2));
                    if (stats.getN() > 1) {
                        System.out.print(" (" + ForesterUtil.round(stats.sampleStandardDeviation(), 2) + ")");
                    } else {
                        System.out.print(" (n/a)");
                    }
                    System.out.print(" [" + stats.getN() + "]");
                    System.out.print(" | ");
                    System.out.print(ForesterUtil.round(shared_domains_based_genome_distance, 2));
                    System.out.print(" | ");
                    System.out.println(ForesterUtil.round(shared_binary_combinations_based_genome_distance, 2));
                }
                String pairwise_similarities_output_file_str = automated_pairwise_comparison_prefix + species_i + "_" + species_j + automated_pairwise_comparison_suffix;
                switch (domain_similarity_print_option) {
                    case HTML: {
                        if (pairwise_similarities_output_file_str.endsWith(".html")) break;
                        pairwise_similarities_output_file_str = pairwise_similarities_output_file_str + ".html";
                    }
                }
                if (!write_pairwise_comparisons) continue;
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(out_dir == null ? pairwise_similarities_output_file_str : out_dir + ForesterUtil.FILE_SEPARATOR + pairwise_similarities_output_file_str));
                    SurfacingUtil.writeDomainSimilaritiesToFile(html_desc, new StringBuilder(species_i + "-" + species_j), null, writer, null, similarities, true, null, domain_similarity_print_option, scoring, false, tax_code_to_id_map, phy, null);
                    continue;
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(command_line_prg_name, "Failed to write similarites to: \"" + pairwise_similarities_output_file_str + "\" [" + e.getMessage() + "]");
                }
            }
        }
        this.getDomainDistanceScoresMeans().add(domain_distance_scores_means);
        this.getSharedDomainsBasedDistances().add(shared_domains_based_distances);
        this.getSharedBinaryCombinationsBasedDistances().add(shared_binary_combinations_based_distances);
        if (verbose) {
            System.out.println();
        }
    }

    public void performPairwiseComparisonsJacknifed(Species[] species, int number_of_genomes, List<GenomeWideCombinableDomains> list_of_genome_wide_combinable_domains, boolean verbose, int number_of_resamplings, double jacknife_ratio, long random_seed) {
        this.init();
        if (number_of_resamplings < 2) {
            throw new IllegalArgumentException("attempt to perform jacknife resampling with less than 2 resamplings");
        }
        if (jacknife_ratio <= 0.0) {
            throw new IllegalArgumentException("attempt to perform jacknife resampling with jacknife ratio of 0.0 or less");
        }
        if (jacknife_ratio >= 1.0) {
            throw new IllegalArgumentException("attempt to perform jacknife resampling with jacknife ratio 1.0 or more");
        }
        String[] all_unique_domain_ids = PairwiseGenomeComparator.getAllUniqueDomainIdAsArray(list_of_genome_wide_combinable_domains);
        if (verbose) {
            System.out.println();
            System.out.println("Jacknife: total of domains: " + all_unique_domain_ids.length);
        }
        if (verbose) {
            System.out.print("resampling ");
        }
        Random generator = new Random(random_seed);
        for (int r = 0; r < number_of_resamplings; ++r) {
            if (verbose) {
                System.out.print(" " + r);
            }
            SortedSet<String> domain_ids_to_ignore = PairwiseGenomeComparator.randomlyPickDomainIds(all_unique_domain_ids, jacknife_ratio, generator);
            BasicSymmetricalDistanceMatrix shared_domains_based_distances = new BasicSymmetricalDistanceMatrix(number_of_genomes);
            BasicSymmetricalDistanceMatrix shared_binary_combinations_based_distances = new BasicSymmetricalDistanceMatrix(number_of_genomes);
            for (int i = 0; i < number_of_genomes; ++i) {
                String species_i = species[i].getSpeciesId();
                shared_domains_based_distances.setIdentifier(i, species_i);
                shared_binary_combinations_based_distances.setIdentifier(i, species_i);
                for (int j = 0; j < i; ++j) {
                    ArrayList<GenomeWideCombinableDomains> genome_pair = new ArrayList<GenomeWideCombinableDomains>(2);
                    genome_pair.add(list_of_genome_wide_combinable_domains.get(i));
                    genome_pair.add(list_of_genome_wide_combinable_domains.get(j));
                    DomainArchitectureBasedGenomeSimilarityCalculator genome_simiarity_calculator = new DomainArchitectureBasedGenomeSimilarityCalculator(list_of_genome_wide_combinable_domains.get(i), list_of_genome_wide_combinable_domains.get(j));
                    genome_simiarity_calculator.setAllowDomainsToBeIgnored(true);
                    genome_simiarity_calculator.setDomainIdsToIgnore(domain_ids_to_ignore);
                    shared_domains_based_distances.setValue(i, j, 1.0 - genome_simiarity_calculator.calculateSharedDomainsBasedGenomeSimilarityScore());
                    shared_binary_combinations_based_distances.setValue(i, j, 1.0 - genome_simiarity_calculator.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore());
                }
            }
            this.getSharedDomainsBasedDistances().add(shared_domains_based_distances);
            this.getSharedBinaryCombinationsBasedDistances().add(shared_binary_combinations_based_distances);
        }
        if (verbose) {
            System.out.println();
        }
    }

    private void init() {
        this._domain_distance_scores_means = new ArrayList<DistanceMatrix>();
        this._shared_domains_based_distances = new ArrayList<DistanceMatrix>();
        this._shared_binary_combinations_based_distances = new ArrayList<DistanceMatrix>();
    }

    private static String[] getAllUniqueDomainIdAsArray(List<GenomeWideCombinableDomains> list_of_genome_wide_combinable_domains) {
        TreeSet<String> all_domain_ids = new TreeSet<String>();
        for (GenomeWideCombinableDomains genome_wide_combinable_domains : list_of_genome_wide_combinable_domains) {
            SortedSet<String> all_domains = genome_wide_combinable_domains.getAllDomainIds();
            for (String domain : all_domains) {
                all_domain_ids.add(domain);
            }
        }
        String[] all_domain_ids_array = new String[all_domain_ids.size()];
        int n = 0;
        for (String domain_id : all_domain_ids) {
            all_domain_ids_array[n++] = domain_id;
        }
        return all_domain_ids_array;
    }

    private static SortedSet<String> randomlyPickDomainIds(String[] all_domain_ids_array, double jacknife_ratio, Random generator) {
        int size = all_domain_ids_array.length;
        TreeSet<String> random_domain_ids = new TreeSet<String>();
        int number_of_ids_pick = ForesterUtil.roundToInt(jacknife_ratio * (double)size);
        while (random_domain_ids.size() < number_of_ids_pick) {
            int r = generator.nextInt(size);
            random_domain_ids.add(all_domain_ids_array[r]);
        }
        return random_domain_ids;
    }
}

