/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import java.util.Stack;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PostOrderStackObject;

public final class PostorderTreeIterator
implements PhylogenyNodeIterator {
    private final Phylogeny _tree;
    private final PhylogenyNode _root;
    private boolean _has_next;
    private final Stack<PostOrderStackObject> _stack;

    public PostorderTreeIterator(Phylogeny tree) throws IllegalArgumentException {
        if (tree.isEmpty()) {
            throw new IllegalArgumentException("Attempt to use PostorderTreeIterator on an empty phylogeny.");
        }
        this._tree = tree;
        this._root = this.getTree().getRoot();
        this._stack = new Stack();
        this.reset();
    }

    private final PhylogenyNode getRoot() {
        return this._root;
    }

    private final Stack<PostOrderStackObject> getStack() {
        return this._stack;
    }

    private final Phylogeny getTree() {
        return this._tree;
    }

    @Override
    public final boolean hasNext() {
        return this._has_next;
    }

    @Override
    public final PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        while (true) {
            PostOrderStackObject si = this.getStack().pop();
            PhylogenyNode node = si.getNode();
            int phase = si.getPhase();
            if (phase > node.getNumberOfDescendants()) {
                this.setHasNext(node != this.getRoot());
                return node;
            }
            this.getStack().push(new PostOrderStackObject(node, phase + 1));
            if (!node.isInternal()) continue;
            this.getStack().push(new PostOrderStackObject(node.getChildNode(phase - 1), 1));
        }
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void reset() {
        this.setHasNext(true);
        this.getStack().clear();
        this.getStack().push(new PostOrderStackObject(this.getTree().getRoot(), 1));
    }

    private final void setHasNext(boolean has_next) {
        this._has_next = has_next;
    }
}

