/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;

public class Annotation
implements PhylogenyData,
MultipleUris,
Comparable<Annotation> {
    private Confidence _confidence;
    private String _desc;
    private String _evidence;
    private PropertiesMap _properties;
    private final String _ref_source;
    private final String _ref_value;
    private String _source;
    private String _type;
    private List<Uri> _uris;

    public Annotation() {
        this._ref_value = "";
        this._ref_source = "";
        this.init();
    }

    public Annotation(String ref) {
        if (ForesterUtil.isEmpty(ref)) {
            throw new IllegalArgumentException("annotation reference is empty or null");
        }
        String[] s = ref.split(":");
        if (s.length != 2 || ForesterUtil.isEmpty(s[0]) || ForesterUtil.isEmpty(s[1])) {
            throw new IllegalArgumentException("illegal format for annotation reference: [" + ref + "]");
        }
        this._ref_source = s[0];
        this._ref_value = s[1];
        this.init();
    }

    public Annotation(String ref_source, String ref_value) {
        if (ForesterUtil.isEmpty(ref_source) || ForesterUtil.isEmpty(ref_value)) {
            throw new IllegalArgumentException("illegal format for annotation reference");
        }
        this._ref_source = ref_source;
        this._ref_value = ref_value;
        this.init();
    }

    @Override
    public void addUri(Uri uri) {
        if (this.getUris() == null) {
            this.setUris(new ArrayList<Uri>());
        }
        this.getUris().add(uri);
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(!ForesterUtil.isEmpty(this.getRef()) ? this.getRef() : this.getDesc());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getDesc()) && !ForesterUtil.isEmpty(this.getRef())) {
            sb.append(this.getDesc());
            sb.append(" (");
            sb.append(this.getRef());
            sb.append(")");
        } else if (!ForesterUtil.isEmpty(this.getDesc())) {
            sb.append(this.getDesc());
        } else if (!ForesterUtil.isEmpty(this.getRef())) {
            sb.append(this.getRef());
        }
        return sb;
    }

    @Override
    public int compareTo(Annotation o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.getRef().equals(o.getRef())) {
            return this.getDesc().compareTo(o.getDesc());
        }
        return this.getRef().compareTo(o.getRef());
    }

    @Override
    public PhylogenyData copy() {
        Annotation ann = new Annotation(this.getRefSource(), this.getRefValue());
        if (this.getConfidence() != null) {
            ann.setConfidence((Confidence)this.getConfidence().copy());
        } else {
            ann.setConfidence(null);
        }
        ann.setType(this.getType());
        ann.setDesc(this.getDesc());
        ann.setEvidence(this.getEvidence());
        ann.setSource(new String(this.getSource()));
        if (this.getProperties() != null) {
            ann.setProperties((PropertiesMap)this.getProperties().copy());
        } else {
            ann.setProperties(null);
        }
        if (this.getUris() != null) {
            ann.setUris(new ArrayList<Uri>());
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                ann.getUris().add(uri);
            }
        }
        return ann;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.isEqual((Annotation)o);
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public String getDesc() {
        return this._desc;
    }

    public String getEvidence() {
        return this._evidence;
    }

    public PropertiesMap getProperties() {
        return this._properties;
    }

    public String getRef() {
        if (ForesterUtil.isEmpty(this._ref_source)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._ref_source);
        sb.append(':');
        sb.append(this._ref_value);
        return sb.toString();
    }

    public final String getRefSource() {
        return this._ref_source;
    }

    public final String getRefValue() {
        return this._ref_value;
    }

    public String getSource() {
        return this._source;
    }

    public String getType() {
        return this._type;
    }

    @Override
    public Uri getUri(int index) {
        return this.getUris().get(index);
    }

    @Override
    public List<Uri> getUris() {
        return this._uris;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        Annotation other = (Annotation)data;
        return this.getDesc().equalsIgnoreCase(other.getDesc()) && this.getType().equals(other.getType()) && this.getSource().equals(other.getSource()) && this.getRef().equals(other.getRef());
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDesc(String desc) {
        this._desc = desc;
    }

    public void setEvidence(String evidence) {
        this._evidence = evidence;
    }

    public void setProperties(PropertiesMap property) {
        this._properties = property;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public void setUris(List<Uri> uris) {
        this._uris = uris;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.getConfidence() != null || this.getProperties() != null || this.getUris() != null && !this.getUris().isEmpty() || !ForesterUtil.isEmpty(this.getDesc())) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(indentation);
            PhylogenyDataUtil.appendOpen(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource());
            if (!ForesterUtil.isEmpty(this.getDesc())) {
                PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), indentation);
            }
            if (this.getConfidence() != null) {
                this.getConfidence().toPhyloXML(writer, level, indentation + "  ");
            }
            if (this.getProperties() != null) {
                this.getProperties().toPhyloXML(writer, level, indentation);
            }
            if (this.getUris() != null) {
                for (Uri uri : this.getUris()) {
                    if (uri == null) continue;
                    uri.toPhyloXML(writer, level, indentation);
                }
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(indentation);
            PhylogenyDataUtil.appendClose(writer, "annotation");
        } else {
            PhylogenyDataUtil.appendElement(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource(), indentation);
        }
    }

    public String toString() {
        return this.asText().toString();
    }

    private void init() {
        this._desc = "";
        this._type = "";
        this._source = "";
        this._evidence = "";
        this._confidence = null;
        this._properties = null;
        this.setUris(null);
    }
}

