/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.writers;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class PhyloXmlNodeWriter {
    public static void toPhyloXml(Writer w, PhylogenyNode node, int level, String indentation) throws IOException {
        String ind = "";
        if (indentation != null && indentation.length() > 0) {
            ind = indentation + "  ";
        }
        if (!ForesterUtil.isEmpty(node.getName())) {
            PhylogenyDataUtil.appendElement(w, "name", node.getName(), indentation);
        }
        if (node.getDistanceToParent() != -1024.0) {
            PhylogenyDataUtil.appendElement(w, "branch_length", String.valueOf(ForesterUtil.round(node.getDistanceToParent(), 9)), indentation);
        }
        if (node.getBranchData() != null) {
            node.getBranchData().toPhyloXML(w, level, ind);
        }
        if (node.getNodeData() != null) {
            node.getNodeData().toPhyloXML(w, level, ind);
        }
    }
}

