/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.awt.Color;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.PhylogenyData;

public class ColorParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private ColorParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int j = 0; j < element.getNumberOfChildElements(); ++j) {
            XmlElement c = element.getChildElement(j);
            if (c.getQualifiedName().equals("red")) {
                red = c.getValueAsInt();
                continue;
            }
            if (c.getQualifiedName().equals("green")) {
                green = c.getValueAsInt();
                continue;
            }
            if (!c.getQualifiedName().equals("blue")) continue;
            blue = c.getValueAsInt();
        }
        BranchColor color = new BranchColor();
        color.setValue(new Color(red, green, blue));
        return color;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new ColorParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

