/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.parsimony;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class DolloParsimony {
    private static final CharacterStateMatrix.BinaryStates PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
    private static final CharacterStateMatrix.BinaryStates ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
    private static final CharacterStateMatrix.BinaryStates UNKNOWN = CharacterStateMatrix.BinaryStates.UNKNOWN;
    private static final CharacterStateMatrix.GainLossStates LOSS = CharacterStateMatrix.GainLossStates.LOSS;
    private static final CharacterStateMatrix.GainLossStates GAIN = CharacterStateMatrix.GainLossStates.GAIN;
    private static final CharacterStateMatrix.GainLossStates UNCHANGED_PRESENT = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
    private static final CharacterStateMatrix.GainLossStates UNCHANGED_ABSENT = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
    private static final boolean RETURN_INTERNAL_STATES_DEFAULT = false;
    private static final boolean RETURN_GAIN_LOSS_MATRIX_DEFAULT = false;
    private boolean _return_internal_states = false;
    private boolean _return_gain_loss = false;
    private int _total_gains;
    private int _total_losses;
    private int _total_unchanged;
    private CharacterStateMatrix<CharacterStateMatrix.BinaryStates> _internal_states_matrix;
    private CharacterStateMatrix<CharacterStateMatrix.GainLossStates> _gain_loss_matrix;

    private DolloParsimony() {
        this.init();
    }

    public void execute(Phylogeny p, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> external_node_states_matrix) {
        if (!p.isRooted()) {
            throw new IllegalArgumentException("attempt to execute Dollo parsimony on unroored phylogeny");
        }
        if (external_node_states_matrix.isEmpty()) {
            throw new IllegalArgumentException("character matrix is empty");
        }
        if (external_node_states_matrix.getNumberOfIdentifiers() != p.getNumberOfExternalNodes()) {
            throw new IllegalArgumentException("number of external nodes in phylogeny [" + p.getNumberOfExternalNodes() + "] and number of indentifiers [" + external_node_states_matrix.getNumberOfIdentifiers() + "] in matrix are not equal");
        }
        this.reset();
        if (this.isReturnInternalStates()) {
            this.initializeInternalStates(p, external_node_states_matrix);
        }
        if (this.isReturnGainLossMatrix()) {
            this.initializeGainLossMatrix(p, external_node_states_matrix);
        }
        for (int character_index = 0; character_index < external_node_states_matrix.getNumberOfCharacters(); ++character_index) {
            this.executeForOneCharacter(p, this.getStatesForCharacter(p, external_node_states_matrix, character_index), character_index);
        }
        if (external_node_states_matrix.getNumberOfCharacters() * p.getNumberOfBranches() != this.getTotalGains() + this.getTotalLosses() + this.getTotalUnchanged()) {
            throw new AssertionError((Object)"this should not have happened: something is deeply wrong with Dollo parsimony implementation");
        }
    }

    private void executeForOneCharacter(Phylogeny p, Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> states, int character_state_column) {
        this.postOrderTraversal(p, states);
        this.preOrderTraversal(p, states, character_state_column);
    }

    public int getCost() {
        return this.getTotalGains() + this.getTotalLosses();
    }

    public CharacterStateMatrix<CharacterStateMatrix.GainLossStates> getGainLossMatrix() {
        if (!this.isReturnGainLossMatrix()) {
            throw new RuntimeException("creation of gain-loss matrix has not been enabled");
        }
        return this._gain_loss_matrix;
    }

    public CharacterStateMatrix<CharacterStateMatrix.BinaryStates> getInternalStatesMatrix() {
        if (!this.isReturnInternalStates()) {
            throw new RuntimeException("creation of internal state matrix has not been enabled");
        }
        return this._internal_states_matrix;
    }

    private Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> getStatesForCharacter(Phylogeny p, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix, int character_index) {
        HashMap<PhylogenyNode, CharacterStateMatrix.BinaryStates> states = new HashMap<PhylogenyNode, CharacterStateMatrix.BinaryStates>(matrix.getNumberOfIdentifiers());
        for (int indentifier_index = 0; indentifier_index < matrix.getNumberOfIdentifiers(); ++indentifier_index) {
            CharacterStateMatrix.BinaryStates state = matrix.getState(indentifier_index, character_index);
            if (state == null) {
                throw new IllegalArgumentException("value at [" + indentifier_index + ", " + character_index + "] is null");
            }
            states.put(p.getNode(matrix.getIdentifier(indentifier_index)), state);
        }
        return states;
    }

    public int getTotalGains() {
        return this._total_gains;
    }

    public int getTotalLosses() {
        return this._total_losses;
    }

    public int getTotalUnchanged() {
        return this._total_unchanged;
    }

    private void init() {
        this.setReturnInternalStates(false);
        this.setReturnGainLossMatrix(false);
        this.reset();
    }

    private void initializeGainLossMatrix(Phylogeny p, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> external_node_states_matrix) {
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator postorder = p.iteratorPostorder();
        while (postorder.hasNext()) {
            nodes.add(postorder.next());
        }
        this.setGainLossMatrix(new BasicCharacterStateMatrix<CharacterStateMatrix.GainLossStates>(nodes.size(), external_node_states_matrix.getNumberOfCharacters()));
        int identifier_index = 0;
        for (PhylogenyNode node : nodes) {
            this.getGainLossMatrix().setIdentifier(identifier_index++, ForesterUtil.isEmpty(node.getName()) ? node.getId() + "" : node.getName());
        }
        for (int character_index = 0; character_index < external_node_states_matrix.getNumberOfCharacters(); ++character_index) {
            this.getGainLossMatrix().setCharacter(character_index, external_node_states_matrix.getCharacter(character_index));
        }
    }

    private void initializeInternalStates(Phylogeny p, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> external_node_states_matrix) {
        ArrayList<PhylogenyNode> internal_nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator postorder = p.iteratorPostorder();
        while (postorder.hasNext()) {
            PhylogenyNode node = postorder.next();
            if (!node.isInternal()) continue;
            internal_nodes.add(node);
        }
        this.setInternalStatesMatrix(new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(internal_nodes.size(), external_node_states_matrix.getNumberOfCharacters()));
        int identifier_index = 0;
        for (PhylogenyNode node : internal_nodes) {
            this.getInternalStatesMatrix().setIdentifier(identifier_index++, ForesterUtil.isEmpty(node.getName()) ? node.getId() + "" : node.getName());
        }
        for (int character_index = 0; character_index < external_node_states_matrix.getNumberOfCharacters(); ++character_index) {
            this.getInternalStatesMatrix().setCharacter(character_index, external_node_states_matrix.getCharacter(character_index));
        }
    }

    private boolean isReturnGainLossMatrix() {
        return this._return_gain_loss;
    }

    private boolean isReturnInternalStates() {
        return this._return_internal_states;
    }

    private void postOrderTraversal(Phylogeny p, Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> states) throws AssertionError {
        PhylogenyNodeIterator postorder = p.iteratorPostorder();
        while (postorder.hasNext()) {
            PhylogenyNode node = postorder.next();
            if (node.isExternal()) continue;
            int present_unknown = DolloParsimony.getNumberOfChildNodesWithPresentOrUnknownState(states, node);
            if (present_unknown < 1) {
                states.put(node, ABSENT);
                continue;
            }
            if (present_unknown == 1) {
                states.put(node, UNKNOWN);
                continue;
            }
            states.put(node, PRESENT);
        }
    }

    private void preOrderTraversal(Phylogeny p, Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> states, int character_state_column) throws AssertionError {
        boolean gain = false;
        PhylogenyNodeIterator preorder = p.iteratorPreorder();
        while (preorder.hasNext()) {
            PhylogenyNode node = preorder.next();
            CharacterStateMatrix.BinaryStates parent_state = null;
            if (!node.isRoot()) {
                parent_state = states.get(node.getParent());
            }
            if (!node.isExternal()) {
                if (states.get(node) == UNKNOWN) {
                    if (parent_state == PRESENT) {
                        states.put(node, PRESENT);
                    } else if (DolloParsimony.isCharacterPresentOrUnknownInAtLeastTwoChildNodes(states, node)) {
                        states.put(node, PRESENT);
                    } else {
                        states.put(node, ABSENT);
                    }
                }
                if (this.isReturnInternalStates()) {
                    this.setInternalNodeState(states, character_state_column, node);
                }
            }
            CharacterStateMatrix.BinaryStates current_state = states.get(node);
            if (parent_state == PRESENT && current_state == ABSENT) {
                ++this._total_losses;
                if (!this.isReturnGainLossMatrix()) continue;
                this.setGainLossState(character_state_column, node, LOSS);
                continue;
            }
            if (parent_state == ABSENT && current_state == PRESENT) {
                if (gain) {
                    throw new RuntimeException("this should not have happened: dollo parsimony cannot have more than one gain");
                }
                gain = true;
                ++this._total_gains;
                if (!this.isReturnGainLossMatrix()) continue;
                this.setGainLossState(character_state_column, node, GAIN);
                continue;
            }
            ++this._total_unchanged;
            if (!this.isReturnGainLossMatrix()) continue;
            if (current_state == PRESENT) {
                this.setGainLossState(character_state_column, node, UNCHANGED_PRESENT);
                continue;
            }
            if (current_state != ABSENT) continue;
            this.setGainLossState(character_state_column, node, UNCHANGED_ABSENT);
        }
    }

    private void reset() {
        this.setTotalLosses(0);
        this.setTotalGains(0);
        this.setTotalUnchanged(0);
    }

    private void setGainLossMatrix(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gain_loss_matrix) {
        this._gain_loss_matrix = gain_loss_matrix;
    }

    private void setGainLossState(int character_state_column, PhylogenyNode node, CharacterStateMatrix.GainLossStates state) {
        this.getGainLossMatrix().setState(ForesterUtil.isEmpty(node.getName()) ? node.getId() + "" : node.getName(), character_state_column, state);
    }

    private void setInternalNodeState(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> states, int character_state_column, PhylogenyNode node) {
        this.getInternalStatesMatrix().setState(ForesterUtil.isEmpty(node.getName()) ? node.getId() + "" : node.getName(), character_state_column, states.get(node));
    }

    private void setInternalStatesMatrix(CharacterStateMatrix<CharacterStateMatrix.BinaryStates> internal_states_matrix) {
        this._internal_states_matrix = internal_states_matrix;
    }

    public void setReturnGainLossMatrix(boolean return_gain_loss) {
        this._return_gain_loss = return_gain_loss;
    }

    public void setReturnInternalStates(boolean return_internal_states) {
        this._return_internal_states = return_internal_states;
    }

    private void setTotalGains(int total_gains) {
        this._total_gains = total_gains;
    }

    private void setTotalLosses(int total_losses) {
        this._total_losses = total_losses;
    }

    private void setTotalUnchanged(int total_unchanged) {
        this._total_unchanged = total_unchanged;
    }

    public static DolloParsimony createInstance() {
        return new DolloParsimony();
    }

    private static int getNumberOfChildNodesWithPresentOrUnknownState(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> states, PhylogenyNode node) {
        int presents = 0;
        for (int i = 0; i < node.getNumberOfDescendants(); ++i) {
            PhylogenyNode node_child = node.getChildNode(i);
            if (!states.containsKey(node_child)) {
                throw new RuntimeException("this should not have happened: node [" + node_child.getName() + "] not found in node state map");
            }
            if (states.get(node_child) != CharacterStateMatrix.BinaryStates.PRESENT && states.get(node_child) != CharacterStateMatrix.BinaryStates.UNKNOWN) continue;
            ++presents;
        }
        return presents;
    }

    private static boolean isCharacterPresentOrUnknownInAtLeastTwoChildNodes(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> states, PhylogenyNode node) {
        int count = 0;
        for (int i = 0; i < node.getNumberOfDescendants(); ++i) {
            PhylogenyNode node_child = node.getChildNode(i);
            if (states.get(node_child) != PRESENT && states.get(node_child) != UNKNOWN || ++count <= 1) continue;
            return true;
        }
        return false;
    }
}

