/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.util.Random;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;

public final class DevelopmentTools {
    private DevelopmentTools() {
    }

    public static Phylogeny createBalancedPhylogeny(int levels, int children_per_node) {
        PhylogenyNode root = new PhylogenyNode();
        Phylogeny p = new Phylogeny();
        p.setRoot(root);
        p.setRooted(true);
        DevelopmentTools.createBalancedPhylogenyRecursion(levels, children_per_node, root);
        return p;
    }

    private static void createBalancedPhylogenyRecursion(int current_level, int children_per_node, PhylogenyNode current_node) {
        if (current_level > 0) {
            --current_level;
            for (int i = 0; i < children_per_node; ++i) {
                PhylogenyNode new_node = new PhylogenyNode();
                current_node.addAsChild(new_node);
                DevelopmentTools.createBalancedPhylogenyRecursion(current_level, children_per_node, new_node);
            }
        }
    }

    public static void intervalNumberSpecies(Phylogeny t, int i) {
        if (t == null || t.isEmpty()) {
            return;
        }
        int j = 1;
        boolean odd = true;
        for (PhylogenyNode n = t.getFirstExternalNode(); n != null; n = n.getNextExternalNode()) {
            if (odd) {
                PhylogenyMethods.setScientificName(n, j + "");
            } else {
                PhylogenyMethods.setScientificName(n, j + i + "");
                ++j;
            }
            odd = !odd;
        }
    }

    public static void numberSpeciesInDescOrder(Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        int j = t.getRoot().getNumberOfExternalNodes();
        for (PhylogenyNode n = t.getFirstExternalNode(); n != null; n = n.getNextExternalNode()) {
            try {
                PhylogenyMethods.setTaxonomyCode(n, j + "");
            }
            catch (PhyloXmlDataFormatException e) {
                e.printStackTrace();
            }
            --j;
        }
    }

    public static void numberSpeciesInOrder(Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        int j = 1;
        for (PhylogenyNode n = t.getFirstExternalNode(); n != null; n = n.getNextExternalNode()) {
            PhylogenyMethods.setScientificName(n, j + "");
            ++j;
        }
    }

    public static void randomizeSpecies(int min, int max, Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        int mi = Math.abs(min);
        int ma = Math.abs(max);
        Random r = new Random();
        for (PhylogenyNode n = t.getFirstExternalNode(); n != null; n = n.getNextExternalNode()) {
            String code = Math.abs(r.nextInt()) % (ma - mi + 1) + mi + "";
            try {
                PhylogenyMethods.setTaxonomyCode(n, code);
                continue;
            }
            catch (PhyloXmlDataFormatException e) {
                e.printStackTrace();
            }
        }
    }
}

