/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.util.ArrayList;
import java.util.List;
import org.forester.archaeopteryx.tools.ProcessRunning;

public class ProcessPool {
    private static final boolean DEBUG = true;
    private final ArrayList<ProcessRunning> _processes = new ArrayList();

    private ProcessPool() {
    }

    public static ProcessPool createInstance() {
        return new ProcessPool();
    }

    public synchronized ProcessRunning getProcessByIndex(int i) {
        return this.getProcesses().get(i);
    }

    public synchronized int size() {
        return this.getProcesses().size();
    }

    public synchronized ProcessRunning getProcessById(long id) {
        for (ProcessRunning p : this.getProcesses()) {
            if (p.getId() != id) continue;
            return p;
        }
        return null;
    }

    public synchronized long addProcess(String name) {
        ProcessRunning p = ProcessRunning.createInstance(name);
        long id = p.getId();
        if (this.getProcessById(id) != null) {
            throw new IllegalStateException(" process with id " + id + "already exists");
        }
        this.getProcesses().add(p);
        System.out.println(" pp: added: " + p);
        return id;
    }

    public synchronized boolean removeProcess(long id) {
        int i = this.getProcessIndexById(id);
        if (i >= 0) {
            ProcessRunning p = this.getProcessById(id);
            System.out.println(" pp: removing: " + p);
            this.getProcesses().remove(i);
            return true;
        }
        return false;
    }

    private synchronized int getProcessIndexById(long id) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getProcesses().get(i).getId() != id) continue;
            return i;
        }
        return -1;
    }

    private synchronized List<ProcessRunning> getProcesses() {
        return this._processes;
    }
}

