/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.MouseListener;
import org.forester.archaeopteryx.NodeFrame;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.TreePanelUtil;
import org.forester.archaeopteryx.phylogeny.data.RenderableDomainArchitecture;
import org.forester.archaeopteryx.phylogeny.data.RenderableMsaSequence;
import org.forester.archaeopteryx.phylogeny.data.RenderableVector;
import org.forester.archaeopteryx.tools.Blast;
import org.forester.archaeopteryx.tools.ImageLoader;
import org.forester.io.writers.SequenceWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;
import org.forester.util.TaxonomyUtil;

public final class TreePanel
extends JPanel
implements ActionListener,
MouseWheelListener,
Printable {
    public static final boolean SPECIAL_DOMAIN_COLORING = true;
    static final Cursor ARROW_CURSOR = Cursor.getPredefinedCursor(0);
    static final Cursor CUT_CURSOR = Cursor.getPredefinedCursor(1);
    static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final double _180_OVER_PI = 57.29577951308232;
    private static final float ANGLE_ROTATION_UNIT = 0.09817477f;
    private static final int CONFIDENCE_LEFT_MARGIN = 4;
    private static final int EURO_D = 10;
    private static final NumberFormat FORMATTER_BRANCH_LENGTH;
    private static final NumberFormat FORMATTER_CONFIDENCE;
    private static final float HALF_PI = 1.5707964f;
    private static final int LIMIT_FOR_HQ_RENDERING = 2000;
    private static final int MAX_NODE_FRAMES = 10;
    private static final int MAX_SUBTREES = 100;
    private static final int MIN_ROOT_LENGTH = 3;
    private static final int MOVE = 20;
    private static final String NODE_POPMENU_NODE_CLIENT_PROPERTY = "node";
    private static final float ONEHALF_PI = 4.712389f;
    private static final short OV_BORDER = 10;
    private static final double OVERVIEW_FOUND_NODE_BOX_SIZE = 2.0;
    private static final double OVERVIEW_FOUND_NODE_BOX_SIZE_HALF = 1.0;
    private static final float PI = (float)Math.PI;
    private static final Font POPUP_FONT;
    private static final float ROUNDED_D = 8.0f;
    private static final long serialVersionUID = -978349745916505029L;
    private static final BasicStroke STROKE_0025;
    private static final BasicStroke STROKE_005;
    private static final BasicStroke STROKE_01;
    private static final BasicStroke STROKE_025;
    private static final BasicStroke STROKE_05;
    private static final BasicStroke STROKE_075;
    private static final BasicStroke STROKE_1;
    private static final BasicStroke STROKE_2;
    private static final double TWO_PI = Math.PI * 2;
    private static final int WIGGLE = 2;
    private static final String SHOW_ONLY_THIS_CONF_TYPE;
    HashMap<Long, Short> _nodeid_dist_to_leaf = new HashMap();
    private final Arc2D _arc = new Arc2D.Double();
    private AffineTransform _at;
    private int _circ_max_depth;
    private final Set<Long> _collapsed_external_nodeid_set = new HashSet<Long>();
    private JColorChooser _color_chooser = null;
    private Configuration _configuration = null;
    private ControlPanel _control_panel = null;
    private final CubicCurve2D _cubic_curve = new CubicCurve2D.Float();
    private Set<Long> _current_external_nodes = null;
    private StringBuilder _current_external_nodes_data_buffer = new StringBuilder();
    private int _current_external_nodes_data_buffer_change_counter = 0;
    private int _domain_structure_e_value_thr_exp = -3;
    private double _domain_structure_width = 100.0;
    private int _dynamic_hiding_factor = 0;
    private boolean _edited = false;
    private final Ellipse2D _ellipse = new Ellipse2D.Float();
    private int _external_node_index = 0;
    private Set<Long> _found_nodes_0 = null;
    private Set<Long> _found_nodes_1 = null;
    private final FontRenderContext _frc = new FontRenderContext(null, false, false);
    private Options.PHYLOGENY_GRAPHICS_TYPE _graphics_type = Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
    private PhylogenyNode _highlight_node = null;
    private boolean _in_ov = false;
    private boolean _in_ov_rect = false;
    private float _last_drag_point_x = 0.0f;
    private float _last_drag_point_y = 0.0f;
    private final Line2D _line = new Line2D.Float();
    private int _longest_ext_node_info = 0;
    private PhylogenyNode _ext_node_with_longest_txt_info = null;
    private MainPanel _main_panel = null;
    private double _max_distance_to_root = -1.0;
    private Popup _node_desc_popup;
    private int _node_frame_index = 0;
    private final NodeFrame[] _node_frames = new NodeFrame[10];
    private JPopupMenu _node_popup_menu = null;
    private JMenuItem[] _node_popup_menu_items = null;
    private PhylogenyNode[] _nodes_in_preorder = null;
    private Options _options = null;
    private float _ov_max_height = 0.0f;
    private float _ov_max_width = 0.0f;
    private boolean _ov_on = false;
    private final Rectangle2D _ov_rectangle = new Rectangle2D.Float();
    private final Rectangle _ov_virtual_rectangle = new Rectangle();
    private float _ov_x_correction_factor = 0.0f;
    private float _ov_x_distance = 0.0f;
    private int _ov_x_position = 0;
    private float _ov_y_distance = 0.0f;
    private int _ov_y_position = 0;
    private int _ov_y_start = 0;
    private final boolean _phy_has_branch_lengths;
    private Phylogeny _phylogeny = null;
    private final Path2D.Float _polygon = new Path2D.Float();
    private final StringBuffer _popup_buffer = new StringBuffer();
    private final QuadCurve2D _quad_curve = new QuadCurve2D.Float();
    private Sequence _query_sequence = null;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private final RenderingHints _rendering_hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
    private JTextArea _rollover_popup;
    private PhylogenyNode _root;
    private final StringBuilder _sb = new StringBuilder();
    private double _scale_distance = 0.0;
    private String _scale_label = null;
    private DescriptiveStatistics _statistics_for_vector_data;
    private final Phylogeny[] _sub_phylogenies = new Phylogeny[100];
    private final PhylogenyNode[] _sub_phylogenies_temp_roots = new PhylogenyNode[100];
    private int _subtree_index = 0;
    private File _treefile = null;
    private float _urt_factor = 1.0f;
    private float _urt_factor_ov = 1.0f;
    private final HashMap<Long, Double> _urt_nodeid_angle_map = new HashMap();
    private final HashMap<Long, Integer> _urt_nodeid_index_map = new HashMap();
    private double _urt_starting_angle = 1.5707963705062866;
    private float _x_correction_factor = 0.0f;
    private float _x_distance = 0.0f;
    private float _y_distance = 0.0f;
    private int _length_of_longest_text;
    private int _longest_domain;

    TreePanel(Phylogeny t, Configuration configuration, MainPanel tjp) {
        this.requestFocusInWindow();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent key_event) {
                TreePanel.this.keyPressedCalls(key_event);
                TreePanel.this.requestFocusInWindow();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TreePanel.this.requestFocusInWindow();
            }
        });
        if (t == null || t.isEmpty()) {
            throw new IllegalArgumentException("attempt to draw phylogeny which is null or empty");
        }
        this._graphics_type = tjp.getOptions().getPhylogenyGraphicsType();
        this._main_panel = tjp;
        this._configuration = configuration;
        this._phylogeny = t;
        this._phy_has_branch_lengths = AptxUtil.isHasAtLeastOneBranchLengthLargerThanZero(this._phylogeny);
        this.init();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.checkForVectorProperties(this._phylogeny);
        this.setBackground(this.getTreeColorSet().getBackgroundColor());
        MouseListener mouse_listener = new MouseListener(this);
        this.addMouseListener(mouse_listener);
        this.addMouseMotionListener(mouse_listener);
        this.addMouseWheelListener(this);
        this.calculateScaleDistance();
        FORMATTER_CONFIDENCE.setMaximumFractionDigits(configuration.getNumberOfDigitsAfterCommaForConfidenceValues());
        FORMATTER_BRANCH_LENGTH.setMaximumFractionDigits(configuration.getNumberOfDigitsAfterCommaForBranchLengthValues());
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        boolean done = false;
        JMenuItem node_popup_menu_item = (JMenuItem)e.getSource();
        for (int index = 0; index < this._node_popup_menu_items.length && !done; ++index) {
            if (node_popup_menu_item != this._node_popup_menu_items[index]) continue;
            this._main_panel.getControlPanel().setClickToAction(index);
            PhylogenyNode node = (PhylogenyNode)this._node_popup_menu.getClientProperty(NODE_POPMENU_NODE_CLIENT_PROPERTY);
            this.handleClickToAction(this._control_panel.getActionWhenNodeClicked(), node);
            done = true;
        }
        this.repaint();
        this.requestFocusInWindow();
    }

    public synchronized Hashtable<String, BufferedImage> getImageMap() {
        return this.getMainPanel().getImageMap();
    }

    public final MainPanel getMainPanel() {
        return this._main_panel;
    }

    public final Phylogeny getPhylogeny() {
        return this._phylogeny;
    }

    public final TreeColorSet getTreeColorSet() {
        return this.getMainPanel().getTreeColorSet();
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        if (this.inOvVirtualRectangle(e)) {
            if (!this.isInOvRect()) {
                this.setInOvRect(true);
                this.repaint();
            }
        } else if (this.isInOvRect()) {
            this.setInOvRect(false);
            this.repaint();
        }
        if (e.isControlDown()) {
            if (notches < 0) {
                this.getTreeFontSet().increaseFontSize();
                this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else {
                this.getTreeFontSet().decreaseFontSize(1, false);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
            }
        } else if (e.isShiftDown()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                if (notches < 0) {
                    for (int i = 0; i < -notches; ++i) {
                        this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) + 0.09817477315664291);
                        this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                } else {
                    for (int i = 0; i < notches; ++i) {
                        this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) - 0.09817477315664291);
                        if (this.getStartingAngle() < 0.0) {
                            this.setStartingAngle(Math.PI * 2 + this.getStartingAngle());
                        }
                        this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                }
            } else if (notches < 0) {
                for (int i = 0; i < -notches; ++i) {
                    this.getControlPanel().zoomInY(1.08f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else {
                for (int i = 0; i < notches; ++i) {
                    this.getControlPanel().zoomOutY(0.9259259f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            }
        } else if (notches < 0) {
            for (int i = 0; i < -notches; ++i) {
                this.getControlPanel().zoomInX(1.08f, 1.085f);
                this.getControlPanel().zoomInY(1.08f);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        } else {
            for (int i = 0; i < notches; ++i) {
                this.getControlPanel().zoomOutY(0.9259259f);
                this.getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        }
        this.requestFocus();
        this.requestFocusInWindow();
        this.requestFocus();
    }

    @Override
    public final void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(this._rendering_hints);
        this.paintPhylogeny(g2d, false, false, 0, 0, 0, 0);
    }

    @Override
    public final int print(Graphics g, PageFormat page_format, int page_index) throws PrinterException {
        if (page_index > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(page_format.getImageableX(), page_format.getImageableY());
        this.paintPhylogeny(g2d, true, false, 0, 0, 0, 0);
        return 0;
    }

    public final void setEdited(boolean edited) {
        this._edited = edited;
    }

    public synchronized void setImageMap(Hashtable<String, BufferedImage> image_map) {
        this.getMainPanel().setImageMap(image_map);
    }

    public final void setTree(Phylogeny t) {
        this.setNodeInPreorderToNull();
        this._phylogeny = t;
    }

    public final void setWaitCursor() {
        this.setCursor(WAIT_CURSOR);
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void abbreviateScientificName(String sn, StringBuilder sb) {
        String[] a = sn.split("\\s+");
        sb.append(a[0].substring(0, 1));
        sb.append(a[1].substring(0, 2));
        if (a.length > 2) {
            for (int i = 2; i < a.length; ++i) {
                sb.append(" ");
                sb.append(a[i]);
            }
        }
    }

    private final void addEmptyNode(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        String label = this.createASimpleTextRepresentationOfANode(node);
        String msg = "";
        msg = ForesterUtil.isEmpty(label) ? "How to add the new, empty node?" : "How to add the new, empty node to node" + label + "?";
        Object[] options = new Object[]{"As sibling", "As descendant", "Cancel"};
        int r = JOptionPane.showOptionDialog(this, msg, "Addition of Empty New Node", -1, 3, null, options, options[2]);
        boolean add_as_sibling = true;
        if (r == 1) {
            add_as_sibling = false;
        } else if (r != 0) {
            return;
        }
        Phylogeny phy = new Phylogeny();
        phy.setRoot(new PhylogenyNode());
        phy.setRooted(true);
        if (add_as_sibling) {
            if (node.isRoot()) {
                JOptionPane.showMessageDialog(this, "Cannot add sibling to root", "Attempt to add sibling to root", 0);
                return;
            }
            phy.addAsSibling(node);
        } else {
            phy.addAsChild(node);
        }
        this.setNodeInPreorderToNull();
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void addToCurrentExternalNodes(long i) {
        if (this._current_external_nodes == null) {
            this._current_external_nodes = new HashSet<Long>();
        }
        this._current_external_nodes.add(i);
    }

    private final void assignGraphicsForBranchWithColorForParentBranch(PhylogenyNode node, boolean is_vertical, Graphics g, boolean to_pdf, boolean to_graphics_file) {
        ControlPanel.NodeClickAction action = this._control_panel.getActionWhenNodeClicked();
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else if (!(action != ControlPanel.NodeClickAction.COPY_SUBTREE && action != ControlPanel.NodeClickAction.CUT_SUBTREE && action != ControlPanel.NodeClickAction.DELETE_NODE_OR_SUBTREE && action != ControlPanel.NodeClickAction.PASTE_SUBTREE && action != ControlPanel.NodeClickAction.ADD_NEW_NODE || this.getCutOrCopiedTree() == null || this.getCopiedAndPastedNodes() == null || to_pdf || to_graphics_file || !this.getCopiedAndPastedNodes().contains(node.getId()))) {
            g.setColor(this.getTreeColorSet().getFoundColor0());
        } else if (this.getControlPanel().isUseVisualStyles() && PhylogenyMethods.getBranchColorValue(node) != null) {
            g.setColor(PhylogenyMethods.getBranchColorValue(node));
        } else if (to_pdf) {
            g.setColor(this.getTreeColorSet().getBranchColorForPdf());
        } else {
            g.setColor(this.getTreeColorSet().getBranchColor());
        }
    }

    private final void blast(PhylogenyNode node) {
        if (!this.isCanBlast(node)) {
            JOptionPane.showMessageDialog(this, "Insufficient information present", "Cannot Blast", 1);
            return;
        }
        String query = Blast.obtainQueryForBlast(node);
        System.out.println("query for BLAST is: " + query);
        int type = 63;
        if (!ForesterUtil.isEmpty(query)) {
            if (node.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getType())) {
                    type = node.getNodeData().getSequence().getType().toLowerCase().equals("protein") ? 112 : 110;
                } else if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getMolecularSequence())) {
                    type = ForesterUtil.seqIsLikelyToBeAa(node.getNodeData().getSequence().getMolecularSequence()) ? 112 : 110;
                }
            }
            if (type == 63) {
                type = SequenceAccessionTools.isProteinDbQuery(query) ? 112 : 110;
            }
            JApplet applet = null;
            if (this.isApplet()) {
                applet = this.obtainApplet();
            }
            try {
                Blast.openNcbiBlastWeb(query, type == 110, applet, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final int calcDynamicHidingFactor() {
        return (int)(0.5 + (double)this.getFontMetricsForLargeDefaultFont().getHeight() / (1.5 * (double)this.getYdistance()));
    }

    private final int calcLengthOfLongestText() {
        StringBuilder sb = new StringBuilder();
        if (this._ext_node_with_longest_txt_info != null) {
            this.nodeDataAsSB(this._ext_node_with_longest_txt_info, sb);
            if (this._ext_node_with_longest_txt_info.getNodeData().isHasTaxonomy()) {
                this.nodeTaxonomyDataAsSB(this._ext_node_with_longest_txt_info.getNodeData().getTaxonomy(), sb);
            }
        }
        return this.getFontMetricsForLargeDefaultFont().stringWidth(sb.toString());
    }

    private final float calculateBranchLengthToParent(PhylogenyNode node, float factor) {
        if (this.getControlPanel().isDrawPhylogram()) {
            if (node.getDistanceToParent() < 0.0) {
                return 0.0f;
            }
            return (float)((double)this.getXcorrectionFactor() * node.getDistanceToParent());
        }
        if (factor == 0.0f || this.isNonLinedUpCladogram()) {
            return this.getXdistance();
        }
        return this.getXdistance() * factor;
    }

    private final Color calculateColorForAnnotation(SortedSet<Annotation> ann) {
        Color c = this.getTreeColorSet().getAnnotationColor();
        if (this.getControlPanel().isColorAccordingToAnnotation() && this.getControlPanel().getAnnotationColors() != null) {
            StringBuilder sb = new StringBuilder();
            for (Annotation a : ann) {
                sb.append(!ForesterUtil.isEmpty(a.getRefValue()) ? a.getRefValue() : a.getDesc());
            }
            String ann_str = sb.toString();
            if (!ForesterUtil.isEmpty(ann_str)) {
                c = this.getControlPanel().getAnnotationColors().get(ann_str);
                if (c == null) {
                    c = AptxUtil.calculateColorFromString(ann_str, false);
                    this.getControlPanel().getAnnotationColors().put(ann_str, c);
                }
                if (c == null) {
                    c = this.getTreeColorSet().getAnnotationColor();
                }
            }
        }
        return c;
    }

    private final float calculateOvBranchLengthToParent(PhylogenyNode node, int factor) {
        if (this.getControlPanel().isDrawPhylogram()) {
            if (node.getDistanceToParent() < 0.0) {
                return 0.0f;
            }
            return (float)((double)this.getOvXcorrectionFactor() * node.getDistanceToParent());
        }
        if (factor == 0 || this.isNonLinedUpCladogram()) {
            return this.getOvXDistance();
        }
        return this.getOvXDistance() * (float)factor;
    }

    private final void cannotOpenBrowserWarningMessage(String type_type) {
        JOptionPane.showMessageDialog(this, "Cannot launch web browser for " + type_type + " data of this node", "Cannot launch web browser", 2);
    }

    private void changeNodeFont(PhylogenyNode node) {
        FontChooser fc = new FontChooser();
        Font f = null;
        if (node.getNodeData().getNodeVisualData() != null && !node.getNodeData().getNodeVisualData().isEmpty()) {
            f = node.getNodeData().getNodeVisualData().getFont();
        }
        if (f != null) {
            fc.setFont(f);
        } else {
            fc.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        }
        List<Object> nodes = new ArrayList();
        if (this.getFoundNodes0() != null || this.getFoundNodes1() != null) {
            nodes = this.getFoundNodesAsListOfPhylogenyNodes();
        }
        if (!nodes.contains(node)) {
            nodes.add(node);
        }
        int count = nodes.size();
        String title = "Change the font for ";
        title = count == 1 ? title + "one node" : title + count + " nodes";
        fc.showDialog(this, title);
        if (fc.getFont() != null && !ForesterUtil.isEmpty(fc.getFont().getFamily().trim())) {
            for (PhylogenyNode phylogenyNode : nodes) {
                if (phylogenyNode.getNodeData().getNodeVisualData() == null) {
                    phylogenyNode.getNodeData().setNodeVisualData(new NodeVisualData());
                }
                NodeVisualData vd = phylogenyNode.getNodeData().getNodeVisualData();
                Font ff = fc.getFont();
                vd.setFontName(ff.getFamily().trim());
                int s = ff.getSize();
                if (s < 0) {
                    s = 0;
                }
                if (s > 127) {
                    s = 127;
                }
                vd.setFontSize(s);
                vd.setFontStyle(ff.getStyle());
            }
            if (this._control_panel.getUseVisualStylesCb() != null) {
                this.getControlPanel().getUseVisualStylesCb().setSelected(true);
            }
        }
        this.setEdited(true);
        this.repaint();
    }

    private final void colorizeNodes(Color c, PhylogenyNode node, List<PhylogenyNode> additional_nodes) {
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getUseVisualStylesCb() != null) {
            this._control_panel.getUseVisualStylesCb().setSelected(true);
        }
        if (node != null) {
            TreePanel.colorizeNodesHelper(c, node);
        }
        if (additional_nodes != null) {
            for (PhylogenyNode n : additional_nodes) {
                TreePanel.colorizeNodesHelper(c, n);
            }
        }
        this.repaint();
    }

    private final void colorizeSubtree(Color c, PhylogenyNode node, List<PhylogenyNode> additional_nodes) {
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getUseVisualStylesCb() != null) {
            this._control_panel.getUseVisualStylesCb().setSelected(true);
        }
        if (node != null) {
            PreorderTreeIterator it = new PreorderTreeIterator(node);
            while (it.hasNext()) {
                it.next().getBranchData().setBranchColor(new BranchColor(c));
            }
        }
        if (additional_nodes != null) {
            for (PhylogenyNode an : additional_nodes) {
                PreorderTreeIterator it = new PreorderTreeIterator(an);
                while (it.hasNext()) {
                    it.next().getBranchData().setBranchColor(new BranchColor(c));
                }
            }
        }
        this.repaint();
    }

    private void colorNodeFont(PhylogenyNode node) {
        NodeColorizationActionListener al;
        this._color_chooser.setPreviewPanel(new JPanel());
        int count = 1;
        if (this.getFoundNodes0() != null || this.getFoundNodes1() != null) {
            List<PhylogenyNode> additional_nodes = this.getFoundNodesAsListOfPhylogenyNodes();
            al = new NodeColorizationActionListener(this._color_chooser, node, additional_nodes);
            count = additional_nodes.size();
            if (!additional_nodes.contains(node)) {
                ++count;
            }
        } else {
            al = new NodeColorizationActionListener(this._color_chooser, node);
        }
        String title = "Change the (node and font) color for ";
        title = count == 1 ? title + "one node" : title + count + " nodes";
        JDialog dialog = JColorChooser.createDialog(this, title, true, this._color_chooser, al, null);
        this.setEdited(true);
        dialog.setVisible(true);
    }

    private final void colorSubtree(PhylogenyNode node) {
        SubtreeColorizationActionListener al;
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot colorize subtree in unrooted display type", "Attempt to colorize subtree in unrooted display", 2);
            return;
        }
        this._color_chooser.setPreviewPanel(new JPanel());
        if (this.getFoundNodes0() != null || this.getFoundNodes1() != null) {
            List<PhylogenyNode> additional_nodes = this.getFoundNodesAsListOfPhylogenyNodes();
            al = new SubtreeColorizationActionListener(this._color_chooser, node, additional_nodes);
        } else {
            al = new SubtreeColorizationActionListener(this._color_chooser, node);
        }
        JDialog dialog = JColorChooser.createDialog(this, "Subtree colorization", true, this._color_chooser, al, null);
        this.setEdited(true);
        dialog.setVisible(true);
    }

    private final void copySubtree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        this.setNodeInPreorderToNull();
        this.setCutOrCopiedTree(this._phylogeny.copy(node));
        List<PhylogenyNode> nodes = PhylogenyMethods.getAllDescendants(node);
        HashSet<Long> node_ids = new HashSet<Long>(nodes.size());
        for (PhylogenyNode n : nodes) {
            node_ids.add(n.getId());
        }
        node_ids.add(node.getId());
        this.setCopiedAndPastedNodes(node_ids);
        this.repaint();
    }

    private final String createASimpleTextRepresentationOfANode(PhylogenyNode node) {
        String tax = PhylogenyMethods.getSpecies(node);
        String label = node.getName();
        label = !ForesterUtil.isEmpty(label) && !ForesterUtil.isEmpty(tax) ? label + " " + tax : (!ForesterUtil.isEmpty(tax) ? tax : "");
        if (!ForesterUtil.isEmpty(label)) {
            label = " [" + label + "]";
        }
        return label;
    }

    private final void cutSubtree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (node.isRoot()) {
            JOptionPane.showMessageDialog(this, "Cannot cut entire tree as subtree", "Attempt to cut entire tree", 0);
            return;
        }
        String label = this.createASimpleTextRepresentationOfANode(node);
        int r = JOptionPane.showConfirmDialog(null, "Cut subtree" + label + "?", "Confirm Cutting of Subtree", 0);
        if (r != 0) {
            return;
        }
        this.setNodeInPreorderToNull();
        this.setCopiedAndPastedNodes(null);
        this.setCutOrCopiedTree(this._phylogeny.copy(node));
        this._phylogeny.deleteSubtree(node, true);
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void cycleColors() {
        this.getMainPanel().getTreeColorSet().cycleColorScheme();
        for (TreePanel tree_panel : this.getMainPanel().getTreePanels()) {
            tree_panel.setBackground(this.getMainPanel().getTreeColorSet().getBackgroundColor());
        }
    }

    private final void decreaseOvSize() {
        if (this.getOvMaxWidth() > 20.0f && this.getOvMaxHeight() > 20.0f) {
            this.setOvMaxWidth(this.getOvMaxWidth() - 5.0f);
            this.setOvMaxHeight(this.getOvMaxHeight() - 5.0f);
            this.updateOvSettings();
            this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
        }
    }

    private final void deleteNodeOrSubtree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (node.isRoot() && node.getNumberOfDescendants() != 1) {
            JOptionPane.showMessageDialog(this, "Cannot delete entire tree", "Attempt to delete entire tree", 0);
            return;
        }
        String label = this.createASimpleTextRepresentationOfANode(node);
        Object[] options = new Object[]{"Node only", "Entire subtree", "Cancel"};
        int r = JOptionPane.showOptionDialog(this, "Delete" + label + "?", "Delete Node/Subtree", -1, 3, null, options, options[2]);
        this.setNodeInPreorderToNull();
        boolean node_only = true;
        if (r == 1) {
            node_only = false;
        } else if (r != 0) {
            return;
        }
        if (node_only) {
            PhylogenyMethods.removeNode(node, this._phylogeny);
        } else {
            this._phylogeny.deleteSubtree(node, true);
        }
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void displayNodePopupMenu(PhylogenyNode node, int x, int y) {
        this.makePopupMenus(node);
        this._node_popup_menu.putClientProperty(NODE_POPMENU_NODE_CLIENT_PROPERTY, node);
        this._node_popup_menu.show(this, x, y);
    }

    private final void drawArc(double x, double y, double width, double heigth, double start_angle, double arc_angle, Graphics2D g) {
        this._arc.setArc(x, y, width, heigth, 57.29577951308232 * start_angle, 57.29577951308232 * arc_angle, 0);
        g.draw(this._arc);
    }

    private final void drawLine(double x1, double y1, double x2, double y2, Graphics2D g) {
        if (x1 == x2 && y1 == y2) {
            return;
        }
        this._line.setLine(x1, y1, x2, y2);
        g.draw(this._line);
    }

    private final void drawOval(double x, double y, double width, double heigth, Graphics2D g) {
        this._ellipse.setFrame(x, y, width, heigth);
        g.draw(this._ellipse);
    }

    private final void drawOvalFilled(double x, double y, double width, double heigth, Graphics2D g) {
        this._ellipse.setFrame(x, y, width, heigth);
        g.fill(this._ellipse);
    }

    private final void drawOvalGradient(float x, float y, float width, float heigth, Graphics2D g, Color color_1, Color color_2, Color color_border) {
        this._ellipse.setFrame(x, y, width, heigth);
        g.setPaint(new GradientPaint(x, y, color_1, x + width, y + heigth, color_2, false));
        g.fill(this._ellipse);
        if (color_border != null) {
            g.setPaint(color_border);
            g.draw(this._ellipse);
        }
    }

    private final void drawRect(float x, float y, float width, float heigth, Graphics2D g) {
        this._rectangle.setFrame(x, y, width, heigth);
        g.draw(this._rectangle);
    }

    private final void drawRectFilled(double x, double y, double width, double heigth, Graphics2D g) {
        this._rectangle.setFrame(x, y, width, heigth);
        g.fill(this._rectangle);
    }

    private final void drawRectGradient(float x, float y, float width, float heigth, Graphics2D g, Color color_1, Color color_2, Color color_border) {
        this._rectangle.setFrame(x, y, width, heigth);
        g.setPaint(new GradientPaint(x, y, color_1, x + width, y + heigth, color_2, false));
        g.fill(this._rectangle);
        if (color_border != null) {
            g.setPaint(color_border);
            g.draw(this._rectangle);
        }
    }

    private double drawTaxonomyImage(double x, double y, PhylogenyNode node, Graphics2D g) {
        ArrayList<Uri> us = new ArrayList<Uri>();
        for (Taxonomy t : node.getNodeData().getTaxonomies()) {
            for (Uri uri : t.getUris()) {
                us.add(uri);
            }
        }
        double offset = 0.0;
        for (Uri uri : us) {
            BufferedImage bi;
            if (uri == null) continue;
            String uri_str = uri.getValue().toString().toLowerCase();
            if (!this.getImageMap().containsKey(uri_str) || (bi = this.getImageMap().get(uri_str)) == null || bi.getHeight() <= 5 || bi.getWidth() <= 5) continue;
            double scaling_factor = 1.0;
            if (this.getOptions().isAllowMagnificationOfTaxonomyImages() || (double)bi.getHeight() > 1.8 * (double)this.getYdistance()) {
                scaling_factor = 1.8 * (double)this.getYdistance() / (double)bi.getHeight();
            }
            double hs = (double)bi.getHeight() * scaling_factor;
            double ws = (double)bi.getWidth() * scaling_factor + offset;
            double my_y = y - 0.5 * hs;
            int x_w = (int)(x + ws + 0.5);
            int y_h = (int)(my_y + hs + 0.5);
            if ((double)x_w - x > 7.0 && (double)y_h - my_y > 7.0) {
                g.drawImage(bi, (int)(x + 0.5 + offset), (int)(my_y + 0.5), x_w, y_h, 0, 0, bi.getWidth(), bi.getHeight(), null);
                ws += 8.0;
            } else {
                ws = 0.0;
            }
            offset = ws;
        }
        return offset;
    }

    private final void errorMessageNoCutCopyPasteInUnrootedDisplay() {
        JOptionPane.showMessageDialog(this, "Cannot cut, copy, paste, add, or delete subtrees/nodes in unrooted display", "Attempt to cut/copy/paste/add/delete in unrooted display", 0);
    }

    private final Color getColorForFoundNode(PhylogenyNode n) {
        if (this.isInCurrentExternalNodes(n)) {
            return this.getTreeColorSet().getFoundColor0();
        }
        if (this.isInFoundNodes0(n) && !this.isInFoundNodes1(n)) {
            return this.getTreeColorSet().getFoundColor0();
        }
        if (!this.isInFoundNodes0(n) && this.isInFoundNodes1(n)) {
            return this.getTreeColorSet().getFoundColor1();
        }
        return this.getTreeColorSet().getFoundColor0and1();
    }

    private final Set<Long> getCopiedAndPastedNodes() {
        return this.getMainPanel().getCopiedAndPastedNodes();
    }

    private final Set<Long> getCurrentExternalNodes() {
        return this._current_external_nodes;
    }

    private final Phylogeny getCutOrCopiedTree() {
        return this.getMainPanel().getCutOrCopiedTree();
    }

    private FontMetrics getFontMetricsForLargeDefaultFont() {
        return this.getTreeFontSet().getFontMetricsLarge();
    }

    private final float getLastDragPointX() {
        return this._last_drag_point_x;
    }

    private final float getLastDragPointY() {
        return this._last_drag_point_y;
    }

    private final short getMaxBranchesToLeaf(PhylogenyNode node) {
        if (!this._nodeid_dist_to_leaf.containsKey(node.getId())) {
            short m = PhylogenyMethods.calculateMaxBranchesToLeaf(node);
            this._nodeid_dist_to_leaf.put(node.getId(), m);
            return m;
        }
        return this._nodeid_dist_to_leaf.get(node.getId());
    }

    private final double getMaxDistanceToRoot() {
        if (this._max_distance_to_root < 0.0) {
            this.recalculateMaxDistanceToRoot();
        }
        return this._max_distance_to_root;
    }

    private final float getOvMaxHeight() {
        return this._ov_max_height;
    }

    private final float getOvMaxWidth() {
        return this._ov_max_width;
    }

    private final float getOvXcorrectionFactor() {
        return this._ov_x_correction_factor;
    }

    private final float getOvXDistance() {
        return this._ov_x_distance;
    }

    private final int getOvXPosition() {
        return this._ov_x_position;
    }

    private final float getOvYDistance() {
        return this._ov_y_distance;
    }

    private final int getOvYPosition() {
        return this._ov_y_position;
    }

    private final int getOvYStart() {
        return this._ov_y_start;
    }

    private final List<Accession> getPdbAccs(PhylogenyNode node) {
        Sequence seq;
        ArrayList<Accession> pdb_ids = new ArrayList<Accession>();
        if (node.getNodeData().isHasSequence() && !ForesterUtil.isEmpty((seq = node.getNodeData().getSequence()).getCrossReferences())) {
            SortedSet<Accession> cross_refs = seq.getCrossReferences();
            for (Accession acc : cross_refs) {
                if (!acc.getSource().equalsIgnoreCase("pdb")) continue;
                pdb_ids.add(acc);
            }
        }
        return pdb_ids;
    }

    private final double getScaleDistance() {
        return this._scale_distance;
    }

    private final String getScaleLabel() {
        return this._scale_label;
    }

    private final TreeFontSet getTreeFontSet() {
        return this.getMainPanel().getTreeFontSet();
    }

    private final float getUrtFactor() {
        return this._urt_factor;
    }

    private final float getUrtFactorOv() {
        return this._urt_factor_ov;
    }

    private final void handleClickToAction(ControlPanel.NodeClickAction action, PhylogenyNode node) {
        switch (action) {
            case SHOW_DATA: {
                this.showNodeFrame(node);
                break;
            }
            case COLLAPSE: {
                this.collapse(node);
                break;
            }
            case REROOT: {
                this.reRoot(node);
                break;
            }
            case SUBTREE: {
                this.subTree(node);
                break;
            }
            case SWAP: {
                this.swap(node);
                break;
            }
            case COLOR_SUBTREE: {
                this.colorSubtree(node);
                break;
            }
            case COLOR_NODE_FONT: {
                this.colorNodeFont(node);
                break;
            }
            case CHANGE_NODE_FONT: {
                this.changeNodeFont(node);
                break;
            }
            case OPEN_SEQ_WEB: {
                this.openSeqWeb(node);
                break;
            }
            case BLAST: {
                this.blast(node);
                break;
            }
            case OPEN_TAX_WEB: {
                this.openTaxWeb(node);
                break;
            }
            case OPEN_PDB_WEB: {
                this.openPdbWeb(node);
                break;
            }
            case CUT_SUBTREE: {
                this.cutSubtree(node);
                break;
            }
            case COPY_SUBTREE: {
                this.copySubtree(node);
                break;
            }
            case PASTE_SUBTREE: {
                this.pasteSubtree(node);
                break;
            }
            case DELETE_NODE_OR_SUBTREE: {
                this.deleteNodeOrSubtree(node);
                break;
            }
            case ADD_NEW_NODE: {
                this.addEmptyNode(node);
                break;
            }
            case EDIT_NODE_DATA: {
                this.showNodeEditFrame(node);
                break;
            }
            case SELECT_NODES: {
                this.selectNode(node);
                break;
            }
            case SORT_DESCENDENTS: {
                this.sortDescendants(node);
                break;
            }
            case GET_EXT_DESC_DATA: {
                this.showExtDescNodeData(node);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown action: " + (Object)((Object)action));
            }
        }
    }

    private final void increaseCurrentExternalNodesDataBufferChangeCounter() {
        ++this._current_external_nodes_data_buffer_change_counter;
    }

    private final void increaseOvSize() {
        if ((double)this.getOvMaxWidth() < this.getMainPanel().getCurrentScrollPane().getViewport().getVisibleRect().getWidth() / 2.0 && (double)this.getOvMaxHeight() < this.getMainPanel().getCurrentScrollPane().getViewport().getVisibleRect().getHeight() / 2.0) {
            this.setOvMaxWidth(this.getOvMaxWidth() + 5.0f);
            this.setOvMaxHeight(this.getOvMaxHeight() + 5.0f);
            this.updateOvSettings();
            this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
        }
    }

    private final void init() {
        this._color_chooser = new JColorChooser();
        this._rollover_popup = new JTextArea();
        this._rollover_popup.setFont(POPUP_FONT);
        this.resetNodeIdToDistToLeafMap();
        this.setTextAntialias();
        this.setTreeFile(null);
        this.setEdited(false);
        this.initializeOvSettings();
        this.setStartingAngle(4.71238898038469);
        ImageLoader il = new ImageLoader(this);
        new Thread(il).start();
    }

    private final void initializeOvSettings() {
        this.setOvMaxHeight(this.getConfiguration().getOvMaxHeight());
        this.setOvMaxWidth(this.getConfiguration().getOvMaxWidth());
    }

    private final boolean inOvVirtualRectangle(int x, int y) {
        return x >= this.getOvVirtualRectangle().x - 1 && x <= this.getOvVirtualRectangle().x + this.getOvVirtualRectangle().width + 1 && y >= this.getOvVirtualRectangle().y - 1 && y <= this.getOvVirtualRectangle().y + this.getOvVirtualRectangle().height + 1;
    }

    private final boolean inOvVirtualRectangle(MouseEvent e) {
        return this.inOvVirtualRectangle(e.getX(), e.getY());
    }

    private final boolean isCanBlast(PhylogenyNode node) {
        if (!node.getNodeData().isHasSequence() && ForesterUtil.isEmpty(node.getName())) {
            return false;
        }
        return Blast.isContainsQueryForBlast(node);
    }

    private final String isCanOpenSeqWeb(PhylogenyNode node) {
        Accession a = SequenceAccessionTools.obtainAccessorFromDataFields(node);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    private final boolean isCanOpenTaxWeb(PhylogenyNode node) {
        return node.getNodeData().isHasTaxonomy() && (!ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getScientificName()) || !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getTaxonomyCode()) || !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getCommonName()) || node.getNodeData().getTaxonomy().getIdentifier() != null && !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getIdentifier().getValue()));
    }

    private final boolean isInCurrentExternalNodes(PhylogenyNode node) {
        return this.getCurrentExternalNodes() != null && this.getCurrentExternalNodes().contains(node.getId());
    }

    private boolean isInFoundNodes(PhylogenyNode n) {
        return this.isInFoundNodes0(n) || this.isInFoundNodes1(n);
    }

    private final boolean isInFoundNodes0(PhylogenyNode node) {
        return this.getFoundNodes0() != null && this.getFoundNodes0().contains(node.getId());
    }

    private final boolean isInFoundNodes1(PhylogenyNode node) {
        return this.getFoundNodes1() != null && this.getFoundNodes1().contains(node.getId());
    }

    private final boolean isInOv() {
        return this._in_ov;
    }

    private final boolean isNodeDataInvisible(PhylogenyNode node) {
        int y_dist = 40;
        if (this.getControlPanel().isShowTaxonomyImages()) {
            y_dist = 40 + (int)this.getYdistance();
        }
        return (double)node.getYcoord() < this.getVisibleRect().getMinY() - (double)y_dist || (double)node.getYcoord() > this.getVisibleRect().getMaxY() + (double)y_dist || node.getParent() != null && (double)node.getParent().getXcoord() > this.getVisibleRect().getMaxX();
    }

    private final boolean isNodeDataInvisibleUnrootedCirc(PhylogenyNode node) {
        return (double)node.getYcoord() < this.getVisibleRect().getMinY() - 20.0 || (double)node.getYcoord() > this.getVisibleRect().getMaxY() + 20.0 || (double)node.getXcoord() < this.getVisibleRect().getMinX() - 20.0 || (double)node.getXcoord() > this.getVisibleRect().getMaxX() + 20.0;
    }

    private final boolean isNonLinedUpCladogram() {
        return this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP;
    }

    private final boolean isUniformBranchLengthsForCladogram() {
        return this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP;
    }

    private final void keyPressedCalls(KeyEvent e) {
        if (this.isOvOn() && this.getMousePosition() != null && this.getMousePosition().getLocation() != null) {
            if (this.inOvVirtualRectangle(this.getMousePosition().x, this.getMousePosition().y)) {
                if (!this.isInOvRect()) {
                    this.setInOvRect(true);
                }
            } else if (this.isInOvRect()) {
                this.setInOvRect(false);
            }
        }
        if (e.getModifiersEx() == 128) {
            if (e.getKeyCode() == 127 || e.getKeyCode() == 36 || e.getKeyCode() == 70) {
                this.getMainPanel().getTreeFontSet().mediumFonts();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else if (e.getKeyCode() == 109 || e.getKeyCode() == 45) {
                this.getMainPanel().getTreeFontSet().decreaseFontSize(1, false);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else if (TreePanel.plusPressed(e.getKeyCode())) {
                this.getMainPanel().getTreeFontSet().increaseFontSize();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            }
        } else {
            if (e.getKeyCode() == 127 || e.getKeyCode() == 36 || e.getKeyCode() == 70) {
                this.getControlPanel().showWhole();
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                if (e.getModifiersEx() == 64) {
                    if (e.getKeyCode() == 38) {
                        this.getMainPanel().getControlPanel().zoomInY(1.08f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (e.getKeyCode() == 40) {
                        this.getMainPanel().getControlPanel().zoomOutY(0.9259259f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (e.getKeyCode() == 37) {
                        this.getMainPanel().getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (e.getKeyCode() == 39) {
                        this.getMainPanel().getControlPanel().zoomInX(1.08f, 1.08f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                } else {
                    int d = 80;
                    int dx = 0;
                    int dy = -80;
                    if (e.getKeyCode() == 40) {
                        dy = 80;
                    } else if (e.getKeyCode() == 37) {
                        dx = -80;
                        dy = 0;
                    } else if (e.getKeyCode() == 39) {
                        dx = 80;
                        dy = 0;
                    }
                    Point scroll_position = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
                    scroll_position.x += dx;
                    scroll_position.y += dy;
                    if (scroll_position.x <= 0) {
                        scroll_position.x = 0;
                    } else {
                        int max_x = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
                        if (scroll_position.x >= max_x) {
                            scroll_position.x = max_x;
                        }
                    }
                    if (scroll_position.y <= 0) {
                        scroll_position.y = 0;
                    } else {
                        int max_y = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
                        if (scroll_position.y >= max_y) {
                            scroll_position.y = max_y;
                        }
                    }
                    this.repaint();
                    this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(scroll_position);
                }
            } else if (e.getKeyCode() == 109 || e.getKeyCode() == 45) {
                this.getMainPanel().getControlPanel().zoomOutY(0.9259259f);
                this.getMainPanel().getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (TreePanel.plusPressed(e.getKeyCode())) {
                this.getMainPanel().getControlPanel().zoomInX(1.08f, 1.08f);
                this.getMainPanel().getControlPanel().zoomInY(1.08f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (e.getKeyCode() == 83) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                    this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) + 0.09817477315664291);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else if (e.getKeyCode() == 65) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                    this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) - 0.09817477315664291);
                    if (this.getStartingAngle() < 0.0) {
                        this.setStartingAngle(Math.PI * 2 + this.getStartingAngle());
                    }
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else if (e.getKeyCode() == 68) {
                boolean selected = false;
                if (this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.HORIZONTAL) {
                    this.getOptions().setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
                    selected = true;
                } else {
                    this.getOptions().setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                }
                if (this.getMainPanel().getMainFrame() == null) {
                    ArchaeopteryxE ae = (ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet();
                    if (ae.getlabelDirectionCbmi() != null) {
                        ae.getlabelDirectionCbmi().setSelected(selected);
                    }
                } else {
                    this.getMainPanel().getMainFrame().getlabelDirectionCbmi().setSelected(selected);
                }
                this.repaint();
            } else if (e.getKeyCode() == 88) {
                this.switchDisplaygetPhylogenyGraphicsType();
                this.repaint();
            } else if (e.getKeyCode() == 67) {
                this.cycleColors();
                this.repaint();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && e.getKeyCode() == 79) {
                MainFrame.cycleOverview(this.getOptions(), this);
                this.repaint();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && e.getKeyCode() == 73) {
                this.increaseOvSize();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && e.getKeyCode() == 85) {
                this.decreaseOvSize();
            }
            e.consume();
        }
    }

    private final void makePopupMenus(PhylogenyNode node) {
        this._node_popup_menu = new JPopupMenu();
        List<String> clickto_names = this._main_panel.getControlPanel().getSingleClickToNames();
        this._node_popup_menu_items = new JMenuItem[clickto_names.size()];
        for (int i = 0; i < clickto_names.size(); ++i) {
            String title = clickto_names.get(i);
            this._node_popup_menu_items[i] = new JMenuItem(title);
            if (title.equals(Configuration.clickto_options[8][0])) {
                String id = this.isCanOpenSeqWeb(node);
                if (!ForesterUtil.isEmpty(id)) {
                    this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + id + "]");
                    this._node_popup_menu_items[i].setEnabled(true);
                } else {
                    this._node_popup_menu_items[i].setEnabled(false);
                }
            } else if (title.equals(Configuration.clickto_options[9][0])) {
                List<Accession> accs = this.getPdbAccs(node);
                this._node_popup_menu_items[i] = new JMenuItem(title);
                if (!ForesterUtil.isEmpty(accs)) {
                    if (accs.size() == 1) {
                        this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + TreePanelUtil.pdbAccToString(accs, 0) + "]");
                        this._node_popup_menu_items[i].setEnabled(true);
                    } else if (accs.size() == 2) {
                        this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + TreePanelUtil.pdbAccToString(accs, 0) + ", " + TreePanelUtil.pdbAccToString(accs, 1) + "]");
                        this._node_popup_menu_items[i].setEnabled(true);
                    } else if (accs.size() == 3) {
                        this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + TreePanelUtil.pdbAccToString(accs, 0) + ", " + TreePanelUtil.pdbAccToString(accs, 1) + ", " + TreePanelUtil.pdbAccToString(accs, 2) + "]");
                        this._node_popup_menu_items[i].setEnabled(true);
                    } else {
                        this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + TreePanelUtil.pdbAccToString(accs, 0) + ", " + TreePanelUtil.pdbAccToString(accs, 1) + ", " + TreePanelUtil.pdbAccToString(accs, 2) + ", + " + (accs.size() - 3) + " more]");
                        this._node_popup_menu_items[i].setEnabled(true);
                    }
                } else {
                    this._node_popup_menu_items[i].setEnabled(false);
                }
            } else if (title.startsWith(Configuration.clickto_options[19][0])) {
                this._node_popup_menu_items[i].setText(Configuration.clickto_options[19][0] + ": " + this.getOptions().getExtDescNodeDataToReturn().toString());
            } else if (title.equals(Configuration.clickto_options[10][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanOpenTaxWeb(node));
            } else if (title.equals(Configuration.clickto_options[11][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanBlast(node));
            } else if (title.equals(Configuration.clickto_options[15][0])) {
                if (!this.getOptions().isEditable()) continue;
                this._node_popup_menu_items[i].setEnabled(this.isCanDelete());
            } else if (title.equals(Configuration.clickto_options[12][0])) {
                if (!this.getOptions().isEditable()) continue;
                this._node_popup_menu_items[i].setEnabled(this.isCanCut(node));
            } else if (title.equals(Configuration.clickto_options[13][0])) {
                if (!this.getOptions().isEditable()) continue;
                this._node_popup_menu_items[i].setEnabled(this.isCanCopy());
            } else if (title.equals(Configuration.clickto_options[14][0])) {
                if (!this.getOptions().isEditable()) continue;
                this._node_popup_menu_items[i].setEnabled(this.isCanPaste());
            } else if (title.equals(Configuration.clickto_options[17][0])) {
                if (!this.getOptions().isEditable()) {
                    continue;
                }
            } else if (title.equals(Configuration.clickto_options[16][0])) {
                if (!this.getOptions().isEditable()) {
                    continue;
                }
            } else if (title.equals(Configuration.clickto_options[2][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanReroot());
            } else if (title.equals(Configuration.clickto_options[1][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanCollapse() && !node.isExternal());
            } else if (title.equals(Configuration.clickto_options[7][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanColorSubtree());
            } else if (title.equals(Configuration.clickto_options[3][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanSubtree(node));
            } else if (title.equals(Configuration.clickto_options[4][0])) {
                this._node_popup_menu_items[i].setEnabled(node.getNumberOfDescendants() == 2);
            } else if (title.equals(Configuration.clickto_options[18][0])) {
                this._node_popup_menu_items[i].setEnabled(node.getNumberOfDescendants() > 1);
            }
            this._node_popup_menu_items[i].addActionListener(this);
            this._node_popup_menu.add(this._node_popup_menu_items[i]);
        }
    }

    private final void nodeDataAsSB(PhylogenyNode node, StringBuilder sb) {
        if (node != null) {
            if (this.getControlPanel().isShowNodeNames() && !ForesterUtil.isEmpty(node.getName())) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(node.getName());
            }
            if (node.getNodeData().isHasSequence()) {
                if (this.getControlPanel().isShowSeqSymbols() && node.getNodeData().getSequence().getSymbol().length() > 0) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(node.getNodeData().getSequence().getSymbol());
                }
                if (this.getControlPanel().isShowGeneNames() && node.getNodeData().getSequence().getGeneName().length() > 0) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(node.getNodeData().getSequence().getGeneName());
                }
                if (this.getControlPanel().isShowSeqNames() && node.getNodeData().getSequence().getName().length() > 0) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(node.getNodeData().getSequence().getName());
                }
                if (this.getControlPanel().isShowSequenceAcc() && node.getNodeData().getSequence().getAccession() != null) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().getSource())) {
                        sb.append(node.getNodeData().getSequence().getAccession().getSource());
                        sb.append(":");
                    }
                    sb.append(node.getNodeData().getSequence().getAccession().getValue());
                }
            }
            if (this.getControlPanel().isShowProperties() && node.getNodeData().isHasProperties()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(this.propertiesToString(node));
            }
        }
    }

    private final void nodeTaxonomyDataAsSB(Taxonomy taxonomy, StringBuilder sb) {
        if (this._control_panel.isShowTaxonomyCode() && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            sb.append(taxonomy.getTaxonomyCode());
            sb.append(" ");
        }
        if (this._control_panel.isShowTaxonomyScientificNames() && this._control_panel.isShowTaxonomyCommonNames()) {
            if (!ForesterUtil.isEmpty(taxonomy.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName(), sb);
                } else {
                    sb.append(taxonomy.getScientificName());
                }
                sb.append(" (");
                sb.append(taxonomy.getCommonName());
                sb.append(") ");
            } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName(), sb);
                } else {
                    sb.append(taxonomy.getScientificName());
                }
                sb.append(" ");
            } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                sb.append(taxonomy.getCommonName());
                sb.append(" ");
            }
        } else if (this._control_panel.isShowTaxonomyScientificNames()) {
            if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName(), sb);
                } else {
                    sb.append(taxonomy.getScientificName());
                }
                sb.append(" ");
            }
        } else if (this._control_panel.isShowTaxonomyCommonNames() && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            sb.append(taxonomy.getCommonName());
            sb.append(" ");
        }
    }

    private final String obtainTitleForExtDescNodeData() {
        return this.getOptions().getExtDescNodeDataToReturn().toString();
    }

    private final void openPdbWeb(PhylogenyNode node) {
        List<Accession> pdb_ids = this.getPdbAccs(node);
        if (ForesterUtil.isEmpty(pdb_ids)) {
            this.cannotOpenBrowserWarningMessage("PDB");
            return;
        }
        List<String> uri_strs = TreePanelUtil.createUrisForPdbWeb(node, pdb_ids, this.getConfiguration(), this);
        if (!ForesterUtil.isEmpty(uri_strs)) {
            for (String uri_str : uri_strs) {
                try {
                    AptxUtil.launchWebBrowser(new URI(uri_str), this.isApplet(), this.isApplet() ? this.obtainApplet() : null, "_aptx_seq");
                }
                catch (IOException e) {
                    AptxUtil.showErrorMessage(this, e.toString());
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    AptxUtil.showErrorMessage(this, e.toString());
                    e.printStackTrace();
                }
            }
        } else {
            this.cannotOpenBrowserWarningMessage("PDB");
        }
    }

    private final void openSeqWeb(PhylogenyNode node) {
        if (ForesterUtil.isEmpty(this.isCanOpenSeqWeb(node))) {
            this.cannotOpenBrowserWarningMessage("sequence");
            return;
        }
        String uri_str = TreePanelUtil.createUriForSeqWeb(node, this.getConfiguration(), this);
        if (!ForesterUtil.isEmpty(uri_str)) {
            try {
                AptxUtil.launchWebBrowser(new URI(uri_str), this.isApplet(), this.isApplet() ? this.obtainApplet() : null, "_aptx_seq");
            }
            catch (IOException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else {
            this.cannotOpenBrowserWarningMessage("sequence");
        }
    }

    private final void openTaxWeb(PhylogenyNode node) {
        if (!this.isCanOpenTaxWeb(node)) {
            this.cannotOpenBrowserWarningMessage("taxonomic");
            return;
        }
        String uri_str = null;
        Taxonomy tax = node.getNodeData().getTaxonomy();
        if (tax.getIdentifier() != null && !ForesterUtil.isEmpty(tax.getIdentifier().getValue()) && tax.getIdentifier().getValue().startsWith("http://")) {
            try {
                uri_str = new URI(tax.getIdentifier().getValue()).toString();
            }
            catch (URISyntaxException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                uri_str = null;
                e.printStackTrace();
            }
        } else if (tax.getIdentifier() != null && !ForesterUtil.isEmpty(tax.getIdentifier().getValue()) && !ForesterUtil.isEmpty(tax.getIdentifier().getProvider()) && (tax.getIdentifier().getProvider().equalsIgnoreCase("ncbi") || tax.getIdentifier().getProvider().equalsIgnoreCase("uniprot"))) {
            try {
                uri_str = "http://www.uniprot.org/taxonomy/" + URLEncoder.encode(tax.getIdentifier().getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(tax.getScientificName())) {
            try {
                uri_str = "http://www.uniprot.org/taxonomy/?query=" + URLEncoder.encode(tax.getScientificName(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
            try {
                uri_str = "http://www.uniprot.org/taxonomy/?query=" + URLEncoder.encode(tax.getTaxonomyCode(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(tax.getCommonName())) {
            try {
                uri_str = "http://www.uniprot.org/taxonomy/?query=" + URLEncoder.encode(tax.getCommonName(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        }
        if (!ForesterUtil.isEmpty(uri_str)) {
            try {
                AptxUtil.launchWebBrowser(new URI(uri_str), this.isApplet(), this.isApplet() ? this.obtainApplet() : null, "_aptx_tax");
            }
            catch (IOException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                AptxUtil.showErrorMessage(this, e.toString());
                e.printStackTrace();
            }
        } else {
            this.cannotOpenBrowserWarningMessage("taxonomic");
        }
    }

    private final void paintBranchLength(Graphics2D g, PhylogenyNode node, boolean to_pdf, boolean to_graphics_file) {
        g.setFont(this.getTreeFontSet().getSmallFont());
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(this.getTreeColorSet().getBranchLengthColor());
        }
        if (!node.isRoot()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(node.getDistanceToParent()), node.getParent().getXcoord() + 10.0f, node.getYcoord() - (float)this.getTreeFontSet().getSmallMaxDescent(), g);
            } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(node.getDistanceToParent()), node.getParent().getXcoord() + 8.0f, node.getYcoord() - (float)this.getTreeFontSet().getSmallMaxDescent(), g);
            } else {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(node.getDistanceToParent()), node.getParent().getXcoord() + 3.0f, node.getYcoord() - (float)this.getTreeFontSet().getSmallMaxDescent(), g);
            }
        } else {
            TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(node.getDistanceToParent()), 3.0f, node.getYcoord() - (float)this.getTreeFontSet().getSmallMaxDescent(), g);
        }
    }

    private final void paintBranchLite(Graphics2D g, float x1, float x2, float y1, float y2, PhylogenyNode node) {
        g.setColor(this.getTreeColorSet().getOvColor());
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR) {
            this.drawLine(x1, y1, x2, y2, g);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX) {
            this._quad_curve.setCurve(x1, y1, x1, y2, x2, y2);
            g.draw(this._quad_curve);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CURVED) {
            float dx = x2 - x1;
            float dy = y2 - y1;
            this._cubic_curve.setCurve(x1, y1, x1 + dx * 0.4f, y1 + dy * 0.2f, x1 + dx * 0.6f, y1 + dy * 0.8f, x2, y2);
            g.draw(this._cubic_curve);
        } else {
            float x2a = x2;
            float x1a = x1;
            if (node.isFirstChildNode() || node.isLastChildNode()) {
                this.drawLine(x1, y1, x1, y2, g);
            }
            this.drawLine(x1a, y2, x2a, y2, g);
        }
    }

    private final void paintBranchRectangular(Graphics2D g, float x1, float x2, float y1, float y2, PhylogenyNode node, boolean to_pdf, boolean to_graphics_file) {
        this.assignGraphicsForBranchWithColorForParentBranch(node, false, g, to_pdf, to_graphics_file);
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR) {
            this.drawLine(x1, y1, x2, y2, g);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX) {
            this._quad_curve.setCurve(x1, y1, x1, y2, x2, y2);
            g.draw(this._quad_curve);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CURVED) {
            float dx = x2 - x1;
            float dy = y2 - y1;
            this._cubic_curve.setCurve(x1, y1, x1 + dx * 0.4f, y1 + dy * 0.2f, x1 + dx * 0.6f, y1 + dy * 0.8f, x2, y2);
            g.draw(this._cubic_curve);
        } else {
            float x2a = x2;
            float x1a = x1;
            float y2_r = 0.0f;
            if (!(!node.isFirstChildNode() && !node.isLastChildNode() && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || !to_graphics_file && !to_pdf && ((double)y2 < this.getVisibleRect().getMinY() - 20.0 && (double)y1 < this.getVisibleRect().getMinY() - 20.0 || (double)y2 > this.getVisibleRect().getMaxY() + 20.0 && (double)y1 > this.getVisibleRect().getMaxY() + 20.0))) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    float x2c = x1 + 10.0f;
                    if (x2c > x2a) {
                        x2c = x2a;
                    }
                    this.drawLine(x1, y1, x2c, y2, g);
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    if (y2 > y1) {
                        y2_r = y2 - 8.0f;
                        if (y2_r < y1) {
                            y2_r = y1;
                        }
                        this.drawLine(x1, y1, x1, y2_r, g);
                    } else {
                        y2_r = y2 + 8.0f;
                        if (y2_r > y1) {
                            y2_r = y1;
                        }
                        this.drawLine(x1, y1, x1, y2_r, g);
                    }
                } else {
                    this.drawLine(x1, y1, x1, y2, g);
                }
            }
            if (!to_graphics_file && !to_pdf && ((double)y2 < this.getVisibleRect().getMinY() - 20.0 || (double)y2 > this.getVisibleRect().getMaxY() + 20.0)) {
                return;
            }
            float x1_r = 0.0f;
            if (!this.getControlPanel().isWidthBranches() || PhylogenyMethods.getBranchWidthValue(node) == 1.0) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    x1_r = x1a + 8.0f;
                    if (x1_r < x2a) {
                        this.drawLine(x1_r, y2, x2a, y2, g);
                    }
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    float x1c = x1a + 10.0f;
                    if (x1c < x2a) {
                        this.drawLine(x1c, y2, x2a, y2, g);
                    }
                } else {
                    this.drawLine(x1a, y2, x2a, y2, g);
                }
            } else {
                double w = PhylogenyMethods.getBranchWidthValue(node);
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    x1_r = x1a + 8.0f;
                    if (x1_r < x2a) {
                        this.drawRectFilled(x1_r, (double)y2 - w / 2.0, x2a - x1_r, w, g);
                    }
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    float x1c = x1a + 10.0f;
                    if (x1c < x2a) {
                        this.drawRectFilled(x1c, (double)y2 - w / 2.0, x2a - x1c, w, g);
                    }
                } else {
                    this.drawRectFilled(x1a, (double)y2 - w / 2.0, x2a - x1a, w, g);
                }
            }
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                if (x1_r > x2a) {
                    x1_r = x2a;
                }
                if (y2 > y2_r) {
                    double diff = y2 - y2_r;
                    this._arc.setArc(x1, (double)y2_r - diff, 2.0f * (x1_r - x1), 2.0 * diff, 180.0, 90.0, 0);
                } else {
                    this._arc.setArc(x1, y2, 2.0f * (x1_r - x1), 2.0f * (y2_r - y2), 90.0, 90.0, 0);
                }
                g.draw(this._arc);
            }
        }
        if (node.isExternal()) {
            this.paintNodeBox(x2, y2, node, g, to_pdf, to_graphics_file);
        }
    }

    private final double paintCirculars(PhylogenyNode n, Phylogeny phy, float center_x, float center_y, double radius, boolean radial_labels, Graphics2D g, boolean to_pdf, boolean to_graphics_file) {
        if (n.isExternal() || n.isCollapse()) {
            if (!this._urt_nodeid_angle_map.containsKey(n.getId())) {
                System.out.println("no " + n + " =====>>>>>>> ERROR!");
            }
            return this._urt_nodeid_angle_map.get(n.getId());
        }
        List<PhylogenyNode> descs = n.getDescendants();
        double sum = 0.0;
        for (PhylogenyNode desc : descs) {
            sum += this.paintCirculars(desc, phy, center_x, center_y, radius, radial_labels, g, to_pdf, to_graphics_file);
        }
        double r = 0.0;
        if (!n.isRoot()) {
            r = 1.0 - ((double)this._circ_max_depth - (double)n.calculateDepth()) / (double)this._circ_max_depth;
        }
        double theta = sum / (double)descs.size();
        n.setXcoord((float)((double)center_x + r * radius * Math.cos(theta)));
        n.setYcoord((float)((double)center_y + r * radius * Math.sin(theta)));
        this._urt_nodeid_angle_map.put(n.getId(), theta);
        for (PhylogenyNode desc : descs) {
            this.paintBranchCircular(n, desc, g, radial_labels, to_pdf, to_graphics_file);
        }
        return theta;
    }

    private final void paintCircularsLite(PhylogenyNode n, Phylogeny phy, int center_x, int center_y, int radius, Graphics2D g) {
        if (n.isExternal()) {
            return;
        }
        List<PhylogenyNode> descs = n.getDescendants();
        for (PhylogenyNode desc : descs) {
            this.paintCircularsLite(desc, phy, center_x, center_y, radius, g);
        }
        float r = 0.0f;
        if (!n.isRoot()) {
            r = 1.0f - ((float)this._circ_max_depth - (float)n.calculateDepth()) / (float)this._circ_max_depth;
        }
        double theta = this._urt_nodeid_angle_map.get(n.getId());
        n.setXSecondary((float)((double)center_x + (double)((float)radius * r) * Math.cos(theta)));
        n.setYSecondary((float)((double)center_y + (double)((float)radius * r) * Math.sin(theta)));
        for (PhylogenyNode desc : descs) {
            this.paintBranchCircularLite(n, desc, g);
        }
    }

    private final void paintCollapsedNode(Graphics2D g, PhylogenyNode node, boolean to_graphics_file, boolean to_pdf, boolean is_in_found_nodes) {
        float xx;
        int box_size;
        Color c = null;
        c = (to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite() ? Color.BLACK : (is_in_found_nodes ? this.getColorForFoundNode(node) : (this.getControlPanel().isColorAccordingToSequence() ? this.getSequenceBasedColor(node) : (this.getControlPanel().isColorAccordingToTaxonomy() ? this.getTaxonomyBasedColor(node) : (this.getOptions().isColorLabelsSameAsParentBranch() && this.getControlPanel().isUseVisualStyles() && PhylogenyMethods.getBranchColorValue(node) != null ? PhylogenyMethods.getBranchColorValue(node) : this.getTreeColorSet().getCollapseFillColor()))));
        double d = node.getAllExternalDescendants().size();
        if ((d = d > 1000.0 ? (double)(3.0f * this._y_distance / 3.0f) : Math.log10(d) * (double)this._y_distance / 2.5) < (double)(box_size = this.getOptions().getDefaultNodeShapeSize() + 1)) {
            d = box_size;
        }
        float xxx = (xx = node.getXcoord() - (float)(2 * box_size)) > node.getParent().getXcoord() + 1.0f ? xx : node.getParent().getXcoord() + 1.0f;
        this._polygon.reset();
        this._polygon.moveTo(xxx, node.getYcoord());
        this._polygon.lineTo((double)(node.getXcoord() + 1.0f), (double)node.getYcoord() - d);
        this._polygon.lineTo((double)(node.getXcoord() + 1.0f), (double)node.getYcoord() + d);
        this._polygon.closePath();
        if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.SOLID) {
            g.setColor(c);
            g.fill(this._polygon);
        } else if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.NONE) {
            g.setColor(this.getBackground());
            g.fill(this._polygon);
            g.setColor(c);
            g.draw(this._polygon);
        } else if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.GRADIENT) {
            g.setPaint(new GradientPaint(xxx, node.getYcoord(), this.getBackground(), node.getXcoord(), (float)((double)node.getYcoord() - d), c, false));
            g.fill(this._polygon);
            g.setPaint(c);
            g.draw(this._polygon);
        }
        this.paintNodeData(g, node, to_graphics_file, to_pdf, is_in_found_nodes);
    }

    private final void paintConfidenceValues(Graphics2D g, PhylogenyNode node, boolean to_pdf, boolean to_graphics_file) {
        List<Confidence> confidences = node.getBranchData().getConfidences();
        boolean not_first = false;
        Collections.sort(confidences);
        StringBuilder sb = new StringBuilder();
        for (Confidence confidence : confidences) {
            double value;
            if (!ForesterUtil.isEmpty(SHOW_ONLY_THIS_CONF_TYPE) && (ForesterUtil.isEmpty(confidence.getType()) || !confidence.getType().equalsIgnoreCase(SHOW_ONLY_THIS_CONF_TYPE)) || (value = confidence.getValue()) == -9999.0) continue;
            if (value < this.getOptions().getMinConfidenceValue()) {
                return;
            }
            if (not_first) {
                sb.append("/");
            } else {
                not_first = true;
            }
            sb.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(value, this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
            if (!this.getOptions().isShowConfidenceStddev() || confidence.getStandardDeviation() == -9999.0) continue;
            sb.append("(");
            sb.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(confidence.getStandardDeviation(), this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
            sb.append(")");
        }
        if (sb.length() > 0) {
            float parent_x = node.getParent().getXcoord();
            float x = node.getXcoord();
            g.setFont(this.getTreeFontSet().getSmallFont());
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                x += 10.0f;
            } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                x += 8.0f;
            }
            if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.getTreeColorSet().getConfidenceColor());
            }
            String conf_str = sb.toString();
            TreePanel.drawString(conf_str, parent_x + (x - parent_x - (float)this.getTreeFontSet().getFontMetricsSmall().stringWidth(conf_str)) / 2.0f, node.getYcoord() + (float)this.getTreeFontSet().getSmallMaxAscent() - 1.0f, g);
        }
    }

    private final void paintGainedAndLostCharacters(Graphics2D g, PhylogenyNode node, String gained, String lost) {
        if (node.getParent() != null) {
            float parent_x = node.getParent().getXcoord();
            float x = node.getXcoord();
            g.setFont(this.getTreeFontSet().getLargeFont());
            g.setColor(this.getTreeColorSet().getGainedCharactersColor());
            TreePanel.drawString(gained, parent_x + (x - parent_x - (float)this.getFontMetricsForLargeDefaultFont().stringWidth(gained)) / 2.0f, node.getYcoord() - (float)this.getFontMetricsForLargeDefaultFont().getMaxDescent(), g);
            g.setColor(this.getTreeColorSet().getLostCharactersColor());
            TreePanel.drawString(lost, parent_x + (x - parent_x - (float)this.getFontMetricsForLargeDefaultFont().stringWidth(lost)) / 2.0f, node.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getMaxAscent(), g);
        }
    }

    private void paintMolecularSequences(Graphics2D g, PhylogenyNode node, boolean to_pdf) {
        RenderableMsaSequence rs = RenderableMsaSequence.createInstance(node.getNodeData().getSequence().getMolecularSequence(), node.getNodeData().getSequence().getType(), this.getConfiguration());
        if (rs != null) {
            int default_height = 8;
            float y = this.getYdistance();
            int h = y / 2.0f < 8.0f ? ForesterUtil.roundToInt(y * 2.0f) : 8;
            rs.setRenderingHeight(h > 1 ? (float)h : 1.0f);
            if (this.getControlPanel().isDrawPhylogram()) {
                rs.render((float)(this.getMaxDistanceToRoot() * (double)this.getXcorrectionFactor() + (double)this._length_of_longest_text), node.getYcoord() - (float)h / 2.0f, g, this, to_pdf);
            } else {
                rs.render(this.getPhylogeny().getFirstExternalNode().getXcoord() + (float)this._length_of_longest_text, node.getYcoord() - (float)h / 2.0f, g, this, to_pdf);
            }
        }
    }

    private final void paintNodeBox(float x, float y, PhylogenyNode node, Graphics2D g, boolean to_pdf, boolean to_graphics_file) {
        if (node.isCollapse()) {
            return;
        }
        if (this._highlight_node == node && !to_pdf && !to_graphics_file) {
            g.setColor(this.getTreeColorSet().getFoundColor0());
            this.drawOval(x - 8.0f, y - 8.0f, 16.0, 16.0, g);
            this.drawOval(x - 9.0f, y - 8.0f, 17.0, 17.0, g);
            this.drawOval(x - 9.0f, y - 9.0f, 18.0, 18.0, g);
        }
        if (this.isInFoundNodes(node) || this.isInCurrentExternalNodes(node) || this.getOptions().isShowDefaultNodeShapesExternal() && node.isExternal() || this.getOptions().isShowDefaultNodeShapesInternal() && node.isInternal() || this.getOptions().isShowDefaultNodeShapesForMarkedNodes() && node.getNodeData().getNodeVisualData() != null && !node.getNodeData().getNodeVisualData().isEmpty() || this.getControlPanel().isUseVisualStyles() && node.getNodeData().getNodeVisualData() != null && (node.getNodeData().getNodeVisualData().getNodeColor() != null || node.getNodeData().getNodeVisualData().getSize() != -1.0f || node.getNodeData().getNodeVisualData().getFillType() != NodeVisualData.NodeFill.DEFAULT || node.getNodeData().getNodeVisualData().getShape() != NodeVisualData.NodeShape.DEFAULT) || this.getControlPanel().isEvents() && node.isHasAssignedEvent() && (node.getNodeData().getEvent().isDuplication() || node.getNodeData().getEvent().isSpeciation() || node.getNodeData().getEvent().isSpeciationOrDuplication())) {
            NodeVisualData vis = null;
            if (this.getControlPanel().isUseVisualStyles() && node.getNodeData().getNodeVisualData() != null && !node.getNodeData().getNodeVisualData().isEmpty()) {
                vis = node.getNodeData().getNodeVisualData();
            }
            float box_size = this.getOptions().getDefaultNodeShapeSize();
            if (vis != null && vis.getSize() != -1.0f) {
                box_size = vis.getSize();
            }
            float half_box_size = box_size / 2.0f;
            Color outline_color = null;
            if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
                outline_color = Color.BLACK;
            } else if (this.isInFoundNodes(node) || this.isInCurrentExternalNodes(node)) {
                outline_color = this.getColorForFoundNode(node);
            } else if (vis != null) {
                if (vis.getNodeColor() != null) {
                    outline_color = vis.getNodeColor();
                } else if (vis.getFontColor() != null) {
                    outline_color = vis.getFontColor();
                }
            } else if (this.getControlPanel().isEvents() && TreePanelUtil.isHasAssignedEvent(node)) {
                Event event = node.getNodeData().getEvent();
                if (event.isDuplication()) {
                    outline_color = this.getTreeColorSet().getDuplicationBoxColor();
                } else if (event.isSpeciation()) {
                    outline_color = this.getTreeColorSet().getSpecBoxColor();
                } else if (event.isSpeciationOrDuplication()) {
                    outline_color = this.getTreeColorSet().getDuplicationOrSpeciationColor();
                }
            }
            if (outline_color == null) {
                outline_color = this.getGraphicsForNodeBoxWithColorForParentBranch(node);
                if (to_pdf && outline_color == this.getTreeColorSet().getBranchColor()) {
                    outline_color = this.getTreeColorSet().getBranchColorForPdf();
                }
            }
            NodeVisualData.NodeShape shape = null;
            if (vis != null) {
                if (vis.getShape() == NodeVisualData.NodeShape.CIRCLE) {
                    shape = NodeVisualData.NodeShape.CIRCLE;
                } else if (vis.getShape() == NodeVisualData.NodeShape.RECTANGLE) {
                    shape = NodeVisualData.NodeShape.RECTANGLE;
                }
            }
            if (shape == null) {
                if (this.getOptions().getDefaultNodeShape() == NodeVisualData.NodeShape.CIRCLE) {
                    shape = NodeVisualData.NodeShape.CIRCLE;
                } else if (this.getOptions().getDefaultNodeShape() == NodeVisualData.NodeShape.RECTANGLE) {
                    shape = NodeVisualData.NodeShape.RECTANGLE;
                }
            }
            NodeVisualData.NodeFill fill = null;
            if (vis != null) {
                if (vis.getFillType() == NodeVisualData.NodeFill.SOLID) {
                    fill = NodeVisualData.NodeFill.SOLID;
                } else if (vis.getFillType() == NodeVisualData.NodeFill.NONE) {
                    fill = NodeVisualData.NodeFill.NONE;
                } else if (vis.getFillType() == NodeVisualData.NodeFill.GRADIENT) {
                    fill = NodeVisualData.NodeFill.GRADIENT;
                }
            }
            if (fill == null) {
                if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.SOLID) {
                    fill = NodeVisualData.NodeFill.SOLID;
                } else if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.NONE) {
                    fill = NodeVisualData.NodeFill.NONE;
                } else if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.GRADIENT) {
                    fill = NodeVisualData.NodeFill.GRADIENT;
                }
            }
            Color vis_fill_color = null;
            if (vis != null && vis.getNodeColor() != null) {
                vis_fill_color = vis.getNodeColor();
            }
            if (shape == NodeVisualData.NodeShape.CIRCLE) {
                if (fill == NodeVisualData.NodeFill.GRADIENT) {
                    this.drawOvalGradient(x - half_box_size, y - half_box_size, box_size, box_size, g, to_pdf ? Color.WHITE : outline_color, to_pdf ? outline_color : this.getBackground(), outline_color);
                } else if (fill == NodeVisualData.NodeFill.NONE) {
                    Color background = this.getBackground();
                    if (to_pdf) {
                        background = Color.WHITE;
                    }
                    this.drawOvalGradient(x - half_box_size, y - half_box_size, box_size, box_size, g, background, background, outline_color);
                } else if (fill == NodeVisualData.NodeFill.SOLID) {
                    if (vis_fill_color != null) {
                        g.setColor(vis_fill_color);
                    } else {
                        g.setColor(outline_color);
                    }
                    this.drawOvalFilled(x - half_box_size, y - half_box_size, box_size, box_size, g);
                }
            } else if (shape == NodeVisualData.NodeShape.RECTANGLE) {
                if (fill == NodeVisualData.NodeFill.GRADIENT) {
                    this.drawRectGradient(x - half_box_size, y - half_box_size, box_size, box_size, g, to_pdf ? Color.WHITE : outline_color, to_pdf ? outline_color : this.getBackground(), outline_color);
                } else if (fill == NodeVisualData.NodeFill.NONE) {
                    Color background = this.getBackground();
                    if (to_pdf) {
                        background = Color.WHITE;
                    }
                    this.drawRectGradient(x - half_box_size, y - half_box_size, box_size, box_size, g, background, background, outline_color);
                } else if (fill == NodeVisualData.NodeFill.SOLID) {
                    if (vis_fill_color != null) {
                        g.setColor(vis_fill_color);
                    } else {
                        g.setColor(outline_color);
                    }
                    this.drawRectFilled(x - half_box_size, y - half_box_size, box_size, box_size, g);
                }
            }
        }
    }

    private final int paintNodeData(Graphics2D g, PhylogenyNode node, boolean to_graphics_file, boolean to_pdf, boolean is_in_found_nodes) {
        String sb_str;
        float pos_y;
        float pos_x;
        float down_shift_factor;
        boolean using_visual_font;
        int half_box_size;
        int x;
        block26: {
            int nodeTextBoundsWidth;
            block27: {
                if (this.isNodeDataInvisible(node) && !to_graphics_file && !to_pdf) {
                    return 0;
                }
                if (this.getControlPanel().isWriteBranchLengthValues() && (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) && !node.isRoot() && node.getDistanceToParent() != -1024.0) {
                    this.paintBranchLength(g, node, to_pdf, to_graphics_file);
                }
                if (!(this.getControlPanel().isShowInternalData() || node.isExternal() || node.isCollapse())) {
                    return 0;
                }
                this._sb.setLength(0);
                x = 0;
                half_box_size = this.getOptions().getDefaultNodeShapeSize() / 2;
                if (this.getControlPanel().isShowTaxonomyImages() && this.getImageMap() != null && !this.getImageMap().isEmpty() && node.getNodeData().isHasTaxonomy() && node.getNodeData().getTaxonomy().getUris() != null && !node.getNodeData().getTaxonomy().getUris().isEmpty()) {
                    x = (int)((double)x + this.drawTaxonomyImage(node.getXcoord() + 2.0f + (float)half_box_size, node.getYcoord(), node, g));
                }
                if ((this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCommonNames()) && node.getNodeData().isHasTaxonomy()) {
                    x += this.paintTaxonomy(g, node, is_in_found_nodes, to_pdf, to_graphics_file, x);
                }
                this.setColor(g, node, to_graphics_file, to_pdf, is_in_found_nodes, this.getTreeColorSet().getSequenceColor());
                if (node.isCollapse() && (!node.isRoot() && !node.getParent().isCollapse() || node.isRoot())) {
                    if (this._sb.length() > 0) {
                        this._sb.setLength(0);
                        this._sb.append(" (");
                        this._sb.append(node.getAllExternalDescendants().size());
                        this._sb.append(")");
                    }
                } else {
                    this._sb.setLength(0);
                }
                this.nodeDataAsSB(node, this._sb);
                using_visual_font = this.setFont(g, node, is_in_found_nodes);
                down_shift_factor = 3.0f;
                if (!node.isExternal() && node.getNumberOfDescendants() == 1) {
                    down_shift_factor = 1.0f;
                }
                pos_x = node.getXcoord() + (float)x + 2.0f + (float)half_box_size;
                pos_y = !using_visual_font ? node.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / down_shift_factor : node.getYcoord() + (float)this.getFontMetrics(g.getFont()).getAscent() / down_shift_factor;
                sb_str = this._sb.toString();
                if (!this._control_panel.isShowSequenceRelations() || !node.getNodeData().isHasSequence() || this._query_sequence == null) break block26;
                nodeTextBoundsWidth = 0;
                if (sb_str.length() > 0) {
                    Rectangle2D node_text_bounds = new TextLayout(sb_str, g.getFont(), this._frc).getBounds();
                    nodeTextBoundsWidth = (int)node_text_bounds.getWidth();
                }
                if (!node.getNodeData().getSequence().equals(this._query_sequence)) break block27;
                if (nodeTextBoundsWidth <= 0) break block26;
                g.fillRect((int)pos_x - 1, (int)pos_y - 8, nodeTextBoundsWidth + 5, 11);
                g.setColor(this.getTreeColorSet().getBackgroundColor());
                break block26;
            }
            List<SequenceRelation> seqRelations = node.getNodeData().getSequence().getSequenceRelations();
            for (SequenceRelation seqRelation : seqRelations) {
                String sConfidence;
                boolean fGotRelationWithQuery = (seqRelation.getRef0().isEqual(this._query_sequence) || seqRelation.getRef1().isEqual(this._query_sequence)) && seqRelation.getType().equals(this.getControlPanel().getSequenceRelationTypeBox().getSelectedItem());
                if (!fGotRelationWithQuery) continue;
                double linePosX = node.getXcoord() + 2.0f + (float)half_box_size;
                String string = sConfidence = !this.getControlPanel().isShowSequenceRelationConfidence() || seqRelation.getConfidence() == null ? null : " (" + seqRelation.getConfidence().getValue() + ")";
                if (sConfidence != null) {
                    float confidenceX = pos_x;
                    if (sb_str.length() > 0) {
                        confidenceX = (float)((double)confidenceX + (new TextLayout(sb_str, g.getFont(), this._frc).getBounds().getWidth() + 4.0));
                    }
                    if ((double)confidenceX > linePosX) {
                        int confidenceWidth = (int)new TextLayout(sConfidence, g.getFont(), this._frc).getBounds().getWidth();
                        TreePanel.drawString(sConfidence, confidenceX, pos_y, g);
                        x += 4 + confidenceWidth;
                    }
                }
                if (x + nodeTextBoundsWidth <= 0) continue;
                nodeTextBoundsWidth = nodeTextBoundsWidth == 0 ? (nodeTextBoundsWidth -= 3) : (nodeTextBoundsWidth += 2);
                g.drawLine((int)linePosX + 1, 3 + (int)pos_y, (int)linePosX + x + nodeTextBoundsWidth, 3 + (int)pos_y);
                break;
            }
        }
        if (sb_str.length() > 0) {
            TreePanel.drawString(sb_str, pos_x, pos_y, g);
        }
        if (this._sb.length() > 0) {
            x = !using_visual_font && !is_in_found_nodes ? (x += this.getFontMetricsForLargeDefaultFont().stringWidth(this._sb.toString()) + 5) : (x += this.getFontMetrics(g.getFont()).stringWidth(this._sb.toString()) + 5);
        }
        if (this.getControlPanel().isShowAnnotation() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAnnotations() != null && !node.getNodeData().getSequence().getAnnotations().isEmpty()) {
            SortedSet<Annotation> ann = node.getNodeData().getSequence().getAnnotations();
            if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(Color.BLACK);
            } else if (this.getControlPanel().isColorAccordingToAnnotation()) {
                g.setColor(this.calculateColorForAnnotation(ann));
            }
            String ann_str = TreePanelUtil.createAnnotationString(ann, this.getOptions().isShowAnnotationRefSource());
            TreePanel.drawString(ann_str, node.getXcoord() + (float)x + 3.0f + (float)half_box_size, node.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / down_shift_factor, g);
            this._sb.setLength(0);
            this._sb.append(ann_str);
            if (this._sb.length() > 0) {
                x = !using_visual_font && !is_in_found_nodes ? (x += this.getFontMetricsForLargeDefaultFont().stringWidth(this._sb.toString()) + 5) : (x += this.getFontMetrics(g.getFont()).stringWidth(this._sb.toString()) + 5);
            }
        }
        if ((this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) && (this.getControlPanel().isShowBinaryCharacters() || this.getControlPanel().isShowBinaryCharacterCounts()) && node.getNodeData().isHasBinaryCharacters()) {
            if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.getTreeColorSet().getBinaryDomainCombinationsColor());
            }
            if (this.getControlPanel().isShowBinaryCharacters()) {
                TreePanel.drawString(node.getNodeData().getBinaryCharacters().getPresentCharactersAsStringBuffer().toString(), node.getXcoord() + (float)x + 1.0f + (float)half_box_size, node.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / down_shift_factor, g);
                this.paintGainedAndLostCharacters(g, node, node.getNodeData().getBinaryCharacters().getGainedCharactersAsStringBuffer().toString(), node.getNodeData().getBinaryCharacters().getLostCharactersAsStringBuffer().toString());
            } else {
                TreePanel.drawString(" " + node.getNodeData().getBinaryCharacters().getPresentCount(), node.getXcoord() + (float)x + 4.0f + (float)half_box_size, node.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / down_shift_factor, g);
                this.paintGainedAndLostCharacters(g, node, "+" + node.getNodeData().getBinaryCharacters().getGainedCount(), "-" + node.getNodeData().getBinaryCharacters().getLostCount());
            }
        }
        return x;
    }

    private final void paintNodeDataUnrootedCirc(Graphics2D g, PhylogenyNode node, boolean to_pdf, boolean to_graphics_file, boolean radial_labels, double ur_angle, boolean is_in_found_nodes) {
        if (this.isNodeDataInvisibleUnrootedCirc(node) && !to_graphics_file && !to_pdf) {
            return;
        }
        this._sb.setLength(0);
        this._sb.append(" ");
        if (node.getNodeData().isHasTaxonomy() && (this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCommonNames())) {
            Taxonomy taxonomy = node.getNodeData().getTaxonomy();
            if (this._control_panel.isShowTaxonomyCode() && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                this._sb.append(taxonomy.getTaxonomyCode());
                this._sb.append(" ");
            }
            if (this._control_panel.isShowTaxonomyScientificNames() && this._control_panel.isShowTaxonomyCommonNames()) {
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                    this._sb.append(taxonomy.getScientificName());
                    this._sb.append(" (");
                    this._sb.append(taxonomy.getCommonName());
                    this._sb.append(") ");
                } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                    this._sb.append(taxonomy.getScientificName());
                    this._sb.append(" ");
                } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                    this._sb.append(taxonomy.getCommonName());
                    this._sb.append(" ");
                }
            } else if (this._control_panel.isShowTaxonomyScientificNames()) {
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                    this._sb.append(taxonomy.getScientificName());
                    this._sb.append(" ");
                }
            } else if (this._control_panel.isShowTaxonomyCommonNames() && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                this._sb.append(taxonomy.getCommonName());
                this._sb.append(" ");
            }
        }
        if (node.isCollapse() && (!node.isRoot() && !node.getParent().isCollapse() || node.isRoot())) {
            this._sb.append(" [");
            this._sb.append(node.getAllExternalDescendants().size());
            this._sb.append("]");
        }
        if (this.getControlPanel().isShowNodeNames() && node.getName().length() > 0) {
            if (this._sb.length() > 0) {
                this._sb.append(" ");
            }
            this._sb.append(node.getName());
        }
        if (node.getNodeData().isHasSequence()) {
            if (this.getControlPanel().isShowSequenceAcc() && node.getNodeData().getSequence().getAccession() != null) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                if (!ForesterUtil.isEmpty(node.getNodeData().getSequence().getAccession().getSource())) {
                    this._sb.append(node.getNodeData().getSequence().getAccession().getSource());
                    this._sb.append(":");
                }
                this._sb.append(node.getNodeData().getSequence().getAccession().getValue());
            }
            if (this.getControlPanel().isShowSeqNames() && node.getNodeData().getSequence().getName().length() > 0) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                this._sb.append(node.getNodeData().getSequence().getName());
            }
        }
        if (this._sb.length() > 1) {
            this.setColor(g, node, to_graphics_file, to_pdf, is_in_found_nodes, this.getTreeColorSet().getSequenceColor());
            boolean using_visual_font = this.setFont(g, node, is_in_found_nodes);
            String sb_str = this._sb.toString();
            double m = 0.0;
            m = this._graphics_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR ? this._urt_nodeid_angle_map.get(node.getId()) % (Math.PI * 2) : (double)((float)(ur_angle % (Math.PI * 2)));
            this._at = g.getTransform();
            boolean need_to_reset = false;
            float x_coord = node.getXcoord();
            float y_coord = !using_visual_font ? node.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / 3.0f : node.getYcoord() + (float)this.getFontMetrics(g.getFont()).getAscent() / 3.0f;
            if (radial_labels) {
                need_to_reset = true;
                boolean left = false;
                if (m > 1.5707963705062866 && m < 4.71238899230957) {
                    m -= 3.1415927410125732;
                    left = true;
                }
                g.rotate(m, x_coord, node.getYcoord());
                if (left) {
                    if (!using_visual_font) {
                        g.translate(-this.getFontMetricsForLargeDefaultFont().getStringBounds(sb_str, g).getWidth(), 0.0);
                    } else {
                        g.translate(-this.getFontMetrics(g.getFont()).getStringBounds(sb_str, g).getWidth(), 0.0);
                    }
                }
            } else if (m > 1.5707963705062866 && m < 4.71238899230957) {
                need_to_reset = true;
                if (!using_visual_font) {
                    g.translate(-this.getFontMetricsForLargeDefaultFont().getStringBounds(sb_str, g).getWidth(), 0.0);
                } else {
                    g.translate(-this.getFontMetrics(g.getFont()).getStringBounds(sb_str, g).getWidth(), 0.0);
                }
            }
            TreePanel.drawString(sb_str, x_coord, y_coord, g);
            if (need_to_reset) {
                g.setTransform(this._at);
            }
        }
    }

    private final void paintNodeLite(Graphics2D g, PhylogenyNode node) {
        if (node.isCollapse()) {
            if (!node.isRoot() && !node.getParent().isCollapse()) {
                this.paintCollapsedNode(g, node, false, false, false);
            }
            return;
        }
        if (this.isInFoundNodes(node) || this.isInCurrentExternalNodes(node)) {
            g.setColor(this.getColorForFoundNode(node));
            this.drawRectFilled((double)node.getXSecondary() - 1.0, (double)node.getYSecondary() - 1.0, 2.0, 2.0, g);
        }
        float new_x = 0.0f;
        if (!node.isExternal() && !node.isCollapse()) {
            boolean first_child = true;
            float y2 = 0.0f;
            short parent_max_branch_to_leaf = this.getMaxBranchesToLeaf(node);
            for (int i = 0; i < node.getNumberOfDescendants(); ++i) {
                PhylogenyNode child_node = node.getChildNode(i);
                int factor_x = !this.isUniformBranchLengthsForCladogram() ? node.getNumberOfExternalNodes() - child_node.getNumberOfExternalNodes() : parent_max_branch_to_leaf - this.getMaxBranchesToLeaf(child_node);
                if (first_child) {
                    first_child = false;
                    y2 = node.getYSecondary() - this.getOvYDistance() * (float)(node.getNumberOfExternalNodes() - child_node.getNumberOfExternalNodes());
                } else {
                    y2 += this.getOvYDistance() * (float)child_node.getNumberOfExternalNodes();
                }
                float x2 = this.calculateOvBranchLengthToParent(child_node, factor_x);
                new_x = x2 + node.getXSecondary();
                float diff_y = node.getYSecondary() - y2;
                float diff_x = node.getXSecondary() - new_x;
                if (diff_y > 2.0f || diff_y < -2.0f || diff_x > 2.0f || diff_x < -2.0f) {
                    this.paintBranchLite(g, node.getXSecondary(), new_x, node.getYSecondary(), y2, child_node);
                }
                child_node.setXSecondary(new_x);
                child_node.setYSecondary(y2);
                y2 += this.getOvYDistance() * (float)child_node.getNumberOfExternalNodes();
            }
        }
    }

    private final void paintNodeRectangular(Graphics2D g, PhylogenyNode node, boolean to_pdf, boolean dynamically_hide, int dynamic_hiding_factor, boolean to_graphics_file, boolean disallow_shortcutting) {
        boolean is_in_found_nodes;
        boolean bl = is_in_found_nodes = this.isInFoundNodes(node) || this.isInCurrentExternalNodes(node);
        if (node.isCollapse()) {
            if (!node.isRoot() && !node.getParent().isCollapse()) {
                this.paintCollapsedNode(g, node, to_graphics_file, to_pdf, is_in_found_nodes);
            }
            return;
        }
        if (node.isExternal()) {
            ++this._external_node_index;
        }
        if (this.getControlPanel().isShowConfidenceValues() && !node.isExternal() && !node.isRoot() && (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) && node.getBranchData().isHasConfidences()) {
            this.paintConfidenceValues(g, node, to_pdf, to_graphics_file);
        }
        if (node.isRoot() && this._phylogeny.isRooted()) {
            this.paintRootBranch(g, node.getXcoord(), node.getYcoord(), node, to_pdf, to_graphics_file);
        }
        float new_x = 0.0f;
        float new_x_min = Float.MAX_VALUE;
        float min_dist = 1.5f;
        if (!disallow_shortcutting) {
            if (dynamic_hiding_factor > 4000) {
                min_dist = 4.0f;
            } else if (dynamic_hiding_factor > 1000) {
                min_dist = 3.0f;
            } else if (dynamic_hiding_factor > 100) {
                min_dist = 2.0f;
            }
        }
        if (!node.isExternal() && !node.isCollapse()) {
            boolean first_child = true;
            float y2 = 0.0f;
            short parent_max_branch_to_leaf = this.getMaxBranchesToLeaf(node);
            for (int i = 0; i < node.getNumberOfDescendants(); ++i) {
                PhylogenyNode child_node = node.getChildNode(i);
                int factor_x = !this.isUniformBranchLengthsForCladogram() ? node.getNumberOfExternalNodes() - child_node.getNumberOfExternalNodes() : parent_max_branch_to_leaf - this.getMaxBranchesToLeaf(child_node);
                if (first_child) {
                    first_child = false;
                    y2 = node.getYcoord() - this._y_distance * (float)(node.getNumberOfExternalNodes() - child_node.getNumberOfExternalNodes());
                } else {
                    y2 += this._y_distance * (float)child_node.getNumberOfExternalNodes();
                }
                float x2 = this.calculateBranchLengthToParent(child_node, factor_x);
                new_x = x2 + node.getXcoord();
                if (dynamically_hide && x2 < new_x_min) {
                    new_x_min = x2;
                }
                float diff_y = node.getYcoord() - y2;
                float diff_x = node.getXcoord() - new_x;
                if (disallow_shortcutting || diff_y > min_dist || diff_y < -min_dist || diff_x > min_dist || diff_x < -min_dist) {
                    this.paintBranchRectangular(g, node.getXcoord(), new_x, node.getYcoord(), y2, child_node, to_pdf, to_graphics_file);
                }
                child_node.setXcoord(new_x);
                child_node.setYcoord(y2);
                y2 += this._y_distance * (float)child_node.getNumberOfExternalNodes();
            }
            this.paintNodeBox(node.getXcoord(), node.getYcoord(), node, g, to_pdf, to_graphics_file);
        }
        if (this.getControlPanel().isShowMolSequences() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().isMolecularSequenceAligned() && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getMolecularSequence())) {
            this.paintMolecularSequences(g, node, to_pdf);
        }
        if (dynamically_hide && !is_in_found_nodes && (node.isExternal() && this._external_node_index % dynamic_hiding_factor != 1 || !node.isExternal() && (new_x_min < 20.0f || this._y_distance * (float)node.getNumberOfExternalNodes() < (float)this.getFontMetricsForLargeDefaultFont().getHeight()))) {
            return;
        }
        int x = this.paintNodeData(g, node, to_graphics_file, to_pdf, is_in_found_nodes);
        this.paintNodeWithRenderableData(x, g, node, to_graphics_file, to_pdf);
    }

    private final void paintNodeWithRenderableData(int x, Graphics2D g, PhylogenyNode node, boolean to_graphics_file, boolean to_pdf) {
        RenderableVector rv;
        if (this.isNodeDataInvisible(node) && !to_graphics_file && !to_pdf) {
            return;
        }
        if (!this.getControlPanel().isShowInternalData() && !node.isExternal()) {
            return;
        }
        if (this.getControlPanel().isShowDomainArchitectures() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null && node.getNodeData().getSequence().getDomainArchitecture() instanceof RenderableDomainArchitecture) {
            RenderableDomainArchitecture rds = null;
            try {
                rds = (RenderableDomainArchitecture)node.getNodeData().getSequence().getDomainArchitecture();
            }
            catch (ClassCastException cce) {
                cce.printStackTrace();
            }
            if (rds != null) {
                int default_height = 7;
                float y = this.getYdistance();
                if (this.getControlPanel().isDynamicallyHideData()) {
                    y = this.getTreeFontSet().getFontMetricsLarge().getHeight();
                }
                int h = y < 7.0f ? ForesterUtil.roundToInt(y) : 7;
                rds.setRenderingHeight(h > 1 ? (float)h : 2.0f);
                if (this.getControlPanel().isDrawPhylogram()) {
                    if (this.getOptions().isLineUpRendarableNodeData()) {
                        if (this.getOptions().isRightLineUpDomains()) {
                            rds.render((float)(this.getMaxDistanceToRoot() * (double)this.getXcorrectionFactor() + (double)this._length_of_longest_text + (double)((float)(this._longest_domain - rds.getTotalLength()) * rds.getRenderingFactorWidth())), node.getYcoord() - (float)h / 2.0f, g, this, to_pdf);
                        } else {
                            rds.render((float)(this.getMaxDistanceToRoot() * (double)this.getXcorrectionFactor() + (double)this._length_of_longest_text), node.getYcoord() - (float)h / 2.0f, g, this, to_pdf);
                        }
                    } else {
                        rds.render(node.getXcoord() + (float)x, node.getYcoord() - (float)h / 2.0f, g, this, to_pdf);
                    }
                } else if (this.getOptions().isRightLineUpDomains()) {
                    rds.render(this.getPhylogeny().getFirstExternalNode().getXcoord() + (float)this._length_of_longest_text - 20.0f + (float)(this._longest_domain - rds.getTotalLength()) * rds.getRenderingFactorWidth(), node.getYcoord() - (float)h / 2.0f, g, this, to_pdf);
                } else {
                    rds.render(this.getPhylogeny().getFirstExternalNode().getXcoord() + (float)this._length_of_longest_text, node.getYcoord() - (float)h / 2.0f, g, this, to_pdf);
                }
            }
        }
        if (this.getControlPanel().isShowVectorData() && node.getNodeData().getVector() != null && node.getNodeData().getVector().size() > 0 && this.getStatisticsForExpressionValues() != null && (rv = RenderableVector.createInstance(node.getNodeData().getVector(), this.getStatisticsForExpressionValues(), this.getConfiguration())) != null) {
            double domain_add = 0.0;
            if (this.getControlPanel().isShowDomainArchitectures() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null) {
                domain_add = this._domain_structure_width + 10.0;
            }
            if (this.getControlPanel().isDrawPhylogram()) {
                rv.render((float)((double)(node.getXcoord() + (float)x) + domain_add), node.getYcoord() - 3.0f, g, this, to_pdf);
            } else {
                rv.render((float)((double)(this.getPhylogeny().getFirstExternalNode().getXcoord() + (float)this._length_of_longest_text) + domain_add), node.getYcoord() - 3.0f, g, this, to_pdf);
            }
        }
    }

    private final void paintOvRectangle(Graphics2D g) {
        float w_ratio = (float)this.getWidth() / (float)this.getVisibleRect().width;
        float h_ratio = (float)this.getHeight() / (float)this.getVisibleRect().height;
        float x_ratio = (float)this.getWidth() / (float)this.getVisibleRect().x;
        float y_ratio = (float)this.getHeight() / (float)this.getVisibleRect().y;
        float width = this.getOvMaxWidth() / w_ratio;
        float height = this.getOvMaxHeight() / h_ratio;
        float x = (float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() / x_ratio;
        float y = (float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() / y_ratio;
        g.setColor(this.getTreeColorSet().getFoundColor0());
        this.getOvRectangle().setRect(x, y, width, height);
        Stroke s = g.getStroke();
        g.setStroke(STROKE_1);
        if (width < 6.0f && height < 6.0f) {
            this.drawRectFilled(x, y, 6.0, 6.0, g);
            this.getOvVirtualRectangle().setRect(x, y, 6.0, 6.0);
        } else if (width < 6.0f) {
            this.drawRectFilled(x, y, 6.0, height, g);
            this.getOvVirtualRectangle().setRect(x, y, 6.0, height);
        } else if (height < 6.0f) {
            this.drawRectFilled(x, y, width, 6.0, g);
            this.getOvVirtualRectangle().setRect(x, y, width, 6.0);
        } else {
            this.drawRect(x, y, width, height, g);
            if (this.isInOvRect()) {
                this.drawRect(x + 1.0f, y + 1.0f, width - 2.0f, height - 2.0f, g);
            }
            this.getOvVirtualRectangle().setRect(x, y, width, height);
        }
        g.setStroke(s);
    }

    private final void paintPhylogenyLite(Graphics2D g) {
        this._phylogeny.getRoot().setXSecondary((float)((double)(this.getVisibleRect().x + this.getOvXPosition()) + 20.0 / ((double)this.getVisibleRect().width / this.getOvRectangle().getWidth())));
        this._phylogeny.getRoot().setYSecondary(this.getVisibleRect().y + this.getOvYStart());
        Stroke s = g.getStroke();
        g.setStroke(STROKE_05);
        for (PhylogenyNode element : this._nodes_in_preorder) {
            this.paintNodeLite(g, element);
        }
        g.setStroke(s);
        this.paintOvRectangle(g);
    }

    private final void paintRootBranch(Graphics2D g, float x1, float y1, PhylogenyNode root, boolean to_pdf, boolean to_graphics_file) {
        this.assignGraphicsForBranchWithColorForParentBranch(root, false, g, to_pdf, to_graphics_file);
        float d = this.getXdistance();
        if (this.getControlPanel().isDrawPhylogram() && root.getDistanceToParent() > 0.0) {
            d = (float)((double)this.getXcorrectionFactor() * root.getDistanceToParent());
        }
        if (d < 3.0f) {
            d = 3.0f;
        }
        if (!this.getControlPanel().isWidthBranches() || PhylogenyMethods.getBranchWidthValue(root) == 1.0) {
            this.drawLine(x1 - d, root.getYcoord(), x1, root.getYcoord(), g);
        } else {
            double w = PhylogenyMethods.getBranchWidthValue(root);
            this.drawRectFilled(x1 - d, (double)root.getYcoord() - w / 2.0, d, w, g);
        }
        this.paintNodeBox(x1, root.getYcoord(), root, g, to_pdf, to_graphics_file);
    }

    private final void paintScale(Graphics2D g, int x1, int y1, boolean to_pdf, boolean to_graphics_file) {
        double x2 = (double)(x1 += 20) + this.getScaleDistance() * (double)this.getXcorrectionFactor();
        int y2 = (y1 -= 12) - 8;
        int y3 = y1 - 4;
        g.setFont(this.getTreeFontSet().getSmallFont());
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(this.getTreeColorSet().getBranchLengthColor());
        }
        Stroke s = g.getStroke();
        g.setStroke(STROKE_1);
        this.drawLine(x1, y1, x1, y2, g);
        this.drawLine(x2, y1, x2, y2, g);
        this.drawLine(x1, y3, x2, y3, g);
        if (this.getScaleLabel() != null) {
            g.drawString(this.getScaleLabel(), x1 + 2, y3 - 2);
        }
        g.setStroke(s);
    }

    private final int paintTaxonomy(Graphics2D g, PhylogenyNode node, boolean is_in_found_nodes, boolean to_pdf, boolean to_graphics_file, float x_shift) {
        Taxonomy taxonomy = node.getNodeData().getTaxonomy();
        boolean using_visual_font = this.setFont(g, node, is_in_found_nodes);
        this.setColor(g, node, to_graphics_file, to_pdf, is_in_found_nodes, this.getTreeColorSet().getTaxonomyColor());
        float start_x = node.getXcoord() + 3.0f + (float)(this.getOptions().getDefaultNodeShapeSize() / 2) + x_shift;
        float start_y = !using_visual_font ? node.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / (node.getNumberOfDescendants() == 1 ? 1.0f : 3.0f) : node.getYcoord() + (float)this.getFontMetrics(g.getFont()).getAscent() / (node.getNumberOfDescendants() == 1 ? 1.0f : 3.0f);
        this._sb.setLength(0);
        this.nodeTaxonomyDataAsSB(taxonomy, this._sb);
        String label = this._sb.toString();
        if (this._control_panel.isShowSequenceRelations() && label.length() > 0 && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().equals(this._query_sequence)) {
            Rectangle2D nodeTextBounds = new TextLayout(label, g.getFont(), new FontRenderContext(null, false, false)).getBounds();
            g.fillRect((int)start_x - 1, (int)start_y - 8, (int)nodeTextBounds.getWidth() + 4, 11);
            g.setColor(this.getTreeColorSet().getBackgroundColor());
        }
        TreePanel.drawString(label, start_x, start_y, g);
        if (!using_visual_font && !is_in_found_nodes) {
            return this.getFontMetricsForLargeDefaultFont().stringWidth(label);
        }
        return this.getFontMetrics(g.getFont()).stringWidth(label);
    }

    private final void paintUnrooted(PhylogenyNode n, double low_angle, double high_angle, boolean radial_labels, Graphics2D g, boolean to_pdf, boolean to_graphics_file) {
        if (n.isRoot()) {
            n.setXcoord(this.getWidth() / 2);
            n.setYcoord(this.getHeight() / 2);
        }
        if (n.isExternal()) {
            this.paintNodeDataUnrootedCirc(g, n, to_pdf, to_graphics_file, radial_labels, (high_angle + low_angle) / 2.0, this.isInFoundNodes(n) || this.isInCurrentExternalNodes(n));
            return;
        }
        float num_enclosed = n.getNumberOfExternalNodes();
        float x = n.getXcoord();
        float y = n.getYcoord();
        double current_angle = low_angle;
        for (int i = 0; i < n.getNumberOfDescendants(); ++i) {
            PhylogenyNode desc = n.getChildNode(i);
            int desc_num_enclosed = desc.getNumberOfExternalNodes();
            double arc_size = (double)((float)desc_num_enclosed / num_enclosed) * (high_angle - low_angle);
            float length = this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram() ? (desc.getDistanceToParent() < 0.0 ? 0.0f : (float)(desc.getDistanceToParent() * (double)this.getUrtFactor())) : this.getUrtFactor();
            double mid_angle = current_angle + arc_size / 2.0;
            float new_x = (float)((double)x + Math.cos(mid_angle) * (double)length);
            float new_y = (float)((double)y + Math.sin(mid_angle) * (double)length);
            desc.setXcoord(new_x);
            desc.setYcoord(new_y);
            this.paintUnrooted(desc, current_angle, current_angle + arc_size, radial_labels, g, to_pdf, to_graphics_file);
            current_angle += arc_size;
            this.assignGraphicsForBranchWithColorForParentBranch(desc, false, g, to_pdf, to_graphics_file);
            this.drawLine(x, y, new_x, new_y, g);
            this.paintNodeBox(new_x, new_y, desc, g, to_pdf, to_graphics_file);
        }
        if (n.isRoot()) {
            this.paintNodeBox(n.getXcoord(), n.getYcoord(), n, g, to_pdf, to_graphics_file);
        }
    }

    private final void paintUnrootedLite(PhylogenyNode n, double low_angle, double high_angle, Graphics2D g, float urt_ov_factor) {
        if (n.isRoot()) {
            int x_pos = (int)((float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() / 2.0f);
            int y_pos = (int)((float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() / 2.0f);
            n.setXSecondary(x_pos);
            n.setYSecondary(y_pos);
        }
        if (n.isExternal()) {
            return;
        }
        float num_enclosed = n.getNumberOfExternalNodes();
        float x = n.getXSecondary();
        float y = n.getYSecondary();
        double current_angle = low_angle;
        for (int i = 0; i < n.getNumberOfDescendants(); ++i) {
            PhylogenyNode desc = n.getChildNode(i);
            int desc_num_enclosed = desc.getNumberOfExternalNodes();
            double arc_size = (double)((float)desc_num_enclosed / num_enclosed) * (high_angle - low_angle);
            float length = this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram() ? (desc.getDistanceToParent() < 0.0 ? 0.0f : (float)(desc.getDistanceToParent() * (double)urt_ov_factor)) : urt_ov_factor;
            double mid_angle = current_angle + arc_size / 2.0;
            float new_x = (float)((double)x + Math.cos(mid_angle) * (double)length);
            float new_y = (float)((double)y + Math.sin(mid_angle) * (double)length);
            desc.setXSecondary(new_x);
            desc.setYSecondary(new_y);
            if (this.isInFoundNodes(desc) || this.isInCurrentExternalNodes(desc)) {
                g.setColor(this.getColorForFoundNode(desc));
                this.drawRectFilled((double)desc.getXSecondary() - 1.0, (double)desc.getYSecondary() - 1.0, 2.0, 2.0, g);
                g.setColor(this.getTreeColorSet().getOvColor());
            }
            this.paintUnrootedLite(desc, current_angle, current_angle + arc_size, g, urt_ov_factor);
            current_angle += arc_size;
            this.drawLine(x, y, new_x, new_y, g);
        }
    }

    private final void pasteSubtree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (this.getCutOrCopiedTree() == null || this.getCutOrCopiedTree().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No tree in buffer (need to copy or cut a subtree first)", "Attempt to paste with empty buffer", 0);
            return;
        }
        String label = this.createASimpleTextRepresentationOfANode(this.getCutOrCopiedTree().getRoot());
        Object[] options = new Object[]{"As sibling", "As descendant", "Cancel"};
        int r = JOptionPane.showOptionDialog(this, "How to paste subtree" + label + "?", "Paste Subtree", -1, 3, null, options, options[2]);
        boolean paste_as_sibling = true;
        if (r == 1) {
            paste_as_sibling = false;
        } else if (r != 0) {
            return;
        }
        Phylogeny buffer_phy = this.getCutOrCopiedTree().copy();
        buffer_phy.setAllNodesToNotCollapse();
        PhylogenyMethods.preOrderReId(buffer_phy);
        buffer_phy.setRooted(true);
        boolean need_to_show_whole = false;
        if (paste_as_sibling) {
            if (node.isRoot()) {
                JOptionPane.showMessageDialog(this, "Cannot paste sibling to root", "Attempt to paste sibling to root", 0);
                return;
            }
            buffer_phy.addAsSibling(node);
        } else if (node.getNumberOfExternalNodes() == 1 && node.isRoot()) {
            need_to_show_whole = true;
            this._phylogeny = buffer_phy;
        } else {
            buffer_phy.addAsChild(node);
        }
        if (this.getCopiedAndPastedNodes() == null) {
            this.setCopiedAndPastedNodes(new HashSet<Long>());
        }
        List<PhylogenyNode> nodes = PhylogenyMethods.obtainAllNodesAsList(buffer_phy);
        HashSet<Long> node_ids = new HashSet<Long>(nodes.size());
        for (PhylogenyNode n : nodes) {
            node_ids.add(n.getId());
        }
        node_ids.add(node.getId());
        this.getCopiedAndPastedNodes().addAll(node_ids);
        this.setNodeInPreorderToNull();
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        if (need_to_show_whole) {
            this.getControlPanel().showWhole();
        }
        this.repaint();
    }

    private final StringBuffer propertiesToString(PhylogenyNode node) {
        PropertiesMap properties = node.getNodeData().getProperties();
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String ref : properties.getPropertyRefs()) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            Property p = properties.getProperty(ref);
            sb.append(TreePanelUtil.getPartAfterColon(p.getRef()));
            sb.append("=");
            sb.append(p.getValue());
            if (ForesterUtil.isEmpty(p.getUnit())) continue;
            sb.append(TreePanelUtil.getPartAfterColon(p.getUnit()));
        }
        return sb;
    }

    private void setColor(Graphics2D g, PhylogenyNode node, boolean to_graphics_file, boolean to_pdf, boolean is_in_found_nodes, Color default_color) {
        if ((to_pdf || to_graphics_file) && this.getOptions().isPrintBlackAndWhite()) {
            g.setColor(Color.BLACK);
        } else if (is_in_found_nodes) {
            g.setColor(this.getColorForFoundNode(node));
        } else if (this.getControlPanel().isUseVisualStyles() && node.getNodeData().getNodeVisualData() != null && node.getNodeData().getNodeVisualData().getFontColor() != null) {
            g.setColor(node.getNodeData().getNodeVisualData().getFontColor());
        } else if (this.getControlPanel().isColorAccordingToSequence()) {
            g.setColor(this.getSequenceBasedColor(node));
        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
            g.setColor(this.getTaxonomyBasedColor(node));
        } else if (this.getControlPanel().isColorAccordingToAnnotation() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAnnotations() != null && !node.getNodeData().getSequence().getAnnotations().isEmpty()) {
            g.setColor(this.calculateColorForAnnotation(node.getNodeData().getSequence().getAnnotations()));
        } else if (this.getOptions().isColorLabelsSameAsParentBranch() && this.getControlPanel().isUseVisualStyles() && PhylogenyMethods.getBranchColorValue(node) != null) {
            g.setColor(PhylogenyMethods.getBranchColorValue(node));
        } else if (to_pdf) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(default_color);
        }
    }

    private final void setCopiedAndPastedNodes(Set<Long> nodeIds) {
        this.getMainPanel().setCopiedAndPastedNodes(nodeIds);
    }

    private final void setCutOrCopiedTree(Phylogeny cut_or_copied_tree) {
        this.getMainPanel().setCutOrCopiedTree(cut_or_copied_tree);
    }

    private boolean setFont(Graphics2D g, PhylogenyNode node, boolean is_in_found_nodes) {
        Font visual_font = null;
        if (this.getControlPanel().isUseVisualStyles() && node.getNodeData().getNodeVisualData() != null) {
            visual_font = node.getNodeData().getNodeVisualData().getFont();
            g.setFont(visual_font != null ? visual_font : this.getTreeFontSet().getLargeFont());
        } else {
            g.setFont(this.getTreeFontSet().getLargeFont());
        }
        if (is_in_found_nodes) {
            g.setFont(g.getFont().deriveFont(1));
        }
        return visual_font != null;
    }

    private final void setInOv(boolean in_ov) {
        this._in_ov = in_ov;
    }

    private final void setOvMaxHeight(float ov_max_height) {
        this._ov_max_height = ov_max_height;
    }

    private final void setOvMaxWidth(float ov_max_width) {
        this._ov_max_width = ov_max_width;
    }

    private final void setOvXcorrectionFactor(float f) {
        this._ov_x_correction_factor = f;
    }

    private final void setOvXDistance(float ov_x_distance) {
        this._ov_x_distance = ov_x_distance;
    }

    private final void setOvXPosition(int ov_x_position) {
        this._ov_x_position = ov_x_position;
    }

    private final void setOvYDistance(float ov_y_distance) {
        this._ov_y_distance = ov_y_distance;
    }

    private final void setOvYPosition(int ov_y_position) {
        this._ov_y_position = ov_y_position;
    }

    private final void setOvYStart(int ov_y_start) {
        this._ov_y_start = ov_y_start;
    }

    private final void setScaleDistance(double scale_distance) {
        this._scale_distance = scale_distance;
    }

    private final void setScaleLabel(String scale_label) {
        this._scale_label = scale_label;
    }

    private final void setupStroke(Graphics2D g) {
        if ((double)this.getYdistance() < 1.0E-4) {
            g.setStroke(STROKE_0025);
        }
        if ((double)this.getYdistance() < 0.001) {
            g.setStroke(STROKE_005);
        } else if ((double)this.getYdistance() < 0.01) {
            g.setStroke(STROKE_01);
        } else if ((double)this.getYdistance() < 0.5) {
            g.setStroke(STROKE_025);
        } else if (this.getYdistance() < 1.0f) {
            g.setStroke(STROKE_05);
        } else if (this.getYdistance() < 2.0f) {
            g.setStroke(STROKE_075);
        } else if (this.getYdistance() < 20.0f || !this.getConfiguration().isAllowThickStrokes()) {
            g.setStroke(STROKE_1);
        } else {
            g.setStroke(STROKE_2);
        }
    }

    private final void setUpUrtFactor() {
        int d;
        int n = d = this.getVisibleRect().width < this.getVisibleRect().height ? this.getVisibleRect().width : this.getVisibleRect().height;
        if (this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram()) {
            this.setUrtFactor((float)((double)d / (2.0 * this.getMaxDistanceToRoot())));
        } else {
            int max_depth = this._circ_max_depth;
            if (max_depth > 0) {
                this.setUrtFactor(d / (2 * max_depth));
            } else {
                this.setUrtFactor(d / 2);
            }
        }
        this.setUrtFactorOv(this.getUrtFactor());
    }

    private final void setUrtFactor(float urt_factor) {
        this._urt_factor = urt_factor;
    }

    private final void setUrtFactorOv(float urt_factor_ov) {
        this._urt_factor_ov = urt_factor_ov;
    }

    private void showExtDescNodeData(PhylogenyNode node) {
        ArrayList<String> data = new ArrayList<String>();
        List<PhylogenyNode> nodes = node.getAllExternalDescendants();
        if (this.getFoundNodes0() != null || this.getFoundNodes1() != null) {
            for (PhylogenyNode n : this.getFoundNodesAsListOfPhylogenyNodes()) {
                if (nodes.contains(n)) continue;
                nodes.add(n);
            }
        }
        block15: for (PhylogenyNode n : nodes) {
            switch (this.getOptions().getExtDescNodeDataToReturn()) {
                case NODE_NAME: {
                    if (ForesterUtil.isEmpty(n.getName())) continue block15;
                    data.add(n.getName());
                    break;
                }
                case SEQUENCE_NAME: {
                    if (!n.getNodeData().isHasSequence() || ForesterUtil.isEmpty(n.getNodeData().getSequence().getName())) continue block15;
                    data.add(n.getNodeData().getSequence().getName());
                    break;
                }
                case GENE_NAME: {
                    if (!n.getNodeData().isHasSequence() || ForesterUtil.isEmpty(n.getNodeData().getSequence().getGeneName())) continue block15;
                    data.add(n.getNodeData().getSequence().getGeneName());
                    break;
                }
                case SEQUENCE_SYMBOL: {
                    if (!n.getNodeData().isHasSequence() || ForesterUtil.isEmpty(n.getNodeData().getSequence().getSymbol())) continue block15;
                    data.add(n.getNodeData().getSequence().getSymbol());
                    break;
                }
                case SEQUENCE_MOL_SEQ_FASTA: {
                    StringBuilder sb = new StringBuilder();
                    if (!n.getNodeData().isHasSequence() || ForesterUtil.isEmpty(n.getNodeData().getSequence().getMolecularSequence())) continue block15;
                    StringBuilder ann = new StringBuilder();
                    if (!ForesterUtil.isEmpty(n.getName())) {
                        ann.append(n.getName());
                        ann.append("|");
                    }
                    if (!ForesterUtil.isEmpty(n.getNodeData().getSequence().getSymbol())) {
                        ann.append("SYM=");
                        ann.append(n.getNodeData().getSequence().getSymbol());
                        ann.append("|");
                    }
                    if (!ForesterUtil.isEmpty(n.getNodeData().getSequence().getName())) {
                        ann.append("NAME=");
                        ann.append(n.getNodeData().getSequence().getName());
                        ann.append("|");
                    }
                    if (!ForesterUtil.isEmpty(n.getNodeData().getSequence().getGeneName())) {
                        ann.append("GN=");
                        ann.append(n.getNodeData().getSequence().getGeneName());
                        ann.append("|");
                    }
                    if (n.getNodeData().getSequence().getAccession() != null) {
                        ann.append("ACC=");
                        ann.append(n.getNodeData().getSequence().getAccession().asText());
                        ann.append("|");
                    }
                    if (n.getNodeData().isHasTaxonomy()) {
                        if (!ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getTaxonomyCode())) {
                            ann.append("TAXID=");
                            ann.append(n.getNodeData().getTaxonomy().getTaxonomyCode());
                            ann.append("|");
                        }
                        if (!ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) {
                            ann.append("SN=");
                            ann.append(n.getNodeData().getTaxonomy().getScientificName());
                            ann.append("|");
                        }
                    }
                    String ann_str = ann.charAt(ann.length() - 1) == '|' ? ann.substring(0, ann.length() - 1) : ann.toString();
                    sb.append((CharSequence)SequenceWriter.toFasta(ann_str, n.getNodeData().getSequence().getMolecularSequence(), 60));
                    data.add(sb.toString());
                    break;
                }
                case SEQUENCE_ACC: {
                    if (!n.getNodeData().isHasSequence() || n.getNodeData().getSequence().getAccession() == null || ForesterUtil.isEmpty(n.getNodeData().getSequence().getAccession().toString())) continue block15;
                    data.add(n.getNodeData().getSequence().getAccession().toString());
                    break;
                }
                case TAXONOMY_SCIENTIFIC_NAME: {
                    if (!n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) continue block15;
                    data.add(n.getNodeData().getTaxonomy().getScientificName());
                    break;
                }
                case TAXONOMY_CODE: {
                    if (!n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getTaxonomyCode())) continue block15;
                    data.add(n.getNodeData().getTaxonomy().getTaxonomyCode());
                    break;
                }
                case DOMAINS_ALL: 
                case DOMAINS_COLLAPSED_PER_PROTEIN: {
                    if (!n.getNodeData().isHasSequence() || n.getNodeData().getSequence().getDomainArchitecture() == null) continue block15;
                    DomainArchitecture da = n.getNodeData().getSequence().getDomainArchitecture();
                    HashSet<String> s = new HashSet<String>();
                    for (int i = 0; i < da.getDomains().size(); ++i) {
                        String name;
                        ProteinDomain d = da.getDomain(i);
                        if (!(d.getConfidence() <= Math.pow(10.0, this.getDomainStructureEvalueThresholdExp())) || s.contains(name = d.getName())) continue;
                        data.add(name);
                        if (this.getOptions().getExtDescNodeDataToReturn() != NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN) continue;
                        s.add(name);
                    }
                    continue block15;
                }
                case SEQ_ANNOTATIONS: {
                    if (!n.getNodeData().isHasSequence() || !n.getNodeData().isHasSequence() || n.getNodeData().getSequence().getAnnotations() == null) continue block15;
                    SortedSet<Annotation> a = n.getNodeData().getSequence().getAnnotations();
                    for (int i = 0; i < a.size(); ++i) {
                        data.add(n.getNodeData().getSequence().getAnnotation(i).toString());
                    }
                    continue block15;
                }
                case GO_TERM_IDS: {
                    if (!n.getNodeData().isHasSequence() || !n.getNodeData().isHasSequence() || n.getNodeData().getSequence().getAnnotations() == null) continue block15;
                    SortedSet<Annotation> a = n.getNodeData().getSequence().getAnnotations();
                    for (int i = 0; i < a.size(); ++i) {
                        Annotation ann = n.getNodeData().getSequence().getAnnotation(i);
                        String ref = ann.getRef();
                        if (!ref.toUpperCase().startsWith("GO:")) continue;
                        data.add(ref);
                    }
                    continue block15;
                }
                case UNKNOWN: {
                    TreePanelUtil.showExtDescNodeDataUserSelectedHelper(this.getControlPanel(), n, data);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown data element: " + (Object)((Object)this.getOptions().getExtDescNodeDataToReturn()));
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        int size = TreePanelUtil.nodeDataIntoStringBuffer(data, this.getOptions(), sb);
        if (this.getConfiguration().getExtNodeDataReturnOn() == Configuration.EXT_NODE_DATA_RETURN_ON.CONSOLE || this.getConfiguration().getExtNodeDataReturnOn() == Configuration.EXT_NODE_DATA_RETURN_ON.BUFFER_ONLY) {
            if (this.getConfiguration().getExtNodeDataReturnOn() == Configuration.EXT_NODE_DATA_RETURN_ON.CONSOLE) {
                System.out.println(sb);
            }
            if (sb.length() < 1) {
                this.clearCurrentExternalNodesDataBuffer();
            } else {
                this.setCurrentExternalNodesDataBuffer(sb);
            }
        } else if (this.getConfiguration().getExtNodeDataReturnOn() == Configuration.EXT_NODE_DATA_RETURN_ON.WINODW) {
            if (sb.length() < 1) {
                TreePanelUtil.showInformationMessage(this, "No Appropriate Data (" + this.obtainTitleForExtDescNodeData() + ")", "Descendants of selected node do not contain selected data");
                this.clearCurrentExternalNodesDataBuffer();
            } else {
                this.setCurrentExternalNodesDataBuffer(sb);
                String title = this.getFoundNodes0() != null && !this.getFoundNodes0().isEmpty() ? (this.getOptions().getExtDescNodeDataToReturn() == NodeDataField.UNKNOWN ? "Data" : this.obtainTitleForExtDescNodeData()) + " for " + data.size() + " nodes, unique entries: " + size : (this.getOptions().getExtDescNodeDataToReturn() == NodeDataField.UNKNOWN ? "Data" : this.obtainTitleForExtDescNodeData()) + " for " + data.size() + "/" + node.getNumberOfExternalNodes() + " external descendats of node " + node + ", unique entries: " + size;
                String s = sb.toString().trim();
                if (this.getMainPanel().getMainFrame() == null) {
                    ArchaeopteryxE ae = (ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet();
                    ae.showTextFrame(s, title);
                } else {
                    this.getMainPanel().getMainFrame().showTextFrame(s, title);
                }
            }
        }
    }

    private final void showNodeDataPopup(MouseEvent e, PhylogenyNode node) {
        try {
            if (node.getName().length() > 0 || node.getNodeData().isHasTaxonomy() && !TreePanelUtil.isTaxonomyEmpty(node.getNodeData().getTaxonomy()) || node.getNodeData().isHasSequence() && !TreePanelUtil.isSequenceEmpty(node.getNodeData().getSequence()) || node.getNodeData().isHasDate() || node.getNodeData().isHasDistribution() || node.getBranchData().isHasConfidences()) {
                boolean enc_data;
                this._popup_buffer.setLength(0);
                int lines = 0;
                if (node.getName().length() > 0) {
                    lines = (short)(lines + 1);
                    this._popup_buffer.append(node.getName());
                }
                if (node.getNodeData().isHasTaxonomy() && !TreePanelUtil.isTaxonomyEmpty(node.getNodeData().getTaxonomy())) {
                    lines = (short)(lines + 1);
                    enc_data = false;
                    Taxonomy tax = node.getNodeData().getTaxonomy();
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    if (!ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                        this._popup_buffer.append("[");
                        this._popup_buffer.append(tax.getTaxonomyCode());
                        this._popup_buffer.append("]");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(tax.getScientificName())) {
                        if (enc_data) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append(tax.getScientificName());
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(tax.getCommonName())) {
                        if (enc_data) {
                            this._popup_buffer.append(" (");
                        } else {
                            this._popup_buffer.append("(");
                        }
                        this._popup_buffer.append(tax.getCommonName());
                        this._popup_buffer.append(")");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(tax.getAuthority())) {
                        if (enc_data) {
                            this._popup_buffer.append(" (");
                        } else {
                            this._popup_buffer.append("(");
                        }
                        this._popup_buffer.append(tax.getAuthority());
                        this._popup_buffer.append(")");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(tax.getRank())) {
                        if (enc_data) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(tax.getRank());
                        this._popup_buffer.append("]");
                        enc_data = true;
                    }
                    if (tax.getSynonyms().size() > 0) {
                        if (enc_data) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append("[");
                        int counter = 1;
                        for (String syn : tax.getSynonyms()) {
                            if (!ForesterUtil.isEmpty(syn)) {
                                enc_data = true;
                                this._popup_buffer.append(syn);
                                if (counter < tax.getSynonyms().size()) {
                                    this._popup_buffer.append(", ");
                                }
                            }
                            ++counter;
                        }
                        this._popup_buffer.append("]");
                    }
                    if (!enc_data && tax.getIdentifier() != null && !ForesterUtil.isEmpty(tax.getIdentifier().getValue())) {
                        if (!ForesterUtil.isEmpty(tax.getIdentifier().getProvider())) {
                            this._popup_buffer.append("[");
                            this._popup_buffer.append(tax.getIdentifier().getProvider());
                            this._popup_buffer.append("] ");
                        }
                        this._popup_buffer.append(tax.getIdentifier().getValue());
                    }
                }
                if (node.getNodeData().isHasSequence() && !TreePanelUtil.isSequenceEmpty(node.getNodeData().getSequence())) {
                    Sequence seq;
                    lines = (short)(lines + 1);
                    enc_data = false;
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    if ((seq = node.getNodeData().getSequence()).getAccession() != null) {
                        this._popup_buffer.append("[");
                        if (!ForesterUtil.isEmpty(seq.getAccession().getSource())) {
                            this._popup_buffer.append(seq.getAccession().getSource());
                            this._popup_buffer.append(":");
                        }
                        this._popup_buffer.append(seq.getAccession().getValue());
                        this._popup_buffer.append("]");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(seq.getSymbol())) {
                        if (enc_data) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(seq.getSymbol());
                        this._popup_buffer.append("]");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(seq.getGeneName())) {
                        if (enc_data) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(seq.getGeneName());
                        this._popup_buffer.append("]");
                        enc_data = true;
                    }
                    if (!ForesterUtil.isEmpty(seq.getName())) {
                        if (enc_data) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append(seq.getName());
                    }
                }
                if (node.getNodeData().isHasDate()) {
                    lines = (short)(lines + 1);
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(node.getNodeData().getDate().asSimpleText());
                }
                if (node.getNodeData().isHasDistribution()) {
                    lines = (short)(lines + 1);
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(node.getNodeData().getDistribution().asSimpleText());
                }
                if (node.getBranchData().isHasConfidences()) {
                    List<Confidence> confs = node.getBranchData().getConfidences();
                    for (Confidence confidence : confs) {
                        lines = (short)(lines + 1);
                        if (this._popup_buffer.length() > 0) {
                            this._popup_buffer.append("\n");
                        }
                        if (!ForesterUtil.isEmpty(confidence.getType())) {
                            this._popup_buffer.append("[");
                            this._popup_buffer.append(confidence.getType());
                            this._popup_buffer.append("] ");
                        }
                        this._popup_buffer.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(confidence.getValue(), this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
                        if (confidence.getStandardDeviation() == -9999.0) continue;
                        this._popup_buffer.append(" (sd=");
                        this._popup_buffer.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(confidence.getStandardDeviation(), this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
                        this._popup_buffer.append(")");
                    }
                }
                if (node.getNodeData().isHasProperties()) {
                    PropertiesMap properties = node.getNodeData().getProperties();
                    for (String ref : properties.getPropertyRefs()) {
                        this._popup_buffer.append("\n");
                        Property p = properties.getProperty(ref);
                        this._popup_buffer.append(TreePanelUtil.getPartAfterColon(p.getRef()));
                        this._popup_buffer.append("=");
                        this._popup_buffer.append(p.getValue());
                        if (ForesterUtil.isEmpty(p.getUnit())) continue;
                        this._popup_buffer.append(TreePanelUtil.getPartAfterColon(p.getUnit()));
                    }
                }
                if (this._popup_buffer.length() > 0) {
                    if (!this.getConfiguration().isUseNativeUI()) {
                        this._rollover_popup.setBorder(BorderFactory.createLineBorder(this.getTreeColorSet().getBranchColor()));
                        this._rollover_popup.setBackground(this.getTreeColorSet().getBackgroundColor());
                        if (this.isInFoundNodes0(node) && !this.isInFoundNodes1(node)) {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getFoundColor0());
                        } else if (!this.isInFoundNodes0(node) && this.isInFoundNodes1(node)) {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getFoundColor1());
                        } else if (this.isInFoundNodes0(node) && this.isInFoundNodes1(node)) {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getFoundColor0and1());
                        } else {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getSequenceColor());
                        }
                    } else {
                        this._rollover_popup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    }
                    this._rollover_popup.setText(this._popup_buffer.toString());
                    this._node_desc_popup = PopupFactory.getSharedInstance().getPopup(null, this._rollover_popup, e.getLocationOnScreen().x + 10, e.getLocationOnScreen().y - lines * 20);
                    this._node_desc_popup.show();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void showNodeEditFrame(PhylogenyNode n) {
        if (this._node_frame_index < 10) {
            this._node_frames[this._node_frame_index] = new NodeFrame(n, this._phylogeny, this, this._node_frame_index, "");
            ++this._node_frame_index;
        } else {
            JOptionPane.showMessageDialog(this, "too many node windows are open");
        }
    }

    private final void showNodeFrame(PhylogenyNode n) {
        if (this._node_frame_index < 10) {
            this._node_frames[this._node_frame_index] = new NodeFrame(n, this._phylogeny, this, this._node_frame_index);
            ++this._node_frame_index;
        } else {
            JOptionPane.showMessageDialog(this, "too many node windows are open");
        }
    }

    private final void switchDisplaygetPhylogenyGraphicsType() {
        switch (this.getPhylogenyGraphicsType()) {
            case RECTANGULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                break;
            }
            case EURO_STYLE: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                break;
            }
            case ROUNDED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                break;
            }
            case CURVED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                break;
            }
            case TRIANGULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                break;
            }
            case CONVEX: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                break;
            }
            case UNROOTED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                break;
            }
            case CIRCULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                break;
            }
            default: {
                throw new RuntimeException("unkwnown display type: " + (Object)((Object)this.getPhylogenyGraphicsType()));
            }
        }
        if (this.getControlPanel().getDynamicallyHideData() != null) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                this.getControlPanel().getDynamicallyHideData().setEnabled(false);
            } else {
                this.getControlPanel().getDynamicallyHideData().setEnabled(true);
            }
        }
        if (this.isPhyHasBranchLengths() && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this.getControlPanel().setDrawPhylogramEnabled(true);
        } else {
            this.getControlPanel().setDrawPhylogramEnabled(false);
        }
        if (this.getMainPanel().getMainFrame() == null) {
            ((ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet()).setSelectedTypeInTypeMenu(this.getPhylogenyGraphicsType());
        } else {
            this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(this.getPhylogenyGraphicsType());
        }
    }

    final void calcMaxDepth() {
        if (this._phylogeny != null) {
            this._circ_max_depth = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
        }
    }

    final void calcParametersForPainting(int x, int y) {
        if (this._phylogeny != null && !this._phylogeny.isEmpty()) {
            this.initNodeData();
            this.calculateLongestExtNodeInfo();
            if ((double)this.getLongestExtNodeInfo() > (double)x * 0.6 && (float)this.getTreeFontSet().getLargeFont().getSize() > 3.0f) {
                while ((double)this.getLongestExtNodeInfo() > (double)x * 0.7 && this.getTreeFontSet().getLargeFont().getSize() > 2) {
                    this.getMainPanel().getTreeFontSet().decreaseFontSize(this.getConfiguration().getMinBaseFontSize(), true);
                    this.calculateLongestExtNodeInfo();
                }
            } else {
                while ((double)this.getLongestExtNodeInfo() < (double)x * 0.6 && (float)this.getTreeFontSet().getLargeFont().getSize() <= (float)this.getTreeFontSet().getLargeFontMemory().getSize() - 1.0f) {
                    this.getMainPanel().getTreeFontSet().increaseFontSize();
                    this.calculateLongestExtNodeInfo();
                }
            }
            int ext_nodes = this._phylogeny.getRoot().getNumberOfExternalNodes();
            int max_depth = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
            if (ext_nodes == 1 && (ext_nodes = max_depth) < 1) {
                ext_nodes = 1;
            }
            this.updateOvSizes();
            float xdist = 0.0f;
            float ov_xdist = 0.0f;
            if (!this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram()) {
                xdist = (float)((double)(x - this.getLongestExtNodeInfo() - 20) / ((double)ext_nodes + 3.0));
                ov_xdist = (float)((double)this.getOvMaxWidth() / ((double)ext_nodes + 3.0));
            } else {
                xdist = (x - this.getLongestExtNodeInfo() - 20) / (max_depth + 1);
                ov_xdist = this.getOvMaxWidth() / (float)(max_depth + 1);
            }
            float ydist = (float)((double)(y - 20) / ((double)ext_nodes * 2.0));
            if ((double)xdist < 0.0) {
                xdist = 0.0f;
            }
            if ((double)ov_xdist < 0.0) {
                ov_xdist = 0.0f;
            }
            if ((double)ydist < 0.0) {
                ydist = 0.0f;
            }
            this.setXdistance(xdist);
            this.setYdistance(ydist);
            this.setOvXDistance(ov_xdist);
            double height = this._phylogeny.getHeight();
            if (height > 0.0) {
                float corr = (float)((double)((float)(x - 20 - this.getLongestExtNodeInfo()) - this.getXdistance()) / height);
                this.setXcorrectionFactor(corr > 0.0f ? corr : 0.0f);
                float ov_corr = (float)((double)(this.getOvMaxWidth() - this.getOvXDistance()) / height);
                this.setOvXcorrectionFactor(ov_corr > 0.0f ? ov_corr : 0.0f);
            } else {
                this.setXcorrectionFactor(0.0f);
                this.setOvXcorrectionFactor(0.0f);
            }
            this._circ_max_depth = max_depth;
            this.setUpUrtFactor();
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                // empty if block
            }
        }
    }

    final void calculateLongestExtNodeInfo() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        int max_length = ForesterUtil.roundToInt((this.getSize().getWidth() - 20.0) * 0.95);
        if (max_length < 40) {
            max_length = 40;
        }
        int longest = 30;
        int longest_txt = 0;
        this._longest_domain = 0;
        PhylogenyNode longest_txt_node = this._phylogeny.getFirstExternalNode();
        for (PhylogenyNode node : this._phylogeny.getExternalNodes()) {
            int txt;
            int sum = 0;
            if (node.isCollapse()) continue;
            StringBuilder sb = new StringBuilder();
            this.nodeDataAsSB(node, sb);
            if (node.getNodeData().isHasTaxonomy()) {
                this.nodeTaxonomyDataAsSB(node.getNodeData().getTaxonomy(), sb);
            }
            if ((txt = sb.length()) > longest_txt) {
                longest_txt = txt;
                longest_txt_node = node;
            }
            boolean use_vis = false;
            Graphics2D g = (Graphics2D)this.getGraphics();
            if (this.getControlPanel().isUseVisualStyles()) {
                use_vis = this.setFont(g, node, false);
            }
            sum = !use_vis ? this.getFontMetricsForLargeDefaultFont().stringWidth(sb.toString()) : this.getFontMetrics(g.getFont()).stringWidth(sb.toString());
            if (this.getControlPanel().isShowBinaryCharacters() && node.getNodeData().isHasBinaryCharacters()) {
                sum += this.getFontMetricsForLargeDefaultFont().stringWidth(node.getNodeData().getBinaryCharacters().getGainedCharactersAsStringBuffer().toString());
            }
            if (this.getControlPanel().isShowVectorData() && node.getNodeData().getVector() != null && node.getNodeData().getVector().size() > 0) {
                sum = this.getConfiguration() != null ? (sum += this.getConfiguration().getVectorDataWidth() + 10) : (sum += 130);
            }
            if (this.getControlPanel().isShowDomainArchitectures() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null) {
                DomainArchitecture d = node.getNodeData().getSequence().getDomainArchitecture();
                sum = (int)((double)sum + (this._domain_structure_width / ((RenderableDomainArchitecture)d).getOriginalSize().getWidth() * (double)d.getTotalLength() + 10.0));
                if (d.getTotalLength() > this._longest_domain) {
                    this._longest_domain = d.getTotalLength();
                }
            }
            if (this.getControlPanel().isShowMolSequences() && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().isMolecularSequenceAligned() && !ForesterUtil.isEmpty(node.getNodeData().getSequence().getMolecularSequence())) {
                sum += 430;
            }
            if (sum >= max_length) {
                this._longest_ext_node_info = max_length;
            }
            if (sum <= longest) continue;
            longest = sum;
        }
        this._ext_node_with_longest_txt_info = longest_txt_node;
        this._longest_ext_node_info = longest >= max_length ? max_length : longest;
        this._length_of_longest_text = this.calcLengthOfLongestText();
    }

    final void calculateScaleDistance() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        double height = this.getMaxDistanceToRoot();
        if (height > 0.0) {
            if (height <= 0.5) {
                this.setScaleDistance(0.01);
            } else if (height <= 5.0) {
                this.setScaleDistance(0.1);
            } else if (height <= 50.0) {
                this.setScaleDistance(1.0);
            } else if (height <= 500.0) {
                this.setScaleDistance(10.0);
            } else {
                this.setScaleDistance(100.0);
            }
        } else {
            this.setScaleDistance(0.0);
        }
        String scale_label = String.valueOf(this.getScaleDistance());
        if (!ForesterUtil.isEmpty(this._phylogeny.getDistanceUnit())) {
            scale_label = scale_label + " [" + this._phylogeny.getDistanceUnit() + "]";
        }
        this.setScaleLabel(scale_label);
    }

    final Color calculateSequenceBasedColor(Sequence seq) {
        if (ForesterUtil.isEmpty(seq.getName())) {
            return this.getTreeColorSet().getSequenceColor();
        }
        Color c = null;
        String seq_name = seq.getName();
        c = this.getControlPanel().getSequenceColors().get(seq_name);
        if (c == null) {
            c = AptxUtil.calculateColorFromString(seq_name, false);
            this.getControlPanel().getSequenceColors().put(seq_name, c);
        }
        return c;
    }

    final Color calculateTaxonomyBasedColor(Taxonomy tax) {
        if (this.getOptions().isColorByTaxonomicGroup()) {
            if (!ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                Color c;
                boolean ex = false;
                String group = null;
                try {
                    group = TaxonomyUtil.getTaxGroupByTaxCode(tax.getTaxonomyCode());
                }
                catch (Exception e) {
                    ex = true;
                }
                if (!ex && !ForesterUtil.isEmpty(group) && (c = ForesterUtil.obtainColorDependingOnTaxonomyGroup(group)) != null) {
                    return c;
                }
            }
            return this.getTreeColorSet().getTaxonomyColor();
        }
        if (ForesterUtil.isEmpty(tax.getTaxonomyCode()) && ForesterUtil.isEmpty(tax.getScientificName())) {
            return this.getTreeColorSet().getTaxonomyColor();
        }
        Color c = null;
        if (!ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
            c = this.getControlPanel().getSpeciesColors().get(tax.getTaxonomyCode());
        }
        if (c == null && !ForesterUtil.isEmpty(tax.getScientificName())) {
            c = this.getControlPanel().getSpeciesColors().get(tax.getScientificName());
        }
        if (c == null) {
            if (!ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                c = AptxUtil.calculateColorFromString(tax.getTaxonomyCode(), true);
                this.getControlPanel().getSpeciesColors().put(tax.getTaxonomyCode(), c);
            } else {
                c = AptxUtil.calculateColorFromString(tax.getScientificName(), true);
                this.getControlPanel().getSpeciesColors().put(tax.getScientificName(), c);
            }
        }
        return c;
    }

    void checkForVectorProperties(Phylogeny phy) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.getNodeData().getProperties() == null) continue;
            PropertiesMap pm = node.getNodeData().getProperties();
            double[] vector = new double[pm.getProperties().size()];
            int counter = 0;
            for (String ref : pm.getProperties().keySet()) {
                if (!ref.startsWith("vector:index=")) continue;
                Property p = pm.getProperty(ref);
                String value_str = p.getValue();
                String index_str = ref.substring("vector:index=".length(), ref.length());
                double d = -100.0;
                try {
                    d = Double.parseDouble(value_str);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Could not parse \"" + value_str + "\" into a decimal value", "Problem with Vector Data", 0);
                    return;
                }
                int i = -1;
                try {
                    i = Integer.parseInt(index_str);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Could not parse \"" + index_str + "\" into index for vector data", "Problem with Vector Data", 0);
                    return;
                }
                if (i < 0) {
                    JOptionPane.showMessageDialog(this, "Attempt to use negative index for vector data", "Problem with Vector Data", 0);
                    return;
                }
                vector[i] = d;
                ++counter;
                stats.addValue(d);
            }
            ArrayList<Double> vector_l = new ArrayList<Double>(counter);
            for (int i = 0; i < counter; ++i) {
                vector_l.add(vector[i]);
            }
            node.getNodeData().setVector(vector_l);
        }
        if (stats.getN() > 0) {
            this._statistics_for_vector_data = stats;
        }
    }

    void clearCurrentExternalNodesDataBuffer() {
        this.setCurrentExternalNodesDataBuffer(new StringBuilder());
    }

    final void collapse(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot collapse in unrooted display type", "Attempt to collapse in unrooted display", 2);
            return;
        }
        if (!node.isExternal() && !node.isRoot()) {
            boolean collapse = !node.isCollapse();
            TreePanelUtil.collapseSubtree(node, collapse);
            this.updateSetOfCollapsedExternalNodes();
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.calculateLongestExtNodeInfo();
            this.setNodeInPreorderToNull();
            this._control_panel.displayedPhylogenyMightHaveChanged(true);
            this.resetPreferredSize();
            this.updateOvSizes();
            this._main_panel.adjustJScrollPane();
            this.repaint();
        }
    }

    final void collapseSpeciesSpecificSubtrees() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        TreePanelUtil.collapseSpeciesSpecificSubtrees(this._phylogeny);
        this.updateSetOfCollapsedExternalNodes();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.calculateLongestExtNodeInfo();
        this.setNodeInPreorderToNull();
        this.resetPreferredSize();
        this._main_panel.adjustJScrollPane();
        this.setArrowCursor();
        this.repaint();
    }

    final void colorRank(String rank) {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        AptxUtil.removeBranchColors(this._phylogeny);
        int colorizations = TreePanelUtil.colorPhylogenyAccordingToRanks(this._phylogeny, rank, this);
        if (colorizations > 0) {
            this._control_panel.setColorBranches(true);
            if (this._control_panel.getUseVisualStylesCb() != null) {
                this._control_panel.getUseVisualStylesCb().setSelected(true);
            }
            if (this._control_panel.getColorAccSpeciesCb() != null) {
                this._control_panel.getColorAccSpeciesCb().setSelected(false);
            }
            this._options.setColorLabelsSameAsParentBranch(true);
            if (this.getMainPanel().getMainFrame()._color_labels_same_as_parent_branch != null) {
                this.getMainPanel().getMainFrame()._color_labels_same_as_parent_branch.setSelected(true);
            }
            this._control_panel.repaint();
        }
        this.setArrowCursor();
        this.repaint();
        if (colorizations > 0) {
            String msg = "Taxonomy colorization via " + rank + " completed:\n";
            msg = colorizations > 1 ? msg + "colorized " + colorizations + " subtrees" : msg + "colorized one subtree";
            this.setEdited(true);
            JOptionPane.showMessageDialog(this, msg, "Taxonomy Colorization Completed (" + rank + ")", 1);
        } else {
            String msg = "Could not taxonomy colorize any subtree via " + rank + ".\n";
            msg = msg + "Possible solutions (given that suitable taxonomic information is present):\n";
            msg = msg + "select a different rank (e.g. phylum, genus, ...)\n";
            msg = msg + "  and/or\n";
            msg = msg + "execute:\n";
            msg = msg + "1. \"Obtain Detailed Taxonomic Information\" (Tools)\n";
            msg = msg + "2. \"Infer Ancestor Taxonomies\" (Analysis)";
            JOptionPane.showMessageDialog(this, msg, "Taxonomy Colorization Failed", 2);
        }
    }

    final void confColor() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        AptxUtil.removeBranchColors(this._phylogeny);
        TreePanelUtil.colorPhylogenyAccordingToConfidenceValues(this._phylogeny, this);
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getUseVisualStylesCb() != null) {
            this._control_panel.getUseVisualStylesCb().setSelected(true);
        }
        this.setArrowCursor();
        this.repaint();
    }

    final void decreaseDomainStructureEvalueThresholdExp() {
        if (this._domain_structure_e_value_thr_exp > -20) {
            --this._domain_structure_e_value_thr_exp;
        }
    }

    final PhylogenyNode findNode(int x, int y) {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return null;
        }
        int half_box_size_plus_wiggle = this.getOptions().getDefaultNodeShapeSize() / 2 + 2;
        PhylogenyNodeIterator iter = this._phylogeny.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (!this._phylogeny.isRooted() && node.isRoot() && node.getNumberOfDescendants() <= 2 || !(node.getXcoord() - (float)half_box_size_plus_wiggle <= (float)x) || !(node.getXcoord() + (float)half_box_size_plus_wiggle >= (float)x) || !(node.getYcoord() - (float)half_box_size_plus_wiggle <= (float)y) || !(node.getYcoord() + (float)half_box_size_plus_wiggle >= (float)y)) continue;
            return node;
        }
        return null;
    }

    final Configuration getConfiguration() {
        return this._configuration;
    }

    final ControlPanel getControlPanel() {
        return this._control_panel;
    }

    String getCurrentExternalNodesDataBufferAsString() {
        return this._current_external_nodes_data_buffer.toString();
    }

    int getCurrentExternalNodesDataBufferChangeCounter() {
        return this._current_external_nodes_data_buffer_change_counter;
    }

    final int getDomainStructureEvalueThresholdExp() {
        return this._domain_structure_e_value_thr_exp;
    }

    final Set<Long> getFoundNodes0() {
        return this._found_nodes_0;
    }

    final Set<Long> getFoundNodes1() {
        return this._found_nodes_1;
    }

    List<PhylogenyNode> getFoundNodesAsListOfPhylogenyNodes() {
        PhylogenyNode n;
        ArrayList<PhylogenyNode> additional_nodes = new ArrayList<PhylogenyNode>();
        if (this.getFoundNodes0() != null) {
            for (Long id : this.getFoundNodes0()) {
                n = this._phylogeny.getNode(id);
                if (n == null) continue;
                additional_nodes.add(n);
            }
        }
        if (this.getFoundNodes1() != null) {
            for (Long id : this.getFoundNodes1()) {
                if (this.getFoundNodes0() != null && this.getFoundNodes0().contains(id) || (n = this._phylogeny.getNode(id)) == null) continue;
                additional_nodes.add(n);
            }
        }
        return additional_nodes;
    }

    final Color getGraphicsForNodeBoxWithColorForParentBranch(PhylogenyNode node) {
        if (this.getControlPanel().isUseVisualStyles() && PhylogenyMethods.getBranchColorValue(node) != null) {
            return PhylogenyMethods.getBranchColorValue(node);
        }
        return this.getTreeColorSet().getBranchColor();
    }

    final int getLongestExtNodeInfo() {
        return this._longest_ext_node_info;
    }

    final Options getOptions() {
        if (this._options == null) {
            this._options = this.getControlPanel().getOptions();
        }
        return this._options;
    }

    final Rectangle2D getOvRectangle() {
        return this._ov_rectangle;
    }

    final Rectangle getOvVirtualRectangle() {
        return this._ov_virtual_rectangle;
    }

    final Options.PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._graphics_type;
    }

    final Color getSequenceBasedColor(PhylogenyNode node) {
        if (node.getNodeData().isHasSequence()) {
            return this.calculateSequenceBasedColor(node.getNodeData().getSequence());
        }
        return this.getTreeColorSet().getSequenceColor();
    }

    final double getStartingAngle() {
        return this._urt_starting_angle;
    }

    DescriptiveStatistics getStatisticsForExpressionValues() {
        return this._statistics_for_vector_data;
    }

    final Color getTaxonomyBasedColor(PhylogenyNode node) {
        if (node.isExternal() && node.getNodeData().isHasTaxonomy()) {
            return this.calculateTaxonomyBasedColor(node.getNodeData().getTaxonomy());
        }
        return this.getTreeColorSet().getTaxonomyColor();
    }

    final File getTreeFile() {
        return this._treefile;
    }

    final float getXcorrectionFactor() {
        return this._x_correction_factor;
    }

    final float getXdistance() {
        return this._x_distance;
    }

    final float getYdistance() {
        return this._y_distance;
    }

    final void increaseDomainStructureEvalueThresholdExp() {
        if (this._domain_structure_e_value_thr_exp < 3) {
            ++this._domain_structure_e_value_thr_exp;
        }
    }

    final void initNodeData() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        double _max_original_domain_structure_width = 0.0;
        for (PhylogenyNode node : this._phylogeny.getExternalNodes()) {
            double dsw;
            if (!node.getNodeData().isHasSequence() || node.getNodeData().getSequence().getDomainArchitecture() == null) continue;
            RenderableDomainArchitecture rds = null;
            if (!(node.getNodeData().getSequence().getDomainArchitecture() instanceof RenderableDomainArchitecture)) {
                rds = new RenderableDomainArchitecture(node.getNodeData().getSequence().getDomainArchitecture(), node.getName());
                node.getNodeData().getSequence().setDomainArchitecture(rds);
            } else {
                rds = (RenderableDomainArchitecture)node.getNodeData().getSequence().getDomainArchitecture();
            }
            if (!this.getControlPanel().isShowDomainArchitectures() || !((dsw = rds.getOriginalSize().getWidth()) > _max_original_domain_structure_width)) continue;
            _max_original_domain_structure_width = dsw;
        }
        if (this.getControlPanel().isShowDomainArchitectures()) {
            float ds_factor_width = (float)(this._domain_structure_width / _max_original_domain_structure_width);
            for (PhylogenyNode node : this._phylogeny.getExternalNodes()) {
                if (!node.getNodeData().isHasSequence() || node.getNodeData().getSequence().getDomainArchitecture() == null) continue;
                RenderableDomainArchitecture rds = (RenderableDomainArchitecture)node.getNodeData().getSequence().getDomainArchitecture();
                rds.setRenderingFactorWidth(ds_factor_width);
                rds.setParameter(this._domain_structure_e_value_thr_exp);
            }
        }
    }

    final boolean inOv(MouseEvent e) {
        return e.getX() > this.getVisibleRect().x + this.getOvXPosition() + 1 && (float)e.getX() < (float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() - 1.0f && e.getY() > this.getVisibleRect().y + this.getOvYPosition() + 1 && (float)e.getY() < (float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() - 1.0f;
    }

    final boolean inOvRectangle(MouseEvent e) {
        return (double)e.getX() >= this.getOvRectangle().getX() - 1.0 && (double)e.getX() <= this.getOvRectangle().getX() + this.getOvRectangle().getWidth() + 1.0 && (double)e.getY() >= this.getOvRectangle().getY() - 1.0 && (double)e.getY() <= this.getOvRectangle().getY() + this.getOvRectangle().getHeight() + 1.0;
    }

    final boolean isApplet() {
        return this.getMainPanel() instanceof MainPanelApplets;
    }

    final boolean isCanCollapse() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanColorSubtree() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanCopy() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable();
    }

    final boolean isCanCut(PhylogenyNode node) {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable() && !node.isRoot();
    }

    final boolean isCanDelete() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable();
    }

    final boolean isCanPaste() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable() && this.getCutOrCopiedTree() != null && !this.getCutOrCopiedTree().isEmpty();
    }

    final boolean isCanReroot() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this._subtree_index < 1;
    }

    final boolean isCanSubtree(PhylogenyNode node) {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && !node.isExternal() && (!node.isRoot() || this._subtree_index > 0);
    }

    final boolean isCurrentTreeIsSubtree() {
        return this._subtree_index > 0;
    }

    final boolean isEdited() {
        return this._edited;
    }

    final boolean isInOvRect() {
        return this._in_ov_rect;
    }

    final boolean isOvOn() {
        return this._ov_on;
    }

    final boolean isPhyHasBranchLengths() {
        return this._phy_has_branch_lengths;
    }

    final void midpointRoot() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        if (!this._phylogeny.isRerootable()) {
            JOptionPane.showMessageDialog(this, "This is not rerootable", "Not rerootable", 2);
            return;
        }
        this.setNodeInPreorderToNull();
        this.setWaitCursor();
        PhylogenyMethods.midpointRoot(this._phylogeny);
        this.resetNodeIdToDistToLeafMap();
        this.setArrowCursor();
        this.setEdited(true);
        this.repaint();
    }

    final void mouseClicked(MouseEvent e) {
        if (this.getOptions().isShowOverview() && this.isOvOn() && this.isInOv()) {
            double w_ratio = (double)this.getVisibleRect().width / this.getOvRectangle().getWidth();
            double h_ratio = (double)this.getVisibleRect().height / this.getOvRectangle().getHeight();
            double x = ((double)(e.getX() - this.getVisibleRect().x - this.getOvXPosition()) - this.getOvRectangle().getWidth() / 2.0) * w_ratio;
            double y = ((double)(e.getY() - this.getVisibleRect().y - this.getOvYPosition()) - this.getOvRectangle().getHeight() / 2.0) * h_ratio;
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            double max_x = this.getWidth() - this.getVisibleRect().width;
            double max_y = this.getHeight() - this.getVisibleRect().height;
            if (x > max_x) {
                x = max_x;
            }
            if (y > max_y) {
                y = max_y;
            }
            this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(new Point(ForesterUtil.roundToInt(x), ForesterUtil.roundToInt(y)));
            this.setInOvRect(true);
            this.repaint();
        } else {
            PhylogenyNode node = this.findNode(e.getX(), e.getY());
            if (node != null) {
                if (!node.isRoot() && node.getParent().isCollapse()) {
                    return;
                }
                this._highlight_node = node;
                if ((e.getModifiers() & 1) != 0) {
                    if (this.getFoundNodes0() == null) {
                        this.setFoundNodes0(new HashSet<Long>());
                    }
                    this.getFoundNodes0().add(node.getId());
                } else if ((e.getModifiers() & 2) != 0) {
                    this.displayNodePopupMenu(node, e.getX(), e.getY());
                } else if (e.getModifiers() == 4) {
                    this.displayNodePopupMenu(node, e.getX(), e.getY());
                } else {
                    this.handleClickToAction(this._control_panel.getActionWhenNodeClicked(), node);
                }
            } else {
                this._highlight_node = null;
            }
        }
        this.repaint();
    }

    final void mouseDragInBrowserPanel(MouseEvent e) {
        this.setCursor(MOVE_CURSOR);
        Point scroll_position = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
        scroll_position.x = (int)((float)scroll_position.x - ((float)e.getX() - this.getLastDragPointX()));
        scroll_position.y = (int)((float)scroll_position.y - ((float)e.getY() - this.getLastDragPointY()));
        if (scroll_position.x < 0) {
            scroll_position.x = 0;
        } else {
            int max_x = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
            if (scroll_position.x > max_x) {
                scroll_position.x = max_x;
            }
        }
        if (scroll_position.y < 0) {
            scroll_position.y = 0;
        } else {
            int max_y = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
            if (scroll_position.y > max_y) {
                scroll_position.y = max_y;
            }
        }
        if (this.isOvOn() || this.getOptions().isShowScale()) {
            this.repaint();
        }
        this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(scroll_position);
    }

    final void mouseDragInOvRectangle(MouseEvent e) {
        this.setCursor(HAND_CURSOR);
        double w_ratio = (double)this.getVisibleRect().width / this.getOvRectangle().getWidth();
        double h_ratio = (double)this.getVisibleRect().height / this.getOvRectangle().getHeight();
        Point scroll_position = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
        double dx = w_ratio * (double)e.getX() - w_ratio * (double)this.getLastDragPointX();
        double dy = h_ratio * (double)e.getY() - h_ratio * (double)this.getLastDragPointY();
        scroll_position.x = ForesterUtil.roundToInt((double)scroll_position.x + dx);
        scroll_position.y = ForesterUtil.roundToInt((double)scroll_position.y + dy);
        if (scroll_position.x <= 0) {
            scroll_position.x = 0;
            dx = 0.0;
        } else {
            int max_x = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
            if (scroll_position.x >= max_x) {
                dx = 0.0;
                scroll_position.x = max_x;
            }
        }
        if (scroll_position.y <= 0) {
            dy = 0.0;
            scroll_position.y = 0;
        } else {
            int max_y = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
            if (scroll_position.y >= max_y) {
                dy = 0.0;
                scroll_position.y = max_y;
            }
        }
        this.repaint();
        this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(scroll_position);
        this.setLastMouseDragPointX((float)((double)e.getX() + dx));
        this.setLastMouseDragPointY((float)((double)e.getY() + dy));
    }

    final void mouseMoved(MouseEvent e) {
        this.requestFocusInWindow();
        if (this._current_external_nodes != null) {
            this._current_external_nodes = null;
            this.repaint();
        }
        if (this.getControlPanel().isNodeDescPopup() && this._node_desc_popup != null) {
            this._node_desc_popup.hide();
            this._node_desc_popup = null;
        }
        if (this.getOptions().isShowOverview() && this.isOvOn()) {
            if (this.inOvVirtualRectangle(e)) {
                if (!this.isInOvRect()) {
                    this.setInOvRect(true);
                    this.repaint();
                }
            } else if (this.isInOvRect()) {
                this.setInOvRect(false);
                this.repaint();
            }
        }
        if (this.inOv(e) && this.getOptions().isShowOverview() && this.isOvOn()) {
            if (!this.isInOv()) {
                this.setInOv(true);
            }
        } else {
            PhylogenyNode node;
            if (this.isInOv()) {
                this.setInOv(false);
            }
            if ((node = this.findNode(e.getX(), e.getY())) != null && (node.isRoot() || !node.getParent().isCollapse())) {
                if (this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.GET_EXT_DESC_DATA) {
                    for (PhylogenyNode n : node.getAllExternalDescendants()) {
                        this.addToCurrentExternalNodes(n.getId());
                    }
                    this.setCursor(HAND_CURSOR);
                    this.repaint();
                } else if (this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.CUT_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.COPY_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.PASTE_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.DELETE_NODE_OR_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.REROOT || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.ADD_NEW_NODE) {
                    this.setCursor(CUT_CURSOR);
                } else {
                    this.setCursor(HAND_CURSOR);
                    if (this.getControlPanel().isNodeDescPopup()) {
                        this.showNodeDataPopup(e, node);
                    }
                }
            } else {
                this.setCursor(ARROW_CURSOR);
            }
        }
    }

    final void mouseReleasedInBrowserPanel(MouseEvent e) {
        this.setCursor(ARROW_CURSOR);
    }

    final void multiplyUrtFactor(float f) {
        this._urt_factor *= f;
    }

    final JApplet obtainApplet() {
        return ((MainPanelApplets)this.getMainPanel()).getApplet();
    }

    final void paintBranchCircular(PhylogenyNode p, PhylogenyNode c, Graphics2D g, boolean radial_labels, boolean to_pdf, boolean to_graphics_file) {
        double angle = this._urt_nodeid_angle_map.get(c.getId());
        double root_x = this._root.getXcoord();
        double root_y = this._root.getYcoord();
        double dx = root_x - (double)p.getXcoord();
        double dy = root_y - (double)p.getYcoord();
        double parent_radius = Math.sqrt(dx * dx + dy * dy);
        double arc = this._urt_nodeid_angle_map.get(p.getId()) - angle;
        this.assignGraphicsForBranchWithColorForParentBranch(c, false, g, to_pdf, to_graphics_file);
        if ((c.isFirstChildNode() || c.isLastChildNode()) && (Math.abs(parent_radius * arc) > 1.5 || to_pdf || to_graphics_file)) {
            double r2 = 2.0 * parent_radius;
            this.drawArc(root_x - parent_radius, root_y - parent_radius, r2, r2, -angle - arc, arc, g);
        }
        this.drawLine(c.getXcoord(), c.getYcoord(), root_x + Math.cos(angle) * parent_radius, root_y + Math.sin(angle) * parent_radius, g);
        this.paintNodeBox(c.getXcoord(), c.getYcoord(), c, g, to_pdf, to_graphics_file);
        if (c.isExternal()) {
            boolean is_in_found_nodes;
            boolean bl = is_in_found_nodes = this.isInFoundNodes0(c) || this.isInFoundNodes1(c) || this.isInCurrentExternalNodes(c);
            if (this._dynamic_hiding_factor > 1 && !is_in_found_nodes && this._urt_nodeid_index_map.get(c.getId()) % this._dynamic_hiding_factor != 1) {
                return;
            }
            this.paintNodeDataUnrootedCirc(g, c, to_pdf, to_graphics_file, radial_labels, 0.0, is_in_found_nodes);
        }
    }

    final void paintBranchCircularLite(PhylogenyNode p, PhylogenyNode c, Graphics2D g) {
        double angle = this._urt_nodeid_angle_map.get(c.getId());
        double root_x = this._root.getXSecondary();
        double root_y = this._root.getYSecondary();
        double dx = root_x - (double)p.getXSecondary();
        double dy = root_y - (double)p.getYSecondary();
        double arc = this._urt_nodeid_angle_map.get(p.getId()) - angle;
        double parent_radius = Math.sqrt(dx * dx + dy * dy);
        g.setColor(this.getTreeColorSet().getOvColor());
        if ((c.isFirstChildNode() || c.isLastChildNode()) && Math.abs(arc) > 0.02) {
            double r2 = 2.0 * parent_radius;
            this.drawArc(root_x - parent_radius, root_y - parent_radius, r2, r2, -angle - arc, arc, g);
        }
        this.drawLine(c.getXSecondary(), c.getYSecondary(), root_x + Math.cos(angle) * parent_radius, root_y + Math.sin(angle) * parent_radius, g);
        if (this.isInFoundNodes(c) || this.isInCurrentExternalNodes(c)) {
            g.setColor(this.getColorForFoundNode(c));
            this.drawRectFilled((double)c.getXSecondary() - 1.0, (double)c.getYSecondary() - 1.0, 2.0, 2.0, g);
        }
    }

    final void paintCircular(Phylogeny phy, double starting_angle, int center_x, int center_y, int radius, Graphics2D g, boolean to_pdf, boolean to_graphics_file) {
        int circ_num_ext_nodes = phy.getNumberOfExternalNodes() - this._collapsed_external_nodeid_set.size();
        System.out.println("# collapsed external = " + this._collapsed_external_nodeid_set.size());
        this._root = phy.getRoot();
        this._root.setXcoord(center_x);
        this._root.setYcoord(center_y);
        boolean radial_labels = this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL;
        double current_angle = starting_angle;
        int i = 0;
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.isCollapse()) {
                n.setXcoord((float)((double)center_x + (double)radius * Math.cos(current_angle)));
                n.setYcoord((float)((double)center_y + (double)radius * Math.sin(current_angle)));
                this._urt_nodeid_angle_map.put(n.getId(), current_angle);
                this._urt_nodeid_index_map.put(n.getId(), i++);
                current_angle += Math.PI * 2 / (double)circ_num_ext_nodes;
                continue;
            }
            System.out.println("is collapse" + n.getName());
        }
        this.paintCirculars(phy.getRoot(), phy, center_x, center_y, radius, radial_labels, g, to_pdf, to_graphics_file);
        this.paintNodeBox(this._root.getXcoord(), this._root.getYcoord(), this._root, g, to_pdf, to_graphics_file);
    }

    final void paintCircularLite(Phylogeny phy, double starting_angle, int center_x, int center_y, int radius, Graphics2D g) {
        int circ_num_ext_nodes = phy.getNumberOfExternalNodes();
        this._root = phy.getRoot();
        this._root.setXSecondary(center_x);
        this._root.setYSecondary(center_y);
        double current_angle = starting_angle;
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            n.setXSecondary((float)((double)center_x + (double)radius * Math.cos(current_angle)));
            n.setYSecondary((float)((double)center_y + (double)radius * Math.sin(current_angle)));
            this._urt_nodeid_angle_map.put(n.getId(), current_angle);
            current_angle += Math.PI * 2 / (double)circ_num_ext_nodes;
        }
        this.paintCircularsLite(phy.getRoot(), phy, center_x, center_y, radius, g);
    }

    final void paintPhylogeny(Graphics2D g, boolean to_pdf, boolean to_graphics_file, int graphics_file_width, int graphics_file_height, int graphics_file_x, int graphics_file_y) {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        if (this._control_panel.isShowSequenceRelations()) {
            this._query_sequence = this._control_panel.getSelectedQuerySequence();
        }
        if (!to_pdf) {
            Rectangle r = this.getVisibleRect();
            if (!this.getOptions().isBackgroundColorGradient() || this.getOptions().isPrintBlackAndWhite()) {
                g.setColor(this.getTreeColorSet().getBackgroundColor());
                if (!to_graphics_file) {
                    g.fill(r);
                } else {
                    if (this.getOptions().isPrintBlackAndWhite()) {
                        g.setColor(Color.WHITE);
                    }
                    g.fillRect(graphics_file_x, graphics_file_y, graphics_file_width, graphics_file_height);
                }
            } else if (!to_graphics_file) {
                g.setPaint(new GradientPaint(r.x, r.y, this.getTreeColorSet().getBackgroundColor(), r.x, r.y + r.height, this.getTreeColorSet().getBackgroundColorGradientBottom()));
                g.fill(r);
            } else {
                g.setPaint(new GradientPaint(graphics_file_x, graphics_file_y, this.getTreeColorSet().getBackgroundColor(), graphics_file_x, graphics_file_y + graphics_file_height, this.getTreeColorSet().getBackgroundColorGradientBottom()));
                g.fillRect(graphics_file_x, graphics_file_y, graphics_file_width, graphics_file_height);
            }
            this.setupStroke(g);
        } else {
            g.setStroke(new BasicStroke(this.getOptions().getPrintLineWidth()));
        }
        if (this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this._external_node_index = 0;
            if (!this._phylogeny.isRooted()) {
                this._phylogeny.getRoot().setXcoord(20.0f);
            } else if (this._phylogeny.getRoot().getDistanceToParent() > 0.0 && this.getControlPanel().isDrawPhylogram()) {
                this._phylogeny.getRoot().setXcoord((float)(20.0 + this._phylogeny.getRoot().getDistanceToParent() * (double)this.getXcorrectionFactor()));
            } else {
                this._phylogeny.getRoot().setXcoord(20.0f + this.getXdistance());
            }
            this._phylogeny.getRoot().setYcoord(this.getYdistance() * (float)this._phylogeny.getRoot().getNumberOfExternalNodes() + 10.0f);
            int dynamic_hiding_factor = this.calcDynamicHidingFactor();
            if (this.getControlPanel().isDynamicallyHideData()) {
                if (dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            if (this._nodes_in_preorder == null) {
                this._nodes_in_preorder = new PhylogenyNode[this._phylogeny.getNodeCount()];
                int i = 0;
                PhylogenyNodeIterator it = this._phylogeny.iteratorPreorder();
                while (it.hasNext()) {
                    this._nodes_in_preorder[i++] = it.next();
                }
            }
            boolean disallow_shortcutting = dynamic_hiding_factor < 40 || this.getControlPanel().isUseVisualStyles() || this.getOptions().isShowDefaultNodeShapesForMarkedNodes() || this.getFoundNodes0() != null && !this.getFoundNodes0().isEmpty() || this.getFoundNodes1() != null && !this.getFoundNodes1().isEmpty() || this.getCurrentExternalNodes() != null && !this.getCurrentExternalNodes().isEmpty() || to_graphics_file || to_pdf;
            for (PhylogenyNode element : this._nodes_in_preorder) {
                this.paintNodeRectangular(g, element, to_pdf, this.getControlPanel().isDynamicallyHideData() && dynamic_hiding_factor > 1, dynamic_hiding_factor, to_graphics_file, disallow_shortcutting);
            }
            if (this.getOptions().isShowScale() && this.getControlPanel().isDrawPhylogram() && this.getScaleDistance() > 0.0) {
                if (!to_graphics_file && !to_pdf) {
                    this.paintScale(g, this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height, to_pdf, to_graphics_file);
                } else {
                    this.paintScale(g, graphics_file_x, graphics_file_y + graphics_file_height, to_pdf, to_graphics_file);
                }
            }
            if (this.getOptions().isShowOverview() && this.isOvOn() && !to_graphics_file && !to_pdf) {
                this.paintPhylogenyLite(g);
            }
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                this.getControlPanel().setDynamicHidingIsOn(false);
            }
            double angle = this.getStartingAngle();
            boolean radial_labels = this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL;
            this._dynamic_hiding_factor = 0;
            if (this.getControlPanel().isDynamicallyHideData()) {
                this._dynamic_hiding_factor = (int)((double)this.getFontMetricsForLargeDefaultFont().getHeight() * 1.5 * (double)this.getPhylogeny().getNumberOfExternalNodes() / 62.83185307179586);
            }
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                if (this._dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            this.paintUnrooted(this._phylogeny.getRoot(), angle, (float)(angle + Math.PI * 2), radial_labels, g, to_pdf, to_graphics_file);
            if (this.getOptions().isShowScale()) {
                if (!to_graphics_file && !to_pdf) {
                    this.paintScale(g, this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height, to_pdf, to_graphics_file);
                } else {
                    this.paintScale(g, graphics_file_x, graphics_file_y + graphics_file_height, to_pdf, to_graphics_file);
                }
            }
            if (this.getOptions().isShowOverview() && this.isOvOn() && !to_graphics_file && !to_pdf) {
                g.setColor(this.getTreeColorSet().getOvColor());
                this.paintUnrootedLite(this._phylogeny.getRoot(), angle, angle + Math.PI * 2, g, this.getUrtFactorOv() / ((float)this.getVisibleRect().width / this.getOvMaxWidth()));
                this.paintOvRectangle(g);
            }
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            int radius = (int)(Math.min(this.getPreferredSize().getWidth(), this.getPreferredSize().getHeight()) / 2.0 - (double)(20 + this.getLongestExtNodeInfo()));
            int d = radius + 20 + this.getLongestExtNodeInfo();
            this._dynamic_hiding_factor = 0;
            if (this.getControlPanel().isDynamicallyHideData() && radius > 0) {
                this._dynamic_hiding_factor = (int)((double)this.getFontMetricsForLargeDefaultFont().getHeight() * 1.5 * (double)this.getPhylogeny().getNumberOfExternalNodes() / (Math.PI * 2 * (double)radius));
            }
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                if (this._dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            this.paintCircular(this._phylogeny, this.getStartingAngle(), d, d, radius > 0 ? radius : 0, g, to_pdf, to_graphics_file);
            if (this.getOptions().isShowOverview() && this.isOvOn() && !to_graphics_file && !to_pdf) {
                int radius_ov = (int)(this.getOvMaxHeight() < this.getOvMaxWidth() ? this.getOvMaxHeight() / 2.0f : this.getOvMaxWidth() / 2.0f);
                double x_scale = 1.0;
                double y_scale = 1.0;
                int x_pos = this.getVisibleRect().x + this.getOvXPosition();
                int y_pos = this.getVisibleRect().y + this.getOvYPosition();
                if (this.getWidth() > this.getHeight()) {
                    x_scale = (double)this.getHeight() / (double)this.getWidth();
                    x_pos = ForesterUtil.roundToInt((double)x_pos / x_scale);
                } else {
                    y_scale = (double)this.getWidth() / (double)this.getHeight();
                    y_pos = ForesterUtil.roundToInt((double)y_pos / y_scale);
                }
                this._at = g.getTransform();
                g.scale(x_scale, y_scale);
                this.paintCircularLite(this._phylogeny, this.getStartingAngle(), x_pos + radius_ov, y_pos + radius_ov, (int)((double)radius_ov - (double)this.getLongestExtNodeInfo() / ((double)this.getVisibleRect().width / this.getOvRectangle().getWidth())), g);
                g.setTransform(this._at);
                this.paintOvRectangle(g);
            }
        }
    }

    final void recalculateMaxDistanceToRoot() {
        this._max_distance_to_root = PhylogenyMethods.calculateMaxDistanceToRoot(this.getPhylogeny());
    }

    final void removeAllEditNodeJFrames() {
        for (int i = 0; i <= 9; ++i) {
            if (this._node_frames[i] == null) continue;
            this._node_frames[i].dispose();
            this._node_frames[i] = null;
        }
        this._node_frame_index = 0;
    }

    final void removeEditNodeFrame(int i) {
        --this._node_frame_index;
        this._node_frames[i] = null;
        if (i < this._node_frame_index) {
            for (int j = 0; j < this._node_frame_index - 1; ++j) {
                this._node_frames[j] = this._node_frames[j + 1];
            }
            this._node_frames[this._node_frame_index] = null;
        }
    }

    final void reRoot(PhylogenyNode node) {
        if (!this.getPhylogeny().isRerootable()) {
            JOptionPane.showMessageDialog(this, "This is not rerootable", "Not rerootable", 2);
            return;
        }
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot reroot in unrooted display type", "Attempt to reroot tree in unrooted display", 2);
            return;
        }
        this.getPhylogeny().reRoot(node);
        this.getPhylogeny().recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setNodeInPreorderToNull();
        this.resetPreferredSize();
        this.getMainPanel().adjustJScrollPane();
        this.setEdited(true);
        this.repaint();
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this.getControlPanel().showWhole();
        }
    }

    final void resetNodeIdToDistToLeafMap() {
        this._nodeid_dist_to_leaf = new HashMap();
    }

    final void resetPreferredSize() {
        if (this.getPhylogeny() == null || this.getPhylogeny().isEmpty()) {
            return;
        }
        int x = 0;
        int y = 0;
        y = 20 + ForesterUtil.roundToInt(this.getYdistance() * (float)this.getPhylogeny().getRoot().getNumberOfExternalNodes() * 2.0f);
        x = this.getControlPanel().isDrawPhylogram() ? 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt((double)this.getXcorrectionFactor() * this.getPhylogeny().getHeight() + (double)this.getXdistance()) : (!this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram() ? 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt(this.getXdistance() * (float)(this.getPhylogeny().getRoot().getNumberOfExternalNodes() + 2)) : 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt(this.getXdistance() * (float)(PhylogenyMethods.calculateMaxDepth(this.getPhylogeny()) + 1)));
        this.setPreferredSize(new Dimension(x, y));
    }

    final void selectNode(PhylogenyNode node) {
        if (this.getFoundNodes0() != null && this.getFoundNodes0().contains(node.getId())) {
            this.getFoundNodes0().remove(node.getId());
            this.getControlPanel().setSearchFoundCountsOnLabel0(this.getFoundNodes0().size());
            if (this.getFoundNodes0().size() < 1) {
                this.getControlPanel().searchReset0();
            }
        } else {
            this.getControlPanel().getSearchFoundCountsLabel0().setVisible(true);
            this.getControlPanel().getSearchResetButton0().setEnabled(true);
            this.getControlPanel().getSearchResetButton0().setVisible(true);
            if (this.getFoundNodes0() == null) {
                this.setFoundNodes0(new HashSet<Long>());
            }
            this.getFoundNodes0().add(node.getId());
            this.getControlPanel().setSearchFoundCountsOnLabel0(this.getFoundNodes0().size());
        }
    }

    final void setArrowCursor() {
        this.setCursor(ARROW_CURSOR);
        this.repaint();
    }

    final void setControlPanel(ControlPanel atv_control) {
        this._control_panel = atv_control;
    }

    void setCurrentExternalNodesDataBuffer(StringBuilder sb) {
        this.increaseCurrentExternalNodesDataBufferChangeCounter();
        this._current_external_nodes_data_buffer = sb;
    }

    final void setFoundNodes0(Set<Long> found_nodes) {
        this._found_nodes_0 = found_nodes;
    }

    final void setFoundNodes1(Set<Long> found_nodes) {
        this._found_nodes_1 = found_nodes;
    }

    final void setInOvRect(boolean in_ov_rect) {
        this._in_ov_rect = in_ov_rect;
    }

    final void setLargeFonts() {
        this.getTreeFontSet().largeFonts();
    }

    final void setLastMouseDragPointX(float x) {
        this._last_drag_point_x = x;
    }

    final void setLastMouseDragPointY(float y) {
        this._last_drag_point_y = y;
    }

    final void setMediumFonts() {
        this.getTreeFontSet().mediumFonts();
    }

    final void setNodeInPreorderToNull() {
        this._nodes_in_preorder = null;
    }

    final void setOvOn(boolean ov_on) {
        this._ov_on = ov_on;
    }

    final void setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE graphics_type) {
        this._graphics_type = graphics_type;
        this.setTextAntialias();
    }

    final void setSmallFonts() {
        this.getTreeFontSet().smallFonts();
    }

    final void setStartingAngle(double starting_angle) {
        this._urt_starting_angle = starting_angle;
    }

    void setStatisticsForExpressionValues(DescriptiveStatistics statistics_for_expression_values) {
        this._statistics_for_vector_data = statistics_for_expression_values;
    }

    final void setSuperTinyFonts() {
        this.getTreeFontSet().superTinyFonts();
    }

    final void setTextAntialias() {
        if (this._phylogeny != null && !this._phylogeny.isEmpty()) {
            if (this._phylogeny.getNumberOfExternalNodes() <= 2000) {
                this._rendering_hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            } else {
                this._rendering_hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            }
        }
        if (this.getMainPanel().getOptions().isAntialiasScreen()) {
            this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        } else {
            this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    final void setTinyFonts() {
        this.getTreeFontSet().tinyFonts();
    }

    final void setTreeFile(File treefile) {
        this._treefile = treefile;
    }

    final void setXcorrectionFactor(float f) {
        this._x_correction_factor = f;
    }

    final void setXdistance(float x) {
        this._x_distance = x;
    }

    final void setYdistance(float y) {
        this._y_distance = y;
    }

    final void sortDescendants(PhylogenyNode node) {
        if (!node.isExternal()) {
            PhylogenyMethods.DESCENDANT_SORT_PRIORITY pri = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME;
            if (this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCode()) {
                pri = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY;
            } else if (this.getControlPanel().isShowSeqNames() || this.getControlPanel().isShowSeqSymbols() || this.getControlPanel().isShowGeneNames()) {
                pri = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.SEQUENCE;
            }
            PhylogenyMethods.sortNodeDescendents(node, pri);
            this.setNodeInPreorderToNull();
            this._phylogeny.externalNodesHaveChanged();
            this._phylogeny.clearHashIdToNodeMap();
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.setEdited(true);
        }
        this.repaint();
    }

    final void subTree(PhylogenyNode node) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot get a sub/super tree in unrooted display", "Attempt to get sub/super tree in unrooted display", 2);
            return;
        }
        if (node.isExternal()) {
            JOptionPane.showMessageDialog(this, "Cannot get a subtree of a external node", "Attempt to get subtree of external node", 2);
            return;
        }
        if (node.isRoot() && !this.isCurrentTreeIsSubtree()) {
            JOptionPane.showMessageDialog(this, "Cannot get a subtree of the root node", "Attempt to get subtree of root node", 2);
            return;
        }
        this.setNodeInPreorderToNull();
        if (!node.isExternal() && !node.isRoot() && this._subtree_index <= 99) {
            this._sub_phylogenies[this._subtree_index] = this._phylogeny;
            this._sub_phylogenies_temp_roots[this._subtree_index] = node;
            ++this._subtree_index;
            this._phylogeny = TreePanelUtil.subTree(node, this._phylogeny);
            this.updateSubSuperTreeButton();
        } else if (node.isRoot() && this.isCurrentTreeIsSubtree()) {
            this.superTree();
        }
        this._main_panel.getControlPanel().showWhole();
        this.repaint();
    }

    final void superTree() {
        this.setNodeInPreorderToNull();
        PhylogenyNode temp_root = this._sub_phylogenies_temp_roots[this._subtree_index - 1];
        for (PhylogenyNode n : temp_root.getDescendants()) {
            n.setParent(temp_root);
        }
        this._sub_phylogenies[this._subtree_index] = null;
        this._sub_phylogenies_temp_roots[this._subtree_index] = null;
        this._phylogeny = this._sub_phylogenies[--this._subtree_index];
        this.updateSubSuperTreeButton();
    }

    final void swap(PhylogenyNode node) {
        if (node.isExternal() || node.getNumberOfDescendants() < 2) {
            return;
        }
        if (node.getNumberOfDescendants() > 2) {
            JOptionPane.showMessageDialog(this, "Cannot swap descendants of nodes with more than 2 descendants", "Cannot swap descendants", 0);
            return;
        }
        if (!node.isExternal()) {
            node.swapChildren();
            this.setNodeInPreorderToNull();
            this._phylogeny.externalNodesHaveChanged();
            this._phylogeny.clearHashIdToNodeMap();
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.setEdited(true);
        }
        this.repaint();
    }

    final void taxColor() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        TreePanelUtil.colorPhylogenyAccordingToExternalTaxonomy(this._phylogeny, this);
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getUseVisualStylesCb() != null) {
            this._control_panel.getUseVisualStylesCb().setSelected(true);
        }
        this.setEdited(true);
        this.setArrowCursor();
        this.repaint();
    }

    final void updateOvSettings() {
        switch (this.getOptions().getOvPlacement()) {
            case LOWER_LEFT: {
                this.setOvXPosition(10);
                this.setOvYPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().height - 10) - this.getOvMaxHeight()));
                this.setOvYStart(ForesterUtil.roundToInt((float)this.getOvYPosition() + this.getOvMaxHeight() / 2.0f));
                break;
            }
            case LOWER_RIGHT: {
                this.setOvXPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().width - 10) - this.getOvMaxWidth()));
                this.setOvYPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().height - 10) - this.getOvMaxHeight()));
                this.setOvYStart(ForesterUtil.roundToInt((float)this.getOvYPosition() + this.getOvMaxHeight() / 2.0f));
                break;
            }
            case UPPER_RIGHT: {
                this.setOvXPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().width - 10) - this.getOvMaxWidth()));
                this.setOvYPosition(10);
                this.setOvYStart(ForesterUtil.roundToInt(10.0f + this.getOvMaxHeight() / 2.0f));
                break;
            }
            default: {
                this.setOvXPosition(10);
                this.setOvYPosition(10);
                this.setOvYStart(ForesterUtil.roundToInt(10.0f + this.getOvMaxHeight() / 2.0f));
            }
        }
    }

    final void updateOvSizes() {
        if ((double)this.getWidth() > 1.05 * (double)this.getVisibleRect().width || (double)this.getHeight() > 1.05 * (double)this.getVisibleRect().height) {
            this.setOvOn(true);
            float l = this.getLongestExtNodeInfo();
            float w_ratio = this.getOvMaxWidth() / (float)this.getWidth();
            int ext_nodes = this._phylogeny.getRoot().getNumberOfExternalNodes();
            this.setOvYDistance(this.getOvMaxHeight() / (float)(2 * ext_nodes));
            float ov_xdist = 0.0f;
            ov_xdist = !this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram() ? (this.getOvMaxWidth() - l) / (float)ext_nodes : (this.getOvMaxWidth() - (l *= w_ratio)) / (float)PhylogenyMethods.calculateMaxDepth(this._phylogeny);
            float ydist = (float)((double)this.getOvMaxWidth() / ((double)ext_nodes * 2.0));
            if ((double)ov_xdist < 0.0) {
                ov_xdist = 0.0f;
            }
            if ((double)ydist < 0.0) {
                ydist = 0.0f;
            }
            this.setOvXDistance(ov_xdist);
            double height = this._phylogeny.getHeight();
            if (height > 0.0) {
                float ov_corr = (float)((double)(this.getOvMaxWidth() - l - this.getOvXDistance()) / height);
                this.setOvXcorrectionFactor(ov_corr > 0.0f ? ov_corr : 0.0f);
            } else {
                this.setOvXcorrectionFactor(0.0f);
            }
        } else {
            this.setOvOn(false);
        }
    }

    void updateSetOfCollapsedExternalNodes() {
        Phylogeny phy = this.getPhylogeny();
        this._collapsed_external_nodeid_set.clear();
        if (phy != null) {
            PhylogenyNodeIterator it = phy.iteratorExternalForward();
            block0: while (it.hasNext()) {
                PhylogenyNode ext_node;
                PhylogenyNode n = ext_node = it.next();
                while (!n.isRoot()) {
                    if (n.isCollapse()) {
                        this._collapsed_external_nodeid_set.add(ext_node.getId());
                        ext_node.setCollapse(true);
                        continue block0;
                    }
                    n = n.getParent();
                }
            }
        }
    }

    final void updateSubSuperTreeButton() {
        if (this._subtree_index < 1) {
            this.getControlPanel().deactivateButtonToReturnToSuperTree();
        } else {
            this.getControlPanel().activateButtonToReturnToSuperTree(this._subtree_index);
        }
    }

    final void zoomInDomainStructure() {
        if (this._domain_structure_width < 2000.0) {
            this._domain_structure_width *= 1.2;
        }
    }

    final void zoomOutDomainStructure() {
        if (this._domain_structure_width > 20.0) {
            this._domain_structure_width *= 0.8;
        }
    }

    private static final void colorizeNodesHelper(Color c, PhylogenyNode node) {
        if (node.getNodeData().getNodeVisualData() == null) {
            node.getNodeData().setNodeVisualData(new NodeVisualData());
        }
        node.getNodeData().getNodeVisualData().setFontColor(new Color(c.getRed(), c.getGreen(), c.getBlue()));
    }

    private static final void drawString(String str, float x, float y, Graphics2D g) {
        g.drawString(str, x, y);
    }

    private static final boolean plusPressed(int key_code) {
        return key_code == 107 || key_code == 521 || key_code == 61 || key_code == 59 || key_code == 49;
    }

    static {
        POPUP_FONT = new Font(Configuration.getDefaultFontFamilyName(), 0, 12);
        STROKE_0025 = new BasicStroke(0.025f);
        STROKE_005 = new BasicStroke(0.05f);
        STROKE_01 = new BasicStroke(0.1f);
        STROKE_025 = new BasicStroke(0.25f);
        STROKE_05 = new BasicStroke(0.5f);
        STROKE_075 = new BasicStroke(0.75f);
        STROKE_1 = new BasicStroke(1.0f);
        STROKE_2 = new BasicStroke(2.0f);
        SHOW_ONLY_THIS_CONF_TYPE = null;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        FORMATTER_CONFIDENCE = new DecimalFormat("#.###", dfs);
        FORMATTER_BRANCH_LENGTH = new DecimalFormat("#.###", dfs);
    }

    private final class SubtreeColorizationActionListener
    implements ActionListener {
        List<PhylogenyNode> _additional_nodes = null;
        JColorChooser _chooser = null;
        PhylogenyNode _node = null;

        SubtreeColorizationActionListener(JColorChooser chooser, PhylogenyNode node) {
            this._chooser = chooser;
            this._node = node;
        }

        SubtreeColorizationActionListener(JColorChooser chooser, PhylogenyNode node, List<PhylogenyNode> additional_nodes) {
            this._chooser = chooser;
            this._node = node;
            this._additional_nodes = additional_nodes;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color c = this._chooser.getColor();
            if (c != null) {
                TreePanel.this.colorizeSubtree(c, this._node, this._additional_nodes);
            }
        }
    }

    private final class NodeColorizationActionListener
    implements ActionListener {
        List<PhylogenyNode> _additional_nodes = null;
        JColorChooser _chooser = null;
        PhylogenyNode _node = null;

        NodeColorizationActionListener(JColorChooser chooser, PhylogenyNode node) {
            this._chooser = chooser;
            this._node = node;
        }

        NodeColorizationActionListener(JColorChooser chooser, PhylogenyNode node, List<PhylogenyNode> additional_nodes) {
            this._chooser = chooser;
            this._node = node;
            this._additional_nodes = additional_nodes;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color c = this._chooser.getColor();
            if (c != null) {
                TreePanel.this.colorizeNodes(c, this._node, this._additional_nodes);
            }
        }
    }
}

