/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Font;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.util.ForesterUtil;

public final class Options {
    static final double MIN_CONFIDENCE_DEFAULT = 0.0;
    private boolean _abbreviate_scientific_names;
    private boolean _allow_errors_in_distance_to_parent;
    private boolean _antialias_print;
    private boolean _antialias_screen;
    private boolean _background_color_gradient;
    private Font _base_font;
    private CLADOGRAM_TYPE _cladogram_type;
    private boolean _color_by_taxonomic_group;
    private boolean _color_labels_same_as_parent_branch;
    private NodeVisualData.NodeFill _default_node_fill;
    private NodeVisualData.NodeShape _default_node_shape;
    private short _default_node_shape_size;
    private boolean _editable;
    private NodeDataField _ext_desc_data_to_return;
    private boolean _graphics_export_using_actual_size;
    private boolean _graphics_export_visible_only;
    private boolean _internal_number_are_confidence_for_nh_parsing;
    private boolean _inverse_search_result;
    private boolean _match_whole_terms_only;
    private boolean _search_with_regex;
    private double _min_confidence_value;
    private PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE _nh_conversion_support_value_style;
    private boolean _nh_parsing_replace_underscores;
    private NODE_LABEL_DIRECTION _node_label_direction;
    private short _number_of_digits_after_comma_for_branch_length_values;
    private short _number_of_digits_after_comma_for_confidence_values;
    private OVERVIEW_PLACEMENT_TYPE _ov_placement;
    private PHYLOGENY_GRAPHICS_TYPE _phylogeny_graphics_type;
    private boolean _print_black_and_white;
    private float _print_line_width;
    private int _print_size_x;
    private int _print_size_y;
    private boolean _print_using_actual_size;
    private double _scale_bar_length;
    private boolean _search_case_sensitive;
    private boolean _show_annotation_ref_source;
    private boolean _show_confidence_stddev;
    private boolean _show_default_node_shapes_for_marked_nodes;
    private boolean _show_default_node_shapes_external;
    private boolean _show_default_node_shapes_internal;
    private boolean _show_domain_labels;
    private boolean _show_overview;
    private boolean _show_scale;
    private NHXParser.TAXONOMY_EXTRACTION _taxonomy_extraction;
    private boolean _line_up_renderable_node_data;
    private boolean _right_align_domains;

    private Options() {
        this.init();
    }

    public NodeDataField getExtDescNodeDataToReturn() {
        return this._ext_desc_data_to_return;
    }

    public boolean isAllowErrorsInDistanceToParent() {
        return this._allow_errors_in_distance_to_parent;
    }

    public final boolean isLineUpRendarableNodeData() {
        return this._line_up_renderable_node_data;
    }

    public final boolean isRightLineUpDomains() {
        return this._right_align_domains;
    }

    public final boolean isShowAnnotationRefSource() {
        return this._show_annotation_ref_source;
    }

    public final boolean isShowDomainLabels() {
        return this._show_domain_labels;
    }

    public final void setAllowErrorsInDistanceToParent(boolean allow_errors_in_distance_to_parent) {
        this._allow_errors_in_distance_to_parent = allow_errors_in_distance_to_parent;
    }

    public void setBackgroundColorGradient(boolean background_color_gradient) {
        this._background_color_gradient = background_color_gradient;
    }

    public void setColorLabelsSameAsParentBranch(boolean color_labels_same_as_parent_branch) {
        this._color_labels_same_as_parent_branch = color_labels_same_as_parent_branch;
    }

    public void setExtDescNodeDataToReturn(NodeDataField ext_desc_data_to_return) {
        this._ext_desc_data_to_return = ext_desc_data_to_return;
    }

    public final void setLineUpRendarableNodeData(boolean line_up_renderable_node_data) {
        this._line_up_renderable_node_data = line_up_renderable_node_data;
    }

    public final void setRightLineUpDomains(boolean right_align_domains) {
        this._right_align_domains = right_align_domains;
    }

    public final void setShowAnnotationRefSource(boolean show_annotation_ref_source) {
        this._show_annotation_ref_source = show_annotation_ref_source;
    }

    public void setShowDomainLabels(boolean show_domain_labels) {
        this._show_domain_labels = show_domain_labels;
    }

    private final void init() {
        this._default_node_shape = NodeVisualData.NodeShape.CIRCLE;
        this._default_node_fill = NodeVisualData.NodeFill.GRADIENT;
        this._default_node_shape_size = (short)4;
        this._internal_number_are_confidence_for_nh_parsing = false;
        this._show_scale = false;
        this._antialias_screen = true;
        this._antialias_print = true;
        this._graphics_export_visible_only = false;
        this._editable = true;
        this._background_color_gradient = false;
        this._show_default_node_shapes_internal = false;
        this._show_default_node_shapes_external = false;
        this._show_default_node_shapes_for_marked_nodes = false;
        if (AptxUtil.isUsOrCanada()) {
            this._print_size_x = 612;
            this._print_size_y = 792;
        } else {
            this._print_size_x = 595;
            this._print_size_y = 845;
        }
        this._min_confidence_value = 0.0;
        this._print_black_and_white = false;
        this._print_using_actual_size = true;
        this._graphics_export_using_actual_size = true;
        this._phylogeny_graphics_type = PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
        this._base_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 10);
        this._match_whole_terms_only = false;
        this._search_with_regex = false;
        this._search_case_sensitive = false;
        this._print_line_width = 0.5f;
        this._show_overview = true;
        this._ov_placement = OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT;
        this._node_label_direction = NODE_LABEL_DIRECTION.HORIZONTAL;
        this._inverse_search_result = false;
        this._scale_bar_length = 0.0;
        this._number_of_digits_after_comma_for_branch_length_values = (short)3;
        this._number_of_digits_after_comma_for_confidence_values = (short)2;
        this._nh_parsing_replace_underscores = false;
        this._taxonomy_extraction = NHXParser.TAXONOMY_EXTRACTION.NO;
        this._cladogram_type = Constants.CLADOGRAM_TYPE_DEFAULT;
        this._show_domain_labels = true;
        this._show_annotation_ref_source = true;
        this.setAbbreviateScientificTaxonNames(false);
        this._color_labels_same_as_parent_branch = false;
        this._show_confidence_stddev = false;
        this._nh_conversion_support_value_style = PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE;
        this._ext_desc_data_to_return = NodeDataField.UNKNOWN;
        this._line_up_renderable_node_data = true;
        this._right_align_domains = false;
    }

    private final void setNumberOfDigitsAfterCommaForBranchLength(short number_of_digits_after_comma_for_branch_length_values) {
        this._number_of_digits_after_comma_for_branch_length_values = number_of_digits_after_comma_for_branch_length_values;
    }

    private final void setNumberOfDigitsAfterCommaForConfidenceValues(short number_of_digits_after_comma_for_confidence_values) {
        this._number_of_digits_after_comma_for_confidence_values = number_of_digits_after_comma_for_confidence_values;
    }

    final Font getBaseFont() {
        return this._base_font;
    }

    final CLADOGRAM_TYPE getCladogramType() {
        return this._cladogram_type;
    }

    final NodeVisualData.NodeFill getDefaultNodeFill() {
        return this._default_node_fill;
    }

    final NodeVisualData.NodeShape getDefaultNodeShape() {
        return this._default_node_shape;
    }

    final short getDefaultNodeShapeSize() {
        return this._default_node_shape_size;
    }

    final double getMinConfidenceValue() {
        return this._min_confidence_value;
    }

    PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE getNhConversionSupportValueStyle() {
        return this._nh_conversion_support_value_style;
    }

    final NODE_LABEL_DIRECTION getNodeLabelDirection() {
        return this._node_label_direction;
    }

    final short getNumberOfDigitsAfterCommaForBranchLengthValues() {
        return this._number_of_digits_after_comma_for_branch_length_values;
    }

    final short getNumberOfDigitsAfterCommaForConfidenceValues() {
        return this._number_of_digits_after_comma_for_confidence_values;
    }

    final OVERVIEW_PLACEMENT_TYPE getOvPlacement() {
        return this._ov_placement;
    }

    final PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._phylogeny_graphics_type;
    }

    final float getPrintLineWidth() {
        return this._print_line_width;
    }

    final int getPrintSizeX() {
        return this._print_size_x;
    }

    final int getPrintSizeY() {
        return this._print_size_y;
    }

    final double getScaleBarLength() {
        return this._scale_bar_length;
    }

    final NHXParser.TAXONOMY_EXTRACTION getTaxonomyExtraction() {
        return this._taxonomy_extraction;
    }

    final boolean isAbbreviateScientificTaxonNames() {
        return this._abbreviate_scientific_names;
    }

    boolean isAllowMagnificationOfTaxonomyImages() {
        return true;
    }

    final boolean isAntialiasPrint() {
        return this._antialias_print;
    }

    final boolean isAntialiasScreen() {
        return this._antialias_screen;
    }

    final boolean isBackgroundColorGradient() {
        return this._background_color_gradient;
    }

    final boolean isColorByTaxonomicGroup() {
        return this._color_by_taxonomic_group;
    }

    final boolean isColorLabelsSameAsParentBranch() {
        return this._color_labels_same_as_parent_branch;
    }

    final boolean isEditable() {
        return this._editable;
    }

    final boolean isGraphicsExportUsingActualSize() {
        return this._graphics_export_using_actual_size;
    }

    final boolean isGraphicsExportVisibleOnly() {
        return this._graphics_export_visible_only;
    }

    final boolean isInternalNumberAreConfidenceForNhParsing() {
        return this._internal_number_are_confidence_for_nh_parsing;
    }

    final boolean isInverseSearchResult() {
        return this._inverse_search_result;
    }

    final boolean isMatchWholeTermsOnly() {
        return this._match_whole_terms_only;
    }

    final boolean isPrintBlackAndWhite() {
        return this._print_black_and_white;
    }

    final boolean isPrintUsingActualSize() {
        return this._print_using_actual_size;
    }

    final boolean isReplaceUnderscoresInNhParsing() {
        return this._nh_parsing_replace_underscores;
    }

    final boolean isSearchCaseSensitive() {
        return this._search_case_sensitive;
    }

    final boolean isSearchWithRegex() {
        return this._search_with_regex;
    }

    boolean isShowConfidenceStddev() {
        return this._show_confidence_stddev;
    }

    boolean isShowDefaultNodeShapesExternal() {
        return this._show_default_node_shapes_external;
    }

    boolean isShowDefaultNodeShapesForMarkedNodes() {
        return this._show_default_node_shapes_for_marked_nodes;
    }

    boolean isShowDefaultNodeShapesInternal() {
        return this._show_default_node_shapes_internal;
    }

    final boolean isShowOverview() {
        return this._show_overview;
    }

    final boolean isShowScale() {
        return this._show_scale;
    }

    final void setAbbreviateScientificTaxonNames(boolean abbreviate_scientific_names) {
        this._abbreviate_scientific_names = abbreviate_scientific_names;
    }

    final void setAntialiasPrint(boolean antialias_print) {
        this._antialias_print = antialias_print;
    }

    final void setAntialiasScreen(boolean antialias_screen) {
        this._antialias_screen = antialias_screen;
    }

    final void setBaseFont(Font base_font) {
        this._base_font = base_font;
    }

    final void setCladogramType(CLADOGRAM_TYPE cladogram_type) {
        this._cladogram_type = cladogram_type;
    }

    final void setColorByTaxonomicGroup(boolean color_by_taxonomic_group) {
        this._color_by_taxonomic_group = color_by_taxonomic_group;
    }

    final void setDefaultNodeFill(NodeVisualData.NodeFill default_node_fill) {
        this._default_node_fill = default_node_fill;
    }

    final void setDefaultNodeShape(NodeVisualData.NodeShape default_node_shape) {
        this._default_node_shape = default_node_shape;
    }

    final void setDefaultNodeShapeSize(short default_node_shape_size) {
        this._default_node_shape_size = default_node_shape_size;
    }

    final void setEditable(boolean editable) {
        this._editable = editable;
    }

    final void setGraphicsExportUsingActualSize(boolean graphics_export_using_actual_size) {
        this._graphics_export_using_actual_size = graphics_export_using_actual_size;
        if (!graphics_export_using_actual_size) {
            this.setGraphicsExportVisibleOnly(false);
        }
    }

    final void setGraphicsExportVisibleOnly(boolean graphics_export_visible_only) {
        this._graphics_export_visible_only = graphics_export_visible_only;
        if (graphics_export_visible_only) {
            this.setGraphicsExportUsingActualSize(true);
        }
    }

    final void setInternalNumberAreConfidenceForNhParsing(boolean internal_number_are_confidence_for_nh_parsing) {
        this._internal_number_are_confidence_for_nh_parsing = internal_number_are_confidence_for_nh_parsing;
    }

    final void setInverseSearchResult(boolean inverse_search_result) {
        this._inverse_search_result = inverse_search_result;
    }

    final void setMatchWholeTermsOnly(boolean search_whole_words_only) {
        this._match_whole_terms_only = search_whole_words_only;
    }

    final void setMinConfidenceValue(double min_confidence_value) {
        this._min_confidence_value = min_confidence_value;
    }

    void setNhConversionSupportValueStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE nh_conversion_support_value_style) {
        this._nh_conversion_support_value_style = nh_conversion_support_value_style;
    }

    final void setNodeLabelDirection(NODE_LABEL_DIRECTION node_label_direction) {
        this._node_label_direction = node_label_direction;
    }

    final void setOvPlacement(OVERVIEW_PLACEMENT_TYPE ov_placement) {
        this._ov_placement = ov_placement;
    }

    final void setPhylogenyGraphicsType(PHYLOGENY_GRAPHICS_TYPE phylogeny_graphics_type) {
        this._phylogeny_graphics_type = phylogeny_graphics_type;
    }

    final void setPrintBlackAndWhite(boolean print_black_and_white) {
        this._print_black_and_white = print_black_and_white;
    }

    final void setPrintLineWidth(float print_line_width) {
        this._print_line_width = print_line_width;
    }

    final void setPrintSizeX(int print_size_x) {
        this._print_size_x = print_size_x;
    }

    final void setPrintSizeY(int print_size_y) {
        this._print_size_y = print_size_y;
    }

    final void setPrintUsingActualSize(boolean print_using_actual_size) {
        this._print_using_actual_size = print_using_actual_size;
    }

    final void setReplaceUnderscoresInNhParsing(boolean nh_parsing_replace_underscores) {
        this._nh_parsing_replace_underscores = nh_parsing_replace_underscores;
    }

    final void setScaleBarLength(double scale_bar_length) {
        this._scale_bar_length = scale_bar_length;
    }

    final void setSearchCaseSensitive(boolean search_case_sensitive) {
        this._search_case_sensitive = search_case_sensitive;
    }

    final void setSearchWithRegex(boolean search_with_regex) {
        this._search_with_regex = search_with_regex;
    }

    void setShowConfidenceStddev(boolean show_confidence_stddev) {
        this._show_confidence_stddev = show_confidence_stddev;
    }

    void setShowDefaultNodeShapesExternal(boolean show_default_node_shapes_external) {
        this._show_default_node_shapes_external = show_default_node_shapes_external;
    }

    void setShowDefaultNodeShapesForMarkedNodes(boolean show_default_node_shapes_for_marked_nodes) {
        this._show_default_node_shapes_for_marked_nodes = show_default_node_shapes_for_marked_nodes;
    }

    void setShowDefaultNodeShapesInternal(boolean show_default_node_shapes_internal) {
        this._show_default_node_shapes_internal = show_default_node_shapes_internal;
    }

    final void setShowOverview(boolean show_overview) {
        this._show_overview = show_overview;
    }

    final void setShowScale(boolean show_scale) {
        this._show_scale = show_scale;
    }

    final void setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction) {
        this._taxonomy_extraction = taxonomy_extraction;
    }

    public static final Options createInstance(Configuration configuration) {
        Options instance = Options.createDefaultInstance();
        if (configuration != null) {
            instance.setAntialiasScreen(configuration.isAntialiasScreen());
            instance.setShowScale(configuration.isShowScale());
            instance.setShowOverview(configuration.isShowOverview());
            instance.setColorByTaxonomicGroup(configuration.isColorByTaxonomicGroup());
            instance.setCladogramType(configuration.getCladogramType());
            instance.setOvPlacement(configuration.getOvPlacement());
            instance.setPrintLineWidth(configuration.getPrintLineWidth());
            instance.setNodeLabelDirection(configuration.getNodeLabelDirection());
            instance.setBackgroundColorGradient(configuration.isBackgroundColorGradient());
            if (configuration.getNumberOfDigitsAfterCommaForBranchLengthValues() >= 0) {
                instance.setNumberOfDigitsAfterCommaForBranchLength(configuration.getNumberOfDigitsAfterCommaForBranchLengthValues());
            }
            if (configuration.getNumberOfDigitsAfterCommaForConfidenceValues() >= 0) {
                instance.setNumberOfDigitsAfterCommaForConfidenceValues(configuration.getNumberOfDigitsAfterCommaForConfidenceValues());
            }
            instance.setTaxonomyExtraction(configuration.getTaxonomyExtraction());
            instance.setReplaceUnderscoresInNhParsing(configuration.isReplaceUnderscoresInNhParsing());
            instance.setInternalNumberAreConfidenceForNhParsing(configuration.isInternalNumberAreConfidenceForNhParsing());
            instance.setEditable(configuration.isEditable());
            instance.setColorLabelsSameAsParentBranch(configuration.isColorLabelsSameAsParentBranch());
            instance.setShowDomainLabels(configuration.isShowDomainLabels());
            instance.setShowAnnotationRefSource(configuration.isShowAnnotationRefSource());
            instance.setAbbreviateScientificTaxonNames(configuration.isAbbreviateScientificTaxonNames());
            if (configuration.getMinConfidenceValue() != 0.0) {
                instance.setMinConfidenceValue(configuration.getMinConfidenceValue());
            }
            if (configuration.getGraphicsExportX() > 0) {
                instance.setPrintSizeX(configuration.getGraphicsExportX());
            }
            if (configuration.getGraphicsExportY() > 0) {
                instance.setPrintSizeY(configuration.getGraphicsExportY());
            }
            if (configuration.getBaseFontSize() > 0) {
                instance.setBaseFont(instance.getBaseFont().deriveFont((float)configuration.getBaseFontSize()));
            }
            if (!ForesterUtil.isEmpty(configuration.getBaseFontFamilyName())) {
                instance.setBaseFont(new Font(configuration.getBaseFontFamilyName(), 0, instance.getBaseFont().getSize()));
            }
            if (configuration.getPhylogenyGraphicsType() != null) {
                instance.setPhylogenyGraphicsType(configuration.getPhylogenyGraphicsType());
            }
            if (configuration.getDefaultNodeFill() != null) {
                instance.setDefaultNodeFill(configuration.getDefaultNodeFill());
            }
            if (configuration.getDefaultNodeShape() != null) {
                instance.setDefaultNodeShape(configuration.getDefaultNodeShape());
            }
            if (configuration.getDefaultNodeShapeSize() >= 0) {
                instance.setDefaultNodeShapeSize(configuration.getDefaultNodeShapeSize());
            }
            instance.setShowDefaultNodeShapesInternal(configuration.isShowDefaultNodeShapesInternal());
            instance.setShowDefaultNodeShapesExternal(configuration.isShowDefaultNodeShapesExternal());
            instance.setShowDefaultNodeShapesForMarkedNodes(configuration.isShowDefaultNodeShapesForMarkedNodes());
            if (configuration.getExtDescNodeDataToReturn() != null) {
                instance.setExtDescNodeDataToReturn(configuration.getExtDescNodeDataToReturn());
            }
            instance.setRightLineUpDomains(configuration.isRightLineUpDomains());
            instance.setLineUpRendarableNodeData(configuration.isLineUpRendarableNodeData());
            instance.setAllowErrorsInDistanceToParent(false);
        }
        return instance;
    }

    static final Options createDefaultInstance() {
        return new Options();
    }

    static enum OVERVIEW_PLACEMENT_TYPE {
        LOWER_LEFT("lower left"),
        LOWER_RIGHT("lower right"),
        UPPER_LEFT("upper left"),
        UPPER_RIGHT("upper right");

        private final String _name;

        private OVERVIEW_PLACEMENT_TYPE(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public String toTag() {
            return this.toString().replaceAll(" ", "_");
        }
    }

    public static enum PHYLOGENY_GRAPHICS_TYPE {
        CIRCULAR,
        CONVEX,
        CURVED,
        EURO_STYLE,
        RECTANGULAR,
        ROUNDED,
        TRIANGULAR,
        UNROOTED;

    }

    public static enum NODE_LABEL_DIRECTION {
        HORIZONTAL,
        RADIAL;

    }

    public static enum CLADOGRAM_TYPE {
        EXT_NODE_SUM_DEP,
        NON_LINED_UP,
        TOTAL_NODE_SUM_DEP;

    }
}

