/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.analysis.TaxonomyDataManager;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.InferenceManager;
import org.forester.archaeopteryx.tools.PhyloInferenceDialog;
import org.forester.archaeopteryx.tools.PhylogeneticInferenceOptions;
import org.forester.archaeopteryx.tools.PhylogeneticInferrer;
import org.forester.archaeopteryx.tools.SequenceDataRetriver;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.GeneralMsaParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.Msa;
import org.forester.msa.MsaFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;

public final class MainFrameApplication
extends MainFrame {
    private static final int FRAME_X_SIZE = 800;
    private static final int FRAME_Y_SIZE = 800;
    private static final long serialVersionUID = -799735726778865234L;
    private static final boolean PREPROCESS_TREES = false;
    private final JFileChooser _values_filechooser;
    private final JFileChooser _sequences_filechooser;
    private final JFileChooser _open_filechooser;
    private final JFileChooser _msa_filechooser;
    private final JFileChooser _seqs_pi_filechooser;
    private final JFileChooser _open_filechooser_for_species_tree;
    private JMenuItem _collapse_below_threshold;
    private JMenuItem _collapse_below_branch_length;
    private ButtonGroup _radio_group_1;
    private ButtonGroup _radio_group_2;
    double _min_not_collapse = 50.0;
    double _min_not_collapse_bl = 0.001;
    private JMenu _inference_menu;
    private JMenuItem _inference_from_msa_item;
    private JMenuItem _inference_from_seqs_item;
    private PhylogeneticInferenceOptions _phylogenetic_inference_options = null;
    private Msa _msa = null;
    private File _msa_file = null;
    private List<MolecularSequence> _seqs = null;
    private File _seqs_file = null;
    JMenuItem _read_values_jmi;
    JMenuItem _read_seqs_jmi;

    private MainFrameApplication(Phylogeny[] phys, Configuration config) {
        this._configuration = config;
        if (this._configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.setVisible(false);
        this.setOptions(Options.createInstance(this._configuration));
        this._mainpanel = new MainPanel(this._configuration, this);
        this._open_filechooser = null;
        this._open_filechooser_for_species_tree = null;
        this._save_filechooser = null;
        this._writetopdf_filechooser = null;
        this._writetographics_filechooser = null;
        this._msa_filechooser = null;
        this._seqs_pi_filechooser = null;
        this._values_filechooser = null;
        this._sequences_filechooser = null;
        this._jmenubar = new JMenuBar();
        this.buildFileMenu();
        this.buildTypeMenu();
        this._contentpane = this.getContentPane();
        this._contentpane.setLayout(new BorderLayout());
        this._contentpane.add((Component)this._mainpanel, "Center");
        this.setSize(800, 800);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrameApplication.this.exit();
            }
        });
        if (phys != null && phys.length > 0) {
            AptxUtil.addPhylogeniesToTabs(phys, "", null, this._configuration, this._mainpanel);
            this.validate();
            this.getMainPanel().getControlPanel().showWholeAll();
            this.getMainPanel().getControlPanel().showWhole();
        }
        this._contentpane.repaint();
    }

    private MainFrameApplication(Phylogeny[] phys, Configuration config, String title) {
        this(phys, config, title, null);
    }

    private MainFrameApplication(Phylogeny[] phys, Configuration config, String title, File current_dir) {
        this._configuration = config;
        if (this._configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        try {
            boolean synth_exception = false;
            if (this._configuration.isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            AptxUtil.dieWithSystemError("unsupported look and feel: " + e.toString());
        }
        catch (ClassNotFoundException e) {
            AptxUtil.dieWithSystemError("class not found exception: " + e.toString());
        }
        catch (InstantiationException e) {
            AptxUtil.dieWithSystemError("instantiation exception: " + e.toString());
        }
        catch (IllegalAccessException e) {
            AptxUtil.dieWithSystemError("illegal access exception: " + e.toString());
        }
        if (current_dir != null && current_dir.canRead() && current_dir.isDirectory()) {
            this.setCurrentDir(current_dir);
        }
        this.setVisible(false);
        this.setOptions(Options.createInstance(this._configuration));
        this.setInferenceManager(InferenceManager.createInstance(this._configuration));
        this.setPhylogeneticInferenceOptions(PhylogeneticInferenceOptions.createInstance(this._configuration));
        this.setTitle("Archaeopteryx 0.9909 experimental (150513)");
        this._mainpanel = new MainPanel(this._configuration, this);
        this._open_filechooser = new JFileChooser();
        this._open_filechooser.setMultiSelectionEnabled(true);
        this._open_filechooser.addChoosableFileFilter(MainFrame.xmlfilter);
        this._open_filechooser.addChoosableFileFilter(MainFrame.nhxfilter);
        this._open_filechooser.addChoosableFileFilter(MainFrame.nhfilter);
        this._open_filechooser.addChoosableFileFilter(MainFrame.nexusfilter);
        this._open_filechooser.addChoosableFileFilter(MainFrame.tolfilter);
        this._open_filechooser.addChoosableFileFilter(this._open_filechooser.getAcceptAllFileFilter());
        this._open_filechooser.setFileFilter(MainFrame.defaultfilter);
        this._open_filechooser_for_species_tree = new JFileChooser();
        this._open_filechooser_for_species_tree.setMultiSelectionEnabled(false);
        this._open_filechooser_for_species_tree.addChoosableFileFilter(MainFrame.xmlfilter);
        this._open_filechooser_for_species_tree.addChoosableFileFilter(MainFrame.tolfilter);
        this._open_filechooser_for_species_tree.setFileFilter(MainFrame.xmlfilter);
        this._msa_filechooser = new JFileChooser();
        this._msa_filechooser.setName("Read Multiple Sequence Alignment File");
        this._msa_filechooser.setMultiSelectionEnabled(false);
        this._msa_filechooser.addChoosableFileFilter(this._msa_filechooser.getAcceptAllFileFilter());
        this._msa_filechooser.addChoosableFileFilter(MainFrame.msafilter);
        this._seqs_pi_filechooser = new JFileChooser();
        this._seqs_pi_filechooser.setName("Read Sequences File");
        this._seqs_pi_filechooser.setMultiSelectionEnabled(false);
        this._seqs_pi_filechooser.addChoosableFileFilter(this._seqs_pi_filechooser.getAcceptAllFileFilter());
        this._seqs_pi_filechooser.addChoosableFileFilter(MainFrame.seqsfilter);
        this._values_filechooser = new JFileChooser();
        this._values_filechooser.setMultiSelectionEnabled(false);
        this._sequences_filechooser = new JFileChooser();
        this._sequences_filechooser.setMultiSelectionEnabled(false);
        try {
            String home_dir = System.getProperty("user.home");
            this._open_filechooser.setCurrentDirectory(new File(home_dir));
            this._open_filechooser_for_species_tree.setCurrentDirectory(new File(home_dir));
            this._msa_filechooser.setCurrentDirectory(new File(home_dir));
            this._seqs_pi_filechooser.setCurrentDirectory(new File(home_dir));
            this._values_filechooser.setCurrentDirectory(new File(home_dir));
            this._sequences_filechooser.setCurrentDirectory(new File(home_dir));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._jmenubar = new JMenuBar();
        if (!this._configuration.isUseNativeUI()) {
            this._jmenubar.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
        }
        this.buildFileMenu();
        this.buildPhylogeneticInferenceMenu();
        this.buildAnalysisMenu();
        this.buildToolsMenu();
        this.buildViewMenu();
        this.buildFontSizeMenu();
        this.buildOptionsMenu();
        this.buildTypeMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this._jmenubar);
        this._jmenubar.add(this._help_jmenu);
        this._contentpane = this.getContentPane();
        this._contentpane.setLayout(new BorderLayout());
        this._contentpane.add((Component)this._mainpanel, "Center");
        this.setSize(800, 800);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int r;
                if (MainFrameApplication.this.isUnsavedDataPresent() ? (r = JOptionPane.showConfirmDialog(null, "Exit despite potentially unsaved changes?", "Exit?", 0)) != 0 : (r = JOptionPane.showConfirmDialog(null, "Exit Archaeopteryx?", "Exit?", 0)) != 0) {
                    return;
                }
                MainFrameApplication.this.exit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MainFrameApplication.this._mainpanel.getCurrentTreePanel() != null) {
                    MainFrameApplication.this._mainpanel.getCurrentTreePanel().calcParametersForPainting(MainFrameApplication.this._mainpanel.getCurrentTreePanel().getWidth(), MainFrameApplication.this._mainpanel.getCurrentTreePanel().getHeight());
                }
            }
        });
        this.requestFocusInWindow();
        this.setVisible(true);
        if (phys != null && phys.length > 0) {
            AptxUtil.addPhylogeniesToTabs(phys, title, null, this._configuration, this._mainpanel);
            this.validate();
            this.getMainPanel().getControlPanel().showWholeAll();
            this.getMainPanel().getControlPanel().showWhole();
        }
        this.activateSaveAllIfNeeded();
        this._contentpane.repaint();
        System.gc();
    }

    private MainFrameApplication(Phylogeny[] phys, String config_file, String title) {
        this(phys, new Configuration(config_file, false, false, true), title);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            super.actionPerformed(e);
            Object o = e.getSource();
            if (o == this._open_item) {
                this.readPhylogeniesFromFile();
            }
            if (o == this._open_url_item) {
                this.readPhylogeniesFromURL();
            } else if (o == this._new_item) {
                this.newTree();
            } else if (o == this._close_item) {
                this.closeCurrentPane();
            } else if (o == this._load_species_tree_item) {
                this.readSpeciesTreeFromFile();
            } else if (o == this._obtain_detailed_taxonomic_information_jmi) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.obtainDetailedTaxonomicInformation();
            } else if (o == this._obtain_detailed_taxonomic_information_deleting_jmi) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.obtainDetailedTaxonomicInformationDelete();
            } else if (o == this._obtain_seq_information_jmi) {
                this.obtainSequenceInformation();
            } else if (o == this._read_values_jmi) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.addExpressionValuesFromFile();
            } else if (o == this._read_seqs_jmi) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.addSequencesFromFile();
            } else if (o == this._move_node_names_to_tax_sn_jmi) {
                this.moveNodeNamesToTaxSn();
            } else if (o == this._move_node_names_to_seq_names_jmi) {
                this.moveNodeNamesToSeqNames();
            } else if (o == this._extract_tax_code_from_node_names_jmi) {
                this.extractTaxDataFromNodeNames();
            } else if (o == this._internal_number_are_confidence_for_nh_parsing_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._replace_underscores_cbmi) {
                if (this._extract_taxonomy_no_rbmi != null && !this._extract_taxonomy_no_rbmi.isSelected()) {
                    this._extract_taxonomy_no_rbmi.setSelected(true);
                }
                this.updateOptions(this.getOptions());
            } else if (o == this._allow_errors_in_distance_to_parent_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._collapse_below_threshold) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.collapseBelowThreshold();
            } else if (o == this._collapse_below_branch_length) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.collapseBelowBranchLengthThreshold();
            } else if (o == this._extract_taxonomy_pfam_strict_rbmi || o == this._extract_taxonomy_pfam_relaxed_rbmi || o == this._extract_taxonomy_agressive_rbmi) {
                if (this._replace_underscores_cbmi != null) {
                    this._replace_underscores_cbmi.setSelected(false);
                }
                this.updateOptions(this.getOptions());
            } else if (o == this._extract_taxonomy_no_rbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._inference_from_msa_item) {
                this.executePhyleneticInference(false);
            } else if (o == this._inference_from_seqs_item) {
                this.executePhyleneticInference(true);
            }
            this._contentpane.repaint();
        }
        catch (Exception ex) {
            AptxUtil.unexpectedException(ex);
        }
        catch (Error err) {
            AptxUtil.unexpectedError(err);
        }
    }

    public void end() {
        this._mainpanel.terminate();
        this._contentpane.removeAll();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public MainPanel getMainPanel() {
        return this._mainpanel;
    }

    public Msa getMsa() {
        return this._msa;
    }

    public File getMsaFile() {
        return this._msa_file;
    }

    public List<MolecularSequence> getSeqs() {
        return this._seqs;
    }

    public File getSeqsFile() {
        return this._seqs_file;
    }

    public void readMsaFromFile() {
        File my_dir = this.getCurrentDir();
        this._msa_filechooser.setMultiSelectionEnabled(false);
        if (my_dir != null) {
            this._msa_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._msa_filechooser.showOpenDialog(this._contentpane);
        File file = this._msa_filechooser.getSelectedFile();
        this.setCurrentDir(this._msa_filechooser.getCurrentDirectory());
        if (file != null && !file.isDirectory() && result == 0) {
            this.setMsaFile(null);
            this.setMsa(null);
            Msa msa = null;
            try {
                FileInputStream is = new FileInputStream(file);
                msa = FastaParser.isLikelyFasta(file) ? FastaParser.parseMsa(is) : GeneralMsaParser.parse(is);
            }
            catch (MsaFormatException e) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Multiple sequence alignment format error", 0);
                return;
            }
            catch (IOException e) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Failed to read multiple sequence alignment", 0);
                return;
            }
            catch (IllegalArgumentException e) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Unexpected error during reading of multiple sequence alignment", 0);
                return;
            }
            catch (Exception e) {
                this.setArrowCursor();
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Unexpected error during reading of multiple sequence alignment", 0);
                return;
            }
            if (msa == null || msa.getNumberOfSequences() < 1) {
                JOptionPane.showMessageDialog(this, "Multiple sequence alignment is empty", "Illegal Multiple Sequence Alignment", 0);
                return;
            }
            if (msa.getNumberOfSequences() < 4) {
                JOptionPane.showMessageDialog(this, "Multiple sequence alignment needs to contain at least 3 sequences", "Illegal multiple sequence alignment", 0);
                return;
            }
            if (msa.getLength() < 2) {
                JOptionPane.showMessageDialog(this, "Multiple sequence alignment needs to contain at least 2 residues", "Illegal multiple sequence alignment", 0);
                return;
            }
            System.gc();
            this.setMsaFile(this._msa_filechooser.getSelectedFile());
            this.setMsa(msa);
        }
    }

    public void readSeqsFromFileforPI() {
        File my_dir = this.getCurrentDir();
        this._seqs_pi_filechooser.setMultiSelectionEnabled(false);
        if (my_dir != null) {
            this._seqs_pi_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._seqs_pi_filechooser.showOpenDialog(this._contentpane);
        File file = this._seqs_pi_filechooser.getSelectedFile();
        this.setCurrentDir(this._seqs_pi_filechooser.getCurrentDirectory());
        if (file != null && !file.isDirectory() && result == 0) {
            this.setSeqsFile(null);
            this.setSeqs(null);
            List<MolecularSequence> seqs = null;
            try {
                if (FastaParser.isLikelyFasta(new FileInputStream(file))) {
                    seqs = FastaParser.parse(new FileInputStream(file));
                    for (MolecularSequence seq : seqs) {
                        System.out.println(SequenceWriter.toFasta(seq, 60));
                    }
                }
            }
            catch (MsaFormatException e) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Multiple sequence file format error", 0);
                return;
            }
            catch (IOException e) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Failed to read multiple sequence file", 0);
                return;
            }
            catch (IllegalArgumentException e) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Unexpected error during reading of multiple sequence file", 0);
                return;
            }
            catch (Exception e) {
                this.setArrowCursor();
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Unexpected error during reading of multiple sequence file", 0);
                return;
            }
            if (seqs == null || seqs.size() < 1) {
                JOptionPane.showMessageDialog(this, "Multiple sequence file is empty", "Illegal multiple sequence file", 0);
                return;
            }
            if (seqs.size() < 4) {
                JOptionPane.showMessageDialog(this, "Multiple sequence file needs to contain at least 3 sequences", "Illegal multiple sequence file", 0);
                return;
            }
            System.gc();
            this.setSeqsFile(this._seqs_pi_filechooser.getSelectedFile());
            this.setSeqs(seqs);
        }
    }

    private void addExpressionValuesFromFile() {
        if (this.getCurrentTreePanel() == null || this.getCurrentTreePanel().getPhylogeny() == null) {
            JOptionPane.showMessageDialog(this, "Need to load evolutionary tree first", "Can Not Read Expression Values", 2);
            return;
        }
        File my_dir = this.getCurrentDir();
        if (my_dir != null) {
            this._values_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._values_filechooser.showOpenDialog(this._contentpane);
        File file = this._values_filechooser.getSelectedFile();
        if (file != null && file.length() > 0L && result == 0) {
            BasicTable<String> t = null;
            try {
                t = BasicTableParser.parse(file, '\t');
                if (t.getNumberOfColumns() < 2) {
                    t = BasicTableParser.parse(file, ',');
                }
                if (t.getNumberOfColumns() < 2) {
                    t = BasicTableParser.parse(file, ' ');
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Could Not Read Expression Value Table", 0);
                return;
            }
            if (t.getNumberOfColumns() < 2) {
                JOptionPane.showMessageDialog(this, "Table contains " + t.getNumberOfColumns() + " column(s)", "Problem with Expression Value Table", 0);
                return;
            }
            if (t.getNumberOfRows() < 1) {
                JOptionPane.showMessageDialog(this, "Table contains zero rows", "Problem with Expression Value Table", 0);
                return;
            }
            Phylogeny phy = this.getCurrentTreePanel().getPhylogeny();
            if (t.getNumberOfRows() != phy.getNumberOfExternalNodes()) {
                JOptionPane.showMessageDialog(this, "Table contains " + t.getNumberOfRows() + " rows, but tree contains " + phy.getNumberOfExternalNodes() + " external nodes", "Warning", 2);
            }
            BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
            int not_found = 0;
            PhylogenyNodeIterator iter = phy.iteratorPreorder();
            while (iter.hasNext()) {
                PhylogenyNode node = iter.next();
                String node_name = node.getName();
                if (ForesterUtil.isEmpty(node_name)) continue;
                int row = -1;
                try {
                    row = t.findRow(node_name);
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error Mapping Node Identifiers to Expression Value Identifiers", 0);
                    return;
                }
                if (row < 0) {
                    if (!node.isExternal()) continue;
                    ++not_found;
                    continue;
                }
                ArrayList<Double> l = new ArrayList<Double>();
                for (int col = 1; col < t.getNumberOfColumns(); ++col) {
                    double d = -100.0;
                    try {
                        d = Double.parseDouble(t.getValueAsString(col, row));
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(this, "Could not parse \"" + t.getValueAsString(col, row) + "\" into a decimal value", "Issue with Expression Value Table", 0);
                        return;
                    }
                    stats.addValue(d);
                    l.add(d);
                }
                if (l.isEmpty()) continue;
                if (node.getNodeData().getProperties() != null) {
                    node.getNodeData().getProperties().removePropertiesWithGivenReferencePrefix("vector:index=");
                }
                node.getNodeData().setVector(l);
            }
            if (not_found > 0) {
                JOptionPane.showMessageDialog(this, "Could not fine expression values for " + not_found + " external node(s)", "Warning", 2);
            }
            this.getCurrentTreePanel().setStatisticsForExpressionValues(stats);
        }
    }

    private void addSequencesFromFile() {
        if (this.getCurrentTreePanel() == null || this.getCurrentTreePanel().getPhylogeny() == null) {
            JOptionPane.showMessageDialog(this, "Need to load evolutionary tree first", "Can Not Read Sequences", 2);
            return;
        }
        File my_dir = this.getCurrentDir();
        if (my_dir != null) {
            this._sequences_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._sequences_filechooser.showOpenDialog(this._contentpane);
        File file = this._sequences_filechooser.getSelectedFile();
        List<MolecularSequence> seqs = null;
        if (file != null && !file.isDirectory() && result == 0) {
            try {
                if (!FastaParser.isLikelyFasta(new FileInputStream(file))) {
                    JOptionPane.showMessageDialog(this, "Format does not appear to be Fasta", "Multiple sequence file format error", 0);
                    return;
                }
                seqs = FastaParser.parse(new FileInputStream(file));
            }
            catch (MsaFormatException e) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Multiple sequence file format error", 0);
                return;
            }
            catch (IOException e) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Failed to read multiple sequence file", 0);
                return;
            }
            catch (Exception e) {
                this.setArrowCursor();
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Unexpected error during reading of multiple sequence file", 0);
                return;
            }
            if (seqs == null || seqs.size() < 1) {
                JOptionPane.showMessageDialog(this, "Multiple sequence file is empty", "Empty multiple sequence file", 0);
                this.setArrowCursor();
                return;
            }
        }
        if (seqs != null) {
            for (MolecularSequence seq : seqs) {
                System.out.println(seq.getIdentifier());
            }
            Phylogeny phy = this.getCurrentTreePanel().getPhylogeny();
            int total_counter = 0;
            int attached_counter = 0;
            for (MolecularSequence seq : seqs) {
                ++total_counter;
                String seq_name = seq.getIdentifier();
                if (ForesterUtil.isEmpty(seq_name)) continue;
                List<PhylogenyNode> nodes = phy.getNodesViaSequenceName(seq_name);
                if (nodes.isEmpty()) {
                    nodes = phy.getNodesViaSequenceSymbol(seq_name);
                }
                if (nodes.isEmpty()) {
                    nodes = phy.getNodesViaGeneName(seq_name);
                }
                if (nodes.isEmpty()) {
                    nodes = phy.getNodes(seq_name);
                }
                if (nodes.size() > 1) {
                    JOptionPane.showMessageDialog(this, "Sequence name \"" + seq_name + "\" is not unique", "Sequence name not unique", 0);
                    this.setArrowCursor();
                    return;
                }
                String[] a = seq_name.split("\\s");
                if (nodes.isEmpty() && a.length > 1) {
                    String seq_name_split = a[0];
                    nodes = phy.getNodesViaSequenceName(seq_name_split);
                    if (nodes.isEmpty()) {
                        nodes = phy.getNodesViaSequenceSymbol(seq_name_split);
                    }
                    if (nodes.isEmpty()) {
                        nodes = phy.getNodes(seq_name_split);
                    }
                    if (nodes.size() > 1) {
                        JOptionPane.showMessageDialog(this, "Split sequence name \"" + seq_name_split + "\" is not unique", "Sequence name not unique", 0);
                        this.setArrowCursor();
                        return;
                    }
                }
                if (nodes.size() != 1) continue;
                ++attached_counter;
                PhylogenyNode n = nodes.get(0);
                if (!n.getNodeData().isHasSequence()) {
                    n.getNodeData().addSequence(new Sequence());
                }
                n.getNodeData().getSequence().setMolecularSequence(seq.getMolecularSequenceAsString());
                if (!ForesterUtil.isEmpty(n.getNodeData().getSequence().getName())) continue;
                n.getNodeData().getSequence().setName(seq_name);
            }
            if (attached_counter > 0) {
                int ext_nodes = 0;
                int ext_nodes_with_seq = 0;
                PhylogenyNodeIterator iter = phy.iteratorExternalForward();
                while (iter.hasNext()) {
                    ++ext_nodes;
                    PhylogenyNode n = iter.next();
                    if (!n.getNodeData().isHasSequence() || ForesterUtil.isEmpty(n.getNodeData().getSequence().getMolecularSequence())) continue;
                    ++ext_nodes_with_seq;
                }
                String s = ext_nodes == ext_nodes_with_seq ? "All " + ext_nodes_with_seq + " external nodes now have a molecular sequence attached to them." : ext_nodes_with_seq + " out of " + ext_nodes + " external nodes now have a molecular sequence attached to them.";
                if (attached_counter == total_counter && ext_nodes == ext_nodes_with_seq) {
                    JOptionPane.showMessageDialog(this, "Attached all " + total_counter + " sequences to tree nodes.\n" + s, "All sequences attached", 1);
                } else {
                    JOptionPane.showMessageDialog(this, "Attached " + attached_counter + " sequences out of a total of " + total_counter + " sequences.\n" + s, attached_counter + " sequences attached", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "No maching tree node for any of the " + total_counter + " sequences", "Could not attach any sequences", 0);
            }
        }
    }

    private void closeCurrentPane() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            int r;
            if (this.getMainPanel().getCurrentTreePanel().isEdited() && (r = JOptionPane.showConfirmDialog(this, "Close tab despite potentially unsaved changes?", "Close Tab?", 0)) != 0) {
                return;
            }
            this.getMainPanel().closeCurrentPane();
            this.activateSaveAllIfNeeded();
        }
    }

    private void collapse(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        ArrayList<PhylogenyNode> to_be_removed = new ArrayList<PhylogenyNode>();
        double min_support = Double.MAX_VALUE;
        boolean conf_present = false;
        while (it.hasNext()) {
            List<Confidence> c;
            PhylogenyNode n = it.next();
            if (n.isExternal() || n.isRoot() || (c = n.getBranchData().getConfidences()) == null || c.size() <= 0) continue;
            conf_present = true;
            double max = 0.0;
            for (Confidence confidence : c) {
                if (!(confidence.getValue() > max)) continue;
                max = confidence.getValue();
            }
            if (max < this.getMinNotCollapseConfidenceValue()) {
                to_be_removed.add(n);
            }
            if (!(max < min_support)) continue;
            min_support = max;
        }
        if (conf_present) {
            for (PhylogenyNode node : to_be_removed) {
                PhylogenyMethods.removeNode(node, phy);
            }
            if (to_be_removed.size() > 0) {
                phy.externalNodesHaveChanged();
                phy.clearHashIdToNodeMap();
                phy.recalculateNumberOfExternalDescendants(true);
                this.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
                this.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
                this.getCurrentTreePanel().calculateLongestExtNodeInfo();
                this.getCurrentTreePanel().setNodeInPreorderToNull();
                this.getCurrentTreePanel().recalculateMaxDistanceToRoot();
                this.getCurrentTreePanel().resetPreferredSize();
                this.getCurrentTreePanel().setEdited(true);
                this.getCurrentTreePanel().repaint();
                this.repaint();
            }
            if (to_be_removed.size() > 0) {
                JOptionPane.showMessageDialog(this, "Collapsed " + to_be_removed.size() + " branches with\nconfidence values below " + this.getMinNotCollapseConfidenceValue(), "Collapsed " + to_be_removed.size() + " branches", 1);
            } else {
                JOptionPane.showMessageDialog(this, "No branch collapsed,\nminimum confidence value per branch is " + min_support, "No branch collapsed", 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No branch collapsed because no confidence values present", "No confidence values present", 1);
        }
    }

    private void collapseBelowBranchLengthThreshold() {
        String s;
        Phylogeny phy;
        if (this.getCurrentTreePanel() != null && (phy = this.getCurrentTreePanel().getPhylogeny()) != null && !phy.isEmpty() && !ForesterUtil.isEmpty(s = (String)JOptionPane.showInputDialog(this, "Please enter the minimum branch length value\n", "Minimal Branch Length Value", 3, null, null, this.getMinNotCollapseBlValue()))) {
            boolean success = true;
            double m = 0.0;
            String m_str = s.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    m = Double.parseDouble(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && m >= 0.0) {
                this.setMinNotCollapseBlValue(m);
                this.collapseBl(phy);
            }
        }
    }

    private void collapseBelowThreshold() {
        String s;
        Phylogeny phy;
        if (this.getCurrentTreePanel() != null && (phy = this.getCurrentTreePanel().getPhylogeny()) != null && !phy.isEmpty() && !ForesterUtil.isEmpty(s = (String)JOptionPane.showInputDialog(this, "Please enter the minimum confidence value\n", "Minimal Confidence Value", 3, null, null, this.getMinNotCollapseConfidenceValue()))) {
            boolean success = true;
            double m = 0.0;
            String m_str = s.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    m = Double.parseDouble(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && m >= 0.0) {
                this.setMinNotCollapseConfidenceValue(m);
                this.collapse(phy);
            }
        }
    }

    private void collapseBl(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        ArrayList<PhylogenyNode> to_be_removed = new ArrayList<PhylogenyNode>();
        double min_bl = Double.MAX_VALUE;
        boolean bl_present = false;
        while (it.hasNext()) {
            double bl;
            PhylogenyNode n = it.next();
            if (n.isExternal() || n.isRoot() || (bl = n.getDistanceToParent()) == -1024.0) continue;
            bl_present = true;
            if (bl < this.getMinNotCollapseBlValue()) {
                to_be_removed.add(n);
            }
            if (!(bl < min_bl)) continue;
            min_bl = bl;
        }
        if (bl_present) {
            for (PhylogenyNode node : to_be_removed) {
                PhylogenyMethods.removeNode(node, phy);
            }
            if (to_be_removed.size() > 0) {
                phy.externalNodesHaveChanged();
                phy.clearHashIdToNodeMap();
                phy.recalculateNumberOfExternalDescendants(true);
                this.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
                this.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
                this.getCurrentTreePanel().calculateLongestExtNodeInfo();
                this.getCurrentTreePanel().setNodeInPreorderToNull();
                this.getCurrentTreePanel().recalculateMaxDistanceToRoot();
                this.getCurrentTreePanel().resetPreferredSize();
                this.getCurrentTreePanel().setEdited(true);
                this.getCurrentTreePanel().repaint();
                this.repaint();
            }
            if (to_be_removed.size() > 0) {
                JOptionPane.showMessageDialog(this, "Collapsed " + to_be_removed.size() + " branches with\nbranch length values below " + this.getMinNotCollapseBlValue(), "Collapsed " + to_be_removed.size() + " branches", 1);
            } else {
                JOptionPane.showMessageDialog(this, "No branch collapsed,\nminimum branch length is " + min_bl, "No branch collapsed", 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No branch collapsed because no branch length values present", "No branch length values present", 1);
        }
    }

    private PhyloXmlParser createPhyloXmlParser() {
        PhyloXmlParser xml_parser = null;
        if (this.getConfiguration().isValidatePhyloXmlAgainstSchema()) {
            try {
                xml_parser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "failed to create validating XML parser", 2);
            }
        }
        if (xml_parser == null) {
            xml_parser = PhyloXmlParser.createPhyloXmlParser();
        }
        return xml_parser;
    }

    private void executePhyleneticInference(boolean from_unaligned_seqs) {
        PhyloInferenceDialog dialog = new PhyloInferenceDialog(this, this.getPhylogeneticInferenceOptions(), from_unaligned_seqs);
        dialog.activate();
        if (dialog.getValue() == 0) {
            if (!from_unaligned_seqs) {
                if (this.getMsa() != null) {
                    PhylogeneticInferrer inferrer = new PhylogeneticInferrer(this.getMsa(), this.getPhylogeneticInferenceOptions().copy(), this);
                    new Thread(inferrer).start();
                } else {
                    JOptionPane.showMessageDialog(this, "No multiple sequence alignment selected", "Phylogenetic Inference Not Launched", 2);
                }
            } else if (this.getSeqs() != null) {
                PhylogeneticInferrer inferrer = new PhylogeneticInferrer(this.getSeqs(), this.getPhylogeneticInferenceOptions().copy(), this);
                new Thread(inferrer).start();
            } else {
                JOptionPane.showMessageDialog(this, "No input sequences selected", "Phylogenetic Inference Not Launched", 2);
            }
        }
    }

    private void extractTaxDataFromNodeNames() throws PhyloXmlDataFormatException {
        Phylogeny phy;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb_failed = new StringBuilder();
        int counter = 0;
        int counter_failed = 0;
        if (this.getCurrentTreePanel() != null && (phy = this.getCurrentTreePanel().getPhylogeny()) != null && !phy.isEmpty()) {
            PhylogenyNodeIterator it = phy.iteratorExternalForward();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                String name = n.getName().trim();
                if (ForesterUtil.isEmpty(name)) continue;
                String nt = ParserUtils.extractTaxonomyDataFromNodeName(n, NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                if (!ForesterUtil.isEmpty(nt)) {
                    if (counter < 15) {
                        sb.append(name + ": " + nt + "\n");
                    } else if (counter == 15) {
                        sb.append("...\n");
                    }
                    ++counter;
                    continue;
                }
                if (counter_failed < 15) {
                    sb_failed.append(name + "\n");
                } else if (counter_failed == 15) {
                    sb_failed.append("...\n");
                }
                ++counter_failed;
            }
            if (counter > 0) {
                String failed = "";
                String all = "all ";
                if (counter_failed > 0) {
                    all = "";
                    failed = "\nCould not extract taxonomic data for " + counter_failed + " named external nodes:\n" + sb_failed;
                }
                JOptionPane.showMessageDialog(this, "Extracted taxonomic data from " + all + counter + " named external nodes:\n" + sb.toString() + failed, "Taxonomic Data Extraction Completed", counter_failed > 0 ? 2 : 1);
            } else {
                JOptionPane.showMessageDialog(this, "Could not extract any taxonomic data.\nMaybe node names are empty\nor not in the forms \"XYZ_CAEEL\", \"XYZ_6239\", or \"XYZ_Caenorhabditis_elegans\"\nor nodes already have taxonomic data?\n", "No Taxonomic Data Extracted", 0);
            }
        }
    }

    private double getMinNotCollapseBlValue() {
        return this._min_not_collapse_bl;
    }

    private double getMinNotCollapseConfidenceValue() {
        return this._min_not_collapse;
    }

    private PhylogeneticInferenceOptions getPhylogeneticInferenceOptions() {
        if (this._phylogenetic_inference_options == null) {
            this._phylogenetic_inference_options = new PhylogeneticInferenceOptions();
        }
        return this._phylogenetic_inference_options;
    }

    private boolean isUnsavedDataPresent() {
        List<TreePanel> tps = this.getMainPanel().getTreePanels();
        for (TreePanel tp : tps) {
            if (!tp.isEdited()) continue;
            return true;
        }
        return false;
    }

    private void moveNodeNamesToSeqNames() throws PhyloXmlDataFormatException {
        Phylogeny phy;
        if (this.getCurrentTreePanel() != null && (phy = this.getCurrentTreePanel().getPhylogeny()) != null && !phy.isEmpty()) {
            PhylogenyMethods.transferNodeNameToField(phy, PhylogenyMethods.PhylogenyNodeField.SEQUENCE_NAME, false);
        }
    }

    private void moveNodeNamesToTaxSn() throws PhyloXmlDataFormatException {
        Phylogeny phy;
        if (this.getCurrentTreePanel() != null && (phy = this.getCurrentTreePanel().getPhylogeny()) != null && !phy.isEmpty()) {
            PhylogenyMethods.transferNodeNameToField(phy, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, false);
        }
    }

    private void newTree() {
        Phylogeny[] phys = new Phylogeny[1];
        Phylogeny phy = new Phylogeny();
        PhylogenyNode node = new PhylogenyNode();
        phy.setRoot(node);
        phy.setRooted(true);
        phys[0] = phy;
        AptxUtil.addPhylogeniesToTabs(phys, "", "", this.getConfiguration(), this.getMainPanel());
        this._mainpanel.getControlPanel().showWhole();
        this._mainpanel.getCurrentTreePanel().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        this._mainpanel.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        if (this.getMainPanel().getMainFrame() == null) {
            ((ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet()).setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else {
            this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    private void obtainDetailedTaxonomicInformation() {
        Phylogeny phy;
        if (this.getCurrentTreePanel() != null && (phy = this.getCurrentTreePanel().getPhylogeny()) != null && !phy.isEmpty()) {
            TaxonomyDataManager t = new TaxonomyDataManager(this, this._mainpanel.getCurrentTreePanel(), phy.copy(), false, true);
            new Thread(t).start();
        }
    }

    private void obtainDetailedTaxonomicInformationDelete() {
        Phylogeny phy;
        if (this.getCurrentTreePanel() != null && (phy = this.getCurrentTreePanel().getPhylogeny()) != null && !phy.isEmpty()) {
            TaxonomyDataManager t = new TaxonomyDataManager(this, this._mainpanel.getCurrentTreePanel(), phy.copy(), true, true);
            new Thread(t).start();
        }
    }

    private void obtainSequenceInformation() {
        Phylogeny phy;
        if (this.getCurrentTreePanel() != null && (phy = this.getCurrentTreePanel().getPhylogeny()) != null && !phy.isEmpty()) {
            SequenceDataRetriver u = new SequenceDataRetriver(this, this._mainpanel.getCurrentTreePanel(), phy.copy());
            new Thread(u).start();
        }
    }

    private void preProcessTreesUponReading(Phylogeny[] phys) {
        for (Phylogeny phy : phys) {
            if (phy == null || phy.isEmpty()) continue;
            PhylogenyNodeIterator it = phy.iteratorPreorder();
            while (it.hasNext()) {
                Sequence s;
                PhylogenyNode n = it.next();
                if (!n.isExternal() || !n.getNodeData().isHasSequence() || !ForesterUtil.isEmpty((s = n.getNodeData().getSequence()).getGeneName()) && !s.getGeneName().startsWith("LOC")) continue;
                if (s.getAccession() != null && !ForesterUtil.isEmpty(s.getAccession().getValue())) {
                    s.setGeneName(s.getAccession().getValue());
                    continue;
                }
                if (ForesterUtil.isEmpty(n.getName())) continue;
                s.setGeneName(n.getName());
            }
        }
    }

    private void readPhylogeniesFromFile() {
        boolean exception = false;
        Phylogeny[] phys = null;
        File my_dir = this.getCurrentDir();
        if (my_dir != null) {
            this._open_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._open_filechooser.showOpenDialog(this._contentpane);
        File[] files = this._open_filechooser.getSelectedFiles();
        this.setCurrentDir(this._open_filechooser.getCurrentDirectory());
        boolean nhx_or_nexus = false;
        if (files != null && files.length > 0 && result == 0) {
            for (File file : files) {
                if (file == null || file.isDirectory()) continue;
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setWaitCursor();
                } else {
                    this._mainpanel.setWaitCursor();
                }
                if (this._open_filechooser.getFileFilter() == MainFrame.nhfilter || this._open_filechooser.getFileFilter() == MainFrame.nhxfilter) {
                    try {
                        NHXParser nhx = new NHXParser();
                        this.setSpecialOptionsForNhxParser(nhx);
                        phys = PhylogenyMethods.readPhylogenies((PhylogenyParser)nhx, file);
                        nhx_or_nexus = true;
                    }
                    catch (Exception e) {
                        exception = true;
                        this.exceptionOccuredDuringOpenFile(e);
                    }
                } else if (this._open_filechooser.getFileFilter() == MainFrame.xmlfilter) {
                    MainFrameApplication.warnIfNotPhyloXmlValidation(this.getConfiguration());
                    try {
                        PhyloXmlParser xml_parser = this.createPhyloXmlParser();
                        phys = PhylogenyMethods.readPhylogenies((PhylogenyParser)xml_parser, file);
                    }
                    catch (Exception e) {
                        exception = true;
                        this.exceptionOccuredDuringOpenFile(e);
                    }
                } else if (this._open_filechooser.getFileFilter() == MainFrame.tolfilter) {
                    try {
                        phys = PhylogenyMethods.readPhylogenies((PhylogenyParser)new TolParser(), file);
                    }
                    catch (Exception e) {
                        exception = true;
                        this.exceptionOccuredDuringOpenFile(e);
                    }
                } else if (this._open_filechooser.getFileFilter() == MainFrame.nexusfilter) {
                    try {
                        NexusPhylogeniesParser nex = new NexusPhylogeniesParser();
                        this.setSpecialOptionsForNexParser(nex);
                        phys = PhylogenyMethods.readPhylogenies((PhylogenyParser)nex, file);
                        nhx_or_nexus = true;
                    }
                    catch (Exception e) {
                        exception = true;
                        this.exceptionOccuredDuringOpenFile(e);
                    }
                } else {
                    try {
                        PhylogenyParser parser = ParserUtils.createParserDependingOnFileType(file, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
                        if (parser instanceof NexusPhylogeniesParser) {
                            NexusPhylogeniesParser nex = (NexusPhylogeniesParser)parser;
                            this.setSpecialOptionsForNexParser(nex);
                            nhx_or_nexus = true;
                        } else if (parser instanceof NHXParser) {
                            NHXParser nhx = (NHXParser)parser;
                            this.setSpecialOptionsForNhxParser(nhx);
                            nhx_or_nexus = true;
                        } else if (parser instanceof PhyloXmlParser) {
                            MainFrameApplication.warnIfNotPhyloXmlValidation(this.getConfiguration());
                        }
                        phys = PhylogenyMethods.readPhylogenies(parser, file);
                    }
                    catch (Exception e) {
                        exception = true;
                        this.exceptionOccuredDuringOpenFile(e);
                    }
                }
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setArrowCursor();
                } else {
                    this._mainpanel.setArrowCursor();
                }
                if (exception || phys == null || phys.length <= 0) continue;
                boolean one_desc = false;
                if (nhx_or_nexus) {
                    for (Phylogeny phy : phys) {
                        if (this.getOptions().isInternalNumberAreConfidenceForNhParsing()) {
                            PhylogenyMethods.transferInternalNodeNamesToConfidence(phy, "");
                        }
                        if (PhylogenyMethods.getMinimumDescendentsPerInternalNodes(phy) != 1) continue;
                        one_desc = true;
                        break;
                    }
                }
                AptxUtil.addPhylogeniesToTabs(phys, file.getName(), file.getAbsolutePath(), this.getConfiguration(), this.getMainPanel());
                this._mainpanel.getControlPanel().showWhole();
                if (!nhx_or_nexus || !one_desc) continue;
                JOptionPane.showMessageDialog(this, "One or more trees contain (a) node(s) with one descendant, " + ForesterUtil.LINE_SEPARATOR + "possibly indicating illegal parentheses within node names.", "Warning: Possible Error in New Hampshire Formatted Data", 2);
            }
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    private void readSpeciesTreeFromFile() {
        Phylogeny t = null;
        boolean exception = false;
        File my_dir = this.getCurrentDir();
        this._open_filechooser_for_species_tree.setSelectedFile(new File(""));
        if (my_dir != null) {
            this._open_filechooser_for_species_tree.setCurrentDirectory(my_dir);
        }
        int result = this._open_filechooser_for_species_tree.showOpenDialog(this._contentpane);
        File file = this._open_filechooser_for_species_tree.getSelectedFile();
        if (file != null && result == 0) {
            Phylogeny[] trees;
            if (this._open_filechooser_for_species_tree.getFileFilter() == MainFrame.xmlfilter) {
                try {
                    trees = PhylogenyMethods.readPhylogenies((PhylogenyParser)PhyloXmlParser.createPhyloXmlParserXsdValidating(), file);
                    t = trees[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            } else if (this._open_filechooser_for_species_tree.getFileFilter() == MainFrame.tolfilter) {
                try {
                    trees = PhylogenyMethods.readPhylogenies((PhylogenyParser)new TolParser(), file);
                    t = trees[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            } else {
                try {
                    trees = PhylogenyMethods.readPhylogenies((PhylogenyParser)PhyloXmlParser.createPhyloXmlParserXsdValidating(), file);
                    t = trees[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            }
            if (!exception && t != null && !t.isRooted()) {
                exception = true;
                t = null;
                JOptionPane.showMessageDialog(this, "Species tree is not rooted", "Species tree not loaded", 0);
            }
            if (!exception && t != null) {
                HashSet<Taxonomy> tax_set = new HashSet<Taxonomy>();
                PhylogenyNodeIterator it = t.iteratorExternalForward();
                while (it.hasNext()) {
                    PhylogenyNode node = it.next();
                    if (!node.getNodeData().isHasTaxonomy()) {
                        exception = true;
                        t = null;
                        JOptionPane.showMessageDialog(this, "Species tree contains external node(s) without taxonomy information", "Species tree not loaded", 0);
                        break;
                    }
                    if (tax_set.contains(node.getNodeData().getTaxonomy())) {
                        exception = true;
                        t = null;
                        JOptionPane.showMessageDialog(this, "Taxonomy [" + node.getNodeData().getTaxonomy().asSimpleText() + "] is not unique in species tree", "Species tree not loaded", 0);
                        break;
                    }
                    tax_set.add(node.getNodeData().getTaxonomy());
                }
            }
            if (!exception && t != null) {
                this.setSpeciesTree(t);
                JOptionPane.showMessageDialog(this, "Species tree successfully loaded", "Species tree loaded", 1);
            }
            this._contentpane.repaint();
            System.gc();
        }
    }

    private void setArrowCursor() {
        try {
            this._mainpanel.getCurrentTreePanel().setArrowCursor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setMinNotCollapseBlValue(double min_not_collapse_bl) {
        this._min_not_collapse_bl = min_not_collapse_bl;
    }

    private void setMinNotCollapseConfidenceValue(double min_not_collapse) {
        this._min_not_collapse = min_not_collapse;
    }

    private void setPhylogeneticInferenceOptions(PhylogeneticInferenceOptions phylogenetic_inference_options) {
        this._phylogenetic_inference_options = phylogenetic_inference_options;
    }

    private void setSpecialOptionsForNexParser(NexusPhylogeniesParser nex) {
        nex.setReplaceUnderscores(this.getOptions().isReplaceUnderscoresInNhParsing());
        nex.setTaxonomyExtraction(this.getOptions().getTaxonomyExtraction());
    }

    private void setSpecialOptionsForNhxParser(NHXParser nhx) {
        nhx.setReplaceUnderscores(this.getOptions().isReplaceUnderscoresInNhParsing());
        nhx.setTaxonomyExtraction(this.getOptions().getTaxonomyExtraction());
        nhx.setAllowErrorsInDistanceToParent(this.getOptions().isAllowErrorsInDistanceToParent());
    }

    void buildAnalysisMenu() {
        this._analysis_menu = MainFrame.createMenu("Analysis", this.getConfiguration());
        this._gsdi_item = new JMenuItem("GSDI (Generalized Speciation Duplication Inference)");
        this._analysis_menu.add(this._gsdi_item);
        this._gsdir_item = new JMenuItem("GSDIR (GSDI with re-rooting)");
        this._analysis_menu.add(this._gsdir_item);
        this._load_species_tree_item = new JMenuItem("Load Species Tree...");
        this._analysis_menu.add(this._load_species_tree_item);
        this.customizeJMenuItem(this._gsdi_item);
        this.customizeJMenuItem(this._gsdir_item);
        this.customizeJMenuItem(this._load_species_tree_item);
        this._analysis_menu.addSeparator();
        this._lineage_inference = new JMenuItem("Infer Ancestor Taxonomies");
        this._analysis_menu.add(this._lineage_inference);
        this.customizeJMenuItem(this._lineage_inference);
        this._lineage_inference.setToolTipText("Inference of ancestor taxonomies/lineages");
        this._jmenubar.add(this._analysis_menu);
    }

    @Override
    void buildFileMenu() {
        int i;
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._open_item = new JMenuItem("Read Tree from File...");
        this._file_jmenu.add(this._open_item);
        this._file_jmenu.addSeparator();
        this._open_url_item = new JMenuItem("Read Tree from URL/Webservice...");
        this._file_jmenu.add(this._open_url_item);
        this._file_jmenu.addSeparator();
        WebservicesManager webservices_manager = WebservicesManager.getInstance();
        this._load_phylogeny_from_webservice_menu_items = new JMenuItem[webservices_manager.getAvailablePhylogeniesWebserviceClients().size()];
        for (i = 0; i < webservices_manager.getAvailablePhylogeniesWebserviceClients().size(); ++i) {
            PhylogeniesWebserviceClient client = webservices_manager.getAvailablePhylogeniesWebserviceClient(i);
            this._load_phylogeny_from_webservice_menu_items[i] = new JMenuItem(client.getMenuName());
            this._file_jmenu.add(this._load_phylogeny_from_webservice_menu_items[i]);
        }
        if (this.getConfiguration().isEditable()) {
            this._file_jmenu.addSeparator();
            this._new_item = new JMenuItem("New");
            this._file_jmenu.add(this._new_item);
            this._new_item.setToolTipText("to create a new tree with one node, as source for manual tree construction");
        }
        this._file_jmenu.addSeparator();
        this._save_item = new JMenuItem("Save Tree As...");
        this._file_jmenu.add(this._save_item);
        this._save_all_item = new JMenuItem("Save All Trees As...");
        this._file_jmenu.add(this._save_all_item);
        this._save_all_item.setToolTipText("Write all phylogenies to one file.");
        this._save_all_item.setEnabled(false);
        this._file_jmenu.addSeparator();
        this._write_to_pdf_item = new JMenuItem("Export to PDF file ...");
        this._file_jmenu.add(this._write_to_pdf_item);
        if (AptxUtil.canWriteFormat("tif") || AptxUtil.canWriteFormat("tiff") || AptxUtil.canWriteFormat("TIF")) {
            this._write_to_tif_item = new JMenuItem("Export to TIFF file...");
            this._file_jmenu.add(this._write_to_tif_item);
        }
        this._write_to_png_item = new JMenuItem("Export to PNG file...");
        this._file_jmenu.add(this._write_to_png_item);
        this._write_to_jpg_item = new JMenuItem("Export to JPG file...");
        this._file_jmenu.add(this._write_to_jpg_item);
        if (AptxUtil.canWriteFormat("gif")) {
            this._write_to_gif_item = new JMenuItem("Export to GIF file...");
            this._file_jmenu.add(this._write_to_gif_item);
        }
        if (AptxUtil.canWriteFormat("bmp")) {
            this._write_to_bmp_item = new JMenuItem("Export to BMP file...");
            this._file_jmenu.add(this._write_to_bmp_item);
        }
        this._file_jmenu.addSeparator();
        this._print_item = new JMenuItem("Print...");
        this._file_jmenu.add(this._print_item);
        this._file_jmenu.addSeparator();
        this._close_item = new JMenuItem("Close Tab");
        this._file_jmenu.add(this._close_item);
        this._close_item.setToolTipText("To close the current pane.");
        this._close_item.setEnabled(true);
        this._file_jmenu.addSeparator();
        this._exit_item = new JMenuItem("Exit");
        this._file_jmenu.add(this._exit_item);
        this.customizeJMenuItem(this._open_item);
        this._open_item.setFont(new Font(this._open_item.getFont().getFontName(), 1, this._open_item.getFont().getSize() + 4));
        this.customizeJMenuItem(this._open_url_item);
        for (i = 0; i < webservices_manager.getAvailablePhylogeniesWebserviceClients().size(); ++i) {
            this.customizeJMenuItem(this._load_phylogeny_from_webservice_menu_items[i]);
        }
        this.customizeJMenuItem(this._save_item);
        if (this.getConfiguration().isEditable()) {
            this.customizeJMenuItem(this._new_item);
        }
        this.customizeJMenuItem(this._close_item);
        this.customizeJMenuItem(this._save_all_item);
        this.customizeJMenuItem(this._write_to_pdf_item);
        this.customizeJMenuItem(this._write_to_png_item);
        this.customizeJMenuItem(this._write_to_jpg_item);
        this.customizeJMenuItem(this._write_to_gif_item);
        this.customizeJMenuItem(this._write_to_tif_item);
        this.customizeJMenuItem(this._write_to_bmp_item);
        this.customizeJMenuItem(this._print_item);
        this.customizeJMenuItem(this._exit_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.setOvPlacementColorChooseMenuItem(MainFrameApplication.this._overview_placment_mi, MainFrameApplication.this.getOptions());
                MainFrame.setTextColorChooseMenuItem(MainFrameApplication.this._switch_colors_mi, MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(MainFrameApplication.this._choose_minimal_confidence_mi, MainFrameApplication.this.getOptions(), MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(MainFrameApplication.this._choose_font_mi, MainFrame.createCurrentFontDesc(MainFrameApplication.this.getMainPanel().getTreeFontSet()));
                MainFrame.setTextForGraphicsSizeChooserMenuItem(MainFrameApplication.this._print_size_mi, MainFrameApplication.this.getOptions());
                MainFrame.setTextForPdfLineWidthChooserMenuItem(MainFrameApplication.this._choose_pdf_width_mi, MainFrameApplication.this.getOptions());
                MainFrame.setCycleNodeFillMenuItem(MainFrameApplication.this._cycle_node_fill_mi, MainFrameApplication.this.getOptions());
                MainFrame.setCycleNodeShapeMenuItem(MainFrameApplication.this._cycle_node_shape_mi, MainFrameApplication.this.getOptions());
                MainFrame.setCycleDataReturnMenuItem(MainFrameApplication.this._cycle_data_return, MainFrameApplication.this.getOptions());
                MainFrame.setTextNodeSizeMenuItem(MainFrameApplication.this._choose_node_size_mi, MainFrameApplication.this.getOptions());
                try {
                    MainFrameApplication.this.getMainPanel().getControlPanel().setVisibilityOfDomainStrucureCB();
                    MainFrameApplication.this.getMainPanel().getControlPanel().setVisibilityOfX();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("External Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._uniform_cladograms_rbmi = new JRadioButtonMenuItem("Total Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._uniform_cladograms_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladograms");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._uniform_cladograms_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_default_node_shapes_internal_cbmi = new JCheckBoxMenuItem("Shapes for Internal Nodes");
        this._options_jmenu.add(this._show_default_node_shapes_internal_cbmi);
        this._show_default_node_shapes_external_cbmi = new JCheckBoxMenuItem("Shapes for External Nodes");
        this._options_jmenu.add(this._show_default_node_shapes_external_cbmi);
        this._show_default_node_shapes_for_marked_cbmi = new JCheckBoxMenuItem("Shapes for Nodes with Visual Data");
        this._options_jmenu.add(this._show_default_node_shapes_for_marked_cbmi);
        this._line_up_renderable_data_cbmi = new JCheckBoxMenuItem("Line Up Diagrams (such as Domain Architectures)");
        this._options_jmenu.add(this._line_up_renderable_data_cbmi);
        if (this.getConfiguration().doDisplayOption(10)) {
            this._right_line_up_domains_cbmi = new JCheckBoxMenuItem("Right-align Domain Architectures");
            this._options_jmenu.add(this._right_line_up_domains_cbmi);
            this._show_domain_labels = new JCheckBoxMenuItem("Domain Labels");
            this._options_jmenu.add(this._show_domain_labels);
        }
        this._show_annotation_ref_source = new JCheckBoxMenuItem("Seq Annotation Ref Sources");
        this._options_jmenu.add(this._show_annotation_ref_source);
        this._show_confidence_stddev_cbmi = new JCheckBoxMenuItem("Confidence Standard Deviations");
        this._options_jmenu.add(this._show_confidence_stddev_cbmi);
        this._color_by_taxonomic_group_cbmi = new JCheckBoxMenuItem("Colorize by Taxonomic Group");
        this._options_jmenu.add(this._color_by_taxonomic_group_cbmi);
        this._color_labels_same_as_parent_branch = new JCheckBoxMenuItem("Colorize Labels Same as Parent Branch");
        this._options_jmenu.add(this._color_labels_same_as_parent_branch);
        this._color_labels_same_as_parent_branch.setToolTipText("To use parent branch colors for node labels as well, need to turn off taxonomy dependent colorization and turn on branch colorization for this to become apparent");
        this._abbreviate_scientific_names = new JCheckBoxMenuItem("Abbreviate Scientific Taxonomic Names");
        this._options_jmenu.add(this._abbreviate_scientific_names);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        this._cycle_node_shape_mi = new JMenuItem("Cycle Node Shapes");
        this._options_jmenu.add(this._cycle_node_shape_mi);
        this._cycle_node_fill_mi = new JMenuItem("Cycle Node Fill Type");
        this._options_jmenu.add(this._cycle_node_fill_mi);
        this._choose_node_size_mi = new JMenuItem("Choose Node Shape Size");
        this._options_jmenu.add(this._choose_node_size_mi);
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._cycle_data_return = new JMenuItem("Cycle Data Return");
        this._options_jmenu.add(this._cycle_data_return);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Case Sensitive");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Match Complete Terms Only");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._search_with_regex_cbmi = new JCheckBoxMenuItem("Search with Regular Expressions");
        this._options_jmenu.add(this._search_with_regex_cbmi);
        this._search_with_regex_cbmi.setToolTipText("To search using regular expressions (~Java/Perl syntax). For example, use \"^B.+\\d{2,}$\" to search for everything starting with a B and ending with at least two digits.");
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Negate Result");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Graphics Export & Printing:"), this.getConfiguration()));
        this._antialias_print_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._antialias_print_cbmi);
        this._print_black_and_white_cbmi = new JCheckBoxMenuItem("Export in Black and White");
        this._options_jmenu.add(this._print_black_and_white_cbmi);
        this._print_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PDF export and Printing");
        this._options_jmenu.add(this._print_using_actual_size_cbmi);
        this._graphics_export_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_using_actual_size_cbmi);
        this._graphics_export_visible_only_cbmi = new JCheckBoxMenuItem("Limit to Visible ('Screenshot') for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_visible_only_cbmi);
        this._print_size_mi = new JMenuItem("");
        this._options_jmenu.add(this._print_size_mi);
        this._choose_pdf_width_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_pdf_width_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Newick/NHX/Nexus Input:"), this.getConfiguration()));
        this._internal_number_are_confidence_for_nh_parsing_cbmi = new JCheckBoxMenuItem("Internal Node Names are Confidence Values");
        this._options_jmenu.add(this._internal_number_are_confidence_for_nh_parsing_cbmi);
        this._replace_underscores_cbmi = new JCheckBoxMenuItem("Replace Underscores with Spaces");
        this._options_jmenu.add(this._replace_underscores_cbmi);
        this._allow_errors_in_distance_to_parent_cbmi = new JCheckBoxMenuItem("Ignore Distance Values Format Errors");
        this._options_jmenu.add(this._allow_errors_in_distance_to_parent_cbmi);
        this._extract_taxonomy_no_rbmi = new JRadioButtonMenuItem("No Taxonomy Extraction");
        this._options_jmenu.add(this._extract_taxonomy_no_rbmi);
        this._extract_taxonomy_pfam_strict_rbmi = new JRadioButtonMenuItem("Extract Taxonomy Codes/Ids from Pfam-style Node Names");
        this._options_jmenu.add(this._extract_taxonomy_pfam_strict_rbmi);
        this._extract_taxonomy_pfam_relaxed_rbmi = new JRadioButtonMenuItem("Extract Taxonomy Codes/Ids from Pfam-style like Node Names");
        this._options_jmenu.add(this._extract_taxonomy_pfam_relaxed_rbmi);
        this._extract_taxonomy_agressive_rbmi = new JRadioButtonMenuItem("Extract Taxonomy Codes/Ids/Scientific Names from Node Names");
        this._options_jmenu.add(this._extract_taxonomy_agressive_rbmi);
        this._extract_taxonomy_pfam_strict_rbmi.setToolTipText("To extract taxonomy codes/ids from node names in the form of e.g. \"BCL2_MOUSE/123-304\" or \"BCL2_10090/123-304\"");
        this._extract_taxonomy_pfam_relaxed_rbmi.setToolTipText("To extract taxonomy codes/ids from node names in the form of e.g. \"bax_MOUSE\" or \"bax_10090\"");
        this._extract_taxonomy_agressive_rbmi.setToolTipText("To extract taxonomy codes/ids or scientific names from node names in the form of e.g. \"MOUSE\" or \"10090\" or \"xyz_Nematostella_vectensis\"");
        this._radio_group_2 = new ButtonGroup();
        this._radio_group_2.add(this._extract_taxonomy_no_rbmi);
        this._radio_group_2.add(this._extract_taxonomy_pfam_strict_rbmi);
        this._radio_group_2.add(this._extract_taxonomy_pfam_relaxed_rbmi);
        this._radio_group_2.add(this._extract_taxonomy_agressive_rbmi);
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Newick/Nexus Output:"), this.getConfiguration()));
        this._use_brackets_for_conf_in_nh_export_cbmi = new JCheckBoxMenuItem("Use Brackets for Confidence Values");
        this._options_jmenu.add(this._use_brackets_for_conf_in_nh_export_cbmi);
        this._use_brackets_for_conf_in_nh_export_cbmi.setToolTipText("e.g. \"0.1[90]\" for a branch with support 90 and a length of 0.1");
        this._use_internal_names_for_conf_in_nh_export_cbmi = new JCheckBoxMenuItem("Use Internal Node Names for Confidence Values");
        this._options_jmenu.add(this._use_internal_names_for_conf_in_nh_export_cbmi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._print_size_mi);
        this.customizeJMenuItem(this._choose_pdf_width_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_external_cbmi, this.getOptions().isShowDefaultNodeShapesExternal());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_internal_cbmi, this.getOptions().isShowDefaultNodeShapesInternal());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_for_marked_cbmi, this.getOptions().isShowDefaultNodeShapesForMarkedNodes());
        this.customizeJMenuItem(this._cycle_node_shape_mi);
        this.customizeJMenuItem(this._cycle_node_fill_mi);
        this.customizeJMenuItem(this._choose_node_size_mi);
        this.customizeJMenuItem(this._cycle_data_return);
        this.customizeCheckBoxMenuItem(this._color_labels_same_as_parent_branch, this.getOptions().isColorLabelsSameAsParentBranch());
        this.customizeCheckBoxMenuItem(this._color_by_taxonomic_group_cbmi, this.getOptions().isColorByTaxonomicGroup());
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._show_domain_labels, this.getOptions().isShowDomainLabels());
        this.customizeCheckBoxMenuItem(this._show_annotation_ref_source, this.getOptions().isShowAnnotationRefSource());
        this.customizeCheckBoxMenuItem(this._abbreviate_scientific_names, this.getOptions().isAbbreviateScientificTaxonNames());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._uniform_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._antialias_print_cbmi, this.getOptions().isAntialiasPrint());
        this.customizeCheckBoxMenuItem(this._print_black_and_white_cbmi, this.getOptions().isPrintBlackAndWhite());
        this.customizeCheckBoxMenuItem(this._internal_number_are_confidence_for_nh_parsing_cbmi, this.getOptions().isInternalNumberAreConfidenceForNhParsing());
        this.customizeRadioButtonMenuItem(this._extract_taxonomy_no_rbmi, this.getOptions().getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.NO);
        this.customizeRadioButtonMenuItem(this._extract_taxonomy_pfam_strict_rbmi, this.getOptions().getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
        this.customizeRadioButtonMenuItem(this._extract_taxonomy_pfam_relaxed_rbmi, this.getOptions().getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED);
        this.customizeRadioButtonMenuItem(this._extract_taxonomy_agressive_rbmi, this.getOptions().getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        this.customizeCheckBoxMenuItem(this._replace_underscores_cbmi, this.getOptions().isReplaceUnderscoresInNhParsing());
        this.customizeCheckBoxMenuItem(this._allow_errors_in_distance_to_parent_cbmi, this.getOptions().isReplaceUnderscoresInNhParsing());
        this.customizeCheckBoxMenuItem(this._search_with_regex_cbmi, this.getOptions().isSearchWithRegex());
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this.customizeCheckBoxMenuItem(this._graphics_export_visible_only_cbmi, this.getOptions().isGraphicsExportVisibleOnly());
        this.customizeCheckBoxMenuItem(this._print_using_actual_size_cbmi, this.getOptions().isPrintUsingActualSize());
        this.customizeCheckBoxMenuItem(this._graphics_export_using_actual_size_cbmi, this.getOptions().isGraphicsExportUsingActualSize());
        this.customizeCheckBoxMenuItem(this._show_confidence_stddev_cbmi, this.getOptions().isShowConfidenceStddev());
        this.customizeCheckBoxMenuItem(this._use_brackets_for_conf_in_nh_export_cbmi, this.getOptions().getNhConversionSupportValueStyle() == PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.IN_SQUARE_BRACKETS);
        this.customizeCheckBoxMenuItem(this._use_internal_names_for_conf_in_nh_export_cbmi, this.getOptions().getNhConversionSupportValueStyle() == PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.AS_INTERNAL_NODE_NAMES);
        this.customizeCheckBoxMenuItem(this._line_up_renderable_data_cbmi, this.getOptions().isLineUpRendarableNodeData());
        this.customizeCheckBoxMenuItem(this._right_line_up_domains_cbmi, this.getOptions().isRightLineUpDomains());
        this._jmenubar.add(this._options_jmenu);
    }

    void buildPhylogeneticInferenceMenu() {
        InferenceManager im = this.getInferenceManager();
        this._inference_menu = MainFrame.createMenu("Inference", this.getConfiguration());
        this._inference_from_msa_item = new JMenuItem("From Multiple Sequence Alignment...");
        this._inference_menu.add(this._inference_from_msa_item);
        this.customizeJMenuItem(this._inference_from_msa_item);
        this._inference_from_msa_item.setToolTipText("Basic phylogenetic inference from MSA");
        if (im.canDoMsa()) {
            this._inference_from_seqs_item = new JMenuItem("From Unaligned Sequences...");
            this._inference_menu.add(this._inference_from_seqs_item);
            this.customizeJMenuItem(this._inference_from_seqs_item);
            this._inference_from_seqs_item.setToolTipText("Basic phylogenetic inference including multiple sequence alignment");
        } else {
            this._inference_from_seqs_item = new JMenuItem("From Unaligned Sequences (no program found)");
            this._inference_menu.add(this._inference_from_seqs_item);
            this.customizeJMenuItem(this._inference_from_seqs_item);
            this._inference_from_seqs_item.setEnabled(false);
        }
        this._jmenubar.add(this._inference_menu);
    }

    void buildToolsMenu() {
        this._tools_menu = MainFrameApplication.createMenu("Tools", this.getConfiguration());
        this._confcolor_item = new JMenuItem("Colorize Branches Depending on Confidence");
        this._tools_menu.add(this._confcolor_item);
        this.customizeJMenuItem(this._confcolor_item);
        this._color_rank_jmi = new JMenuItem("Colorize Subtrees via Taxonomic Rank");
        this._tools_menu.add(this._color_rank_jmi);
        this.customizeJMenuItem(this._color_rank_jmi);
        this._color_rank_jmi.setToolTipText("for example, at \"Class\" level, colorize mammal specific subtree red");
        this._taxcolor_item = new JMenuItem("Taxonomy Colorize Branches");
        this._tools_menu.add(this._taxcolor_item);
        this.customizeJMenuItem(this._taxcolor_item);
        this._tools_menu.addSeparator();
        this._remove_visual_styles_item = new JMenuItem("Delete All Visual Styles From Nodes");
        this._tools_menu.add(this._remove_visual_styles_item);
        this._remove_visual_styles_item.setToolTipText("To remove all node visual styles (fonts, colors) from the current phylogeny");
        this.customizeJMenuItem(this._remove_visual_styles_item);
        this._remove_branch_color_item = new JMenuItem("Delete All Colors From Branches");
        this._tools_menu.add(this._remove_branch_color_item);
        this._remove_branch_color_item.setToolTipText("To remove all branch color values from the current phylogeny");
        this.customizeJMenuItem(this._remove_branch_color_item);
        this._tools_menu.addSeparator();
        this._annotate_item = new JMenuItem("Annotate Sequences of Selected Nodes");
        this._tools_menu.add(this._annotate_item);
        this.customizeJMenuItem(this._annotate_item);
        this._tools_menu.addSeparator();
        this._midpoint_root_item = new JMenuItem("Midpoint-Root");
        this._tools_menu.add(this._midpoint_root_item);
        this.customizeJMenuItem(this._midpoint_root_item);
        this._tools_menu.addSeparator();
        this._delete_selected_nodes_item = new JMenuItem("Delete Selected Nodes");
        this._tools_menu.add(this._delete_selected_nodes_item);
        this._delete_selected_nodes_item.setToolTipText("To delete all selected external nodes");
        this.customizeJMenuItem(this._delete_selected_nodes_item);
        this._delete_not_selected_nodes_item = new JMenuItem("Retain Selected Nodes");
        this._tools_menu.add(this._delete_not_selected_nodes_item);
        this._delete_not_selected_nodes_item.setToolTipText("To delete all not selected external nodes");
        this.customizeJMenuItem(this._delete_not_selected_nodes_item);
        this._tools_menu.addSeparator();
        this._collapse_species_specific_subtrees = new JMenuItem("Collapse Species-Specific Subtrees");
        this._tools_menu.add(this._collapse_species_specific_subtrees);
        this.customizeJMenuItem(this._collapse_species_specific_subtrees);
        this._collapse_species_specific_subtrees.setToolTipText("To (reversibly) collapse species-specific subtrees");
        this._collapse_below_threshold = new JMenuItem("Collapse Branches with Confidence Below Threshold into Multifurcations");
        this._tools_menu.add(this._collapse_below_threshold);
        this.customizeJMenuItem(this._collapse_below_threshold);
        this._collapse_below_threshold.setToolTipText("To (permanently) collapse branches with confidence values below a threshold into multifurcations (in the case of multiple confidences per branch: without at least one confidence value above a threshold)");
        this._collapse_below_branch_length = new JMenuItem("Collapse Branches with Branch Lengths Below Threshold into Multifurcations");
        this._tools_menu.add(this._collapse_below_branch_length);
        this.customizeJMenuItem(this._collapse_below_branch_length);
        this._collapse_below_branch_length.setToolTipText("To (permanently) collapse branches with branches with branch lengths below a threshold into multifurcations");
        this._tools_menu.addSeparator();
        this._extract_tax_code_from_node_names_jmi = new JMenuItem("Extract Taxonomic Data from Node Names");
        this._tools_menu.add(this._extract_tax_code_from_node_names_jmi);
        this.customizeJMenuItem(this._extract_tax_code_from_node_names_jmi);
        this._extract_tax_code_from_node_names_jmi.setToolTipText("To extract SwissProt/Uniprot taxonomic codes (mnemonics) from nodes names in the form of 'xyz_CAEEL', Uniprot/NCBI identifiers form of 'xyz_6239', or scientific names form of 'xyz_Caenorhabditis_elegans'");
        this._move_node_names_to_tax_sn_jmi = new JMenuItem("Transfer Node Names to Taxonomic Scientific Names");
        this._tools_menu.add(this._move_node_names_to_tax_sn_jmi);
        this.customizeJMenuItem(this._move_node_names_to_tax_sn_jmi);
        this._move_node_names_to_tax_sn_jmi.setToolTipText("To interpret node names as taxonomic scientific names");
        this._move_node_names_to_seq_names_jmi = new JMenuItem("Transfer Node Names to Sequence Names");
        this._tools_menu.add(this._move_node_names_to_seq_names_jmi);
        this.customizeJMenuItem(this._move_node_names_to_seq_names_jmi);
        this._move_node_names_to_seq_names_jmi.setToolTipText("To interpret node names as sequence (protein, gene) names");
        this._tools_menu.addSeparator();
        this._obtain_seq_information_jmi = new JMenuItem("Obtain Sequence Information");
        this._tools_menu.add(this._obtain_seq_information_jmi);
        this.customizeJMenuItem(this._obtain_seq_information_jmi);
        this._obtain_seq_information_jmi.setToolTipText("To add additional sequence information");
        this._obtain_detailed_taxonomic_information_jmi = new JMenuItem("Obtain Detailed Taxonomic Information");
        this._tools_menu.add(this._obtain_detailed_taxonomic_information_jmi);
        this.customizeJMenuItem(this._obtain_detailed_taxonomic_information_jmi);
        this._obtain_detailed_taxonomic_information_jmi.setToolTipText("To add additional taxonomic information (from UniProt Taxonomy)");
        this._obtain_detailed_taxonomic_information_deleting_jmi = new JMenuItem("Obtain Detailed Taxonomic Information (deletes nodes!)");
        this._tools_menu.add(this._obtain_detailed_taxonomic_information_deleting_jmi);
        this.customizeJMenuItem(this._obtain_detailed_taxonomic_information_deleting_jmi);
        this._obtain_detailed_taxonomic_information_deleting_jmi.setToolTipText("To add additional taxonomic information, deletes nodes for which taxonomy cannot found (from UniProt Taxonomy)");
        this._tools_menu.addSeparator();
        this._read_values_jmi = new JMenuItem("Attach Vector/Expression Values");
        this._tools_menu.add(this._read_values_jmi);
        this.customizeJMenuItem(this._read_values_jmi);
        this._read_values_jmi.setToolTipText("To attach vector (e.g. gene expression) values to tree nodes (beta)");
        this._jmenubar.add(this._tools_menu);
        this._read_seqs_jmi = new JMenuItem("Attach Molecular Sequences");
        this._tools_menu.add(this._read_seqs_jmi);
        this.customizeJMenuItem(this._read_seqs_jmi);
        this._read_seqs_jmi.setToolTipText("To attach molecular sequences to tree nodes (from Fasta-formatted file) (beta)");
        this._jmenubar.add(this._tools_menu);
    }

    @Override
    void close() {
        int r;
        if (this.isUnsavedDataPresent() && (r = JOptionPane.showConfirmDialog(this, "Exit despite potentially unsaved changes?", "Exit?", 0)) != 0) {
            return;
        }
        this.exit();
    }

    void exit() {
        this.removeAllTextFrames();
        this._mainpanel.terminate();
        this._contentpane.removeAll();
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPhylogeniesFromURL() {
        URL url = null;
        Phylogeny[] phys = null;
        String message = "Please enter a complete URL, for example \"http://purl.org/phylo/treebase/phylows/study/TB2:S15480?format=nexus\"";
        String url_string = JOptionPane.showInputDialog(this, "Please enter a complete URL, for example \"http://purl.org/phylo/treebase/phylows/study/TB2:S15480?format=nexus\"", "Use URL/webservice to obtain a phylogeny", 3);
        boolean nhx_or_nexus = false;
        if (url_string != null && url_string.length() > 0) {
            try {
                url = new URL(url_string);
                PhylogenyParser parser = null;
                parser = url.getHost().toLowerCase().indexOf("tolweb") >= 0 ? new TolParser() : ParserUtils.createParserDependingOnUrlContents(url, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
                if (parser instanceof NexusPhylogeniesParser) {
                    nhx_or_nexus = true;
                } else if (parser instanceof NHXParser) {
                    nhx_or_nexus = true;
                }
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setWaitCursor();
                } else {
                    this._mainpanel.setWaitCursor();
                }
                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                phys = factory.create(url.openStream(), parser);
            }
            catch (MalformedURLException e) {
                JOptionPane.showMessageDialog(this, "Malformed URL: " + url + "\n" + e.getLocalizedMessage(), "Malformed URL", 0);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not read from " + url + "\n" + ForesterUtil.wordWrap(e.getLocalizedMessage(), 80), "Failed to read URL", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, ForesterUtil.wordWrap(e.getLocalizedMessage(), 80), "Unexpected Exception", 0);
            }
            finally {
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setArrowCursor();
                } else {
                    this._mainpanel.setArrowCursor();
                }
            }
            if (phys != null && phys.length > 0) {
                if (nhx_or_nexus && this.getOptions().isInternalNumberAreConfidenceForNhParsing()) {
                    for (Phylogeny phy : phys) {
                        PhylogenyMethods.transferInternalNodeNamesToConfidence(phy, "");
                    }
                }
                AptxUtil.addPhylogeniesToTabs(phys, new File(url.getFile()).getName(), new File(url.getFile()).toString(), this.getConfiguration(), this.getMainPanel());
                this._mainpanel.getControlPanel().showWhole();
            }
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    void setMsa(Msa msa) {
        this._msa = msa;
    }

    void setMsaFile(File msa_file) {
        this._msa_file = msa_file;
    }

    void setSeqs(List<MolecularSequence> seqs) {
        this._seqs = seqs;
    }

    void setSeqsFile(File seqs_file) {
        this._seqs_file = seqs_file;
    }

    public static MainFrameApplication createInstance(Phylogeny[] phys, Configuration config) {
        return new MainFrameApplication(phys, config);
    }

    public static MainFrame createInstance(Phylogeny[] phys, Configuration config, String title, File current_dir) {
        return new MainFrameApplication(phys, config, title, current_dir);
    }

    static MainFrame createInstance(Phylogeny[] phys, Configuration config, String title) {
        return new MainFrameApplication(phys, config, title);
    }

    static MainFrame createInstance(Phylogeny[] phys, String config_file_name, String title) {
        return new MainFrameApplication(phys, config_file_name, title);
    }

    static void warnIfNotPhyloXmlValidation(Configuration c) {
        if (!c.isValidatePhyloXmlAgainstSchema()) {
            JOptionPane.showMessageDialog(null, ForesterUtil.wordWrap("phyloXML XSD-based validation is turned off [enable with line 'validate_against_phyloxml_xsd_schem: true' in configuration file]", 80), "Warning", 2);
        }
    }
}

