/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.text.MaskFormatter;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.io.parsers.tol.TolParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.AsciiHistogram;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class AptxUtil {
    private static final String[] AVAILABLE_FONT_FAMILIES_SORTED = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    public static final Color calculateColorFromString(String str, boolean is_taxonomy) {
        String my_str = str.toUpperCase();
        char first = my_str.charAt(0);
        int second = 32;
        char third = ' ';
        if (my_str.length() > 1) {
            second = is_taxonomy ? my_str.charAt(1) : my_str.charAt(my_str.length() - 1);
            if (is_taxonomy) {
                if (my_str.length() > 2) {
                    third = my_str.indexOf(" ") > 0 ? my_str.charAt(my_str.indexOf(" ") + 1) : my_str.charAt(2);
                }
            } else if (my_str.length() > 2) {
                third = my_str.charAt((my_str.length() - 1) / 2);
            }
        }
        first = AptxUtil.normalizeCharForRGB(first);
        second = AptxUtil.normalizeCharForRGB((char)second);
        third = AptxUtil.normalizeCharForRGB(third);
        if (first > '\u00eb' && second > 235 && third > '\u00eb') {
            first = '\u0000';
        } else if (first < '<' && second < 60 && third < '<') {
            second = 255;
        }
        return new Color(first, second, third);
    }

    public static MaskFormatter createMaskFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return formatter;
    }

    public static final boolean isHasAtLeastNodeWithEvent(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            if (!it.next().getNodeData().isHasEvent()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchLengthLargerThanZero(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            if (!(it.next().getDistanceToParent() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchWithSupportSD(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.getBranchData().isHasConfidences()) continue;
            List<Confidence> c = n.getBranchData().getConfidences();
            for (Confidence confidence : c) {
                if (!(confidence.getStandardDeviation() > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchWithSupportValues(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            if (!it.next().getBranchData().isHasConfidences()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneNodeWithScientificName(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneNodeWithSequenceAnnotation(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.getNodeData().isHasSequence() || ForesterUtil.isEmpty(n.getNodeData().getSequence().getAnnotations())) continue;
            return true;
        }
        return false;
    }

    public static final void launchWebBrowser(URI uri, boolean is_applet, JApplet applet, String frame_name) throws IOException {
        if (is_applet) {
            applet.getAppletContext().showDocument(uri.toURL(), frame_name);
        } else {
            try {
                AptxUtil.openUrlInWebBrowser(uri.toString());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static Set<Taxonomy> obtainAllDistinctTaxonomies(PhylogenyNode node) {
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        HashSet<Taxonomy> tax_set = new HashSet<Taxonomy>();
        for (PhylogenyNode n : descs) {
            if (!n.getNodeData().isHasTaxonomy() || n.getNodeData().getTaxonomy().isEmpty()) continue;
            tax_set.add(n.getNodeData().getTaxonomy());
        }
        return tax_set;
    }

    public static final void printWarningMessage(String name, String message) {
        System.out.println("[" + name + "] > " + message);
    }

    public static final Phylogeny[] readPhylogeniesFromUrl(URL url, boolean phyloxml_validate_against_xsd, boolean replace_underscores, boolean internal_numbers_are_confidences, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction, boolean midpoint_reroot) throws FileNotFoundException, IOException {
        PhylogenyParser parser;
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        boolean nhx_or_nexus = false;
        if (url.getHost().toLowerCase().indexOf("tolweb") >= 0) {
            parser = new TolParser();
        } else {
            parser = ParserUtils.createParserDependingOnUrlContents(url, phyloxml_validate_against_xsd);
            if (parser instanceof NHXParser) {
                nhx_or_nexus = true;
                NHXParser nhx = (NHXParser)parser;
                nhx.setReplaceUnderscores(replace_underscores);
                nhx.setIgnoreQuotes(false);
                nhx.setTaxonomyExtraction(taxonomy_extraction);
            } else if (parser instanceof NexusPhylogeniesParser) {
                nhx_or_nexus = true;
                NexusPhylogeniesParser nex = (NexusPhylogeniesParser)parser;
                nex.setReplaceUnderscores(replace_underscores);
                nex.setIgnoreQuotes(false);
            }
        }
        AptxUtil.printAppletMessage("Archaeopteryx", "parser is " + parser.getName());
        URLConnection url_connection = url.openConnection();
        url_connection.setDefaultUseCaches(false);
        InputStream i = url_connection.getInputStream();
        Phylogeny[] phys = factory.create(i, parser);
        i.close();
        if (phys != null) {
            if (nhx_or_nexus && internal_numbers_are_confidences) {
                for (Phylogeny phy : phys) {
                    PhylogenyMethods.transferInternalNodeNamesToConfidence(phy, "");
                }
            }
            if (midpoint_reroot) {
                for (Phylogeny phy : phys) {
                    PhylogenyMethods.midpointRoot(phy);
                    PhylogenyMethods.orderAppearance(phy.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME);
                }
            }
        }
        return phys;
    }

    public static final void showErrorMessage(Component parent, String error_msg) {
        AptxUtil.printAppletMessage("Archaeopteryx", error_msg);
        JOptionPane.showMessageDialog(parent, error_msg, "[Archaeopteryx 0.9909 experimental] Error", 0);
    }

    public static void writePhylogenyToGraphicsFile(File intree, File outfile, int width, int height, GraphicsExportType type, Configuration config) throws IOException {
        PhylogenyParser parser = ParserUtils.createParserDependingOnFileType(intree, true);
        Phylogeny[] phys = null;
        phys = PhylogenyMethods.readPhylogenies(parser, intree);
        AptxUtil.writePhylogenyToGraphicsFile(phys[0], outfile, width, height, type, config);
    }

    public static void writePhylogenyToGraphicsFile(Phylogeny phy, File outfile, int width, int height, GraphicsExportType type, Configuration config) throws IOException {
        Phylogeny[] phys = new Phylogeny[]{phy};
        MainFrameApplication mf = MainFrameApplication.createInstance(phys, config);
        AptxUtil.writePhylogenyToGraphicsFileNonInteractive(outfile, width, height, mf.getMainPanel().getCurrentTreePanel(), mf.getMainPanel().getControlPanel(), type, mf.getOptions());
        mf.end();
    }

    public static final void writePhylogenyToGraphicsFileNonInteractive(File outfile, int width, int height, TreePanel tree_panel, ControlPanel ac, GraphicsExportType type, Options options) throws IOException {
        tree_panel.calcParametersForPainting(width, height);
        tree_panel.resetPreferredSize();
        tree_panel.repaint();
        RenderingHints rendering_hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        rendering_hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = tree_panel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        if (outfile.isDirectory()) {
            throw new IOException("\"" + outfile + "\" is a directory");
        }
        BufferedImage buffered_img = new BufferedImage(width, height, 1);
        Graphics2D g2d = buffered_img.createGraphics();
        g2d.setRenderingHints(rendering_hints);
        tree_panel.paintPhylogeny(g2d, false, true, width, height, 0, 0);
        if (type == GraphicsExportType.TIFF) {
            AptxUtil.writeToTiff(outfile, buffered_img);
        } else {
            ImageIO.write((RenderedImage)buffered_img, type.toString(), outfile);
        }
        g2d.dispose();
    }

    private static final char normalizeCharForRGB(char c) {
        c = (char)(c - 65);
        c = (char)((c = (char)((double)c * 10.2)) > '\u00ff' ? 255 : (int)c);
        c = c < '\u0000' ? (char)'\u0000' : c;
        return c;
    }

    private static final void openUrlInWebBrowser(String url) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InterruptedException {
        String os = System.getProperty("os.name");
        Runtime runtime = Runtime.getRuntime();
        if (os.toLowerCase().startsWith("win")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (ForesterUtil.isMac()) {
            Class<?> file_mgr = Class.forName("com.apple.eio.FileManager");
            Method open_url = file_mgr.getDeclaredMethod("openURL", String.class);
            open_url.invoke(null, url);
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "mozilla", "netscape", "epiphany"};
            String browser = null;
            for (int i = 0; i < browsers.length && browser == null; ++i) {
                if (runtime.exec(new String[]{"which", browsers[i]}).waitFor() != 0) continue;
                browser = browsers[i];
            }
            if (browser == null) {
                throw new IOException("could not find a web browser to open [" + url + "] in");
            }
            runtime.exec(new String[]{browser, url});
        }
    }

    static final void addPhylogeniesToTabs(Phylogeny[] phys, String default_name, String full_path, Configuration configuration, MainPanel main_panel) {
        if (phys.length > 100) {
            JOptionPane.showMessageDialog(main_panel, "Attempt to load " + phys.length + " phylogenies,\ngoing to load only the first " + 100, "Archaeopteryx more than 100 phylogenies", 2);
        }
        int i = 1;
        for (Phylogeny phy : phys) {
            if (phy.isEmpty() || i > 100) continue;
            String my_name = "";
            String my_name_for_file = "";
            if (phys.length > 1) {
                if (!ForesterUtil.isEmpty(default_name)) {
                    my_name = new String(default_name);
                }
                if (!ForesterUtil.isEmpty(full_path)) {
                    my_name_for_file = new String(full_path);
                } else if (!ForesterUtil.isEmpty(default_name)) {
                    my_name_for_file = new String(default_name);
                }
                String suffix = "";
                if (my_name_for_file.indexOf(46) > 0) {
                    suffix = my_name_for_file.substring(my_name_for_file.lastIndexOf(46), my_name_for_file.length());
                    my_name_for_file = my_name_for_file.substring(0, my_name_for_file.lastIndexOf(46));
                }
                if (!ForesterUtil.isEmpty(my_name_for_file)) {
                    my_name_for_file = my_name_for_file + "_";
                }
                if (!ForesterUtil.isEmpty(phy.getName())) {
                    my_name_for_file = my_name_for_file + phy.getName().replaceAll(" ", "_");
                } else if (phy.getIdentifier() != null) {
                    StringBuffer sb = new StringBuffer();
                    if (!ForesterUtil.isEmpty(phy.getIdentifier().getProvider())) {
                        sb.append(phy.getIdentifier().getProvider());
                        sb.append("_");
                    }
                    sb.append(phy.getIdentifier().getValue());
                    my_name_for_file = my_name_for_file + sb;
                } else {
                    my_name_for_file = my_name_for_file + i;
                }
                if (!ForesterUtil.isEmpty(my_name) && ForesterUtil.isEmpty(phy.getName()) && phy.getIdentifier() == null) {
                    my_name = my_name + " [" + i + "]";
                }
                if (!ForesterUtil.isEmpty(suffix)) {
                    my_name_for_file = my_name_for_file + suffix;
                }
            } else {
                if (!ForesterUtil.isEmpty(default_name)) {
                    my_name = new String(default_name);
                }
                my_name_for_file = "";
                if (!ForesterUtil.isEmpty(full_path)) {
                    my_name_for_file = new String(full_path);
                } else if (!ForesterUtil.isEmpty(default_name)) {
                    my_name_for_file = new String(default_name);
                }
                if (ForesterUtil.isEmpty(my_name_for_file)) {
                    if (!ForesterUtil.isEmpty(phy.getName())) {
                        my_name_for_file = new String(phy.getName()).replaceAll(" ", "_");
                    } else if (phy.getIdentifier() != null) {
                        StringBuffer sb = new StringBuffer();
                        if (!ForesterUtil.isEmpty(phy.getIdentifier().getProvider())) {
                            sb.append(phy.getIdentifier().getProvider());
                            sb.append("_");
                        }
                        sb.append(phy.getIdentifier().getValue());
                        my_name_for_file = new String(sb.toString().replaceAll(" ", "_"));
                    }
                }
            }
            main_panel.addPhylogenyInNewTab(phy, configuration, my_name, full_path);
            main_panel.getCurrentTreePanel().setTreeFile(new File(my_name_for_file));
            AptxUtil.lookAtSomeTreePropertiesForAptxControlSettings(phy, main_panel.getControlPanel(), configuration);
            ++i;
        }
    }

    static final void addPhylogenyToPanel(Phylogeny[] phys, Configuration configuration, MainPanel main_panel) {
        Phylogeny phy = phys[0];
        main_panel.addPhylogenyInPanel(phy, configuration);
        AptxUtil.lookAtSomeTreePropertiesForAptxControlSettings(phy, main_panel.getControlPanel(), configuration);
    }

    static final boolean canWriteFormat(String format_name) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(format_name);
        return iter.hasNext();
    }

    static final String createBasicInformation(Phylogeny phy, File treefile) {
        StringBuilder desc = new StringBuilder();
        if (phy != null && !phy.isEmpty()) {
            DescriptiveStatistics ds;
            String f = null;
            if (treefile != null) {
                try {
                    f = treefile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!ForesterUtil.isEmpty(f)) {
                    desc.append("Path: ");
                    desc.append(f);
                    desc.append("\n");
                }
            }
            if (!ForesterUtil.isEmpty(phy.getName())) {
                desc.append("Name: ");
                desc.append(phy.getName());
                desc.append("\n");
            }
            if (phy.getIdentifier() != null) {
                desc.append("Id: ");
                desc.append(phy.getIdentifier().toString());
                desc.append("\n");
            }
            if (!ForesterUtil.isEmpty(phy.getDescription())) {
                desc.append("Description: ");
                desc.append(phy.getDescription());
                desc.append("\n");
            }
            if (!ForesterUtil.isEmpty(phy.getDistanceUnit())) {
                desc.append("Distance Unit: ");
                desc.append(phy.getDistanceUnit());
                desc.append("\n");
            }
            if (!ForesterUtil.isEmpty(phy.getType())) {
                desc.append("Type: ");
                desc.append(phy.getType());
                desc.append("\n");
            }
            desc.append("Rooted: ");
            desc.append(phy.isRooted());
            desc.append("\n");
            desc.append("Rerootable: ");
            desc.append(phy.isRerootable());
            desc.append("\n");
            desc.append("Nodes: ");
            desc.append(phy.getNodeCount());
            desc.append("\n");
            desc.append("External nodes: ");
            desc.append(phy.getNumberOfExternalNodes());
            desc.append("\n");
            desc.append("Internal nodes: ");
            desc.append(phy.getNodeCount() - phy.getNumberOfExternalNodes());
            desc.append("\n");
            desc.append("Internal nodes with polytomies: ");
            desc.append(PhylogenyMethods.countNumberOfPolytomies(phy));
            desc.append("\n");
            desc.append("Branches: ");
            desc.append(phy.getNumberOfBranches());
            desc.append("\n");
            desc.append("Depth: ");
            desc.append(PhylogenyMethods.calculateMaxDepth(phy));
            desc.append("\n");
            desc.append("Maximum distance to root: ");
            desc.append(ForesterUtil.round(PhylogenyMethods.calculateMaxDistanceToRoot(phy), 6));
            desc.append("\n");
            Set<Taxonomy> taxs = AptxUtil.obtainAllDistinctTaxonomies(phy.getRoot());
            if (taxs != null) {
                desc.append("Distinct external taxonomies: ");
                desc.append(taxs.size());
            }
            for (Taxonomy t : taxs) {
                System.out.println(t.toString());
            }
            desc.append("\n");
            DescriptiveStatistics bs = PhylogenyMethods.calculateBranchLengthStatistics(phy);
            if (bs.getN() > 3) {
                desc.append("\n");
                desc.append("Branch-length statistics: ");
                desc.append("\n");
                desc.append("    Number of branches with non-negative branch-lengths: " + bs.getN());
                desc.append("\n");
                desc.append("    Median: " + ForesterUtil.round(bs.median(), 6));
                desc.append("\n");
                desc.append("    Mean: " + ForesterUtil.round(bs.arithmeticMean(), 6) + " (stdev: " + ForesterUtil.round(bs.sampleStandardDeviation(), 6) + ")");
                desc.append("\n");
                desc.append("    Minimum: " + ForesterUtil.round(bs.getMin(), 6));
                desc.append("\n");
                desc.append("    Maximum: " + ForesterUtil.round(bs.getMax(), 6));
                desc.append("\n");
                if (Math.abs(bs.getMax() - bs.getMin()) > 1.0E-4) {
                    desc.append("\n");
                    AsciiHistogram histo = new AsciiHistogram(bs);
                    desc.append(histo.toStringBuffer(12, '#', 40, 7, "    "));
                }
            }
            if ((ds = PhylogenyMethods.calculateNumberOfDescendantsPerNodeStatistics(phy)).getN() > 2) {
                desc.append("\n");
                desc.append("Descendants per node statistics: ");
                desc.append("\n");
                desc.append("    Median: " + ForesterUtil.round(ds.median(), 6));
                desc.append("\n");
                desc.append("    Mean: " + ForesterUtil.round(ds.arithmeticMean(), 6) + " (stdev: " + ForesterUtil.round(ds.sampleStandardDeviation(), 6) + ")");
                desc.append("\n");
                desc.append("    Minimum: " + ForesterUtil.roundToInt(ds.getMin()));
                desc.append("\n");
                desc.append("    Maximum: " + ForesterUtil.roundToInt(ds.getMax()));
                desc.append("\n");
            }
            List<DescriptiveStatistics> css = null;
            try {
                css = PhylogenyMethods.calculateConfidenceStatistics(phy);
            }
            catch (IllegalArgumentException e) {
                ForesterUtil.printWarningMessage("Archaeopteryx", e.getMessage());
            }
            if (css != null && css.size() > 0) {
                desc.append("\n");
                for (int i = 0; i < css.size(); ++i) {
                    DescriptiveStatistics cs = css.get(i);
                    if (cs == null || cs.getN() <= 1) continue;
                    if (css.size() > 1) {
                        desc.append("Support statistics " + (i + 1) + ": ");
                    } else {
                        desc.append("Support statistics: ");
                    }
                    if (!ForesterUtil.isEmpty(cs.getDescription())) {
                        desc.append("\n");
                        desc.append("    Type: " + cs.getDescription());
                    }
                    desc.append("\n");
                    desc.append("    Branches with support: " + cs.getN());
                    desc.append("\n");
                    desc.append("    Median: " + ForesterUtil.round(cs.median(), 6));
                    desc.append("\n");
                    desc.append("    Mean: " + ForesterUtil.round(cs.arithmeticMean(), 6));
                    if (cs.getN() > 2) {
                        desc.append(" (stdev: " + ForesterUtil.round(cs.sampleStandardDeviation(), 6) + ")");
                    }
                    desc.append("\n");
                    desc.append("    Minimum: " + ForesterUtil.round(cs.getMin(), 6));
                    desc.append("\n");
                    desc.append("    Maximum: " + ForesterUtil.round(cs.getMax(), 6));
                    desc.append("\n");
                }
            }
        }
        return desc.toString();
    }

    static final void dieWithSystemError(String message) {
        System.out.println();
        System.out.println("Archaeopteryx encountered the following system error: " + message);
        System.out.println("Please contact the authors.");
        System.out.println("Archaeopteryx needs to close.");
        System.out.println();
        System.exit(-1);
    }

    static final String[] getAllPossibleRanks() {
        String[] str_array = new String[PhyloXmlUtil.TAXONOMY_RANKS_LIST.size() - 2];
        int i = 0;
        for (String e : PhyloXmlUtil.TAXONOMY_RANKS_LIST) {
            if (e.equals("unknown") || e.equals("other")) continue;
            str_array[i++] = e;
        }
        return str_array;
    }

    static final String[] getAllRanks(Phylogeny tree) {
        TreeSet<String> ranks = new TreeSet<String>();
        PhylogenyNodeIterator it = tree.iteratorPreorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getRank())) continue;
            ranks.add(n.getNodeData().getTaxonomy().getRank());
        }
        return ForesterUtil.stringSetToArray(ranks);
    }

    static final String[] getAvailableFontFamiliesSorted() {
        return AVAILABLE_FONT_FAMILIES_SORTED;
    }

    static final boolean isUsOrCanada() {
        try {
            if (Locale.getDefault().equals(Locale.CANADA) || Locale.getDefault().equals(Locale.US)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    static final void lookAtSomeTreePropertiesForAptxControlSettings(Phylogeny t, ControlPanel atv_control, Configuration configuration) {
        if (t != null && !t.isEmpty()) {
            if (!AptxUtil.isHasAtLeastOneBranchLengthLargerThanZero(t)) {
                atv_control.setDrawPhylogram(false);
                atv_control.setDrawPhylogramEnabled(false);
            }
            if (configuration.doGuessCheckOption(0) && atv_control.getDisplayAsPhylogramCb() != null) {
                if (AptxUtil.isHasAtLeastOneBranchLengthLargerThanZero(t)) {
                    atv_control.setDrawPhylogram(true);
                    atv_control.setDrawPhylogramEnabled(true);
                } else {
                    atv_control.setDrawPhylogram(false);
                }
            }
            if (configuration.doGuessCheckOption(4) && atv_control.getWriteConfidenceCb() != null) {
                if (AptxUtil.isHasAtLeastOneBranchWithSupportValues(t)) {
                    atv_control.setCheckbox(4, true);
                } else {
                    atv_control.setCheckbox(4, false);
                }
            }
            if (configuration.doGuessCheckOption(5) && atv_control.getShowEventsCb() != null) {
                if (AptxUtil.isHasAtLeastNodeWithEvent(t)) {
                    atv_control.setCheckbox(5, true);
                } else {
                    atv_control.setCheckbox(5, false);
                }
            }
        }
    }

    static final void openWebsite(String url, boolean is_applet, JApplet applet) throws IOException {
        try {
            AptxUtil.launchWebBrowser(new URI(url), is_applet, applet, "Archaeopteryx");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static final void outOfMemoryError(OutOfMemoryError e) {
        System.err.println();
        System.err.println("Java memory allocation might be too small, try \"-Xmx2048m\" java command line option");
        System.err.println();
        e.printStackTrace();
        System.err.println();
        JOptionPane.showMessageDialog(null, "Java memory allocation might be too small, try \"-Xmx2048m\" java command line option\n\nError: " + e.getLocalizedMessage(), "Out of Memory Error [Archaeopteryx 0.9909 experimental]", 0);
        System.exit(-1);
    }

    static final void printAppletMessage(String applet_name, String message) {
        System.out.println("[" + applet_name + "] > " + message);
    }

    static final void removeBranchColors(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPreorder();
        while (it.hasNext()) {
            it.next().getBranchData().setBranchColor(null);
        }
    }

    static final void removeVisualStyles(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPreorder();
        while (it.hasNext()) {
            it.next().getNodeData().setNodeVisualData(null);
        }
    }

    static final void unexpectedError(Error e) {
        System.err.println();
        e.printStackTrace(System.err);
        System.err.println();
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement s : e.getStackTrace()) {
            sb.append(s + "\n");
        }
        JOptionPane.showMessageDialog(null, "An unexpected (possibly severe) error has occured - terminating. \nPlease contact: phyloxml@gmail.com \nError: " + e.getLocalizedMessage() + "\n" + sb, "Unexpected Severe Error [Archaeopteryx 0.9909 experimental]", 0);
        System.exit(-1);
    }

    static final void unexpectedException(Exception e) {
        System.err.println();
        e.printStackTrace(System.err);
        System.err.println();
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement s : e.getStackTrace()) {
            sb.append(s + "\n");
        }
        JOptionPane.showMessageDialog(null, "An unexpected exception has occured. \nPlease contact: phyloxml@gmail.com \nException: " + e.getLocalizedMessage() + "\n" + sb, "Unexpected Exception [Archaeopteryx0.9909 experimental]", 0);
    }

    static final String writePhylogenyToGraphicsByteArrayOutputStream(ByteArrayOutputStream baos, int width, int height, TreePanel tree_panel, ControlPanel ac, GraphicsExportType type, Options options) throws IOException {
        if (!options.isGraphicsExportUsingActualSize()) {
            if (options.isGraphicsExportVisibleOnly()) {
                throw new IllegalArgumentException("cannot export visible rectangle only without exporting in actual size");
            }
            tree_panel.calcParametersForPainting(options.getPrintSizeX(), options.getPrintSizeY());
            tree_panel.resetPreferredSize();
            tree_panel.repaint();
        }
        RenderingHints rendering_hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        rendering_hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = tree_panel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        Rectangle visible = null;
        if (!options.isGraphicsExportUsingActualSize()) {
            width = options.getPrintSizeX();
            height = options.getPrintSizeY();
        } else if (options.isGraphicsExportVisibleOnly()) {
            visible = tree_panel.getVisibleRect();
            width = visible.width;
            height = visible.height;
        }
        BufferedImage buffered_img = new BufferedImage(width, height, 1);
        Graphics2D g2d = buffered_img.createGraphics();
        g2d.setRenderingHints(rendering_hints);
        int x = 0;
        int y = 0;
        if (options.isGraphicsExportVisibleOnly()) {
            g2d = (Graphics2D)g2d.create(-visible.x, -visible.y, visible.width, visible.height);
            g2d.setClip(null);
            x = visible.x;
            y = visible.y;
        }
        tree_panel.paintPhylogeny(g2d, false, true, width, height, x, y);
        ImageIO.write((RenderedImage)buffered_img, type.toString(), baos);
        g2d.dispose();
        System.gc();
        if (!options.isGraphicsExportUsingActualSize()) {
            tree_panel.getMainPanel().getControlPanel().showWhole();
        }
        String msg = baos.toString();
        if (width > 0 && height > 0) {
            msg = msg + " [size: " + width + ", " + height + "]";
        }
        return msg;
    }

    static final String writePhylogenyToGraphicsFile(String file_name, int width, int height, TreePanel tree_panel, ControlPanel ac, GraphicsExportType type, Options options) throws IOException {
        if (!options.isGraphicsExportUsingActualSize()) {
            if (options.isGraphicsExportVisibleOnly()) {
                throw new IllegalArgumentException("cannot export visible rectangle only without exporting in actual size");
            }
            tree_panel.calcParametersForPainting(options.getPrintSizeX(), options.getPrintSizeY());
            tree_panel.resetPreferredSize();
            tree_panel.repaint();
        }
        RenderingHints rendering_hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        rendering_hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = tree_panel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        File file = new File(file_name);
        if (file.isDirectory()) {
            throw new IOException("\"" + file_name + "\" is a directory");
        }
        Rectangle visible = null;
        if (!options.isGraphicsExportUsingActualSize()) {
            width = options.getPrintSizeX();
            height = options.getPrintSizeY();
        } else if (options.isGraphicsExportVisibleOnly()) {
            visible = tree_panel.getVisibleRect();
            width = visible.width;
            height = visible.height;
        }
        BufferedImage buffered_img = new BufferedImage(width, height, 1);
        Graphics2D g2d = buffered_img.createGraphics();
        g2d.setRenderingHints(rendering_hints);
        int x = 0;
        int y = 0;
        if (options.isGraphicsExportVisibleOnly()) {
            g2d = (Graphics2D)g2d.create(-visible.x, -visible.y, visible.width, visible.height);
            g2d.setClip(null);
            x = visible.x;
            y = visible.y;
        }
        tree_panel.paintPhylogeny(g2d, false, true, width, height, x, y);
        if (type == GraphicsExportType.TIFF) {
            AptxUtil.writeToTiff(file, buffered_img);
        } else {
            ImageIO.write((RenderedImage)buffered_img, type.toString(), file);
        }
        g2d.dispose();
        System.gc();
        if (!options.isGraphicsExportUsingActualSize()) {
            tree_panel.getMainPanel().getControlPanel().showWhole();
        }
        String msg = file.toString();
        if (width > 0 && height > 0) {
            msg = msg + " [size: " + width + ", " + height + "]";
        }
        return msg;
    }

    static final void writeToTiff(File file, BufferedImage image) throws IOException {
        String[] t;
        ImageWriter writer = null;
        ImageOutputStream ios = null;
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("TIF");
        if (!it.hasNext()) {
            throw new IOException("failed to get TIFF image writer");
        }
        writer = it.next();
        ios = ImageIO.createImageOutputStream(file);
        writer.setOutput(ios);
        ImageWriteParam image_write_param = new ImageWriteParam(Locale.getDefault());
        image_write_param.setCompressionMode(2);
        image_write_param.setCompressionType("PackBits");
        for (String string : t = image_write_param.getCompressionTypes()) {
            System.out.println(string);
        }
        IIOImage iio_image = new IIOImage(image, null, null);
        writer.write(null, iio_image, image_write_param);
    }

    static {
        Arrays.sort(AVAILABLE_FONT_FAMILIES_SORTED);
    }

    public static enum GraphicsExportType {
        BMP("bmp"),
        GIF("gif"),
        JPG("jpg"),
        PDF("pdf"),
        PNG("png"),
        TIFF("tif");

        private final String _suffix;

        private GraphicsExportType(String suffix) {
            this._suffix = suffix;
        }

        public String toString() {
            return this._suffix;
        }
    }
}

