/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.nettosphere.StreamWriter;
import org.atmosphere.nettosphere.util.Utils;
import org.atmosphere.util.ByteArrayAsyncWriter;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelWriter
extends AtmosphereInterceptorWriter {
    protected static final Logger logger = LoggerFactory.getLogger(StreamWriter.class);
    protected static final String END = Integer.toHexString(0);
    protected static final String CRLF = "\r\n";
    protected static final byte[] CHUNK_DELIMITER = "\r\n".getBytes();
    protected static final byte[] ENDCHUNK = (END + "\r\n" + "\r\n").getBytes();
    protected final Channel channel;
    protected final AtomicBoolean doneProcessing = new AtomicBoolean(false);
    protected final ByteArrayAsyncWriter transformCacheBuffer = new ByteArrayAsyncWriter();
    protected final boolean writeHeader;
    protected long lastWrite = 0L;
    protected boolean keepAlive;

    public ChannelWriter(Channel channel, boolean writeHeader, boolean keepAlive) {
        this.channel = channel;
        this.writeHeader = writeHeader;
        this.keepAlive = keepAlive;
    }

    public boolean isClosed() {
        return this.doneProcessing.get();
    }

    public AsyncIOWriter writeError(AtmosphereResponse response, int errorCode, String message) throws IOException {
        if (!this.channel.isOpen()) {
            return this;
        }
        try {
            DefaultHttpResponse r = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)errorCode));
            this.channel.write((Object)r).addListener(ChannelFutureListener.CLOSE);
        }
        catch (Throwable ex) {
            logger.debug("", ex);
        }
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse response, String data) throws IOException {
        byte[] b = data.getBytes("ISO-8859-1");
        this.write(response, b);
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse response, byte[] data) throws IOException {
        this.write(response, data, 0, data.length);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] transform(AtmosphereResponse response, byte[] b, int offset, int length) throws IOException {
        AsyncIOWriter a = response.getAsyncIOWriter();
        try {
            response.asyncIOWriter((AsyncIOWriter)this.transformCacheBuffer);
            this.invokeInterceptor(response, b, offset, length);
            byte[] byArray = this.transformCacheBuffer.stream().toByteArray();
            return byArray;
        }
        finally {
            this.transformCacheBuffer.close(null);
            response.asyncIOWriter(a);
        }
    }

    public AsyncIOWriter write(AtmosphereResponse response, byte[] data, int offset, int length) throws IOException {
        boolean transform;
        if (this.doneProcessing.get()) {
            throw Utils.ioExceptionForChannel(this.channel, response.uuid());
        }
        boolean bl = transform = this.filters.size() > 0 && response.getStatus() < 400;
        if (transform) {
            data = this.transform(response, data, offset, length);
            offset = 0;
            length = data.length;
        }
        logger.trace("About to write to {}", (Object)this.channel);
        if (!this.channel.isOpen()) {
            logger.trace("Trying to write on a closed channel {}", (Object)this.channel);
            throw new IOException("Channel closed");
        }
        this.asyncWrite(response, data, offset, length);
        return this;
    }

    public long lastTick() {
        return this.lastWrite == -1L ? System.currentTimeMillis() : this.lastWrite;
    }

    protected String constructStatusAndHeaders(AtmosphereResponse response, int contentLength) {
        StringBuffer b = new StringBuffer("HTTP/1.1").append(" ").append(response.getStatus()).append(" ").append(response.getStatusMessage()).append(CRLF);
        Map headers = response.headers();
        String contentType = response.getContentType();
        b.append("Content-Type").append(":").append(headers.get("Content-Type") == null ? contentType : (String)headers.get("Content-Type")).append(CRLF);
        if (contentLength != -1) {
            b.append("Content-Length").append(":").append(contentLength).append(CRLF);
        }
        for (String s : headers.keySet()) {
            if (s.equalsIgnoreCase("Content-Type")) continue;
            b.append(s).append(":").append((String)headers.get(s)).append(CRLF);
        }
        b.append(CRLF);
        return b.toString();
    }

    public abstract AsyncIOWriter asyncWrite(AtmosphereResponse var1, byte[] var2, int var3, int var4) throws IOException;
}

