/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.io.ByteSource;
import java.io.IOException;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.guava.error.ShouldHaveSize;

public class ByteSourceAssert
extends AbstractAssert<ByteSourceAssert, ByteSource> {
    @VisibleForTesting
    Failures failures = Failures.instance();

    protected ByteSourceAssert(ByteSource actual) {
        super((Object)actual, ByteSourceAssert.class);
    }

    public ByteSourceAssert hasSameContentAs(ByteSource other) throws IOException {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((ByteSource)this.actual).contentEquals(other)) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeEqual.shouldBeEqual((Object)this.actual, (Object)other, (Representation)new StandardRepresentation()));
        }
        return this;
    }

    public void isEmpty() throws IOException {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((ByteSource)this.actual).isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
    }

    public ByteSourceAssert hasSize(long expectedSize) throws IOException {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        long sizeOfActual = ((ByteSource)this.actual).size();
        if (sizeOfActual != expectedSize) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSize.shouldHaveSize(this.actual, sizeOfActual, expectedSize));
        }
        return this;
    }
}

