/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Source;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.util.NameComparator;

public class Table
extends AbstractDbData<Table> {
    private String name;
    private List<String> columnsList;
    private String[] columnsToCheck;
    private String[] columnsToExclude;
    private Order[] columnsToOrder;
    private Character startDelimiter = null;
    private Character endDelimiter = null;

    public Table() {
        super(Table.class, DataType.TABLE);
    }

    public Table(Source source, String name) {
        this(source, name, (String[])null, (String[])null);
    }

    public Table(Source source, String name, String[] columnsToCheck, String[] columnsToExclude) {
        this(source, name, null, columnsToCheck, columnsToExclude);
    }

    public Table(DataSource dataSource, String name) {
        this(dataSource, name, (String[])null, (String[])null);
    }

    public Table(DataSource dataSource, String name, String[] columnsToCheck, String[] columnsToExclude) {
        this(dataSource, name, null, columnsToCheck, columnsToExclude);
    }

    public Table(Source source, String name, Order[] columnsToOrder) {
        this(source, name, columnsToOrder, null, null);
    }

    public Table(Source source, String name, Order[] columnsToOrder, String[] columnsToCheck, String[] columnsToExclude) {
        this(source, name, null, null, columnsToOrder, columnsToCheck, columnsToExclude);
    }

    public Table(DataSource dataSource, String name, Order[] columnsToOrder) {
        this(dataSource, name, columnsToOrder, null, null);
    }

    public Table(DataSource dataSource, String name, Order[] columnsToOrder, String[] columnsToCheck, String[] columnsToExclude) {
        this(dataSource, name, null, null, columnsToOrder, columnsToCheck, columnsToExclude);
    }

    public Table(Source source, String name, Character startDelimiter, Character endDelimiter) {
        this(source, name, startDelimiter, endDelimiter, null, null, null);
    }

    public Table(Source source, String name, Character startDelimiter, Character endDelimiter, String[] columnsToCheck, String[] columnsToExclude) {
        this(source, name, startDelimiter, endDelimiter, null, columnsToCheck, columnsToExclude);
    }

    public Table(DataSource dataSource, String name, Character startDelimiter, Character endDelimiter) {
        this(dataSource, name, startDelimiter, endDelimiter, null, null, null);
    }

    public Table(DataSource dataSource, String name, Character startDelimiter, Character endDelimiter, String[] columnsToCheck, String[] columnsToExclude) {
        this(dataSource, name, startDelimiter, endDelimiter, null, columnsToCheck, columnsToExclude);
    }

    public Table(Source source, String name, Character startDelimiter, Character endDelimiter, Order[] columnsToOrder) {
        this(source, name, startDelimiter, endDelimiter, columnsToOrder, null, null);
    }

    public Table(Source source, String name, Character startDelimiter, Character endDelimiter, Order[] columnsToOrder, String[] columnsToCheck, String[] columnsToExclude) {
        super(Table.class, DataType.TABLE, source);
        this.setName(name);
        this.setStartDelimiter(startDelimiter);
        this.setEndDelimiter(endDelimiter);
        this.setColumnsToOrder(columnsToOrder);
        this.setColumnsToCheck(columnsToCheck);
        this.setColumnsToExclude(columnsToExclude);
    }

    public Table(DataSource dataSource, String name, Character startDelimiter, Character endDelimiter, Order[] columnsToOrder) {
        this(dataSource, name, startDelimiter, endDelimiter, columnsToOrder, null, null);
    }

    public Table(DataSource dataSource, String name, Character startDelimiter, Character endDelimiter, Order[] columnsToOrder, String[] columnsToCheck, String[] columnsToExclude) {
        super(Table.class, DataType.TABLE, dataSource);
        this.setName(name);
        this.setStartDelimiter(startDelimiter);
        this.setEndDelimiter(endDelimiter);
        this.setColumnsToOrder(columnsToOrder);
        this.setColumnsToCheck(columnsToCheck);
        this.setColumnsToExclude(columnsToExclude);
    }

    public String getName() {
        return this.name;
    }

    public Table setName(String name) {
        if (name == null) {
            throw new NullPointerException("name can not be null");
        }
        this.name = name;
        this.setNameFromDb();
        return this;
    }

    @Override
    public Table setDataSource(DataSource dataSource) {
        Table table = (Table)super.setDataSource(dataSource);
        this.setNameFromDb();
        return table;
    }

    @Override
    public Table setSource(Source source) {
        Table table = (Table)super.setSource(source);
        this.setNameFromDb();
        return table;
    }

    private void setNameFromDb() {
        if (this.name != null && (this.getSource() != null || this.getDataSource() != null)) {
            try (Connection connection = this.getConnection();){
                LetterCase tableLetterCase = this.getTableLetterCase();
                LetterCase columnLetterCase = this.getColumnLetterCase();
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet tableResultSet = metaData.getTables(Table.getCatalog(connection), Table.getSchema(connection), null, new String[]{"TABLE"});){
                    while (tableResultSet.next()) {
                        String tableName = tableResultSet.getString("TABLE_NAME");
                        if (!tableLetterCase.isEqual(tableName, this.name)) continue;
                        this.name = tableLetterCase.convert(tableName);
                        break;
                    }
                }
                this.columnsList = new ArrayList<String>();
                var7_10 = null;
                try (ResultSet columnsResultSet = metaData.getColumns(Table.getCatalog(connection), Table.getSchema(connection), this.name, null);){
                    while (columnsResultSet.next()) {
                        String column = columnsResultSet.getString("COLUMN_NAME");
                        this.columnsList.add(columnLetterCase.convert(column));
                    }
                }
                catch (Throwable throwable) {
                    var7_10 = throwable;
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new AssertJDBException(e);
            }
        }
    }

    public String[] getColumnsToCheck() {
        if (this.columnsToCheck == null) {
            return null;
        }
        return (String[])this.columnsToCheck.clone();
    }

    public Table setColumnsToCheck(String[] columnsToCheck) {
        if (this.columnsList == null) {
            throw new AssertJDBException("The table name and the source or datasource must be set first", new Object[0]);
        }
        if (columnsToCheck != null) {
            LetterCase letterCase = this.getColumnLetterCase();
            ArrayList<String> columnsToCheckList = new ArrayList<String>();
            for (int index = 0; index < columnsToCheck.length; ++index) {
                String column = columnsToCheck[index];
                if (column == null) {
                    throw new NullPointerException("The name of the column can not be null");
                }
                int indexOf = NameComparator.INSTANCE.indexOf(this.columnsList, column, letterCase);
                if (indexOf == -1) continue;
                columnsToCheckList.add(this.columnsList.get(indexOf));
            }
            this.columnsToCheck = columnsToCheckList.toArray(new String[0]);
        } else {
            this.columnsToCheck = null;
        }
        return this;
    }

    public String[] getColumnsToExclude() {
        if (this.columnsToExclude == null) {
            return null;
        }
        return (String[])this.columnsToExclude.clone();
    }

    public Table setColumnsToExclude(String[] columnsToExclude) {
        if (this.columnsList == null) {
            throw new AssertJDBException("The table name and the source or datasource must be set first", new Object[0]);
        }
        if (columnsToExclude != null) {
            LetterCase letterCase = this.getColumnLetterCase();
            this.columnsToExclude = new String[columnsToExclude.length];
            ArrayList<String> columnsToExcludeList = new ArrayList<String>();
            for (int index = 0; index < columnsToExclude.length; ++index) {
                String column = columnsToExclude[index];
                if (column == null) {
                    throw new NullPointerException("The name of the column can not be null");
                }
                int indexOf = NameComparator.INSTANCE.indexOf(this.columnsList, column, letterCase);
                if (indexOf == -1) continue;
                columnsToExcludeList.add(this.columnsList.get(indexOf));
            }
            this.columnsToExclude = columnsToExcludeList.toArray(new String[0]);
        } else {
            this.columnsToExclude = null;
        }
        return this;
    }

    public Order[] getColumnsToOrder() {
        if (this.columnsToOrder == null) {
            return null;
        }
        return (Order[])this.columnsToOrder.clone();
    }

    public Table setColumnsToOrder(Order[] columnsToOrder) {
        if (this.columnsList == null) {
            throw new AssertJDBException("The table name and the source or datasource must be set first", new Object[0]);
        }
        if (columnsToOrder != null) {
            LetterCase letterCase = this.getColumnLetterCase();
            this.columnsToOrder = new Order[columnsToOrder.length];
            ArrayList<Order> columnsToOrderList = new ArrayList<Order>();
            for (int index = 0; index < columnsToOrder.length; ++index) {
                Order order = columnsToOrder[index];
                if (order == null) {
                    throw new NullPointerException("The order can not be null");
                }
                String column = order.getName();
                if (column == null) {
                    throw new NullPointerException("The name of the column for order can not be null");
                }
                int indexOf = NameComparator.INSTANCE.indexOf(this.columnsList, column, letterCase);
                if (indexOf == -1) continue;
                String columnName = this.columnsList.get(indexOf);
                columnsToOrderList.add(Order.getOrder(columnName, order.getType()));
            }
            this.columnsToOrder = columnsToOrderList.toArray(new Order[0]);
        } else {
            this.columnsToOrder = null;
        }
        return this;
    }

    public Character getStartDelimiter() {
        return this.startDelimiter;
    }

    public Table setStartDelimiter(Character startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public Character getEndDelimiter() {
        return this.endDelimiter;
    }

    public Table setEndDelimiter(Character endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    private String encode(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.startDelimiter != null) {
            stringBuilder.append(this.startDelimiter);
        }
        stringBuilder.append(name);
        if (this.endDelimiter != null) {
            stringBuilder.append(this.endDelimiter);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getRequest() {
        if (this.name == null) {
            throw new NullPointerException("name can not be null");
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.columnsToCheck == null) {
            stringBuilder.append("*");
        } else {
            for (String column : this.columnsToCheck) {
                if (stringBuilder.length() > 7) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.encode(column));
            }
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.encode(this.name));
        if (this.columnsToOrder != null) {
            for (int index = 0; index < this.columnsToOrder.length; ++index) {
                if (index == 0) {
                    stringBuilder.append(" ORDER BY ");
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.encode(this.columnsToOrder[index].getName()));
                if (this.columnsToOrder[index].getType() != Order.OrderType.DESC) continue;
                stringBuilder.append(" DESC");
            }
        }
        return stringBuilder.toString();
    }

    private void collectColumnsNameFromResultSet(ResultSet resultSet) throws SQLException {
        LetterCase letterCase = this.getColumnLetterCase();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<String> columnsNameList = new ArrayList<String>();
        List<String> columnsToExcludeList = null;
        if (this.columnsToExclude != null) {
            columnsToExcludeList = Arrays.asList(this.columnsToExclude);
        }
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnName = letterCase.convert(resultSetMetaData.getColumnLabel(i));
            if (columnsToExcludeList != null && NameComparator.INSTANCE.contains(columnsToExcludeList, columnName, letterCase)) continue;
            columnsNameList.add(columnName);
        }
        this.setColumnsNameList(columnsNameList);
    }

    private void collectPrimaryKeyName(Connection connection) throws SQLException {
        LetterCase letterCase;
        String catalog = Table.getCatalog(connection);
        String schema = Table.getSchema(connection);
        ArrayList<String> pksNameList = new ArrayList<String>();
        DatabaseMetaData metaData = connection.getMetaData();
        String tableName = this.name;
        try (ResultSet resultSet = metaData.getTables(catalog, schema, null, new String[]{"TABLE"});){
            letterCase = this.getTableLetterCase();
            while (resultSet.next()) {
                String tableResult = resultSet.getString("TABLE_NAME");
                if (!letterCase.isEqual(tableName, tableResult)) continue;
                tableName = tableResult;
                break;
            }
        }
        resultSet = metaData.getPrimaryKeys(catalog, schema, tableName);
        var8_8 = null;
        try {
            letterCase = this.getPrimaryKeyLetterCase();
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                if (!NameComparator.INSTANCE.contains(this.getColumnsNameList(), columnName, letterCase)) continue;
                String pkName = letterCase.convert(columnName);
                pksNameList.add(pkName);
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (var8_8 != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        this.setPksNameList(pksNameList);
    }

    @Override
    protected void loadImpl(Connection connection) throws SQLException {
        if (this.name == null) {
            throw new NullPointerException("name can not be null");
        }
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getRequest());){
            this.collectColumnsNameFromResultSet(resultSet);
            this.collectRowsFromResultSet(resultSet);
        }
        this.collectPrimaryKeyName(connection);
        if (this.columnsToOrder == null) {
            this.sortRows();
        }
    }

    public static class Order {
        private String name;
        private OrderType type;

        public static Order asc(String name) {
            return Order.getOrder(name, OrderType.ASC);
        }

        public static Order desc(String name) {
            return Order.getOrder(name, OrderType.DESC);
        }

        private static Order getOrder(String name, OrderType type) {
            return new Order(name, type);
        }

        private Order(String name, OrderType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public OrderType getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Order) {
                Order order = (Order)obj;
                if (order.type == this.type && (this.name == null && order.name == null || this.name != null && this.name.equals(order.name))) {
                    return true;
                }
            }
            return false;
        }

        public static enum OrderType {
            ASC,
            DESC;

        }
    }
}

