/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.internal.cglib.proxy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.assertj.db.internal.cglib.asm.$ClassReader;
import org.assertj.db.internal.cglib.asm.$ClassVisitor;
import org.assertj.db.internal.cglib.asm.$MethodVisitor;
import org.assertj.db.internal.cglib.core.Signature;

class BridgeMethodResolver {
    private final Map declToBridge;
    private final ClassLoader classLoader;

    public BridgeMethodResolver(Map declToBridge, ClassLoader classLoader) {
        this.declToBridge = declToBridge;
        this.classLoader = classLoader;
    }

    public Map resolveAll() {
        HashMap resolved = new HashMap();
        for (Map.Entry entry : this.declToBridge.entrySet()) {
            Class owner = (Class)entry.getKey();
            Set bridges = (Set)entry.getValue();
            try {
                new $ClassReader(this.classLoader.getResourceAsStream(owner.getName().replace('.', '/') + ".class")).accept(new BridgedFinder(bridges, resolved), 6);
            }
            catch (IOException iOException) {}
        }
        return resolved;
    }

    private static class BridgedFinder
    extends $ClassVisitor {
        private Map resolved;
        private Set eligibleMethods;
        private Signature currentMethod = null;

        BridgedFinder(Set eligibleMethods, Map resolved) {
            super(327680);
            this.resolved = resolved;
            this.eligibleMethods = eligibleMethods;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public $MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Signature sig = new Signature(name, desc);
            if (this.eligibleMethods.remove(sig)) {
                this.currentMethod = sig;
                return new $MethodVisitor(327680){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (opcode == 183 && BridgedFinder.this.currentMethod != null) {
                            Signature target = new Signature(name, desc);
                            if (!target.equals(BridgedFinder.this.currentMethod)) {
                                BridgedFinder.this.resolved.put(BridgedFinder.this.currentMethod, target);
                            }
                            BridgedFinder.this.currentMethod = null;
                        }
                    }
                };
            }
            return null;
        }
    }
}

