/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.assertj.db.api.ErrorCollector;
import org.assertj.db.api.ProxifyPositionResult;
import org.assertj.db.internal.cglib.proxy.Callback;
import org.assertj.db.internal.cglib.proxy.CallbackFilter;
import org.assertj.db.internal.cglib.proxy.Enhancer;

class SoftProxies {
    private final ErrorCollector collector = new ErrorCollector();

    SoftProxies() {
    }

    List<Throwable> errorsCollected() {
        return this.collector.errors();
    }

    <V, T> V create(Class<V> assertClass, Class<T> actualClass, T actual) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(assertClass);
        enhancer.setCallbackFilter(CollectErrorsOrCreateExtractedProxy.FILTER);
        enhancer.setCallbacks(new Callback[]{this.collector, new ProxifyPositionResult(this)});
        return (V)enhancer.create((Class[])org.assertj.core.util.Arrays.array((Object[])new Class[]{actualClass}), org.assertj.core.util.Arrays.array((Object[])new Object[]{actual}));
    }

    <V> V create(Class<V> assertClass, Class[] paramClass, Object[] params) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(assertClass);
        enhancer.setCallbackFilter(CollectErrorsOrCreateExtractedProxy.FILTER);
        enhancer.setCallbacks(new Callback[]{this.collector, new ProxifyPositionResult(this)});
        return (V)enhancer.create(paramClass, params);
    }

    public boolean wasSuccess() {
        return this.collector.wasSuccess();
    }

    private static enum CollectErrorsOrCreateExtractedProxy implements CallbackFilter
    {
        FILTER;


        @Override
        public int accept(Method method) {
            return this.isPositionMethod(method) ? 1 : 0;
        }

        private boolean isPositionMethod(Method method) {
            String methodName = method.getName();
            return Arrays.asList("change", "column", "row", "value").contains(methodName) || methodName.startsWith("changeOf") || methodName.startsWith("rowAt") || methodName.startsWith("of");
        }
    }
}

