/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apdplat.word.segmentation.PartOfSpeech;

public class Word
implements Comparable {
    private String text;
    private String acronymPinYin;
    private String fullPinYin;
    private PartOfSpeech partOfSpeech = null;
    private int frequency;
    private List<Word> synonym = null;
    private List<Word> antonym = null;
    private Float weight;

    public Word(String string) {
        this.text = string;
    }

    public Word(String string, PartOfSpeech partOfSpeech, int n) {
        this.text = string;
        this.partOfSpeech = partOfSpeech;
        this.frequency = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getAcronymPinYin() {
        if (this.acronymPinYin == null) {
            return "";
        }
        return this.acronymPinYin;
    }

    public void setAcronymPinYin(String string) {
        this.acronymPinYin = string;
    }

    public String getFullPinYin() {
        if (this.fullPinYin == null) {
            return "";
        }
        return this.fullPinYin;
    }

    public void setFullPinYin(String string) {
        this.fullPinYin = string;
    }

    public PartOfSpeech getPartOfSpeech() {
        return this.partOfSpeech;
    }

    public void setPartOfSpeech(PartOfSpeech partOfSpeech) {
        this.partOfSpeech = partOfSpeech;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int n) {
        this.frequency = n;
    }

    public List<Word> getSynonym() {
        if (this.synonym == null) {
            return Collections.emptyList();
        }
        return this.synonym;
    }

    public void setSynonym(List<Word> list) {
        if (list != null) {
            Collections.sort(list);
            this.synonym = list;
        }
    }

    public List<Word> getAntonym() {
        if (this.antonym == null) {
            return Collections.emptyList();
        }
        return this.antonym;
    }

    public void setAntonym(List<Word> list) {
        if (list != null) {
            Collections.sort(list);
            this.antonym = list;
        }
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(Float f) {
        this.weight = f;
    }

    public int hashCode() {
        return Objects.hashCode(this.text);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Word word = (Word)object;
        return Objects.equals(this.text, word.text);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.text != null) {
            stringBuilder.append(this.text);
        }
        if (this.acronymPinYin != null) {
            stringBuilder.append(" ").append(this.acronymPinYin);
        }
        if (this.fullPinYin != null) {
            stringBuilder.append(" ").append(this.fullPinYin);
        }
        if (this.partOfSpeech != null) {
            stringBuilder.append("/").append(this.partOfSpeech.getPos());
        }
        if (this.frequency > 0) {
            stringBuilder.append("/").append(this.frequency);
        }
        if (this.synonym != null) {
            stringBuilder.append(this.synonym.toString());
        }
        if (this.antonym != null) {
            stringBuilder.append(this.antonym.toString());
        }
        return stringBuilder.toString();
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        if (this.text == null) {
            return -1;
        }
        if (object == null) {
            return 1;
        }
        if (!(object instanceof Word)) {
            return 1;
        }
        String string = ((Word)object).getText();
        if (string == null) {
            return 1;
        }
        return this.text.compareTo(string);
    }
}

