/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.elasticsearch;

import org.apdplat.word.lucene.ChineseWordAnalyzer;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.settings.IndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseWordAnalyzerProvider
extends AbstractIndexAnalyzerProvider<ChineseWordAnalyzer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChineseWordAnalyzerProvider.class);
    private final ChineseWordAnalyzer analyzer;

    @Inject
    public ChineseWordAnalyzerProvider(Index index, @IndexSettings Settings settings, Environment environment, @Assisted String string, @Assisted Settings settings2) {
        super(index, settings, string, settings2);
        String string2 = settings2.get("segAlgorithm");
        if (string2 != null) {
            LOGGER.info("analyzer\u4f7f\u7528\u6307\u5b9a\u5206\u8bcd\u7b97\u6cd5\uff1a" + string2);
            Segmentation segmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.valueOf(string2));
            this.analyzer = new ChineseWordAnalyzer(segmentation);
        } else {
            LOGGER.info("\u6ca1\u6709\u4e3aword analyzer\u6307\u5b9asegAlgorithm\u53c2\u6570");
            LOGGER.info("analyzer\u4f7f\u7528\u9ed8\u8ba4\u5206\u8bcd\u7b97\u6cd5\uff1a" + (Object)((Object)SegmentationAlgorithm.BidirectionalMaximumMatching));
            this.analyzer = new ChineseWordAnalyzer();
        }
    }

    public ChineseWordAnalyzer get() {
        return this.analyzer;
    }
}

