/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.analysis;

import java.util.List;
import org.apdplat.word.analysis.TextSimilarity;
import org.apdplat.word.segmentation.Word;

public class JaroDistanceTextSimilarity
extends TextSimilarity {
    protected String shorterText = null;
    protected String longerText = null;

    @Override
    protected double scoreImpl(List<Word> list, List<Word> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        list.forEach(word -> stringBuilder.append(word.getText()));
        StringBuilder stringBuilder2 = new StringBuilder();
        list2.forEach(word -> stringBuilder2.append(word.getText()));
        double d = this.jaroDistance(stringBuilder.toString(), stringBuilder2.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6587\u672c1\uff1a" + stringBuilder.toString());
            LOGGER.debug("\u6587\u672c2\uff1a" + stringBuilder2.toString());
            LOGGER.debug("\u6587\u672c1\u548c\u6587\u672c2\u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d);
        }
        return d;
    }

    private double jaroDistance(String string, String string2) {
        this.shorterText = string.toLowerCase();
        this.longerText = string2.toLowerCase();
        if (this.shorterText.length() > this.longerText.length()) {
            String string3 = this.shorterText;
            this.shorterText = this.longerText;
            this.longerText = string3;
        }
        int n = this.shorterText.length() / 2 - 1;
        String string4 = this.getCharacterConjunction(this.shorterText, this.longerText, n);
        String string5 = this.getCharacterConjunction(this.longerText, this.shorterText, n);
        if (string4.length() == 0 || string5.length() == 0) {
            return 0.0;
        }
        if (string4.length() != string5.length()) {
            return 0.0;
        }
        int n2 = string4.length();
        int n3 = this.transpositions(string4, string5);
        int n4 = n3 / 2;
        double d = ((double)n2 / (double)this.shorterText.length() + (double)n2 / (double)this.longerText.length() + (double)(n2 - n4) / (double)n2) / 3.0;
        return d;
    }

    private String getCharacterConjunction(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(string2);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            int n3 = Math.max(0, i - n);
            int n4 = Math.min(i + n, string2.length());
            for (int j = n3; !bl && j < n4; ++j) {
                if (c != stringBuilder2.charAt(j)) continue;
                bl = true;
                stringBuilder.append(c);
                stringBuilder2.setCharAt(j, '*');
            }
        }
        return stringBuilder.toString();
    }

    private int transpositions(String string, String string2) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        String string = "\u6211\u7231\u8d2d\u7269";
        String string2 = "\u6211\u7231\u8bfb\u4e66";
        String string3 = "\u4ed6\u662f\u9ed1\u5ba2";
        JaroDistanceTextSimilarity jaroDistanceTextSimilarity = new JaroDistanceTextSimilarity();
        double d = jaroDistanceTextSimilarity.similarScore(string, string);
        double d2 = jaroDistanceTextSimilarity.similarScore(string, string2);
        double d3 = jaroDistanceTextSimilarity.similarScore(string, string3);
        double d4 = jaroDistanceTextSimilarity.similarScore(string2, string2);
        double d5 = jaroDistanceTextSimilarity.similarScore(string2, string3);
        double d6 = jaroDistanceTextSimilarity.similarScore(string3, string3);
        System.out.println(string + " \u548c " + string + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d);
        System.out.println(string + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d2);
        System.out.println(string + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d3);
        System.out.println(string2 + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d4);
        System.out.println(string2 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d5);
        System.out.println(string3 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d6);
    }
}

