/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TransactionContext;
import org.apache.tephra.TransactionFailureException;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.distributed.TransactionServiceClient;
import org.apache.tephra.hbase.TransactionAwareHTable;

public class SecondaryIndexTable
implements Closeable {
    private byte[] secondaryIndex;
    private TransactionAwareHTable transactionAwareHTable;
    private TransactionAwareHTable secondaryIndexTable;
    private TransactionContext transactionContext;
    private final TableName secondaryIndexTableName;
    private Connection connection;
    private static final byte[] secondaryIndexFamily = Bytes.toBytes((String)"secondaryIndexFamily");
    private static final byte[] secondaryIndexQualifier = Bytes.toBytes((int)114);
    private static final byte[] DELIMITER = new byte[]{0};

    public SecondaryIndexTable(TransactionServiceClient transactionServiceClient, Table table, byte[] secondaryIndex) throws IOException {
        this.secondaryIndexTableName = TableName.valueOf((String)(table.getName().getNameAsString() + ".idx"));
        this.connection = ConnectionFactory.createConnection((Configuration)table.getConfiguration());
        Table secondaryIndexHTable = null;
        try (Admin hBaseAdmin = this.connection.getAdmin();){
            if (!hBaseAdmin.tableExists(this.secondaryIndexTableName)) {
                hBaseAdmin.createTable(TableDescriptorBuilder.newBuilder((TableName)this.secondaryIndexTableName).build());
            }
            secondaryIndexHTable = this.connection.getTable(this.secondaryIndexTableName);
        }
        catch (Exception e) {
            Closeables.closeQuietly((Closeable)this.connection);
            Throwables.propagate((Throwable)e);
        }
        this.secondaryIndex = secondaryIndex;
        this.transactionAwareHTable = new TransactionAwareHTable(table);
        this.secondaryIndexTable = new TransactionAwareHTable(secondaryIndexHTable);
        this.transactionContext = new TransactionContext((TransactionSystemClient)transactionServiceClient, new TransactionAware[]{this.transactionAwareHTable, this.secondaryIndexTable});
    }

    public Result get(Get get) throws IOException {
        return this.get(Collections.singletonList(get))[0];
    }

    public Result[] get(List<Get> gets) throws IOException {
        try {
            this.transactionContext.start();
            Result[] result = this.transactionAwareHTable.get(gets);
            this.transactionContext.finish();
            return result;
        }
        catch (Exception e) {
            try {
                this.transactionContext.abort();
            }
            catch (TransactionFailureException e1) {
                throw new IOException("Could not rollback transaction", e1);
            }
            return null;
        }
    }

    public Result[] getByIndex(byte[] value) throws IOException {
        try {
            this.transactionContext.start();
            Scan scan = new Scan(value, Bytes.add((byte[])value, (byte[])new byte[0]));
            scan.addColumn(secondaryIndexFamily, secondaryIndexQualifier);
            ResultScanner indexScanner = this.secondaryIndexTable.getScanner(scan);
            ArrayList<Get> gets = new ArrayList<Get>();
            for (Result result : indexScanner) {
                for (Cell cell : result.listCells()) {
                    gets.add(new Get(CellUtil.cloneValue((Cell)cell)));
                }
            }
            Result[] results = this.transactionAwareHTable.get(gets);
            this.transactionContext.finish();
            return results;
        }
        catch (Exception e) {
            try {
                this.transactionContext.abort();
            }
            catch (TransactionFailureException e1) {
                throw new IOException("Could not rollback transaction", e1);
            }
            return null;
        }
    }

    public void put(Put put) throws IOException {
        this.put(Collections.singletonList(put));
    }

    public void put(List<Put> puts) throws IOException {
        try {
            this.transactionContext.start();
            ArrayList<Put> secondaryIndexPuts = new ArrayList<Put>();
            for (Put put : puts) {
                ArrayList<Put> indexPuts = new ArrayList<Put>();
                Set familyMap = put.getFamilyCellMap().entrySet();
                for (Map.Entry family : familyMap) {
                    for (Cell value : (List)family.getValue()) {
                        if (!Bytes.equals((byte[])value.getQualifierArray(), (int)value.getQualifierOffset(), (int)value.getQualifierLength(), (byte[])this.secondaryIndex, (int)0, (int)this.secondaryIndex.length)) continue;
                        byte[] secondaryRow = Bytes.add((byte[])CellUtil.cloneQualifier((Cell)value), (byte[])DELIMITER, (byte[])Bytes.add((byte[])CellUtil.cloneValue((Cell)value), (byte[])DELIMITER, (byte[])CellUtil.cloneRow((Cell)value)));
                        Put indexPut = new Put(secondaryRow);
                        indexPut.addColumn(secondaryIndexFamily, secondaryIndexQualifier, put.getRow());
                        indexPuts.add(indexPut);
                    }
                }
                secondaryIndexPuts.addAll(indexPuts);
            }
            this.transactionAwareHTable.put(puts);
            this.secondaryIndexTable.put(secondaryIndexPuts);
            this.transactionContext.finish();
        }
        catch (Exception e) {
            try {
                this.transactionContext.abort();
            }
            catch (TransactionFailureException e1) {
                throw new IOException("Could not rollback transaction", e1);
            }
        }
    }

    @Override
    public void close() throws IOException {
        Closeables.closeQuietly((Closeable)this.connection);
        try {
            this.transactionAwareHTable.close();
        }
        catch (IOException e) {
            try {
                this.secondaryIndexTable.close();
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        this.secondaryIndexTable.close();
    }
}

