/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.io.Serializable;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.OutputOperationUIData;
import org.apache.spark.streaming.ui.UIUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001y3a\u0001D\u0007\u0002\u000259\u0002\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\t\u0011-\u0002!\u0011!Q\u0001\n1BQa\f\u0001\u0005\u0002ABQ!\u000e\u0001\u0005\u0012YBQA\u0012\u0001\u0005\u0012\u001dCQ!\u0015\u0001\u0005\u0012ICQ!\u0016\u0001\u0005\u0012YCQ\u0001\u0017\u0001\u0005\nYBQ!\u0017\u0001\u0005\u0002YBQA\u0017\u0001\u0005\u0012mCQ!\u0018\u0001\u0007\u0012Y\u0012aBQ1uG\"$\u0016M\u00197f\u0005\u0006\u001cXM\u0003\u0002\u000f\u001f\u0005\u0011Q/\u001b\u0006\u0003!E\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005I\u0019\u0012!B:qCJ\\'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u001d!\u0018M\u00197f\u0013\u0012\u001c\u0001\u0001\u0005\u0002\"Q9\u0011!E\n\t\u0003Gii\u0011\u0001\n\u0006\u0003K}\ta\u0001\u0010:p_Rt\u0014BA\u0014\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011F\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001dR\u0012!\u00042bi\u000eD\u0017J\u001c;feZ\fG\u000e\u0005\u0002\u001a[%\u0011aF\u0007\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0004cM\"\u0004C\u0001\u001a\u0001\u001b\u0005i\u0001\"\u0002\u0010\u0004\u0001\u0004\u0001\u0003\"B\u0016\u0004\u0001\u0004a\u0013aB2pYVlgn]\u000b\u0002oA\u0019\u0001(\u0010!\u000f\u0005eZdBA\u0012;\u0013\u0005Y\u0012B\u0001\u001f\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\u0007M+\u0017O\u0003\u0002=5A\u0011\u0011\tR\u0007\u0002\u0005*\u00111IG\u0001\u0004q6d\u0017BA#C\u0005\u0011qu\u000eZ3\u0002+\u001d,GOR5sgR4\u0015-\u001b7ve\u0016\u0014V-Y:p]R\u0011\u0001j\u0013\t\u00043%\u0003\u0013B\u0001&\u001b\u0005\u0019y\u0005\u000f^5p]\")A*\u0002a\u0001\u001b\u00069!-\u0019;dQ\u0016\u001c\bc\u0001\u001d>\u001dB\u0011!gT\u0005\u0003!6\u00111BQ1uG\",\u0016\nR1uC\u0006Ar-\u001a;GSJ\u001cHOR1jYV\u0014X\rV1cY\u0016\u001cU\r\u001c7\u0015\u0005]\u001a\u0006\"\u0002+\u0007\u0001\u0004q\u0015!\u00022bi\u000eD\u0017a\u00022bg\u0016\u0014vn\u001e\u000b\u0003o]CQ\u0001V\u0004A\u00029\u000b!BY1uG\"$\u0016M\u00197f\u0003%!xNT8eKN+\u0017/\u0001\u0011de\u0016\fG/Z(viB,Ho\u00149fe\u0006$\u0018n\u001c8Qe><'/Z:t\u0005\u0006\u0014HCA\u001c]\u0011\u0015!&\u00021\u0001O\u0003)\u0011XM\u001c3feJ{wo\u001d")
public abstract class BatchTableBase {
    private final String tableId;
    private final long batchInterval;

    /*
     * WARNING - void declaration
     */
    public Seq<Node> columns() {
        void var1_1;
        void var3_3;
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Batch Time"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Records"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Scheduling Delay\n        "));
        $buf4.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken by Streaming scheduler to submit jobs of a batch", "top"));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Processing Time\n        "));
        $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken to process all jobs of a batch", "top"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        return var1_1;
    }

    public Option<String> getFirstFailureReason(Seq<BatchUIData> batches) {
        return ((TraversableLike)batches.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Iterable)x$1.outputOperations().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(((OutputOperationUIData)x$2._2()).failureReason()), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).headOption();
    }

    public Seq<Node> getFirstFailureTableCell(BatchUIData batch) {
        Option firstFailureReason = ((TraversableLike)batch.outputOperations().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(((OutputOperationUIData)x$3._2()).failureReason()), Iterable$.MODULE$.canBuildFrom())).headOption();
        return (Seq)firstFailureReason.map((Function1 & Serializable & scala.Serializable)failureReason -> {
            String failureReasonForUI = UIUtils$.MODULE$.createOutputOperationFailureForUI((String)failureReason);
            return UIUtils$.MODULE$.failureReasonCell(failureReasonForUI, 1, false);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var0;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("-"));
            return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var0);
        });
    }

    public Seq<Node> baseRow(BatchUIData batch) {
        long batchTime = batch.batchTime().milliseconds();
        String formattedBatchTime = UIUtils$.MODULE$.formatBatchTime(batchTime, this.batchInterval, UIUtils$.MODULE$.formatBatchTime$default$3(), UIUtils$.MODULE$.formatBatchTime$default$4());
        long numRecords = batch.numRecords();
        Option<Object> schedulingDelay = batch.schedulingDelay();
        String formattedSchedulingDelay = (String)schedulingDelay.map((Function1 & Serializable & scala.Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
        Option<Object> processingTime = batch.processingDelay();
        String formattedProcessingTime = (String)processingTime.map((Function1 & Serializable & scala.Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
        String batchTimeId = new StringBuilder(6).append("batch-").append(batchTime).toString();
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("isFailed", ((Object)BoxesRunTime.boxToBoolean((boolean)batch.isFailed())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("sorttable_customkey", ((Object)BoxesRunTime.boxToLong((long)batchTime)).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("id", batchTimeId, (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("href", new StringBuilder(9).append("batch?id=").append(batchTime).toString(), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)formattedBatchTime);
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("sorttable_customkey", ((Object)BoxesRunTime.boxToLong((long)numRecords)).toString(), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)((Object)BoxesRunTime.boxToLong((long)numRecords)).toString());
        $buf4.$amp$plus((Object)new Text(" records"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("sorttable_customkey", schedulingDelay.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE).toString(), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)formattedSchedulingDelay);
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("sorttable_customkey", processingTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE).toString(), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)formattedProcessingTime);
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        return $buf;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> batchTable() {
        void var2_2;
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered table-striped table-condensed sortable"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", this.tableId, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.columns());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(this.renderRows());
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public Seq<Node> toNodeSeq() {
        return this.batchTable();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> createOutputOperationProgressBar(BatchUIData batch) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("progress-cell"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.makeProgressBar(batch.numActiveOutputOp(), batch.numCompletedOutputOp(), batch.numFailedOutputOp(), 0, Predef$.MODULE$.Map().empty(), batch.outputOperations().size()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    public abstract Seq<Node> renderRows();

    public BatchTableBase(String tableId, long batchInterval) {
        this.tableId = tableId;
        this.batchInterval = batchInterval;
    }
}

