/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.DStreamGraph;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-c!B\n\u0015\u0001Yq\u0002\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011}\u0002!1!Q\u0001\f\u0001CQA\u0012\u0001\u0005\u0002\u001dCq\u0001\u0014\u0001C\u0002\u0013EQ\n\u0003\u0004[\u0001\u0001\u0006IA\u0014\u0005\b7\u0002\u0001\r\u0011\"\u0003]\u0011\u001dI\u0007\u00011A\u0005\n)Da\u0001\u001d\u0001!B\u0013i\u0006bB;\u0001\u0001\u0004%IA\u001e\u0005\bq\u0002\u0001\r\u0011\"\u0003z\u0011\u0019Y\b\u0001)Q\u0005o\"1Q\u0010\u0001C\t-qCQA \u0001\u0005\u0002}Dq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\u001e\u0001\u0011%\u0011Q\b\u0002\u0016\tN#(/Z1n\u0007\",7m\u001b9pS:$H)\u0019;b\u0015\t)b#A\u0004egR\u0014X-Y7\u000b\u0005]A\u0012!C:ue\u0016\fW.\u001b8h\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<WCA\u00107'\u0011\u0001\u0001EJ\u0015\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t\ts%\u0003\u0002)E\ta1+\u001a:jC2L'0\u00192mKB\u0011!&L\u0007\u0002W)\u0011A\u0006G\u0001\tS:$XM\u001d8bY&\u0011af\u000b\u0002\b\u0019><w-\u001b8h\u0007\u0001\u00012!\r\u001a5\u001b\u0005!\u0012BA\u001a\u0015\u0005\u001d!5\u000b\u001e:fC6\u0004\"!\u000e\u001c\r\u0001\u0011)q\u0007\u0001b\u0001q\t\tA+\u0005\u0002:yA\u0011\u0011EO\u0005\u0003w\t\u0012qAT8uQ&tw\r\u0005\u0002\"{%\u0011aH\t\u0002\u0004\u0003:L\u0018AC3wS\u0012,gnY3%cA\u0019\u0011\t\u0012\u001b\u000e\u0003\tS!a\u0011\u0012\u0002\u000fI,g\r\\3di&\u0011QI\u0011\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"\"\u0001S&\u0015\u0005%S\u0005cA\u0019\u0001i!)qh\u0001a\u0002\u0001\")Qc\u0001a\u0001a\u0005!A-\u0019;b+\u0005q\u0005\u0003B(U-\u0002j\u0011\u0001\u0015\u0006\u0003#J\u000bq!\\;uC\ndWM\u0003\u0002TE\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0003&a\u0002%bg\"l\u0015\r\u001d\t\u0003/bk\u0011AF\u0005\u00033Z\u0011A\u0001V5nK\u0006)A-\u0019;bA\u0005!B/[7f)>\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016,\u0012!\u0018\t\u0005\u001fR3f\f\u0005\u0002`M:\u0011\u0001\r\u001a\t\u0003C\nj\u0011A\u0019\u0006\u0003G>\na\u0001\u0010:p_Rt\u0014BA3#\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\u0014\u0013\u0001\u0007;j[\u0016$vn\u00115fG.\u0004x.\u001b8u\r&dWm\u0018\u0013fcR\u00111N\u001c\t\u0003C1L!!\u001c\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b_\u001e\t\t\u00111\u0001^\u0003\rAH%M\u0001\u0016i&lW\rV8DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3!Q\tA!\u000f\u0005\u0002\"g&\u0011AO\t\u0002\niJ\fgn]5f]R\fa\u0004^5nKR{w\n\u001c3fgR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$\u0016.\\3\u0016\u0003]\u0004Ba\u0014+W-\u0006\u0011C/[7f)>|E\u000eZ3ti\u000eCWmY6q_&tGOR5mKRKW.Z0%KF$\"a\u001b>\t\u000f=T\u0011\u0011!a\u0001o\u0006yB/[7f)>|E\u000eZ3ti\u000eCWmY6q_&tGOR5mKRKW.\u001a\u0011)\u0005-\u0011\u0018AF2veJ,g\u000e^\"iK\u000e\\\u0007o\\5oi\u001aKG.Z:\u0002\rU\u0004H-\u0019;f)\rY\u0017\u0011\u0001\u0005\u0007\u0003\u0007i\u0001\u0019\u0001,\u0002\tQLW.Z\u0001\bG2,\u0017M\\;q)\rY\u0017\u0011\u0002\u0005\u0007\u0003\u0007q\u0001\u0019\u0001,\u0002\u000fI,7\u000f^8sKR\t1.\u0001\u0005u_N#(/\u001b8h)\u0005q\u0016aC<sSR,wJ\u00196fGR$2a[A\f\u0011\u001d\tI\"\u0005a\u0001\u00037\t1a\\8t!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!![8\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002 \t\u0011rJ\u00196fGR|U\u000f\u001e9viN#(/Z1nQ\u0015\t\u0012QFA\u001d!\u0015\t\u0013qFA\u001a\u0013\r\t\tD\t\u0002\u0007i\"\u0014xn^:\u0011\t\u0005u\u0011QG\u0005\u0005\u0003o\tyBA\u0006J\u001f\u0016C8-\u001a9uS>t7EAA\u001a\u0003)\u0011X-\u00193PE*,7\r\u001e\u000b\u0004W\u0006}\u0002bBA!%\u0001\u0007\u00111I\u0001\u0004_&\u001c\b\u0003BA\u000f\u0003\u000bJA!a\u0012\u0002 \t\trJ\u00196fGRLe\u000e];u'R\u0014X-Y7)\u000bI\ti#!\u000f")
public class DStreamCheckpointData<T>
implements scala.Serializable,
Logging {
    private final DStream<T> dstream;
    private final ClassTag<T> evidence$1;
    private final HashMap<Time, Object> data;
    private transient HashMap<Time, String> timeToCheckpointFile;
    private transient HashMap<Time, Time> timeToOldestCheckpointFileTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public HashMap<Time, Object> data() {
        return this.data;
    }

    private HashMap<Time, String> timeToCheckpointFile() {
        return this.timeToCheckpointFile;
    }

    private void timeToCheckpointFile_$eq(HashMap<Time, String> x$1) {
        this.timeToCheckpointFile = x$1;
    }

    private HashMap<Time, Time> timeToOldestCheckpointFileTime() {
        return this.timeToOldestCheckpointFileTime;
    }

    private void timeToOldestCheckpointFileTime_$eq(HashMap<Time, Time> x$1) {
        this.timeToOldestCheckpointFileTime = x$1;
    }

    public HashMap<Time, String> currentCheckpointFiles() {
        return this.data();
    }

    public void update(Time time) {
        block0: {
            HashMap checkpointFiles = (HashMap)((TraversableLike)this.dstream.generatedRDDs().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DStreamCheckpointData.$anonfun$update$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x._1(), ((RDD)x._2()).getCheckpointFile().get()), HashMap$.MODULE$.canBuildFrom());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Current checkpoint files:\n").append(checkpointFiles.toSeq().mkString("\n")).toString());
            if (checkpointFiles.isEmpty()) break block0;
            this.currentCheckpointFiles().clear();
            this.currentCheckpointFiles().$plus$plus$eq((TraversableOnce)checkpointFiles);
            this.timeToCheckpointFile().$plus$plus$eq(this.currentCheckpointFiles());
            this.timeToOldestCheckpointFileTime().update((Object)time, this.currentCheckpointFiles().keys().min(Time$.MODULE$.ordering()));
        }
    }

    public void cleanup(Time time) {
        Option option = this.timeToOldestCheckpointFileTime().remove((Object)time);
        if (option instanceof Some) {
            Some some = (Some)option;
            Time lastCheckpointFileTime = (Time)some.value();
            HashMap filesToDelete = (HashMap)this.timeToCheckpointFile().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DStreamCheckpointData.$anonfun$cleanup$1(lastCheckpointFileTime, x$2)));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Files to delete:\n").append(filesToDelete.mkString(",")).toString());
            ObjectRef fileSystem = ObjectRef.create(null);
            filesToDelete.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DStreamCheckpointData.$anonfun$cleanup$3(this, fileSystem, x0$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Nothing to delete");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void restore() {
        this.currentCheckpointFiles().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Time time = (Time)tuple2._1();
            String file = (String)tuple2._2();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Restoring checkpointed RDD for time ").append(time).append(" from file '").append(file).append("'").toString());
            HashMap hashMap = $this.dstream.generatedRDDs().$plus$eq(new Tuple2((Object)time, (Object)$this.dstream.context().sparkContext().checkpointFile(file, $this.evidence$1)));
            return hashMap;
        });
    }

    public String toString() {
        return new StringBuilder(23).append("[\n").append(this.currentCheckpointFiles().size()).append(" checkpoint files \n").append(this.currentCheckpointFiles().mkString("\n")).append("\n]").toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append(this.getClass().getSimpleName()).append(".writeObject used").toString());
            if ($this.dstream.context().graph() != null) {
                DStreamGraph dStreamGraph = $this.dstream.context().graph();
                synchronized (dStreamGraph) {
                    if (!$this.dstream.context().graph().checkpointInProgress()) {
                        String msg = new StringBuilder(317).append("Object of ").append(this.getClass().getName()).append(" is being serialized ").append(" possibly as a part of closure of an RDD operation. This is because ").append(" the DStream object is being referred to from within the closure. ").append(" Please rewrite the RDD operation inside this DStream to avoid this. ").append(" This has been enforced to avoid bloating of Spark tasks ").append(" with unnecessary objects.").toString();
                        throw new NotSerializableException(msg);
                    }
                    oos.defaultWriteObject();
                }
            } else {
                throw new NotSerializableException("Graph is unexpectedly null when DStream is being serialized.");
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(this.getClass().getSimpleName()).append(".readObject used").toString());
            ois.defaultReadObject();
            this.timeToOldestCheckpointFileTime_$eq((HashMap<Time, Time>)new HashMap());
            this.timeToCheckpointFile_$eq((HashMap<Time, String>)new HashMap());
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$1(Tuple2 x$1) {
        return ((RDD)x$1._2()).getCheckpointFile().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$cleanup$1(Time lastCheckpointFileTime$1, Tuple2 x$2) {
        return ((Time)x$2._1()).$less(lastCheckpointFileTime$1);
    }

    public static final /* synthetic */ void $anonfun$cleanup$3(DStreamCheckpointData $this, ObjectRef fileSystem$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Time time = (Time)tuple2._1();
            String file = (String)tuple2._2();
            try {
                Path path = new Path(file);
                if ((FileSystem)fileSystem$1.elem == null) {
                    fileSystem$1.elem = path.getFileSystem($this.dstream.ssc().sparkContext().hadoopConfiguration());
                }
                ((FileSystem)fileSystem$1.elem).delete(path, true);
                $this.timeToCheckpointFile().$minus$eq((Object)time);
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleted checkpoint file '").append(file).append("' for time ").append(time).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Error deleting old checkpoint file '").append(file).append("' for time ").append(time).toString(), e);
                fileSystem$1.elem = null;
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public DStreamCheckpointData(DStream<T> dstream, ClassTag<T> evidence$1) {
        this.dstream = dstream;
        this.evidence$1 = evidence$1;
        Logging.$init$((Logging)this);
        this.data = new HashMap();
        this.timeToCheckpointFile = new HashMap();
        this.timeToOldestCheckpointFileTime = new HashMap();
    }
}

